#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Jan 23 16:15:29 2017 by generateDS.py version 2.24b.
#
# Command line options:
#   ('-o', 'nml.py')
#   ('-f', '')
#   ('--use-getter-setter', 'none')
#   ('--silence', '')
#   ('--user-methods', 'helper_methods')
#
# Command line arguments:
#   NeuroML_v2beta5.xsd
#
# Command line:
#   /usr/local/bin/generateDS.py -o "nml.py" -f --use-getter-setter="none" --silence --user-methods="helper_methods" NeuroML_v2beta5.xsd
#
# Current working directory (os.getcwd()):
#   nml
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info[0] == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info[0] == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring

    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name, pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class Property(GeneratedsSuper):
    """Generic property with a tag and value"""
    member_data_items_ = [
        MemberSpec_('tag', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, tag=None, value=None):
        self.original_tagname_ = None
        self.tag = _cast(None, tag)
        self.value = _cast(None, value)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Property)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Property.subclass:
            return Property.subclass(*args_, **kwargs_)
        else:
            return Property(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Property', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Property')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Property', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Property'):
        if self.tag is not None and 'tag' not in already_processed:
            already_processed.add('tag')
            outfile.write(' tag=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.tag), input_name='tag')), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Property', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tag', node)
        if value is not None and 'tag' not in already_processed:
            already_processed.add('tag')
            self.tag = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Property


class Annotation(GeneratedsSuper):
    """Placeholder for MIRIAM related metadata, among others."""
    member_data_items_ = [
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, anytypeobjs_=None):
        self.original_tagname_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Annotation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Annotation.subclass:
            return Annotation.subclass(*args_, **kwargs_)
        else:
            return Annotation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Annotation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Annotation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Annotation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Annotation'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Annotation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'Annotation')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class Annotation


class ComponentType(GeneratedsSuper):
    """Contains an extension to NeuroML by creating custom LEMS
    ComponentType."""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('extends', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('Parameter', 'Parameter', 1),
        MemberSpec_('Constant', 'Constant', 1),
        MemberSpec_('Requirement', 'Requirement', 1),
        MemberSpec_('Dynamics', 'Dynamics', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, extends=None, description=None, Parameter=None, Constant=None, Requirement=None, Dynamics=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.extends = _cast(None, extends)
        self.description = _cast(None, description)
        if Parameter is None:
            self.Parameter = []
        else:
            self.Parameter = Parameter
        if Constant is None:
            self.Constant = []
        else:
            self.Constant = Constant
        if Requirement is None:
            self.Requirement = []
        else:
            self.Requirement = Requirement
        if Dynamics is None:
            self.Dynamics = []
        else:
            self.Dynamics = Dynamics
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ComponentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ComponentType.subclass:
            return ComponentType.subclass(*args_, **kwargs_)
        else:
            return ComponentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.Parameter or
            self.Constant or
            self.Requirement or
            self.Dynamics
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ComponentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ComponentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ComponentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ComponentType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.extends is not None and 'extends' not in already_processed:
            already_processed.add('extends')
            outfile.write(' extends=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.extends), input_name='extends')), ))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            outfile.write(' description=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.description), input_name='description')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ComponentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Parameter_ in self.Parameter:
            Parameter_.export(outfile, level, namespace_, name_='Parameter', pretty_print=pretty_print)
        for Constant_ in self.Constant:
            Constant_.export(outfile, level, namespace_, name_='Constant', pretty_print=pretty_print)
        for Requirement_ in self.Requirement:
            Requirement_.export(outfile, level, namespace_, name_='Requirement', pretty_print=pretty_print)
        for Dynamics_ in self.Dynamics:
            Dynamics_.export(outfile, level, namespace_, name_='Dynamics', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('extends', node)
        if value is not None and 'extends' not in already_processed:
            already_processed.add('extends')
            self.extends = value
        value = find_attr_value_('description', node)
        if value is not None and 'description' not in already_processed:
            already_processed.add('description')
            self.description = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Parameter':
            obj_ = Parameter.factory()
            obj_.build(child_)
            self.Parameter.append(obj_)
            obj_.original_tagname_ = 'Parameter'
        elif nodeName_ == 'Constant':
            obj_ = Constant.factory()
            obj_.build(child_)
            self.Constant.append(obj_)
            obj_.original_tagname_ = 'Constant'
        elif nodeName_ == 'Requirement':
            obj_ = Requirement.factory()
            obj_.build(child_)
            self.Requirement.append(obj_)
            obj_.original_tagname_ = 'Requirement'
        elif nodeName_ == 'Dynamics':
            obj_ = Dynamics.factory()
            obj_.build(child_)
            self.Dynamics.append(obj_)
            obj_.original_tagname_ = 'Dynamics'
# end class ComponentType


class Constant(GeneratedsSuper):
    """LEMS ComponentType for Constant."""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('dimension', 'xs:string', 0),
        MemberSpec_('value', 'Nml2Quantity', 0),
        MemberSpec_('description', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, dimension=None, value=None, description=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.value = _cast(None, value)
        self.description = _cast(None, description)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Constant)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Constant.subclass:
            return Constant.subclass(*args_, **kwargs_)
        else:
            return Constant(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity(self, value):
        # Validate type Nml2Quantity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_patterns_, ))
    validate_Nml2Quantity_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*([_a-zA-Z0-9])*$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Constant', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Constant')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Constant', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Constant'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.dimension is not None and 'dimension' not in already_processed:
            already_processed.add('dimension')
            outfile.write(' dimension=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dimension), input_name='dimension')), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            outfile.write(' description=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.description), input_name='description')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Constant', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('dimension', node)
        if value is not None and 'dimension' not in already_processed:
            already_processed.add('dimension')
            self.dimension = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_Nml2Quantity(self.value)    # validate type Nml2Quantity
        value = find_attr_value_('description', node)
        if value is not None and 'description' not in already_processed:
            already_processed.add('description')
            self.description = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Constant


class NamedDimensionalType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('dimension', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, dimension='none', description=None, extensiontype_=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.description = _cast(None, description)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NamedDimensionalType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedDimensionalType.subclass:
            return NamedDimensionalType.subclass(*args_, **kwargs_)
        else:
            return NamedDimensionalType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NamedDimensionalType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NamedDimensionalType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NamedDimensionalType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NamedDimensionalType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.dimension != "none" and 'dimension' not in already_processed:
            already_processed.add('dimension')
            outfile.write(' dimension=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dimension), input_name='dimension')), ))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            outfile.write(' description=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.description), input_name='description')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='NamedDimensionalType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('dimension', node)
        if value is not None and 'dimension' not in already_processed:
            already_processed.add('dimension')
            self.dimension = value
        value = find_attr_value_('description', node)
        if value is not None and 'description' not in already_processed:
            already_processed.add('description')
            self.description = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class NamedDimensionalType


class Parameter(NamedDimensionalType):
    member_data_items_ = [
    ]
    subclass = None
    superclass = NamedDimensionalType
    def __init__(self, name=None, dimension='none', description=None):
        self.original_tagname_ = None
        super(Parameter, self).__init__(name, dimension, description, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Parameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Parameter.subclass:
            return Parameter.subclass(*args_, **kwargs_)
        else:
            return Parameter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(Parameter, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Parameter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Parameter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Parameter', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Parameter'):
        super(Parameter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Parameter')
    def exportChildren(self, outfile, level, namespace_='', name_='Parameter', fromsubclass_=False, pretty_print=True):
        super(Parameter, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Parameter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Parameter, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Parameter


class Requirement(NamedDimensionalType):
    member_data_items_ = [
    ]
    subclass = None
    superclass = NamedDimensionalType
    def __init__(self, name=None, dimension='none', description=None):
        self.original_tagname_ = None
        super(Requirement, self).__init__(name, dimension, description, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Requirement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Requirement.subclass:
            return Requirement.subclass(*args_, **kwargs_)
        else:
            return Requirement(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(Requirement, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Requirement', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Requirement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Requirement', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Requirement'):
        super(Requirement, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Requirement')
    def exportChildren(self, outfile, level, namespace_='', name_='Requirement', fromsubclass_=False, pretty_print=True):
        super(Requirement, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Requirement, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Requirement, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Requirement


class Dynamics(GeneratedsSuper):
    """LEMS ComponentType for Dynamics"""
    member_data_items_ = [
        MemberSpec_('DerivedVariable', 'DerivedVariable', 1),
        MemberSpec_('ConditionalDerivedVariable', 'ConditionalDerivedVariable', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, DerivedVariable=None, ConditionalDerivedVariable=None):
        self.original_tagname_ = None
        if DerivedVariable is None:
            self.DerivedVariable = []
        else:
            self.DerivedVariable = DerivedVariable
        if ConditionalDerivedVariable is None:
            self.ConditionalDerivedVariable = []
        else:
            self.ConditionalDerivedVariable = ConditionalDerivedVariable
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Dynamics)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Dynamics.subclass:
            return Dynamics.subclass(*args_, **kwargs_)
        else:
            return Dynamics(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.DerivedVariable or
            self.ConditionalDerivedVariable
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Dynamics', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Dynamics')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Dynamics', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Dynamics'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Dynamics', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DerivedVariable_ in self.DerivedVariable:
            DerivedVariable_.export(outfile, level, namespace_, name_='DerivedVariable', pretty_print=pretty_print)
        for ConditionalDerivedVariable_ in self.ConditionalDerivedVariable:
            ConditionalDerivedVariable_.export(outfile, level, namespace_, name_='ConditionalDerivedVariable', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'DerivedVariable':
            obj_ = DerivedVariable.factory()
            obj_.build(child_)
            self.DerivedVariable.append(obj_)
            obj_.original_tagname_ = 'DerivedVariable'
        elif nodeName_ == 'ConditionalDerivedVariable':
            obj_ = ConditionalDerivedVariable.factory()
            obj_.build(child_)
            self.ConditionalDerivedVariable.append(obj_)
            obj_.original_tagname_ = 'ConditionalDerivedVariable'
# end class Dynamics


class DerivedVariable(GeneratedsSuper):
    """LEMS ComponentType for DerivedVariable"""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('dimension', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
        MemberSpec_('exposure', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, dimension=None, value=None, exposure=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.value = _cast(None, value)
        self.exposure = _cast(None, exposure)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DerivedVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DerivedVariable.subclass:
            return DerivedVariable.subclass(*args_, **kwargs_)
        else:
            return DerivedVariable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DerivedVariable', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DerivedVariable')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DerivedVariable', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DerivedVariable'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.dimension is not None and 'dimension' not in already_processed:
            already_processed.add('dimension')
            outfile.write(' dimension=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dimension), input_name='dimension')), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
        if self.exposure is not None and 'exposure' not in already_processed:
            already_processed.add('exposure')
            outfile.write(' exposure=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.exposure), input_name='exposure')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DerivedVariable', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('dimension', node)
        if value is not None and 'dimension' not in already_processed:
            already_processed.add('dimension')
            self.dimension = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
        value = find_attr_value_('exposure', node)
        if value is not None and 'exposure' not in already_processed:
            already_processed.add('exposure')
            self.exposure = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DerivedVariable


class ConditionalDerivedVariable(GeneratedsSuper):
    """LEMS ComponentType for ConditionalDerivedVariable"""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('dimension', 'xs:string', 0),
        MemberSpec_('exposure', 'xs:string', 0),
        MemberSpec_('Case', 'Case', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, dimension=None, exposure=None, Case=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.dimension = _cast(None, dimension)
        self.exposure = _cast(None, exposure)
        if Case is None:
            self.Case = []
        else:
            self.Case = Case
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConditionalDerivedVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConditionalDerivedVariable.subclass:
            return ConditionalDerivedVariable.subclass(*args_, **kwargs_)
        else:
            return ConditionalDerivedVariable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.Case
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConditionalDerivedVariable', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConditionalDerivedVariable')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ConditionalDerivedVariable', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConditionalDerivedVariable'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
        if self.dimension is not None and 'dimension' not in already_processed:
            already_processed.add('dimension')
            outfile.write(' dimension=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.dimension), input_name='dimension')), ))
        if self.exposure is not None and 'exposure' not in already_processed:
            already_processed.add('exposure')
            outfile.write(' exposure=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.exposure), input_name='exposure')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConditionalDerivedVariable', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Case_ in self.Case:
            Case_.export(outfile, level, namespace_, name_='Case', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('dimension', node)
        if value is not None and 'dimension' not in already_processed:
            already_processed.add('dimension')
            self.dimension = value
        value = find_attr_value_('exposure', node)
        if value is not None and 'exposure' not in already_processed:
            already_processed.add('exposure')
            self.exposure = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Case':
            obj_ = Case.factory()
            obj_.build(child_)
            self.Case.append(obj_)
            obj_.original_tagname_ = 'Case'
# end class ConditionalDerivedVariable


class Case(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('condition', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, condition=None, value=None):
        self.original_tagname_ = None
        self.condition = _cast(None, condition)
        self.value = _cast(None, value)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Case)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Case.subclass:
            return Case.subclass(*args_, **kwargs_)
        else:
            return Case(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Case', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Case')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Case', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Case'):
        if self.condition is not None and 'condition' not in already_processed:
            already_processed.add('condition')
            outfile.write(' condition=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.condition), input_name='condition')), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Case', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('condition', node)
        if value is not None and 'condition' not in already_processed:
            already_processed.add('condition')
            self.condition = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Case


class IncludeType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('href', 'xs:anyURI', 0),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, href=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.href = _cast(None, href)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IncludeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IncludeType.subclass:
            return IncludeType.subclass(*args_, **kwargs_)
        else:
            return IncludeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            1 if type(self.valueOf_) in [int,float] else self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IncludeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IncludeType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IncludeType'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.href), input_name='href')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IncludeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class IncludeType


class Q10ConductanceScaling(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('q10Factor', 'Nml2Quantity_none', 0),
        MemberSpec_('experimentalTemp', 'Nml2Quantity_temperature', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, q10_factor=None, experimental_temp=None):
        self.original_tagname_ = None
        self.q10_factor = _cast(None, q10_factor)
        self.experimental_temp = _cast(None, experimental_temp)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Q10ConductanceScaling)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Q10ConductanceScaling.subclass:
            return Q10ConductanceScaling.subclass(*args_, **kwargs_)
        else:
            return Q10ConductanceScaling(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_temperature_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_temperature_patterns_, ))
    validate_Nml2Quantity_temperature_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC)$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Q10ConductanceScaling', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Q10ConductanceScaling')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Q10ConductanceScaling', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Q10ConductanceScaling'):
        if self.q10_factor is not None and 'q10_factor' not in already_processed:
            already_processed.add('q10_factor')
            outfile.write(' q10Factor=%s' % (quote_attrib(self.q10_factor), ))
        if self.experimental_temp is not None and 'experimental_temp' not in already_processed:
            already_processed.add('experimental_temp')
            outfile.write(' experimentalTemp=%s' % (quote_attrib(self.experimental_temp), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Q10ConductanceScaling', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('q10Factor', node)
        if value is not None and 'q10Factor' not in already_processed:
            already_processed.add('q10Factor')
            self.q10_factor = value
            self.validate_Nml2Quantity_none(self.q10_factor)    # validate type Nml2Quantity_none
        value = find_attr_value_('experimentalTemp', node)
        if value is not None and 'experimentalTemp' not in already_processed:
            already_processed.add('experimentalTemp')
            self.experimental_temp = value
            self.validate_Nml2Quantity_temperature(self.experimental_temp)    # validate type Nml2Quantity_temperature
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Q10ConductanceScaling


class Q10Settings(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'NmlId', 0),
        MemberSpec_('fixedQ10', 'Nml2Quantity_none', 0),
        MemberSpec_('q10Factor', 'Nml2Quantity_none', 0),
        MemberSpec_('experimentalTemp', 'Nml2Quantity_temperature', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type=None, fixed_q10=None, q10_factor=None, experimental_temp=None):
        self.original_tagname_ = None
        self.type = _cast(None, type)
        self.fixed_q10 = _cast(None, fixed_q10)
        self.q10_factor = _cast(None, q10_factor)
        self.experimental_temp = _cast(None, experimental_temp)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Q10Settings)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Q10Settings.subclass:
            return Q10Settings.subclass(*args_, **kwargs_)
        else:
            return Q10Settings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_temperature_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_temperature_patterns_, ))
    validate_Nml2Quantity_temperature_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC)$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Q10Settings', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Q10Settings')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Q10Settings', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Q10Settings'):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.fixed_q10 is not None and 'fixed_q10' not in already_processed:
            already_processed.add('fixed_q10')
            outfile.write(' fixedQ10=%s' % (quote_attrib(self.fixed_q10), ))
        if self.q10_factor is not None and 'q10_factor' not in already_processed:
            already_processed.add('q10_factor')
            outfile.write(' q10Factor=%s' % (quote_attrib(self.q10_factor), ))
        if self.experimental_temp is not None and 'experimental_temp' not in already_processed:
            already_processed.add('experimental_temp')
            outfile.write(' experimentalTemp=%s' % (quote_attrib(self.experimental_temp), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Q10Settings', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
        value = find_attr_value_('fixedQ10', node)
        if value is not None and 'fixedQ10' not in already_processed:
            already_processed.add('fixedQ10')
            self.fixed_q10 = value
            self.validate_Nml2Quantity_none(self.fixed_q10)    # validate type Nml2Quantity_none
        value = find_attr_value_('q10Factor', node)
        if value is not None and 'q10Factor' not in already_processed:
            already_processed.add('q10Factor')
            self.q10_factor = value
            self.validate_Nml2Quantity_none(self.q10_factor)    # validate type Nml2Quantity_none
        value = find_attr_value_('experimentalTemp', node)
        if value is not None and 'experimentalTemp' not in already_processed:
            already_processed.add('experimentalTemp')
            self.experimental_temp = value
            self.validate_Nml2Quantity_temperature(self.experimental_temp)    # validate type Nml2Quantity_temperature
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Q10Settings


class HHRate(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'NmlId', 0),
        MemberSpec_('rate', 'Nml2Quantity_pertime', 0),
        MemberSpec_('midpoint', 'Nml2Quantity_voltage', 0),
        MemberSpec_('scale', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type=None, rate=None, midpoint=None, scale=None):
        self.original_tagname_ = None
        self.type = _cast(None, type)
        self.rate = _cast(None, rate)
        self.midpoint = _cast(None, midpoint)
        self.scale = _cast(None, scale)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HHRate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHRate.subclass:
            return HHRate.subclass(*args_, **kwargs_)
        else:
            return HHRate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_pertime_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_pertime_patterns_, ))
    validate_Nml2Quantity_pertime_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s$|^per_ms$|^Hz)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HHRate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HHRate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='HHRate', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HHRate'):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate=%s' % (quote_attrib(self.rate), ))
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            outfile.write(' midpoint=%s' % (quote_attrib(self.midpoint), ))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            outfile.write(' scale=%s' % (quote_attrib(self.scale), ))
    def exportChildren(self, outfile, level, namespace_='', name_='HHRate', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            self.rate = value
            self.validate_Nml2Quantity_pertime(self.rate)    # validate type Nml2Quantity_pertime
        value = find_attr_value_('midpoint', node)
        if value is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(self.midpoint)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('scale', node)
        if value is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            self.scale = value
            self.validate_Nml2Quantity_voltage(self.scale)    # validate type Nml2Quantity_voltage
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HHRate


class HHVariable(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'NmlId', 0),
        MemberSpec_('rate', 'xs:float', 0),
        MemberSpec_('midpoint', 'Nml2Quantity_voltage', 0),
        MemberSpec_('scale', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type=None, rate=None, midpoint=None, scale=None):
        self.original_tagname_ = None
        self.type = _cast(None, type)
        self.rate = _cast(float, rate)
        self.midpoint = _cast(None, midpoint)
        self.scale = _cast(None, scale)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HHVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHVariable.subclass:
            return HHVariable.subclass(*args_, **kwargs_)
        else:
            return HHVariable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HHVariable', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HHVariable')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='HHVariable', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HHVariable'):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate="%s"' % self.gds_format_float(self.rate, input_name='rate'))
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            outfile.write(' midpoint=%s' % (quote_attrib(self.midpoint), ))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            outfile.write(' scale=%s' % (quote_attrib(self.scale), ))
    def exportChildren(self, outfile, level, namespace_='', name_='HHVariable', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            try:
                self.rate = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (rate): %s' % exp)
        value = find_attr_value_('midpoint', node)
        if value is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(self.midpoint)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('scale', node)
        if value is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            self.scale = value
            self.validate_Nml2Quantity_voltage(self.scale)    # validate type Nml2Quantity_voltage
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HHVariable


class HHTime(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'NmlId', 0),
        MemberSpec_('rate', 'Nml2Quantity_time', 0),
        MemberSpec_('midpoint', 'Nml2Quantity_voltage', 0),
        MemberSpec_('scale', 'Nml2Quantity_voltage', 0),
        MemberSpec_('tau', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type=None, rate=None, midpoint=None, scale=None, tau=None):
        self.original_tagname_ = None
        self.type = _cast(None, type)
        self.rate = _cast(None, rate)
        self.midpoint = _cast(None, midpoint)
        self.scale = _cast(None, scale)
        self.tau = _cast(None, tau)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HHTime)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHTime.subclass:
            return HHTime.subclass(*args_, **kwargs_)
        else:
            return HHTime(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HHTime', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HHTime')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='HHTime', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HHTime'):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate=%s' % (quote_attrib(self.rate), ))
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            outfile.write(' midpoint=%s' % (quote_attrib(self.midpoint), ))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            outfile.write(' scale=%s' % (quote_attrib(self.scale), ))
        if self.tau is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            outfile.write(' tau=%s' % (quote_attrib(self.tau), ))
    def exportChildren(self, outfile, level, namespace_='', name_='HHTime', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            self.rate = value
            self.validate_Nml2Quantity_time(self.rate)    # validate type Nml2Quantity_time
        value = find_attr_value_('midpoint', node)
        if value is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(self.midpoint)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('scale', node)
        if value is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            self.scale = value
            self.validate_Nml2Quantity_voltage(self.scale)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('tau', node)
        if value is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            self.tau = value
            self.validate_Nml2Quantity_time(self.tau)    # validate type Nml2Quantity_time
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HHTime


class BlockMechanism(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'BlockTypes', 0),
        MemberSpec_('species', 'NmlId', 0),
        MemberSpec_('blockConcentration', 'Nml2Quantity_concentration', 0),
        MemberSpec_('scalingConc', 'Nml2Quantity_concentration', 0),
        MemberSpec_('scalingVolt', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type=None, species=None, block_concentration=None, scaling_conc=None, scaling_volt=None):
        self.original_tagname_ = None
        self.type = _cast(None, type)
        self.species = _cast(None, species)
        self.block_concentration = _cast(None, block_concentration)
        self.scaling_conc = _cast(None, scaling_conc)
        self.scaling_volt = _cast(None, scaling_volt)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BlockMechanism)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BlockMechanism.subclass:
            return BlockMechanism.subclass(*args_, **kwargs_)
        else:
            return BlockMechanism(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_BlockTypes(self, value):
        # Validate type BlockTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['voltageConcDepBlockMechanism']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on BlockTypes' % {"value" : value.encode("utf-8")} )
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_concentration_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_concentration_patterns_, ))
    validate_Nml2Quantity_concentration_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3$|^mol_per_cm3$|^M$|^mM)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BlockMechanism', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BlockMechanism')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BlockMechanism', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BlockMechanism'):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            outfile.write(' species=%s' % (quote_attrib(self.species), ))
        if self.block_concentration is not None and 'block_concentration' not in already_processed:
            already_processed.add('block_concentration')
            outfile.write(' blockConcentration=%s' % (quote_attrib(self.block_concentration), ))
        if self.scaling_conc is not None and 'scaling_conc' not in already_processed:
            already_processed.add('scaling_conc')
            outfile.write(' scalingConc=%s' % (quote_attrib(self.scaling_conc), ))
        if self.scaling_volt is not None and 'scaling_volt' not in already_processed:
            already_processed.add('scaling_volt')
            outfile.write(' scalingVolt=%s' % (quote_attrib(self.scaling_volt), ))
    def exportChildren(self, outfile, level, namespace_='', name_='BlockMechanism', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_BlockTypes(self.type)    # validate type BlockTypes
        value = find_attr_value_('species', node)
        if value is not None and 'species' not in already_processed:
            already_processed.add('species')
            self.species = value
            self.validate_NmlId(self.species)    # validate type NmlId
        value = find_attr_value_('blockConcentration', node)
        if value is not None and 'blockConcentration' not in already_processed:
            already_processed.add('blockConcentration')
            self.block_concentration = value
            self.validate_Nml2Quantity_concentration(self.block_concentration)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('scalingConc', node)
        if value is not None and 'scalingConc' not in already_processed:
            already_processed.add('scalingConc')
            self.scaling_conc = value
            self.validate_Nml2Quantity_concentration(self.scaling_conc)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('scalingVolt', node)
        if value is not None and 'scalingVolt' not in already_processed:
            already_processed.add('scalingVolt')
            self.scaling_volt = value
            self.validate_Nml2Quantity_voltage(self.scaling_volt)    # validate type Nml2Quantity_voltage
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BlockMechanism


class PlasticityMechanism(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'PlasticityTypes', 0),
        MemberSpec_('initReleaseProb', 'ZeroToOne', 0),
        MemberSpec_('tauRec', 'Nml2Quantity_time', 0),
        MemberSpec_('tauFac', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type=None, init_release_prob=None, tau_rec=None, tau_fac=None):
        self.original_tagname_ = None
        self.type = _cast(None, type)
        self.init_release_prob = _cast(None, init_release_prob)
        self.tau_rec = _cast(None, tau_rec)
        self.tau_fac = _cast(None, tau_fac)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PlasticityMechanism)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PlasticityMechanism.subclass:
            return PlasticityMechanism.subclass(*args_, **kwargs_)
        else:
            return PlasticityMechanism(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_PlasticityTypes(self, value):
        # Validate type PlasticityTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['tsodyksMarkramDepMechanism', 'tsodyksMarkramDepFacMechanism']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on PlasticityTypes' % {"value" : value.encode("utf-8")} )
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne' % {"value" : value} )
            if value > 1:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne' % {"value" : value} )
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PlasticityMechanism', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PlasticityMechanism')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PlasticityMechanism', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PlasticityMechanism'):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.init_release_prob is not None and 'init_release_prob' not in already_processed:
            already_processed.add('init_release_prob')
            outfile.write(' initReleaseProb=%s' % (quote_attrib(self.init_release_prob), ))
        if self.tau_rec is not None and 'tau_rec' not in already_processed:
            already_processed.add('tau_rec')
            outfile.write(' tauRec=%s' % (quote_attrib(self.tau_rec), ))
        if self.tau_fac is not None and 'tau_fac' not in already_processed:
            already_processed.add('tau_fac')
            outfile.write(' tauFac=%s' % (quote_attrib(self.tau_fac), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PlasticityMechanism', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_PlasticityTypes(self.type)    # validate type PlasticityTypes
        value = find_attr_value_('initReleaseProb', node)
        if value is not None and 'initReleaseProb' not in already_processed:
            already_processed.add('initReleaseProb')
            try:
                self.init_release_prob = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (initReleaseProb): %s' % exp)
            self.validate_ZeroToOne(self.init_release_prob)    # validate type ZeroToOne
        value = find_attr_value_('tauRec', node)
        if value is not None and 'tauRec' not in already_processed:
            already_processed.add('tauRec')
            self.tau_rec = value
            self.validate_Nml2Quantity_time(self.tau_rec)    # validate type Nml2Quantity_time
        value = find_attr_value_('tauFac', node)
        if value is not None and 'tauFac' not in already_processed:
            already_processed.add('tauFac')
            self.tau_fac = value
            self.validate_Nml2Quantity_time(self.tau_fac)    # validate type Nml2Quantity_time
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PlasticityMechanism


class SegmentParent(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segment', 'NonNegativeInteger', 0),
        MemberSpec_('fractionAlong', 'ZeroToOne', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segments=None, fraction_along='1'):
        self.original_tagname_ = None
        self.segments = _cast(None, segments)
        self.fraction_along = _cast(None, fraction_along)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SegmentParent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentParent.subclass:
            return SegmentParent.subclass(*args_, **kwargs_)
        else:
            return SegmentParent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne' % {"value" : value} )
            if value > 1:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne' % {"value" : value} )
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SegmentParent', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentParent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SegmentParent', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SegmentParent'):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.fraction_along != 1 and 'fraction_along' not in already_processed:
            already_processed.add('fraction_along')
            outfile.write(' fractionAlong=%s' % (quote_attrib(self.fraction_along), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SegmentParent', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.segments)    # validate type NonNegativeInteger
        value = find_attr_value_('fractionAlong', node)
        if value is not None and 'fractionAlong' not in already_processed:
            already_processed.add('fractionAlong')
            try:
                self.fraction_along = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (fractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.fraction_along)    # validate type ZeroToOne
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SegmentParent


class Point3DWithDiam(GeneratedsSuper):
    """A 3D point with diameter."""
    member_data_items_ = [
        MemberSpec_('x', 'xs:double', 0),
        MemberSpec_('y', 'xs:double', 0),
        MemberSpec_('z', 'xs:double', 0),
        MemberSpec_('diameter', 'DoubleGreaterThanZero', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None, diameter=None):
        self.original_tagname_ = None
        self.x = _cast(float, x)
        self.y = _cast(float, y)
        self.z = _cast(float, z)
        self.diameter = _cast(None, diameter)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Point3DWithDiam)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Point3DWithDiam.subclass:
            return Point3DWithDiam.subclass(*args_, **kwargs_)
        else:
            return Point3DWithDiam(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_DoubleGreaterThanZero(self, value):
        # Validate type DoubleGreaterThanZero, a restriction on xs:double.
        if value is not None and Validate_simpletypes_:
            if value <= 0:
                warnings_.warn('Value "%(value)s" does not match xsd minExclusive restriction on DoubleGreaterThanZero' % {"value" : value} )
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Point3DWithDiam', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Point3DWithDiam')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Point3DWithDiam', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Point3DWithDiam'):
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            outfile.write(' x="%s"' % self.gds_format_double(self.x, input_name='x'))
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            outfile.write(' y="%s"' % self.gds_format_double(self.y, input_name='y'))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            outfile.write(' z="%s"' % self.gds_format_double(self.z, input_name='z'))
        if self.diameter is not None and 'diameter' not in already_processed:
            already_processed.add('diameter')
            outfile.write(' diameter=%s' % (quote_attrib(self.diameter), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Point3DWithDiam', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('x', node)
        if value is not None and 'x' not in already_processed:
            already_processed.add('x')
            try:
                self.x = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (x): %s' % exp)
        value = find_attr_value_('y', node)
        if value is not None and 'y' not in already_processed:
            already_processed.add('y')
            try:
                self.y = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (y): %s' % exp)
        value = find_attr_value_('z', node)
        if value is not None and 'z' not in already_processed:
            already_processed.add('z')
            try:
                self.z = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (z): %s' % exp)
        value = find_attr_value_('diameter', node)
        if value is not None and 'diameter' not in already_processed:
            already_processed.add('diameter')
            try:
                self.diameter = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (diameter): %s' % exp)
            self.validate_DoubleGreaterThanZero(self.diameter)    # validate type DoubleGreaterThanZero
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Point3DWithDiam


class ProximalDetails(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('translationStart', 'xs:double', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, translation_start=None):
        self.original_tagname_ = None
        self.translation_start = _cast(float, translation_start)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ProximalDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProximalDetails.subclass:
            return ProximalDetails.subclass(*args_, **kwargs_)
        else:
            return ProximalDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ProximalDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProximalDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ProximalDetails', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ProximalDetails'):
        if self.translation_start is not None and 'translation_start' not in already_processed:
            already_processed.add('translation_start')
            outfile.write(' translationStart="%s"' % self.gds_format_double(self.translation_start, input_name='translationStart'))
    def exportChildren(self, outfile, level, namespace_='', name_='ProximalDetails', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('translationStart', node)
        if value is not None and 'translationStart' not in already_processed:
            already_processed.add('translationStart')
            try:
                self.translation_start = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (translationStart): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ProximalDetails


class DistalDetails(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('normalizationEnd', 'xs:double', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, normalization_end=None):
        self.original_tagname_ = None
        self.normalization_end = _cast(float, normalization_end)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DistalDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DistalDetails.subclass:
            return DistalDetails.subclass(*args_, **kwargs_)
        else:
            return DistalDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DistalDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DistalDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DistalDetails', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DistalDetails'):
        if self.normalization_end is not None and 'normalization_end' not in already_processed:
            already_processed.add('normalization_end')
            outfile.write(' normalizationEnd="%s"' % self.gds_format_double(self.normalization_end, input_name='normalizationEnd'))
    def exportChildren(self, outfile, level, namespace_='', name_='DistalDetails', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('normalizationEnd', node)
        if value is not None and 'normalizationEnd' not in already_processed:
            already_processed.add('normalizationEnd')
            try:
                self.normalization_end = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (normalizationEnd): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DistalDetails


class Member(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segment', 'NonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segments=None):
        self.original_tagname_ = None
        self.segments = _cast(None, segments)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Member)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Member.subclass:
            return Member.subclass(*args_, **kwargs_)
        else:
            return Member(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Member', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Member')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Member', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Member'):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Member', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.segments)    # validate type NonNegativeInteger
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Member


class Include(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segmentGroup', 'NmlId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segment_groups=None):
        self.original_tagname_ = None
        self.segment_groups = _cast(None, segment_groups)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Include)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Include.subclass:
            return Include.subclass(*args_, **kwargs_)
        else:
            return Include(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Include', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Include')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Include', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Include'):
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Include', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Include


class Path(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('from_', 'SegmentEndPoint', 0),
        MemberSpec_('to', 'SegmentEndPoint', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, from_=None, to=None):
        self.original_tagname_ = None
        self.from_ = from_
        self.to = to
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Path)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Path.subclass:
            return Path.subclass(*args_, **kwargs_)
        else:
            return Path(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.from_ is not None or
            self.to is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Path', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Path')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Path', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Path'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Path', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_ is not None:
            self.from_.export(outfile, level, namespace_, name_='from', pretty_print=pretty_print)
        if self.to is not None:
            self.to.export(outfile, level, namespace_, name_='to', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'from':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.from_ = obj_
            obj_.original_tagname_ = 'from'
        elif nodeName_ == 'to':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.to = obj_
            obj_.original_tagname_ = 'to'
# end class Path


class SubTree(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('from_', 'SegmentEndPoint', 0),
        MemberSpec_('to', 'SegmentEndPoint', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, from_=None, to=None):
        self.original_tagname_ = None
        self.from_ = from_
        self.to = to
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SubTree)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SubTree.subclass:
            return SubTree.subclass(*args_, **kwargs_)
        else:
            return SubTree(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.from_ is not None or
            self.to is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SubTree', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubTree')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SubTree', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SubTree'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SubTree', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_ is not None:
            self.from_.export(outfile, level, namespace_, name_='from', pretty_print=pretty_print)
        if self.to is not None:
            self.to.export(outfile, level, namespace_, name_='to', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'from':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.from_ = obj_
            obj_.original_tagname_ = 'from'
        elif nodeName_ == 'to':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.to = obj_
            obj_.original_tagname_ = 'to'
# end class SubTree


class SegmentEndPoint(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segment', 'NonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segments=None):
        self.original_tagname_ = None
        self.segments = _cast(None, segments)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SegmentEndPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentEndPoint.subclass:
            return SegmentEndPoint.subclass(*args_, **kwargs_)
        else:
            return SegmentEndPoint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SegmentEndPoint', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentEndPoint')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SegmentEndPoint', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SegmentEndPoint'):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SegmentEndPoint', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.segments)    # validate type NonNegativeInteger
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SegmentEndPoint


class MembraneProperties(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('channel_populations', 'ChannelPopulation', 1),
        MemberSpec_('channel_densities', 'ChannelDensity', 1),
        MemberSpec_('channel_density_nernsts', 'ChannelDensityNernst', 1),
        MemberSpec_('channel_density_ghks', 'ChannelDensityGHK', 1),
        MemberSpec_('channel_density_ghk2s', 'ChannelDensityGHK2', 1),
        MemberSpec_('channel_density_non_uniforms', 'ChannelDensityNonUniform', 1),
        MemberSpec_('channel_density_non_uniform_nernsts', 'ChannelDensityNonUniformNernst', 1),
        MemberSpec_('channel_density_non_uniform_ghks', 'ChannelDensityNonUniformGHK', 1),
        MemberSpec_('spike_threshes', 'SpikeThresh', 1),
        MemberSpec_('specific_capacitances', 'SpecificCapacitance', 1),
        MemberSpec_('init_memb_potentials', 'InitMembPotential', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, channel_populations=None, channel_densities=None, channel_density_nernsts=None, channel_density_ghks=None, channel_density_ghk2s=None, channel_density_non_uniforms=None, channel_density_non_uniform_nernsts=None, channel_density_non_uniform_ghks=None, spike_threshes=None, specific_capacitances=None, init_memb_potentials=None, extensiontype_=None):
        self.original_tagname_ = None
        if channel_populations is None:
            self.channel_populations = []
        else:
            self.channel_populations = channel_populations
        if channel_densities is None:
            self.channel_densities = []
        else:
            self.channel_densities = channel_densities
        if channel_density_nernsts is None:
            self.channel_density_nernsts = []
        else:
            self.channel_density_nernsts = channel_density_nernsts
        if channel_density_ghks is None:
            self.channel_density_ghks = []
        else:
            self.channel_density_ghks = channel_density_ghks
        if channel_density_ghk2s is None:
            self.channel_density_ghk2s = []
        else:
            self.channel_density_ghk2s = channel_density_ghk2s
        if channel_density_non_uniforms is None:
            self.channel_density_non_uniforms = []
        else:
            self.channel_density_non_uniforms = channel_density_non_uniforms
        if channel_density_non_uniform_nernsts is None:
            self.channel_density_non_uniform_nernsts = []
        else:
            self.channel_density_non_uniform_nernsts = channel_density_non_uniform_nernsts
        if channel_density_non_uniform_ghks is None:
            self.channel_density_non_uniform_ghks = []
        else:
            self.channel_density_non_uniform_ghks = channel_density_non_uniform_ghks
        if spike_threshes is None:
            self.spike_threshes = []
        else:
            self.spike_threshes = spike_threshes
        if specific_capacitances is None:
            self.specific_capacitances = []
        else:
            self.specific_capacitances = specific_capacitances
        if init_memb_potentials is None:
            self.init_memb_potentials = []
        else:
            self.init_memb_potentials = init_memb_potentials
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MembraneProperties)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MembraneProperties.subclass:
            return MembraneProperties.subclass(*args_, **kwargs_)
        else:
            return MembraneProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.channel_populations or
            self.channel_densities or
            self.channel_density_nernsts or
            self.channel_density_ghks or
            self.channel_density_ghk2s or
            self.channel_density_non_uniforms or
            self.channel_density_non_uniform_nernsts or
            self.channel_density_non_uniform_ghks or
            self.spike_threshes or
            self.specific_capacitances or
            self.init_memb_potentials
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MembraneProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MembraneProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MembraneProperties', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MembraneProperties'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MembraneProperties', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for channelPopulation_ in self.channel_populations:
            channelPopulation_.export(outfile, level, namespace_, name_='channelPopulation', pretty_print=pretty_print)
        for channelDensity_ in self.channel_densities:
            channelDensity_.export(outfile, level, namespace_, name_='channelDensity', pretty_print=pretty_print)
        for channelDensityNernst_ in self.channel_density_nernsts:
            channelDensityNernst_.export(outfile, level, namespace_, name_='channelDensityNernst', pretty_print=pretty_print)
        for channelDensityGHK_ in self.channel_density_ghks:
            channelDensityGHK_.export(outfile, level, namespace_, name_='channelDensityGHK', pretty_print=pretty_print)
        for channelDensityGHK2_ in self.channel_density_ghk2s:
            channelDensityGHK2_.export(outfile, level, namespace_, name_='channelDensityGHK2', pretty_print=pretty_print)
        for channelDensityNonUniform_ in self.channel_density_non_uniforms:
            channelDensityNonUniform_.export(outfile, level, namespace_, name_='channelDensityNonUniform', pretty_print=pretty_print)
        for channelDensityNonUniformNernst_ in self.channel_density_non_uniform_nernsts:
            channelDensityNonUniformNernst_.export(outfile, level, namespace_, name_='channelDensityNonUniformNernst', pretty_print=pretty_print)
        for channelDensityNonUniformGHK_ in self.channel_density_non_uniform_ghks:
            channelDensityNonUniformGHK_.export(outfile, level, namespace_, name_='channelDensityNonUniformGHK', pretty_print=pretty_print)
        for spikeThresh_ in self.spike_threshes:
            spikeThresh_.export(outfile, level, namespace_, name_='spikeThresh', pretty_print=pretty_print)
        for specificCapacitance_ in self.specific_capacitances:
            specificCapacitance_.export(outfile, level, namespace_, name_='specificCapacitance', pretty_print=pretty_print)
        for initMembPotential_ in self.init_memb_potentials:
            initMembPotential_.export(outfile, level, namespace_, name_='initMembPotential', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'channelPopulation':
            obj_ = ChannelPopulation.factory()
            obj_.build(child_)
            self.channel_populations.append(obj_)
            obj_.original_tagname_ = 'channelPopulation'
        elif nodeName_ == 'channelDensity':
            obj_ = ChannelDensity.factory()
            obj_.build(child_)
            self.channel_densities.append(obj_)
            obj_.original_tagname_ = 'channelDensity'
        elif nodeName_ == 'channelDensityNernst':
            class_obj_ = self.get_class_obj_(child_, ChannelDensityNernst)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.channel_density_nernsts.append(obj_)
            obj_.original_tagname_ = 'channelDensityNernst'
        elif nodeName_ == 'channelDensityGHK':
            obj_ = ChannelDensityGHK.factory()
            obj_.build(child_)
            self.channel_density_ghks.append(obj_)
            obj_.original_tagname_ = 'channelDensityGHK'
        elif nodeName_ == 'channelDensityGHK2':
            obj_ = ChannelDensityGHK2.factory()
            obj_.build(child_)
            self.channel_density_ghk2s.append(obj_)
            obj_.original_tagname_ = 'channelDensityGHK2'
        elif nodeName_ == 'channelDensityNonUniform':
            obj_ = ChannelDensityNonUniform.factory()
            obj_.build(child_)
            self.channel_density_non_uniforms.append(obj_)
            obj_.original_tagname_ = 'channelDensityNonUniform'
        elif nodeName_ == 'channelDensityNonUniformNernst':
            obj_ = ChannelDensityNonUniformNernst.factory()
            obj_.build(child_)
            self.channel_density_non_uniform_nernsts.append(obj_)
            obj_.original_tagname_ = 'channelDensityNonUniformNernst'
        elif nodeName_ == 'channelDensityNonUniformGHK':
            obj_ = ChannelDensityNonUniformGHK.factory()
            obj_.build(child_)
            self.channel_density_non_uniform_ghks.append(obj_)
            obj_.original_tagname_ = 'channelDensityNonUniformGHK'
        elif nodeName_ == 'spikeThresh':
            obj_ = SpikeThresh.factory()
            obj_.build(child_)
            self.spike_threshes.append(obj_)
            obj_.original_tagname_ = 'spikeThresh'
        elif nodeName_ == 'specificCapacitance':
            obj_ = SpecificCapacitance.factory()
            obj_.build(child_)
            self.specific_capacitances.append(obj_)
            obj_.original_tagname_ = 'specificCapacitance'
        elif nodeName_ == 'initMembPotential':
            obj_ = InitMembPotential.factory()
            obj_.build(child_)
            self.init_memb_potentials.append(obj_)
            obj_.original_tagname_ = 'initMembPotential'
# end class MembraneProperties


class MembraneProperties2CaPools(MembraneProperties):
    member_data_items_ = [
        MemberSpec_('channel_density_nernst_ca2s', 'ChannelDensityNernstCa2', 1),
    ]
    subclass = None
    superclass = MembraneProperties
    def __init__(self, channel_populations=None, channel_densities=None, channel_density_nernsts=None, channel_density_ghks=None, channel_density_ghk2s=None, channel_density_non_uniforms=None, channel_density_non_uniform_nernsts=None, channel_density_non_uniform_ghks=None, spike_threshes=None, specific_capacitances=None, init_memb_potentials=None, channel_density_nernst_ca2s=None):
        self.original_tagname_ = None
        super(MembraneProperties2CaPools, self).__init__(channel_populations, channel_densities, channel_density_nernsts, channel_density_ghks, channel_density_ghk2s, channel_density_non_uniforms, channel_density_non_uniform_nernsts, channel_density_non_uniform_ghks, spike_threshes, specific_capacitances, init_memb_potentials, )
        if channel_density_nernst_ca2s is None:
            self.channel_density_nernst_ca2s = []
        else:
            self.channel_density_nernst_ca2s = channel_density_nernst_ca2s
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MembraneProperties2CaPools)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MembraneProperties2CaPools.subclass:
            return MembraneProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return MembraneProperties2CaPools(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.channel_density_nernst_ca2s or
            super(MembraneProperties2CaPools, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MembraneProperties2CaPools', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MembraneProperties2CaPools')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MembraneProperties2CaPools', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MembraneProperties2CaPools'):
        super(MembraneProperties2CaPools, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MembraneProperties2CaPools')
    def exportChildren(self, outfile, level, namespace_='', name_='MembraneProperties2CaPools', fromsubclass_=False, pretty_print=True):
        super(MembraneProperties2CaPools, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for channelDensityNernstCa2_ in self.channel_density_nernst_ca2s:
            channelDensityNernstCa2_.export(outfile, level, namespace_, name_='channelDensityNernstCa2', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MembraneProperties2CaPools, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'channelDensityNernstCa2':
            obj_ = ChannelDensityNernstCa2.factory()
            obj_.build(child_)
            self.channel_density_nernst_ca2s.append(obj_)
            obj_.original_tagname_ = 'channelDensityNernstCa2'
        super(MembraneProperties2CaPools, self).buildChildren(child_, node, nodeName_, True)
# end class MembraneProperties2CaPools


class ValueAcrossSegOrSegGroup(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('value', 'Nml2Quantity', 0),
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('segment', 'NmlId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, value=None, segment_groups='all', segments=None, extensiontype_=None):
        self.original_tagname_ = None
        self.value = _cast(None, value)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValueAcrossSegOrSegGroup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValueAcrossSegOrSegGroup.subclass:
            return ValueAcrossSegOrSegGroup.subclass(*args_, **kwargs_)
        else:
            return ValueAcrossSegOrSegGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity(self, value):
        # Validate type Nml2Quantity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_patterns_, ))
    validate_Nml2Quantity_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*([_a-zA-Z0-9])*$']]
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ValueAcrossSegOrSegGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ValueAcrossSegOrSegGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ValueAcrossSegOrSegGroup', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ValueAcrossSegOrSegGroup'):
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
        if self.segment_groups != "all" and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ValueAcrossSegOrSegGroup', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_Nml2Quantity(self.value)    # validate type Nml2Quantity
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            self.segments = value
            self.validate_NmlId(self.segments)    # validate type NmlId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ValueAcrossSegOrSegGroup


class VariableParameter(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('parameter', 'xs:string', 0),
        MemberSpec_('segmentGroup', 'xs:string', 0),
        MemberSpec_('inhomogeneous_value', 'InhomogeneousValue', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, parameter=None, segment_groups=None, inhomogeneous_value=None):
        self.original_tagname_ = None
        self.parameter = _cast(None, parameter)
        self.segment_groups = _cast(None, segment_groups)
        self.inhomogeneous_value = inhomogeneous_value
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VariableParameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VariableParameter.subclass:
            return VariableParameter.subclass(*args_, **kwargs_)
        else:
            return VariableParameter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.inhomogeneous_value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VariableParameter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VariableParameter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VariableParameter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VariableParameter'):
        if self.parameter is not None and 'parameter' not in already_processed:
            already_processed.add('parameter')
            outfile.write(' parameter=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.parameter), input_name='parameter')), ))
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.segment_groups), input_name='segmentGroup')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VariableParameter', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.inhomogeneous_value is not None:
            self.inhomogeneous_value.export(outfile, level, namespace_, name_='inhomogeneousValue', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('parameter', node)
        if value is not None and 'parameter' not in already_processed:
            already_processed.add('parameter')
            self.parameter = value
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'inhomogeneousValue':
            obj_ = InhomogeneousValue.factory()
            obj_.build(child_)
            self.inhomogeneous_value = obj_
            obj_.original_tagname_ = 'inhomogeneousValue'
# end class VariableParameter


class InhomogeneousValue(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('inhomogeneousParameter', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, inhomogeneous_parameters=None, value=None):
        self.original_tagname_ = None
        self.inhomogeneous_parameters = _cast(None, inhomogeneous_parameters)
        self.value = _cast(None, value)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InhomogeneousValue)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InhomogeneousValue.subclass:
            return InhomogeneousValue.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InhomogeneousValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InhomogeneousValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='InhomogeneousValue', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InhomogeneousValue'):
        if self.inhomogeneous_parameters is not None and 'inhomogeneous_parameters' not in already_processed:
            already_processed.add('inhomogeneous_parameters')
            outfile.write(' inhomogeneousParameter=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.inhomogeneous_parameters), input_name='inhomogeneousParameter')), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='InhomogeneousValue', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('inhomogeneousParameter', node)
        if value is not None and 'inhomogeneousParameter' not in already_processed:
            already_processed.add('inhomogeneousParameter')
            self.inhomogeneous_parameters = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class InhomogeneousValue


class Species(ValueAcrossSegOrSegGroup):
    """Specifying the ion here again is redundant, the ion name should be
    the same as id. Kept for now until LEMS implementation can
    select by id. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('id', 'NmlId', 0),
        MemberSpec_('concentrationModel', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('initialConcentration', 'Nml2Quantity_concentration', 0),
        MemberSpec_('initialExtConcentration', 'Nml2Quantity_concentration', 0),
    ]
    subclass = None
    superclass = ValueAcrossSegOrSegGroup
    def __init__(self, value=None, segment_groups='all', segments=None, id=None, concentration_model=None, ion=None, initial_concentration=None, initial_ext_concentration=None):
        self.original_tagname_ = None
        super(Species, self).__init__(value, segment_groups, segments, )
        self.id = _cast(None, id)
        self.concentration_model = _cast(None, concentration_model)
        self.ion = _cast(None, ion)
        self.initial_concentration = _cast(None, initial_concentration)
        self.initial_ext_concentration = _cast(None, initial_ext_concentration)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Species)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Species.subclass:
            return Species.subclass(*args_, **kwargs_)
        else:
            return Species(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_concentration_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_concentration_patterns_, ))
    validate_Nml2Quantity_concentration_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3$|^mol_per_cm3$|^M$|^mM)$']]
    def hasContent_(self):
        if (
            super(Species, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Species', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Species')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Species', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Species'):
        super(Species, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Species')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.concentration_model is not None and 'concentration_model' not in already_processed:
            already_processed.add('concentration_model')
            outfile.write(' concentrationModel=%s' % (quote_attrib(self.concentration_model), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.initial_concentration is not None and 'initial_concentration' not in already_processed:
            already_processed.add('initial_concentration')
            outfile.write(' initialConcentration=%s' % (quote_attrib(self.initial_concentration), ))
        if self.initial_ext_concentration is not None and 'initial_ext_concentration' not in already_processed:
            already_processed.add('initial_ext_concentration')
            outfile.write(' initialExtConcentration=%s' % (quote_attrib(self.initial_ext_concentration), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Species', fromsubclass_=False, pretty_print=True):
        super(Species, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_NmlId(self.id)    # validate type NmlId
        value = find_attr_value_('concentrationModel', node)
        if value is not None and 'concentrationModel' not in already_processed:
            already_processed.add('concentrationModel')
            self.concentration_model = value
            self.validate_NmlId(self.concentration_model)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('initialConcentration', node)
        if value is not None and 'initialConcentration' not in already_processed:
            already_processed.add('initialConcentration')
            self.initial_concentration = value
            self.validate_Nml2Quantity_concentration(self.initial_concentration)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('initialExtConcentration', node)
        if value is not None and 'initialExtConcentration' not in already_processed:
            already_processed.add('initialExtConcentration')
            self.initial_ext_concentration = value
            self.validate_Nml2Quantity_concentration(self.initial_ext_concentration)    # validate type Nml2Quantity_concentration
        super(Species, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Species, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Species


class IntracellularProperties(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('species', 'Species', 1),
        MemberSpec_('resistivities', 'Resistivity', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, species=None, resistivities=None, extensiontype_=None):
        self.original_tagname_ = None
        if species is None:
            self.species = []
        else:
            self.species = species
        if resistivities is None:
            self.resistivities = []
        else:
            self.resistivities = resistivities
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IntracellularProperties)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntracellularProperties.subclass:
            return IntracellularProperties.subclass(*args_, **kwargs_)
        else:
            return IntracellularProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.species or
            self.resistivities
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IntracellularProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IntracellularProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IntracellularProperties', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IntracellularProperties'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='IntracellularProperties', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for species_ in self.species:
            species_.export(outfile, level, namespace_, name_='species', pretty_print=pretty_print)
        for resistivity_ in self.resistivities:
            resistivity_.export(outfile, level, namespace_, name_='resistivity', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'species':
            obj_ = Species.factory()
            obj_.build(child_)
            self.species.append(obj_)
            obj_.original_tagname_ = 'species'
        elif nodeName_ == 'resistivity':
            obj_ = Resistivity.factory()
            obj_.build(child_)
            self.resistivities.append(obj_)
            obj_.original_tagname_ = 'resistivity'
# end class IntracellularProperties


class IntracellularProperties2CaPools(IntracellularProperties):
    member_data_items_ = [
    ]
    subclass = None
    superclass = IntracellularProperties
    def __init__(self, species=None, resistivities=None):
        self.original_tagname_ = None
        super(IntracellularProperties2CaPools, self).__init__(species, resistivities, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IntracellularProperties2CaPools)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntracellularProperties2CaPools.subclass:
            return IntracellularProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return IntracellularProperties2CaPools(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(IntracellularProperties2CaPools, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IntracellularProperties2CaPools', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IntracellularProperties2CaPools')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IntracellularProperties2CaPools', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IntracellularProperties2CaPools'):
        super(IntracellularProperties2CaPools, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IntracellularProperties2CaPools')
    def exportChildren(self, outfile, level, namespace_='', name_='IntracellularProperties2CaPools', fromsubclass_=False, pretty_print=True):
        super(IntracellularProperties2CaPools, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(IntracellularProperties2CaPools, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IntracellularProperties2CaPools, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IntracellularProperties2CaPools


class ExtracellularPropertiesLocal(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('species', 'Species', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, species=None):
        self.original_tagname_ = None
        if species is None:
            self.species = []
        else:
            self.species = species
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExtracellularPropertiesLocal)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExtracellularPropertiesLocal.subclass:
            return ExtracellularPropertiesLocal.subclass(*args_, **kwargs_)
        else:
            return ExtracellularPropertiesLocal(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.species
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExtracellularPropertiesLocal', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExtracellularPropertiesLocal')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ExtracellularPropertiesLocal', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExtracellularPropertiesLocal'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ExtracellularPropertiesLocal', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for species_ in self.species:
            species_.export(outfile, level, namespace_, name_='species', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'species':
            obj_ = Species.factory()
            obj_.build(child_)
            self.species.append(obj_)
            obj_.original_tagname_ = 'species'
# end class ExtracellularPropertiesLocal


class SpaceStructure(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('xSpacing', 'xs:float', 0),
        MemberSpec_('ySpacing', 'xs:float', 0),
        MemberSpec_('zSpacing', 'xs:float', 0),
        MemberSpec_('xStart', 'xs:float', 0),
        MemberSpec_('yStart', 'xs:float', 0),
        MemberSpec_('zStart', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, x_spacing=None, y_spacing=None, z_spacing=None, x_start=0, y_start=0, z_start=0):
        self.original_tagname_ = None
        self.x_spacing = _cast(float, x_spacing)
        self.y_spacing = _cast(float, y_spacing)
        self.z_spacing = _cast(float, z_spacing)
        self.x_start = _cast(float, x_start)
        self.y_start = _cast(float, y_start)
        self.z_start = _cast(float, z_start)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpaceStructure)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpaceStructure.subclass:
            return SpaceStructure.subclass(*args_, **kwargs_)
        else:
            return SpaceStructure(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpaceStructure', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpaceStructure')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpaceStructure', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpaceStructure'):
        if self.x_spacing is not None and 'x_spacing' not in already_processed:
            already_processed.add('x_spacing')
            outfile.write(' xSpacing="%s"' % self.gds_format_float(self.x_spacing, input_name='xSpacing'))
        if self.y_spacing is not None and 'y_spacing' not in already_processed:
            already_processed.add('y_spacing')
            outfile.write(' ySpacing="%s"' % self.gds_format_float(self.y_spacing, input_name='ySpacing'))
        if self.z_spacing is not None and 'z_spacing' not in already_processed:
            already_processed.add('z_spacing')
            outfile.write(' zSpacing="%s"' % self.gds_format_float(self.z_spacing, input_name='zSpacing'))
        if self.x_start != 0 and 'x_start' not in already_processed:
            already_processed.add('x_start')
            outfile.write(' xStart="%s"' % self.gds_format_float(self.x_start, input_name='xStart'))
        if self.y_start != 0 and 'y_start' not in already_processed:
            already_processed.add('y_start')
            outfile.write(' yStart="%s"' % self.gds_format_float(self.y_start, input_name='yStart'))
        if self.z_start != 0 and 'z_start' not in already_processed:
            already_processed.add('z_start')
            outfile.write(' zStart="%s"' % self.gds_format_float(self.z_start, input_name='zStart'))
    def exportChildren(self, outfile, level, namespace_='', name_='SpaceStructure', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xSpacing', node)
        if value is not None and 'xSpacing' not in already_processed:
            already_processed.add('xSpacing')
            try:
                self.x_spacing = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (xSpacing): %s' % exp)
        value = find_attr_value_('ySpacing', node)
        if value is not None and 'ySpacing' not in already_processed:
            already_processed.add('ySpacing')
            try:
                self.y_spacing = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (ySpacing): %s' % exp)
        value = find_attr_value_('zSpacing', node)
        if value is not None and 'zSpacing' not in already_processed:
            already_processed.add('zSpacing')
            try:
                self.z_spacing = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (zSpacing): %s' % exp)
        value = find_attr_value_('xStart', node)
        if value is not None and 'xStart' not in already_processed:
            already_processed.add('xStart')
            try:
                self.x_start = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (xStart): %s' % exp)
        value = find_attr_value_('yStart', node)
        if value is not None and 'yStart' not in already_processed:
            already_processed.add('yStart')
            try:
                self.y_start = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (yStart): %s' % exp)
        value = find_attr_value_('zStart', node)
        if value is not None and 'zStart' not in already_processed:
            already_processed.add('zStart')
            try:
                self.z_start = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (zStart): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SpaceStructure


class Layout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('space', 'NmlId', 0),
        MemberSpec_('random', 'RandomLayout', 0),
        MemberSpec_('grid', 'GridLayout', 0),
        MemberSpec_('unstructured', 'UnstructuredLayout', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, spaces=None, random=None, grid=None, unstructured=None):
        self.original_tagname_ = None
        self.spaces = _cast(None, spaces)
        self.random = random
        self.grid = grid
        self.unstructured = unstructured
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Layout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Layout.subclass:
            return Layout.subclass(*args_, **kwargs_)
        else:
            return Layout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.random is not None or
            self.grid is not None or
            self.unstructured is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Layout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Layout', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Layout'):
        if self.spaces is not None and 'spaces' not in already_processed:
            already_processed.add('spaces')
            outfile.write(' space=%s' % (quote_attrib(self.spaces), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Layout', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.random is not None:
            self.random.export(outfile, level, namespace_, name_='random', pretty_print=pretty_print)
        if self.grid is not None:
            self.grid.export(outfile, level, namespace_, name_='grid', pretty_print=pretty_print)
        if self.unstructured is not None:
            self.unstructured.export(outfile, level, namespace_, name_='unstructured', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('space', node)
        if value is not None and 'space' not in already_processed:
            already_processed.add('space')
            self.spaces = value
            self.validate_NmlId(self.spaces)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'random':
            obj_ = RandomLayout.factory()
            obj_.build(child_)
            self.random = obj_
            obj_.original_tagname_ = 'random'
        elif nodeName_ == 'grid':
            obj_ = GridLayout.factory()
            obj_.build(child_)
            self.grid = obj_
            obj_.original_tagname_ = 'grid'
        elif nodeName_ == 'unstructured':
            obj_ = UnstructuredLayout.factory()
            obj_.build(child_)
            self.unstructured = obj_
            obj_.original_tagname_ = 'unstructured'
# end class Layout


class UnstructuredLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('number', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, number=None):
        self.original_tagname_ = None
        self.number = _cast(int, number)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UnstructuredLayout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UnstructuredLayout.subclass:
            return UnstructuredLayout.subclass(*args_, **kwargs_)
        else:
            return UnstructuredLayout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='UnstructuredLayout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnstructuredLayout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='UnstructuredLayout', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='UnstructuredLayout'):
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            outfile.write(' number="%s"' % self.gds_format_integer(self.number, input_name='number'))
    def exportChildren(self, outfile, level, namespace_='', name_='UnstructuredLayout', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.add('number')
            try:
                self.number = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.number < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class UnstructuredLayout


class RandomLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('number', 'xs:nonNegativeInteger', 0),
        MemberSpec_('region', 'NmlId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, number=None, regions=None):
        self.original_tagname_ = None
        self.number = _cast(int, number)
        self.regions = _cast(None, regions)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RandomLayout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RandomLayout.subclass:
            return RandomLayout.subclass(*args_, **kwargs_)
        else:
            return RandomLayout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RandomLayout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RandomLayout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='RandomLayout', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RandomLayout'):
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            outfile.write(' number="%s"' % self.gds_format_integer(self.number, input_name='number'))
        if self.regions is not None and 'regions' not in already_processed:
            already_processed.add('regions')
            outfile.write(' region=%s' % (quote_attrib(self.regions), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RandomLayout', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.add('number')
            try:
                self.number = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.number < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('region', node)
        if value is not None and 'region' not in already_processed:
            already_processed.add('region')
            self.regions = value
            self.validate_NmlId(self.regions)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class RandomLayout


class GridLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('xSize', 'xs:nonNegativeInteger', 0),
        MemberSpec_('ySize', 'xs:nonNegativeInteger', 0),
        MemberSpec_('zSize', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, x_size=None, y_size=None, z_size=None):
        self.original_tagname_ = None
        self.x_size = _cast(int, x_size)
        self.y_size = _cast(int, y_size)
        self.z_size = _cast(int, z_size)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GridLayout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GridLayout.subclass:
            return GridLayout.subclass(*args_, **kwargs_)
        else:
            return GridLayout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GridLayout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GridLayout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GridLayout', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GridLayout'):
        if self.x_size is not None and 'x_size' not in already_processed:
            already_processed.add('x_size')
            outfile.write(' xSize="%s"' % self.gds_format_integer(self.x_size, input_name='xSize'))
        if self.y_size is not None and 'y_size' not in already_processed:
            already_processed.add('y_size')
            outfile.write(' ySize="%s"' % self.gds_format_integer(self.y_size, input_name='ySize'))
        if self.z_size is not None and 'z_size' not in already_processed:
            already_processed.add('z_size')
            outfile.write(' zSize="%s"' % self.gds_format_integer(self.z_size, input_name='zSize'))
    def exportChildren(self, outfile, level, namespace_='', name_='GridLayout', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xSize', node)
        if value is not None and 'xSize' not in already_processed:
            already_processed.add('xSize')
            try:
                self.x_size = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.x_size < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('ySize', node)
        if value is not None and 'ySize' not in already_processed:
            already_processed.add('ySize')
            try:
                self.y_size = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.y_size < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('zSize', node)
        if value is not None and 'zSize' not in already_processed:
            already_processed.add('zSize')
            try:
                self.z_size = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.z_size < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class GridLayout


class Instance(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('id', 'xs:nonNegativeInteger', 0),
        MemberSpec_('i', 'xs:nonNegativeInteger', 0),
        MemberSpec_('j', 'xs:nonNegativeInteger', 0),
        MemberSpec_('k', 'xs:nonNegativeInteger', 0),
        MemberSpec_('location', 'Location', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, i=None, j=None, k=None, location=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.i = _cast(int, i)
        self.j = _cast(int, j)
        self.k = _cast(int, k)
        self.location = location
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Instance)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Instance.subclass:
            return Instance.subclass(*args_, **kwargs_)
        else:
            return Instance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.location is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Instance', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Instance')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Instance', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Instance'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.i is not None and 'i' not in already_processed:
            already_processed.add('i')
            outfile.write(' i="%s"' % self.gds_format_integer(self.i, input_name='i'))
        if self.j is not None and 'j' not in already_processed:
            already_processed.add('j')
            outfile.write(' j="%s"' % self.gds_format_integer(self.j, input_name='j'))
        if self.k is not None and 'k' not in already_processed:
            already_processed.add('k')
            outfile.write(' k="%s"' % self.gds_format_integer(self.k, input_name='k'))
    def exportChildren(self, outfile, level, namespace_='', name_='Instance', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.location is not None:
            self.location.export(outfile, level, namespace_, name_='location', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('i', node)
        if value is not None and 'i' not in already_processed:
            already_processed.add('i')
            try:
                self.i = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.i < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('j', node)
        if value is not None and 'j' not in already_processed:
            already_processed.add('j')
            try:
                self.j = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.j < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('k', node)
        if value is not None and 'k' not in already_processed:
            already_processed.add('k')
            try:
                self.k = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.k < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'location':
            obj_ = Location.factory()
            obj_.build(child_)
            self.location = obj_
            obj_.original_tagname_ = 'location'
# end class Instance


class Location(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('x', 'xs:float', 0),
        MemberSpec_('y', 'xs:float', 0),
        MemberSpec_('z', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None):
        self.original_tagname_ = None
        self.x = _cast(float, x)
        self.y = _cast(float, y)
        self.z = _cast(float, z)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Location)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Location.subclass:
            return Location.subclass(*args_, **kwargs_)
        else:
            return Location(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Location', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Location')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Location', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Location'):
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            outfile.write(' x="%s"' % self.gds_format_float(self.x, input_name='x'))
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            outfile.write(' y="%s"' % self.gds_format_float(self.y, input_name='y'))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            outfile.write(' z="%s"' % self.gds_format_float(self.z, input_name='z'))
    def exportChildren(self, outfile, level, namespace_='', name_='Location', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('x', node)
        if value is not None and 'x' not in already_processed:
            already_processed.add('x')
            try:
                self.x = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (x): %s' % exp)
        value = find_attr_value_('y', node)
        if value is not None and 'y' not in already_processed:
            already_processed.add('y')
            try:
                self.y = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (y): %s' % exp)
        value = find_attr_value_('z', node)
        if value is not None and 'z' not in already_processed:
            already_processed.add('z')
            try:
                self.z = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (z): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

        
    def __str__(self):
        
        return "("+ '%.4f' % self.x+","+ '%.4f' % self.y+","+ '%.4f' % self.z+")"
        
    def __repr__(self):
    
        return str(self)
    
# end class Location


class SynapticConnection(GeneratedsSuper):
    """Single explicit connection. Introduced to test connections in LEMS.
    Will probably be removed in favour of connections wrapped in
    projection element"""
    member_data_items_ = [
        MemberSpec_('from', 'xs:string', 0),
        MemberSpec_('to', 'xs:string', 0),
        MemberSpec_('synapse', 'xs:string', 0),
        MemberSpec_('destination', 'NmlId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, from_=None, to=None, synapse=None, destination=None):
        self.original_tagname_ = None
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        self.synapse = _cast(None, synapse)
        self.destination = _cast(None, destination)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SynapticConnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SynapticConnection.subclass:
            return SynapticConnection.subclass(*args_, **kwargs_)
        else:
            return SynapticConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SynapticConnection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SynapticConnection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SynapticConnection', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SynapticConnection'):
        if self.from_ is not None and 'from_' not in already_processed:
            already_processed.add('from_')
            outfile.write(' from=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.from_), input_name='from')), ))
        if self.to is not None and 'to' not in already_processed:
            already_processed.add('to')
            outfile.write(' to=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.to), input_name='to')), ))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.synapse), input_name='synapse')), ))
        if self.destination is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            outfile.write(' destination=%s' % (quote_attrib(self.destination), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SynapticConnection', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('from', node)
        if value is not None and 'from' not in already_processed:
            already_processed.add('from')
            self.from_ = value
        value = find_attr_value_('to', node)
        if value is not None and 'to' not in already_processed:
            already_processed.add('to')
            self.to = value
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
        value = find_attr_value_('destination', node)
        if value is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            self.destination = value
            self.validate_NmlId(self.destination)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SynapticConnection


class ExplicitInput(GeneratedsSuper):
    """Single explicit input. Introduced to test inputs in LEMS. Will
    probably be removed in favour of inputs wrapped in inputList
    element"""
    member_data_items_ = [
        MemberSpec_('target', 'xs:string', 0),
        MemberSpec_('input', 'xs:string', 0),
        MemberSpec_('destination', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, target=None, input=None, destination=None):
        self.original_tagname_ = None
        self.target = _cast(None, target)
        self.input = _cast(None, input)
        self.destination = _cast(None, destination)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExplicitInput)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExplicitInput.subclass:
            return ExplicitInput.subclass(*args_, **kwargs_)
        else:
            return ExplicitInput(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExplicitInput', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExplicitInput')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ExplicitInput', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExplicitInput'):
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            outfile.write(' target=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.target), input_name='target')), ))
        if self.input is not None and 'input' not in already_processed:
            already_processed.add('input')
            outfile.write(' input=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.input), input_name='input')), ))
        if self.destination is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            outfile.write(' destination=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.destination), input_name='destination')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ExplicitInput', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.add('target')
            self.target = value
        value = find_attr_value_('input', node)
        if value is not None and 'input' not in already_processed:
            already_processed.add('input')
            self.input = value
        value = find_attr_value_('destination', node)
        if value is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            self.destination = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

    def _get_cell_id(self, id_string):
        if '[' in id_string:
            return int(id_string.split('[')[1].split(']')[0])
        else:
            return int(id_string.split('/')[2])

    def get_target_cell_id(self):
        
        return self._get_cell_id(self.target)

    def get_segment_id(self):
        
        return int(self.segment_id) if self.segment_id else 0

    def get_fraction_along(self):
        
        return float(self.fraction_along) if self.fraction_along else 0.5
        
    def __str__(self):
        
        return "Input "+str(self.id)+": "+str(self.get_target_cell_id())+":"+str(self.get_segment_id())+"("+'%.6f'%self.get_fraction_along()+")"
        
    # end class ExplicitInput


class Input(GeneratedsSuper):
    """Subject to change as it gets tested with LEMS"""
    member_data_items_ = [
        MemberSpec_('id', 'NonNegativeInteger', 0),
        MemberSpec_('target', 'xs:string', 0),
        MemberSpec_('destination', 'NmlId', 0),
        MemberSpec_('segmentId', 'NonNegativeInteger', 0),
        MemberSpec_('fractionAlong', 'ZeroToOne', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, id=None, target=None, destination=None, segment_id=None, fraction_along=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.target = _cast(None, target)
        self.destination = _cast(None, destination)
        self.segment_id = _cast(None, segment_id)
        self.fraction_along = _cast(None, fraction_along)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Input)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Input.subclass:
            return Input.subclass(*args_, **kwargs_)
        else:
            return Input(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne' % {"value" : value} )
            if value > 1:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne' % {"value" : value} )
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Input', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Input')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Input', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Input'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            outfile.write(' target=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.target), input_name='target')), ))
        if self.destination is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            outfile.write(' destination=%s' % (quote_attrib(self.destination), ))
        if self.segment_id is not None and 'segment_id' not in already_processed:
            already_processed.add('segment_id')
            outfile.write(' segmentId=%s' % (quote_attrib(self.segment_id), ))
        if self.fraction_along is not None and 'fraction_along' not in already_processed:
            already_processed.add('fraction_along')
            outfile.write(' fractionAlong=%s' % (quote_attrib(self.fraction_along), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Input', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.id)    # validate type NonNegativeInteger
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.add('target')
            self.target = value
        value = find_attr_value_('destination', node)
        if value is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            self.destination = value
            self.validate_NmlId(self.destination)    # validate type NmlId
        value = find_attr_value_('segmentId', node)
        if value is not None and 'segmentId' not in already_processed:
            already_processed.add('segmentId')
            try:
                self.segment_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segment_id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.segment_id)    # validate type NonNegativeInteger
        value = find_attr_value_('fractionAlong', node)
        if value is not None and 'fractionAlong' not in already_processed:
            already_processed.add('fractionAlong')
            try:
                self.fraction_along = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (fractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.fraction_along)    # validate type ZeroToOne
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass

    def _get_cell_id(self, id_string):
        if '[' in id_string:
            return int(id_string.split('[')[1].split(']')[0])
        else:
            return int(id_string.split('/')[2])

    def get_target_cell_id(self):
        
        return self._get_cell_id(self.target)

    def get_segment_id(self):
        
        return int(self.segment_id) if self.segment_id else 0

    def get_fraction_along(self):
        
        return float(self.fraction_along) if self.fraction_along else 0.5
        
    def __str__(self):
        
        return "Input "+str(self.id)+": "+str(self.get_target_cell_id())+":"+str(self.get_segment_id())+"("+'%.6f'%self.get_fraction_along()+")"
        
    # end class Input


class BaseWithoutId(GeneratedsSuper):
    """Base element without ID specified *yet*, e.g. for an element with a
    particular requirement on its id which does not comply with
    NmlId (e.g. Segment needs nonNegativeInteger)."""
    member_data_items_ = [
        MemberSpec_('neuroLexId', 'NeuroLexId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, neuro_lex_id=None, extensiontype_=None):
        self.original_tagname_ = None
        self.neuro_lex_id = _cast(None, neuro_lex_id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseWithoutId)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseWithoutId.subclass:
            return BaseWithoutId.subclass(*args_, **kwargs_)
        else:
            return BaseWithoutId(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NeuroLexId(self, value):
        # Validate type NeuroLexId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NeuroLexId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NeuroLexId_patterns_, ))
    validate_NeuroLexId_patterns_ = [['^[a-zA-Z0-9_:]*$']]
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseWithoutId', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseWithoutId')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseWithoutId', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseWithoutId'):
        if self.neuro_lex_id is not None and 'neuro_lex_id' not in already_processed:
            already_processed.add('neuro_lex_id')
            outfile.write(' neuroLexId=%s' % (quote_attrib(self.neuro_lex_id), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseWithoutId', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('neuroLexId', node)
        if value is not None and 'neuroLexId' not in already_processed:
            already_processed.add('neuroLexId')
            self.neuro_lex_id = value
            self.validate_NeuroLexId(self.neuro_lex_id)    # validate type NeuroLexId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BaseWithoutId


class BaseNonNegativeIntegerId(BaseWithoutId):
    """Anything which can have a unique (within its parent) id, which must
    be an integer zero or greater."""
    member_data_items_ = [
        MemberSpec_('id', 'NonNegativeInteger', 0),
    ]
    subclass = None
    superclass = BaseWithoutId
    def __init__(self, neuro_lex_id=None, id=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseNonNegativeIntegerId, self).__init__(neuro_lex_id, extensiontype_, )
        self.id = _cast(None, id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseNonNegativeIntegerId)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseNonNegativeIntegerId.subclass:
            return BaseNonNegativeIntegerId.subclass(*args_, **kwargs_)
        else:
            return BaseNonNegativeIntegerId(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            super(BaseNonNegativeIntegerId, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseNonNegativeIntegerId', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseNonNegativeIntegerId')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseNonNegativeIntegerId', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseNonNegativeIntegerId'):
        super(BaseNonNegativeIntegerId, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseNonNegativeIntegerId')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseNonNegativeIntegerId', fromsubclass_=False, pretty_print=True):
        super(BaseNonNegativeIntegerId, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.id)    # validate type NonNegativeInteger
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseNonNegativeIntegerId, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseNonNegativeIntegerId, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseNonNegativeIntegerId


class Base(BaseWithoutId):
    """Anything which can have a unique (within its parent) id of the form
    NmlId (spaceless combination of letters, numbers and
    underscore)."""
    member_data_items_ = [
        MemberSpec_('id', 'NmlId', 0),
    ]
    subclass = None
    superclass = BaseWithoutId
    def __init__(self, neuro_lex_id=None, id=None, extensiontype_=None):
        self.original_tagname_ = None
        super(Base, self).__init__(neuro_lex_id, extensiontype_, )
        self.id = _cast(None, id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Base)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Base.subclass:
            return Base.subclass(*args_, **kwargs_)
        else:
            return Base(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            super(Base, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Base', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Base')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Base', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Base'):
        super(Base, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Base')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Base', fromsubclass_=False, pretty_print=True):
        super(Base, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_NmlId(self.id)    # validate type NmlId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Base, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Base, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Base


class Standalone(Base):
    """Elements which can stand alone and be referenced by id, e.g. cell,
    morphology."""
    member_data_items_ = [
        MemberSpec_('metaid', 'MetaId', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('properties', 'Property', 1),
        MemberSpec_('annotation', 'Annotation', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, extensiontype_=None):
        self.original_tagname_ = None
        super(Standalone, self).__init__(neuro_lex_id, id, extensiontype_, )
        self.metaid = _cast(None, metaid)
        self.notes = notes
        self.validate_Notes(self.notes)
        if properties is None:
            self.properties = []
        else:
            self.properties = properties
        self.annotation = annotation
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Standalone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Standalone.subclass:
            return Standalone.subclass(*args_, **kwargs_)
        else:
            return Standalone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_MetaId(self, value):
        # Validate type MetaId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_MetaId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_MetaId_patterns_, ))
    validate_MetaId_patterns_ = [['^[a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.notes is not None or
            self.properties or
            self.annotation is not None or
            super(Standalone, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Standalone', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Standalone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Standalone', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Standalone'):
        super(Standalone, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Standalone')
        if self.metaid is not None and 'metaid' not in already_processed:
            already_processed.add('metaid')
            outfile.write(' metaid=%s' % (quote_attrib(self.metaid), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Standalone', fromsubclass_=False, pretty_print=True):
        super(Standalone, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        for property_ in self.properties:
            property_.export(outfile, level, namespace_, name_='property', pretty_print=pretty_print)
        if self.annotation is not None:
            self.annotation.export(outfile, level, namespace_, name_='annotation', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('metaid', node)
        if value is not None and 'metaid' not in already_processed:
            already_processed.add('metaid')
            self.metaid = value
            self.validate_MetaId(self.metaid)    # validate type MetaId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Standalone, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'property':
            obj_ = Property.factory()
            obj_.build(child_)
            self.properties.append(obj_)
            obj_.original_tagname_ = 'property'
        elif nodeName_ == 'annotation':
            obj_ = Annotation.factory()
            obj_.build(child_)
            self.annotation = obj_
            obj_.original_tagname_ = 'annotation'
        super(Standalone, self).buildChildren(child_, node, nodeName_, True)
# end class Standalone


class SpikeSourcePoisson(Standalone):
    member_data_items_ = [
        MemberSpec_('start', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('rate', 'Nml2Quantity_pertime', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, start=None, duration=None, rate=None):
        self.original_tagname_ = None
        super(SpikeSourcePoisson, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.start = _cast(None, start)
        self.duration = _cast(None, duration)
        self.rate = _cast(None, rate)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeSourcePoisson)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeSourcePoisson.subclass:
            return SpikeSourcePoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeSourcePoisson(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_pertime_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_pertime_patterns_, ))
    validate_Nml2Quantity_pertime_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s$|^per_ms$|^Hz)$']]
    def hasContent_(self):
        if (
            super(SpikeSourcePoisson, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeSourcePoisson', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeSourcePoisson')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpikeSourcePoisson', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeSourcePoisson'):
        super(SpikeSourcePoisson, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeSourcePoisson')
        if self.start is not None and 'start' not in already_processed:
            already_processed.add('start')
            outfile.write(' start=%s' % (quote_attrib(self.start), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate=%s' % (quote_attrib(self.rate), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeSourcePoisson', fromsubclass_=False, pretty_print=True):
        super(SpikeSourcePoisson, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('start', node)
        if value is not None and 'start' not in already_processed:
            already_processed.add('start')
            self.start = value
            self.validate_Nml2Quantity_time(self.start)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            self.rate = value
            self.validate_Nml2Quantity_pertime(self.rate)    # validate type Nml2Quantity_pertime
        super(SpikeSourcePoisson, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeSourcePoisson, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeSourcePoisson


class InputList(Base):
    """Subject to change as it gets tested with LEMS"""
    member_data_items_ = [
        MemberSpec_('population', 'NmlId', 0),
        MemberSpec_('component', 'NmlId', 0),
        MemberSpec_('input', 'Input', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, populations=None, component=None, input=None):
        self.original_tagname_ = None
        super(InputList, self).__init__(neuro_lex_id, id, )
        self.populations = _cast(None, populations)
        self.component = _cast(None, component)
        if input is None:
            self.input = []
        else:
            self.input = input
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InputList)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InputList.subclass:
            return InputList.subclass(*args_, **kwargs_)
        else:
            return InputList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.input or
            super(InputList, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InputList', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InputList')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='InputList', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InputList'):
        super(InputList, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InputList')
        if self.populations is not None and 'populations' not in already_processed:
            already_processed.add('populations')
            outfile.write(' population=%s' % (quote_attrib(self.populations), ))
        if self.component is not None and 'component' not in already_processed:
            already_processed.add('component')
            outfile.write(' component=%s' % (quote_attrib(self.component), ))
    def exportChildren(self, outfile, level, namespace_='', name_='InputList', fromsubclass_=False, pretty_print=True):
        super(InputList, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for input_ in self.input:
            input_.export(outfile, level, namespace_, name_='input', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('population', node)
        if value is not None and 'population' not in already_processed:
            already_processed.add('population')
            self.populations = value
            self.validate_NmlId(self.populations)    # validate type NmlId
        value = find_attr_value_('component', node)
        if value is not None and 'component' not in already_processed:
            already_processed.add('component')
            self.component = value
            self.validate_NmlId(self.component)    # validate type NmlId
        super(InputList, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'input':
            obj_ = Input.factory()
            obj_.build(child_)
            self.input.append(obj_)
            obj_.original_tagname_ = 'input'
        super(InputList, self).buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        #print("Exporting InputList: "+str(self.id)+" as HDF5")
        
         
        import numpy
        
        ilGroup = h5file.create_group(h5Group, 'inputList_'+self.id)
        ilGroup._f_setattr("id", self.id)
        ilGroup._f_setattr("component", self.component)
        ilGroup._f_setattr("population", self.populations)
        
        colCount = 4
        a = numpy.ones([len(self.input), colCount], numpy.float32)
        
        count=0
        for input in self.input:
            a[count,0] = input.id
            a[count,1] = input.get_target_cell_id()
            a[count,2] = input.get_segment_id()
            a[count,3] = input.get_fraction_along()
            count+=1
            
        array = h5file.create_carray(ilGroup, self.id, obj=a, title="Locations of inputs in "+ self.id)
            
        array._f_setattr("column_0", "id")
        array._f_setattr("column_1", "target_cell_id")
        array._f_setattr("column_2", "segment_id")
        array._f_setattr("column_3", "fraction_along")
        

    # end class InputList


class ContinuousProjection(Base):
    """Projection between two populations consisting of analog connections
    (e.g. graded synapses)"""
    member_data_items_ = [
        MemberSpec_('presynapticPopulation', 'NmlId', 0),
        MemberSpec_('postsynapticPopulation', 'NmlId', 0),
        MemberSpec_('continuous_connections', 'ContinuousConnection', 1),
        MemberSpec_('continuous_connection_instances', 'ContinuousConnectionInstance', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, presynaptic_population=None, postsynaptic_population=None, continuous_connections=None, continuous_connection_instances=None):
        self.original_tagname_ = None
        super(ContinuousProjection, self).__init__(neuro_lex_id, id, )
        self.presynaptic_population = _cast(None, presynaptic_population)
        self.postsynaptic_population = _cast(None, postsynaptic_population)
        if continuous_connections is None:
            self.continuous_connections = []
        else:
            self.continuous_connections = continuous_connections
        if continuous_connection_instances is None:
            self.continuous_connection_instances = []
        else:
            self.continuous_connection_instances = continuous_connection_instances
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContinuousProjection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContinuousProjection.subclass:
            return ContinuousProjection.subclass(*args_, **kwargs_)
        else:
            return ContinuousProjection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.continuous_connections or
            self.continuous_connection_instances or
            super(ContinuousProjection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ContinuousProjection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousProjection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ContinuousProjection', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousProjection'):
        super(ContinuousProjection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousProjection')
        if self.presynaptic_population is not None and 'presynaptic_population' not in already_processed:
            already_processed.add('presynaptic_population')
            outfile.write(' presynapticPopulation=%s' % (quote_attrib(self.presynaptic_population), ))
        if self.postsynaptic_population is not None and 'postsynaptic_population' not in already_processed:
            already_processed.add('postsynaptic_population')
            outfile.write(' postsynapticPopulation=%s' % (quote_attrib(self.postsynaptic_population), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousProjection', fromsubclass_=False, pretty_print=True):
        super(ContinuousProjection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for continuousConnection_ in self.continuous_connections:
            continuousConnection_.export(outfile, level, namespace_, name_='continuousConnection', pretty_print=pretty_print)
        for continuousConnectionInstance_ in self.continuous_connection_instances:
            continuousConnectionInstance_.export(outfile, level, namespace_, name_='continuousConnectionInstance', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('presynapticPopulation', node)
        if value is not None and 'presynapticPopulation' not in already_processed:
            already_processed.add('presynapticPopulation')
            self.presynaptic_population = value
            self.validate_NmlId(self.presynaptic_population)    # validate type NmlId
        value = find_attr_value_('postsynapticPopulation', node)
        if value is not None and 'postsynapticPopulation' not in already_processed:
            already_processed.add('postsynapticPopulation')
            self.postsynaptic_population = value
            self.validate_NmlId(self.postsynaptic_population)    # validate type NmlId
        super(ContinuousProjection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'continuousConnection':
            class_obj_ = self.get_class_obj_(child_, ContinuousConnection)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.continuous_connections.append(obj_)
            obj_.original_tagname_ = 'continuousConnection'
        elif nodeName_ == 'continuousConnectionInstance':
            obj_ = ContinuousConnectionInstance.factory()
            obj_.build(child_)
            self.continuous_connection_instances.append(obj_)
            obj_.original_tagname_ = 'continuousConnectionInstance'
        super(ContinuousProjection, self).buildChildren(child_, node, nodeName_, True)
# end class ContinuousProjection


class ElectricalProjection(Base):
    """Projection between two populations consisting of electrical
    connections (gap junctions)"""
    member_data_items_ = [
        MemberSpec_('presynapticPopulation', 'NmlId', 0),
        MemberSpec_('postsynapticPopulation', 'NmlId', 0),
        MemberSpec_('electrical_connections', 'ElectricalConnection', 1),
        MemberSpec_('electrical_connection_instances', 'ElectricalConnectionInstance', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, presynaptic_population=None, postsynaptic_population=None, electrical_connections=None, electrical_connection_instances=None):
        self.original_tagname_ = None
        super(ElectricalProjection, self).__init__(neuro_lex_id, id, )
        self.presynaptic_population = _cast(None, presynaptic_population)
        self.postsynaptic_population = _cast(None, postsynaptic_population)
        if electrical_connections is None:
            self.electrical_connections = []
        else:
            self.electrical_connections = electrical_connections
        if electrical_connection_instances is None:
            self.electrical_connection_instances = []
        else:
            self.electrical_connection_instances = electrical_connection_instances
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ElectricalProjection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ElectricalProjection.subclass:
            return ElectricalProjection.subclass(*args_, **kwargs_)
        else:
            return ElectricalProjection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.electrical_connections or
            self.electrical_connection_instances or
            super(ElectricalProjection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ElectricalProjection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ElectricalProjection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ElectricalProjection', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ElectricalProjection'):
        super(ElectricalProjection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ElectricalProjection')
        if self.presynaptic_population is not None and 'presynaptic_population' not in already_processed:
            already_processed.add('presynaptic_population')
            outfile.write(' presynapticPopulation=%s' % (quote_attrib(self.presynaptic_population), ))
        if self.postsynaptic_population is not None and 'postsynaptic_population' not in already_processed:
            already_processed.add('postsynaptic_population')
            outfile.write(' postsynapticPopulation=%s' % (quote_attrib(self.postsynaptic_population), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ElectricalProjection', fromsubclass_=False, pretty_print=True):
        super(ElectricalProjection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for electricalConnection_ in self.electrical_connections:
            electricalConnection_.export(outfile, level, namespace_, name_='electricalConnection', pretty_print=pretty_print)
        for electricalConnectionInstance_ in self.electrical_connection_instances:
            electricalConnectionInstance_.export(outfile, level, namespace_, name_='electricalConnectionInstance', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('presynapticPopulation', node)
        if value is not None and 'presynapticPopulation' not in already_processed:
            already_processed.add('presynapticPopulation')
            self.presynaptic_population = value
            self.validate_NmlId(self.presynaptic_population)    # validate type NmlId
        value = find_attr_value_('postsynapticPopulation', node)
        if value is not None and 'postsynapticPopulation' not in already_processed:
            already_processed.add('postsynapticPopulation')
            self.postsynaptic_population = value
            self.validate_NmlId(self.postsynaptic_population)    # validate type NmlId
        super(ElectricalProjection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'electricalConnection':
            class_obj_ = self.get_class_obj_(child_, ElectricalConnection)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.electrical_connections.append(obj_)
            obj_.original_tagname_ = 'electricalConnection'
        elif nodeName_ == 'electricalConnectionInstance':
            obj_ = ElectricalConnectionInstance.factory()
            obj_.build(child_)
            self.electrical_connection_instances.append(obj_)
            obj_.original_tagname_ = 'electricalConnectionInstance'
        super(ElectricalProjection, self).buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        #print("Exporting ElectricalProjection: "+str(self.id)+" as HDF5")
        
         
        import numpy
        
        projGroup = h5file.create_group(h5Group, 'projection_'+self.id)
        projGroup._f_setattr("id", self.id)
        projGroup._f_setattr("type", "electricalProjection")
        projGroup._f_setattr("presynapticPopulation", self.presynaptic_population)
        projGroup._f_setattr("postsynapticPopulation", self.postsynaptic_population)
        
        syn = self.electrical_connections[0].synapse if len(self.electrical_connections)>0 else self.electrical_connection_instances[0].synapse
        projGroup._f_setattr("synapse", syn )
        
        
        
        cols = 7
        extra_cols = {}
        
        num_tot = len(self.electrical_connections)+len(self.electrical_connection_instances)
        
        #print("Exporting "+str(num_tot)+" electrical connections")
        a = numpy.ones([num_tot, cols], numpy.float32)
        
        
        count=0
        
        for connection in self.electrical_connections:
          a[count,0] = connection.id
          a[count,1] = connection.get_pre_cell_id()
          a[count,2] = connection.get_post_cell_id()  
          a[count,3] = connection.pre_segment  
          a[count,4] = connection.post_segment  
          a[count,5] = connection.pre_fraction_along 
          a[count,6] = connection.post_fraction_along          
          count=count+1
          
        for connection in self.electrical_connection_instances:
          a[count,0] = connection.id
          a[count,1] = connection.get_pre_cell_id()
          a[count,2] = connection.get_post_cell_id()  
          a[count,3] = connection.pre_segment  
          a[count,4] = connection.post_segment  
          a[count,5] = connection.pre_fraction_along 
          a[count,6] = connection.post_fraction_along          
          count=count+1
          
        array = h5file.create_carray(projGroup, self.id, obj=a, title="Connections of cells in "+ self.id)
        
        array._f_setattr("column_0", "id")
        array._f_setattr("column_1", "pre_cell_id")
        array._f_setattr("column_2", "post_cell_id")
        array._f_setattr("column_3", "pre_segment_id")
        array._f_setattr("column_4", "post_segment_id")
        array._f_setattr("column_5", "pre_fraction_along")
        array._f_setattr("column_6", "post_fraction_along")
        
            
        

    # end class ElectricalProjection


class BaseConnection(BaseNonNegativeIntegerId):
    """Base of all synaptic connections (chemical/electrical/analog, etc.)
    inside projections"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = BaseNonNegativeIntegerId
    def __init__(self, neuro_lex_id=None, id=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseConnection, self).__init__(neuro_lex_id, id, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseConnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConnection.subclass:
            return BaseConnection.subclass(*args_, **kwargs_)
        else:
            return BaseConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BaseConnection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseConnection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConnection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseConnection', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseConnection'):
        super(BaseConnection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConnection')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseConnection', fromsubclass_=False, pretty_print=True):
        super(BaseConnection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseConnection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseConnection, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseConnection


class Projection(Base):
    """Projection (set of synaptic connections) between two populations"""
    member_data_items_ = [
        MemberSpec_('presynapticPopulation', 'NmlId', 0),
        MemberSpec_('postsynapticPopulation', 'NmlId', 0),
        MemberSpec_('synapse', 'NmlId', 0),
        MemberSpec_('connections', 'Connection', 1),
        MemberSpec_('connection_wds', 'ConnectionWD', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, presynaptic_population=None, postsynaptic_population=None, synapse=None, connections=None, connection_wds=None):
        self.original_tagname_ = None
        super(Projection, self).__init__(neuro_lex_id, id, )
        self.presynaptic_population = _cast(None, presynaptic_population)
        self.postsynaptic_population = _cast(None, postsynaptic_population)
        self.synapse = _cast(None, synapse)
        if connections is None:
            self.connections = []
        else:
            self.connections = connections
        if connection_wds is None:
            self.connection_wds = []
        else:
            self.connection_wds = connection_wds
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Projection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Projection.subclass:
            return Projection.subclass(*args_, **kwargs_)
        else:
            return Projection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.connections or
            self.connection_wds or
            super(Projection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Projection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Projection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Projection', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Projection'):
        super(Projection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Projection')
        if self.presynaptic_population is not None and 'presynaptic_population' not in already_processed:
            already_processed.add('presynaptic_population')
            outfile.write(' presynapticPopulation=%s' % (quote_attrib(self.presynaptic_population), ))
        if self.postsynaptic_population is not None and 'postsynaptic_population' not in already_processed:
            already_processed.add('postsynaptic_population')
            outfile.write(' postsynapticPopulation=%s' % (quote_attrib(self.postsynaptic_population), ))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (quote_attrib(self.synapse), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Projection', fromsubclass_=False, pretty_print=True):
        super(Projection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for connection_ in self.connections:
            connection_.export(outfile, level, namespace_, name_='connection', pretty_print=pretty_print)
        for connectionWD_ in self.connection_wds:
            connectionWD_.export(outfile, level, namespace_, name_='connectionWD', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('presynapticPopulation', node)
        if value is not None and 'presynapticPopulation' not in already_processed:
            already_processed.add('presynapticPopulation')
            self.presynaptic_population = value
            self.validate_NmlId(self.presynaptic_population)    # validate type NmlId
        value = find_attr_value_('postsynapticPopulation', node)
        if value is not None and 'postsynapticPopulation' not in already_processed:
            already_processed.add('postsynapticPopulation')
            self.postsynaptic_population = value
            self.validate_NmlId(self.postsynaptic_population)    # validate type NmlId
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
            self.validate_NmlId(self.synapse)    # validate type NmlId
        super(Projection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'connection':
            obj_ = Connection.factory()
            obj_.build(child_)
            self.connections.append(obj_)
            obj_.original_tagname_ = 'connection'
        elif nodeName_ == 'connectionWD':
            obj_ = ConnectionWD.factory()
            obj_.build(child_)
            self.connection_wds.append(obj_)
            obj_.original_tagname_ = 'connectionWD'
        super(Projection, self).buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        #print("Exporting Projection: "+str(self.id)+" as HDF5")
        
         
        import numpy
        
        projGroup = h5file.create_group(h5Group, 'projection_'+self.id)
        projGroup._f_setattr("id", self.id)
        projGroup._f_setattr("type", "projection")
        projGroup._f_setattr("presynapticPopulation", self.presynaptic_population)
        projGroup._f_setattr("postsynapticPopulation", self.postsynaptic_population)
        projGroup._f_setattr("synapse", self.synapse)
        
        #print("Exporting "+str(len(self.connections))+" connections, "+str(len(self.connection_wds))+" connections with weight")
        
        connection_wds = len(self.connection_wds) > 0
        
        cols = 3
        
        extra_cols = {}
        
        from neuroml.utils import has_segment_fraction_info
        
        include_segment_fraction = has_segment_fraction_info(self.connections) or has_segment_fraction_info(self.connection_wds)
        
        if include_segment_fraction:
            cols +=4
            extra_cols["column_3"] = "pre_segment_id"
            extra_cols["column_4"] = "post_segment_id"
            extra_cols["column_5"] = "pre_fraction_along"
            extra_cols["column_6"] = "post_fraction_along"
            
        
        if connection_wds:
            extra_cols["column_"+str(cols)] = "weight"
            extra_cols["column_"+str(cols+1)] = "delay"
            cols+=2
        
        
        a = numpy.ones([len(self.connections)+len(self.connection_wds), cols], numpy.float32)
        
        
        count=0
        
        for connection in self.connections:
          a[count,0] = connection.id
          a[count,1] = connection.get_pre_cell_id()
          a[count,2] = connection.get_post_cell_id()  
          if include_segment_fraction:
            a[count,3] = connection.pre_segment_id  
            a[count,4] = connection.post_segment_id  
            a[count,5] = connection.pre_fraction_along 
            a[count,6] = connection.post_fraction_along          
          count=count+1
          
        for connection in self.connection_wds:
          a[count,0] = connection.id
          a[count,1] = connection.get_pre_cell_id()
          a[count,2] = connection.get_post_cell_id()  
          
          if include_segment_fraction:
            a[count,3] = connection.pre_segment_id  
            a[count,4] = connection.post_segment_id  
            a[count,5] = connection.pre_fraction_along 
            a[count,6] = connection.post_fraction_along  
          
          a[count,cols-2] = connection.weight  
          if 'ms' in connection.delay:
            delay = float(connection.delay[:-2].strip())
          elif 's' in connection.delay:
            delay = float(connection.delay[:-1].strip())*1000.
          elif 'us' in connection.delay:
            delay = float(connection.delay[:-2].strip())/1e3
            
          a[count,cols-1] = delay          
          count=count+1
        
            
        array = h5file.create_carray(projGroup, self.id, obj=a, title="Connections of cells in "+ self.id)
        
        array._f_setattr("column_0", "id")
        array._f_setattr("column_1", "pre_cell_id")
        array._f_setattr("column_2", "post_cell_id")
        
        for col in extra_cols.keys():
            array._f_setattr(col,extra_cols[col])
            
        
        

    # end class Projection


class CellSet(Base):
    member_data_items_ = [
        MemberSpec_('select', 'xs:string', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, select=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(CellSet, self).__init__(neuro_lex_id, id, )
        self.select = _cast(None, select)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CellSet)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CellSet.subclass:
            return CellSet.subclass(*args_, **kwargs_)
        else:
            return CellSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(CellSet, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CellSet', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CellSet')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CellSet', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CellSet'):
        super(CellSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CellSet')
        if self.select is not None and 'select' not in already_processed:
            already_processed.add('select')
            outfile.write(' select=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.select), input_name='select')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CellSet', fromsubclass_=False, pretty_print=True):
        super(CellSet, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('select', node)
        if value is not None and 'select' not in already_processed:
            already_processed.add('select')
            self.select = value
        super(CellSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'CellSet')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(CellSet, self).buildChildren(child_, node, nodeName_, True)
# end class CellSet


class Population(Standalone):
    member_data_items_ = [
        MemberSpec_('component', 'NmlId', 0),
        MemberSpec_('size', 'NonNegativeInteger', 0),
        MemberSpec_('type', 'populationTypes', 0),
        MemberSpec_('extracellularProperties', 'NmlId', 0),
        MemberSpec_('layout', 'Layout', 0),
        MemberSpec_('instances', 'Instance', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, component=None, size=None, type=None, extracellular_properties=None, layout=None, instances=None):
        self.original_tagname_ = None
        super(Population, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.component = _cast(None, component)
        self.size = _cast(None, size)
        self.type = _cast(None, type)
        self.extracellular_properties = _cast(None, extracellular_properties)
        self.layout = layout
        if instances is None:
            self.instances = []
        else:
            self.instances = instances
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Population)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Population.subclass:
            return Population.subclass(*args_, **kwargs_)
        else:
            return Population(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_populationTypes(self, value):
        # Validate type populationTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['population', 'populationList']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on populationTypes' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.layout is not None or
            self.instances or
            super(Population, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Population', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Population')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Population', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Population'):
        super(Population, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Population')
        if self.component is not None and 'component' not in already_processed:
            already_processed.add('component')
            outfile.write(' component=%s' % (quote_attrib(self.component), ))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size=%s' % (quote_attrib(self.size), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.extracellular_properties is not None and 'extracellular_properties' not in already_processed:
            already_processed.add('extracellular_properties')
            outfile.write(' extracellularProperties=%s' % (quote_attrib(self.extracellular_properties), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Population', fromsubclass_=False, pretty_print=True):
        super(Population, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.layout is not None:
            self.layout.export(outfile, level, namespace_, name_='layout', pretty_print=pretty_print)
        for instance_ in self.instances:
            instance_.export(outfile, level, namespace_, name_='instance', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('component', node)
        if value is not None and 'component' not in already_processed:
            already_processed.add('component')
            self.component = value
            self.validate_NmlId(self.component)    # validate type NmlId
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            try:
                self.size = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.size < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.size)    # validate type NonNegativeInteger
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_populationTypes(self.type)    # validate type populationTypes
        value = find_attr_value_('extracellularProperties', node)
        if value is not None and 'extracellularProperties' not in already_processed:
            already_processed.add('extracellularProperties')
            self.extracellular_properties = value
            self.validate_NmlId(self.extracellular_properties)    # validate type NmlId
        super(Population, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'layout':
            obj_ = Layout.factory()
            obj_.build(child_)
            self.layout = obj_
            obj_.original_tagname_ = 'layout'
        elif nodeName_ == 'instance':
            obj_ = Instance.factory()
            obj_.build(child_)
            self.instances.append(obj_)
            obj_.original_tagname_ = 'instance'
        super(Population, self).buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        #print("Exporting Population: "+str(self.id)+" as HDF5")
        
         
        import numpy
        
        popGroup = h5file.create_group(h5Group, 'population_'+self.id)
        popGroup._f_setattr("id", self.id)
        popGroup._f_setattr("component", self.component)
        
        if len(self.instances)>0:

            colCount = 4
            a = numpy.ones([len(self.instances), colCount], numpy.float32)

            count=0
            for instance in self.instances:
              a[count,0] = instance.id
              a[count,1] = instance.location.x
              a[count,2] = instance.location.y
              a[count,3] = instance.location.z

              count=count+1
        
            popGroup._f_setattr("size", count)
            popGroup._f_setattr("type", "populationList")

            h5file.create_carray(popGroup, self.id, obj=a, title="Locations of cells in "+ self.id)
            
        else:
            popGroup._f_setattr("size", self.size)
        
        

    # end class Population


class Region(Base):
    member_data_items_ = [
        MemberSpec_('space', 'NmlId', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, spaces=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(Region, self).__init__(neuro_lex_id, id, )
        self.spaces = _cast(None, spaces)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Region)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Region.subclass:
            return Region.subclass(*args_, **kwargs_)
        else:
            return Region(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(Region, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Region', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Region')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Region', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Region'):
        super(Region, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Region')
        if self.spaces is not None and 'spaces' not in already_processed:
            already_processed.add('spaces')
            outfile.write(' space=%s' % (quote_attrib(self.spaces), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Region', fromsubclass_=False, pretty_print=True):
        super(Region, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('space', node)
        if value is not None and 'space' not in already_processed:
            already_processed.add('space')
            self.spaces = value
            self.validate_NmlId(self.spaces)    # validate type NmlId
        super(Region, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'Region')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(Region, self).buildChildren(child_, node, nodeName_, True)
# end class Region


class Space(Base):
    member_data_items_ = [
        MemberSpec_('basedOn', 'allowedSpaces', 0),
        MemberSpec_('structure', 'SpaceStructure', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, based_on=None, structure=None):
        self.original_tagname_ = None
        super(Space, self).__init__(neuro_lex_id, id, )
        self.based_on = _cast(None, based_on)
        self.structure = structure
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Space)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Space.subclass:
            return Space.subclass(*args_, **kwargs_)
        else:
            return Space(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_allowedSpaces(self, value):
        # Validate type allowedSpaces, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Euclidean_1D', 'Euclidean_2D', 'Euclidean_3D', 'Grid_1D', 'Grid_2D', 'Grid_3D']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on allowedSpaces' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.structure is not None or
            super(Space, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Space', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Space')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Space', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Space'):
        super(Space, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Space')
        if self.based_on is not None and 'based_on' not in already_processed:
            already_processed.add('based_on')
            outfile.write(' basedOn=%s' % (quote_attrib(self.based_on), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Space', fromsubclass_=False, pretty_print=True):
        super(Space, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.structure is not None:
            self.structure.export(outfile, level, namespace_, name_='structure', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('basedOn', node)
        if value is not None and 'basedOn' not in already_processed:
            already_processed.add('basedOn')
            self.based_on = value
            self.validate_allowedSpaces(self.based_on)    # validate type allowedSpaces
        super(Space, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'structure':
            obj_ = SpaceStructure.factory()
            obj_.build(child_)
            self.structure = obj_
            obj_.original_tagname_ = 'structure'
        super(Space, self).buildChildren(child_, node, nodeName_, True)
# end class Space


class Network(Standalone):
    member_data_items_ = [
        MemberSpec_('type', 'networkTypes', 0),
        MemberSpec_('temperature', 'Nml2Quantity_temperature', 0),
        MemberSpec_('spaces', 'Space', 1),
        MemberSpec_('regions', 'Region', 1),
        MemberSpec_('extracellular_properties', 'ExtracellularPropertiesLocal', 1),
        MemberSpec_('populations', 'Population', 1),
        MemberSpec_('cell_sets', 'CellSet', 1),
        MemberSpec_('synaptic_connections', 'SynapticConnection', 1),
        MemberSpec_('projections', 'Projection', 1),
        MemberSpec_('electrical_projections', 'ElectricalProjection', 1),
        MemberSpec_('continuous_projections', 'ContinuousProjection', 1),
        MemberSpec_('explicit_inputs', 'ExplicitInput', 1),
        MemberSpec_('input_lists', 'InputList', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, type=None, temperature=None, spaces=None, regions=None, extracellular_properties=None, populations=None, cell_sets=None, synaptic_connections=None, projections=None, electrical_projections=None, continuous_projections=None, explicit_inputs=None, input_lists=None):
        self.original_tagname_ = None
        super(Network, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.type = _cast(None, type)
        self.temperature = _cast(None, temperature)
        if spaces is None:
            self.spaces = []
        else:
            self.spaces = spaces
        if regions is None:
            self.regions = []
        else:
            self.regions = regions
        if extracellular_properties is None:
            self.extracellular_properties = []
        else:
            self.extracellular_properties = extracellular_properties
        if populations is None:
            self.populations = []
        else:
            self.populations = populations
        if cell_sets is None:
            self.cell_sets = []
        else:
            self.cell_sets = cell_sets
        if synaptic_connections is None:
            self.synaptic_connections = []
        else:
            self.synaptic_connections = synaptic_connections
        if projections is None:
            self.projections = []
        else:
            self.projections = projections
        if electrical_projections is None:
            self.electrical_projections = []
        else:
            self.electrical_projections = electrical_projections
        if continuous_projections is None:
            self.continuous_projections = []
        else:
            self.continuous_projections = continuous_projections
        if explicit_inputs is None:
            self.explicit_inputs = []
        else:
            self.explicit_inputs = explicit_inputs
        if input_lists is None:
            self.input_lists = []
        else:
            self.input_lists = input_lists
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Network)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Network.subclass:
            return Network.subclass(*args_, **kwargs_)
        else:
            return Network(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_networkTypes(self, value):
        # Validate type networkTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['network', 'networkWithTemperature']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on networkTypes' % {"value" : value.encode("utf-8")} )
    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_temperature_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_temperature_patterns_, ))
    validate_Nml2Quantity_temperature_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC)$']]
    def hasContent_(self):
        if (
            self.spaces or
            self.regions or
            self.extracellular_properties or
            self.populations or
            self.cell_sets or
            self.synaptic_connections or
            self.projections or
            self.electrical_projections or
            self.continuous_projections or
            self.explicit_inputs or
            self.input_lists or
            super(Network, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Network', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Network', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Network'):
        super(Network, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.temperature is not None and 'temperature' not in already_processed:
            already_processed.add('temperature')
            outfile.write(' temperature=%s' % (quote_attrib(self.temperature), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Network', fromsubclass_=False, pretty_print=True):
        super(Network, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for space_ in self.spaces:
            space_.export(outfile, level, namespace_, name_='space', pretty_print=pretty_print)
        for region_ in self.regions:
            region_.export(outfile, level, namespace_, name_='region', pretty_print=pretty_print)
        for extracellularProperties_ in self.extracellular_properties:
            extracellularProperties_.export(outfile, level, namespace_, name_='extracellularProperties', pretty_print=pretty_print)
        for population_ in self.populations:
            population_.export(outfile, level, namespace_, name_='population', pretty_print=pretty_print)
        for cellSet_ in self.cell_sets:
            cellSet_.export(outfile, level, namespace_, name_='cellSet', pretty_print=pretty_print)
        for synapticConnection_ in self.synaptic_connections:
            synapticConnection_.export(outfile, level, namespace_, name_='synapticConnection', pretty_print=pretty_print)
        for projection_ in self.projections:
            projection_.export(outfile, level, namespace_, name_='projection', pretty_print=pretty_print)
        for electricalProjection_ in self.electrical_projections:
            electricalProjection_.export(outfile, level, namespace_, name_='electricalProjection', pretty_print=pretty_print)
        for continuousProjection_ in self.continuous_projections:
            continuousProjection_.export(outfile, level, namespace_, name_='continuousProjection', pretty_print=pretty_print)
        for explicitInput_ in self.explicit_inputs:
            explicitInput_.export(outfile, level, namespace_, name_='explicitInput', pretty_print=pretty_print)
        for inputList_ in self.input_lists:
            inputList_.export(outfile, level, namespace_, name_='inputList', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_networkTypes(self.type)    # validate type networkTypes
        value = find_attr_value_('temperature', node)
        if value is not None and 'temperature' not in already_processed:
            already_processed.add('temperature')
            self.temperature = value
            self.validate_Nml2Quantity_temperature(self.temperature)    # validate type Nml2Quantity_temperature
        super(Network, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'space':
            obj_ = Space.factory()
            obj_.build(child_)
            self.spaces.append(obj_)
            obj_.original_tagname_ = 'space'
        elif nodeName_ == 'region':
            obj_ = Region.factory()
            obj_.build(child_)
            self.regions.append(obj_)
            obj_.original_tagname_ = 'region'
        elif nodeName_ == 'extracellularProperties':
            obj_ = ExtracellularPropertiesLocal.factory()
            obj_.build(child_)
            self.extracellular_properties.append(obj_)
            obj_.original_tagname_ = 'extracellularProperties'
        elif nodeName_ == 'population':
            obj_ = Population.factory()
            obj_.build(child_)
            self.populations.append(obj_)
            obj_.original_tagname_ = 'population'
        elif nodeName_ == 'cellSet':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.cell_sets.append(obj_)
            obj_.original_tagname_ = 'cellSet'
        elif nodeName_ == 'synapticConnection':
            obj_ = SynapticConnection.factory()
            obj_.build(child_)
            self.synaptic_connections.append(obj_)
            obj_.original_tagname_ = 'synapticConnection'
        elif nodeName_ == 'projection':
            obj_ = Projection.factory()
            obj_.build(child_)
            self.projections.append(obj_)
            obj_.original_tagname_ = 'projection'
        elif nodeName_ == 'electricalProjection':
            obj_ = ElectricalProjection.factory()
            obj_.build(child_)
            self.electrical_projections.append(obj_)
            obj_.original_tagname_ = 'electricalProjection'
        elif nodeName_ == 'continuousProjection':
            obj_ = ContinuousProjection.factory()
            obj_.build(child_)
            self.continuous_projections.append(obj_)
            obj_.original_tagname_ = 'continuousProjection'
        elif nodeName_ == 'explicitInput':
            obj_ = ExplicitInput.factory()
            obj_.build(child_)
            self.explicit_inputs.append(obj_)
            obj_.original_tagname_ = 'explicitInput'
        elif nodeName_ == 'inputList':
            obj_ = InputList.factory()
            obj_.build(child_)
            self.input_lists.append(obj_)
            obj_.original_tagname_ = 'inputList'
        super(Network, self).buildChildren(child_, node, nodeName_, True)

    def get_by_id(self,id):
        all_ids = []
        for ms in self.member_data_items_:
            mlist = self.__getattribute__(ms.name)
            for m in mlist:
                if hasattr(m,"id"):
                    if m.id == id:
                        return m
                    else:
                        all_ids.append(m.id)
        print("Id "+id+" not found in <network> element. All ids: "+str(all_ids))
        return None
    
    def exportHdf5(self, h5file, h5Group):
        #print("Exporting Network: "+str(self.id)+" as HDF5")
        
         
        import numpy
        
        netGroup = h5file.create_group(h5Group, 'network')
        netGroup._f_setattr("id", self.id)
        netGroup._f_setattr("notes", self.notes)
        if self.temperature:
            netGroup._f_setattr("temperature", self.temperature)
        
       
        for pop in self.populations:
            pop.exportHdf5(h5file, netGroup)
            
        if len(self.synaptic_connections) > 0:
            raise Exception("<synapticConnection> not yet supported in HDF5 export")
        if len(self.explicit_inputs) > 0:
            raise Exception("<explicitInput> not yet supported in HDF5 export")

        for proj in self.projections:
            proj.exportHdf5(h5file, netGroup)
            
        for eproj in self.electrical_projections:
            eproj.exportHdf5(h5file, netGroup)
            
        for cproj in self.continuous_projections:
            raise Exception("Error: <continuousProjection> not yet supported!")
            
        for il in self.input_lists:
            il.exportHdf5(h5file, netGroup)
        

    # end class Network


class TransientPoissonFiringSynapse(Standalone):
    member_data_items_ = [
        MemberSpec_('averageRate', 'Nml2Quantity_pertime', 0),
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('synapse', 'xs:string', 0),
        MemberSpec_('spikeTarget', 'xs:string', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, average_rate=None, delay=None, duration=None, synapse=None, spike_target=None):
        self.original_tagname_ = None
        super(TransientPoissonFiringSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.average_rate = _cast(None, average_rate)
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.synapse = _cast(None, synapse)
        self.spike_target = _cast(None, spike_target)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransientPoissonFiringSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransientPoissonFiringSynapse.subclass:
            return TransientPoissonFiringSynapse.subclass(*args_, **kwargs_)
        else:
            return TransientPoissonFiringSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_pertime_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_pertime_patterns_, ))
    validate_Nml2Quantity_pertime_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s$|^per_ms$|^Hz)$']]
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(TransientPoissonFiringSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TransientPoissonFiringSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TransientPoissonFiringSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TransientPoissonFiringSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TransientPoissonFiringSynapse'):
        super(TransientPoissonFiringSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TransientPoissonFiringSynapse')
        if self.average_rate is not None and 'average_rate' not in already_processed:
            already_processed.add('average_rate')
            outfile.write(' averageRate=%s' % (quote_attrib(self.average_rate), ))
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.synapse), input_name='synapse')), ))
        if self.spike_target is not None and 'spike_target' not in already_processed:
            already_processed.add('spike_target')
            outfile.write(' spikeTarget=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.spike_target), input_name='spikeTarget')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TransientPoissonFiringSynapse', fromsubclass_=False, pretty_print=True):
        super(TransientPoissonFiringSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('averageRate', node)
        if value is not None and 'averageRate' not in already_processed:
            already_processed.add('averageRate')
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(self.average_rate)    # validate type Nml2Quantity_pertime
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
        value = find_attr_value_('spikeTarget', node)
        if value is not None and 'spikeTarget' not in already_processed:
            already_processed.add('spikeTarget')
            self.spike_target = value
        super(TransientPoissonFiringSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(TransientPoissonFiringSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class TransientPoissonFiringSynapse


class PoissonFiringSynapse(Standalone):
    member_data_items_ = [
        MemberSpec_('averageRate', 'Nml2Quantity_pertime', 0),
        MemberSpec_('synapse', 'xs:string', 0),
        MemberSpec_('spikeTarget', 'xs:string', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, average_rate=None, synapse=None, spike_target=None):
        self.original_tagname_ = None
        super(PoissonFiringSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.average_rate = _cast(None, average_rate)
        self.synapse = _cast(None, synapse)
        self.spike_target = _cast(None, spike_target)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PoissonFiringSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PoissonFiringSynapse.subclass:
            return PoissonFiringSynapse.subclass(*args_, **kwargs_)
        else:
            return PoissonFiringSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_pertime_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_pertime_patterns_, ))
    validate_Nml2Quantity_pertime_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s$|^per_ms$|^Hz)$']]
    def hasContent_(self):
        if (
            super(PoissonFiringSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PoissonFiringSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PoissonFiringSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PoissonFiringSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PoissonFiringSynapse'):
        super(PoissonFiringSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PoissonFiringSynapse')
        if self.average_rate is not None and 'average_rate' not in already_processed:
            already_processed.add('average_rate')
            outfile.write(' averageRate=%s' % (quote_attrib(self.average_rate), ))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.synapse), input_name='synapse')), ))
        if self.spike_target is not None and 'spike_target' not in already_processed:
            already_processed.add('spike_target')
            outfile.write(' spikeTarget=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.spike_target), input_name='spikeTarget')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PoissonFiringSynapse', fromsubclass_=False, pretty_print=True):
        super(PoissonFiringSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('averageRate', node)
        if value is not None and 'averageRate' not in already_processed:
            already_processed.add('averageRate')
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(self.average_rate)    # validate type Nml2Quantity_pertime
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
        value = find_attr_value_('spikeTarget', node)
        if value is not None and 'spikeTarget' not in already_processed:
            already_processed.add('spikeTarget')
            self.spike_target = value
        super(PoissonFiringSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PoissonFiringSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class PoissonFiringSynapse


class SpikeGeneratorPoisson(Standalone):
    member_data_items_ = [
        MemberSpec_('averageRate', 'Nml2Quantity_pertime', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, average_rate=None):
        self.original_tagname_ = None
        super(SpikeGeneratorPoisson, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.average_rate = _cast(None, average_rate)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeGeneratorPoisson)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGeneratorPoisson.subclass:
            return SpikeGeneratorPoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorPoisson(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_pertime_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_pertime_patterns_, ))
    validate_Nml2Quantity_pertime_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s$|^per_ms$|^Hz)$']]
    def hasContent_(self):
        if (
            super(SpikeGeneratorPoisson, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeGeneratorPoisson', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorPoisson')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpikeGeneratorPoisson', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeGeneratorPoisson'):
        super(SpikeGeneratorPoisson, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorPoisson')
        if self.average_rate is not None and 'average_rate' not in already_processed:
            already_processed.add('average_rate')
            outfile.write(' averageRate=%s' % (quote_attrib(self.average_rate), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeGeneratorPoisson', fromsubclass_=False, pretty_print=True):
        super(SpikeGeneratorPoisson, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('averageRate', node)
        if value is not None and 'averageRate' not in already_processed:
            already_processed.add('averageRate')
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(self.average_rate)    # validate type Nml2Quantity_pertime
        super(SpikeGeneratorPoisson, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGeneratorPoisson, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeGeneratorPoisson


class SpikeGeneratorRandom(Standalone):
    member_data_items_ = [
        MemberSpec_('maxISI', 'Nml2Quantity_time', 0),
        MemberSpec_('minISI', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, max_isi=None, min_isi=None):
        self.original_tagname_ = None
        super(SpikeGeneratorRandom, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.max_isi = _cast(None, max_isi)
        self.min_isi = _cast(None, min_isi)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeGeneratorRandom)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGeneratorRandom.subclass:
            return SpikeGeneratorRandom.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorRandom(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(SpikeGeneratorRandom, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeGeneratorRandom', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorRandom')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpikeGeneratorRandom', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeGeneratorRandom'):
        super(SpikeGeneratorRandom, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorRandom')
        if self.max_isi is not None and 'max_isi' not in already_processed:
            already_processed.add('max_isi')
            outfile.write(' maxISI=%s' % (quote_attrib(self.max_isi), ))
        if self.min_isi is not None and 'min_isi' not in already_processed:
            already_processed.add('min_isi')
            outfile.write(' minISI=%s' % (quote_attrib(self.min_isi), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeGeneratorRandom', fromsubclass_=False, pretty_print=True):
        super(SpikeGeneratorRandom, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('maxISI', node)
        if value is not None and 'maxISI' not in already_processed:
            already_processed.add('maxISI')
            self.max_isi = value
            self.validate_Nml2Quantity_time(self.max_isi)    # validate type Nml2Quantity_time
        value = find_attr_value_('minISI', node)
        if value is not None and 'minISI' not in already_processed:
            already_processed.add('minISI')
            self.min_isi = value
            self.validate_Nml2Quantity_time(self.min_isi)    # validate type Nml2Quantity_time
        super(SpikeGeneratorRandom, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGeneratorRandom, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeGeneratorRandom


class SpikeGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_('period', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, period=None):
        self.original_tagname_ = None
        super(SpikeGenerator, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.period = _cast(None, period)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGenerator.subclass:
            return SpikeGenerator.subclass(*args_, **kwargs_)
        else:
            return SpikeGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(SpikeGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpikeGenerator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeGenerator'):
        super(SpikeGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGenerator')
        if self.period is not None and 'period' not in already_processed:
            already_processed.add('period')
            outfile.write(' period=%s' % (quote_attrib(self.period), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeGenerator', fromsubclass_=False, pretty_print=True):
        super(SpikeGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('period', node)
        if value is not None and 'period' not in already_processed:
            already_processed.add('period')
            self.period = value
            self.validate_Nml2Quantity_time(self.period)    # validate type Nml2Quantity_time
        super(SpikeGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeGenerator


class TimedSynapticInput(Standalone):
    member_data_items_ = [
        MemberSpec_('synapse', 'NmlId', 0),
        MemberSpec_('spikeTarget', 'xs:string', 0),
        MemberSpec_('spikes', 'Spike', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, synapse=None, spike_target=None, spikes=None):
        self.original_tagname_ = None
        super(TimedSynapticInput, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.synapse = _cast(None, synapse)
        self.spike_target = _cast(None, spike_target)
        if spikes is None:
            self.spikes = []
        else:
            self.spikes = spikes
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TimedSynapticInput)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TimedSynapticInput.subclass:
            return TimedSynapticInput.subclass(*args_, **kwargs_)
        else:
            return TimedSynapticInput(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.spikes or
            super(TimedSynapticInput, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimedSynapticInput', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimedSynapticInput')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimedSynapticInput', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimedSynapticInput'):
        super(TimedSynapticInput, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TimedSynapticInput')
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (quote_attrib(self.synapse), ))
        if self.spike_target is not None and 'spike_target' not in already_processed:
            already_processed.add('spike_target')
            outfile.write(' spikeTarget=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.spike_target), input_name='spikeTarget')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TimedSynapticInput', fromsubclass_=False, pretty_print=True):
        super(TimedSynapticInput, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for spike_ in self.spikes:
            spike_.export(outfile, level, namespace_, name_='spike', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
            self.validate_NmlId(self.synapse)    # validate type NmlId
        value = find_attr_value_('spikeTarget', node)
        if value is not None and 'spikeTarget' not in already_processed:
            already_processed.add('spikeTarget')
            self.spike_target = value
        super(TimedSynapticInput, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'spike':
            obj_ = Spike.factory()
            obj_.build(child_)
            self.spikes.append(obj_)
            obj_.original_tagname_ = 'spike'
        super(TimedSynapticInput, self).buildChildren(child_, node, nodeName_, True)
# end class TimedSynapticInput


class SpikeArray(Standalone):
    member_data_items_ = [
        MemberSpec_('spikes', 'Spike', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, spikes=None):
        self.original_tagname_ = None
        super(SpikeArray, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        if spikes is None:
            self.spikes = []
        else:
            self.spikes = spikes
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeArray)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeArray.subclass:
            return SpikeArray.subclass(*args_, **kwargs_)
        else:
            return SpikeArray(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.spikes or
            super(SpikeArray, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeArray', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeArray')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpikeArray', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeArray'):
        super(SpikeArray, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeArray')
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeArray', fromsubclass_=False, pretty_print=True):
        super(SpikeArray, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for spike_ in self.spikes:
            spike_.export(outfile, level, namespace_, name_='spike', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SpikeArray, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'spike':
            obj_ = Spike.factory()
            obj_.build(child_)
            self.spikes.append(obj_)
            obj_.original_tagname_ = 'spike'
        super(SpikeArray, self).buildChildren(child_, node, nodeName_, True)
# end class SpikeArray


class Spike(BaseNonNegativeIntegerId):
    member_data_items_ = [
        MemberSpec_('time', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = BaseNonNegativeIntegerId
    def __init__(self, neuro_lex_id=None, id=None, time=None):
        self.original_tagname_ = None
        super(Spike, self).__init__(neuro_lex_id, id, )
        self.time = _cast(None, time)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Spike)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Spike.subclass:
            return Spike.subclass(*args_, **kwargs_)
        else:
            return Spike(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(Spike, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Spike', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Spike')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Spike', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Spike'):
        super(Spike, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Spike')
        if self.time is not None and 'time' not in already_processed:
            already_processed.add('time')
            outfile.write(' time=%s' % (quote_attrib(self.time), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Spike', fromsubclass_=False, pretty_print=True):
        super(Spike, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('time', node)
        if value is not None and 'time' not in already_processed:
            already_processed.add('time')
            self.time = value
            self.validate_Nml2Quantity_time(self.time)    # validate type Nml2Quantity_time
        super(Spike, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Spike, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Spike


class VoltageClamp(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('targetVoltage', 'Nml2Quantity_voltage', 0),
        MemberSpec_('simpleSeriesResistance', 'Nml2Quantity_resistance', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, delay=None, duration=None, target_voltage=None, simple_series_resistance=None):
        self.original_tagname_ = None
        super(VoltageClamp, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.target_voltage = _cast(None, target_voltage)
        self.simple_series_resistance = _cast(None, simple_series_resistance)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoltageClamp)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoltageClamp.subclass:
            return VoltageClamp.subclass(*args_, **kwargs_)
        else:
            return VoltageClamp(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_resistance(self, value):
        # Validate type Nml2Quantity_resistance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_resistance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_resistance_patterns_, ))
    validate_Nml2Quantity_resistance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(ohm$|^kohm$|^Mohm)$']]
    def hasContent_(self):
        if (
            super(VoltageClamp, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VoltageClamp', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VoltageClamp')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VoltageClamp', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VoltageClamp'):
        super(VoltageClamp, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VoltageClamp')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.target_voltage is not None and 'target_voltage' not in already_processed:
            already_processed.add('target_voltage')
            outfile.write(' targetVoltage=%s' % (quote_attrib(self.target_voltage), ))
        if self.simple_series_resistance is not None and 'simple_series_resistance' not in already_processed:
            already_processed.add('simple_series_resistance')
            outfile.write(' simpleSeriesResistance=%s' % (quote_attrib(self.simple_series_resistance), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VoltageClamp', fromsubclass_=False, pretty_print=True):
        super(VoltageClamp, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('targetVoltage', node)
        if value is not None and 'targetVoltage' not in already_processed:
            already_processed.add('targetVoltage')
            self.target_voltage = value
            self.validate_Nml2Quantity_voltage(self.target_voltage)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('simpleSeriesResistance', node)
        if value is not None and 'simpleSeriesResistance' not in already_processed:
            already_processed.add('simpleSeriesResistance')
            self.simple_series_resistance = value
            self.validate_Nml2Quantity_resistance(self.simple_series_resistance)    # validate type Nml2Quantity_resistance
        super(VoltageClamp, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VoltageClamp, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class VoltageClamp


class CompoundInputDL(Standalone):
    member_data_items_ = [
        MemberSpec_('pulse_generator_dls', 'PulseGeneratorDL', 1),
        MemberSpec_('sine_generator_dls', 'SineGeneratorDL', 1),
        MemberSpec_('ramp_generator_dls', 'RampGeneratorDL', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, pulse_generator_dls=None, sine_generator_dls=None, ramp_generator_dls=None):
        self.original_tagname_ = None
        super(CompoundInputDL, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        if pulse_generator_dls is None:
            self.pulse_generator_dls = []
        else:
            self.pulse_generator_dls = pulse_generator_dls
        if sine_generator_dls is None:
            self.sine_generator_dls = []
        else:
            self.sine_generator_dls = sine_generator_dls
        if ramp_generator_dls is None:
            self.ramp_generator_dls = []
        else:
            self.ramp_generator_dls = ramp_generator_dls
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CompoundInputDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CompoundInputDL.subclass:
            return CompoundInputDL.subclass(*args_, **kwargs_)
        else:
            return CompoundInputDL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.pulse_generator_dls or
            self.sine_generator_dls or
            self.ramp_generator_dls or
            super(CompoundInputDL, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CompoundInputDL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CompoundInputDL')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CompoundInputDL', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CompoundInputDL'):
        super(CompoundInputDL, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CompoundInputDL')
    def exportChildren(self, outfile, level, namespace_='', name_='CompoundInputDL', fromsubclass_=False, pretty_print=True):
        super(CompoundInputDL, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for pulseGeneratorDL_ in self.pulse_generator_dls:
            pulseGeneratorDL_.export(outfile, level, namespace_, name_='pulseGeneratorDL', pretty_print=pretty_print)
        for sineGeneratorDL_ in self.sine_generator_dls:
            sineGeneratorDL_.export(outfile, level, namespace_, name_='sineGeneratorDL', pretty_print=pretty_print)
        for rampGeneratorDL_ in self.ramp_generator_dls:
            rampGeneratorDL_.export(outfile, level, namespace_, name_='rampGeneratorDL', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(CompoundInputDL, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pulseGeneratorDL':
            obj_ = PulseGeneratorDL.factory()
            obj_.build(child_)
            self.pulse_generator_dls.append(obj_)
            obj_.original_tagname_ = 'pulseGeneratorDL'
        elif nodeName_ == 'sineGeneratorDL':
            obj_ = SineGeneratorDL.factory()
            obj_.build(child_)
            self.sine_generator_dls.append(obj_)
            obj_.original_tagname_ = 'sineGeneratorDL'
        elif nodeName_ == 'rampGeneratorDL':
            obj_ = RampGeneratorDL.factory()
            obj_.build(child_)
            self.ramp_generator_dls.append(obj_)
            obj_.original_tagname_ = 'rampGeneratorDL'
        super(CompoundInputDL, self).buildChildren(child_, node, nodeName_, True)
# end class CompoundInputDL


class CompoundInput(Standalone):
    member_data_items_ = [
        MemberSpec_('pulse_generators', 'PulseGenerator', 1),
        MemberSpec_('sine_generators', 'SineGenerator', 1),
        MemberSpec_('ramp_generators', 'RampGenerator', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, pulse_generators=None, sine_generators=None, ramp_generators=None):
        self.original_tagname_ = None
        super(CompoundInput, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        if pulse_generators is None:
            self.pulse_generators = []
        else:
            self.pulse_generators = pulse_generators
        if sine_generators is None:
            self.sine_generators = []
        else:
            self.sine_generators = sine_generators
        if ramp_generators is None:
            self.ramp_generators = []
        else:
            self.ramp_generators = ramp_generators
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CompoundInput)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CompoundInput.subclass:
            return CompoundInput.subclass(*args_, **kwargs_)
        else:
            return CompoundInput(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.pulse_generators or
            self.sine_generators or
            self.ramp_generators or
            super(CompoundInput, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CompoundInput', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CompoundInput')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CompoundInput', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CompoundInput'):
        super(CompoundInput, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CompoundInput')
    def exportChildren(self, outfile, level, namespace_='', name_='CompoundInput', fromsubclass_=False, pretty_print=True):
        super(CompoundInput, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for pulseGenerator_ in self.pulse_generators:
            pulseGenerator_.export(outfile, level, namespace_, name_='pulseGenerator', pretty_print=pretty_print)
        for sineGenerator_ in self.sine_generators:
            sineGenerator_.export(outfile, level, namespace_, name_='sineGenerator', pretty_print=pretty_print)
        for rampGenerator_ in self.ramp_generators:
            rampGenerator_.export(outfile, level, namespace_, name_='rampGenerator', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(CompoundInput, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pulseGenerator':
            obj_ = PulseGenerator.factory()
            obj_.build(child_)
            self.pulse_generators.append(obj_)
            obj_.original_tagname_ = 'pulseGenerator'
        elif nodeName_ == 'sineGenerator':
            obj_ = SineGenerator.factory()
            obj_.build(child_)
            self.sine_generators.append(obj_)
            obj_.original_tagname_ = 'sineGenerator'
        elif nodeName_ == 'rampGenerator':
            obj_ = RampGenerator.factory()
            obj_.build(child_)
            self.ramp_generators.append(obj_)
            obj_.original_tagname_ = 'rampGenerator'
        super(CompoundInput, self).buildChildren(child_, node, nodeName_, True)
# end class CompoundInput


class RampGeneratorDL(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('startAmplitude', 'Nml2Quantity_none', 0),
        MemberSpec_('finishAmplitude', 'Nml2Quantity_none', 0),
        MemberSpec_('baselineAmplitude', 'Nml2Quantity_none', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, delay=None, duration=None, start_amplitude=None, finish_amplitude=None, baseline_amplitude=None):
        self.original_tagname_ = None
        super(RampGeneratorDL, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.start_amplitude = _cast(None, start_amplitude)
        self.finish_amplitude = _cast(None, finish_amplitude)
        self.baseline_amplitude = _cast(None, baseline_amplitude)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RampGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RampGeneratorDL.subclass:
            return RampGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return RampGeneratorDL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def hasContent_(self):
        if (
            super(RampGeneratorDL, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RampGeneratorDL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RampGeneratorDL')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='RampGeneratorDL', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RampGeneratorDL'):
        super(RampGeneratorDL, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RampGeneratorDL')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.start_amplitude is not None and 'start_amplitude' not in already_processed:
            already_processed.add('start_amplitude')
            outfile.write(' startAmplitude=%s' % (quote_attrib(self.start_amplitude), ))
        if self.finish_amplitude is not None and 'finish_amplitude' not in already_processed:
            already_processed.add('finish_amplitude')
            outfile.write(' finishAmplitude=%s' % (quote_attrib(self.finish_amplitude), ))
        if self.baseline_amplitude is not None and 'baseline_amplitude' not in already_processed:
            already_processed.add('baseline_amplitude')
            outfile.write(' baselineAmplitude=%s' % (quote_attrib(self.baseline_amplitude), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RampGeneratorDL', fromsubclass_=False, pretty_print=True):
        super(RampGeneratorDL, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('startAmplitude', node)
        if value is not None and 'startAmplitude' not in already_processed:
            already_processed.add('startAmplitude')
            self.start_amplitude = value
            self.validate_Nml2Quantity_none(self.start_amplitude)    # validate type Nml2Quantity_none
        value = find_attr_value_('finishAmplitude', node)
        if value is not None and 'finishAmplitude' not in already_processed:
            already_processed.add('finishAmplitude')
            self.finish_amplitude = value
            self.validate_Nml2Quantity_none(self.finish_amplitude)    # validate type Nml2Quantity_none
        value = find_attr_value_('baselineAmplitude', node)
        if value is not None and 'baselineAmplitude' not in already_processed:
            already_processed.add('baselineAmplitude')
            self.baseline_amplitude = value
            self.validate_Nml2Quantity_none(self.baseline_amplitude)    # validate type Nml2Quantity_none
        super(RampGeneratorDL, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RampGeneratorDL, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class RampGeneratorDL


class RampGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('startAmplitude', 'Nml2Quantity_current', 0),
        MemberSpec_('finishAmplitude', 'Nml2Quantity_current', 0),
        MemberSpec_('baselineAmplitude', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, delay=None, duration=None, start_amplitude=None, finish_amplitude=None, baseline_amplitude=None):
        self.original_tagname_ = None
        super(RampGenerator, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.start_amplitude = _cast(None, start_amplitude)
        self.finish_amplitude = _cast(None, finish_amplitude)
        self.baseline_amplitude = _cast(None, baseline_amplitude)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RampGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RampGenerator.subclass:
            return RampGenerator.subclass(*args_, **kwargs_)
        else:
            return RampGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_current_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_current_patterns_, ))
    validate_Nml2Quantity_current_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A$|^uA$|^nA$|^pA)$']]
    def hasContent_(self):
        if (
            super(RampGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RampGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RampGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='RampGenerator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RampGenerator'):
        super(RampGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RampGenerator')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.start_amplitude is not None and 'start_amplitude' not in already_processed:
            already_processed.add('start_amplitude')
            outfile.write(' startAmplitude=%s' % (quote_attrib(self.start_amplitude), ))
        if self.finish_amplitude is not None and 'finish_amplitude' not in already_processed:
            already_processed.add('finish_amplitude')
            outfile.write(' finishAmplitude=%s' % (quote_attrib(self.finish_amplitude), ))
        if self.baseline_amplitude is not None and 'baseline_amplitude' not in already_processed:
            already_processed.add('baseline_amplitude')
            outfile.write(' baselineAmplitude=%s' % (quote_attrib(self.baseline_amplitude), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RampGenerator', fromsubclass_=False, pretty_print=True):
        super(RampGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('startAmplitude', node)
        if value is not None and 'startAmplitude' not in already_processed:
            already_processed.add('startAmplitude')
            self.start_amplitude = value
            self.validate_Nml2Quantity_current(self.start_amplitude)    # validate type Nml2Quantity_current
        value = find_attr_value_('finishAmplitude', node)
        if value is not None and 'finishAmplitude' not in already_processed:
            already_processed.add('finishAmplitude')
            self.finish_amplitude = value
            self.validate_Nml2Quantity_current(self.finish_amplitude)    # validate type Nml2Quantity_current
        value = find_attr_value_('baselineAmplitude', node)
        if value is not None and 'baselineAmplitude' not in already_processed:
            already_processed.add('baselineAmplitude')
            self.baseline_amplitude = value
            self.validate_Nml2Quantity_current(self.baseline_amplitude)    # validate type Nml2Quantity_current
        super(RampGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RampGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class RampGenerator


class SineGeneratorDL(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('phase', 'Nml2Quantity_none', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('amplitude', 'Nml2Quantity_none', 0),
        MemberSpec_('period', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, delay=None, phase=None, duration=None, amplitude=None, period=None):
        self.original_tagname_ = None
        super(SineGeneratorDL, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.delay = _cast(None, delay)
        self.phase = _cast(None, phase)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)
        self.period = _cast(None, period)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SineGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SineGeneratorDL.subclass:
            return SineGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return SineGeneratorDL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def hasContent_(self):
        if (
            super(SineGeneratorDL, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SineGeneratorDL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SineGeneratorDL')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SineGeneratorDL', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SineGeneratorDL'):
        super(SineGeneratorDL, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SineGeneratorDL')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.phase is not None and 'phase' not in already_processed:
            already_processed.add('phase')
            outfile.write(' phase=%s' % (quote_attrib(self.phase), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            outfile.write(' amplitude=%s' % (quote_attrib(self.amplitude), ))
        if self.period is not None and 'period' not in already_processed:
            already_processed.add('period')
            outfile.write(' period=%s' % (quote_attrib(self.period), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SineGeneratorDL', fromsubclass_=False, pretty_print=True):
        super(SineGeneratorDL, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('phase', node)
        if value is not None and 'phase' not in already_processed:
            already_processed.add('phase')
            self.phase = value
            self.validate_Nml2Quantity_none(self.phase)    # validate type Nml2Quantity_none
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('amplitude', node)
        if value is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            self.amplitude = value
            self.validate_Nml2Quantity_none(self.amplitude)    # validate type Nml2Quantity_none
        value = find_attr_value_('period', node)
        if value is not None and 'period' not in already_processed:
            already_processed.add('period')
            self.period = value
            self.validate_Nml2Quantity_time(self.period)    # validate type Nml2Quantity_time
        super(SineGeneratorDL, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SineGeneratorDL, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SineGeneratorDL


class SineGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('phase', 'Nml2Quantity_none', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('amplitude', 'Nml2Quantity_current', 0),
        MemberSpec_('period', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, delay=None, phase=None, duration=None, amplitude=None, period=None):
        self.original_tagname_ = None
        super(SineGenerator, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.delay = _cast(None, delay)
        self.phase = _cast(None, phase)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)
        self.period = _cast(None, period)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SineGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SineGenerator.subclass:
            return SineGenerator.subclass(*args_, **kwargs_)
        else:
            return SineGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_current_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_current_patterns_, ))
    validate_Nml2Quantity_current_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A$|^uA$|^nA$|^pA)$']]
    def hasContent_(self):
        if (
            super(SineGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SineGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SineGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SineGenerator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SineGenerator'):
        super(SineGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SineGenerator')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.phase is not None and 'phase' not in already_processed:
            already_processed.add('phase')
            outfile.write(' phase=%s' % (quote_attrib(self.phase), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            outfile.write(' amplitude=%s' % (quote_attrib(self.amplitude), ))
        if self.period is not None and 'period' not in already_processed:
            already_processed.add('period')
            outfile.write(' period=%s' % (quote_attrib(self.period), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SineGenerator', fromsubclass_=False, pretty_print=True):
        super(SineGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('phase', node)
        if value is not None and 'phase' not in already_processed:
            already_processed.add('phase')
            self.phase = value
            self.validate_Nml2Quantity_none(self.phase)    # validate type Nml2Quantity_none
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('amplitude', node)
        if value is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            self.amplitude = value
            self.validate_Nml2Quantity_current(self.amplitude)    # validate type Nml2Quantity_current
        value = find_attr_value_('period', node)
        if value is not None and 'period' not in already_processed:
            already_processed.add('period')
            self.period = value
            self.validate_Nml2Quantity_time(self.period)    # validate type Nml2Quantity_time
        super(SineGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SineGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SineGenerator


class PulseGeneratorDL(Standalone):
    """Generates a constant current pulse of a certain amplitude (non
    dimensional) for a specified duration after a delay."""
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('amplitude', 'Nml2Quantity_none', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, delay=None, duration=None, amplitude=None):
        self.original_tagname_ = None
        super(PulseGeneratorDL, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PulseGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PulseGeneratorDL.subclass:
            return PulseGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return PulseGeneratorDL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def hasContent_(self):
        if (
            super(PulseGeneratorDL, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PulseGeneratorDL', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PulseGeneratorDL')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PulseGeneratorDL', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PulseGeneratorDL'):
        super(PulseGeneratorDL, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PulseGeneratorDL')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            outfile.write(' amplitude=%s' % (quote_attrib(self.amplitude), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PulseGeneratorDL', fromsubclass_=False, pretty_print=True):
        super(PulseGeneratorDL, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('amplitude', node)
        if value is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            self.amplitude = value
            self.validate_Nml2Quantity_none(self.amplitude)    # validate type Nml2Quantity_none
        super(PulseGeneratorDL, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PulseGeneratorDL, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class PulseGeneratorDL


class PulseGenerator(Standalone):
    """Generates a constant current pulse of a certain amplitude (with
    dimensions for current) for a specified duration after a delay."""
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('amplitude', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, delay=None, duration=None, amplitude=None):
        self.original_tagname_ = None
        super(PulseGenerator, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PulseGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PulseGenerator.subclass:
            return PulseGenerator.subclass(*args_, **kwargs_)
        else:
            return PulseGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_current_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_current_patterns_, ))
    validate_Nml2Quantity_current_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A$|^uA$|^nA$|^pA)$']]
    def hasContent_(self):
        if (
            super(PulseGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PulseGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PulseGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PulseGenerator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PulseGenerator'):
        super(PulseGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PulseGenerator')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            outfile.write(' amplitude=%s' % (quote_attrib(self.amplitude), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PulseGenerator', fromsubclass_=False, pretty_print=True):
        super(PulseGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('amplitude', node)
        if value is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            self.amplitude = value
            self.validate_Nml2Quantity_current(self.amplitude)    # validate type Nml2Quantity_current
        super(PulseGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PulseGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class PulseGenerator


class ReactionScheme(Base):
    member_data_items_ = [
        MemberSpec_('source', 'xs:string', 0),
        MemberSpec_('type', 'xs:string', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, source=None, type=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(ReactionScheme, self).__init__(neuro_lex_id, id, )
        self.source = _cast(None, source)
        self.type = _cast(None, type)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReactionScheme)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReactionScheme.subclass:
            return ReactionScheme.subclass(*args_, **kwargs_)
        else:
            return ReactionScheme(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(ReactionScheme, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReactionScheme', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReactionScheme')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReactionScheme', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReactionScheme'):
        super(ReactionScheme, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReactionScheme')
        if self.source is not None and 'source' not in already_processed:
            already_processed.add('source')
            outfile.write(' source=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.source), input_name='source')), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ReactionScheme', fromsubclass_=False, pretty_print=True):
        super(ReactionScheme, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('source', node)
        if value is not None and 'source' not in already_processed:
            already_processed.add('source')
            self.source = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
        super(ReactionScheme, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'ReactionScheme')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(ReactionScheme, self).buildChildren(child_, node, nodeName_, True)
# end class ReactionScheme


class ExtracellularProperties(Base):
    member_data_items_ = [
        MemberSpec_('species', 'Species', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, species=None):
        self.original_tagname_ = None
        super(ExtracellularProperties, self).__init__(neuro_lex_id, id, )
        if species is None:
            self.species = []
        else:
            self.species = species
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExtracellularProperties)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExtracellularProperties.subclass:
            return ExtracellularProperties.subclass(*args_, **kwargs_)
        else:
            return ExtracellularProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.species or
            super(ExtracellularProperties, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExtracellularProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExtracellularProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ExtracellularProperties', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExtracellularProperties'):
        super(ExtracellularProperties, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExtracellularProperties')
    def exportChildren(self, outfile, level, namespace_='', name_='ExtracellularProperties', fromsubclass_=False, pretty_print=True):
        super(ExtracellularProperties, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for species_ in self.species:
            species_.export(outfile, level, namespace_, name_='species', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ExtracellularProperties, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'species':
            obj_ = Species.factory()
            obj_.build(child_)
            self.species.append(obj_)
            obj_.original_tagname_ = 'species'
        super(ExtracellularProperties, self).buildChildren(child_, node, nodeName_, True)
# end class ExtracellularProperties


class ChannelDensityGHK2(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('condDensity', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('segment', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, cond_density=None, segment_groups='all', segments=None, ion=None):
        self.original_tagname_ = None
        super(ChannelDensityGHK2, self).__init__(neuro_lex_id, id, )
        self.ion_channel = _cast(None, ion_channel)
        self.cond_density = _cast(None, cond_density)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityGHK2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityGHK2.subclass:
            return ChannelDensityGHK2.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityGHK2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductanceDensity_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductanceDensity_patterns_, ))
    validate_Nml2Quantity_conductanceDensity_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2$|^mS_per_cm2$|^S_per_cm2)$']]
    def hasContent_(self):
        if (
            super(ChannelDensityGHK2, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensityGHK2', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityGHK2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensityGHK2', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensityGHK2'):
        super(ChannelDensityGHK2, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityGHK2')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.cond_density is not None and 'cond_density' not in already_processed:
            already_processed.add('cond_density')
            outfile.write(' condDensity=%s' % (quote_attrib(self.cond_density), ))
        if self.segment_groups != "all" and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensityGHK2', fromsubclass_=False, pretty_print=True):
        super(ChannelDensityGHK2, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('condDensity', node)
        if value is not None and 'condDensity' not in already_processed:
            already_processed.add('condDensity')
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(self.cond_density)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            self.segments = value
            self.validate_NmlId(self.segments)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        super(ChannelDensityGHK2, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ChannelDensityGHK2, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ChannelDensityGHK2


class ChannelDensityGHK(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('permeability', 'Nml2Quantity_permeability', 0),
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('segment', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, permeability=None, segment_groups='all', segments=None, ion=None):
        self.original_tagname_ = None
        super(ChannelDensityGHK, self).__init__(neuro_lex_id, id, )
        self.ion_channel = _cast(None, ion_channel)
        self.permeability = _cast(None, permeability)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityGHK)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityGHK.subclass:
            return ChannelDensityGHK.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityGHK(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_permeability(self, value):
        # Validate type Nml2Quantity_permeability, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_permeability_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_permeability_patterns_, ))
    validate_Nml2Quantity_permeability_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(m_per_s$|^                        um_per_ms$|^cm_per_s$|^cm_per_ms)$']]
    def hasContent_(self):
        if (
            super(ChannelDensityGHK, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensityGHK', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityGHK')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensityGHK', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensityGHK'):
        super(ChannelDensityGHK, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityGHK')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.permeability is not None and 'permeability' not in already_processed:
            already_processed.add('permeability')
            outfile.write(' permeability=%s' % (quote_attrib(self.permeability), ))
        if self.segment_groups != "all" and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensityGHK', fromsubclass_=False, pretty_print=True):
        super(ChannelDensityGHK, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('permeability', node)
        if value is not None and 'permeability' not in already_processed:
            already_processed.add('permeability')
            self.permeability = value
            self.validate_Nml2Quantity_permeability(self.permeability)    # validate type Nml2Quantity_permeability
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            self.segments = value
            self.validate_NmlId(self.segments)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        super(ChannelDensityGHK, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ChannelDensityGHK, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ChannelDensityGHK


class ChannelDensityNernst(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('condDensity', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('segment', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, cond_density=None, segment_groups='all', segments=None, ion=None, variable_parameters=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ChannelDensityNernst, self).__init__(neuro_lex_id, id, extensiontype_, )
        self.ion_channel = _cast(None, ion_channel)
        self.cond_density = _cast(None, cond_density)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNernst)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNernst.subclass:
            return ChannelDensityNernst.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNernst(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductanceDensity_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductanceDensity_patterns_, ))
    validate_Nml2Quantity_conductanceDensity_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2$|^mS_per_cm2$|^S_per_cm2)$']]
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelDensityNernst, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensityNernst', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNernst')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensityNernst', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensityNernst'):
        super(ChannelDensityNernst, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNernst')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.cond_density is not None and 'cond_density' not in already_processed:
            already_processed.add('cond_density')
            outfile.write(' condDensity=%s' % (quote_attrib(self.cond_density), ))
        if self.segment_groups != "all" and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensityNernst', fromsubclass_=False, pretty_print=True):
        super(ChannelDensityNernst, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('condDensity', node)
        if value is not None and 'condDensity' not in already_processed:
            already_processed.add('condDensity')
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(self.cond_density)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            self.segments = value
            self.validate_NmlId(self.segments)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ChannelDensityNernst, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = 'variableParameter'
        super(ChannelDensityNernst, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelDensityNernst


class ChannelDensity(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('condDensity', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('segment', 'NonNegativeInteger', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, cond_density=None, erev=None, segment_groups='all', segments=None, ion=None, variable_parameters=None):
        self.original_tagname_ = None
        super(ChannelDensity, self).__init__(neuro_lex_id, id, )
        self.ion_channel = _cast(None, ion_channel)
        self.cond_density = _cast(None, cond_density)
        self.erev = _cast(None, erev)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensity.subclass:
            return ChannelDensity.subclass(*args_, **kwargs_)
        else:
            return ChannelDensity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductanceDensity_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductanceDensity_patterns_, ))
    validate_Nml2Quantity_conductanceDensity_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2$|^mS_per_cm2$|^S_per_cm2)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelDensity, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensity', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensity'):
        super(ChannelDensity, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensity')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.cond_density is not None and 'cond_density' not in already_processed:
            already_processed.add('cond_density')
            outfile.write(' condDensity=%s' % (quote_attrib(self.cond_density), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.segment_groups != "all" and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensity', fromsubclass_=False, pretty_print=True):
        super(ChannelDensity, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('condDensity', node)
        if value is not None and 'condDensity' not in already_processed:
            already_processed.add('condDensity')
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(self.cond_density)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.segments)    # validate type NonNegativeInteger
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        super(ChannelDensity, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = 'variableParameter'
        super(ChannelDensity, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelDensity


class ChannelDensityNonUniformGHK(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, ion=None, variable_parameters=None):
        self.original_tagname_ = None
        super(ChannelDensityNonUniformGHK, self).__init__(neuro_lex_id, id, )
        self.ion_channel = _cast(None, ion_channel)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniformGHK)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniformGHK.subclass:
            return ChannelDensityNonUniformGHK.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniformGHK(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelDensityNonUniformGHK, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensityNonUniformGHK', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNonUniformGHK')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensityNonUniformGHK', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensityNonUniformGHK'):
        super(ChannelDensityNonUniformGHK, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNonUniformGHK')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensityNonUniformGHK', fromsubclass_=False, pretty_print=True):
        super(ChannelDensityNonUniformGHK, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        super(ChannelDensityNonUniformGHK, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = 'variableParameter'
        super(ChannelDensityNonUniformGHK, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelDensityNonUniformGHK


class ChannelDensityNonUniformNernst(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, ion=None, variable_parameters=None):
        self.original_tagname_ = None
        super(ChannelDensityNonUniformNernst, self).__init__(neuro_lex_id, id, )
        self.ion_channel = _cast(None, ion_channel)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniformNernst)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniformNernst.subclass:
            return ChannelDensityNonUniformNernst.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniformNernst(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelDensityNonUniformNernst, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensityNonUniformNernst', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNonUniformNernst')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensityNonUniformNernst', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensityNonUniformNernst'):
        super(ChannelDensityNonUniformNernst, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNonUniformNernst')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensityNonUniformNernst', fromsubclass_=False, pretty_print=True):
        super(ChannelDensityNonUniformNernst, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        super(ChannelDensityNonUniformNernst, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = 'variableParameter'
        super(ChannelDensityNonUniformNernst, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelDensityNonUniformNernst


class ChannelDensityNonUniform(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, erev=None, ion=None, variable_parameters=None):
        self.original_tagname_ = None
        super(ChannelDensityNonUniform, self).__init__(neuro_lex_id, id, )
        self.ion_channel = _cast(None, ion_channel)
        self.erev = _cast(None, erev)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniform)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniform.subclass:
            return ChannelDensityNonUniform.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniform(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelDensityNonUniform, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensityNonUniform', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNonUniform')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensityNonUniform', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensityNonUniform'):
        super(ChannelDensityNonUniform, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNonUniform')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensityNonUniform', fromsubclass_=False, pretty_print=True):
        super(ChannelDensityNonUniform, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        super(ChannelDensityNonUniform, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = 'variableParameter'
        super(ChannelDensityNonUniform, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelDensityNonUniform


class ChannelPopulation(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel definition. It is added here TEMPORARILY since
    selecting all ca or na conducting channel populations/densities
    in a cell would be difficult otherwise. Also, it will make it
    easier to set the correct native simulator value for erev (e.g.
    ek for ion = k in NEURON). Currently a required attribute. It
    should be removed in the longer term, due to possible
    inconsistencies in this value and that in the ionChannel
    element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('number', 'NonNegativeInteger', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('segment', 'NonNegativeInteger', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, number=None, erev=None, segment_groups='all', segments=None, ion=None, variable_parameters=None):
        self.original_tagname_ = None
        super(ChannelPopulation, self).__init__(neuro_lex_id, id, )
        self.ion_channel = _cast(None, ion_channel)
        self.number = _cast(None, number)
        self.erev = _cast(None, erev)
        self.segment_groups = _cast(None, segment_groups)
        self.segments = _cast(None, segments)
        self.ion = _cast(None, ion)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelPopulation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelPopulation.subclass:
            return ChannelPopulation.subclass(*args_, **kwargs_)
        else:
            return ChannelPopulation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelPopulation, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelPopulation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelPopulation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelPopulation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelPopulation'):
        super(ChannelPopulation, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelPopulation')
        if self.ion_channel is not None and 'ion_channel' not in already_processed:
            already_processed.add('ion_channel')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channel), ))
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            outfile.write(' number=%s' % (quote_attrib(self.number), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.segment_groups != "all" and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelPopulation', fromsubclass_=False, pretty_print=True):
        super(ChannelPopulation, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)    # validate type NmlId
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.add('number')
            try:
                self.number = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.number < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.number)    # validate type NonNegativeInteger
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.segments)    # validate type NonNegativeInteger
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        super(ChannelPopulation, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = 'variableParameter'
        super(ChannelPopulation, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelPopulation


class Resistivity(ValueAcrossSegOrSegGroup):
    """Using a thin extension of ValueAcrossSegOrSegGroup to facilitate
    library generation (e.g. libNeuroML)"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = ValueAcrossSegOrSegGroup
    def __init__(self, value=None, segment_groups='all', segments=None):
        self.original_tagname_ = None
        super(Resistivity, self).__init__(value, segment_groups, segments, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Resistivity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Resistivity.subclass:
            return Resistivity.subclass(*args_, **kwargs_)
        else:
            return Resistivity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(Resistivity, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Resistivity', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Resistivity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Resistivity', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Resistivity'):
        super(Resistivity, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Resistivity')
    def exportChildren(self, outfile, level, namespace_='', name_='Resistivity', fromsubclass_=False, pretty_print=True):
        super(Resistivity, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Resistivity, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Resistivity, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Resistivity


class InitMembPotential(ValueAcrossSegOrSegGroup):
    """Using a thin extension of ValueAcrossSegOrSegGroup to facilitate
    library generation (e.g. libNeuroML)"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = ValueAcrossSegOrSegGroup
    def __init__(self, value=None, segment_groups='all', segments=None):
        self.original_tagname_ = None
        super(InitMembPotential, self).__init__(value, segment_groups, segments, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InitMembPotential)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InitMembPotential.subclass:
            return InitMembPotential.subclass(*args_, **kwargs_)
        else:
            return InitMembPotential(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(InitMembPotential, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InitMembPotential', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InitMembPotential')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='InitMembPotential', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InitMembPotential'):
        super(InitMembPotential, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InitMembPotential')
    def exportChildren(self, outfile, level, namespace_='', name_='InitMembPotential', fromsubclass_=False, pretty_print=True):
        super(InitMembPotential, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(InitMembPotential, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(InitMembPotential, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class InitMembPotential


class SpecificCapacitance(ValueAcrossSegOrSegGroup):
    """Using a thin extension of ValueAcrossSegOrSegGroup to facilitate
    library generation (e.g. libNeuroML)"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = ValueAcrossSegOrSegGroup
    def __init__(self, value=None, segment_groups='all', segments=None):
        self.original_tagname_ = None
        super(SpecificCapacitance, self).__init__(value, segment_groups, segments, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpecificCapacitance)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpecificCapacitance.subclass:
            return SpecificCapacitance.subclass(*args_, **kwargs_)
        else:
            return SpecificCapacitance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(SpecificCapacitance, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpecificCapacitance', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpecificCapacitance')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpecificCapacitance', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpecificCapacitance'):
        super(SpecificCapacitance, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpecificCapacitance')
    def exportChildren(self, outfile, level, namespace_='', name_='SpecificCapacitance', fromsubclass_=False, pretty_print=True):
        super(SpecificCapacitance, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SpecificCapacitance, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpecificCapacitance, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpecificCapacitance


class SpikeThresh(ValueAcrossSegOrSegGroup):
    """Using a thin extension of ValueAcrossSegOrSegGroup to facilitate
    library generation (e.g. libNeuroML)"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = ValueAcrossSegOrSegGroup
    def __init__(self, value=None, segment_groups='all', segments=None):
        self.original_tagname_ = None
        super(SpikeThresh, self).__init__(value, segment_groups, segments, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeThresh)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeThresh.subclass:
            return SpikeThresh.subclass(*args_, **kwargs_)
        else:
            return SpikeThresh(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(SpikeThresh, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeThresh', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeThresh')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SpikeThresh', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeThresh'):
        super(SpikeThresh, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeThresh')
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeThresh', fromsubclass_=False, pretty_print=True):
        super(SpikeThresh, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SpikeThresh, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeThresh, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeThresh


class BiophysicalProperties2CaPools(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""
    member_data_items_ = [
        MemberSpec_('membrane_properties2_ca_pools', 'MembraneProperties2CaPools', 0),
        MemberSpec_('intracellular_properties2_ca_pools', 'IntracellularProperties2CaPools', 0),
        MemberSpec_('extracellular_properties', 'ExtracellularProperties', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, membrane_properties2_ca_pools=None, intracellular_properties2_ca_pools=None, extracellular_properties=None):
        self.original_tagname_ = None
        super(BiophysicalProperties2CaPools, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.membrane_properties2_ca_pools = membrane_properties2_ca_pools
        self.intracellular_properties2_ca_pools = intracellular_properties2_ca_pools
        self.extracellular_properties = extracellular_properties
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiophysicalProperties2CaPools)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiophysicalProperties2CaPools.subclass:
            return BiophysicalProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return BiophysicalProperties2CaPools(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.membrane_properties2_ca_pools is not None or
            self.intracellular_properties2_ca_pools is not None or
            self.extracellular_properties is not None or
            super(BiophysicalProperties2CaPools, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BiophysicalProperties2CaPools', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BiophysicalProperties2CaPools')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BiophysicalProperties2CaPools', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BiophysicalProperties2CaPools'):
        super(BiophysicalProperties2CaPools, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BiophysicalProperties2CaPools')
    def exportChildren(self, outfile, level, namespace_='', name_='BiophysicalProperties2CaPools', fromsubclass_=False, pretty_print=True):
        super(BiophysicalProperties2CaPools, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.membrane_properties2_ca_pools is not None:
            self.membrane_properties2_ca_pools.export(outfile, level, namespace_, name_='membraneProperties2CaPools', pretty_print=pretty_print)
        if self.intracellular_properties2_ca_pools is not None:
            self.intracellular_properties2_ca_pools.export(outfile, level, namespace_, name_='intracellularProperties2CaPools', pretty_print=pretty_print)
        if self.extracellular_properties is not None:
            self.extracellular_properties.export(outfile, level, namespace_, name_='extracellularProperties', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BiophysicalProperties2CaPools, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'membraneProperties2CaPools':
            obj_ = MembraneProperties2CaPools.factory()
            obj_.build(child_)
            self.membrane_properties2_ca_pools = obj_
            obj_.original_tagname_ = 'membraneProperties2CaPools'
        elif nodeName_ == 'intracellularProperties2CaPools':
            obj_ = IntracellularProperties2CaPools.factory()
            obj_.build(child_)
            self.intracellular_properties2_ca_pools = obj_
            obj_.original_tagname_ = 'intracellularProperties2CaPools'
        elif nodeName_ == 'extracellularProperties':
            obj_ = ExtracellularProperties.factory()
            obj_.build(child_)
            self.extracellular_properties = obj_
            obj_.original_tagname_ = 'extracellularProperties'
        super(BiophysicalProperties2CaPools, self).buildChildren(child_, node, nodeName_, True)
# end class BiophysicalProperties2CaPools


class BiophysicalProperties(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""
    member_data_items_ = [
        MemberSpec_('membrane_properties', 'MembraneProperties', 0),
        MemberSpec_('intracellular_properties', 'IntracellularProperties', 0),
        MemberSpec_('extracellular_properties', 'ExtracellularProperties', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, membrane_properties=None, intracellular_properties=None, extracellular_properties=None):
        self.original_tagname_ = None
        super(BiophysicalProperties, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.membrane_properties = membrane_properties
        self.intracellular_properties = intracellular_properties
        self.extracellular_properties = extracellular_properties
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiophysicalProperties)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiophysicalProperties.subclass:
            return BiophysicalProperties.subclass(*args_, **kwargs_)
        else:
            return BiophysicalProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.membrane_properties is not None or
            self.intracellular_properties is not None or
            self.extracellular_properties is not None or
            super(BiophysicalProperties, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BiophysicalProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BiophysicalProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BiophysicalProperties', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BiophysicalProperties'):
        super(BiophysicalProperties, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BiophysicalProperties')
    def exportChildren(self, outfile, level, namespace_='', name_='BiophysicalProperties', fromsubclass_=False, pretty_print=True):
        super(BiophysicalProperties, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.membrane_properties is not None:
            self.membrane_properties.export(outfile, level, namespace_, name_='membraneProperties', pretty_print=pretty_print)
        if self.intracellular_properties is not None:
            self.intracellular_properties.export(outfile, level, namespace_, name_='intracellularProperties', pretty_print=pretty_print)
        if self.extracellular_properties is not None:
            self.extracellular_properties.export(outfile, level, namespace_, name_='extracellularProperties', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(BiophysicalProperties, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'membraneProperties':
            class_obj_ = self.get_class_obj_(child_, MembraneProperties)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.membrane_properties = obj_
            obj_.original_tagname_ = 'membraneProperties'
        elif nodeName_ == 'intracellularProperties':
            class_obj_ = self.get_class_obj_(child_, IntracellularProperties)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.intracellular_properties = obj_
            obj_.original_tagname_ = 'intracellularProperties'
        elif nodeName_ == 'extracellularProperties':
            obj_ = ExtracellularProperties.factory()
            obj_.build(child_)
            self.extracellular_properties = obj_
            obj_.original_tagname_ = 'extracellularProperties'
        super(BiophysicalProperties, self).buildChildren(child_, node, nodeName_, True)
# end class BiophysicalProperties


class InhomogeneousParameter(Base):
    member_data_items_ = [
        MemberSpec_('variable', 'xs:string', 0),
        MemberSpec_('metric', 'Metric', 0),
        MemberSpec_('proximal', 'ProximalDetails', 0),
        MemberSpec_('distal', 'DistalDetails', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, variable=None, metric=None, proximal=None, distal=None):
        self.original_tagname_ = None
        super(InhomogeneousParameter, self).__init__(neuro_lex_id, id, )
        self.variable = _cast(None, variable)
        self.metric = _cast(None, metric)
        self.proximal = proximal
        self.distal = distal
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InhomogeneousParameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InhomogeneousParameter.subclass:
            return InhomogeneousParameter.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousParameter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Metric(self, value):
        # Validate type Metric, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['Path Length from root']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on Metric' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.proximal is not None or
            self.distal is not None or
            super(InhomogeneousParameter, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InhomogeneousParameter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InhomogeneousParameter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='InhomogeneousParameter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InhomogeneousParameter'):
        super(InhomogeneousParameter, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InhomogeneousParameter')
        if self.variable is not None and 'variable' not in already_processed:
            already_processed.add('variable')
            outfile.write(' variable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.variable), input_name='variable')), ))
        if self.metric is not None and 'metric' not in already_processed:
            already_processed.add('metric')
            outfile.write(' metric=%s' % (quote_attrib(self.metric), ))
    def exportChildren(self, outfile, level, namespace_='', name_='InhomogeneousParameter', fromsubclass_=False, pretty_print=True):
        super(InhomogeneousParameter, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.proximal is not None:
            self.proximal.export(outfile, level, namespace_, name_='proximal', pretty_print=pretty_print)
        if self.distal is not None:
            self.distal.export(outfile, level, namespace_, name_='distal', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('variable', node)
        if value is not None and 'variable' not in already_processed:
            already_processed.add('variable')
            self.variable = value
        value = find_attr_value_('metric', node)
        if value is not None and 'metric' not in already_processed:
            already_processed.add('metric')
            self.metric = value
            self.validate_Metric(self.metric)    # validate type Metric
        super(InhomogeneousParameter, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'proximal':
            obj_ = ProximalDetails.factory()
            obj_.build(child_)
            self.proximal = obj_
            obj_.original_tagname_ = 'proximal'
        elif nodeName_ == 'distal':
            obj_ = DistalDetails.factory()
            obj_.build(child_)
            self.distal = obj_
            obj_.original_tagname_ = 'distal'
        super(InhomogeneousParameter, self).buildChildren(child_, node, nodeName_, True)
# end class InhomogeneousParameter


class SegmentGroup(Base):
    member_data_items_ = [
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('properties', 'Property', 1),
        MemberSpec_('annotation', 'Annotation', 0),
        MemberSpec_('members', 'Member', 1),
        MemberSpec_('includes', 'Include', 1),
        MemberSpec_('paths', 'Path', 1),
        MemberSpec_('sub_trees', 'SubTree', 1),
        MemberSpec_('inhomogeneous_parameters', 'InhomogeneousParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, notes=None, properties=None, annotation=None, members=None, includes=None, paths=None, sub_trees=None, inhomogeneous_parameters=None):
        self.original_tagname_ = None
        super(SegmentGroup, self).__init__(neuro_lex_id, id, )
        self.notes = notes
        self.validate_Notes(self.notes)
        if properties is None:
            self.properties = []
        else:
            self.properties = properties
        self.annotation = annotation
        if members is None:
            self.members = []
        else:
            self.members = members
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        if paths is None:
            self.paths = []
        else:
            self.paths = paths
        if sub_trees is None:
            self.sub_trees = []
        else:
            self.sub_trees = sub_trees
        if inhomogeneous_parameters is None:
            self.inhomogeneous_parameters = []
        else:
            self.inhomogeneous_parameters = inhomogeneous_parameters
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SegmentGroup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentGroup.subclass:
            return SegmentGroup.subclass(*args_, **kwargs_)
        else:
            return SegmentGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.properties or
            self.annotation is not None or
            self.members or
            self.includes or
            self.paths or
            self.sub_trees or
            self.inhomogeneous_parameters or
            super(SegmentGroup, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SegmentGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SegmentGroup', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SegmentGroup'):
        super(SegmentGroup, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentGroup')
    def exportChildren(self, outfile, level, namespace_='', name_='SegmentGroup', fromsubclass_=False, pretty_print=True):
        super(SegmentGroup, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        for property_ in self.properties:
            property_.export(outfile, level, namespace_, name_='property', pretty_print=pretty_print)
        if self.annotation is not None:
            self.annotation.export(outfile, level, namespace_, name_='annotation', pretty_print=pretty_print)
        for member_ in self.members:
            member_.export(outfile, level, namespace_, name_='member', pretty_print=pretty_print)
        for include_ in self.includes:
            include_.export(outfile, level, namespace_, name_='include', pretty_print=pretty_print)
        for path_ in self.paths:
            path_.export(outfile, level, namespace_, name_='path', pretty_print=pretty_print)
        for subTree_ in self.sub_trees:
            subTree_.export(outfile, level, namespace_, name_='subTree', pretty_print=pretty_print)
        for inhomogeneousParameter_ in self.inhomogeneous_parameters:
            inhomogeneousParameter_.export(outfile, level, namespace_, name_='inhomogeneousParameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SegmentGroup, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'property':
            obj_ = Property.factory()
            obj_.build(child_)
            self.properties.append(obj_)
            obj_.original_tagname_ = 'property'
        elif nodeName_ == 'annotation':
            obj_ = Annotation.factory()
            obj_.build(child_)
            self.annotation = obj_
            obj_.original_tagname_ = 'annotation'
        elif nodeName_ == 'member':
            obj_ = Member.factory()
            obj_.build(child_)
            self.members.append(obj_)
            obj_.original_tagname_ = 'member'
        elif nodeName_ == 'include':
            obj_ = Include.factory()
            obj_.build(child_)
            self.includes.append(obj_)
            obj_.original_tagname_ = 'include'
        elif nodeName_ == 'path':
            obj_ = Path.factory()
            obj_.build(child_)
            self.paths.append(obj_)
            obj_.original_tagname_ = 'path'
        elif nodeName_ == 'subTree':
            obj_ = SubTree.factory()
            obj_.build(child_)
            self.sub_trees.append(obj_)
            obj_.original_tagname_ = 'subTree'
        elif nodeName_ == 'inhomogeneousParameter':
            obj_ = InhomogeneousParameter.factory()
            obj_.build(child_)
            self.inhomogeneous_parameters.append(obj_)
            obj_.original_tagname_ = 'inhomogeneousParameter'
        super(SegmentGroup, self).buildChildren(child_, node, nodeName_, True)
# end class SegmentGroup


class Segment(BaseNonNegativeIntegerId):
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('parent', 'SegmentParent', 0),
        MemberSpec_('proximal', 'Point3DWithDiam', 0),
        MemberSpec_('distal', 'Point3DWithDiam', 0),
    ]
    subclass = None
    superclass = BaseNonNegativeIntegerId
    def __init__(self, neuro_lex_id=None, id=None, name=None, parent=None, proximal=None, distal=None):
        self.original_tagname_ = None
        super(Segment, self).__init__(neuro_lex_id, id, )
        self.name = _cast(None, name)
        self.parent = parent
        self.proximal = proximal
        self.distal = distal
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Segment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Segment.subclass:
            return Segment.subclass(*args_, **kwargs_)
        else:
            return Segment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.parent is not None or
            self.proximal is not None or
            self.distal is not None or
            super(Segment, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Segment', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Segment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Segment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Segment'):
        super(Segment, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Segment')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Segment', fromsubclass_=False, pretty_print=True):
        super(Segment, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.parent is not None:
            self.parent.export(outfile, level, namespace_, name_='parent', pretty_print=pretty_print)
        if self.proximal is not None:
            self.proximal.export(outfile, level, namespace_, name_='proximal', pretty_print=pretty_print)
        if self.distal is not None:
            self.distal.export(outfile, level, namespace_, name_='distal', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(Segment, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parent':
            obj_ = SegmentParent.factory()
            obj_.build(child_)
            self.parent = obj_
            obj_.original_tagname_ = 'parent'
        elif nodeName_ == 'proximal':
            obj_ = Point3DWithDiam.factory()
            obj_.build(child_)
            self.proximal = obj_
            obj_.original_tagname_ = 'proximal'
        elif nodeName_ == 'distal':
            obj_ = Point3DWithDiam.factory()
            obj_.build(child_)
            self.distal = obj_
            obj_.original_tagname_ = 'distal'
        super(Segment, self).buildChildren(child_, node, nodeName_, True)
    @property
    def length(self):
        prox_x = self.proximal.x
        prox_y = self.proximal.y
        prox_z = self.proximal.z

        dist_x = self.distal.x
        dist_y = self.distal.y
        dist_z = self.distal.z

        length = ((prox_x-dist_x)**2 + (prox_y-dist_y)**2 + (prox_z-dist_z)**2)**(0.5)

        return length
        
    def __str__(self):
        
        return "<Segment|"+str(self.id)+"|"+self.name+">"
        
    def __repr__(self):
    
        return str(self)
    
    @property
    def volume(self):
        from math import pi

        prox_rad = self.proximal.diameter/2.0
        dist_rad = self.distal.diameter/2.0
        length = self.length

        volume = (pi/3)*length*(prox_rad**2+dist_rad**2+prox_rad*dist_rad)

        return volume
    
    @property
    def surface_area(self):
        from math import pi
        from math import sqrt

        prox_rad = self.proximal.diameter/2.0
        dist_rad = self.distal.diameter/2.0
        length = self.length

        surface_area = pi*(prox_rad+dist_rad)*sqrt((prox_rad-dist_rad)**2+length**2)
        
        return surface_area
    # end class Segment


class Morphology(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""
    member_data_items_ = [
        MemberSpec_('segments', 'Segment', 1),
        MemberSpec_('segment_groups', 'SegmentGroup', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, segments=None, segment_groups=None):
        self.original_tagname_ = None
        super(Morphology, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        if segments is None:
            self.segments = []
        else:
            self.segments = segments
        if segment_groups is None:
            self.segment_groups = []
        else:
            self.segment_groups = segment_groups
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Morphology)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Morphology.subclass:
            return Morphology.subclass(*args_, **kwargs_)
        else:
            return Morphology(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.segments or
            self.segment_groups or
            super(Morphology, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Morphology', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Morphology')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Morphology', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Morphology'):
        super(Morphology, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Morphology')
    def exportChildren(self, outfile, level, namespace_='', name_='Morphology', fromsubclass_=False, pretty_print=True):
        super(Morphology, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for segment_ in self.segments:
            segment_.export(outfile, level, namespace_, name_='segment', pretty_print=pretty_print)
        for segmentGroup_ in self.segment_groups:
            segmentGroup_.export(outfile, level, namespace_, name_='segmentGroup', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Morphology, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'segment':
            obj_ = Segment.factory()
            obj_.build(child_)
            self.segments.append(obj_)
            obj_.original_tagname_ = 'segment'
        elif nodeName_ == 'segmentGroup':
            obj_ = SegmentGroup.factory()
            obj_.build(child_)
            self.segment_groups.append(obj_)
            obj_.original_tagname_ = 'segmentGroup'
        super(Morphology, self).buildChildren(child_, node, nodeName_, True)
    @property
    def num_segments(self):
        return len(self.segments)
# end class Morphology


class BaseCell(Standalone):
    member_data_items_ = [
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseCell.subclass:
            return BaseCell.subclass(*args_, **kwargs_)
        else:
            return BaseCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BaseCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseCell'):
        super(BaseCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCell')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseCell', fromsubclass_=False, pretty_print=True):
        super(BaseCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseCell


class BaseSynapse(Standalone):
    member_data_items_ = [
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseSynapse.subclass:
            return BaseSynapse.subclass(*args_, **kwargs_)
        else:
            return BaseSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BaseSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseSynapse'):
        super(BaseSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseSynapse')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseSynapse', fromsubclass_=False, pretty_print=True):
        super(BaseSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseSynapse


class FixedFactorConcentrationModel(Standalone):
    """Should not be required, as it's present on the species element!"""
    member_data_items_ = [
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('restingConc', 'Nml2Quantity_concentration', 0),
        MemberSpec_('decayConstant', 'Nml2Quantity_time', 0),
        MemberSpec_('rho', 'Nml2Quantity_rhoFactor', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, ion=None, resting_conc=None, decay_constant=None, rho=None):
        self.original_tagname_ = None
        super(FixedFactorConcentrationModel, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.ion = _cast(None, ion)
        self.resting_conc = _cast(None, resting_conc)
        self.decay_constant = _cast(None, decay_constant)
        self.rho = _cast(None, rho)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FixedFactorConcentrationModel)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FixedFactorConcentrationModel.subclass:
            return FixedFactorConcentrationModel.subclass(*args_, **kwargs_)
        else:
            return FixedFactorConcentrationModel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_concentration_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_concentration_patterns_, ))
    validate_Nml2Quantity_concentration_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3$|^mol_per_cm3$|^M$|^mM)$']]
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_rhoFactor(self, value):
        # Validate type Nml2Quantity_rhoFactor, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_rhoFactor_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_rhoFactor_patterns_, ))
    validate_Nml2Quantity_rhoFactor_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m_per_A_per_s$|^mol_per_cm_per_uA_per_ms)$']]
    def hasContent_(self):
        if (
            super(FixedFactorConcentrationModel, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FixedFactorConcentrationModel', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FixedFactorConcentrationModel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FixedFactorConcentrationModel', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FixedFactorConcentrationModel'):
        super(FixedFactorConcentrationModel, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FixedFactorConcentrationModel')
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.resting_conc is not None and 'resting_conc' not in already_processed:
            already_processed.add('resting_conc')
            outfile.write(' restingConc=%s' % (quote_attrib(self.resting_conc), ))
        if self.decay_constant is not None and 'decay_constant' not in already_processed:
            already_processed.add('decay_constant')
            outfile.write(' decayConstant=%s' % (quote_attrib(self.decay_constant), ))
        if self.rho is not None and 'rho' not in already_processed:
            already_processed.add('rho')
            outfile.write(' rho=%s' % (quote_attrib(self.rho), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FixedFactorConcentrationModel', fromsubclass_=False, pretty_print=True):
        super(FixedFactorConcentrationModel, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('restingConc', node)
        if value is not None and 'restingConc' not in already_processed:
            already_processed.add('restingConc')
            self.resting_conc = value
            self.validate_Nml2Quantity_concentration(self.resting_conc)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('decayConstant', node)
        if value is not None and 'decayConstant' not in already_processed:
            already_processed.add('decayConstant')
            self.decay_constant = value
            self.validate_Nml2Quantity_time(self.decay_constant)    # validate type Nml2Quantity_time
        value = find_attr_value_('rho', node)
        if value is not None and 'rho' not in already_processed:
            already_processed.add('rho')
            self.rho = value
            self.validate_Nml2Quantity_rhoFactor(self.rho)    # validate type Nml2Quantity_rhoFactor
        super(FixedFactorConcentrationModel, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FixedFactorConcentrationModel, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FixedFactorConcentrationModel


class DecayingPoolConcentrationModel(Standalone):
    """Should not be required, as it's present on the species element!"""
    member_data_items_ = [
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('restingConc', 'Nml2Quantity_concentration', 0),
        MemberSpec_('decayConstant', 'Nml2Quantity_time', 0),
        MemberSpec_('shellThickness', 'Nml2Quantity_length', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, ion=None, resting_conc=None, decay_constant=None, shell_thickness=None, extensiontype_=None):
        self.original_tagname_ = None
        super(DecayingPoolConcentrationModel, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.ion = _cast(None, ion)
        self.resting_conc = _cast(None, resting_conc)
        self.decay_constant = _cast(None, decay_constant)
        self.shell_thickness = _cast(None, shell_thickness)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DecayingPoolConcentrationModel)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DecayingPoolConcentrationModel.subclass:
            return DecayingPoolConcentrationModel.subclass(*args_, **kwargs_)
        else:
            return DecayingPoolConcentrationModel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_concentration_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_concentration_patterns_, ))
    validate_Nml2Quantity_concentration_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3$|^mol_per_cm3$|^M$|^mM)$']]
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_length(self, value):
        # Validate type Nml2Quantity_length, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_length_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_length_patterns_, ))
    validate_Nml2Quantity_length_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(m$|^cm$|^um)$']]
    def hasContent_(self):
        if (
            super(DecayingPoolConcentrationModel, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DecayingPoolConcentrationModel', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DecayingPoolConcentrationModel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DecayingPoolConcentrationModel', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DecayingPoolConcentrationModel'):
        super(DecayingPoolConcentrationModel, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DecayingPoolConcentrationModel')
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.resting_conc is not None and 'resting_conc' not in already_processed:
            already_processed.add('resting_conc')
            outfile.write(' restingConc=%s' % (quote_attrib(self.resting_conc), ))
        if self.decay_constant is not None and 'decay_constant' not in already_processed:
            already_processed.add('decay_constant')
            outfile.write(' decayConstant=%s' % (quote_attrib(self.decay_constant), ))
        if self.shell_thickness is not None and 'shell_thickness' not in already_processed:
            already_processed.add('shell_thickness')
            outfile.write(' shellThickness=%s' % (quote_attrib(self.shell_thickness), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='DecayingPoolConcentrationModel', fromsubclass_=False, pretty_print=True):
        super(DecayingPoolConcentrationModel, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('restingConc', node)
        if value is not None and 'restingConc' not in already_processed:
            already_processed.add('restingConc')
            self.resting_conc = value
            self.validate_Nml2Quantity_concentration(self.resting_conc)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('decayConstant', node)
        if value is not None and 'decayConstant' not in already_processed:
            already_processed.add('decayConstant')
            self.decay_constant = value
            self.validate_Nml2Quantity_time(self.decay_constant)    # validate type Nml2Quantity_time
        value = find_attr_value_('shellThickness', node)
        if value is not None and 'shellThickness' not in already_processed:
            already_processed.add('shellThickness')
            self.shell_thickness = value
            self.validate_Nml2Quantity_length(self.shell_thickness)    # validate type Nml2Quantity_length
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(DecayingPoolConcentrationModel, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(DecayingPoolConcentrationModel, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class DecayingPoolConcentrationModel


class GateFractionalSubgate(Base):
    member_data_items_ = [
        MemberSpec_('fractionalConductance', 'Nml2Quantity_none', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
        MemberSpec_('time_course', 'HHTime', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, fractional_conductance=None, notes=None, q10_settings=None, steady_state=None, time_course=None):
        self.original_tagname_ = None
        super(GateFractionalSubgate, self).__init__(neuro_lex_id, id, )
        self.fractional_conductance = _cast(None, fractional_conductance)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.steady_state = steady_state
        self.time_course = time_course
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateFractionalSubgate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateFractionalSubgate.subclass:
            return GateFractionalSubgate.subclass(*args_, **kwargs_)
        else:
            return GateFractionalSubgate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.steady_state is not None or
            self.time_course is not None or
            super(GateFractionalSubgate, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateFractionalSubgate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateFractionalSubgate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateFractionalSubgate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateFractionalSubgate'):
        super(GateFractionalSubgate, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateFractionalSubgate')
        if self.fractional_conductance is not None and 'fractional_conductance' not in already_processed:
            already_processed.add('fractional_conductance')
            outfile.write(' fractionalConductance=%s' % (quote_attrib(self.fractional_conductance), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateFractionalSubgate', fromsubclass_=False, pretty_print=True):
        super(GateFractionalSubgate, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fractionalConductance', node)
        if value is not None and 'fractionalConductance' not in already_processed:
            already_processed.add('fractionalConductance')
            self.fractional_conductance = value
            self.validate_Nml2Quantity_none(self.fractional_conductance)    # validate type Nml2Quantity_none
        super(GateFractionalSubgate, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = 'steadyState'
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = 'timeCourse'
        super(GateFractionalSubgate, self).buildChildren(child_, node, nodeName_, True)
# end class GateFractionalSubgate


class GateFractional(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('sub_gates', 'GateFractionalSubgate', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, q10_settings=None, sub_gates=None):
        self.original_tagname_ = None
        super(GateFractional, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        if sub_gates is None:
            self.sub_gates = []
        else:
            self.sub_gates = sub_gates
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateFractional)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateFractional.subclass:
            return GateFractional.subclass(*args_, **kwargs_)
        else:
            return GateFractional(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.sub_gates or
            super(GateFractional, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateFractional', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateFractional')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateFractional', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateFractional'):
        super(GateFractional, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateFractional')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateFractional', fromsubclass_=False, pretty_print=True):
        super(GateFractional, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        for subGate_ in self.sub_gates:
            subGate_.export(outfile, level, namespace_, name_='subGate', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateFractional, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'subGate':
            obj_ = GateFractionalSubgate.factory()
            obj_.build(child_)
            self.sub_gates.append(obj_)
            obj_.original_tagname_ = 'subGate'
        super(GateFractional, self).buildChildren(child_, node, nodeName_, True)
# end class GateFractional


class GateHHInstantaneous(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, steady_state=None):
        self.original_tagname_ = None
        super(GateHHInstantaneous, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.steady_state = steady_state
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHInstantaneous)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHInstantaneous.subclass:
            return GateHHInstantaneous.subclass(*args_, **kwargs_)
        else:
            return GateHHInstantaneous(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.steady_state is not None or
            super(GateHHInstantaneous, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHInstantaneous', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHInstantaneous')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateHHInstantaneous', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHInstantaneous'):
        super(GateHHInstantaneous, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHInstantaneous')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHInstantaneous', fromsubclass_=False, pretty_print=True):
        super(GateHHInstantaneous, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateHHInstantaneous, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = 'steadyState'
        super(GateHHInstantaneous, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHInstantaneous


class GateHHRatesInf(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None, steady_state=None):
        self.original_tagname_ = None
        super(GateHHRatesInf, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.steady_state = steady_state
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHRatesInf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRatesInf.subclass:
            return GateHHRatesInf.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesInf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            self.steady_state is not None or
            super(GateHHRatesInf, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHRatesInf', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesInf')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateHHRatesInf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHRatesInf'):
        super(GateHHRatesInf, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesInf')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHRatesInf', fromsubclass_=False, pretty_print=True):
        super(GateHHRatesInf, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateHHRatesInf, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = 'forwardRate'
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = 'reverseRate'
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = 'steadyState'
        super(GateHHRatesInf, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHRatesInf


class GateHHRatesTau(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
        MemberSpec_('time_course', 'HHTime', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None, time_course=None):
        self.original_tagname_ = None
        super(GateHHRatesTau, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHRatesTau)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRatesTau.subclass:
            return GateHHRatesTau.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesTau(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            self.time_course is not None or
            super(GateHHRatesTau, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHRatesTau', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesTau')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateHHRatesTau', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHRatesTau'):
        super(GateHHRatesTau, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesTau')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHRatesTau', fromsubclass_=False, pretty_print=True):
        super(GateHHRatesTau, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateHHRatesTau, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = 'forwardRate'
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = 'reverseRate'
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = 'timeCourse'
        super(GateHHRatesTau, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHRatesTau


class GateHHRatesTauInf(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
        MemberSpec_('time_course', 'HHTime', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None, time_course=None, steady_state=None):
        self.original_tagname_ = None
        super(GateHHRatesTauInf, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course
        self.steady_state = steady_state
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHRatesTauInf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRatesTauInf.subclass:
            return GateHHRatesTauInf.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesTauInf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            self.time_course is not None or
            self.steady_state is not None or
            super(GateHHRatesTauInf, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHRatesTauInf', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesTauInf')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateHHRatesTauInf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHRatesTauInf'):
        super(GateHHRatesTauInf, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesTauInf')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHRatesTauInf', fromsubclass_=False, pretty_print=True):
        super(GateHHRatesTauInf, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateHHRatesTauInf, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = 'forwardRate'
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = 'reverseRate'
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = 'timeCourse'
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = 'steadyState'
        super(GateHHRatesTauInf, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHRatesTauInf


class GateHHTauInf(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('time_course', 'HHTime', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, q10_settings=None, time_course=None, steady_state=None):
        self.original_tagname_ = None
        super(GateHHTauInf, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.time_course = time_course
        self.steady_state = steady_state
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHTauInf)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHTauInf.subclass:
            return GateHHTauInf.subclass(*args_, **kwargs_)
        else:
            return GateHHTauInf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.time_course is not None or
            self.steady_state is not None or
            super(GateHHTauInf, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHTauInf', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHTauInf')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateHHTauInf', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHTauInf'):
        super(GateHHTauInf, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHTauInf')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHTauInf', fromsubclass_=False, pretty_print=True):
        super(GateHHTauInf, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateHHTauInf, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = 'timeCourse'
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = 'steadyState'
        super(GateHHTauInf, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHTauInf


class GateHHRates(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None):
        self.original_tagname_ = None
        super(GateHHRates, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHRates)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHRates.subclass:
            return GateHHRates.subclass(*args_, **kwargs_)
        else:
            return GateHHRates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            super(GateHHRates, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHRates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateHHRates', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHRates'):
        super(GateHHRates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRates')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHRates', fromsubclass_=False, pretty_print=True):
        super(GateHHRates, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateHHRates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = 'forwardRate'
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = 'reverseRate'
        super(GateHHRates, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHRates


class GateHHUndetermined(Base):
    """Note all sub elements for gateHHrates, gateHHratesTau,
    gateFractional etc. allowed here. Which are valid should be
    constrained by what type is set"""
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('type', 'gateTypes', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
        MemberSpec_('time_course', 'HHTime', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
        MemberSpec_('sub_gates', 'GateFractionalSubgate', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, type=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None, time_course=None, steady_state=None, sub_gates=None):
        self.original_tagname_ = None
        super(GateHHUndetermined, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.type = _cast(None, type)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course
        self.steady_state = steady_state
        if sub_gates is None:
            self.sub_gates = []
        else:
            self.sub_gates = sub_gates
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateHHUndetermined)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateHHUndetermined.subclass:
            return GateHHUndetermined.subclass(*args_, **kwargs_)
        else:
            return GateHHUndetermined(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_gateTypes(self, value):
        # Validate type gateTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['gateHHrates', 'gateHHratesTau', 'gateHHtauInf', 'gateHHratesInf', 'gateHHratesTauInf', 'gateHHInstantaneous', 'gateKS', 'gateFractional']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on gateTypes' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            self.time_course is not None or
            self.steady_state is not None or
            self.sub_gates or
            super(GateHHUndetermined, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHUndetermined', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHUndetermined')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateHHUndetermined', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHUndetermined'):
        super(GateHHUndetermined, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHUndetermined')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHUndetermined', fromsubclass_=False, pretty_print=True):
        super(GateHHUndetermined, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
        for subGate_ in self.sub_gates:
            subGate_.export(outfile, level, namespace_, name_='subGate', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_gateTypes(self.type)    # validate type gateTypes
        super(GateHHUndetermined, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
            obj_.original_tagname_ = 'forwardRate'
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
            obj_.original_tagname_ = 'reverseRate'
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = 'timeCourse'
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = 'steadyState'
        elif nodeName_ == 'subGate':
            obj_ = GateFractionalSubgate.factory()
            obj_.build(child_)
            self.sub_gates.append(obj_)
            obj_.original_tagname_ = 'subGate'
        super(GateHHUndetermined, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHUndetermined


class GateKS(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'PositiveInteger', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('closed_states', 'ClosedState', 1),
        MemberSpec_('open_states', 'OpenState', 1),
        MemberSpec_('forward_transition', 'ForwardTransition', 1),
        MemberSpec_('reverse_transition', 'ReverseTransition', 1),
        MemberSpec_('tau_inf_transition', 'TauInfTransition', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=None, notes=None, q10_settings=None, closed_states=None, open_states=None, forward_transition=None, reverse_transition=None, tau_inf_transition=None):
        self.original_tagname_ = None
        super(GateKS, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(None, instances)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.q10_settings = q10_settings
        if closed_states is None:
            self.closed_states = []
        else:
            self.closed_states = closed_states
        if open_states is None:
            self.open_states = []
        else:
            self.open_states = open_states
        if forward_transition is None:
            self.forward_transition = []
        else:
            self.forward_transition = forward_transition
        if reverse_transition is None:
            self.reverse_transition = []
        else:
            self.reverse_transition = reverse_transition
        if tau_inf_transition is None:
            self.tau_inf_transition = []
        else:
            self.tau_inf_transition = tau_inf_transition
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GateKS)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GateKS.subclass:
            return GateKS.subclass(*args_, **kwargs_)
        else:
            return GateKS(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_PositiveInteger(self, value):
        # Validate type PositiveInteger, a restriction on xs:positiveInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.closed_states or
            self.open_states or
            self.forward_transition or
            self.reverse_transition or
            self.tau_inf_transition or
            super(GateKS, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateKS', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateKS')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GateKS', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateKS'):
        super(GateKS, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateKS')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances=%s' % (quote_attrib(self.instances), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateKS', fromsubclass_=False, pretty_print=True):
        super(GateKS, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.notes), input_name='notes')), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        for closedState_ in self.closed_states:
            closedState_.export(outfile, level, namespace_, name_='closedState', pretty_print=pretty_print)
        for openState_ in self.open_states:
            openState_.export(outfile, level, namespace_, name_='openState', pretty_print=pretty_print)
        for forwardTransition_ in self.forward_transition:
            forwardTransition_.export(outfile, level, namespace_, name_='forwardTransition', pretty_print=pretty_print)
        for reverseTransition_ in self.reverse_transition:
            reverseTransition_.export(outfile, level, namespace_, name_='reverseTransition', pretty_print=pretty_print)
        for tauInfTransition_ in self.tau_inf_transition:
            tauInfTransition_.export(outfile, level, namespace_, name_='tauInfTransition', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.instances <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_PositiveInteger(self.instances)    # validate type PositiveInteger
        super(GateKS, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
            obj_.original_tagname_ = 'q10Settings'
        elif nodeName_ == 'closedState':
            obj_ = ClosedState.factory()
            obj_.build(child_)
            self.closed_states.append(obj_)
            obj_.original_tagname_ = 'closedState'
        elif nodeName_ == 'openState':
            obj_ = OpenState.factory()
            obj_.build(child_)
            self.open_states.append(obj_)
            obj_.original_tagname_ = 'openState'
        elif nodeName_ == 'forwardTransition':
            obj_ = ForwardTransition.factory()
            obj_.build(child_)
            self.forward_transition.append(obj_)
            obj_.original_tagname_ = 'forwardTransition'
        elif nodeName_ == 'reverseTransition':
            obj_ = ReverseTransition.factory()
            obj_.build(child_)
            self.reverse_transition.append(obj_)
            obj_.original_tagname_ = 'reverseTransition'
        elif nodeName_ == 'tauInfTransition':
            obj_ = TauInfTransition.factory()
            obj_.build(child_)
            self.tau_inf_transition.append(obj_)
            obj_.original_tagname_ = 'tauInfTransition'
        super(GateKS, self).buildChildren(child_, node, nodeName_, True)
# end class GateKS


class TauInfTransition(Base):
    member_data_items_ = [
        MemberSpec_('from', 'NmlId', 0),
        MemberSpec_('to', 'NmlId', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
        MemberSpec_('time_course', 'HHTime', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, from_=None, to=None, steady_state=None, time_course=None):
        self.original_tagname_ = None
        super(TauInfTransition, self).__init__(neuro_lex_id, id, )
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        self.steady_state = steady_state
        self.time_course = time_course
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TauInfTransition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TauInfTransition.subclass:
            return TauInfTransition.subclass(*args_, **kwargs_)
        else:
            return TauInfTransition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.steady_state is not None or
            self.time_course is not None or
            super(TauInfTransition, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TauInfTransition', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TauInfTransition')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TauInfTransition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TauInfTransition'):
        super(TauInfTransition, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TauInfTransition')
        if self.from_ is not None and 'from_' not in already_processed:
            already_processed.add('from_')
            outfile.write(' from=%s' % (quote_attrib(self.from_), ))
        if self.to is not None and 'to' not in already_processed:
            already_processed.add('to')
            outfile.write(' to=%s' % (quote_attrib(self.to), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TauInfTransition', fromsubclass_=False, pretty_print=True):
        super(TauInfTransition, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('from', node)
        if value is not None and 'from' not in already_processed:
            already_processed.add('from')
            self.from_ = value
            self.validate_NmlId(self.from_)    # validate type NmlId
        value = find_attr_value_('to', node)
        if value is not None and 'to' not in already_processed:
            already_processed.add('to')
            self.to = value
            self.validate_NmlId(self.to)    # validate type NmlId
        super(TauInfTransition, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
            obj_.original_tagname_ = 'steadyState'
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
            obj_.original_tagname_ = 'timeCourse'
        super(TauInfTransition, self).buildChildren(child_, node, nodeName_, True)
# end class TauInfTransition


class ReverseTransition(Base):
    member_data_items_ = [
        MemberSpec_('from', 'NmlId', 0),
        MemberSpec_('to', 'NmlId', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, from_=None, to=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(ReverseTransition, self).__init__(neuro_lex_id, id, )
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReverseTransition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReverseTransition.subclass:
            return ReverseTransition.subclass(*args_, **kwargs_)
        else:
            return ReverseTransition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(ReverseTransition, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReverseTransition', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReverseTransition')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReverseTransition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReverseTransition'):
        super(ReverseTransition, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReverseTransition')
        if self.from_ is not None and 'from_' not in already_processed:
            already_processed.add('from_')
            outfile.write(' from=%s' % (quote_attrib(self.from_), ))
        if self.to is not None and 'to' not in already_processed:
            already_processed.add('to')
            outfile.write(' to=%s' % (quote_attrib(self.to), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ReverseTransition', fromsubclass_=False, pretty_print=True):
        super(ReverseTransition, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('from', node)
        if value is not None and 'from' not in already_processed:
            already_processed.add('from')
            self.from_ = value
            self.validate_NmlId(self.from_)    # validate type NmlId
        value = find_attr_value_('to', node)
        if value is not None and 'to' not in already_processed:
            already_processed.add('to')
            self.to = value
            self.validate_NmlId(self.to)    # validate type NmlId
        super(ReverseTransition, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'ReverseTransition')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(ReverseTransition, self).buildChildren(child_, node, nodeName_, True)
# end class ReverseTransition


class ForwardTransition(Base):
    member_data_items_ = [
        MemberSpec_('from', 'NmlId', 0),
        MemberSpec_('to', 'NmlId', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, from_=None, to=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(ForwardTransition, self).__init__(neuro_lex_id, id, )
        self.from_ = _cast(None, from_)
        self.to = _cast(None, to)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ForwardTransition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ForwardTransition.subclass:
            return ForwardTransition.subclass(*args_, **kwargs_)
        else:
            return ForwardTransition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(ForwardTransition, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ForwardTransition', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ForwardTransition')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ForwardTransition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ForwardTransition'):
        super(ForwardTransition, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ForwardTransition')
        if self.from_ is not None and 'from_' not in already_processed:
            already_processed.add('from_')
            outfile.write(' from=%s' % (quote_attrib(self.from_), ))
        if self.to is not None and 'to' not in already_processed:
            already_processed.add('to')
            outfile.write(' to=%s' % (quote_attrib(self.to), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ForwardTransition', fromsubclass_=False, pretty_print=True):
        super(ForwardTransition, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('from', node)
        if value is not None and 'from' not in already_processed:
            already_processed.add('from')
            self.from_ = value
            self.validate_NmlId(self.from_)    # validate type NmlId
        value = find_attr_value_('to', node)
        if value is not None and 'to' not in already_processed:
            already_processed.add('to')
            self.to = value
            self.validate_NmlId(self.to)    # validate type NmlId
        super(ForwardTransition, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'ForwardTransition')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(ForwardTransition, self).buildChildren(child_, node, nodeName_, True)
# end class ForwardTransition


class OpenState(Base):
    member_data_items_ = [
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None):
        self.original_tagname_ = None
        super(OpenState, self).__init__(neuro_lex_id, id, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OpenState)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OpenState.subclass:
            return OpenState.subclass(*args_, **kwargs_)
        else:
            return OpenState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(OpenState, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OpenState', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OpenState')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OpenState', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OpenState'):
        super(OpenState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OpenState')
    def exportChildren(self, outfile, level, namespace_='', name_='OpenState', fromsubclass_=False, pretty_print=True):
        super(OpenState, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OpenState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OpenState, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OpenState


class ClosedState(Base):
    member_data_items_ = [
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None):
        self.original_tagname_ = None
        super(ClosedState, self).__init__(neuro_lex_id, id, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ClosedState)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ClosedState.subclass:
            return ClosedState.subclass(*args_, **kwargs_)
        else:
            return ClosedState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ClosedState, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ClosedState', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ClosedState')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ClosedState', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ClosedState'):
        super(ClosedState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ClosedState')
    def exportChildren(self, outfile, level, namespace_='', name_='ClosedState', fromsubclass_=False, pretty_print=True):
        super(ClosedState, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ClosedState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ClosedState, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ClosedState


class IonChannelKS(Standalone):
    """Kinetic scheme based ion channel."""
    member_data_items_ = [
        MemberSpec_('species', 'NmlId', 0),
        MemberSpec_('conductance', 'Nml2Quantity_conductance', 0),
        MemberSpec_('gate_kses', 'GateKS', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, species=None, conductance=None, gate_kses=None):
        self.original_tagname_ = None
        super(IonChannelKS, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.species = _cast(None, species)
        self.conductance = _cast(None, conductance)
        if gate_kses is None:
            self.gate_kses = []
        else:
            self.gate_kses = gate_kses
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IonChannelKS)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IonChannelKS.subclass:
            return IonChannelKS.subclass(*args_, **kwargs_)
        else:
            return IonChannelKS(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def hasContent_(self):
        if (
            self.gate_kses or
            super(IonChannelKS, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IonChannelKS', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannelKS')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IonChannelKS', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IonChannelKS'):
        super(IonChannelKS, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannelKS')
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            outfile.write(' species=%s' % (quote_attrib(self.species), ))
        if self.conductance is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            outfile.write(' conductance=%s' % (quote_attrib(self.conductance), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IonChannelKS', fromsubclass_=False, pretty_print=True):
        super(IonChannelKS, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for gateKS_ in self.gate_kses:
            gateKS_.export(outfile, level, namespace_, name_='gateKS', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('species', node)
        if value is not None and 'species' not in already_processed:
            already_processed.add('species')
            self.species = value
            self.validate_NmlId(self.species)    # validate type NmlId
        value = find_attr_value_('conductance', node)
        if value is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            self.conductance = value
            self.validate_Nml2Quantity_conductance(self.conductance)    # validate type Nml2Quantity_conductance
        super(IonChannelKS, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gateKS':
            obj_ = GateKS.factory()
            obj_.build(child_)
            self.gate_kses.append(obj_)
            obj_.original_tagname_ = 'gateKS'
        super(IonChannelKS, self).buildChildren(child_, node, nodeName_, True)
# end class IonChannelKS


class IonChannelScalable(Standalone):
    member_data_items_ = [
        MemberSpec_('q10_conductance_scalings', 'Q10ConductanceScaling', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, q10_conductance_scalings=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IonChannelScalable, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        if q10_conductance_scalings is None:
            self.q10_conductance_scalings = []
        else:
            self.q10_conductance_scalings = q10_conductance_scalings
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IonChannelScalable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IonChannelScalable.subclass:
            return IonChannelScalable.subclass(*args_, **kwargs_)
        else:
            return IonChannelScalable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.q10_conductance_scalings or
            super(IonChannelScalable, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IonChannelScalable', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannelScalable')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IonChannelScalable', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IonChannelScalable'):
        super(IonChannelScalable, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannelScalable')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IonChannelScalable', fromsubclass_=False, pretty_print=True):
        super(IonChannelScalable, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for q10ConductanceScaling_ in self.q10_conductance_scalings:
            q10ConductanceScaling_.export(outfile, level, namespace_, name_='q10ConductanceScaling', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IonChannelScalable, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'q10ConductanceScaling':
            obj_ = Q10ConductanceScaling.factory()
            obj_.build(child_)
            self.q10_conductance_scalings.append(obj_)
            obj_.original_tagname_ = 'q10ConductanceScaling'
        super(IonChannelScalable, self).buildChildren(child_, node, nodeName_, True)
# end class IonChannelScalable


class NeuroMLDocument(Standalone):
    member_data_items_ = [
        MemberSpec_('includes', 'IncludeType', 1),
        MemberSpec_('extracellular_properties', 'ExtracellularProperties', 1),
        MemberSpec_('intracellular_properties', 'IntracellularProperties', 1),
        MemberSpec_('morphology', 'Morphology', 1),
        MemberSpec_('ion_channel', 'IonChannel', 1),
        MemberSpec_('ion_channel_hhs', 'IonChannelHH', 1),
        MemberSpec_('ion_channel_kses', 'IonChannelKS', 1),
        MemberSpec_('decaying_pool_concentration_models', 'DecayingPoolConcentrationModel', 1),
        MemberSpec_('fixed_factor_concentration_models', 'FixedFactorConcentrationModel', 1),
        MemberSpec_('alpha_current_synapses', 'AlphaCurrentSynapse', 1),
        MemberSpec_('alpha_synapses', 'AlphaSynapse', 1),
        MemberSpec_('exp_one_synapses', 'ExpOneSynapse', 1),
        MemberSpec_('exp_two_synapses', 'ExpTwoSynapse', 1),
        MemberSpec_('exp_three_synapses', 'ExpThreeSynapse', 1),
        MemberSpec_('blocking_plastic_synapses', 'BlockingPlasticSynapse', 1),
        MemberSpec_('gap_junctions', 'GapJunction', 1),
        MemberSpec_('silent_synapses', 'SilentSynapse', 1),
        MemberSpec_('linear_graded_synapses', 'LinearGradedSynapse', 1),
        MemberSpec_('graded_synapses', 'GradedSynapse', 1),
        MemberSpec_('biophysical_properties', 'BiophysicalProperties', 1),
        MemberSpec_('cells', 'Cell', 1),
        MemberSpec_('cell2_ca_poolses', 'Cell2CaPools', 1),
        MemberSpec_('base_cells', 'BaseCell', 1),
        MemberSpec_('iaf_tau_cells', 'IafTauCell', 1),
        MemberSpec_('iaf_tau_ref_cells', 'IafTauRefCell', 1),
        MemberSpec_('iaf_cells', 'IafCell', 1),
        MemberSpec_('iaf_ref_cells', 'IafRefCell', 1),
        MemberSpec_('izhikevich_cells', 'IzhikevichCell', 1),
        MemberSpec_('izhikevich2007_cells', 'Izhikevich2007Cell', 1),
        MemberSpec_('ad_ex_ia_f_cells', 'AdExIaFCell', 1),
        MemberSpec_('fitz_hugh_nagumo_cells', 'FitzHughNagumoCell', 1),
        MemberSpec_('fitz_hugh_nagumo1969_cells', 'FitzHughNagumo1969Cell', 1),
        MemberSpec_('pinsky_rinzel_ca3_cells', 'PinskyRinzelCA3Cell', 1),
        MemberSpec_('pulse_generators', 'PulseGenerator', 1),
        MemberSpec_('pulse_generator_dls', 'PulseGeneratorDL', 1),
        MemberSpec_('sine_generators', 'SineGenerator', 1),
        MemberSpec_('sine_generator_dls', 'SineGeneratorDL', 1),
        MemberSpec_('ramp_generators', 'RampGenerator', 1),
        MemberSpec_('ramp_generator_dls', 'RampGeneratorDL', 1),
        MemberSpec_('compound_inputs', 'CompoundInput', 1),
        MemberSpec_('compound_input_dls', 'CompoundInputDL', 1),
        MemberSpec_('voltage_clamps', 'VoltageClamp', 1),
        MemberSpec_('spike_arrays', 'SpikeArray', 1),
        MemberSpec_('timed_synaptic_inputs', 'TimedSynapticInput', 1),
        MemberSpec_('spike_generators', 'SpikeGenerator', 1),
        MemberSpec_('spike_generator_randoms', 'SpikeGeneratorRandom', 1),
        MemberSpec_('spike_generator_poissons', 'SpikeGeneratorPoisson', 1),
        MemberSpec_('poisson_firing_synapses', 'PoissonFiringSynapse', 1),
        MemberSpec_('transient_poisson_firing_synapses', 'TransientPoissonFiringSynapse', 1),
        MemberSpec_('IF_curr_alpha', 'IF_curr_alpha', 1),
        MemberSpec_('IF_curr_exp', 'IF_curr_exp', 1),
        MemberSpec_('IF_cond_alpha', 'IF_cond_alpha', 1),
        MemberSpec_('IF_cond_exp', 'IF_cond_exp', 1),
        MemberSpec_('EIF_cond_exp_isfa_ista', 'EIF_cond_exp_isfa_ista', 1),
        MemberSpec_('EIF_cond_alpha_isfa_ista', 'EIF_cond_alpha_isfa_ista', 1),
        MemberSpec_('HH_cond_exp', 'HH_cond_exp', 1),
        MemberSpec_('exp_cond_synapses', 'ExpCondSynapse', 1),
        MemberSpec_('alpha_cond_synapses', 'AlphaCondSynapse', 1),
        MemberSpec_('exp_curr_synapses', 'ExpCurrSynapse', 1),
        MemberSpec_('alpha_curr_synapses', 'AlphaCurrSynapse', 1),
        MemberSpec_('SpikeSourcePoisson', 'SpikeSourcePoisson', 1),
        MemberSpec_('networks', 'Network', 1),
        MemberSpec_('ComponentType', 'ComponentType', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, includes=None, extracellular_properties=None, intracellular_properties=None, morphology=None, ion_channel=None, ion_channel_hhs=None, ion_channel_kses=None, decaying_pool_concentration_models=None, fixed_factor_concentration_models=None, alpha_current_synapses=None, alpha_synapses=None, exp_one_synapses=None, exp_two_synapses=None, exp_three_synapses=None, blocking_plastic_synapses=None, gap_junctions=None, silent_synapses=None, linear_graded_synapses=None, graded_synapses=None, biophysical_properties=None, cells=None, cell2_ca_poolses=None, base_cells=None, iaf_tau_cells=None, iaf_tau_ref_cells=None, iaf_cells=None, iaf_ref_cells=None, izhikevich_cells=None, izhikevich2007_cells=None, ad_ex_ia_f_cells=None, fitz_hugh_nagumo_cells=None, fitz_hugh_nagumo1969_cells=None, pinsky_rinzel_ca3_cells=None, pulse_generators=None, pulse_generator_dls=None, sine_generators=None, sine_generator_dls=None, ramp_generators=None, ramp_generator_dls=None, compound_inputs=None, compound_input_dls=None, voltage_clamps=None, spike_arrays=None, timed_synaptic_inputs=None, spike_generators=None, spike_generator_randoms=None, spike_generator_poissons=None, poisson_firing_synapses=None, transient_poisson_firing_synapses=None, IF_curr_alpha=None, IF_curr_exp=None, IF_cond_alpha=None, IF_cond_exp=None, EIF_cond_exp_isfa_ista=None, EIF_cond_alpha_isfa_ista=None, HH_cond_exp=None, exp_cond_synapses=None, alpha_cond_synapses=None, exp_curr_synapses=None, alpha_curr_synapses=None, SpikeSourcePoisson=None, networks=None, ComponentType=None):
        self.original_tagname_ = None
        super(NeuroMLDocument, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        if extracellular_properties is None:
            self.extracellular_properties = []
        else:
            self.extracellular_properties = extracellular_properties
        if intracellular_properties is None:
            self.intracellular_properties = []
        else:
            self.intracellular_properties = intracellular_properties
        if morphology is None:
            self.morphology = []
        else:
            self.morphology = morphology
        if ion_channel is None:
            self.ion_channel = []
        else:
            self.ion_channel = ion_channel
        if ion_channel_hhs is None:
            self.ion_channel_hhs = []
        else:
            self.ion_channel_hhs = ion_channel_hhs
        if ion_channel_kses is None:
            self.ion_channel_kses = []
        else:
            self.ion_channel_kses = ion_channel_kses
        if decaying_pool_concentration_models is None:
            self.decaying_pool_concentration_models = []
        else:
            self.decaying_pool_concentration_models = decaying_pool_concentration_models
        if fixed_factor_concentration_models is None:
            self.fixed_factor_concentration_models = []
        else:
            self.fixed_factor_concentration_models = fixed_factor_concentration_models
        if alpha_current_synapses is None:
            self.alpha_current_synapses = []
        else:
            self.alpha_current_synapses = alpha_current_synapses
        if alpha_synapses is None:
            self.alpha_synapses = []
        else:
            self.alpha_synapses = alpha_synapses
        if exp_one_synapses is None:
            self.exp_one_synapses = []
        else:
            self.exp_one_synapses = exp_one_synapses
        if exp_two_synapses is None:
            self.exp_two_synapses = []
        else:
            self.exp_two_synapses = exp_two_synapses
        if exp_three_synapses is None:
            self.exp_three_synapses = []
        else:
            self.exp_three_synapses = exp_three_synapses
        if blocking_plastic_synapses is None:
            self.blocking_plastic_synapses = []
        else:
            self.blocking_plastic_synapses = blocking_plastic_synapses
        if gap_junctions is None:
            self.gap_junctions = []
        else:
            self.gap_junctions = gap_junctions
        if silent_synapses is None:
            self.silent_synapses = []
        else:
            self.silent_synapses = silent_synapses
        if linear_graded_synapses is None:
            self.linear_graded_synapses = []
        else:
            self.linear_graded_synapses = linear_graded_synapses
        if graded_synapses is None:
            self.graded_synapses = []
        else:
            self.graded_synapses = graded_synapses
        if biophysical_properties is None:
            self.biophysical_properties = []
        else:
            self.biophysical_properties = biophysical_properties
        if cells is None:
            self.cells = []
        else:
            self.cells = cells
        if cell2_ca_poolses is None:
            self.cell2_ca_poolses = []
        else:
            self.cell2_ca_poolses = cell2_ca_poolses
        if base_cells is None:
            self.base_cells = []
        else:
            self.base_cells = base_cells
        if iaf_tau_cells is None:
            self.iaf_tau_cells = []
        else:
            self.iaf_tau_cells = iaf_tau_cells
        if iaf_tau_ref_cells is None:
            self.iaf_tau_ref_cells = []
        else:
            self.iaf_tau_ref_cells = iaf_tau_ref_cells
        if iaf_cells is None:
            self.iaf_cells = []
        else:
            self.iaf_cells = iaf_cells
        if iaf_ref_cells is None:
            self.iaf_ref_cells = []
        else:
            self.iaf_ref_cells = iaf_ref_cells
        if izhikevich_cells is None:
            self.izhikevich_cells = []
        else:
            self.izhikevich_cells = izhikevich_cells
        if izhikevich2007_cells is None:
            self.izhikevich2007_cells = []
        else:
            self.izhikevich2007_cells = izhikevich2007_cells
        if ad_ex_ia_f_cells is None:
            self.ad_ex_ia_f_cells = []
        else:
            self.ad_ex_ia_f_cells = ad_ex_ia_f_cells
        if fitz_hugh_nagumo_cells is None:
            self.fitz_hugh_nagumo_cells = []
        else:
            self.fitz_hugh_nagumo_cells = fitz_hugh_nagumo_cells
        if fitz_hugh_nagumo1969_cells is None:
            self.fitz_hugh_nagumo1969_cells = []
        else:
            self.fitz_hugh_nagumo1969_cells = fitz_hugh_nagumo1969_cells
        if pinsky_rinzel_ca3_cells is None:
            self.pinsky_rinzel_ca3_cells = []
        else:
            self.pinsky_rinzel_ca3_cells = pinsky_rinzel_ca3_cells
        if pulse_generators is None:
            self.pulse_generators = []
        else:
            self.pulse_generators = pulse_generators
        if pulse_generator_dls is None:
            self.pulse_generator_dls = []
        else:
            self.pulse_generator_dls = pulse_generator_dls
        if sine_generators is None:
            self.sine_generators = []
        else:
            self.sine_generators = sine_generators
        if sine_generator_dls is None:
            self.sine_generator_dls = []
        else:
            self.sine_generator_dls = sine_generator_dls
        if ramp_generators is None:
            self.ramp_generators = []
        else:
            self.ramp_generators = ramp_generators
        if ramp_generator_dls is None:
            self.ramp_generator_dls = []
        else:
            self.ramp_generator_dls = ramp_generator_dls
        if compound_inputs is None:
            self.compound_inputs = []
        else:
            self.compound_inputs = compound_inputs
        if compound_input_dls is None:
            self.compound_input_dls = []
        else:
            self.compound_input_dls = compound_input_dls
        if voltage_clamps is None:
            self.voltage_clamps = []
        else:
            self.voltage_clamps = voltage_clamps
        if spike_arrays is None:
            self.spike_arrays = []
        else:
            self.spike_arrays = spike_arrays
        if timed_synaptic_inputs is None:
            self.timed_synaptic_inputs = []
        else:
            self.timed_synaptic_inputs = timed_synaptic_inputs
        if spike_generators is None:
            self.spike_generators = []
        else:
            self.spike_generators = spike_generators
        if spike_generator_randoms is None:
            self.spike_generator_randoms = []
        else:
            self.spike_generator_randoms = spike_generator_randoms
        if spike_generator_poissons is None:
            self.spike_generator_poissons = []
        else:
            self.spike_generator_poissons = spike_generator_poissons
        if poisson_firing_synapses is None:
            self.poisson_firing_synapses = []
        else:
            self.poisson_firing_synapses = poisson_firing_synapses
        if transient_poisson_firing_synapses is None:
            self.transient_poisson_firing_synapses = []
        else:
            self.transient_poisson_firing_synapses = transient_poisson_firing_synapses
        if IF_curr_alpha is None:
            self.IF_curr_alpha = []
        else:
            self.IF_curr_alpha = IF_curr_alpha
        if IF_curr_exp is None:
            self.IF_curr_exp = []
        else:
            self.IF_curr_exp = IF_curr_exp
        if IF_cond_alpha is None:
            self.IF_cond_alpha = []
        else:
            self.IF_cond_alpha = IF_cond_alpha
        if IF_cond_exp is None:
            self.IF_cond_exp = []
        else:
            self.IF_cond_exp = IF_cond_exp
        if EIF_cond_exp_isfa_ista is None:
            self.EIF_cond_exp_isfa_ista = []
        else:
            self.EIF_cond_exp_isfa_ista = EIF_cond_exp_isfa_ista
        if EIF_cond_alpha_isfa_ista is None:
            self.EIF_cond_alpha_isfa_ista = []
        else:
            self.EIF_cond_alpha_isfa_ista = EIF_cond_alpha_isfa_ista
        if HH_cond_exp is None:
            self.HH_cond_exp = []
        else:
            self.HH_cond_exp = HH_cond_exp
        if exp_cond_synapses is None:
            self.exp_cond_synapses = []
        else:
            self.exp_cond_synapses = exp_cond_synapses
        if alpha_cond_synapses is None:
            self.alpha_cond_synapses = []
        else:
            self.alpha_cond_synapses = alpha_cond_synapses
        if exp_curr_synapses is None:
            self.exp_curr_synapses = []
        else:
            self.exp_curr_synapses = exp_curr_synapses
        if alpha_curr_synapses is None:
            self.alpha_curr_synapses = []
        else:
            self.alpha_curr_synapses = alpha_curr_synapses
        if SpikeSourcePoisson is None:
            self.SpikeSourcePoisson = []
        else:
            self.SpikeSourcePoisson = SpikeSourcePoisson
        if networks is None:
            self.networks = []
        else:
            self.networks = networks
        if ComponentType is None:
            self.ComponentType = []
        else:
            self.ComponentType = ComponentType
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NeuroMLDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NeuroMLDocument.subclass:
            return NeuroMLDocument.subclass(*args_, **kwargs_)
        else:
            return NeuroMLDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.includes or
            self.extracellular_properties or
            self.intracellular_properties or
            self.morphology or
            self.ion_channel or
            self.ion_channel_hhs or
            self.ion_channel_kses or
            self.decaying_pool_concentration_models or
            self.fixed_factor_concentration_models or
            self.alpha_current_synapses or
            self.alpha_synapses or
            self.exp_one_synapses or
            self.exp_two_synapses or
            self.exp_three_synapses or
            self.blocking_plastic_synapses or
            self.gap_junctions or
            self.silent_synapses or
            self.linear_graded_synapses or
            self.graded_synapses or
            self.biophysical_properties or
            self.cells or
            self.cell2_ca_poolses or
            self.base_cells or
            self.iaf_tau_cells or
            self.iaf_tau_ref_cells or
            self.iaf_cells or
            self.iaf_ref_cells or
            self.izhikevich_cells or
            self.izhikevich2007_cells or
            self.ad_ex_ia_f_cells or
            self.fitz_hugh_nagumo_cells or
            self.fitz_hugh_nagumo1969_cells or
            self.pinsky_rinzel_ca3_cells or
            self.pulse_generators or
            self.pulse_generator_dls or
            self.sine_generators or
            self.sine_generator_dls or
            self.ramp_generators or
            self.ramp_generator_dls or
            self.compound_inputs or
            self.compound_input_dls or
            self.voltage_clamps or
            self.spike_arrays or
            self.timed_synaptic_inputs or
            self.spike_generators or
            self.spike_generator_randoms or
            self.spike_generator_poissons or
            self.poisson_firing_synapses or
            self.transient_poisson_firing_synapses or
            self.IF_curr_alpha or
            self.IF_curr_exp or
            self.IF_cond_alpha or
            self.IF_cond_exp or
            self.EIF_cond_exp_isfa_ista or
            self.EIF_cond_alpha_isfa_ista or
            self.HH_cond_exp or
            self.exp_cond_synapses or
            self.alpha_cond_synapses or
            self.exp_curr_synapses or
            self.alpha_curr_synapses or
            self.SpikeSourcePoisson or
            self.networks or
            self.ComponentType or
            super(NeuroMLDocument, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NeuroMLDocument', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NeuroMLDocument')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NeuroMLDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NeuroMLDocument'):
        super(NeuroMLDocument, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NeuroMLDocument')
    def exportChildren(self, outfile, level, namespace_='', name_='NeuroMLDocument', fromsubclass_=False, pretty_print=True):
        super(NeuroMLDocument, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for include_ in self.includes:
            include_.export(outfile, level, namespace_, name_='include', pretty_print=pretty_print)
        for extracellularProperties_ in self.extracellular_properties:
            extracellularProperties_.export(outfile, level, namespace_, name_='extracellularProperties', pretty_print=pretty_print)
        for intracellularProperties_ in self.intracellular_properties:
            intracellularProperties_.export(outfile, level, namespace_, name_='intracellularProperties', pretty_print=pretty_print)
        for morphology_ in self.morphology:
            morphology_.export(outfile, level, namespace_, name_='morphology', pretty_print=pretty_print)
        for ionChannel_ in self.ion_channel:
            ionChannel_.export(outfile, level, namespace_, name_='ionChannel', pretty_print=pretty_print)
        for ionChannelHH_ in self.ion_channel_hhs:
            ionChannelHH_.export(outfile, level, namespace_, name_='ionChannelHH', pretty_print=pretty_print)
        for ionChannelKS_ in self.ion_channel_kses:
            ionChannelKS_.export(outfile, level, namespace_, name_='ionChannelKS', pretty_print=pretty_print)
        for decayingPoolConcentrationModel_ in self.decaying_pool_concentration_models:
            decayingPoolConcentrationModel_.export(outfile, level, namespace_, name_='decayingPoolConcentrationModel', pretty_print=pretty_print)
        for fixedFactorConcentrationModel_ in self.fixed_factor_concentration_models:
            fixedFactorConcentrationModel_.export(outfile, level, namespace_, name_='fixedFactorConcentrationModel', pretty_print=pretty_print)
        for alphaCurrentSynapse_ in self.alpha_current_synapses:
            alphaCurrentSynapse_.export(outfile, level, namespace_, name_='alphaCurrentSynapse', pretty_print=pretty_print)
        for alphaSynapse_ in self.alpha_synapses:
            alphaSynapse_.export(outfile, level, namespace_, name_='alphaSynapse', pretty_print=pretty_print)
        for expOneSynapse_ in self.exp_one_synapses:
            expOneSynapse_.export(outfile, level, namespace_, name_='expOneSynapse', pretty_print=pretty_print)
        for expTwoSynapse_ in self.exp_two_synapses:
            expTwoSynapse_.export(outfile, level, namespace_, name_='expTwoSynapse', pretty_print=pretty_print)
        for expThreeSynapse_ in self.exp_three_synapses:
            expThreeSynapse_.export(outfile, level, namespace_, name_='expThreeSynapse', pretty_print=pretty_print)
        for blockingPlasticSynapse_ in self.blocking_plastic_synapses:
            blockingPlasticSynapse_.export(outfile, level, namespace_, name_='blockingPlasticSynapse', pretty_print=pretty_print)
        for gapJunction_ in self.gap_junctions:
            gapJunction_.export(outfile, level, namespace_, name_='gapJunction', pretty_print=pretty_print)
        for silentSynapse_ in self.silent_synapses:
            silentSynapse_.export(outfile, level, namespace_, name_='silentSynapse', pretty_print=pretty_print)
        for linearGradedSynapse_ in self.linear_graded_synapses:
            linearGradedSynapse_.export(outfile, level, namespace_, name_='linearGradedSynapse', pretty_print=pretty_print)
        for gradedSynapse_ in self.graded_synapses:
            gradedSynapse_.export(outfile, level, namespace_, name_='gradedSynapse', pretty_print=pretty_print)
        for biophysicalProperties_ in self.biophysical_properties:
            biophysicalProperties_.export(outfile, level, namespace_, name_='biophysicalProperties', pretty_print=pretty_print)
        for cell_ in self.cells:
            cell_.export(outfile, level, namespace_, name_='cell', pretty_print=pretty_print)
        for cell2CaPools_ in self.cell2_ca_poolses:
            cell2CaPools_.export(outfile, level, namespace_, name_='cell2CaPools', pretty_print=pretty_print)
        for baseCell_ in self.base_cells:
            baseCell_.export(outfile, level, namespace_, name_='baseCell', pretty_print=pretty_print)
        for iafTauCell_ in self.iaf_tau_cells:
            iafTauCell_.export(outfile, level, namespace_, name_='iafTauCell', pretty_print=pretty_print)
        for iafTauRefCell_ in self.iaf_tau_ref_cells:
            iafTauRefCell_.export(outfile, level, namespace_, name_='iafTauRefCell', pretty_print=pretty_print)
        for iafCell_ in self.iaf_cells:
            iafCell_.export(outfile, level, namespace_, name_='iafCell', pretty_print=pretty_print)
        for iafRefCell_ in self.iaf_ref_cells:
            iafRefCell_.export(outfile, level, namespace_, name_='iafRefCell', pretty_print=pretty_print)
        for izhikevichCell_ in self.izhikevich_cells:
            izhikevichCell_.export(outfile, level, namespace_, name_='izhikevichCell', pretty_print=pretty_print)
        for izhikevich2007Cell_ in self.izhikevich2007_cells:
            izhikevich2007Cell_.export(outfile, level, namespace_, name_='izhikevich2007Cell', pretty_print=pretty_print)
        for adExIaFCell_ in self.ad_ex_ia_f_cells:
            adExIaFCell_.export(outfile, level, namespace_, name_='adExIaFCell', pretty_print=pretty_print)
        for fitzHughNagumoCell_ in self.fitz_hugh_nagumo_cells:
            fitzHughNagumoCell_.export(outfile, level, namespace_, name_='fitzHughNagumoCell', pretty_print=pretty_print)
        for fitzHughNagumo1969Cell_ in self.fitz_hugh_nagumo1969_cells:
            fitzHughNagumo1969Cell_.export(outfile, level, namespace_, name_='fitzHughNagumo1969Cell', pretty_print=pretty_print)
        for pinskyRinzelCA3Cell_ in self.pinsky_rinzel_ca3_cells:
            pinskyRinzelCA3Cell_.export(outfile, level, namespace_, name_='pinskyRinzelCA3Cell', pretty_print=pretty_print)
        for pulseGenerator_ in self.pulse_generators:
            pulseGenerator_.export(outfile, level, namespace_, name_='pulseGenerator', pretty_print=pretty_print)
        for pulseGeneratorDL_ in self.pulse_generator_dls:
            pulseGeneratorDL_.export(outfile, level, namespace_, name_='pulseGeneratorDL', pretty_print=pretty_print)
        for sineGenerator_ in self.sine_generators:
            sineGenerator_.export(outfile, level, namespace_, name_='sineGenerator', pretty_print=pretty_print)
        for sineGeneratorDL_ in self.sine_generator_dls:
            sineGeneratorDL_.export(outfile, level, namespace_, name_='sineGeneratorDL', pretty_print=pretty_print)
        for rampGenerator_ in self.ramp_generators:
            rampGenerator_.export(outfile, level, namespace_, name_='rampGenerator', pretty_print=pretty_print)
        for rampGeneratorDL_ in self.ramp_generator_dls:
            rampGeneratorDL_.export(outfile, level, namespace_, name_='rampGeneratorDL', pretty_print=pretty_print)
        for compoundInput_ in self.compound_inputs:
            compoundInput_.export(outfile, level, namespace_, name_='compoundInput', pretty_print=pretty_print)
        for compoundInputDL_ in self.compound_input_dls:
            compoundInputDL_.export(outfile, level, namespace_, name_='compoundInputDL', pretty_print=pretty_print)
        for voltageClamp_ in self.voltage_clamps:
            voltageClamp_.export(outfile, level, namespace_, name_='voltageClamp', pretty_print=pretty_print)
        for spikeArray_ in self.spike_arrays:
            spikeArray_.export(outfile, level, namespace_, name_='spikeArray', pretty_print=pretty_print)
        for timedSynapticInput_ in self.timed_synaptic_inputs:
            timedSynapticInput_.export(outfile, level, namespace_, name_='timedSynapticInput', pretty_print=pretty_print)
        for spikeGenerator_ in self.spike_generators:
            spikeGenerator_.export(outfile, level, namespace_, name_='spikeGenerator', pretty_print=pretty_print)
        for spikeGeneratorRandom_ in self.spike_generator_randoms:
            spikeGeneratorRandom_.export(outfile, level, namespace_, name_='spikeGeneratorRandom', pretty_print=pretty_print)
        for spikeGeneratorPoisson_ in self.spike_generator_poissons:
            spikeGeneratorPoisson_.export(outfile, level, namespace_, name_='spikeGeneratorPoisson', pretty_print=pretty_print)
        for poissonFiringSynapse_ in self.poisson_firing_synapses:
            poissonFiringSynapse_.export(outfile, level, namespace_, name_='poissonFiringSynapse', pretty_print=pretty_print)
        for transientPoissonFiringSynapse_ in self.transient_poisson_firing_synapses:
            transientPoissonFiringSynapse_.export(outfile, level, namespace_, name_='transientPoissonFiringSynapse', pretty_print=pretty_print)
        for IF_curr_alpha_ in self.IF_curr_alpha:
            IF_curr_alpha_.export(outfile, level, namespace_, name_='IF_curr_alpha', pretty_print=pretty_print)
        for IF_curr_exp_ in self.IF_curr_exp:
            IF_curr_exp_.export(outfile, level, namespace_, name_='IF_curr_exp', pretty_print=pretty_print)
        for IF_cond_alpha_ in self.IF_cond_alpha:
            IF_cond_alpha_.export(outfile, level, namespace_, name_='IF_cond_alpha', pretty_print=pretty_print)
        for IF_cond_exp_ in self.IF_cond_exp:
            IF_cond_exp_.export(outfile, level, namespace_, name_='IF_cond_exp', pretty_print=pretty_print)
        for EIF_cond_exp_isfa_ista_ in self.EIF_cond_exp_isfa_ista:
            EIF_cond_exp_isfa_ista_.export(outfile, level, namespace_, name_='EIF_cond_exp_isfa_ista', pretty_print=pretty_print)
        for EIF_cond_alpha_isfa_ista_ in self.EIF_cond_alpha_isfa_ista:
            EIF_cond_alpha_isfa_ista_.export(outfile, level, namespace_, name_='EIF_cond_alpha_isfa_ista', pretty_print=pretty_print)
        for HH_cond_exp_ in self.HH_cond_exp:
            HH_cond_exp_.export(outfile, level, namespace_, name_='HH_cond_exp', pretty_print=pretty_print)
        for expCondSynapse_ in self.exp_cond_synapses:
            expCondSynapse_.export(outfile, level, namespace_, name_='expCondSynapse', pretty_print=pretty_print)
        for alphaCondSynapse_ in self.alpha_cond_synapses:
            alphaCondSynapse_.export(outfile, level, namespace_, name_='alphaCondSynapse', pretty_print=pretty_print)
        for expCurrSynapse_ in self.exp_curr_synapses:
            expCurrSynapse_.export(outfile, level, namespace_, name_='expCurrSynapse', pretty_print=pretty_print)
        for alphaCurrSynapse_ in self.alpha_curr_synapses:
            alphaCurrSynapse_.export(outfile, level, namespace_, name_='alphaCurrSynapse', pretty_print=pretty_print)
        for SpikeSourcePoisson_ in self.SpikeSourcePoisson:
            SpikeSourcePoisson_.export(outfile, level, namespace_, name_='SpikeSourcePoisson', pretty_print=pretty_print)
        for network_ in self.networks:
            network_.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
        for ComponentType_ in self.ComponentType:
            ComponentType_.export(outfile, level, namespace_, name_='ComponentType', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NeuroMLDocument, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'include':
            obj_ = IncludeType.factory()
            obj_.build(child_)
            self.includes.append(obj_)
            obj_.original_tagname_ = 'include'
        elif nodeName_ == 'extracellularProperties':
            obj_ = ExtracellularProperties.factory()
            obj_.build(child_)
            self.extracellular_properties.append(obj_)
            obj_.original_tagname_ = 'extracellularProperties'
        elif nodeName_ == 'intracellularProperties':
            class_obj_ = self.get_class_obj_(child_, IntracellularProperties)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.intracellular_properties.append(obj_)
            obj_.original_tagname_ = 'intracellularProperties'
        elif nodeName_ == 'morphology':
            obj_ = Morphology.factory()
            obj_.build(child_)
            self.morphology.append(obj_)
            obj_.original_tagname_ = 'morphology'
        elif nodeName_ == 'ionChannel':
            class_obj_ = self.get_class_obj_(child_, IonChannel)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ion_channel.append(obj_)
            obj_.original_tagname_ = 'ionChannel'
        elif nodeName_ == 'ionChannelHH':
            obj_ = IonChannelHH.factory()
            obj_.build(child_)
            self.ion_channel_hhs.append(obj_)
            obj_.original_tagname_ = 'ionChannelHH'
        elif nodeName_ == 'ionChannelKS':
            obj_ = IonChannelKS.factory()
            obj_.build(child_)
            self.ion_channel_kses.append(obj_)
            obj_.original_tagname_ = 'ionChannelKS'
        elif nodeName_ == 'decayingPoolConcentrationModel':
            class_obj_ = self.get_class_obj_(child_, DecayingPoolConcentrationModel)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.decaying_pool_concentration_models.append(obj_)
            obj_.original_tagname_ = 'decayingPoolConcentrationModel'
        elif nodeName_ == 'fixedFactorConcentrationModel':
            obj_ = FixedFactorConcentrationModel.factory()
            obj_.build(child_)
            self.fixed_factor_concentration_models.append(obj_)
            obj_.original_tagname_ = 'fixedFactorConcentrationModel'
        elif nodeName_ == 'alphaCurrentSynapse':
            obj_ = AlphaCurrentSynapse.factory()
            obj_.build(child_)
            self.alpha_current_synapses.append(obj_)
            obj_.original_tagname_ = 'alphaCurrentSynapse'
        elif nodeName_ == 'alphaSynapse':
            obj_ = AlphaSynapse.factory()
            obj_.build(child_)
            self.alpha_synapses.append(obj_)
            obj_.original_tagname_ = 'alphaSynapse'
        elif nodeName_ == 'expOneSynapse':
            obj_ = ExpOneSynapse.factory()
            obj_.build(child_)
            self.exp_one_synapses.append(obj_)
            obj_.original_tagname_ = 'expOneSynapse'
        elif nodeName_ == 'expTwoSynapse':
            class_obj_ = self.get_class_obj_(child_, ExpTwoSynapse)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.exp_two_synapses.append(obj_)
            obj_.original_tagname_ = 'expTwoSynapse'
        elif nodeName_ == 'expThreeSynapse':
            obj_ = ExpThreeSynapse.factory()
            obj_.build(child_)
            self.exp_three_synapses.append(obj_)
            obj_.original_tagname_ = 'expThreeSynapse'
        elif nodeName_ == 'blockingPlasticSynapse':
            obj_ = BlockingPlasticSynapse.factory()
            obj_.build(child_)
            self.blocking_plastic_synapses.append(obj_)
            obj_.original_tagname_ = 'blockingPlasticSynapse'
        elif nodeName_ == 'gapJunction':
            obj_ = GapJunction.factory()
            obj_.build(child_)
            self.gap_junctions.append(obj_)
            obj_.original_tagname_ = 'gapJunction'
        elif nodeName_ == 'silentSynapse':
            obj_ = SilentSynapse.factory()
            obj_.build(child_)
            self.silent_synapses.append(obj_)
            obj_.original_tagname_ = 'silentSynapse'
        elif nodeName_ == 'linearGradedSynapse':
            obj_ = LinearGradedSynapse.factory()
            obj_.build(child_)
            self.linear_graded_synapses.append(obj_)
            obj_.original_tagname_ = 'linearGradedSynapse'
        elif nodeName_ == 'gradedSynapse':
            obj_ = GradedSynapse.factory()
            obj_.build(child_)
            self.graded_synapses.append(obj_)
            obj_.original_tagname_ = 'gradedSynapse'
        elif nodeName_ == 'biophysicalProperties':
            obj_ = BiophysicalProperties.factory()
            obj_.build(child_)
            self.biophysical_properties.append(obj_)
            obj_.original_tagname_ = 'biophysicalProperties'
        elif nodeName_ == 'cell':
            class_obj_ = self.get_class_obj_(child_, Cell)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.cells.append(obj_)
            obj_.original_tagname_ = 'cell'
        elif nodeName_ == 'cell2CaPools':
            obj_ = Cell2CaPools.factory()
            obj_.build(child_)
            self.cell2_ca_poolses.append(obj_)
            obj_.original_tagname_ = 'cell2CaPools'
        elif nodeName_ == 'baseCell':
            class_obj_ = self.get_class_obj_(child_, BaseCell)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.base_cells.append(obj_)
            obj_.original_tagname_ = 'baseCell'
        elif nodeName_ == 'iafTauCell':
            class_obj_ = self.get_class_obj_(child_, IafTauCell)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.iaf_tau_cells.append(obj_)
            obj_.original_tagname_ = 'iafTauCell'
        elif nodeName_ == 'iafTauRefCell':
            obj_ = IafTauRefCell.factory()
            obj_.build(child_)
            self.iaf_tau_ref_cells.append(obj_)
            obj_.original_tagname_ = 'iafTauRefCell'
        elif nodeName_ == 'iafCell':
            class_obj_ = self.get_class_obj_(child_, IafCell)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.iaf_cells.append(obj_)
            obj_.original_tagname_ = 'iafCell'
        elif nodeName_ == 'iafRefCell':
            obj_ = IafRefCell.factory()
            obj_.build(child_)
            self.iaf_ref_cells.append(obj_)
            obj_.original_tagname_ = 'iafRefCell'
        elif nodeName_ == 'izhikevichCell':
            obj_ = IzhikevichCell.factory()
            obj_.build(child_)
            self.izhikevich_cells.append(obj_)
            obj_.original_tagname_ = 'izhikevichCell'
        elif nodeName_ == 'izhikevich2007Cell':
            obj_ = Izhikevich2007Cell.factory()
            obj_.build(child_)
            self.izhikevich2007_cells.append(obj_)
            obj_.original_tagname_ = 'izhikevich2007Cell'
        elif nodeName_ == 'adExIaFCell':
            obj_ = AdExIaFCell.factory()
            obj_.build(child_)
            self.ad_ex_ia_f_cells.append(obj_)
            obj_.original_tagname_ = 'adExIaFCell'
        elif nodeName_ == 'fitzHughNagumoCell':
            obj_ = FitzHughNagumoCell.factory()
            obj_.build(child_)
            self.fitz_hugh_nagumo_cells.append(obj_)
            obj_.original_tagname_ = 'fitzHughNagumoCell'
        elif nodeName_ == 'fitzHughNagumo1969Cell':
            obj_ = FitzHughNagumo1969Cell.factory()
            obj_.build(child_)
            self.fitz_hugh_nagumo1969_cells.append(obj_)
            obj_.original_tagname_ = 'fitzHughNagumo1969Cell'
        elif nodeName_ == 'pinskyRinzelCA3Cell':
            obj_ = PinskyRinzelCA3Cell.factory()
            obj_.build(child_)
            self.pinsky_rinzel_ca3_cells.append(obj_)
            obj_.original_tagname_ = 'pinskyRinzelCA3Cell'
        elif nodeName_ == 'pulseGenerator':
            obj_ = PulseGenerator.factory()
            obj_.build(child_)
            self.pulse_generators.append(obj_)
            obj_.original_tagname_ = 'pulseGenerator'
        elif nodeName_ == 'pulseGeneratorDL':
            obj_ = PulseGeneratorDL.factory()
            obj_.build(child_)
            self.pulse_generator_dls.append(obj_)
            obj_.original_tagname_ = 'pulseGeneratorDL'
        elif nodeName_ == 'sineGenerator':
            obj_ = SineGenerator.factory()
            obj_.build(child_)
            self.sine_generators.append(obj_)
            obj_.original_tagname_ = 'sineGenerator'
        elif nodeName_ == 'sineGeneratorDL':
            obj_ = SineGeneratorDL.factory()
            obj_.build(child_)
            self.sine_generator_dls.append(obj_)
            obj_.original_tagname_ = 'sineGeneratorDL'
        elif nodeName_ == 'rampGenerator':
            obj_ = RampGenerator.factory()
            obj_.build(child_)
            self.ramp_generators.append(obj_)
            obj_.original_tagname_ = 'rampGenerator'
        elif nodeName_ == 'rampGeneratorDL':
            obj_ = RampGeneratorDL.factory()
            obj_.build(child_)
            self.ramp_generator_dls.append(obj_)
            obj_.original_tagname_ = 'rampGeneratorDL'
        elif nodeName_ == 'compoundInput':
            obj_ = CompoundInput.factory()
            obj_.build(child_)
            self.compound_inputs.append(obj_)
            obj_.original_tagname_ = 'compoundInput'
        elif nodeName_ == 'compoundInputDL':
            obj_ = CompoundInputDL.factory()
            obj_.build(child_)
            self.compound_input_dls.append(obj_)
            obj_.original_tagname_ = 'compoundInputDL'
        elif nodeName_ == 'voltageClamp':
            obj_ = VoltageClamp.factory()
            obj_.build(child_)
            self.voltage_clamps.append(obj_)
            obj_.original_tagname_ = 'voltageClamp'
        elif nodeName_ == 'spikeArray':
            obj_ = SpikeArray.factory()
            obj_.build(child_)
            self.spike_arrays.append(obj_)
            obj_.original_tagname_ = 'spikeArray'
        elif nodeName_ == 'timedSynapticInput':
            obj_ = TimedSynapticInput.factory()
            obj_.build(child_)
            self.timed_synaptic_inputs.append(obj_)
            obj_.original_tagname_ = 'timedSynapticInput'
        elif nodeName_ == 'spikeGenerator':
            obj_ = SpikeGenerator.factory()
            obj_.build(child_)
            self.spike_generators.append(obj_)
            obj_.original_tagname_ = 'spikeGenerator'
        elif nodeName_ == 'spikeGeneratorRandom':
            obj_ = SpikeGeneratorRandom.factory()
            obj_.build(child_)
            self.spike_generator_randoms.append(obj_)
            obj_.original_tagname_ = 'spikeGeneratorRandom'
        elif nodeName_ == 'spikeGeneratorPoisson':
            obj_ = SpikeGeneratorPoisson.factory()
            obj_.build(child_)
            self.spike_generator_poissons.append(obj_)
            obj_.original_tagname_ = 'spikeGeneratorPoisson'
        elif nodeName_ == 'poissonFiringSynapse':
            obj_ = PoissonFiringSynapse.factory()
            obj_.build(child_)
            self.poisson_firing_synapses.append(obj_)
            obj_.original_tagname_ = 'poissonFiringSynapse'
        elif nodeName_ == 'transientPoissonFiringSynapse':
            obj_ = TransientPoissonFiringSynapse.factory()
            obj_.build(child_)
            self.transient_poisson_firing_synapses.append(obj_)
            obj_.original_tagname_ = 'transientPoissonFiringSynapse'
        elif nodeName_ == 'IF_curr_alpha':
            obj_ = IF_curr_alpha.factory()
            obj_.build(child_)
            self.IF_curr_alpha.append(obj_)
            obj_.original_tagname_ = 'IF_curr_alpha'
        elif nodeName_ == 'IF_curr_exp':
            obj_ = IF_curr_exp.factory()
            obj_.build(child_)
            self.IF_curr_exp.append(obj_)
            obj_.original_tagname_ = 'IF_curr_exp'
        elif nodeName_ == 'IF_cond_alpha':
            obj_ = IF_cond_alpha.factory()
            obj_.build(child_)
            self.IF_cond_alpha.append(obj_)
            obj_.original_tagname_ = 'IF_cond_alpha'
        elif nodeName_ == 'IF_cond_exp':
            obj_ = IF_cond_exp.factory()
            obj_.build(child_)
            self.IF_cond_exp.append(obj_)
            obj_.original_tagname_ = 'IF_cond_exp'
        elif nodeName_ == 'EIF_cond_exp_isfa_ista':
            class_obj_ = self.get_class_obj_(child_, EIF_cond_exp_isfa_ista)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.EIF_cond_exp_isfa_ista.append(obj_)
            obj_.original_tagname_ = 'EIF_cond_exp_isfa_ista'
        elif nodeName_ == 'EIF_cond_alpha_isfa_ista':
            obj_ = EIF_cond_alpha_isfa_ista.factory()
            obj_.build(child_)
            self.EIF_cond_alpha_isfa_ista.append(obj_)
            obj_.original_tagname_ = 'EIF_cond_alpha_isfa_ista'
        elif nodeName_ == 'HH_cond_exp':
            obj_ = HH_cond_exp.factory()
            obj_.build(child_)
            self.HH_cond_exp.append(obj_)
            obj_.original_tagname_ = 'HH_cond_exp'
        elif nodeName_ == 'expCondSynapse':
            obj_ = ExpCondSynapse.factory()
            obj_.build(child_)
            self.exp_cond_synapses.append(obj_)
            obj_.original_tagname_ = 'expCondSynapse'
        elif nodeName_ == 'alphaCondSynapse':
            obj_ = AlphaCondSynapse.factory()
            obj_.build(child_)
            self.alpha_cond_synapses.append(obj_)
            obj_.original_tagname_ = 'alphaCondSynapse'
        elif nodeName_ == 'expCurrSynapse':
            obj_ = ExpCurrSynapse.factory()
            obj_.build(child_)
            self.exp_curr_synapses.append(obj_)
            obj_.original_tagname_ = 'expCurrSynapse'
        elif nodeName_ == 'alphaCurrSynapse':
            obj_ = AlphaCurrSynapse.factory()
            obj_.build(child_)
            self.alpha_curr_synapses.append(obj_)
            obj_.original_tagname_ = 'alphaCurrSynapse'
        elif nodeName_ == 'SpikeSourcePoisson':
            obj_ = SpikeSourcePoisson.factory()
            obj_.build(child_)
            self.SpikeSourcePoisson.append(obj_)
            obj_.original_tagname_ = 'SpikeSourcePoisson'
        elif nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.networks.append(obj_)
            obj_.original_tagname_ = 'network'
        elif nodeName_ == 'ComponentType':
            obj_ = ComponentType.factory()
            obj_.build(child_)
            self.ComponentType.append(obj_)
            obj_.original_tagname_ = 'ComponentType'
        super(NeuroMLDocument, self).buildChildren(child_, node, nodeName_, True)

    
    def summary(self, show_includes=True, show_non_network=True):
    
        import inspect
        
        info = "*******************************************************\n"
        info+="* NeuroMLDocument: "+self.id+"\n*\n"
        post = ""
        membs = inspect.getmembers(self)
        for memb in membs:
            if isinstance(memb[1], list) and len(memb[1])>0 and not memb[0].endswith('_') and not memb[0] == 'networks':
                if (memb[0] == 'includes' and show_includes) or (not memb[0] == 'includes' and show_non_network):
                    post = "*\n"
                    info+="*   "+str(memb[1][0].__class__.__name__)+": "
                    listed = []
                    for entry in memb[1]:
                        if hasattr(entry,'id'):
                            listed.append(str(entry.id))
                        elif hasattr(entry,'name'):
                            listed.append(str(entry.name))
                        elif hasattr(entry,'href'):
                            listed.append(str(entry.href))
                        elif hasattr(entry,'tag'):
                            listed.append(str(entry.tag)+" = "+str(entry.value))
                    info+= str(sorted(listed))+"\n"
        info+= post
                    
        for network in self.networks:
            info+="*  Network: "+network.id
            if network.temperature:
                info+=" (temperature: "+network.temperature+")"
            info+="\n*\n"
            tot_pop =0
            tot_cells = 0 
            pop_info = ""
            for pop in sorted(network.populations, key=lambda x: x.id):
                pop_info+="*     Population: "+pop.id+" with "+str(pop.size)+" components of type "+pop.component+"\n"
                tot_pop+=1
                tot_cells+=pop.size
                if len(pop.instances)>0:
                    loc = pop.instances[0].location
                    pop_info+="*       Locations: ["+str(loc)+", ...]\n"
            
            info+="*   "+str(tot_cells)+" cells in "+str(tot_pop)+" populations \n"+pop_info+"*\n"
                
                
            tot_proj =0
            tot_conns = 0 
            
            proj_info = ""
            for proj in sorted(network.projections, key=lambda x: x.id):
                proj_info+="*     Projection: "+proj.id+" from "+proj.presynaptic_population+" to "+proj.postsynaptic_population+", synapse: "+proj.synapse+"\n"
                tot_proj+=1
                tot_conns+=len(proj.connections)
                tot_conns+=len(proj.connection_wds)
                if len(proj.connections)>0:
                    proj_info+="*       "+str(len(proj.connections))+" connections: [("+str(proj.connections[0])+"), ...]\n"
                if len(proj.connection_wds)>0:
                    proj_info+="*       "+str(len(proj.connection_wds))+" connections (wd): [("+str(proj.connection_wds[0])+"), ...]\n"
                    
            for proj in sorted(network.electrical_projections, key=lambda x: x.id):
                proj_info+="*     Electrical projection: "+proj.id+" from "+proj.presynaptic_population+" to "+proj.postsynaptic_population+"\n"
                tot_proj+=1
                tot_conns+=len(proj.electrical_connections)
                tot_conns+=len(proj.electrical_connection_instances)
                if len(proj.electrical_connections)>0:
                    proj_info+="*       "+str(len(proj.electrical_connections))+" connections: [("+str(proj.electrical_connections[0])+"), ...]\n"
                if len(proj.electrical_connection_instances)>0:
                    proj_info+="*       "+str(len(proj.electrical_connection_instances))+" connections: [("+str(proj.electrical_connection_instances[0])+"), ...]\n"
                    
            info+="*   "+str(tot_conns)+" connections in "+str(tot_proj)+" projections \n"+proj_info+"*\n"
            
            tot_input_lists = 0
            tot_inputs = 0
            input_info = ""
            for il in sorted(network.input_lists, key=lambda x: x.id):
                input_info+="*     Input list: "+il.id+" to "+il.populations+", component "+il.component+"\n"
                tot_input_lists += 1
                if len(il.input)>0:
                    input_info+="*       "+str(len(il.input))+" inputs: [("+str(il.input[0])+"), ...]\n"
                    tot_inputs+=len(il.input)
                    
            info+="*   "+str(tot_inputs)+" inputs in "+str(tot_input_lists)+" input lists \n"+input_info+"*\n"
                    
        
        info+="*******************************************************"
        
        return info
        
        
    def get_by_id(self,id):
        all_ids = []
        for ms in self.member_data_items_:
            mlist = self.__getattribute__(ms.name)
            for m in mlist:
                if hasattr(m,"id"):
                    if m.id == id:
                        return m
                    else:
                        all_ids.append(m.id)
        print("Id "+id+" not found in <neuroml> element. All ids: "+str(all_ids))
        return None
        
    def append(self,element):
        from neuroml.utils import append_to_element
        append_to_element(self,element)
        
    # end class NeuroMLDocument


class BasePynnSynapse(BaseSynapse):
    member_data_items_ = [
        MemberSpec_('tau_syn', 'xs:float', 0),
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, tau_syn=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BasePynnSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.tau_syn = _cast(float, tau_syn)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BasePynnSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BasePynnSynapse.subclass:
            return BasePynnSynapse.subclass(*args_, **kwargs_)
        else:
            return BasePynnSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BasePynnSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BasePynnSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BasePynnSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BasePynnSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BasePynnSynapse'):
        super(BasePynnSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BasePynnSynapse')
        if self.tau_syn is not None and 'tau_syn' not in already_processed:
            already_processed.add('tau_syn')
            outfile.write(' tau_syn="%s"' % self.gds_format_float(self.tau_syn, input_name='tau_syn'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BasePynnSynapse', fromsubclass_=False, pretty_print=True):
        super(BasePynnSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tau_syn', node)
        if value is not None and 'tau_syn' not in already_processed:
            already_processed.add('tau_syn')
            try:
                self.tau_syn = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (tau_syn): %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BasePynnSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BasePynnSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BasePynnSynapse


class basePyNNCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('cm', 'xs:float', 0),
        MemberSpec_('i_offset', 'xs:float', 0),
        MemberSpec_('tau_syn_E', 'xs:float', 0),
        MemberSpec_('tau_syn_I', 'xs:float', 0),
        MemberSpec_('v_init', 'xs:float', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, cm=None, i_offset=None, tau_syn_E=None, tau_syn_I=None, v_init=None, extensiontype_=None):
        self.original_tagname_ = None
        super(basePyNNCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.cm = _cast(float, cm)
        self.i_offset = _cast(float, i_offset)
        self.tau_syn_E = _cast(float, tau_syn_E)
        self.tau_syn_I = _cast(float, tau_syn_I)
        self.v_init = _cast(float, v_init)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, basePyNNCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if basePyNNCell.subclass:
            return basePyNNCell.subclass(*args_, **kwargs_)
        else:
            return basePyNNCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(basePyNNCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='basePyNNCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='basePyNNCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='basePyNNCell'):
        super(basePyNNCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNCell')
        if self.cm is not None and 'cm' not in already_processed:
            already_processed.add('cm')
            outfile.write(' cm="%s"' % self.gds_format_float(self.cm, input_name='cm'))
        if self.i_offset is not None and 'i_offset' not in already_processed:
            already_processed.add('i_offset')
            outfile.write(' i_offset="%s"' % self.gds_format_float(self.i_offset, input_name='i_offset'))
        if self.tau_syn_E is not None and 'tau_syn_E' not in already_processed:
            already_processed.add('tau_syn_E')
            outfile.write(' tau_syn_E="%s"' % self.gds_format_float(self.tau_syn_E, input_name='tau_syn_E'))
        if self.tau_syn_I is not None and 'tau_syn_I' not in already_processed:
            already_processed.add('tau_syn_I')
            outfile.write(' tau_syn_I="%s"' % self.gds_format_float(self.tau_syn_I, input_name='tau_syn_I'))
        if self.v_init is not None and 'v_init' not in already_processed:
            already_processed.add('v_init')
            outfile.write(' v_init="%s"' % self.gds_format_float(self.v_init, input_name='v_init'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='basePyNNCell', fromsubclass_=False, pretty_print=True):
        super(basePyNNCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cm', node)
        if value is not None and 'cm' not in already_processed:
            already_processed.add('cm')
            try:
                self.cm = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (cm): %s' % exp)
        value = find_attr_value_('i_offset', node)
        if value is not None and 'i_offset' not in already_processed:
            already_processed.add('i_offset')
            try:
                self.i_offset = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (i_offset): %s' % exp)
        value = find_attr_value_('tau_syn_E', node)
        if value is not None and 'tau_syn_E' not in already_processed:
            already_processed.add('tau_syn_E')
            try:
                self.tau_syn_E = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (tau_syn_E): %s' % exp)
        value = find_attr_value_('tau_syn_I', node)
        if value is not None and 'tau_syn_I' not in already_processed:
            already_processed.add('tau_syn_I')
            try:
                self.tau_syn_I = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (tau_syn_I): %s' % exp)
        value = find_attr_value_('v_init', node)
        if value is not None and 'v_init' not in already_processed:
            already_processed.add('v_init')
            try:
                self.v_init = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (v_init): %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(basePyNNCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(basePyNNCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class basePyNNCell


class BaseConnectionNewFormat(BaseConnection):
    """Base of all synaptic connections with preCell, postSegment, etc. See
    BaseConnectionOldFormat"""
    member_data_items_ = [
        MemberSpec_('preCell', 'xs:string', 0),
        MemberSpec_('preSegment', 'NonNegativeInteger', 0),
        MemberSpec_('preFractionAlong', 'ZeroToOne', 0),
        MemberSpec_('postCell', 'xs:string', 0),
        MemberSpec_('postSegment', 'NonNegativeInteger', 0),
        MemberSpec_('postFractionAlong', 'ZeroToOne', 0),
    ]
    subclass = None
    superclass = BaseConnection
    def __init__(self, neuro_lex_id=None, id=None, pre_cell=None, pre_segment='0', pre_fraction_along='0.5', post_cell=None, post_segment='0', post_fraction_along='0.5', extensiontype_=None):
        self.original_tagname_ = None
        super(BaseConnectionNewFormat, self).__init__(neuro_lex_id, id, extensiontype_, )
        self.pre_cell = _cast(None, pre_cell)
        self.pre_segment = _cast(None, pre_segment)
        self.pre_fraction_along = _cast(None, pre_fraction_along)
        self.post_cell = _cast(None, post_cell)
        self.post_segment = _cast(None, post_segment)
        self.post_fraction_along = _cast(None, post_fraction_along)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseConnectionNewFormat)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConnectionNewFormat.subclass:
            return BaseConnectionNewFormat.subclass(*args_, **kwargs_)
        else:
            return BaseConnectionNewFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne' % {"value" : value} )
            if value > 1:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne' % {"value" : value} )
    def hasContent_(self):
        if (
            super(BaseConnectionNewFormat, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseConnectionNewFormat', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConnectionNewFormat')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseConnectionNewFormat', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseConnectionNewFormat'):
        super(BaseConnectionNewFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConnectionNewFormat')
        if self.pre_cell is not None and 'pre_cell' not in already_processed:
            already_processed.add('pre_cell')
            outfile.write(' preCell=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.pre_cell), input_name='preCell')), ))
        if self.pre_segment != 0 and 'pre_segment' not in already_processed:
            already_processed.add('pre_segment')
            outfile.write(' preSegment=%s' % (quote_attrib(self.pre_segment), ))
        if self.pre_fraction_along != 0.5 and 'pre_fraction_along' not in already_processed:
            already_processed.add('pre_fraction_along')
            outfile.write(' preFractionAlong=%s' % (quote_attrib(self.pre_fraction_along), ))
        if self.post_cell is not None and 'post_cell' not in already_processed:
            already_processed.add('post_cell')
            outfile.write(' postCell=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.post_cell), input_name='postCell')), ))
        if self.post_segment != 0 and 'post_segment' not in already_processed:
            already_processed.add('post_segment')
            outfile.write(' postSegment=%s' % (quote_attrib(self.post_segment), ))
        if self.post_fraction_along != 0.5 and 'post_fraction_along' not in already_processed:
            already_processed.add('post_fraction_along')
            outfile.write(' postFractionAlong=%s' % (quote_attrib(self.post_fraction_along), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseConnectionNewFormat', fromsubclass_=False, pretty_print=True):
        super(BaseConnectionNewFormat, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('preCell', node)
        if value is not None and 'preCell' not in already_processed:
            already_processed.add('preCell')
            self.pre_cell = value
        value = find_attr_value_('preSegment', node)
        if value is not None and 'preSegment' not in already_processed:
            already_processed.add('preSegment')
            try:
                self.pre_segment = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.pre_segment < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.pre_segment)    # validate type NonNegativeInteger
        value = find_attr_value_('preFractionAlong', node)
        if value is not None and 'preFractionAlong' not in already_processed:
            already_processed.add('preFractionAlong')
            try:
                self.pre_fraction_along = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (preFractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.pre_fraction_along)    # validate type ZeroToOne
        value = find_attr_value_('postCell', node)
        if value is not None and 'postCell' not in already_processed:
            already_processed.add('postCell')
            self.post_cell = value
        value = find_attr_value_('postSegment', node)
        if value is not None and 'postSegment' not in already_processed:
            already_processed.add('postSegment')
            try:
                self.post_segment = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.post_segment < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.post_segment)    # validate type NonNegativeInteger
        value = find_attr_value_('postFractionAlong', node)
        if value is not None and 'postFractionAlong' not in already_processed:
            already_processed.add('postFractionAlong')
            try:
                self.post_fraction_along = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (postFractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.post_fraction_along)    # validate type ZeroToOne
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseConnectionNewFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseConnectionNewFormat, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseConnectionNewFormat


class BaseConnectionOldFormat(BaseConnection):
    """Base of all synaptic connections with preCellId, postSegmentId, etc.
    Note: this is not the best name for these attributes, since Id
    is superfluous, hence BaseConnectionNewFormat"""
    member_data_items_ = [
        MemberSpec_('preCellId', 'xs:string', 0),
        MemberSpec_('preSegmentId', 'NonNegativeInteger', 0),
        MemberSpec_('preFractionAlong', 'ZeroToOne', 0),
        MemberSpec_('postCellId', 'xs:string', 0),
        MemberSpec_('postSegmentId', 'NonNegativeInteger', 0),
        MemberSpec_('postFractionAlong', 'ZeroToOne', 0),
    ]
    subclass = None
    superclass = BaseConnection
    def __init__(self, neuro_lex_id=None, id=None, pre_cell_id=None, pre_segment_id='0', pre_fraction_along='0.5', post_cell_id=None, post_segment_id='0', post_fraction_along='0.5', extensiontype_=None):
        self.original_tagname_ = None
        super(BaseConnectionOldFormat, self).__init__(neuro_lex_id, id, extensiontype_, )
        self.pre_cell_id = _cast(None, pre_cell_id)
        self.pre_segment_id = _cast(None, pre_segment_id)
        self.pre_fraction_along = _cast(None, pre_fraction_along)
        self.post_cell_id = _cast(None, post_cell_id)
        self.post_segment_id = _cast(None, post_segment_id)
        self.post_fraction_along = _cast(None, post_fraction_along)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseConnectionOldFormat)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConnectionOldFormat.subclass:
            return BaseConnectionOldFormat.subclass(*args_, **kwargs_)
        else:
            return BaseConnectionOldFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if value is not None and Validate_simpletypes_:
            pass
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on ZeroToOne' % {"value" : value} )
            if value > 1:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on ZeroToOne' % {"value" : value} )
    def hasContent_(self):
        if (
            super(BaseConnectionOldFormat, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseConnectionOldFormat', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConnectionOldFormat')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseConnectionOldFormat', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseConnectionOldFormat'):
        super(BaseConnectionOldFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConnectionOldFormat')
        if self.pre_cell_id is not None and 'pre_cell_id' not in already_processed:
            already_processed.add('pre_cell_id')
            outfile.write(' preCellId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.pre_cell_id), input_name='preCellId')), ))
        if self.pre_segment_id != 0 and 'pre_segment_id' not in already_processed:
            already_processed.add('pre_segment_id')
            outfile.write(' preSegmentId=%s' % (quote_attrib(self.pre_segment_id), ))
        if self.pre_fraction_along != 0.5 and 'pre_fraction_along' not in already_processed:
            already_processed.add('pre_fraction_along')
            outfile.write(' preFractionAlong=%s' % (quote_attrib(self.pre_fraction_along), ))
        if self.post_cell_id is not None and 'post_cell_id' not in already_processed:
            already_processed.add('post_cell_id')
            outfile.write(' postCellId=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.post_cell_id), input_name='postCellId')), ))
        if self.post_segment_id != 0 and 'post_segment_id' not in already_processed:
            already_processed.add('post_segment_id')
            outfile.write(' postSegmentId=%s' % (quote_attrib(self.post_segment_id), ))
        if self.post_fraction_along != 0.5 and 'post_fraction_along' not in already_processed:
            already_processed.add('post_fraction_along')
            outfile.write(' postFractionAlong=%s' % (quote_attrib(self.post_fraction_along), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseConnectionOldFormat', fromsubclass_=False, pretty_print=True):
        super(BaseConnectionOldFormat, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('preCellId', node)
        if value is not None and 'preCellId' not in already_processed:
            already_processed.add('preCellId')
            self.pre_cell_id = value
        value = find_attr_value_('preSegmentId', node)
        if value is not None and 'preSegmentId' not in already_processed:
            already_processed.add('preSegmentId')
            try:
                self.pre_segment_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.pre_segment_id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.pre_segment_id)    # validate type NonNegativeInteger
        value = find_attr_value_('preFractionAlong', node)
        if value is not None and 'preFractionAlong' not in already_processed:
            already_processed.add('preFractionAlong')
            try:
                self.pre_fraction_along = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (preFractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.pre_fraction_along)    # validate type ZeroToOne
        value = find_attr_value_('postCellId', node)
        if value is not None and 'postCellId' not in already_processed:
            already_processed.add('postCellId')
            self.post_cell_id = value
        value = find_attr_value_('postSegmentId', node)
        if value is not None and 'postSegmentId' not in already_processed:
            already_processed.add('postSegmentId')
            try:
                self.post_segment_id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.post_segment_id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_NonNegativeInteger(self.post_segment_id)    # validate type NonNegativeInteger
        value = find_attr_value_('postFractionAlong', node)
        if value is not None and 'postFractionAlong' not in already_processed:
            already_processed.add('postFractionAlong')
            try:
                self.post_fraction_along = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (postFractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.post_fraction_along)    # validate type ZeroToOne
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseConnectionOldFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseConnectionOldFormat, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseConnectionOldFormat


class ConcentrationModel_D(DecayingPoolConcentrationModel):
    member_data_items_ = [
        MemberSpec_('type', 'xs:string', 0),
    ]
    subclass = None
    superclass = DecayingPoolConcentrationModel
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, ion=None, resting_conc=None, decay_constant=None, shell_thickness=None, type=None):
        self.original_tagname_ = None
        super(ConcentrationModel_D, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, ion, resting_conc, decay_constant, shell_thickness, )
        self.type = _cast(None, type)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConcentrationModel_D)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConcentrationModel_D.subclass:
            return ConcentrationModel_D.subclass(*args_, **kwargs_)
        else:
            return ConcentrationModel_D(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ConcentrationModel_D, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConcentrationModel_D', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConcentrationModel_D')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ConcentrationModel_D', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConcentrationModel_D'):
        super(ConcentrationModel_D, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ConcentrationModel_D')
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type), input_name='type')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConcentrationModel_D', fromsubclass_=False, pretty_print=True):
        super(ConcentrationModel_D, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
        super(ConcentrationModel_D, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ConcentrationModel_D, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ConcentrationModel_D


class ChannelDensityNernstCa2(ChannelDensityNernst):
    member_data_items_ = [
    ]
    subclass = None
    superclass = ChannelDensityNernst
    def __init__(self, neuro_lex_id=None, id=None, ion_channel=None, cond_density=None, segment_groups='all', segments=None, ion=None, variable_parameters=None):
        self.original_tagname_ = None
        super(ChannelDensityNernstCa2, self).__init__(neuro_lex_id, id, ion_channel, cond_density, segment_groups, segments, ion, variable_parameters, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNernstCa2)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNernstCa2.subclass:
            return ChannelDensityNernstCa2.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNernstCa2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ChannelDensityNernstCa2, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensityNernstCa2', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNernstCa2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ChannelDensityNernstCa2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensityNernstCa2'):
        super(ChannelDensityNernstCa2, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensityNernstCa2')
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensityNernstCa2', fromsubclass_=False, pretty_print=True):
        super(ChannelDensityNernstCa2, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ChannelDensityNernstCa2, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ChannelDensityNernstCa2, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ChannelDensityNernstCa2


class Cell(BaseCell):
    """Should only be used if morphology element is outside the cell. This
    points to the id of the morphology Should only be used if
    biophysicalProperties element is outside the cell. This points
    to the id of the biophysicalProperties"""
    member_data_items_ = [
        MemberSpec_('morphology_attr', 'xs:string', 0),
        MemberSpec_('biophysical_properties_attr', 'xs:string', 0),
        MemberSpec_('morphology', 'Morphology', 0),
        MemberSpec_('biophysical_properties', 'BiophysicalProperties', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, morphology_attr=None, biophysical_properties_attr=None, morphology=None, biophysical_properties=None, extensiontype_=None):
        self.original_tagname_ = None
        super(Cell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.morphology_attr = _cast(None, morphology_attr)
        self.biophysical_properties_attr = _cast(None, biophysical_properties_attr)
        self.morphology = morphology
        self.biophysical_properties = biophysical_properties
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Cell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Cell.subclass:
            return Cell.subclass(*args_, **kwargs_)
        else:
            return Cell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.morphology is not None or
            self.biophysical_properties is not None or
            super(Cell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Cell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Cell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Cell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Cell'):
        super(Cell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Cell')
        if self.morphology_attr is not None and 'morphology_attr' not in already_processed:
            already_processed.add('morphology_attr')
            outfile.write(' morphology=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.morphology_attr), input_name='morphology_attr')), ))
        if self.biophysical_properties_attr is not None and 'biophysical_properties_attr' not in already_processed:
            already_processed.add('biophysical_properties_attr')
            outfile.write(' biophysicalProperties=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.biophysical_properties_attr), input_name='biophysical_properties_attr')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Cell', fromsubclass_=False, pretty_print=True):
        super(Cell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.morphology is not None:
            self.morphology.export(outfile, level, namespace_, name_='morphology', pretty_print=pretty_print)
        if self.biophysical_properties is not None:
            self.biophysical_properties.export(outfile, level, namespace_, name_='biophysicalProperties', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('morphology', node)
        if value is not None and 'morphology_attr' not in already_processed:
            already_processed.add('morphology_attr')
            self.morphology_attr = value
        value = find_attr_value_('biophysicalProperties', node)
        if value is not None and 'biophysical_properties_attr' not in already_processed:
            already_processed.add('biophysical_properties_attr')
            self.biophysical_properties_attr = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Cell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'morphology':
            obj_ = Morphology.factory()
            obj_.build(child_)
            self.morphology = obj_
            obj_.original_tagname_ = 'morphology'
        elif nodeName_ == 'biophysicalProperties':
            obj_ = BiophysicalProperties.factory()
            obj_.build(child_)
            self.biophysical_properties = obj_
            obj_.original_tagname_ = 'biophysicalProperties'
        super(Cell, self).buildChildren(child_, node, nodeName_, True)



    def get_segment_ids_vs_segments(self):

        segments = {}
        for segment in self.morphology.segments:
            segments[segment.id] = segment

        return segments
        

    def get_ordered_segments_in_groups(self, group_list, check_parentage=False, include_cumulative_lengths=False):

        unord_segs = {}
        other_segs = {}

        segments = self.get_segment_ids_vs_segments()

        for sg in self.morphology.segment_groups:
            if sg.id in group_list:
                unord_segs[sg.id] = []
                for member in sg.members:
                    unord_segs[sg.id].append(segments[member.segments])
            else:
                other_segs[sg.id] = []
                for member in sg.members:
                    other_segs[sg.id].append(segments[member.segments])

        for sg in self.morphology.segment_groups:
            if sg.id in group_list:
                for include in sg.includes:
                    if include.segment_groups in unord_segs:
                        for s in unord_segs[include.segment_groups]:
                            unord_segs[sg.id].append(s)
                    if include.segment_groups in other_segs:
                        for s in other_segs[include.segment_groups]:
                            unord_segs[sg.id].append(s)
        ord_segs = {}     

        from operator import attrgetter
        for key in unord_segs.keys():          
            segs = unord_segs[key]
            if len(segs)==1 or len(segs)==0:
                ord_segs[key]=segs
            else:
                ord_segs[key]=sorted(segs,key=attrgetter('id'),reverse=False) 

        if check_parentage:
            # check parent ordering

            for key in ord_segs.keys():   
                existing_ids = []
                for s in ord_segs[key]:
                    if s.id != ord_segs[key][0].id:
                        if not s.parent or not s.parent.segments in existing_ids:
                            raise Exception("Problem with finding parent of seg: "+str(s)+" in list: "+str(ord_segs))
                    existing_ids.append(s.id)


        if include_cumulative_lengths:
            import math
            cumulative_lengths = {}
            for key in ord_segs.keys():   
                cumulative_lengths[key] = []
                tot_len = 0
                for seg in ord_segs[key]:       
                    d = seg.distal
                    p = seg.proximal
                    if not p:
                        parent_seg = segments[seg.parent.segments]
                        p = parent_seg.distal
                    length = math.sqrt( (d.x-p.x)**2 + (d.y-p.y)**2 + (d.z-p.z)**2 )
                    tot_len += length
                    cumulative_lengths[key].append(tot_len)

            return ord_segs, cumulative_lengths

        return ord_segs
                
    def summary(self):
        print("*******************************************************")
        print("* Cell: "+str(self.id))
        print("* Notes: "+str(self.notes))
        print("* Segments: "+str(len(self.morphology.segments)))
        print("* SegmentGroups: "+str(len(self.morphology.segment_groups)))
        
        
        print("*******************************************************")
        
    # end class Cell


class PinskyRinzelCA3Cell(BaseCell):
    member_data_items_ = [
        MemberSpec_('iSoma', 'Nml2Quantity_currentDensity', 0),
        MemberSpec_('iDend', 'Nml2Quantity_currentDensity', 0),
        MemberSpec_('gc', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gLs', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gLd', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gNa', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gKdr', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gCa', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gKahp', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gKC', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gNmda', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('gAmpa', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('eNa', 'Nml2Quantity_voltage', 0),
        MemberSpec_('eCa', 'Nml2Quantity_voltage', 0),
        MemberSpec_('eK', 'Nml2Quantity_voltage', 0),
        MemberSpec_('eL', 'Nml2Quantity_voltage', 0),
        MemberSpec_('qd0', 'Nml2Quantity_none', 0),
        MemberSpec_('pp', 'Nml2Quantity_none', 0),
        MemberSpec_('alphac', 'Nml2Quantity_none', 0),
        MemberSpec_('betac', 'Nml2Quantity_none', 0),
        MemberSpec_('cm', 'Nml2Quantity_specificCapacitance', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, i_soma=None, i_dend=None, gc=None, g_ls=None, g_ld=None, g_na=None, g_kdr=None, g_ca=None, g_kahp=None, g_kc=None, g_nmda=None, g_ampa=None, e_na=None, e_ca=None, e_k=None, e_l=None, qd0=None, pp=None, alphac=None, betac=None, cm=None):
        self.original_tagname_ = None
        super(PinskyRinzelCA3Cell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.i_soma = _cast(None, i_soma)
        self.i_dend = _cast(None, i_dend)
        self.gc = _cast(None, gc)
        self.g_ls = _cast(None, g_ls)
        self.g_ld = _cast(None, g_ld)
        self.g_na = _cast(None, g_na)
        self.g_kdr = _cast(None, g_kdr)
        self.g_ca = _cast(None, g_ca)
        self.g_kahp = _cast(None, g_kahp)
        self.g_kc = _cast(None, g_kc)
        self.g_nmda = _cast(None, g_nmda)
        self.g_ampa = _cast(None, g_ampa)
        self.e_na = _cast(None, e_na)
        self.e_ca = _cast(None, e_ca)
        self.e_k = _cast(None, e_k)
        self.e_l = _cast(None, e_l)
        self.qd0 = _cast(None, qd0)
        self.pp = _cast(None, pp)
        self.alphac = _cast(None, alphac)
        self.betac = _cast(None, betac)
        self.cm = _cast(None, cm)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PinskyRinzelCA3Cell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PinskyRinzelCA3Cell.subclass:
            return PinskyRinzelCA3Cell.subclass(*args_, **kwargs_)
        else:
            return PinskyRinzelCA3Cell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_currentDensity(self, value):
        # Validate type Nml2Quantity_currentDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_currentDensity_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_currentDensity_patterns_, ))
    validate_Nml2Quantity_currentDensity_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A_per_m2$|^uA_per_cm2$|^mA_per_cm2)$']]
    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductanceDensity_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductanceDensity_patterns_, ))
    validate_Nml2Quantity_conductanceDensity_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2$|^mS_per_cm2$|^S_per_cm2)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def validate_Nml2Quantity_specificCapacitance(self, value):
        # Validate type Nml2Quantity_specificCapacitance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_specificCapacitance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_specificCapacitance_patterns_, ))
    validate_Nml2Quantity_specificCapacitance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(F_per_m2$|^uF_per_cm2)$']]
    def hasContent_(self):
        if (
            super(PinskyRinzelCA3Cell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PinskyRinzelCA3Cell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PinskyRinzelCA3Cell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PinskyRinzelCA3Cell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PinskyRinzelCA3Cell'):
        super(PinskyRinzelCA3Cell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PinskyRinzelCA3Cell')
        if self.i_soma is not None and 'i_soma' not in already_processed:
            already_processed.add('i_soma')
            outfile.write(' iSoma=%s' % (quote_attrib(self.i_soma), ))
        if self.i_dend is not None and 'i_dend' not in already_processed:
            already_processed.add('i_dend')
            outfile.write(' iDend=%s' % (quote_attrib(self.i_dend), ))
        if self.gc is not None and 'gc' not in already_processed:
            already_processed.add('gc')
            outfile.write(' gc=%s' % (quote_attrib(self.gc), ))
        if self.g_ls is not None and 'g_ls' not in already_processed:
            already_processed.add('g_ls')
            outfile.write(' gLs=%s' % (quote_attrib(self.g_ls), ))
        if self.g_ld is not None and 'g_ld' not in already_processed:
            already_processed.add('g_ld')
            outfile.write(' gLd=%s' % (quote_attrib(self.g_ld), ))
        if self.g_na is not None and 'g_na' not in already_processed:
            already_processed.add('g_na')
            outfile.write(' gNa=%s' % (quote_attrib(self.g_na), ))
        if self.g_kdr is not None and 'g_kdr' not in already_processed:
            already_processed.add('g_kdr')
            outfile.write(' gKdr=%s' % (quote_attrib(self.g_kdr), ))
        if self.g_ca is not None and 'g_ca' not in already_processed:
            already_processed.add('g_ca')
            outfile.write(' gCa=%s' % (quote_attrib(self.g_ca), ))
        if self.g_kahp is not None and 'g_kahp' not in already_processed:
            already_processed.add('g_kahp')
            outfile.write(' gKahp=%s' % (quote_attrib(self.g_kahp), ))
        if self.g_kc is not None and 'g_kc' not in already_processed:
            already_processed.add('g_kc')
            outfile.write(' gKC=%s' % (quote_attrib(self.g_kc), ))
        if self.g_nmda is not None and 'g_nmda' not in already_processed:
            already_processed.add('g_nmda')
            outfile.write(' gNmda=%s' % (quote_attrib(self.g_nmda), ))
        if self.g_ampa is not None and 'g_ampa' not in already_processed:
            already_processed.add('g_ampa')
            outfile.write(' gAmpa=%s' % (quote_attrib(self.g_ampa), ))
        if self.e_na is not None and 'e_na' not in already_processed:
            already_processed.add('e_na')
            outfile.write(' eNa=%s' % (quote_attrib(self.e_na), ))
        if self.e_ca is not None and 'e_ca' not in already_processed:
            already_processed.add('e_ca')
            outfile.write(' eCa=%s' % (quote_attrib(self.e_ca), ))
        if self.e_k is not None and 'e_k' not in already_processed:
            already_processed.add('e_k')
            outfile.write(' eK=%s' % (quote_attrib(self.e_k), ))
        if self.e_l is not None and 'e_l' not in already_processed:
            already_processed.add('e_l')
            outfile.write(' eL=%s' % (quote_attrib(self.e_l), ))
        if self.qd0 is not None and 'qd0' not in already_processed:
            already_processed.add('qd0')
            outfile.write(' qd0=%s' % (quote_attrib(self.qd0), ))
        if self.pp is not None and 'pp' not in already_processed:
            already_processed.add('pp')
            outfile.write(' pp=%s' % (quote_attrib(self.pp), ))
        if self.alphac is not None and 'alphac' not in already_processed:
            already_processed.add('alphac')
            outfile.write(' alphac=%s' % (quote_attrib(self.alphac), ))
        if self.betac is not None and 'betac' not in already_processed:
            already_processed.add('betac')
            outfile.write(' betac=%s' % (quote_attrib(self.betac), ))
        if self.cm is not None and 'cm' not in already_processed:
            already_processed.add('cm')
            outfile.write(' cm=%s' % (quote_attrib(self.cm), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PinskyRinzelCA3Cell', fromsubclass_=False, pretty_print=True):
        super(PinskyRinzelCA3Cell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('iSoma', node)
        if value is not None and 'iSoma' not in already_processed:
            already_processed.add('iSoma')
            self.i_soma = value
            self.validate_Nml2Quantity_currentDensity(self.i_soma)    # validate type Nml2Quantity_currentDensity
        value = find_attr_value_('iDend', node)
        if value is not None and 'iDend' not in already_processed:
            already_processed.add('iDend')
            self.i_dend = value
            self.validate_Nml2Quantity_currentDensity(self.i_dend)    # validate type Nml2Quantity_currentDensity
        value = find_attr_value_('gc', node)
        if value is not None and 'gc' not in already_processed:
            already_processed.add('gc')
            self.gc = value
            self.validate_Nml2Quantity_conductanceDensity(self.gc)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gLs', node)
        if value is not None and 'gLs' not in already_processed:
            already_processed.add('gLs')
            self.g_ls = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_ls)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gLd', node)
        if value is not None and 'gLd' not in already_processed:
            already_processed.add('gLd')
            self.g_ld = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_ld)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gNa', node)
        if value is not None and 'gNa' not in already_processed:
            already_processed.add('gNa')
            self.g_na = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_na)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gKdr', node)
        if value is not None and 'gKdr' not in already_processed:
            already_processed.add('gKdr')
            self.g_kdr = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_kdr)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gCa', node)
        if value is not None and 'gCa' not in already_processed:
            already_processed.add('gCa')
            self.g_ca = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_ca)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gKahp', node)
        if value is not None and 'gKahp' not in already_processed:
            already_processed.add('gKahp')
            self.g_kahp = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_kahp)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gKC', node)
        if value is not None and 'gKC' not in already_processed:
            already_processed.add('gKC')
            self.g_kc = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_kc)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gNmda', node)
        if value is not None and 'gNmda' not in already_processed:
            already_processed.add('gNmda')
            self.g_nmda = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_nmda)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('gAmpa', node)
        if value is not None and 'gAmpa' not in already_processed:
            already_processed.add('gAmpa')
            self.g_ampa = value
            self.validate_Nml2Quantity_conductanceDensity(self.g_ampa)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('eNa', node)
        if value is not None and 'eNa' not in already_processed:
            already_processed.add('eNa')
            self.e_na = value
            self.validate_Nml2Quantity_voltage(self.e_na)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('eCa', node)
        if value is not None and 'eCa' not in already_processed:
            already_processed.add('eCa')
            self.e_ca = value
            self.validate_Nml2Quantity_voltage(self.e_ca)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('eK', node)
        if value is not None and 'eK' not in already_processed:
            already_processed.add('eK')
            self.e_k = value
            self.validate_Nml2Quantity_voltage(self.e_k)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('eL', node)
        if value is not None and 'eL' not in already_processed:
            already_processed.add('eL')
            self.e_l = value
            self.validate_Nml2Quantity_voltage(self.e_l)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('qd0', node)
        if value is not None and 'qd0' not in already_processed:
            already_processed.add('qd0')
            self.qd0 = value
            self.validate_Nml2Quantity_none(self.qd0)    # validate type Nml2Quantity_none
        value = find_attr_value_('pp', node)
        if value is not None and 'pp' not in already_processed:
            already_processed.add('pp')
            self.pp = value
            self.validate_Nml2Quantity_none(self.pp)    # validate type Nml2Quantity_none
        value = find_attr_value_('alphac', node)
        if value is not None and 'alphac' not in already_processed:
            already_processed.add('alphac')
            self.alphac = value
            self.validate_Nml2Quantity_none(self.alphac)    # validate type Nml2Quantity_none
        value = find_attr_value_('betac', node)
        if value is not None and 'betac' not in already_processed:
            already_processed.add('betac')
            self.betac = value
            self.validate_Nml2Quantity_none(self.betac)    # validate type Nml2Quantity_none
        value = find_attr_value_('cm', node)
        if value is not None and 'cm' not in already_processed:
            already_processed.add('cm')
            self.cm = value
            self.validate_Nml2Quantity_specificCapacitance(self.cm)    # validate type Nml2Quantity_specificCapacitance
        super(PinskyRinzelCA3Cell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PinskyRinzelCA3Cell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class PinskyRinzelCA3Cell


class FitzHughNagumo1969Cell(BaseCell):
    member_data_items_ = [
        MemberSpec_('a', 'Nml2Quantity_none', 0),
        MemberSpec_('b', 'Nml2Quantity_none', 0),
        MemberSpec_('I', 'Nml2Quantity_none', 0),
        MemberSpec_('phi', 'Nml2Quantity_none', 0),
        MemberSpec_('V0', 'Nml2Quantity_none', 0),
        MemberSpec_('W0', 'Nml2Quantity_none', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, a=None, b=None, I=None, phi=None, V0=None, W0=None):
        self.original_tagname_ = None
        super(FitzHughNagumo1969Cell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.a = _cast(None, a)
        self.b = _cast(None, b)
        self.I = _cast(None, I)
        self.phi = _cast(None, phi)
        self.V0 = _cast(None, V0)
        self.W0 = _cast(None, W0)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FitzHughNagumo1969Cell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FitzHughNagumo1969Cell.subclass:
            return FitzHughNagumo1969Cell.subclass(*args_, **kwargs_)
        else:
            return FitzHughNagumo1969Cell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def hasContent_(self):
        if (
            super(FitzHughNagumo1969Cell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FitzHughNagumo1969Cell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FitzHughNagumo1969Cell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FitzHughNagumo1969Cell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FitzHughNagumo1969Cell'):
        super(FitzHughNagumo1969Cell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FitzHughNagumo1969Cell')
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a=%s' % (quote_attrib(self.a), ))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b=%s' % (quote_attrib(self.b), ))
        if self.I is not None and 'I' not in already_processed:
            already_processed.add('I')
            outfile.write(' I=%s' % (quote_attrib(self.I), ))
        if self.phi is not None and 'phi' not in already_processed:
            already_processed.add('phi')
            outfile.write(' phi=%s' % (quote_attrib(self.phi), ))
        if self.V0 is not None and 'V0' not in already_processed:
            already_processed.add('V0')
            outfile.write(' V0=%s' % (quote_attrib(self.V0), ))
        if self.W0 is not None and 'W0' not in already_processed:
            already_processed.add('W0')
            outfile.write(' W0=%s' % (quote_attrib(self.W0), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FitzHughNagumo1969Cell', fromsubclass_=False, pretty_print=True):
        super(FitzHughNagumo1969Cell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            self.a = value
            self.validate_Nml2Quantity_none(self.a)    # validate type Nml2Quantity_none
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            self.b = value
            self.validate_Nml2Quantity_none(self.b)    # validate type Nml2Quantity_none
        value = find_attr_value_('I', node)
        if value is not None and 'I' not in already_processed:
            already_processed.add('I')
            self.I = value
            self.validate_Nml2Quantity_none(self.I)    # validate type Nml2Quantity_none
        value = find_attr_value_('phi', node)
        if value is not None and 'phi' not in already_processed:
            already_processed.add('phi')
            self.phi = value
            self.validate_Nml2Quantity_none(self.phi)    # validate type Nml2Quantity_none
        value = find_attr_value_('V0', node)
        if value is not None and 'V0' not in already_processed:
            already_processed.add('V0')
            self.V0 = value
            self.validate_Nml2Quantity_none(self.V0)    # validate type Nml2Quantity_none
        value = find_attr_value_('W0', node)
        if value is not None and 'W0' not in already_processed:
            already_processed.add('W0')
            self.W0 = value
            self.validate_Nml2Quantity_none(self.W0)    # validate type Nml2Quantity_none
        super(FitzHughNagumo1969Cell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FitzHughNagumo1969Cell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FitzHughNagumo1969Cell


class FitzHughNagumoCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('I', 'Nml2Quantity_none', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, I=None):
        self.original_tagname_ = None
        super(FitzHughNagumoCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.I = _cast(None, I)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FitzHughNagumoCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FitzHughNagumoCell.subclass:
            return FitzHughNagumoCell.subclass(*args_, **kwargs_)
        else:
            return FitzHughNagumoCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def hasContent_(self):
        if (
            super(FitzHughNagumoCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FitzHughNagumoCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FitzHughNagumoCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FitzHughNagumoCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FitzHughNagumoCell'):
        super(FitzHughNagumoCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FitzHughNagumoCell')
        if self.I is not None and 'I' not in already_processed:
            already_processed.add('I')
            outfile.write(' I=%s' % (quote_attrib(self.I), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FitzHughNagumoCell', fromsubclass_=False, pretty_print=True):
        super(FitzHughNagumoCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('I', node)
        if value is not None and 'I' not in already_processed:
            already_processed.add('I')
            self.I = value
            self.validate_Nml2Quantity_none(self.I)    # validate type Nml2Quantity_none
        super(FitzHughNagumoCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FitzHughNagumoCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FitzHughNagumoCell


class BaseCellMembPotCap(BaseCell):
    """This is to prevent it conflicting with attribute c (lowercase) e.g.
    in izhikevichCell2007"""
    member_data_items_ = [
        MemberSpec_('C', 'Nml2Quantity_capacitance', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, C=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseCellMembPotCap, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.C = _cast(None, C)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseCellMembPotCap)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseCellMembPotCap.subclass:
            return BaseCellMembPotCap.subclass(*args_, **kwargs_)
        else:
            return BaseCellMembPotCap(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_capacitance(self, value):
        # Validate type Nml2Quantity_capacitance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_capacitance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_capacitance_patterns_, ))
    validate_Nml2Quantity_capacitance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(F$|^uF$|^nF$|^pF)$']]
    def hasContent_(self):
        if (
            super(BaseCellMembPotCap, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseCellMembPotCap', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCellMembPotCap')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseCellMembPotCap', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseCellMembPotCap'):
        super(BaseCellMembPotCap, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCellMembPotCap')
        if self.C is not None and 'C' not in already_processed:
            already_processed.add('C')
            outfile.write(' C=%s' % (quote_attrib(self.C), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseCellMembPotCap', fromsubclass_=False, pretty_print=True):
        super(BaseCellMembPotCap, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('C', node)
        if value is not None and 'C' not in already_processed:
            already_processed.add('C')
            self.C = value
            self.validate_Nml2Quantity_capacitance(self.C)    # validate type Nml2Quantity_capacitance
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseCellMembPotCap, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseCellMembPotCap, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseCellMembPotCap


class IzhikevichCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('v0', 'Nml2Quantity_voltage', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
        MemberSpec_('a', 'Nml2Quantity_none', 0),
        MemberSpec_('b', 'Nml2Quantity_none', 0),
        MemberSpec_('c', 'Nml2Quantity_none', 0),
        MemberSpec_('d', 'Nml2Quantity_none', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, v0=None, thresh=None, a=None, b=None, c=None, d=None):
        self.original_tagname_ = None
        super(IzhikevichCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.v0 = _cast(None, v0)
        self.thresh = _cast(None, thresh)
        self.a = _cast(None, a)
        self.b = _cast(None, b)
        self.c = _cast(None, c)
        self.d = _cast(None, d)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IzhikevichCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IzhikevichCell.subclass:
            return IzhikevichCell.subclass(*args_, **kwargs_)
        else:
            return IzhikevichCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_none_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_none_patterns_, ))
    validate_Nml2Quantity_none_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?$']]
    def hasContent_(self):
        if (
            super(IzhikevichCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IzhikevichCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IzhikevichCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IzhikevichCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IzhikevichCell'):
        super(IzhikevichCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IzhikevichCell')
        if self.v0 is not None and 'v0' not in already_processed:
            already_processed.add('v0')
            outfile.write(' v0=%s' % (quote_attrib(self.v0), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a=%s' % (quote_attrib(self.a), ))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b=%s' % (quote_attrib(self.b), ))
        if self.c is not None and 'c' not in already_processed:
            already_processed.add('c')
            outfile.write(' c=%s' % (quote_attrib(self.c), ))
        if self.d is not None and 'd' not in already_processed:
            already_processed.add('d')
            outfile.write(' d=%s' % (quote_attrib(self.d), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IzhikevichCell', fromsubclass_=False, pretty_print=True):
        super(IzhikevichCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('v0', node)
        if value is not None and 'v0' not in already_processed:
            already_processed.add('v0')
            self.v0 = value
            self.validate_Nml2Quantity_voltage(self.v0)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            self.a = value
            self.validate_Nml2Quantity_none(self.a)    # validate type Nml2Quantity_none
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            self.b = value
            self.validate_Nml2Quantity_none(self.b)    # validate type Nml2Quantity_none
        value = find_attr_value_('c', node)
        if value is not None and 'c' not in already_processed:
            already_processed.add('c')
            self.c = value
            self.validate_Nml2Quantity_none(self.c)    # validate type Nml2Quantity_none
        value = find_attr_value_('d', node)
        if value is not None and 'd' not in already_processed:
            already_processed.add('d')
            self.d = value
            self.validate_Nml2Quantity_none(self.d)    # validate type Nml2Quantity_none
        super(IzhikevichCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IzhikevichCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IzhikevichCell


class IafCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('leakReversal', 'Nml2Quantity_voltage', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
        MemberSpec_('reset', 'Nml2Quantity_voltage', 0),
        MemberSpec_('C', 'Nml2Quantity_capacitance', 0),
        MemberSpec_('leakConductance', 'Nml2Quantity_conductance', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, leak_reversal=None, thresh=None, reset=None, C=None, leak_conductance=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IafCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.leak_reversal = _cast(None, leak_reversal)
        self.thresh = _cast(None, thresh)
        self.reset = _cast(None, reset)
        self.C = _cast(None, C)
        self.leak_conductance = _cast(None, leak_conductance)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IafCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IafCell.subclass:
            return IafCell.subclass(*args_, **kwargs_)
        else:
            return IafCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_capacitance(self, value):
        # Validate type Nml2Quantity_capacitance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_capacitance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_capacitance_patterns_, ))
    validate_Nml2Quantity_capacitance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(F$|^uF$|^nF$|^pF)$']]
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def hasContent_(self):
        if (
            super(IafCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IafCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IafCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IafCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IafCell'):
        super(IafCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IafCell')
        if self.leak_reversal is not None and 'leak_reversal' not in already_processed:
            already_processed.add('leak_reversal')
            outfile.write(' leakReversal=%s' % (quote_attrib(self.leak_reversal), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            outfile.write(' reset=%s' % (quote_attrib(self.reset), ))
        if self.C is not None and 'C' not in already_processed:
            already_processed.add('C')
            outfile.write(' C=%s' % (quote_attrib(self.C), ))
        if self.leak_conductance is not None and 'leak_conductance' not in already_processed:
            already_processed.add('leak_conductance')
            outfile.write(' leakConductance=%s' % (quote_attrib(self.leak_conductance), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IafCell', fromsubclass_=False, pretty_print=True):
        super(IafCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('leakReversal', node)
        if value is not None and 'leakReversal' not in already_processed:
            already_processed.add('leakReversal')
            self.leak_reversal = value
            self.validate_Nml2Quantity_voltage(self.leak_reversal)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('reset', node)
        if value is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            self.reset = value
            self.validate_Nml2Quantity_voltage(self.reset)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('C', node)
        if value is not None and 'C' not in already_processed:
            already_processed.add('C')
            self.C = value
            self.validate_Nml2Quantity_capacitance(self.C)    # validate type Nml2Quantity_capacitance
        value = find_attr_value_('leakConductance', node)
        if value is not None and 'leakConductance' not in already_processed:
            already_processed.add('leakConductance')
            self.leak_conductance = value
            self.validate_Nml2Quantity_conductance(self.leak_conductance)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IafCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IafCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IafCell


class IafTauCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('leakReversal', 'Nml2Quantity_voltage', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
        MemberSpec_('reset', 'Nml2Quantity_voltage', 0),
        MemberSpec_('tau', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, leak_reversal=None, thresh=None, reset=None, tau=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IafTauCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.leak_reversal = _cast(None, leak_reversal)
        self.thresh = _cast(None, thresh)
        self.reset = _cast(None, reset)
        self.tau = _cast(None, tau)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IafTauCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IafTauCell.subclass:
            return IafTauCell.subclass(*args_, **kwargs_)
        else:
            return IafTauCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(IafTauCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IafTauCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IafTauCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IafTauCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IafTauCell'):
        super(IafTauCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IafTauCell')
        if self.leak_reversal is not None and 'leak_reversal' not in already_processed:
            already_processed.add('leak_reversal')
            outfile.write(' leakReversal=%s' % (quote_attrib(self.leak_reversal), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            outfile.write(' reset=%s' % (quote_attrib(self.reset), ))
        if self.tau is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            outfile.write(' tau=%s' % (quote_attrib(self.tau), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IafTauCell', fromsubclass_=False, pretty_print=True):
        super(IafTauCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('leakReversal', node)
        if value is not None and 'leakReversal' not in already_processed:
            already_processed.add('leakReversal')
            self.leak_reversal = value
            self.validate_Nml2Quantity_voltage(self.leak_reversal)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('reset', node)
        if value is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            self.reset = value
            self.validate_Nml2Quantity_voltage(self.reset)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('tau', node)
        if value is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            self.tau = value
            self.validate_Nml2Quantity_time(self.tau)    # validate type Nml2Quantity_time
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IafTauCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IafTauCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IafTauCell


class GradedSynapse(BaseSynapse):
    """Based on synapse in Methods of
    http://www.nature.com/neuro/journal/v7/n12/abs/nn1352.html."""
    member_data_items_ = [
        MemberSpec_('conductance', 'Nml2Quantity_conductance', 0),
        MemberSpec_('delta', 'Nml2Quantity_voltage', 0),
        MemberSpec_('Vth', 'Nml2Quantity_voltage', 0),
        MemberSpec_('k', 'Nml2Quantity_pertime', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, conductance=None, delta=None, Vth=None, k=None, erev=None):
        self.original_tagname_ = None
        super(GradedSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.conductance = _cast(None, conductance)
        self.delta = _cast(None, delta)
        self.Vth = _cast(None, Vth)
        self.k = _cast(None, k)
        self.erev = _cast(None, erev)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GradedSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GradedSynapse.subclass:
            return GradedSynapse.subclass(*args_, **kwargs_)
        else:
            return GradedSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_pertime_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_pertime_patterns_, ))
    validate_Nml2Quantity_pertime_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s$|^per_ms$|^Hz)$']]
    def hasContent_(self):
        if (
            super(GradedSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GradedSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GradedSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GradedSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GradedSynapse'):
        super(GradedSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GradedSynapse')
        if self.conductance is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            outfile.write(' conductance=%s' % (quote_attrib(self.conductance), ))
        if self.delta is not None and 'delta' not in already_processed:
            already_processed.add('delta')
            outfile.write(' delta=%s' % (quote_attrib(self.delta), ))
        if self.Vth is not None and 'Vth' not in already_processed:
            already_processed.add('Vth')
            outfile.write(' Vth=%s' % (quote_attrib(self.Vth), ))
        if self.k is not None and 'k' not in already_processed:
            already_processed.add('k')
            outfile.write(' k=%s' % (quote_attrib(self.k), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GradedSynapse', fromsubclass_=False, pretty_print=True):
        super(GradedSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('conductance', node)
        if value is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            self.conductance = value
            self.validate_Nml2Quantity_conductance(self.conductance)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('delta', node)
        if value is not None and 'delta' not in already_processed:
            already_processed.add('delta')
            self.delta = value
            self.validate_Nml2Quantity_voltage(self.delta)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('Vth', node)
        if value is not None and 'Vth' not in already_processed:
            already_processed.add('Vth')
            self.Vth = value
            self.validate_Nml2Quantity_voltage(self.Vth)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('k', node)
        if value is not None and 'k' not in already_processed:
            already_processed.add('k')
            self.k = value
            self.validate_Nml2Quantity_pertime(self.k)    # validate type Nml2Quantity_pertime
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        super(GradedSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(GradedSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class GradedSynapse


class LinearGradedSynapse(BaseSynapse):
    """Behaves just like a one way gap junction."""
    member_data_items_ = [
        MemberSpec_('conductance', 'Nml2Quantity_conductance', 0),
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, conductance=None):
        self.original_tagname_ = None
        super(LinearGradedSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.conductance = _cast(None, conductance)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LinearGradedSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LinearGradedSynapse.subclass:
            return LinearGradedSynapse.subclass(*args_, **kwargs_)
        else:
            return LinearGradedSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def hasContent_(self):
        if (
            super(LinearGradedSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinearGradedSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinearGradedSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LinearGradedSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinearGradedSynapse'):
        super(LinearGradedSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LinearGradedSynapse')
        if self.conductance is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            outfile.write(' conductance=%s' % (quote_attrib(self.conductance), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LinearGradedSynapse', fromsubclass_=False, pretty_print=True):
        super(LinearGradedSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('conductance', node)
        if value is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            self.conductance = value
            self.validate_Nml2Quantity_conductance(self.conductance)    # validate type Nml2Quantity_conductance
        super(LinearGradedSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LinearGradedSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class LinearGradedSynapse


class SilentSynapse(BaseSynapse):
    """Dummy synapse which emits no current. Used as presynaptic endpoint
    for analog synaptic connection (continuousConnection)."""
    member_data_items_ = [
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None):
        self.original_tagname_ = None
        super(SilentSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SilentSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SilentSynapse.subclass:
            return SilentSynapse.subclass(*args_, **kwargs_)
        else:
            return SilentSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(SilentSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SilentSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SilentSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SilentSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SilentSynapse'):
        super(SilentSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SilentSynapse')
    def exportChildren(self, outfile, level, namespace_='', name_='SilentSynapse', fromsubclass_=False, pretty_print=True):
        super(SilentSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(SilentSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SilentSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SilentSynapse


class GapJunction(BaseSynapse):
    """Gap junction/single electrical connection"""
    member_data_items_ = [
        MemberSpec_('conductance', 'Nml2Quantity_conductance', 0),
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, conductance=None):
        self.original_tagname_ = None
        super(GapJunction, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.conductance = _cast(None, conductance)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GapJunction)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GapJunction.subclass:
            return GapJunction.subclass(*args_, **kwargs_)
        else:
            return GapJunction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def hasContent_(self):
        if (
            super(GapJunction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GapJunction', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GapJunction')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GapJunction', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GapJunction'):
        super(GapJunction, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GapJunction')
        if self.conductance is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            outfile.write(' conductance=%s' % (quote_attrib(self.conductance), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GapJunction', fromsubclass_=False, pretty_print=True):
        super(GapJunction, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('conductance', node)
        if value is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            self.conductance = value
            self.validate_Nml2Quantity_conductance(self.conductance)    # validate type Nml2Quantity_conductance
        super(GapJunction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(GapJunction, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class GapJunction


class BaseCurrentBasedSynapse(BaseSynapse):
    member_data_items_ = [
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseCurrentBasedSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseCurrentBasedSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseCurrentBasedSynapse.subclass:
            return BaseCurrentBasedSynapse.subclass(*args_, **kwargs_)
        else:
            return BaseCurrentBasedSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BaseCurrentBasedSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseCurrentBasedSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCurrentBasedSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseCurrentBasedSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseCurrentBasedSynapse'):
        super(BaseCurrentBasedSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCurrentBasedSynapse')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseCurrentBasedSynapse', fromsubclass_=False, pretty_print=True):
        super(BaseCurrentBasedSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseCurrentBasedSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseCurrentBasedSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseCurrentBasedSynapse


class BaseVoltageDepSynapse(BaseSynapse):
    member_data_items_ = [
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseVoltageDepSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseVoltageDepSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseVoltageDepSynapse.subclass:
            return BaseVoltageDepSynapse.subclass(*args_, **kwargs_)
        else:
            return BaseVoltageDepSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BaseVoltageDepSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseVoltageDepSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseVoltageDepSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseVoltageDepSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseVoltageDepSynapse'):
        super(BaseVoltageDepSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseVoltageDepSynapse')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseVoltageDepSynapse', fromsubclass_=False, pretty_print=True):
        super(BaseVoltageDepSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseVoltageDepSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseVoltageDepSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseVoltageDepSynapse


class IonChannel(IonChannelScalable):
    """Note ionChannel and ionChannelHH are currently functionally
    identical. This is needed since many existing examples use
    ionChannel, some use ionChannelHH. NeuroML v2beta4 should remove
    one of these, probably ionChannelHH."""
    member_data_items_ = [
        MemberSpec_('species', 'NmlId', 0),
        MemberSpec_('type', 'channelTypes', 0),
        MemberSpec_('conductance', 'Nml2Quantity_conductance', 0),
        MemberSpec_('gates', 'GateHHUndetermined', 1),
        MemberSpec_('gate_hh_rates', 'GateHHRates', 1),
        MemberSpec_('gate_h_hrates_taus', 'GateHHRatesTau', 1),
        MemberSpec_('gate_hh_tau_infs', 'GateHHTauInf', 1),
        MemberSpec_('gate_h_hrates_infs', 'GateHHRatesInf', 1),
        MemberSpec_('gate_h_hrates_tau_infs', 'GateHHRatesTauInf', 1),
        MemberSpec_('gate_hh_instantaneouses', 'GateHHInstantaneous', 1),
        MemberSpec_('gate_fractionals', 'GateFractional', 1),
    ]
    subclass = None
    superclass = IonChannelScalable
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, q10_conductance_scalings=None, species=None, type=None, conductance=None, gates=None, gate_hh_rates=None, gate_h_hrates_taus=None, gate_hh_tau_infs=None, gate_h_hrates_infs=None, gate_h_hrates_tau_infs=None, gate_hh_instantaneouses=None, gate_fractionals=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IonChannel, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, q10_conductance_scalings, extensiontype_, )
        self.species = _cast(None, species)
        self.type = _cast(None, type)
        self.conductance = _cast(None, conductance)
        if gates is None:
            self.gates = []
        else:
            self.gates = gates
        if gate_hh_rates is None:
            self.gate_hh_rates = []
        else:
            self.gate_hh_rates = gate_hh_rates
        if gate_h_hrates_taus is None:
            self.gate_h_hrates_taus = []
        else:
            self.gate_h_hrates_taus = gate_h_hrates_taus
        if gate_hh_tau_infs is None:
            self.gate_hh_tau_infs = []
        else:
            self.gate_hh_tau_infs = gate_hh_tau_infs
        if gate_h_hrates_infs is None:
            self.gate_h_hrates_infs = []
        else:
            self.gate_h_hrates_infs = gate_h_hrates_infs
        if gate_h_hrates_tau_infs is None:
            self.gate_h_hrates_tau_infs = []
        else:
            self.gate_h_hrates_tau_infs = gate_h_hrates_tau_infs
        if gate_hh_instantaneouses is None:
            self.gate_hh_instantaneouses = []
        else:
            self.gate_hh_instantaneouses = gate_hh_instantaneouses
        if gate_fractionals is None:
            self.gate_fractionals = []
        else:
            self.gate_fractionals = gate_fractionals
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IonChannel)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IonChannel.subclass:
            return IonChannel.subclass(*args_, **kwargs_)
        else:
            return IonChannel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def validate_channelTypes(self, value):
        # Validate type channelTypes, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['ionChannelPassive', 'ionChannelHH']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on channelTypes' % {"value" : value.encode("utf-8")} )
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def hasContent_(self):
        if (
            self.gates or
            self.gate_hh_rates or
            self.gate_h_hrates_taus or
            self.gate_hh_tau_infs or
            self.gate_h_hrates_infs or
            self.gate_h_hrates_tau_infs or
            self.gate_hh_instantaneouses or
            self.gate_fractionals or
            super(IonChannel, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IonChannel', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IonChannel', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IonChannel'):
        super(IonChannel, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannel')
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            outfile.write(' species=%s' % (quote_attrib(self.species), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.conductance is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            outfile.write(' conductance=%s' % (quote_attrib(self.conductance), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IonChannel', fromsubclass_=False, pretty_print=True):
        super(IonChannel, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for gate_ in self.gates:
            gate_.export(outfile, level, namespace_, name_='gate', pretty_print=pretty_print)
        for gateHHrates_ in self.gate_hh_rates:
            gateHHrates_.export(outfile, level, namespace_, name_='gateHHrates', pretty_print=pretty_print)
        for gateHHratesTau_ in self.gate_h_hrates_taus:
            gateHHratesTau_.export(outfile, level, namespace_, name_='gateHHratesTau', pretty_print=pretty_print)
        for gateHHtauInf_ in self.gate_hh_tau_infs:
            gateHHtauInf_.export(outfile, level, namespace_, name_='gateHHtauInf', pretty_print=pretty_print)
        for gateHHratesInf_ in self.gate_h_hrates_infs:
            gateHHratesInf_.export(outfile, level, namespace_, name_='gateHHratesInf', pretty_print=pretty_print)
        for gateHHratesTauInf_ in self.gate_h_hrates_tau_infs:
            gateHHratesTauInf_.export(outfile, level, namespace_, name_='gateHHratesTauInf', pretty_print=pretty_print)
        for gateHHInstantaneous_ in self.gate_hh_instantaneouses:
            gateHHInstantaneous_.export(outfile, level, namespace_, name_='gateHHInstantaneous', pretty_print=pretty_print)
        for gateFractional_ in self.gate_fractionals:
            gateFractional_.export(outfile, level, namespace_, name_='gateFractional', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('species', node)
        if value is not None and 'species' not in already_processed:
            already_processed.add('species')
            self.species = value
            self.validate_NmlId(self.species)    # validate type NmlId
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_channelTypes(self.type)    # validate type channelTypes
        value = find_attr_value_('conductance', node)
        if value is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            self.conductance = value
            self.validate_Nml2Quantity_conductance(self.conductance)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IonChannel, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gate':
            obj_ = GateHHUndetermined.factory()
            obj_.build(child_)
            self.gates.append(obj_)
            obj_.original_tagname_ = 'gate'
        elif nodeName_ == 'gateHHrates':
            obj_ = GateHHRates.factory()
            obj_.build(child_)
            self.gate_hh_rates.append(obj_)
            obj_.original_tagname_ = 'gateHHrates'
        elif nodeName_ == 'gateHHratesTau':
            obj_ = GateHHRatesTau.factory()
            obj_.build(child_)
            self.gate_h_hrates_taus.append(obj_)
            obj_.original_tagname_ = 'gateHHratesTau'
        elif nodeName_ == 'gateHHtauInf':
            obj_ = GateHHTauInf.factory()
            obj_.build(child_)
            self.gate_hh_tau_infs.append(obj_)
            obj_.original_tagname_ = 'gateHHtauInf'
        elif nodeName_ == 'gateHHratesInf':
            obj_ = GateHHRatesInf.factory()
            obj_.build(child_)
            self.gate_h_hrates_infs.append(obj_)
            obj_.original_tagname_ = 'gateHHratesInf'
        elif nodeName_ == 'gateHHratesTauInf':
            obj_ = GateHHRatesTauInf.factory()
            obj_.build(child_)
            self.gate_h_hrates_tau_infs.append(obj_)
            obj_.original_tagname_ = 'gateHHratesTauInf'
        elif nodeName_ == 'gateHHInstantaneous':
            obj_ = GateHHInstantaneous.factory()
            obj_.build(child_)
            self.gate_hh_instantaneouses.append(obj_)
            obj_.original_tagname_ = 'gateHHInstantaneous'
        elif nodeName_ == 'gateFractional':
            obj_ = GateFractional.factory()
            obj_.build(child_)
            self.gate_fractionals.append(obj_)
            obj_.original_tagname_ = 'gateFractional'
        super(IonChannel, self).buildChildren(child_, node, nodeName_, True)
# end class IonChannel


class AlphaCurrSynapse(BasePynnSynapse):
    member_data_items_ = [
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, tau_syn=None):
        self.original_tagname_ = None
        super(AlphaCurrSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, tau_syn, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AlphaCurrSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AlphaCurrSynapse.subclass:
            return AlphaCurrSynapse.subclass(*args_, **kwargs_)
        else:
            return AlphaCurrSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(AlphaCurrSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AlphaCurrSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCurrSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AlphaCurrSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AlphaCurrSynapse'):
        super(AlphaCurrSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCurrSynapse')
    def exportChildren(self, outfile, level, namespace_='', name_='AlphaCurrSynapse', fromsubclass_=False, pretty_print=True):
        super(AlphaCurrSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AlphaCurrSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AlphaCurrSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AlphaCurrSynapse


class ExpCurrSynapse(BasePynnSynapse):
    member_data_items_ = [
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, tau_syn=None):
        self.original_tagname_ = None
        super(ExpCurrSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, tau_syn, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExpCurrSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExpCurrSynapse.subclass:
            return ExpCurrSynapse.subclass(*args_, **kwargs_)
        else:
            return ExpCurrSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ExpCurrSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExpCurrSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCurrSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ExpCurrSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExpCurrSynapse'):
        super(ExpCurrSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCurrSynapse')
    def exportChildren(self, outfile, level, namespace_='', name_='ExpCurrSynapse', fromsubclass_=False, pretty_print=True):
        super(ExpCurrSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ExpCurrSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ExpCurrSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ExpCurrSynapse


class AlphaCondSynapse(BasePynnSynapse):
    member_data_items_ = [
        MemberSpec_('e_rev', 'xs:float', 0),
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, tau_syn=None, e_rev=None):
        self.original_tagname_ = None
        super(AlphaCondSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, tau_syn, )
        self.e_rev = _cast(float, e_rev)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AlphaCondSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AlphaCondSynapse.subclass:
            return AlphaCondSynapse.subclass(*args_, **kwargs_)
        else:
            return AlphaCondSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(AlphaCondSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AlphaCondSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCondSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AlphaCondSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AlphaCondSynapse'):
        super(AlphaCondSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCondSynapse')
        if self.e_rev is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            outfile.write(' e_rev="%s"' % self.gds_format_float(self.e_rev, input_name='e_rev'))
    def exportChildren(self, outfile, level, namespace_='', name_='AlphaCondSynapse', fromsubclass_=False, pretty_print=True):
        super(AlphaCondSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('e_rev', node)
        if value is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            try:
                self.e_rev = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (e_rev): %s' % exp)
        super(AlphaCondSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AlphaCondSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AlphaCondSynapse


class ExpCondSynapse(BasePynnSynapse):
    member_data_items_ = [
        MemberSpec_('e_rev', 'xs:float', 0),
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, tau_syn=None, e_rev=None):
        self.original_tagname_ = None
        super(ExpCondSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, tau_syn, )
        self.e_rev = _cast(float, e_rev)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExpCondSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExpCondSynapse.subclass:
            return ExpCondSynapse.subclass(*args_, **kwargs_)
        else:
            return ExpCondSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ExpCondSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExpCondSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCondSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ExpCondSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExpCondSynapse'):
        super(ExpCondSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCondSynapse')
        if self.e_rev is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            outfile.write(' e_rev="%s"' % self.gds_format_float(self.e_rev, input_name='e_rev'))
    def exportChildren(self, outfile, level, namespace_='', name_='ExpCondSynapse', fromsubclass_=False, pretty_print=True):
        super(ExpCondSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('e_rev', node)
        if value is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            try:
                self.e_rev = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (e_rev): %s' % exp)
        super(ExpCondSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ExpCondSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ExpCondSynapse


class HH_cond_exp(basePyNNCell):
    member_data_items_ = [
        MemberSpec_('v_offset', 'xs:float', 0),
        MemberSpec_('e_rev_E', 'xs:float', 0),
        MemberSpec_('e_rev_I', 'xs:float', 0),
        MemberSpec_('e_rev_K', 'xs:float', 0),
        MemberSpec_('e_rev_Na', 'xs:float', 0),
        MemberSpec_('e_rev_leak', 'xs:float', 0),
        MemberSpec_('g_leak', 'xs:float', 0),
        MemberSpec_('gbar_K', 'xs:float', 0),
        MemberSpec_('gbar_Na', 'xs:float', 0),
    ]
    subclass = None
    superclass = basePyNNCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, cm=None, i_offset=None, tau_syn_E=None, tau_syn_I=None, v_init=None, v_offset=None, e_rev_E=None, e_rev_I=None, e_rev_K=None, e_rev_Na=None, e_rev_leak=None, g_leak=None, gbar_K=None, gbar_Na=None):
        self.original_tagname_ = None
        super(HH_cond_exp, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, cm, i_offset, tau_syn_E, tau_syn_I, v_init, )
        self.v_offset = _cast(float, v_offset)
        self.e_rev_E = _cast(float, e_rev_E)
        self.e_rev_I = _cast(float, e_rev_I)
        self.e_rev_K = _cast(float, e_rev_K)
        self.e_rev_Na = _cast(float, e_rev_Na)
        self.e_rev_leak = _cast(float, e_rev_leak)
        self.g_leak = _cast(float, g_leak)
        self.gbar_K = _cast(float, gbar_K)
        self.gbar_Na = _cast(float, gbar_Na)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HH_cond_exp)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HH_cond_exp.subclass:
            return HH_cond_exp.subclass(*args_, **kwargs_)
        else:
            return HH_cond_exp(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(HH_cond_exp, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HH_cond_exp', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HH_cond_exp')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='HH_cond_exp', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HH_cond_exp'):
        super(HH_cond_exp, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HH_cond_exp')
        if self.v_offset is not None and 'v_offset' not in already_processed:
            already_processed.add('v_offset')
            outfile.write(' v_offset="%s"' % self.gds_format_float(self.v_offset, input_name='v_offset'))
        if self.e_rev_E is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            outfile.write(' e_rev_E="%s"' % self.gds_format_float(self.e_rev_E, input_name='e_rev_E'))
        if self.e_rev_I is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            outfile.write(' e_rev_I="%s"' % self.gds_format_float(self.e_rev_I, input_name='e_rev_I'))
        if self.e_rev_K is not None and 'e_rev_K' not in already_processed:
            already_processed.add('e_rev_K')
            outfile.write(' e_rev_K="%s"' % self.gds_format_float(self.e_rev_K, input_name='e_rev_K'))
        if self.e_rev_Na is not None and 'e_rev_Na' not in already_processed:
            already_processed.add('e_rev_Na')
            outfile.write(' e_rev_Na="%s"' % self.gds_format_float(self.e_rev_Na, input_name='e_rev_Na'))
        if self.e_rev_leak is not None and 'e_rev_leak' not in already_processed:
            already_processed.add('e_rev_leak')
            outfile.write(' e_rev_leak="%s"' % self.gds_format_float(self.e_rev_leak, input_name='e_rev_leak'))
        if self.g_leak is not None and 'g_leak' not in already_processed:
            already_processed.add('g_leak')
            outfile.write(' g_leak="%s"' % self.gds_format_float(self.g_leak, input_name='g_leak'))
        if self.gbar_K is not None and 'gbar_K' not in already_processed:
            already_processed.add('gbar_K')
            outfile.write(' gbar_K="%s"' % self.gds_format_float(self.gbar_K, input_name='gbar_K'))
        if self.gbar_Na is not None and 'gbar_Na' not in already_processed:
            already_processed.add('gbar_Na')
            outfile.write(' gbar_Na="%s"' % self.gds_format_float(self.gbar_Na, input_name='gbar_Na'))
    def exportChildren(self, outfile, level, namespace_='', name_='HH_cond_exp', fromsubclass_=False, pretty_print=True):
        super(HH_cond_exp, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('v_offset', node)
        if value is not None and 'v_offset' not in already_processed:
            already_processed.add('v_offset')
            try:
                self.v_offset = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (v_offset): %s' % exp)
        value = find_attr_value_('e_rev_E', node)
        if value is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            try:
                self.e_rev_E = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (e_rev_E): %s' % exp)
        value = find_attr_value_('e_rev_I', node)
        if value is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            try:
                self.e_rev_I = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (e_rev_I): %s' % exp)
        value = find_attr_value_('e_rev_K', node)
        if value is not None and 'e_rev_K' not in already_processed:
            already_processed.add('e_rev_K')
            try:
                self.e_rev_K = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (e_rev_K): %s' % exp)
        value = find_attr_value_('e_rev_Na', node)
        if value is not None and 'e_rev_Na' not in already_processed:
            already_processed.add('e_rev_Na')
            try:
                self.e_rev_Na = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (e_rev_Na): %s' % exp)
        value = find_attr_value_('e_rev_leak', node)
        if value is not None and 'e_rev_leak' not in already_processed:
            already_processed.add('e_rev_leak')
            try:
                self.e_rev_leak = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (e_rev_leak): %s' % exp)
        value = find_attr_value_('g_leak', node)
        if value is not None and 'g_leak' not in already_processed:
            already_processed.add('g_leak')
            try:
                self.g_leak = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (g_leak): %s' % exp)
        value = find_attr_value_('gbar_K', node)
        if value is not None and 'gbar_K' not in already_processed:
            already_processed.add('gbar_K')
            try:
                self.gbar_K = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (gbar_K): %s' % exp)
        value = find_attr_value_('gbar_Na', node)
        if value is not None and 'gbar_Na' not in already_processed:
            already_processed.add('gbar_Na')
            try:
                self.gbar_Na = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (gbar_Na): %s' % exp)
        super(HH_cond_exp, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(HH_cond_exp, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class HH_cond_exp


class basePyNNIaFCell(basePyNNCell):
    member_data_items_ = [
        MemberSpec_('tau_m', 'xs:float', 0),
        MemberSpec_('tau_refrac', 'xs:float', 0),
        MemberSpec_('v_reset', 'xs:float', 0),
        MemberSpec_('v_rest', 'xs:float', 0),
        MemberSpec_('v_thresh', 'xs:float', 0),
    ]
    subclass = None
    superclass = basePyNNCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, cm=None, i_offset=None, tau_syn_E=None, tau_syn_I=None, v_init=None, tau_m=None, tau_refrac=None, v_reset=None, v_rest=None, v_thresh=None, extensiontype_=None):
        self.original_tagname_ = None
        super(basePyNNIaFCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, cm, i_offset, tau_syn_E, tau_syn_I, v_init, extensiontype_, )
        self.tau_m = _cast(float, tau_m)
        self.tau_refrac = _cast(float, tau_refrac)
        self.v_reset = _cast(float, v_reset)
        self.v_rest = _cast(float, v_rest)
        self.v_thresh = _cast(float, v_thresh)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, basePyNNIaFCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if basePyNNIaFCell.subclass:
            return basePyNNIaFCell.subclass(*args_, **kwargs_)
        else:
            return basePyNNIaFCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(basePyNNIaFCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='basePyNNIaFCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNIaFCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='basePyNNIaFCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='basePyNNIaFCell'):
        super(basePyNNIaFCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNIaFCell')
        if self.tau_m is not None and 'tau_m' not in already_processed:
            already_processed.add('tau_m')
            outfile.write(' tau_m="%s"' % self.gds_format_float(self.tau_m, input_name='tau_m'))
        if self.tau_refrac is not None and 'tau_refrac' not in already_processed:
            already_processed.add('tau_refrac')
            outfile.write(' tau_refrac="%s"' % self.gds_format_float(self.tau_refrac, input_name='tau_refrac'))
        if self.v_reset is not None and 'v_reset' not in already_processed:
            already_processed.add('v_reset')
            outfile.write(' v_reset="%s"' % self.gds_format_float(self.v_reset, input_name='v_reset'))
        if self.v_rest is not None and 'v_rest' not in already_processed:
            already_processed.add('v_rest')
            outfile.write(' v_rest="%s"' % self.gds_format_float(self.v_rest, input_name='v_rest'))
        if self.v_thresh is not None and 'v_thresh' not in already_processed:
            already_processed.add('v_thresh')
            outfile.write(' v_thresh="%s"' % self.gds_format_float(self.v_thresh, input_name='v_thresh'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='basePyNNIaFCell', fromsubclass_=False, pretty_print=True):
        super(basePyNNIaFCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tau_m', node)
        if value is not None and 'tau_m' not in already_processed:
            already_processed.add('tau_m')
            try:
                self.tau_m = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (tau_m): %s' % exp)
        value = find_attr_value_('tau_refrac', node)
        if value is not None and 'tau_refrac' not in already_processed:
            already_processed.add('tau_refrac')
            try:
                self.tau_refrac = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (tau_refrac): %s' % exp)
        value = find_attr_value_('v_reset', node)
        if value is not None and 'v_reset' not in already_processed:
            already_processed.add('v_reset')
            try:
                self.v_reset = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (v_reset): %s' % exp)
        value = find_attr_value_('v_rest', node)
        if value is not None and 'v_rest' not in already_processed:
            already_processed.add('v_rest')
            try:
                self.v_rest = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (v_rest): %s' % exp)
        value = find_attr_value_('v_thresh', node)
        if value is not None and 'v_thresh' not in already_processed:
            already_processed.add('v_thresh')
            try:
                self.v_thresh = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (v_thresh): %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(basePyNNIaFCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(basePyNNIaFCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class basePyNNIaFCell


class ContinuousConnection(BaseConnectionNewFormat):
    """Individual continuous/analog synaptic connection"""
    member_data_items_ = [
        MemberSpec_('preComponent', 'NmlId', 0),
        MemberSpec_('postComponent', 'NmlId', 0),
    ]
    subclass = None
    superclass = BaseConnectionNewFormat
    def __init__(self, neuro_lex_id=None, id=None, pre_cell=None, pre_segment='0', pre_fraction_along='0.5', post_cell=None, post_segment='0', post_fraction_along='0.5', pre_component=None, post_component=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ContinuousConnection, self).__init__(neuro_lex_id, id, pre_cell, pre_segment, pre_fraction_along, post_cell, post_segment, post_fraction_along, extensiontype_, )
        self.pre_component = _cast(None, pre_component)
        self.post_component = _cast(None, post_component)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContinuousConnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContinuousConnection.subclass:
            return ContinuousConnection.subclass(*args_, **kwargs_)
        else:
            return ContinuousConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            super(ContinuousConnection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ContinuousConnection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousConnection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ContinuousConnection', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousConnection'):
        super(ContinuousConnection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousConnection')
        if self.pre_component is not None and 'pre_component' not in already_processed:
            already_processed.add('pre_component')
            outfile.write(' preComponent=%s' % (quote_attrib(self.pre_component), ))
        if self.post_component is not None and 'post_component' not in already_processed:
            already_processed.add('post_component')
            outfile.write(' postComponent=%s' % (quote_attrib(self.post_component), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousConnection', fromsubclass_=False, pretty_print=True):
        super(ContinuousConnection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('preComponent', node)
        if value is not None and 'preComponent' not in already_processed:
            already_processed.add('preComponent')
            self.pre_component = value
            self.validate_NmlId(self.pre_component)    # validate type NmlId
        value = find_attr_value_('postComponent', node)
        if value is not None and 'postComponent' not in already_processed:
            already_processed.add('postComponent')
            self.post_component = value
            self.validate_NmlId(self.post_component)    # validate type NmlId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ContinuousConnection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ContinuousConnection, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ContinuousConnection


class ElectricalConnection(BaseConnectionNewFormat):
    """Individual electrical synaptic connection"""
    member_data_items_ = [
        MemberSpec_('synapse', 'NmlId', 0),
    ]
    subclass = None
    superclass = BaseConnectionNewFormat
    def __init__(self, neuro_lex_id=None, id=None, pre_cell=None, pre_segment='0', pre_fraction_along='0.5', post_cell=None, post_segment='0', post_fraction_along='0.5', synapse=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ElectricalConnection, self).__init__(neuro_lex_id, id, pre_cell, pre_segment, pre_fraction_along, post_cell, post_segment, post_fraction_along, extensiontype_, )
        self.synapse = _cast(None, synapse)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ElectricalConnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ElectricalConnection.subclass:
            return ElectricalConnection.subclass(*args_, **kwargs_)
        else:
            return ElectricalConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_NmlId_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_NmlId_patterns_, ))
    validate_NmlId_patterns_ = [['^[a-zA-Z_][a-zA-Z0-9_]*$']]
    def hasContent_(self):
        if (
            super(ElectricalConnection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ElectricalConnection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ElectricalConnection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ElectricalConnection', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ElectricalConnection'):
        super(ElectricalConnection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ElectricalConnection')
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (quote_attrib(self.synapse), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ElectricalConnection', fromsubclass_=False, pretty_print=True):
        super(ElectricalConnection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
            self.validate_NmlId(self.synapse)    # validate type NmlId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ElectricalConnection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ElectricalConnection, self).buildChildren(child_, node, nodeName_, True)
        pass
        
    def _get_cell_id(self, id_string):
            return int(float(id_string))
            
    def get_pre_cell_id(self):
        
        return self._get_cell_id(self.pre_cell)
        
    def get_post_cell_id(self):
        
        return self._get_cell_id(self.post_cell)
        
    def __str__(self):
        
        return "Electrical Connection "+str(self.id)+": "+str(self.get_pre_cell_id())+" -> "+str(self.get_post_cell_id())+             ", synapse: "+str(self.synapse)
            
        
    # end class ElectricalConnection


class ConnectionWD(BaseConnectionOldFormat):
    """Individual synaptic connection with weight and delay"""
    member_data_items_ = [
        MemberSpec_('weight', 'xs:float', 0),
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = BaseConnectionOldFormat
    def __init__(self, neuro_lex_id=None, id=None, pre_cell_id=None, pre_segment_id='0', pre_fraction_along='0.5', post_cell_id=None, post_segment_id='0', post_fraction_along='0.5', weight=None, delay=None):
        self.original_tagname_ = None
        super(ConnectionWD, self).__init__(neuro_lex_id, id, pre_cell_id, pre_segment_id, pre_fraction_along, post_cell_id, post_segment_id, post_fraction_along, )
        self.weight = _cast(float, weight)
        self.delay = _cast(None, delay)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConnectionWD)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConnectionWD.subclass:
            return ConnectionWD.subclass(*args_, **kwargs_)
        else:
            return ConnectionWD(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(ConnectionWD, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConnectionWD', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConnectionWD')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ConnectionWD', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConnectionWD'):
        super(ConnectionWD, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ConnectionWD')
        if self.weight is not None and 'weight' not in already_processed:
            already_processed.add('weight')
            outfile.write(' weight="%s"' % self.gds_format_float(self.weight, input_name='weight'))
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConnectionWD', fromsubclass_=False, pretty_print=True):
        super(ConnectionWD, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('weight', node)
        if value is not None and 'weight' not in already_processed:
            already_processed.add('weight')
            try:
                self.weight = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (weight): %s' % exp)
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        super(ConnectionWD, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ConnectionWD, self).buildChildren(child_, node, nodeName_, True)
        pass

    def _get_cell_id(self, id_string):
        if '[' in id_string:
            return int(id_string.split('[')[1].split(']')[0])
        else:
            return int(id_string.split('/')[2])

    def get_pre_cell_id(self):
        
        return self._get_cell_id(self.pre_cell_id)
        

    def get_pre_segment_id(self):
        
        return int(self.pre_segment_id)
        
    def get_post_segment_id(self):
        
        return int(self.post_segment_id)

    def get_pre_fraction_along(self):
        
        return float(self.pre_fraction_along)
        
    def get_post_fraction_along(self):
        
        return float(self.post_fraction_along)
        
        
    def get_post_cell_id(self):
        
        return self._get_cell_id(self.post_cell_id)
        
    def get_pre_info(self):
        
        return str(self.get_pre_cell_id())+(':'+str(self.get_pre_segment_id())+'('+ '%.5f'%self.get_pre_fraction_along()+')' if self.get_pre_segment_id()!=0 or self.get_pre_fraction_along()!=0.5 else '')
        
    def get_post_info(self):
        
        return str(self.get_post_cell_id())+(':'+str(self.get_post_segment_id())+'('+ '%.5f'%self.get_post_fraction_along()+')' if self.get_post_segment_id()!=0 or self.get_post_fraction_along()!=0.5 else '')
        
    def __str__(self):
        
        return "Connection "+str(self.id)+": "+str(self.get_pre_info())+" -> "+str(self.get_post_info())
        
            
    def __str__(self):
        
        return "Connection "+str(self.id)+": "+str(self.get_pre_cell_id())+" -> "+str(self.get_post_cell_id())+             ", weight: "+'%f' % (float(self.weight))+", delay: "+'%.5f' % (self.get_delay_in_ms())+" ms"
            
    def get_delay_in_ms(self):
        if 'ms' in self.delay:
            return float(self.delay[:-2].strip())
        elif 's' in self.delay:
            return float(self.delay[:-1].strip())*1000.0
        
    # end class ConnectionWD


class Connection(BaseConnectionOldFormat):
    """Individual chemical (event based) synaptic connection, weight==1 and
    no delay"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = BaseConnectionOldFormat
    def __init__(self, neuro_lex_id=None, id=None, pre_cell_id=None, pre_segment_id='0', pre_fraction_along='0.5', post_cell_id=None, post_segment_id='0', post_fraction_along='0.5'):
        self.original_tagname_ = None
        super(Connection, self).__init__(neuro_lex_id, id, pre_cell_id, pre_segment_id, pre_fraction_along, post_cell_id, post_segment_id, post_fraction_along, )
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Connection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Connection.subclass:
            return Connection.subclass(*args_, **kwargs_)
        else:
            return Connection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(Connection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Connection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Connection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Connection', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Connection'):
        super(Connection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Connection')
    def exportChildren(self, outfile, level, namespace_='', name_='Connection', fromsubclass_=False, pretty_print=True):
        super(Connection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Connection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Connection, self).buildChildren(child_, node, nodeName_, True)
        pass

    def _get_cell_id(self, id_string):
        if '[' in id_string:
            return int(id_string.split('[')[1].split(']')[0])
        else:
            return int(id_string.split('/')[2])

    def get_pre_cell_id(self):
        
        return self._get_cell_id(self.pre_cell_id)
        

    def get_pre_segment_id(self):
        
        return int(self.pre_segment_id)
        
    def get_post_segment_id(self):
        
        return int(self.post_segment_id)

    def get_pre_fraction_along(self):
        
        return float(self.pre_fraction_along)
        
    def get_post_fraction_along(self):
        
        return float(self.post_fraction_along)
        
        
    def get_post_cell_id(self):
        
        return self._get_cell_id(self.post_cell_id)
        
    def get_pre_info(self):
        
        return str(self.get_pre_cell_id())+(':'+str(self.get_pre_segment_id())+'('+ '%.5f'%self.get_pre_fraction_along()+')' if self.get_pre_segment_id()!=0 or self.get_pre_fraction_along()!=0.5 else '')
        
    def get_post_info(self):
        
        return str(self.get_post_cell_id())+(':'+str(self.get_post_segment_id())+'('+ '%.5f'%self.get_post_fraction_along()+')' if self.get_post_segment_id()!=0 or self.get_post_fraction_along()!=0.5 else '')
        
    def __str__(self):
        
        return "Connection "+str(self.id)+": "+str(self.get_pre_info())+" -> "+str(self.get_post_info())
        
    # end class Connection


class Cell2CaPools(Cell):
    member_data_items_ = [
        MemberSpec_('biophysical_properties2_ca_pools', 'BiophysicalProperties2CaPools', 0),
    ]
    subclass = None
    superclass = Cell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, morphology_attr=None, biophysical_properties_attr=None, morphology=None, biophysical_properties=None, biophysical_properties2_ca_pools=None):
        self.original_tagname_ = None
        super(Cell2CaPools, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, morphology_attr, biophysical_properties_attr, morphology, biophysical_properties, )
        self.biophysical_properties2_ca_pools = biophysical_properties2_ca_pools
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Cell2CaPools)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Cell2CaPools.subclass:
            return Cell2CaPools.subclass(*args_, **kwargs_)
        else:
            return Cell2CaPools(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.biophysical_properties2_ca_pools is not None or
            super(Cell2CaPools, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Cell2CaPools', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Cell2CaPools')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Cell2CaPools', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Cell2CaPools'):
        super(Cell2CaPools, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Cell2CaPools')
    def exportChildren(self, outfile, level, namespace_='', name_='Cell2CaPools', fromsubclass_=False, pretty_print=True):
        super(Cell2CaPools, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.biophysical_properties2_ca_pools is not None:
            self.biophysical_properties2_ca_pools.export(outfile, level, namespace_, name_='biophysicalProperties2CaPools', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(Cell2CaPools, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'biophysicalProperties2CaPools':
            obj_ = BiophysicalProperties2CaPools.factory()
            obj_.build(child_)
            self.biophysical_properties2_ca_pools = obj_
            obj_.original_tagname_ = 'biophysicalProperties2CaPools'
        super(Cell2CaPools, self).buildChildren(child_, node, nodeName_, True)
# end class Cell2CaPools


class AdExIaFCell(BaseCellMembPotCap):
    member_data_items_ = [
        MemberSpec_('gL', 'Nml2Quantity_conductance', 0),
        MemberSpec_('EL', 'Nml2Quantity_voltage', 0),
        MemberSpec_('reset', 'Nml2Quantity_voltage', 0),
        MemberSpec_('VT', 'Nml2Quantity_voltage', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
        MemberSpec_('delT', 'Nml2Quantity_voltage', 0),
        MemberSpec_('tauw', 'Nml2Quantity_time', 0),
        MemberSpec_('refract', 'Nml2Quantity_time', 0),
        MemberSpec_('a', 'Nml2Quantity_conductance', 0),
        MemberSpec_('b', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = BaseCellMembPotCap
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, C=None, g_l=None, EL=None, reset=None, VT=None, thresh=None, del_t=None, tauw=None, refract=None, a=None, b=None):
        self.original_tagname_ = None
        super(AdExIaFCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, C, )
        self.g_l = _cast(None, g_l)
        self.EL = _cast(None, EL)
        self.reset = _cast(None, reset)
        self.VT = _cast(None, VT)
        self.thresh = _cast(None, thresh)
        self.del_t = _cast(None, del_t)
        self.tauw = _cast(None, tauw)
        self.refract = _cast(None, refract)
        self.a = _cast(None, a)
        self.b = _cast(None, b)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AdExIaFCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AdExIaFCell.subclass:
            return AdExIaFCell.subclass(*args_, **kwargs_)
        else:
            return AdExIaFCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_current_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_current_patterns_, ))
    validate_Nml2Quantity_current_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A$|^uA$|^nA$|^pA)$']]
    def hasContent_(self):
        if (
            super(AdExIaFCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AdExIaFCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AdExIaFCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AdExIaFCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AdExIaFCell'):
        super(AdExIaFCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AdExIaFCell')
        if self.g_l is not None and 'g_l' not in already_processed:
            already_processed.add('g_l')
            outfile.write(' gL=%s' % (quote_attrib(self.g_l), ))
        if self.EL is not None and 'EL' not in already_processed:
            already_processed.add('EL')
            outfile.write(' EL=%s' % (quote_attrib(self.EL), ))
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            outfile.write(' reset=%s' % (quote_attrib(self.reset), ))
        if self.VT is not None and 'VT' not in already_processed:
            already_processed.add('VT')
            outfile.write(' VT=%s' % (quote_attrib(self.VT), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
        if self.del_t is not None and 'del_t' not in already_processed:
            already_processed.add('del_t')
            outfile.write(' delT=%s' % (quote_attrib(self.del_t), ))
        if self.tauw is not None and 'tauw' not in already_processed:
            already_processed.add('tauw')
            outfile.write(' tauw=%s' % (quote_attrib(self.tauw), ))
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            outfile.write(' refract=%s' % (quote_attrib(self.refract), ))
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a=%s' % (quote_attrib(self.a), ))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b=%s' % (quote_attrib(self.b), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AdExIaFCell', fromsubclass_=False, pretty_print=True):
        super(AdExIaFCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gL', node)
        if value is not None and 'gL' not in already_processed:
            already_processed.add('gL')
            self.g_l = value
            self.validate_Nml2Quantity_conductance(self.g_l)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('EL', node)
        if value is not None and 'EL' not in already_processed:
            already_processed.add('EL')
            self.EL = value
            self.validate_Nml2Quantity_voltage(self.EL)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('reset', node)
        if value is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            self.reset = value
            self.validate_Nml2Quantity_voltage(self.reset)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('VT', node)
        if value is not None and 'VT' not in already_processed:
            already_processed.add('VT')
            self.VT = value
            self.validate_Nml2Quantity_voltage(self.VT)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('delT', node)
        if value is not None and 'delT' not in already_processed:
            already_processed.add('delT')
            self.del_t = value
            self.validate_Nml2Quantity_voltage(self.del_t)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('tauw', node)
        if value is not None and 'tauw' not in already_processed:
            already_processed.add('tauw')
            self.tauw = value
            self.validate_Nml2Quantity_time(self.tauw)    # validate type Nml2Quantity_time
        value = find_attr_value_('refract', node)
        if value is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            self.refract = value
            self.validate_Nml2Quantity_time(self.refract)    # validate type Nml2Quantity_time
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            self.a = value
            self.validate_Nml2Quantity_conductance(self.a)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            self.b = value
            self.validate_Nml2Quantity_current(self.b)    # validate type Nml2Quantity_current
        super(AdExIaFCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AdExIaFCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AdExIaFCell


class Izhikevich2007Cell(BaseCellMembPotCap):
    member_data_items_ = [
        MemberSpec_('v0', 'Nml2Quantity_voltage', 0),
        MemberSpec_('k', 'Nml2Quantity_conductancePerVoltage', 0),
        MemberSpec_('vr', 'Nml2Quantity_voltage', 0),
        MemberSpec_('vt', 'Nml2Quantity_voltage', 0),
        MemberSpec_('vpeak', 'Nml2Quantity_voltage', 0),
        MemberSpec_('a', 'Nml2Quantity_pertime', 0),
        MemberSpec_('b', 'Nml2Quantity_conductance', 0),
        MemberSpec_('c', 'Nml2Quantity_voltage', 0),
        MemberSpec_('d', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = BaseCellMembPotCap
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, C=None, v0=None, k=None, vr=None, vt=None, vpeak=None, a=None, b=None, c=None, d=None):
        self.original_tagname_ = None
        super(Izhikevich2007Cell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, C, )
        self.v0 = _cast(None, v0)
        self.k = _cast(None, k)
        self.vr = _cast(None, vr)
        self.vt = _cast(None, vt)
        self.vpeak = _cast(None, vpeak)
        self.a = _cast(None, a)
        self.b = _cast(None, b)
        self.c = _cast(None, c)
        self.d = _cast(None, d)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Izhikevich2007Cell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Izhikevich2007Cell.subclass:
            return Izhikevich2007Cell.subclass(*args_, **kwargs_)
        else:
            return Izhikevich2007Cell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def validate_Nml2Quantity_conductancePerVoltage(self, value):
        # Validate type Nml2Quantity_conductancePerVoltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductancePerVoltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductancePerVoltage_patterns_, ))
    validate_Nml2Quantity_conductancePerVoltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_V$|^nS_per_mV)$']]
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_pertime_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_pertime_patterns_, ))
    validate_Nml2Quantity_pertime_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s$|^per_ms$|^Hz)$']]
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_current_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_current_patterns_, ))
    validate_Nml2Quantity_current_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A$|^uA$|^nA$|^pA)$']]
    def hasContent_(self):
        if (
            super(Izhikevich2007Cell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Izhikevich2007Cell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Izhikevich2007Cell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Izhikevich2007Cell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Izhikevich2007Cell'):
        super(Izhikevich2007Cell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Izhikevich2007Cell')
        if self.v0 is not None and 'v0' not in already_processed:
            already_processed.add('v0')
            outfile.write(' v0=%s' % (quote_attrib(self.v0), ))
        if self.k is not None and 'k' not in already_processed:
            already_processed.add('k')
            outfile.write(' k=%s' % (quote_attrib(self.k), ))
        if self.vr is not None and 'vr' not in already_processed:
            already_processed.add('vr')
            outfile.write(' vr=%s' % (quote_attrib(self.vr), ))
        if self.vt is not None and 'vt' not in already_processed:
            already_processed.add('vt')
            outfile.write(' vt=%s' % (quote_attrib(self.vt), ))
        if self.vpeak is not None and 'vpeak' not in already_processed:
            already_processed.add('vpeak')
            outfile.write(' vpeak=%s' % (quote_attrib(self.vpeak), ))
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a=%s' % (quote_attrib(self.a), ))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b=%s' % (quote_attrib(self.b), ))
        if self.c is not None and 'c' not in already_processed:
            already_processed.add('c')
            outfile.write(' c=%s' % (quote_attrib(self.c), ))
        if self.d is not None and 'd' not in already_processed:
            already_processed.add('d')
            outfile.write(' d=%s' % (quote_attrib(self.d), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Izhikevich2007Cell', fromsubclass_=False, pretty_print=True):
        super(Izhikevich2007Cell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('v0', node)
        if value is not None and 'v0' not in already_processed:
            already_processed.add('v0')
            self.v0 = value
            self.validate_Nml2Quantity_voltage(self.v0)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('k', node)
        if value is not None and 'k' not in already_processed:
            already_processed.add('k')
            self.k = value
            self.validate_Nml2Quantity_conductancePerVoltage(self.k)    # validate type Nml2Quantity_conductancePerVoltage
        value = find_attr_value_('vr', node)
        if value is not None and 'vr' not in already_processed:
            already_processed.add('vr')
            self.vr = value
            self.validate_Nml2Quantity_voltage(self.vr)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('vt', node)
        if value is not None and 'vt' not in already_processed:
            already_processed.add('vt')
            self.vt = value
            self.validate_Nml2Quantity_voltage(self.vt)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('vpeak', node)
        if value is not None and 'vpeak' not in already_processed:
            already_processed.add('vpeak')
            self.vpeak = value
            self.validate_Nml2Quantity_voltage(self.vpeak)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            self.a = value
            self.validate_Nml2Quantity_pertime(self.a)    # validate type Nml2Quantity_pertime
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            self.b = value
            self.validate_Nml2Quantity_conductance(self.b)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('c', node)
        if value is not None and 'c' not in already_processed:
            already_processed.add('c')
            self.c = value
            self.validate_Nml2Quantity_voltage(self.c)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('d', node)
        if value is not None and 'd' not in already_processed:
            already_processed.add('d')
            self.d = value
            self.validate_Nml2Quantity_current(self.d)    # validate type Nml2Quantity_current
        super(Izhikevich2007Cell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Izhikevich2007Cell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Izhikevich2007Cell


class IafRefCell(IafCell):
    member_data_items_ = [
        MemberSpec_('refract', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = IafCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, leak_reversal=None, thresh=None, reset=None, C=None, leak_conductance=None, refract=None):
        self.original_tagname_ = None
        super(IafRefCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, leak_reversal, thresh, reset, C, leak_conductance, )
        self.refract = _cast(None, refract)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IafRefCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IafRefCell.subclass:
            return IafRefCell.subclass(*args_, **kwargs_)
        else:
            return IafRefCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(IafRefCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IafRefCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IafRefCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IafRefCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IafRefCell'):
        super(IafRefCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IafRefCell')
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            outfile.write(' refract=%s' % (quote_attrib(self.refract), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IafRefCell', fromsubclass_=False, pretty_print=True):
        super(IafRefCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refract', node)
        if value is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            self.refract = value
            self.validate_Nml2Quantity_time(self.refract)    # validate type Nml2Quantity_time
        super(IafRefCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IafRefCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IafRefCell


class IafTauRefCell(IafTauCell):
    member_data_items_ = [
        MemberSpec_('refract', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = IafTauCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, leak_reversal=None, thresh=None, reset=None, tau=None, refract=None):
        self.original_tagname_ = None
        super(IafTauRefCell, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, leak_reversal, thresh, reset, tau, )
        self.refract = _cast(None, refract)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IafTauRefCell)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IafTauRefCell.subclass:
            return IafTauRefCell.subclass(*args_, **kwargs_)
        else:
            return IafTauRefCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def hasContent_(self):
        if (
            super(IafTauRefCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IafTauRefCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IafTauRefCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IafTauRefCell', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IafTauRefCell'):
        super(IafTauRefCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IafTauRefCell')
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            outfile.write(' refract=%s' % (quote_attrib(self.refract), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IafTauRefCell', fromsubclass_=False, pretty_print=True):
        super(IafTauRefCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refract', node)
        if value is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            self.refract = value
            self.validate_Nml2Quantity_time(self.refract)    # validate type Nml2Quantity_time
        super(IafTauRefCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IafTauRefCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IafTauRefCell


class AlphaCurrentSynapse(BaseCurrentBasedSynapse):
    member_data_items_ = [
        MemberSpec_('tau', 'Nml2Quantity_time', 0),
        MemberSpec_('ibase', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = BaseCurrentBasedSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, tau=None, ibase=None):
        self.original_tagname_ = None
        super(AlphaCurrentSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, )
        self.tau = _cast(None, tau)
        self.ibase = _cast(None, ibase)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AlphaCurrentSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AlphaCurrentSynapse.subclass:
            return AlphaCurrentSynapse.subclass(*args_, **kwargs_)
        else:
            return AlphaCurrentSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_time_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_time_patterns_, ))
    validate_Nml2Quantity_time_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s$|^ms)$']]
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_current_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_current_patterns_, ))
    validate_Nml2Quantity_current_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A$|^uA$|^nA$|^pA)$']]
    def hasContent_(self):
        if (
            super(AlphaCurrentSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AlphaCurrentSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCurrentSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AlphaCurrentSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AlphaCurrentSynapse'):
        super(AlphaCurrentSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCurrentSynapse')
        if self.tau is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            outfile.write(' tau=%s' % (quote_attrib(self.tau), ))
        if self.ibase is not None and 'ibase' not in already_processed:
            already_processed.add('ibase')
            outfile.write(' ibase=%s' % (quote_attrib(self.ibase), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AlphaCurrentSynapse', fromsubclass_=False, pretty_print=True):
        super(AlphaCurrentSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tau', node)
        if value is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            self.tau = value
            self.validate_Nml2Quantity_time(self.tau)    # validate type Nml2Quantity_time
        value = find_attr_value_('ibase', node)
        if value is not None and 'ibase' not in already_processed:
            already_processed.add('ibase')
            self.ibase = value
            self.validate_Nml2Quantity_current(self.ibase)    # validate type Nml2Quantity_current
        super(AlphaCurrentSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AlphaCurrentSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AlphaCurrentSynapse


class BaseConductanceBasedSynapseTwo(BaseVoltageDepSynapse):
    member_data_items_ = [
        MemberSpec_('gbase1', 'Nml2Quantity_conductance', 0),
        MemberSpec_('gbase2', 'Nml2Quantity_conductance', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = BaseVoltageDepSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, gbase1=None, gbase2=None, erev=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseConductanceBasedSynapseTwo, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.gbase1 = _cast(None, gbase1)
        self.gbase2 = _cast(None, gbase2)
        self.erev = _cast(None, erev)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseConductanceBasedSynapseTwo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConductanceBasedSynapseTwo.subclass:
            return BaseConductanceBasedSynapseTwo.subclass(*args_, **kwargs_)
        else:
            return BaseConductanceBasedSynapseTwo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (
            super(BaseConductanceBasedSynapseTwo, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseConductanceBasedSynapseTwo', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConductanceBasedSynapseTwo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseConductanceBasedSynapseTwo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseConductanceBasedSynapseTwo'):
        super(BaseConductanceBasedSynapseTwo, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConductanceBasedSynapseTwo')
        if self.gbase1 is not None and 'gbase1' not in already_processed:
            already_processed.add('gbase1')
            outfile.write(' gbase1=%s' % (quote_attrib(self.gbase1), ))
        if self.gbase2 is not None and 'gbase2' not in already_processed:
            already_processed.add('gbase2')
            outfile.write(' gbase2=%s' % (quote_attrib(self.gbase2), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseConductanceBasedSynapseTwo', fromsubclass_=False, pretty_print=True):
        super(BaseConductanceBasedSynapseTwo, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gbase1', node)
        if value is not None and 'gbase1' not in already_processed:
            already_processed.add('gbase1')
            self.gbase1 = value
            self.validate_Nml2Quantity_conductance(self.gbase1)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('gbase2', node)
        if value is not None and 'gbase2' not in already_processed:
            already_processed.add('gbase2')
            self.gbase2 = value
            self.validate_Nml2Quantity_conductance(self.gbase2)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseConductanceBasedSynapseTwo, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseConductanceBasedSynapseTwo, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseConductanceBasedSynapseTwo


class BaseConductanceBasedSynapse(BaseVoltageDepSynapse):
    member_data_items_ = [
        MemberSpec_('gbase', 'Nml2Quantity_conductance', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = BaseVoltageDepSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, properties=None, annotation=None, gbase=None, erev=None, extensiontype_=None):
        self.original_tagname_ = None
        super(BaseConductanceBasedSynapse, self).__init__(neuro_lex_id, id, metaid, notes, properties, annotation, extensiontype_, )
        self.gbase = _cast(None, gbase)
        self.erev = _cast(None, erev)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseConductanceBasedSynapse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConductanceBasedSynapse.subclass:
            return BaseConductanceBasedSynapse.subclass(*args_, **kwargs_)
        else:
            return BaseConductanceBasedSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_conductance_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_conductance_patterns_, ))
    validate_Nml2Quantity_conductance_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S$|^mS$|^uS$|^nS$|^pS)$']]
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_Nml2Quantity_voltage_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_Nml2Quantity_voltage_patterns_, ))
    validate_Nml2Quantity_voltage_patterns_ = [['^-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V$|^mV)$']]
    def hasContent_(self):
        if (
            super(BaseConductanceBasedSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseConductanceBasedSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConductanceBasedSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='BaseConductanceBasedSynapse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseConductanceBasedSynapse'):
        super(BaseConductanceBasedSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConductanceBasedSynapse')
        if self.gbase is not None and 'gbase' not in already_processed:
            already_processed.add('gbase')
            outfile.write(' gbase=%s' % (quote_attrib(self.gbase), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseConductanceBasedSynapse', fromsubclass_=False, pretty_print=True):
        super(BaseConductanceBasedSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gbase', node)
        if value is not None and 'gbase' not in already_processed:
            already_processed.add('gbase')
            self.gbase = value
            self.validate_Nml2Quantity_conductance(self.gbase)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseConductanceBasedSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseConductanceBasedSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseConductanceBasedSynapse


class IonChannelHH(IonChannel):
    """Note ionChannel and ionChannelHH are currently functionally
    identical. This is needed since many existing e