"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Yaml = void 0;
const fs = require("fs");
const YAML = require("yaml");
/**
 * YAML utilities.
 */
class Yaml {
    /**
     * Saves a set of objects as a multi-document YAML file.
     *
     * @param filePath The output path
     * @param docs The set of objects
     */
    static save(filePath, docs) {
        const data = `# Generated by cdk-threagile - ${Date.now()}\n\n${this.stringify(...docs)}`;
        fs.writeFileSync(filePath, data, { encoding: 'utf8' });
    }
    /**
     * Stringify a document (or multiple documents) into YAML
     *
     * Undefined values become null.
     * Undefiend documents will be ignored.
     *
     * @param docs A set of objects to convert to YAML
     * @returns a YAML string. Multiple docs are separated by `---`.
     */
    static stringify(...docs) {
        return docs.map(r => r === undefined ? '\n' : YAML.stringify(r, { keepUndefined: true, lineWidth: 0 })).join('---\n');
    }
}
exports.Yaml = Yaml;
//# sourceMappingURL=data:application/json;base64,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