"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCriticality = exports.Model = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const constructs_1 = require("constructs");
const data_asset_1 = require("./data-asset");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
const yaml_1 = require("./yaml");
class Model extends constructs_1.Construct {
    constructor(props) {
        super(undefined, '');
        this.version = props.version;
        this.title = props.title;
        this.date = props.date;
        this.author = props.author;
        this.businessCriticality = props.businessCriticality;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const dataAssets = new Array();
        const technicalAssets = new Array();
        const trustBoundaries = new Array();
        this.node.findAll().map(n => {
            if (n instanceof data_asset_1.DataAsset) {
                dataAssets.push(n);
            }
            else if (n instanceof technical_asset_1.TechnicalAsset) {
                technicalAssets.push(n);
            }
            else if (n instanceof trust_boundary_1.TrustBoundary) {
                trustBoundaries.push(n);
            }
        });
        const threagile = {
            threagile_version: this.version,
            title: this.title,
            data: this.date?.toISOString().split('T')[0],
            author: this.author._toThreagile(),
            business_criticality: this.businessCriticality,
        };
        if (dataAssets.length > 0) {
            threagile.data_assets = {};
            dataAssets.forEach(a => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.data_assets[k] = obj[k];
            });
        }
        if (technicalAssets.length > 0) {
            threagile.technical_assets = {};
            technicalAssets.forEach(a => {
                const obj = a._toThreagile();
                const k = Object.keys(obj)[0];
                threagile.technical_assets[k] = obj[k];
            });
        }
        if (trustBoundaries.length > 0) {
            threagile.trust_boundaries = {};
            trustBoundaries.forEach(t => {
                const obj = t._toThreagile();
                if (obj) {
                    const k = Object.keys(obj)[0];
                    threagile.trust_boundaries[k] = obj[k];
                }
            });
        }
        return threagile;
    }
    /**
     * Synthesizes the model to the output directory
     */
    synth(outdir = 'dist') {
        fs.mkdirSync(outdir, { recursive: true });
        yaml_1.Yaml.save(path.join(outdir, 'app.yaml'), // There is no "app name", so we just hardcode the file name
        [this._toThreagile()]);
    }
}
exports.Model = Model;
_a = JSII_RTTI_SYMBOL_1;
Model[_a] = { fqn: "cdktg.Model", version: "0.0.3" };
var BusinessCriticality;
(function (BusinessCriticality) {
    BusinessCriticality["ARCHIVE"] = "archive";
    BusinessCriticality["OPERATIONAL"] = "operational";
    BusinessCriticality["IMPORTANT"] = "important";
    BusinessCriticality["CRITICAL"] = "critical";
    BusinessCriticality["MISSION_CRITICAL"] = "mission-critical";
})(BusinessCriticality = exports.BusinessCriticality || (exports.BusinessCriticality = {}));
//# sourceMappingURL=data:application/json;base64,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