"""initial

Revision ID: 339054a81cc6
Revises: 
Create Date: 2023-01-15 23:18:01.934129+00:00

"""
import fastapi_users_db_sqlalchemy
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '339054a81cc6'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    schema_upgrades()
    data_upgrades()


def downgrade():
    data_downgrades()
    schema_downgrades()


def schema_upgrades():
    """schema upgrade migrations go here."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('image_samples',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('created_at', sa.DateTime(), server_default=sa.text("TIMEZONE('utc', CURRENT_TIMESTAMP)"),
                              nullable=True),
                    sa.Column('updated_at', sa.DateTime(), nullable=True),
                    sa.Column('filename', sa.String(), nullable=False),
                    sa.Column('checksum', sa.String(), nullable=False),
                    sa.Column('location', sa.String(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('checksum'),
                    sa.UniqueConstraint('location')
                    )
    op.create_table('user_groups',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('created_at', sa.DateTime(), server_default=sa.text("TIMEZONE('utc', CURRENT_TIMESTAMP)"),
                              nullable=True),
                    sa.Column('updated_at', sa.DateTime(), nullable=True),
                    sa.Column('name', sa.String(), nullable=False),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('users',
                    sa.Column('email', sa.String(length=320), nullable=False),
                    sa.Column('hashed_password', sa.String(length=1024), nullable=False),
                    sa.Column('is_active', sa.Boolean(), nullable=False),
                    sa.Column('is_superuser', sa.Boolean(), nullable=False),
                    sa.Column('is_verified', sa.Boolean(), nullable=False),
                    sa.Column('id', fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False),
                    sa.Column('group_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(('group_id',), ['user_groups.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_index(op.f('ix_users_email'), 'users', ['email'], unique=True)
    op.create_table('image_sample_annotations',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('created_at', sa.DateTime(), server_default=sa.text("TIMEZONE('utc', CURRENT_TIMESTAMP)"),
                              nullable=True),
                    sa.Column('updated_at', sa.DateTime(), nullable=True),
                    sa.Column('user_id', fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False),
                    sa.Column('image_sample_id', sa.Integer(), nullable=False),
                    sa.Column('type', sa.SmallInteger(), nullable=True),
                    sa.Column('make', sa.String(length=32), nullable=True),
                    sa.Column('model', sa.String(length=32), nullable=True),
                    sa.Column('body', sa.String(length=32), nullable=True),
                    sa.Column('color', sa.String(length=32), nullable=True),
                    sa.Column('votes', sa.Integer(), nullable=False),
                    sa.ForeignKeyConstraint(('image_sample_id',), ['image_samples.id'], ),
                    sa.ForeignKeyConstraint(('user_id',), ['users.id'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('user_id', 'image_sample_id', name='uq_image_sample_annotation_item')
                    )
    op.create_table('annotation_votes',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('created_at', sa.DateTime(), server_default=sa.text("TIMEZONE('utc', CURRENT_TIMESTAMP)"),
                              nullable=True),
                    sa.Column('updated_at', sa.DateTime(), nullable=True),
                    sa.Column('user_id', fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False),
                    sa.Column('annotation_id', sa.Integer(), nullable=False),
                    sa.Column('value', sa.SmallInteger(), nullable=False),
                    sa.ForeignKeyConstraint(('annotation_id',), ['image_sample_annotations.id'], ),
                    sa.ForeignKeyConstraint(('user_id',), ['users.id'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('user_id', 'annotation_id', name='uq_annotation_vote')
                    )
    # ### end Alembic commands ###


def schema_downgrades():
    """schema downgrade migrations go here."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('annotation_votes')
    op.drop_table('image_sample_annotations')
    op.drop_index(op.f('ix_users_email'), table_name='users')
    op.drop_table('users')
    op.drop_table('user_groups')
    op.drop_table('image_samples')
    # ### end Alembic commands ###


def data_upgrades():
    """Add any optional data upgrade migrations here!"""
    pass


def data_downgrades():
    """Add any optional data downgrade migrations here!"""
    pass
