## mkgendocs
A Python package for automatically generating documentation pages in markdown for 
Python source files by parsing **Google style docstring**. The markdown output makes it
ideal to combine with [mkdocs](https://www.mkdocs.org/). 

Contrary to other packages, this does not use the `inspect` package to access signatures 
and docstrings. Instead, it uses python Abstract Syntax Trees (AST) to get this from the
source files without executing the code -through the `ast` 
 package. It also makes use of `astor (AST observe/rewrite) to convert function or 
 class signatures back to source code strings.
 
## Installation
Install mkgendocs from [PyPI](https://pypi.org/project/mkgendocs/)

```python
pip install mkgendocs
```

## Usage

```
gendocs --config mkgendocs.yml
```

A sources directory is created with the documentation that was automatically generated.
Any examples in a "examples" directory are automatically copied over to the documentation, 
the module level docstrings are copied 


### Configuration Example

````yaml
sources_dir: docs/sources
templates_dir: docs/templates
docstring_template: docstring_template.md

pages:
  - page: "train/model.md"
    source: "tensorx/train/model.py"
    methods:
      - Model:
          - train
          - set_optimizer
  - page: "layers/core.md"
    source: 'tensorx/layers.py'
    classes:
      - Linear
      - Module
  - page: "math.md"
    source: 'tensorx/math.py'
    functions:
      - sparse_multiply_dense
````

* **sources_dir**: directory where the resulting markdown files are created
* **templates_dir**: directory where template files can be stored. All the folders and files are 
copied to the sources directory. Any markdown files are used as templates with the 
tag `{{autogenerated}}` in the template files being replaced by the generated documentation.
* **pages**: list of pages to be automatically generated from the respective source files and templates:
    * **page**: path for page template / sources dir for the resulting page;
    * **source**: path to source file from which the page is to be genrated;
    * **methods**: list of class to method name dictionaries;
    * **classes**: list of classes to be fully documented;
    * **functions**: list of functions to be documented.

