/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J5\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lsolver/Z3SolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_Z3_COMMAND", "", "alwaysOnOptions", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "customSolverExecutable", "timeout", "Ljava/time/Duration;", "incrementalMode", "", "getDefaultConfigs", "Lsolver/SolverConfig;", "memlimitBytes", "", "logicFeatures", "Lsolver/SolverConfig$LogicFeatures;", "(Ljava/time/Duration;Ljava/lang/Long;ZLsolver/SolverConfig$LogicFeatures;)Ljava/util/List;", "getEqSolverTweakingConfigs", "(Ljava/time/Duration;Ljava/lang/Long;Z)Ljava/util/List;", "getLiaSolverTweakingConfigs", "getProcessTimeoutString", "getQueryTimeoutString", "supportsLogicFeatures", "features", "GeneralUtils"})
public final class Z3SolverInfo
extends SolverInfo {
    @NotNull
    public static final Z3SolverInfo INSTANCE = new Z3SolverInfo();
    @NotNull
    private static final List<String> alwaysOnOptions = CollectionsKt.listOf("-st");
    @NotNull
    private static final String DEFAULT_Z3_COMMAND = "z3";

    private Z3SolverInfo() {
        super("Z3");
    }

    @Override
    @NotNull
    public List<String> getProcessTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("-T:", timeout.toSeconds()));
    }

    @Override
    @NotNull
    public List<String> getQueryTimeoutString(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        return CollectionsKt.listOf(Intrinsics.stringPlus("-t:", timeout.toMillis()));
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@Nullable String customSolverExecutable, @Nullable Duration timeout, boolean incrementalMode) {
        List<String> list2;
        String string2 = customSolverExecutable;
        String[] stringArray = new String[]{string2 == null ? DEFAULT_Z3_COMMAND : string2, "-in"};
        Collection collection = CollectionsKt.listOf(stringArray);
        if (timeout != null) {
            list2 = this.getQueryTimeoutString(timeout);
        } else {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)list2), (Iterable)alwaysOnOptions);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_Z3_COMMAND;
    }

    @Override
    @NotNull
    public List<SolverConfig> getDefaultConfigs(@NotNull Duration timeout, @Nullable Long memlimitBytes, boolean incrementalMode, @NotNull SolverConfig.LogicFeatures logicFeatures) {
        Intrinsics.checkNotNullParameter(timeout, "timeout");
        Intrinsics.checkNotNullParameter(logicFeatures, "logicFeatures");
        SolverConfig.ArithmeticOperations arithmeticOperations = logicFeatures.getArithmeticOperations();
        boolean bl = false;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.emptyList(), null, null, null, 224, null)), (Iterable)(arithmeticOperations == SolverConfig.ArithmeticOperations.LinearOnly ? this.getLiaSolverTweakingConfigs(timeout, memlimitBytes, incrementalMode) : CollectionsKt.emptyList())), (Iterable)this.getEqSolverTweakingConfigs(timeout, memlimitBytes, incrementalMode));
    }

    private final List<SolverConfig> getLiaSolverTweakingConfigs(Duration timeout, Long memlimitBytes, boolean incrementalMode) {
        SolverConfig[] solverConfigArray = new SolverConfig[2];
        String[] stringArray = new String[]{"smt.arith.solver=2", "smt.auto_config=false"};
        solverConfigArray[0] = new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf(stringArray), null, null, null, 224, null);
        stringArray = new String[]{"tactic.solve_eqs.max_occs=4", "smt.arith.solver=2", "smt.auto_config=false"};
        solverConfigArray[1] = new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf(stringArray), null, null, null, 224, null);
        return CollectionsKt.listOf(solverConfigArray);
    }

    private final List<SolverConfig> getEqSolverTweakingConfigs(Duration timeout, Long memlimitBytes, boolean incrementalMode) {
        SolverConfig[] solverConfigArray = new SolverConfig[2];
        solverConfigArray[0] = new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf("tactic.solve_eqs.max_occs=4"), null, null, null, 224, null);
        String[] stringArray = new String[]{"tactic.solve_eqs.max_occs=4", "tactic.solve_eqs.context_solve=true"};
        solverConfigArray[1] = new SolverConfig(INSTANCE, timeout, memlimitBytes, incrementalMode, CollectionsKt.listOf(stringArray), null, null, null, 224, null);
        return CollectionsKt.listOf(solverConfigArray);
    }
}

