/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.EndOfLineParallel;
import parallel.FinishingRaceJob;
import parallel.Parallel;
import parallel.ParallelKt;
import parallel.PreserveDepsOrder;
import parallel.RaceFinish;
import parallel.RacerResult;
import parallel.Sem;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012 \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u00050\u00030\u00022\u00020\u0007B-\u0012&\u0010\b\u001a\"\u0012\u001e\u0012\u001c\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00030\u0005\u00a2\u0006\u0002\u0010\fJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u001e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u00042\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u001b\u00100\u001a\u00020*2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00028\u0000\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u00020*2\n\u00103\u001a\u00060\u0014j\u0002`\u0015J\u001b\u00104\u001a\u00020*2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00028\u0000\u00a2\u0006\u0002\u00101J\u000e\u00105\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0004J\u000e\u00106\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0004J\u000e\u00107\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0004J\u0010\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020:H\u0016R\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00050\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006;"}, d2={"Lparallel/FilteringFanOut;", "T", "Lparallel/EndOfLineParallel;", "Lkotlin/Pair;", "", "", "Lparallel/RacerResult;", "Lparallel/PreserveDepsOrder;", "thunks", "Lkotlin/Function0;", "Lparallel/RaceFinish;", "Ljava/time/Duration;", "(Ljava/util/List;)V", "deps", "Lparallel/Parallel;", "getDeps", "()Ljava/util/List;", "deps_", "Lparallel/FinishingRaceJob;", "exceptionThrown", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getExceptionThrown", "()Ljava/lang/Exception;", "setExceptionThrown", "(Ljava/lang/Exception;)V", "lock", "Lparallel/Sem;", "getLock", "()Lparallel/Sem;", "numJobs", "result", "getResult", "()Lkotlin/Pair;", "results", "", "status", "getStatus", "()I", "setStatus", "(I)V", "dbgPrnt", "", "msg", "", "register", "id", "res", "registerDqf", "(ILjava/lang/Object;)V", "registerException", "e", "registerFull", "registerLostRace", "registerSkipped", "registerTimeout", "sched", "ioPool", "Ljava/util/concurrent/ExecutorService;", "GeneralUtils"})
public final class FilteringFanOut<T>
extends EndOfLineParallel<Pair<? extends Integer, ? extends List<? extends RacerResult<? extends T>>>>
implements PreserveDepsOrder {
    @NotNull
    private final Sem lock;
    private int status;
    @Nullable
    private Exception exceptionThrown;
    private final int numJobs;
    @NotNull
    private final List<FinishingRaceJob<T>> deps_;
    @NotNull
    private final List<RacerResult<T>> results;

    /*
     * WARNING - void declaration
     */
    public FilteringFanOut(@NotNull List<? extends Pair<? extends Function0<? extends RaceFinish<? extends T>>, Duration>> thunks) {
        FinishingRaceJob finishingRaceJob;
        ArrayList arrayList;
        int n;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(thunks, "thunks");
        this.lock = new Sem(ParallelKt.access$getSemaphoreId$p().incrementAndGet());
        this.numJobs = thunks.size();
        Iterable iterable = thunks;
        FilteringFanOut filteringFanOut = this;
        boolean $i$f$mapIndexed = false;
        ArrayList arrayList2 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void $dstr$thunk$timeout;
            n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int n2 = n;
            arrayList = destination$iv$iv;
            boolean bl2 = false;
            Function0 thunk = (Function0)$dstr$thunk$timeout.component1();
            Duration timeout = (Duration)$dstr$thunk$timeout.component2();
            finishingRaceJob = new FinishingRaceJob(thunk, (int)(index + true), this, timeout);
            arrayList.add(finishingRaceJob);
        }
        arrayList = (List)destination$iv$iv;
        filteringFanOut.deps_ = arrayList;
        int n3 = this.numJobs;
        filteringFanOut = this;
        boolean bl = false;
        arrayList2 = new ArrayList(n3);
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            int n6 = n4++;
            boolean bl4 = false;
            n = n6;
            arrayList = arrayList2;
            boolean bl5 = false;
            finishingRaceJob = null;
            arrayList.add(finishingRaceJob);
        }
        arrayList = arrayList2;
        filteringFanOut.results = arrayList;
    }

    @NotNull
    public final Sem getLock() {
        return this.lock;
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setStatus(int n) {
        this.status = n;
    }

    @Nullable
    public final Exception getExceptionThrown() {
        return this.exceptionThrown;
    }

    public final void setExceptionThrown(@Nullable Exception exception) {
        this.exceptionThrown = exception;
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        return this.deps_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Integer, List<RacerResult<T>>> getResult() {
        Pair<Integer, List<RacerResult<T>>> pair;
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            Collection<void> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            boolean bl3 = false;
            Exception exception = this.getExceptionThrown();
            if (exception != null) {
                Exception exception2 = exception;
                boolean bl4 = false;
                boolean bl5 = false;
                Exception it = exception2;
                boolean bl6 = false;
                throw it;
            }
            boolean bl7 = this.getStatus() != 0;
            boolean bl8 = false;
            boolean bl9 = false;
            if (!bl7) {
                boolean bl10 = false;
                String string2 = "status indicates 'still running', but we're already querying the result";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            Iterable iterable = this.results;
            Integer n = this.getStatus() - 1;
            boolean $i$f$mapIndexed = false;
            void var7_15 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void res2;
                int n2 = index$iv$iv++;
                boolean bl11 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RacerResult racerResult = (RacerResult)item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl12 = false;
                void var20_32 = res2;
                if (var20_32 == null) {
                    void i;
                    String string3 = "Result of job " + (int)i + " is null at the end of the race";
                    boolean bl13 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                void var23_33 = var20_32;
                collection.add(var23_33);
            }
            collection = (List)destination$iv$iv;
            pair = TuplesKt.to(n, collection);
        }
        return pair;
    }

    private final void register(int id, RacerResult<? extends T> res2) {
        if (Intrinsics.areEqual(this.results.get(id - 1), RacerResult.Timeout.INSTANCE) || Intrinsics.areEqual(this.results.get(id - 1), RacerResult.LostRace.INSTANCE)) {
            return;
        }
        boolean bl = this.results.get(id - 1) == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Registering a job's result cannot happen twice";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.results.set(id - 1, res2);
    }

    public final void registerException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (this.exceptionThrown == null) {
            this.exceptionThrown = e;
        }
        this.status = -1;
        this.lock.notifyAll();
    }

    public final void registerLostRace(int id) {
        boolean bl = this.status > 0 || this.exceptionThrown != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Can only lose race if we have a known winner (or a job propagated an exception)";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.register(id, RacerResult.LostRace.INSTANCE);
    }

    public final void registerSkipped(int id) {
        boolean bl = this.status > 0 || this.exceptionThrown != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Can only be skipped if we have a known winner (or a job propagated an exception)";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.register(id, RacerResult.Skipped.INSTANCE);
    }

    public final void registerTimeout(int id) {
        boolean bl = this.status == 0 && this.exceptionThrown == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Can only timeout if no one else won (and no job propagated an exception)";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.register(id, RacerResult.Timeout.INSTANCE);
    }

    public final void registerDqf(int id, T res2) {
        this.register(id, (RacerResult)new RacerResult.FromJob<T>(res2));
        this.lock.notifyAll();
    }

    public final void registerFull(int id, T res2) {
        boolean bl = this.status != -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "can't have a winner when status is -1";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.register(id, (RacerResult)new RacerResult.FromJob<T>(res2));
        if (this.status == 0) {
            this.status = id;
        }
        this.lock.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sched(@NotNull ExecutorService ioPool) {
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            boolean bl3 = false;
            if (this.getStatus() == 0) {
                this.setStatus(-1);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dbgPrnt(String msg) {
        Sem sem = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (sem) {
            boolean bl3 = false;
            String string2 = this.getLock() + " : " + msg + " (#jobs: " + this.numJobs + " status: " + this.getStatus() + "  results: " + this.results + ')';
            boolean bl4 = false;
            System.out.println((Object)string2);
            Unit unit = Unit.INSTANCE;
        }
    }
}

