"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTestApi = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const api = require("aws-cdk-lib/aws-apigateway");
const core_1 = require("@aws-solutions-constructs/core");
function CreateTestApi(stack, id) {
    const lamdaFunction = new lambda.Function(stack, `${id}Function`, {
        code: lambda.Code.fromAsset(`${__dirname}/lambda`),
        runtime: lambda.Runtime.NODEJS_14_X,
        handler: ".handler",
    });
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W58", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W89", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W92", reason: "Test Resource" }]);
    const restApi = new api.LambdaRestApi(stack, `${id}Api`, {
        handler: lamdaFunction,
    });
    const newDeployment = restApi.latestDeployment;
    if (newDeployment) {
        core_1.addCfnSuppressRules(newDeployment, [
            { id: "W68", reason: "Test Resource" },
        ]);
    }
    const newMethod = restApi.methods[0];
    core_1.addCfnSuppressRules(newMethod, [{ id: "W59", reason: "Test Resource" }]);
    const newMethodTwo = restApi.methods[1];
    core_1.addCfnSuppressRules(newMethodTwo, [{ id: "W59", reason: "Test Resource" }]);
    const newStage = restApi.deploymentStage;
    core_1.addCfnSuppressRules(newStage, [{ id: "W64", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(newStage, [{ id: "W69", reason: "Test Resource" }]);
    return restApi;
}
exports.CreateTestApi = CreateTestApi;
//# sourceMappingURL=data:application/json;base64,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