# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['scAnnot']

# %% ../nbs/00_core.ipynb 4
import scanpy as sc
import scvi
from fastcore.script import *
import warnings

# %% ../nbs/00_core.ipynb 6
@call_parse
def scAnnot(h5:str, #the input h5ad file, must have row counts in X or layers
            output:str = None, # The path of output file. 1. None->output AnnData object with predicted labels, 2. a path end with h5ad->write out the AnnData. 3. a path end with csv-> write out the table of predicted labels. 
            show:bool=False, #show umap plot. may not work in command line
           ):
    warnings.filterwarnings("ignore")
    ad=sc.read(h5)
   
    if 'counts' not in ad.layers.keys():
        ad.layers['counts']=ad.X

    model=scvi.model.SCANVI.load_query_data(
            ad,
            '/home/huang_yin/projA/scBERT/model/twostep_2layer_subgenes/scanvi_3_epoch_model/',
            freeze_dropout = True,
            inplace_subset_query_vars = True,
        )
    
    ad.obs['predict_level1']=model.predict()
    
    if show:
        model.is_trained=True
        latent=sc.AnnData(model.get_latent_representation())
          
    ad.obs['predict_level2']='unknown'
    for i in ad.obs['predict_level1'].unique():
        sub_ad=ad[ad.obs.predict_level1==i]
        model=scvi.model.SCANVI.load_query_data(
            sub_ad,
            f'/home/huang_yin/projA/scBERT/model/twostep_2layer_subgenes/v1_scanvi_subtype_{i}/',
            freeze_dropout = True,
            inplace_subset_query_vars = True,
        )
        ad.obs['predict_level2'][ad.obs.predict_level1==i]=model.predict()
    if show:
        latent.obs['predict_level1']=ad.obs['predict_level1'].tolist()
        latent.obs['predict_level2']=ad.obs['predict_level2'].tolist()
        sc.pp.neighbors(latent)
        sc.tl.umap(latent)
        sc.pl.umap(latent,color=['predict_level1', 'predict_level2'],frameon=False)
       
    if output is not None:
        if output.endswith('.csv'):
            ad.obs[['predict_level1','predict_level2']].to_csv(output)
            return
        if output.split('.')[-1] in ['h5ad','h5']:
            ad.write_h5ad(output)
            return
    return ad

