"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resources = [
    {
        apiVersion: "v1",
        kind: "Service",
        metadata: { name: "hello-kubernetes" },
        spec: {
            type: "LoadBalancer",
            ports: [{ port: 80, targetPort: 8080 }],
            selector: { app: "hello-kubernetes" }
        }
    },
    {
        apiVersion: "apps/v1",
        kind: "Deployment",
        metadata: { name: "hello-kubernetes" },
        spec: {
            replicas: 1,
            selector: { matchLabels: { app: "hello-kubernetes" } },
            template: {
                metadata: {
                    labels: { app: "hello-kubernetes" }
                },
                spec: {
                    containers: [
                        {
                            name: "hello-kubernetes",
                            image: "paulbouwer/hello-kubernetes:1.5",
                            ports: [{ containerPort: 8080 }]
                        }
                    ]
                }
            }
        }
    }
];
//# sourceMappingURL=data:application/json;base64,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