import { Construct } from "@aws-cdk/core";
import { Cluster } from "./cluster";
export interface CoreDnsComputeTypeProps {
    /**
     * The cluster to apply the patch to.
     */
    readonly cluster: Cluster;
    /**
     * The JSON object to pass to `kubectl patch` when the resource is created/updated.
     */
    readonly applyPatch: any;
    /**
     * The JSON object to pass to `kubectl patch` when the resource is removed.
     */
    readonly restorePatch: any;
    /**
     * The full name of the resource to patch (e.g. `deployment/coredns`).
     */
    readonly resourceName: string;
    /**
     * The kubernetes API namespace
     *
     * @default "default"
     */
    readonly resourceNamespace?: string;
}
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 */
export declare class KubernetesPatch extends Construct {
    constructor(scope: Construct, id: string, props: CoreDnsComputeTypeProps);
}
