import { Intrinsic } from './private/intrinsic';
/**
 * An intrinsic Token that represents a reference to a construct.
 *
 * References are recorded.
 *
 * @stability stable
 */
export declare abstract class Reference extends Intrinsic {
    /**
     * Check whether this is actually a Reference.
     *
     * @stability stable
     */
    static isReference(x: any): x is Reference;
    /**
     * @stability stable
     */
    readonly target: IConstruct;
    /**
     * @stability stable
     */
    readonly displayName: string;
    /**
     * @stability stable
     */
    constructor(value: any, target: IConstruct, displayName?: string);
}
import { IConstruct } from './construct-compat';
