"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLibraryReadme = exports.createModuleDefinitionFromCfnNamespace = void 0;
const fs = require("fs-extra");
function createModuleDefinitionFromCfnNamespace(namespace) {
    const [moduleFamily, moduleBaseName] = (namespace === 'AWS::Serverless' ? 'AWS::SAM' : namespace).split('::');
    const moduleName = `${moduleFamily}-${moduleBaseName.replace(/V\d+$/, '')}`.toLocaleLowerCase();
    const lowcaseModuleName = moduleBaseName.toLocaleLowerCase();
    const packageName = `@aws-cdk/${moduleName}`;
    // dotnet names
    const dotnetPackage = `Amazon.CDK.${moduleFamily}.${moduleBaseName}`;
    // java names
    const javaGroupId = 'software.amazon.awscdk';
    const javaPackage = moduleFamily === 'AWS'
        ? `services.${lowcaseModuleName}`
        : `${moduleFamily.toLocaleLowerCase()}.${lowcaseModuleName}`;
    const javaArtifactId = moduleFamily === 'AWS'
        ? lowcaseModuleName
        : `${moduleFamily.toLocaleLowerCase()}-${lowcaseModuleName}`;
    // python names
    const pythonDistName = `aws-cdk.${moduleName}`;
    const pythonModuleName = pythonDistName.replace(/-/g, '_');
    return {
        namespace,
        moduleName,
        moduleFamily,
        moduleBaseName,
        packageName,
        dotnetPackage,
        javaGroupId,
        javaPackage,
        javaArtifactId,
        pythonDistName,
        pythonModuleName,
    };
}
exports.createModuleDefinitionFromCfnNamespace = createModuleDefinitionFromCfnNamespace;
async function createLibraryReadme(namespace, readmePath) {
    const module = createModuleDefinitionFromCfnNamespace(namespace);
    await fs.writeFile(readmePath, [
        `# ${namespace} Construct Library`,
        '<!--BEGIN STABILITY BANNER-->',
        '',
        '---',
        '',
        '![cfn-resources: Stable](https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge)',
        '',
        '> All classes with the `Cfn` prefix in this module ([CFN Resources]) are always stable and safe to use.',
        '>',
        '> [CFN Resources]: https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib',
        '',
        '---',
        '',
        '<!--END STABILITY BANNER-->',
        '',
        'This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.',
        '',
        '```ts nofixture',
        `import * as ${module.moduleName.toLocaleLowerCase().replace(/[^a-z0-9_]/g, '_')} from '${module.packageName}';`,
        '```',
        '',
    ].join('\n'), 'utf8');
}
exports.createLibraryReadme = createLibraryReadme;
//# sourceMappingURL=data:application/json;base64,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