# auto generated by update_py.py

from . import message_pb2 as message_pb


def _reqAccountStr(self):
    return '<req_a tg={} sub={} rid={} sender={}>'.format(
        self.account_id, self.sub_account, self.req_id, self.sender
    )


def _rspAccountStr(self):
    return '<account tg={} avail={} balance={} frz_amt={} mkt_v={} equity={} frz_mar={} cur={} ft={} pnl={} | {} | {} eid={} err={}>'.format(
        self.account_id, self.avail_amt, self.balance, self.frz_amt, self.mkt_value, self.equity,
        self.frz_margin, message_pb.Currency.Name(self.currency), message_pb.FundType.Name(self.fund_type),
        self.pnl, self.realized_pnl, self.unrealized_pnl, self.err_id, self.err_msg
    )


def _reqPositionStr(self):
    return '<req_p tg={} sub={} rid={} sender={}>'.format(
        self.account_id, self.sub_account, self.req_id, self.sender
    )


def _positionInfoStr(self):
    return '<pos-{} exch={} tkr={} sub={} dir={} mm={} pos={} ydpos={} cost={} frz={} avail={} brw={} i={} lpx={} rr={} pnl={} | {} | {}>'.format(
        message_pb.SecurityType.Name(self.security_type), message_pb.Exchange.Name(self.exchange), self.symbol,
        self.sub_account, message_pb.Direction.Name(self.direction), message_pb.MarginMode.Name(self.margin_mode),
        self.position, self.yd_pos, self.pos_cost, self.frz_pos, self.avail_pos, self.borrowed, self.interest,
        self.liq_price, self.risk_rate, self.pnl, self.realized_pnl, self.unrealized_pnl
    )


def _gatewayPositionStr(self):
    s = '<position tg={} count={} eid={} err={}\n'.format(self.account_id, len(self.positions), self.err_id, self.err_msg)
    for pos in self.positions:
        s += '\t' + str(pos) + '\n'
    s += '>'
    return s


def _reqActiveOrdersStr(self):
    return '<req_act_o tg={} sub={} rid={} sender={}>'.format(
        self.account_id, self.sub_account, self.req_id, self.sender
    )


def _gatewayOrdersStr(self):
    s = '<orders tg={} count={} eid={} err={}\n'.format(self.account_id, len(self.orders), self.err_id, self.err_msg)
    for order in self.orders:
        s += '\t' + str(order) + '\n'
    s += '>'
    return s


def _gatewayTradesStr(self):
    s = '<trades tg={} count={} eid={} err={}\n'.format(self.account_id, len(self.trades), self.err_id, self.err_msg)
    for trade in self.trades:
        s += '\t' + str(trade) + '\n'
    s += '>'
    return s


def _reqOrderCancelStr(self):
    return '<oc oid={} rid={} tg_name={}>'.format(
        self.order_id, self.req_id, self.account_id
    )


def _rspOrderCancelStr(self):
    return '<roc rid={} oid={} ref={} eid={} err={}>'.format(
        self.req_id, self.order_id, self.order_ref, self.err_id, self.err_msg
    )


def _reqOrderInsertStr(self):
    return '<ord-{} pid={} tg={} exch={} ref={} tkr={} px={} vol={} type={} dir={}>'.format(
        self.order_id, self.parent_id, self.account_id, message_pb.Exchange.Name(self.exchange),
        self.order_ref, self.symbol, self.entrust_price, self.entrust_vol,
        message_pb.OrderType.Name(self.order_type), message_pb.Side.Name(self.side)
    )


def _rspOrderInsertStr(self):
    return '<roi oid={} ref={} err_id={} err_msg={}>'.format(
        self.order_id, self.order_ref, self.err_id, self.err_msg
    )


def _reqCreditCashRepayStr(self):
    return '<rcred_cr oid={} ref={} amt={} cid={}>'.format(
        self.order_id, self.order_ref, self.amount, self.contract_id
    )


def _rspCreditCashRepayStr(self):
    return '<rcred_cr oid={} ref={} err_id={} err_msg={}>'.format(
        self.order_id, self.order_ref, self.err_id, self.err_msg
    )


def _reqCreditExtendDebtDateStr(self):
    return '<rcred_edd oid={} ref={} cid={} ddays={}>'.format(
        self.order_id, self.order_ref, self.contract_id, self.defer_days
    )


def _rspCreditExtendDebtDateStr(self):
    return '<rcred_edd oid={} ref={} err_id={} err_msg={}>'.format(
        self.order_id, self.order_ref, self.err_id, self.err_msg
    )


def _rtnOrderStr(self):
    return '<o oid={} ref={} tg={} exch={} ass={} tkr={} dir={} of={} tp={} status={} traded={} create_t={} update_t={}>'.format(
        self.order_id, self.order_ref, self.account_id, message_pb.Exchange.Name(self.exchange),
        message_pb.SecurityType.Name(self.security_type), self.symbol, message_pb.Side.Name(self.side),
        message_pb.OffsetFlag.Name(self.offset_flag), message_pb.OrderType.Name(self.order_type),
        message_pb.OrderStatus.Name(self.order_status), self.traded_vol, self.create_time.ToDatetime(), self.update_time.ToDatetime()
    )


def _rtnTradeStr(self):
    return '<t tid={} oid={} ref={} tg={} exch={} ass={} tkr={} dir={} of={} tp={} px={} vol={} amt={} comm={} t={}>'.format(
        self.trade_ref, self.order_id, self.order_ref, self.account_id, message_pb.Exchange.Name(self.exchange),
        message_pb.SecurityType.Name(self.security_type), self.symbol, message_pb.Side.Name(self.side),
        message_pb.OffsetFlag.Name(self.offset_flag), message_pb.OrderType.Name(self.order_type),
        self.traded_price, self.traded_vol, self.traded_amt, self.commission, self.trade_time.ToDatetime()
    )


def _rtnCreditCashRepayStr(self):
    return '<cred_cr oid={} ref={} ramt={} cramt={} cid={}>'.format(
        self.order_id, self.order_ref, self.request_amount, self.cash_repay_amount, self.contract_id
    )


def _rtnCreditExtendDebtDateStr(self):
    return '<cred_edd oid={} ref={} cid={} os={} ot={}>'.format(
        self.order_id, self.order_ref, self.contract_id, message_pb.CreditDebtExtendOperStatus.Name(self.oper_status), self.oper_time.ToDatetime()
    )


def _reqOrderInfoStr(self):
    return '<req_o oid={} sender={}>'.format(
        self.order_id, self.sender
    )


def _reqHistoryTradesStr(self):
    return '<req_his_t tg={} sub={} rid={} sender={}>'.format(
        self.account_id, self.sub_account, self.req_id, self.sender
    )


def _rspHistoryTradesStr(self):
    s = '<trades tg={} count={} eid={} err={}\n'.format(self.account_id, len(self.trades), self.err_id, self.err_msg)
    for trade in self.trades:
        s += '\t' + str(trade) + '\n'
    s += '>'
    return s


def _rspCancelActiveOrdersStr(self):
    return '<aoc eid={} err={}>'.format(self.err_id, self.err_msg)


def _rspFundTransferInfoOneStr(self):
    return '<fti sid={} type={} amt={} st={} tt={}>'.format(
        self.serial_id, self.fund_trans_type, self.amount, self.fund_oper_status, self.transfer_time.ToDatetime()
    )


def _rspRspFundTransferInfoStr(self):
    s = '<fund_trans tg={} count={} eid={} err={} rt={}\n'.format(self.account_id, len(self.infos), self.err_id, self.err_msg, self.recv_time.ToDatetime())
    for one in self.infos:
        s += '\t' + str(one) + '\n'
    s += '>'
    return s


def _reqFundTransFromBankToFutureStr(self):
    return '<reqft_b2f tg={} bid={} bro_id={} b_acc={} acc={} ta={}>'.format(
        self.account_id, self.bank_id, self.broker_id, self.bank_account, self.account, self.trade_amount
    )


def _rspFundTransFromBankToFutureOneStr(self):
    return '<fto tcode={} bid={} bro_id={} bs={} ps={} cname={} fs={} ta={} tid={} ts={} tt={}>'.format(
        self.trade_code, self.bank_id, self.broker_id, self.bank_serial, self.plate_serial, self.custom_name, self.future_serial, self.trade_amount, self.tid, self.transfer_status, self.transfer_time.ToDatetime()
    )


def _rspFundTransFromBankToFutureStr(self):
    s = '<ft_b2f tg={} count={} eid={} err={} rt={}\n'.format(self.account_id, len(self.infos), self.err_id, self.err_msg, self.recv_time.ToDatetime())
    for one in self.infos:
        s += '\t' + str(one) + '\n'
    s += '>'
    return s


def _rspIPOInfoOneStr(self):
    return '<ii exch={} tkr={} tkrn={} tkrt={} p={} u={} qul={}>'.format(
        message_pb.Exchange.Name(self.exchange), self.symbol, self.symbol_name, self.symbol_type, self.price, self.unit, self.qty_upper_limit
    )


def _rspIPOInfoStr(self):
    s = '<ipo_i tg={} count={} eid={} err={} rt={}\n'.format(self.account_id, len(self.infos), self.err_id, self.err_msg, self.recv_time.ToDatetime())
    for one in self.infos:
        s += '\t' + str(one) + '\n'
    s += '>'
    return s


def _rspIPOQuotaInfoOneStr(self):
    return '<iqi exch={} qt={} tqt={}>'.format(
        message_pb.Exchange.Name(self.exchange), self.quantity, self.tech_quantity
    )


def _rspIPOQuotaInfoStr(self):
    s = '<ipo_qi tg={} count={} eid={} err={} rt={}\n'.format(self.account_id, len(self.infos), self.err_id, self.err_msg, self.recv_time.ToDatetime())
    for one in self.infos:
        s += '\t' + str(one) + '\n'
    s += '>'
    return s


def _rspCreditContractStr(self):
    return '<cc dt={} cid={} pid={} ref={} ds={} exch={} tkr={} od={} ed={} oed={} ra={} rq={} ri={}>'.format(
        message_pb.CreditContractType.Name(self.contract_type), self.contract_id, self.position_id, self.order_ref, message_pb.CreditContractStatus.Name(self.contract_status), message_pb.Exchange.Name(self.exchange), self.symbol,
        self.order_date.ToDatetime(), self.end_date.ToDatetime(), self.orig_end_date.ToDatetime(), self.remain_amt, self.remain_qty, self.remain_interest
    )


def _rspCreditActiveContractsStr(self):
    s = '<c_acs tg={} count={} eid={} err={} rt={}\n'.format(self.account_id, len(self.infos), self.err_id, self.err_msg, self.recv_time.ToDatetime())
    for one in self.infos:
        s += '\t' + str(one) + '\n'
    s += '>'
    return s


def _rspCreditTickerAssignInfoOneStr(self):
    return '<taio exch={} tkr={} lm_qty={} lf_qty={} fz_qty={}>'.format(
        message_pb.Exchange.Name(self.exchange), self.symbol, self.limit_qty, self.left_qty, self.frozen_qty
    )


def _rspCreditTickerAssignInfoStr(self):
    s = '<c_tai tg={} count={} eid={} err={} rt={}\n'.format(self.account_id, len(self.infos), self.err_id, self.err_msg, self.recv_time.ToDatetime())
    for one in self.infos:
        s += '\t' + str(one) + '\n'
    s += '>'
    return s


def _rspCreditExcessStockOneStr(self):
    return '<eso exch={} tkr={} taq={} teq={}>'.format(
        message_pb.Exchange.Name(self.exchange), self.symbol, self.transferable_quantity, self.transferred_quantity
    )


def _rspCreditExcessStockStr(self):
    s = '<c_es tg={} count={} eid={} err={} rt={}\n'.format(self.account_id, len(self.stocks), self.err_id, self.err_msg, self.recv_time.ToDatetime())
    for one in self.stocks:
        s += '\t' + str(one) + '\n'
    s += '>'
    return s


message_pb.ReqAccount.__str__ = _reqAccountStr
message_pb.RspAccount.__str__ = _rspAccountStr
message_pb.ReqPosition.__str__ = _reqPositionStr
message_pb.PositionInfo.__str__ = _positionInfoStr
message_pb.GatewayPosition.__str__ = _gatewayPositionStr
message_pb.ReqActiveOrders.__str__ = _reqActiveOrdersStr
message_pb.GatewayOrders.__str__ = _gatewayOrdersStr
message_pb.ReqOrderCancel.__str__ = _reqOrderCancelStr
message_pb.RspOrderCancel.__str__ = _rspOrderCancelStr
message_pb.ReqOrderInsert.__str__ = _reqOrderInsertStr
message_pb.RspOrderInsert.__str__ = _rspOrderInsertStr
message_pb.ReqCreditCashRepay.__str__ = _reqCreditCashRepayStr
message_pb.RspCreditCashRepay.__str__ = _rspCreditCashRepayStr
message_pb.ReqCreditExtendDebtDate.__str__ = _reqCreditExtendDebtDateStr
message_pb.RspCreditExtendDebtDate.__str__ = _rspCreditExtendDebtDateStr
message_pb.RtnOrder.__str__ = _rtnOrderStr
message_pb.RtnTrade.__str__ = _rtnTradeStr
message_pb.RtnCreditCashRepay.__str__ = _rtnCreditCashRepayStr
message_pb.RtnCreditExtendDebtDate.__str__ = _rtnCreditExtendDebtDateStr
message_pb.ReqOrderInfo.__str__ = _reqOrderInfoStr
message_pb.ReqHistoryTrades.__str__ = _reqHistoryTradesStr
message_pb.RspHistoryTrades.__str__ = _rspHistoryTradesStr
# message_pb.ReqCancelActiveOrders.__str__
message_pb.RspCancelActiveOrders.__str__ = _rspCancelActiveOrdersStr
message_pb.GatewayTrades.__str__ = _gatewayTradesStr
message_pb.FundTransferInfoOne.__str__ = _rspFundTransferInfoOneStr
message_pb.RspFundTransferInfo.__str__ = _rspRspFundTransferInfoStr
message_pb.ReqFundTransFromBankToFuture.__str__ = _reqFundTransFromBankToFutureStr
message_pb.FundTransFromBankToFutureOne.__str__ = _rspFundTransFromBankToFutureOneStr
message_pb.RspFundTransFromBankToFuture.__str__ = _rspFundTransFromBankToFutureStr
message_pb.IPOInfoOne.__str__ = _rspIPOInfoOneStr
message_pb.RspIPOInfo.__str__ = _rspIPOInfoStr
message_pb.IPOQuotaInfoOne.__str__ = _rspIPOQuotaInfoOneStr
message_pb.RspIPOQuotaInfo.__str__ = _rspIPOQuotaInfoStr
message_pb.CreditContract.__str__ = _rspCreditContractStr
message_pb.RspCreditActiveContracts.__str__ = _rspCreditActiveContractsStr
message_pb.CreditTickerAssignInfoOne.__str__ = _rspCreditTickerAssignInfoOneStr
message_pb.RspCreditTickerAssignInfo.__str__ = _rspCreditTickerAssignInfoStr
message_pb.CreditExcessStockOne.__str__ = _rspCreditExcessStockOneStr
message_pb.RspCreditExcessStock.__str__ = _rspCreditExcessStockStr
