# auto generated by update_py.py

import json

from tlclient.linker.constant import FistType

from .constant import MsgType
from .gateway import Gateway
from .message_market import MktInfo


class MarketGateway(Gateway):

    def __init__(self, acc_name, gateway_name, env_name, addr):
        Gateway.__init__(self, acc_name, gateway_name, env_name, addr, FistType.MARKET_GATEWAY)

    # to be override

    def subscribe_mkt_infos(self, mkt_infos):
        pass

    # callbacks

    def _on_subcribe_mkt_infos(self, mkt_infos, frame_nano):
        self.subscribe_mkt_infos(mkt_infos)

    #

    def on_pub_frame(self, frame):
        msg_type = frame.get_msg_type()
        frame_nano = frame.get_nano()
        if msg_type == MsgType.MKT_SUBSCRIBE:
            mkt_infos = json.loads(frame.get_string())
            mkt_infos = [MktInfo(d) for d in mkt_infos]
            self._on_subcribe_mkt_infos(mkt_infos, frame_nano)

    def push_mkt_trade(self, obj):
        self.safe_push(obj, MsgType.MKT_TRADE)

    def push_mkt_bar(self, obj):
        self.safe_push(obj, MsgType.MKT_BAR)

    def push_mkt_snap(self, obj):
        self.safe_push(obj, MsgType.MKT_SNAP)

    def push_mkt_index(self, obj):
        self.safe_push(obj, MsgType.MKT_INDEX)
