(self.webpackChunkspreadsheet_editor=self.webpackChunkspreadsheet_editor||[]).push([[10],{524:(e,t,n)=>{"use strict";n.d(t,{Z:()=>i});var r=n(645),o=n.n(r)()((function(e){return e[1]}));o.push([e.id,"\r\n/**\r\n * (c) jSuites Javascript Web Components\r\n *\r\n * Author: Paul Hodel <paul.hodel@gmail.com>\r\n * Website: https://bossanova.uk/jsuites/\r\n * Description: Create amazing web based applications.\r\n *\r\n * MIT License\r\n *\r\n */\r\n\r\n/** General **/\r\n\r\n:root {\r\n    --button-color: #298BA8; \r\n    --active-color: #007aff;\r\n}\r\n\r\n.jdragging {\r\n    opacity:0.2;\r\n    filter: alpha(opacity=20);\r\n}\r\n\r\n.jupload {\r\n    background-image: url(data:image/png;base64,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);\r\n    background-repeat: no-repeat;\r\n    background-size: 100px;\r\n    background-position: center;\r\n    background-color: rgba(230, 230, 230, 0.1);\r\n    border: 1px dotted #eee;\r\n    cursor: pointer;\r\n    box-sizing: border-box;\r\n    width:100%;\r\n    min-height:180px;\r\n}\r\n\r\n.jremove {\r\n    opacity: 0.2;\r\n    filter: alpha(opacity=20);\r\n}\r\n\r\n/** Animations **/\r\n.fade-in {\r\n    animation: fade-in 2s forwards;\r\n}\r\n\r\n.fade-out {\r\n    animation: fade-out 1s forwards;\r\n}\r\n\r\n.slide-left-in {\r\n    animation: slide-left-in 0.4s forwards;\r\n}\r\n\r\n.slide-left-out {\r\n    animation: slide-left-out 0.4s forwards;\r\n}\r\n\r\n.slide-right-in {\r\n    animation: slide-right-in 0.4s forwards;\r\n}\r\n\r\n.slide-right-out {\r\n    animation: slide-right-out 0.4s forwards;\r\n}\r\n\r\n.slide-top-in {\r\n    animation: slide-top-in 0.4s forwards;\r\n}\r\n\r\n.slide-top-out {\r\n    animation: slide-top-out 0.2s forwards;\r\n}\r\n\r\n.slide-bottom-in {\r\n    animation: slide-bottom-in 0.4s forwards;\r\n}\r\n\r\n.slide-bottom-out {\r\n    animation: slide-bottom-out 0.1s forwards;\r\n}\r\n\r\n/** Fadein and Fadeout **/\r\n@keyframes fade-in {\r\n    0% { opacity: 0; }\r\n    100% { opacity: 100; }\r\n}\r\n\r\n@-webkit-keyframes fade-in {\r\n    0% { opacity: 0; }\r\n    100% { opacity: 100; }\r\n}\r\n\r\n@keyframes fade-out {\r\n    0% { opacity: 100; }\r\n    100% { opacity: 0; }\r\n}\r\n\r\n@-webkit-keyframes fade-out {\r\n    0% { opacity: 100; }\r\n    100% { opacity: 0; }\r\n}\r\n\r\n/** Keyframes Left to Right **/\r\n@keyframes slide-left-in {\r\n    0% { transform: translateX(-100%); }\r\n    100% { transform: translateX(0%); }\r\n}\r\n\r\n@-webkit-keyframes slide-left-in {\r\n    0% { transform: translateX(-100%); }\r\n    100% { -webkit-transform: translateX(0%); }\r\n}\r\n    \r\n@keyframes slide-left-out {\r\n    0% { transform: translateX(0%); }\r\n    100% { transform: translateX(-100%); }\r\n}\r\n\r\n@-webkit-keyframes slide-left-out {\r\n    0% { -webkit-transform: translateX(0%); }\r\n    100% { -webkit-transform: translateX(-100%); }\r\n}\r\n\r\n/** Keyframes Right to Left **/\r\n@keyframes slide-right-in {\r\n    0% { transform: translateX(100%); }\r\n    100% { transform: translateX(0%); }\r\n}\r\n\r\n@-webkit-keyframes slide-right-in\r\n{\r\n    0% { transform: translateX(100%); }\r\n    100% { -webkit-transform: translateX(0%); }\r\n}\r\n    \r\n@keyframes slide-right-out {\r\n    0% { transform: translateX(0%); }\r\n    100% { transform: translateX(100%); }\r\n}\r\n\r\n@-webkit-keyframes slide-right-out {\r\n    0% { -webkit-transform: translateX(0%); }\r\n    100% { -webkit-transform: translateX(100%); }\r\n}\r\n\r\n/** Keyframes Top to Bottom **/\r\n@keyframes slide-top-in {\r\n    0% { transform: translateY(-100%); }\r\n    100% { transform: translateY(0%); }\r\n}\r\n\r\n@-webkit-keyframes slide-top-in {\r\n    0% { transform: translateY(-100%); }\r\n    100% { -webkit-transform: translateY(0%); }\r\n}\r\n    \r\n@keyframes slide-top-out {\r\n    0% { transform: translateY(0%); }\r\n    100% { transform: translateY(-100%); }\r\n}\r\n\r\n@-webkit-keyframes slide-top-out {\r\n    0% { -webkit-transform: translateY(0%); }\r\n    100% { -webkit-transform: translateY(-100%); }\r\n}\r\n\r\n/** Keyframes Bottom to Top **/\r\n@keyframes slide-bottom-in {\r\n    0% { transform: translateY(100%); }\r\n    100% { transform: translateY(0%); }\r\n}\r\n\r\n@-webkit-keyframes slide-bottom-in {\r\n    0% { transform: translateY(100%); }\r\n    100% { -webkit-transform: translateY(0%); }\r\n}\r\n    \r\n@keyframes slide-bottom-out {\r\n    0% { transform: translateY(0%); }\r\n    100% { transform: translateY(100%); }\r\n}\r\n\r\n@-webkit-keyframes slide-bottom-out {\r\n    0% { -webkit-transform: translateY(0%); }\r\n    100% { -webkit-transform: translateY(100%); }\r\n}\r\n\r\n\r\n@supports (-webkit-overflow-scrolling: touch) {\r\n    .app .options input:checked:before {\r\n        top:-12px;\r\n    }\r\n}\r\n\r\n@-webkit-keyframes spin {\r\n    from {\r\n        -webkit-transform:rotate(0deg);\r\n    }\r\n    to {\r\n        -webkit-transform:rotate(360deg);\r\n    }\r\n}\r\n\r\n@keyframes spin {\r\n    from {\r\n        transform:rotate(0deg);\r\n    }\r\n    to {\r\n        transform:rotate(360deg);\r\n    }\r\n}\r\n\r\n.unselectable {\r\n    -webkit-touch-callout: none;\r\n    -webkit-user-select: none;\r\n    -khtml-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n    user-select: none;\r\n}\r\n\r\n.jbutton {\r\n    padding:4px;\r\n    padding-left:10px;\r\n    padding-right:20px;\r\n    border:1px solid #ddd;\r\n    display:inline-flex;\r\n    border-radius:4px;\r\n    cursor:pointer;\r\n    line-height: 24px;\r\n    -webkit-font-smoothing: antialiased;\r\n}\r\n\r\n.jbutton.blue {\r\n    border:1px solid transparent;\r\n    color:#fff;\r\n    background-color:#1a73e8;\r\n}\r\n\r\n.jbutton::before {\r\n    content: attr(data-icon);\r\n    width: 24px;\r\n    height: 24px;\r\n    font-size: 24px;\r\n    line-height: 24px;\r\n    font-family: 'Material icons';\r\n    color: #999;\r\n    margin-right:2px;\r\n}\r\n\r\n.jbutton.blue::before {\r\n    color: #fff;\r\n}\r\n\r\n.jbutton:hover {\r\n    background-color: #eee;\r\n}\r\n\r\n.jbutton.blue:hover {\r\n    background-color: #1a73e8;\r\n    opacity: 0.8;\r\n}\r\n\r\n/**\n * Date & Datetime picker v1.0.1\n * Author: paul.hodel@gmail.com\n * https://github.com/paulhodel/jtools\n */\n \n.jcalendar {\n    position:relative;\n    z-index:9000;\n    display:none;\n    box-sizing:border-box;\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n    -khtml-user-select: none;\n    -moz-user-select: none;\n    -ms-user-select: none;\n    user-select: none;\n    -webkit-tap-highlight-color: rgba(0,0,0,0);\n    -webkit-tap-highlight-color: transparent;\n    min-width:280px;\n}\n\n.jcalendar-focus {\n    display:block;\n}\n\n.jcalendar-backdrop {\n    position:fixed;\n    top:0px;\n    left:0px;\n    z-index:9000;\n    min-width:100%;\n    min-height:100%;\n    background-color:rgba(0,0,0,0.5);\n    border:0px;\n    padding:0px;\n    display:none;\n}\n\n.jcalendar-container {\n    position:relative;\n    box-sizing:border-box;\n}\n\n.jcalendar-content {\n    position:absolute;\n    z-index:9001;\n    -webkit-box-shadow: 1px 1px 5px 0px rgba(0,0,0,0.39);\n    -moz-box-shadow: 1px 1px 5px 0px rgba(0,0,0,0.39);\n    box-shadow: 1px 1px 5px 0px rgba(0,0,0,0.39);\n    background-color:#fff;\n}\n\n.jcalendar-table > table {\n    width:100%;\n    background-color:#fff;\n}\n\n.jcalendar-table > table > tbody td {\n    box-sizing:border-box;\n    cursor:pointer;\n    padding:9px;\n    font-size:0.9em;\n}\n\n.jcalendar-table > table > thead {\n    cursor:pointer;\n}\n\n.jcalendar-header {\n    text-align:center;\n}\n\n.jcalendar-header span {\n    margin-right:4px;\n    font-size:1.1em;\n    font-weight:bold;\n}\n\n.jcalendar-prev {\n    cursor:pointer;\n    background-image:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath d='M15.41 16.59L10.83 12l4.58-4.59L14 6l-6 6 6 6 1.41-1.41z' fill='%23000' /%3E%3Cpath fill='none' d='M0 0h24v24H0V0z'/%3E%3C/svg%3E\");\n    background-position:center;\n    background-repeat:no-repeat;\n}\n\n.jcalendar-next {\n    cursor:pointer;\n    background-image:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath d='M8.59 16.59L13.17 12 8.59 7.41 10 6l6 6-6 6-1.41-1.41z' fill='%23000' /%3E%3Cpath fill='none' d='M0 0h24v24H0V0z'/%3E%3C/svg%3E\");\n    background-position:center;\n    background-repeat:no-repeat;\n}\n\n.jcalendar-weekday {\n    font-weight: 600;\n    background-color: #fcfcfc;\n    padding: 14px;\n}\n\n.jcalendar thead td {\n    padding:10px;\n    height:40px;\n}\n\n.jcalendar tfoot td {\n    padding:10px;\n}\n\n.jcalendar-months td, .jcalendar-years td {\n    height:24px;\n} \n\n.jcalendar-input {\n    padding-right:18px;\n    background-image:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 24 24' fill='gray'%3E%3Cpath d='M20 3h-1V1h-2v2H7V1H5v2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 18H4V8h16v13z'/%3E%3Cpath fill='none' d='M0 0h24v24H0z'/%3E%3C/svg%3E\");\n    background-position:top 50% right 5px;\n    background-repeat:no-repeat;\n    box-sizing: border-box;\n}\n\n.jcalendar-done {\n    -webkit-box-shadow: 1px 1px 5px 0px rgba(0,0,0,0.39);\n    -moz-box-shadow: 1px 1px 5px 0px rgba(0,0,0,0.39);\n    box-shadow: 1px 1px 5px 0px rgba(0,0,0,0.39);\n    background-color:#fff;\n}\n\n.jcalendar-update {\n    border:1px solid #ccc;\n    background-color:#fff;\n    border-radius:4px;\n    padding:5px;\n    width:100%;\n}\n\n.jcalendar select {\n    width:55px;\n    display:inline-block;\n    border:0px;\n    padding:4px;\n    text-align:center;\n    font-size:1.1em;\n    user-select:none;\n    margin-right:10px;\n}\n\n.jcalendar select:first-child\n{\n    margin-right:2px;\n}\n\n.jcalendar-selected {\n    background-color:#eee;\n}\n\n.jcalendar-reset, .jcalendar-confirm {\n    text-transform:uppercase;\n    cursor:pointer;\n    color: var(--active-color);\n}\n\n.jcalendar-controls {\n    padding:15px;\n\n    -webkit-box-sizing: border-box;\n    box-sizing: border-box;\n    vertical-align:middle;\n\n    display: -webkit-box;\n    display: -moz-box;\n    display: -ms-flexbox;\n    display: -webkit-flex;\n    display: flex;\n\n    -webkit-flex-flow: row wrap;\n    justify-content: space-between;\n    align-items:center;\n\n    border-bottom:1px solid #ddd;\n}\n\n.jcalendar-controls div {\n    font-weight:bold;\n}\n\n.jcalendar-fullsize  {\n    position:fixed;\n    width:100%;\n    top:0px;\n    left:0px;\n}\n\n.jcalendar-fullsize .jcalendar-content\n{\n    position:fixed;\n    width:100%;\n    left:0px;\n    bottom:0px;\n}\n\n.jcalendar-focus.jcalendar-fullsize .jcalendar-backdrop {\n    display:block;\n}\n\n.jcalendar-sunday {\n    color: red;\n}\n.jcalendar-disabled {\n    color: #ccc;\n}\r\n\r\n.jcolor {\r\n    position: absolute;\r\n    display: none;\r\n    outline: none;\r\n}\r\n\r\n.jcolor-content {\r\n    position: absolute;\r\n    left: 0px;\r\n    z-index: 9000;\r\n    user-select: none;\r\n    -webkit-font-smoothing: antialiased;\r\n    font-size: .875rem;\r\n    letter-spacing: .2px;\r\n    -webkit-border-radius: 4px;\r\n    border-radius: 4px;\r\n    -webkit-box-shadow: 0 8px 10px 1px rgba(0,0,0,0.14), 0 3px 14px 2px rgba(0,0,0,0.12), 0 5px 5px -3px rgba(0,0,0,0.2);\r\n    box-shadow: 0 8px 10px 1px rgba(0,0,0,0.14), 0 3px 14px 2px rgba(0,0,0,0.12), 0 5px 5px -3px rgba(0,0,0,0.2);\r\n    background-color:#fff;\r\n    box-sizing: border-box;\r\n}\r\n\r\n.jcolor-content table {\r\n    padding: 7px;\r\n    box-sizing: border-box;\r\n}\r\n\r\n.jcolor-focus {\r\n    display:block;\r\n}\r\n\r\n.jcolor table {\r\n    width:100%;\r\n    height:100%;\r\n}\r\n\r\n.jcolor td {\r\n    border:2px solid #fff;\r\n}\r\n\r\n.jcolor-selected {\r\n    border:2px solid #000 !important;\r\n    background-repeat:no-repeat;\r\n    background-size: cover;\r\n    background-position:0 0;\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3Cpath d='M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z' fill='white'/%3E%3C/svg%3E\");\r\n}\r\n\r\n.jcolor-fullscreen {\r\n    position: fixed;\r\n    bottom: 0px;\r\n    width:100%;\r\n    max-height:250px;\r\n    border-radius: 0px;\r\n    box-sizing: border-box;\r\n}\r\n\r\n.jcolor-close {\r\n    display: none;\r\n    font-size: 1em;\r\n    color: var(--active-color);\r\n    text-transform: uppercase;\r\n    text-align: right;\r\n    padding: 15px;\r\n    font-weight: bold;\r\n    -webkit-box-shadow: 1px 0px 1px 0px rgba(0,0,0,0.39);\r\n    -moz-box-shadow: 1px 0px 1px 0px rgba(0,0,0,0.39);\r\n    box-shadow: 1px 0px 1px 0px rgba(0,0,0,0.39);\r\n    width: 100%;\r\n    box-sizing: border-box;\r\n}\r\n\r\n.jcolor-fullscreen .jcolor-close {\r\n    display: block;\r\n}\r\n\r\n.jcolor-backdrop {\r\n    position: fixed;\r\n    top: 0px;\r\n    left: 0px;\r\n    min-width: 100%;\r\n    min-height: 100%;\r\n    background-color: rgba(0,0,0,0.5);\r\n    border: 0px;\r\n    padding: 0px;\r\n    z-index: 8000;\r\n    display: none;\r\n    \r\n  -webkit-touch-callout: none; /* iOS Safari */\r\n    -webkit-user-select: none; /* Safari */\r\n     -khtml-user-select: none; /* Konqueror HTML */\r\n       -moz-user-select: none; /* Firefox */\r\n        -ms-user-select: none; /* Internet Explorer/Edge */\r\n            user-select: none; /* Non-prefixed version, currently\r\n                                  supported by Chrome and Opera */\r\n}\r\n\r\n/**\r\n * Contextmenu v1.0.1\r\n * Author: paul.hodel@gmail.com\r\n * https://github.com/paulhodel/jsuites\r\n */\r\n \r\n.jcontextmenu {\r\n    position:fixed;\r\n    z-index:10000;\r\n    background:#fff;\r\n    color: #555;\r\n    font-size: 11px;\r\n    -webkit-user-select: none;\r\n    -moz-user-select: none;\r\n    user-select: none;\r\n    -webkit-box-shadow: 2px 2px 2px 0px rgba(143, 144, 145, 1);\r\n    -moz-box-shadow: 2px 2px 2px 0px rgba(143, 144, 145, 1);\r\n    box-shadow: 2px 2px 2px 0px rgba(143, 144, 145, 1);\r\n    border: 1px solid #C6C6C6;\r\n    padding: 0px;\r\n    padding-top:4px;\r\n    padding-bottom:4px;\r\n    margin:0px;\r\n    outline:none;\r\n    display:none;\r\n}\r\n\r\n.jcontextmenu.jcontextmenu-focus {\r\n    display:inline-block;\r\n}\r\n\r\n.jcontextmenu > div {\r\n    box-sizing: border-box;\r\n    display: block;\r\n    padding: 8px 8px 8px 28px;\r\n    width: 250px;\r\n    position: relative;\r\n    cursor: default;\r\n    font-size: 11px;\r\n    font-family:sans-serif;\r\n}\r\n\r\n.jcontextmenu > div a {\r\n    color: #555;\r\n    text-decoration: none;\r\n}\r\n\r\n.jcontextmenu > div span {\r\n    float: right;\r\n    margin-right:10px;\r\n}\r\n\r\n.jcontextmenu .contextmenu-disabled {\r\n    color: #a1a192;\r\n}\r\n\r\n.jcontextmenu > div:not(.contextmenu-line):hover {\r\n    background: #ebebeb;\r\n}\r\n\r\n.jcontextmenu > div.contextmenu-line {\r\n    border-top: 1px solid #e9e9e9;\r\n    margin-top:5px;\r\n    padding:2px;\r\n}\r\n\r\n.jcontextmenu hr {\r\n    border: 1px solid #e9e9e9;\r\n    border-bottom: 0;\r\n    margin-top:5px;\r\n    margin-bottom:5px;\r\n}\r\n\r\n/**\r\n * Dialog v1.0.1\r\n * Author: paul.hodel@gmail.com\r\n * https://github.com/paulhodel/jtools\r\n */\r\n \r\n.jdialog\r\n{\r\n    position:fixed;\r\n    left: 0;\r\n    top: 0;\r\n    width: 100%;\r\n    min-height:100%;\r\n    z-index:10000;\r\n\r\n    background-color:rgba(0,0,0,0.5);\r\n    -webkit-transition-duration: .1s;\r\n    transition-duration: .1s;\r\n    display: flex;\r\n    -ms-flex-align: center;\r\n    -webkit-align-items: center;\r\n    -webkit-box-align: center;\r\n\r\n    align-items: center;\r\n}\r\n\r\n.jdialog .jdialog-container\r\n{\r\n    width:100%;\r\n    max-width:280px;\r\n    box-sizing: border-box;\r\n    margin:0 auto;\r\n    vertical-align:middle;\r\n    background-color:#fff;\r\n    border-radius:10px;\r\n\r\n    opacity: 0;\r\n    transition: opacity .2s;\r\n    -webkit-transition: opacity .2s;\r\n}\r\n\r\n.jdialog .jdialog-header\r\n{\r\n    padding:10px;\r\n    text-align:center;\r\n}\r\n\r\n.jdialog .jdialog-header .jdialog-title\r\n{\r\n    font-size:1em;\r\n    font-weight:bold;\r\n    padding:8px;\r\n}\r\n\r\n.jdialog .jdialog-header .jdialog-message\r\n{\r\n    padding: 4px;\r\n}\r\n\r\n.jdialog .jdialog-footer\r\n{\r\n    border-top: 1px solid #ccc;\r\n    display: flex;\r\n    flex-wrap: wrap;\r\n    align-content: stretch;\r\n    align-items: center;\r\n    text-align: center;\r\n}\r\n\r\n.jdialog .jdialog-footer > div\r\n{\r\n    padding:4px;\r\n    border-left:1px solid #ccc;\r\n    text-align:center;\r\n    width:100%;\r\n}\r\n.jdialog .jdialog-footer > div:first-child\r\n{\r\n    border-left:0px;\r\n}\r\n\r\n.jdialog .jdialog-footer input\r\n{\r\n    border: 0px;\r\n    margin: 0px;\r\n    background-color: transparent;\r\n    color: var(--active-color);\r\n    width: 100%;\r\n    outline: none;\r\n}\r\n\r\n/**\n * (c) 2013 jDropdown\n * http://www.github.com/paulhodel/jdropdown\n *\n * @author: Paul Hodel <paul.hodel@gmail.com>\n * @description: Custom dropdowns\n */\n\n.jdropdown\n{\n    cursor:pointer;\n    -webkit-touch-callout: none;\n    -webkit-user-select: none;\n    -khtml-user-select: none;\n    -moz-user-select: none;\n    -ms-user-select: none;\n    user-select: none;\n    box-sizing: border-box;\n    background:#fff;\n    -webkit-tap-highlight-color: transparent;\n    display: inline-block;\n}\n\n.jdropdown-header::placeholder\n{\n    color:#000;\n}\n\n.jdropdown-backdrop\n{\n    position:fixed;\n    top:0px;\n    left:0px;\n    min-width:100%;\n    min-height:100%;\n    background-color:rgba(0,0,0,0.5);\n    border:0px;\n    padding:0px;\n    z-index:8000;\n    display:none;\n}\n\n.jdropdown-focus\n{\n    position:relative;\n}\n\n.jdropdown-focus .jdropdown-container\n{\n    transform: translate3d(0,0,0);\n}\n\n.jdropdown-focus .jdropdown-header\n{\n    outline:auto 5px -webkit-focus-ring-color;\n}\n\n.jdropdown-container-header\n{\n    padding:0px;\n    margin:0px;\n    position:relative;\n}\n\n.jdropdown-header\n{\n    width:100%;\n    appearance: none;\n    background-repeat: no-repeat;\n    background-position:top 50% right 5px;\n    background-image: url(\"data:image/svg+xml,%0A%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath fill='none' d='M0 0h24v24H0V0z'/%3E%3Cpath d='M7 10l5 5 5-5H7z' fill='gray'/%3E%3C/svg%3E\");\n    text-overflow: ellipsis;\n    cursor:pointer;\n    box-sizing: border-box;\n    -webkit-appearance: none;\n    -moz-appearance: none;\n    padding-right:24px;\n}\n\n.jdropdown-insert-button\n{\n    font-size: 1.4em;\n    text-transform: uppercase;\n    position:absolute;\n    right: 30px;\n    top: 4px;\n    display:none;\n}\n\n.jdropdown-container\n{\n    min-width: inherit;\n    transform: translate3d(-10000px,0,0);\n    position:absolute;\n    z-index:9001;\n}\n\n.jdropdown-close\n{\n    display:none;\n    font-size:1em;\n    color: var(--active-color);\n    text-transform:uppercase;\n    text-align:right;\n    padding:15px;\n    font-weight:bold;\n}\n\n.jdropdown-content\n{\n    min-width:inherit;\n    margin:0px;\n    box-sizing:border-box;\n}\n\n.jdropdown-content:empty\n{\n}\n\n.jdropdown-item\n{\n    white-space: nowrap;\n    text-align: left;\n    text-overflow: ellipsis;\n    overflow-x: hidden;\n    color: #000;\n    display: flex;\n    align-items: center;\n}\n\n.jdropdown-image\n{\n    margin-right:10px;\n    width: 32px;\n    height: 32px;\n    border-radius:20px;\n}\n\n.jdropdown-image-small\n{\n    width:24px;\n    height:24px;\n}\n\n.jdropdown-title\n{\n    font-size: 0.7em;\n    text-overflow: ellipsis;\n    overflow-x: hidden;\n    display: block;\n}\n\n/** Default visual **/\n\n.jdropdown-default .jdropdown-header\n{\n    border:1px solid #ccc;\n    padding:5px;\n    padding-left:10px;\n    padding-right:16px;\n}\n\n.jdropdown-default .jdropdown-container\n{\n    background-color:#fff;\n}\n\n.jdropdown-default.jdropdown-focus.jdropdown-insert .jdropdown-header {\n    padding-right:50px;\n}\n\n.jdropdown-default.jdropdown-focus.jdropdown-insert .jdropdown-insert-button {\n    display:block;\n}\n\n.jdropdown-default .jdropdown-content\n{\n    min-width:inherit;\n    border:1px solid #8fb1e3;\n    margin:0px;\n    background-color:#fff;\n    box-sizing:border-box;\n    min-height:10px;\n    max-height:215px;\n    overflow-y:auto;\n}\n\n.jdropdown-default .jdropdown-item\n{\n    padding:4px;\n    padding-left:8px;\n    padding-right:40px;\n}\n\n.jdropdown-default .jdropdown-item:hover\n{\n    background-color:#1f93ff;\n    color:#fff;\n}\n\n.jdropdown-default .jdropdown-cursor\n{\n    background-color:#1f93ff;\n    color:#fff;\n}\n\n.jdropdown-default .jdropdown-selected\n{\n    background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNMCAwaDI0djI0SDB6IiBmaWxsPSJub25lIiAvPjxwYXRoIGQ9Ik05IDE2LjE3TDQuODMgMTJsLTEuNDIgMS40MUw5IDE5IDIxIDdsLTEuNDEtMS40MXoiIGZpbGw9IndoaXRlIiAvPjwvc3ZnPgo=');\n    background-repeat:no-repeat;\n    background-position:top 50% right 5px;\n    background-color:#1f93ff;\n    color:#fff;\n}\n\n.jdropdown-default .jdropdown-group\n{\n    margin-top:5px;\n}\n\n.jdropdown-default .jdropdown-group .jdropdown-item\n{\n    padding-left:16px;\n}\n\n.jdropdown-default .jdropdown-group-name\n{\n    padding-left:8px;\n    font-weight:bold;\n}\n\n\n/** Default render for mobile **/\n\n.jdropdown-picker.jdropdown-focus .jdropdown-header {\n    outline: none;\n}\n\n.jdropdown-picker.jdropdown-focus .jdropdown-backdrop {\n    display:block;\n}\n\n.jdropdown-picker .jdropdown-container\n{\n    position:fixed;\n    bottom:0px;\n    left:0px;\n    border-bottom:1px solid #e6e6e8;\n    width:100%;\n    background-color:#fff;\n    box-sizing: border-box;\n}\n\n.jdropdown-picker .jdropdown-close\n{\n    -webkit-box-shadow: 0px -1px 5px 0px rgba(0,0,0,0.39);\n    -moz-box-shadow: 0px -1px 5px 0px rgba(0,0,0,0.39);\n    box-shadow: 0px -1px 5px 0px rgba(0,0,0,0.39);\n    background-color:#fff;\n    display:block;\n}\n\n.jdropdown-picker .jdropdown-content\n{\n    overflow-y:scroll;\n    height:280px;\n    background-color:#fafafa;\n    border-top:1px solid #e6e6e8;\n}\n\n.jdropdown-picker .jdropdown-group-name\n{\n    font-size: 1em;\n    text-transform: uppercase;\n    padding-top:10px;\n    padding-bottom:10px;\n    display: block;\n    border-bottom: 1px solid #e6e6e8;\n    padding-left:20px;\n    padding-right:20px;\n    text-align:center;\n    font-weight:bold;\n}\n\n.jdropdown-picker .jdropdown-item\n{\n    font-size: 1em;\n    text-transform: uppercase;\n    padding-top:10px;\n    padding-bottom:10px;\n    border-bottom: 1px solid #e6e6e8;\n    padding-left:20px;\n    padding-right:20px;\n}\n\n.jdropdown-picker .jdropdown-selected\n{\n    background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNMCAwaDI0djI0SDB6IiBmaWxsPSJub25lIiAvPjxwYXRoIGQ9Ik05IDE2LjE3TDQuODMgMTJsLTEuNDIgMS40MUw5IDE5IDIxIDdsLTEuNDEtMS40MXoiIGZpbGw9IndoaXRlIiAvPjwvc3ZnPgo=');\n    background-repeat:no-repeat;\n    background-position:top 50% right 15px;\n    background-color:#1f93ff;\n    color:#fff;\n}\n\n.jdropdown-picker .jdropdown-cursor\n{\n    background-color:#1f93ff;\n    color:#fff;\n}\n\n/** Default render for mobile searchbar **/\n\n.jdropdown-searchbar.jdropdown-focus\n{\n    position:fixed;\n    top:0px;\n    left:0px;\n    width:100%;\n    height:100%;\n    background-color:#fafafa;\n    padding:0px;\n    z-index:9001;\n    overflow-y:scroll;\n}\n\n.jdropdown-searchbar.jdropdown-focus .jdropdown-container-header\n{\n    padding:10px;\n    background-color:#fff;\n    box-shadow: 0 1px 2px rgba(0,0,0,.1);\n}\n\n.jdropdown-searchbar.jdropdown-focus .jdropdown-header\n{\n    border: 0px;\n    background-repeat: no-repeat;\n    background-position-x: 0%;\n    background-position-y: 40%;\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNMTUuNSAxNGgtLjc5bC0uMjgtLjI3QzE1LjQxIDEyLjU5IDE2IDExLjExIDE2IDkuNSAxNiA1LjkxIDEzLjA5IDMgOS41IDNTMyA1LjkxIDMgOS41IDUuOTEgMTYgOS41IDE2YzEuNjEgMCAzLjA5LS41OSA0LjIzLTEuNTdsLjI3LjI4di43OWw1IDQuOTlMMjAuNDkgMTlsLTQuOTktNXptLTYgMEM3LjAxIDE0IDUgMTEuOTkgNSA5LjVTNy4wMSA1IDkuNSA1IDE0IDcuMDEgMTQgOS41IDExLjk5IDE0IDkuNSAxNHoiIGZpbGw9IiNlNmU2ZTgiLz48cGF0aCBkPSJNMCAwaDI0djI0SDB6IiBmaWxsPSJub25lIi8+PC9zdmc+);\n    padding-left: 30px !important;\n    padding-right: 60px !important;\n    outline: none;\n}\n\n.jdropdown-searchbar.jdropdown-focus .jdropdown-close\n{\n    display:block;\n}\n\n.jdropdown-searchbar .jdropdown-container\n{\n    width:100%;\n}\n\n.jdropdown-searchbar .jdropdown-close\n{\n    position:fixed;\n    top:0px;\n    right:0px;\n}\n\n.jdropdown-searchbar .jdropdown-content\n{\n    margin-top:10px;\n}\n\n.jdropdown-searchbar .jdropdown-group\n{\n    margin-top:10px;\n    margin-bottom:15px;\n    background-color:#fff;\n}\n\n.jdropdown-searchbar .jdropdown-group-name\n{\n    border-top: 1px solid #e6e6e8;\n    border-bottom: 1px solid #e6e6e8;\n    padding:10px;\n    padding-left:12px;\n    font-weight:bold;\n}\n\n.jdropdown-searchbar .jdropdown-group-arrow\n{\n    float:right;\n    width:24px;\n    height:24px;\n    background-repeat:no-repeat;\n}\n\n.jdropdown-searchbar .jdropdown-group-arrow-down\n{\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNNy40MSA4LjU5TDEyIDEzLjE3bDQuNTktNC41OEwxOCAxMGwtNiA2LTYtNiAxLjQxLTEuNDF6Ii8+PHBhdGggZmlsbD0ibm9uZSIgZD0iTTAgMGgyNHYyNEgwVjB6Ii8+PC9zdmc+);\n}\n\n.jdropdown-searchbar .jdropdown-group-arrow-up\n{\n    background-image: url(data:image/svg+xml;base64,CjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZD0iTTcuNDEgMTUuNDFMMTIgMTAuODNsNC41OSA0LjU4TDE4IDE0bC02LTYtNiA2eiIvPjxwYXRoIGQ9Ik0wIDBoMjR2MjRIMHoiIGZpbGw9Im5vbmUiLz48L3N2Zz4=);\n}\n\n.jdropdown-searchbar .jdropdown-item\n{\n    padding-top:10px;\n    padding-bottom:10px;\n    border-bottom: 1px solid #e6e6e8;\n    padding-left:15px;\n    padding-right:40px;\n    background-color:#fff;\n    font-size:0.9em;\n}\n\n.jdropdown-searchbar .jdropdown-description {\n    text-overflow: ellipsis;\n    overflow: hidden;\n    max-width: calc(100% - 20px);\n}\n\n.jdropdown-searchbar .jdropdown-content > .jdropdown-item:first-child\n{\n    border-top: 1px solid #e6e6e8;\n}\n\n.jdropdown-searchbar .jdropdown-selected\n{\n    background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNMCAwaDI0djI0SDB6IiBmaWxsPSJub25lIi8+PHBhdGggZD0iTTkgMTYuMTdMNC44MyAxMmwtMS40MiAxLjQxTDkgMTkgMjEgN2wtMS40MS0xLjQxeiIgZmlsbD0iIzAwN2FmZiIvPjwvc3ZnPg==');\n    background-repeat:no-repeat;\n    background-position:top 50% right 15px;\n}\n\n/** List render **/\n\n.jdropdown-list\n{\n}\n\n.jdropdown-list .jdropdown-container\n{\n    display:block;\n}\n\n.jdropdown-list .jdropdown-header\n{\n    display:none;\n}\n\n.jdropdown-list .jdropdown-group\n{\n    background-color:#fff;\n}\n\n.jdropdown-list .jdropdown-group-name\n{\n    border-bottom: 1px solid #e6e6e8;\n    padding-top:10px;\n    padding-bottom:10px;\n    font-weight:bold;\n}\n\n.jdropdown-list .jdropdown-item\n{\n    padding-top:10px;\n    padding-bottom:10px;\n    border-bottom: 1px solid #e6e6e8;\n    padding-left:10px;\n    padding-right:40px;\n    background-color:#fff;\n}\n\n.jdropdown-list .jdropdown-selected\n{\n    background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNMCAwaDI0djI0SDB6IiBmaWxsPSJub25lIi8+PHBhdGggZD0iTTkgMTYuMTdMNC44MyAxMmwtMS40MiAxLjQxTDkgMTkgMjEgN2wtMS40MS0xLjQxeiIgZmlsbD0iIzAwN2FmZiIvPjwvc3ZnPg==');\n    background-repeat:no-repeat;\n    background-position:top 50% right 10px;\n}\n\n@media only screen and (max-device-width : 800px)\n{\n    .jdropdown-list\n    {\n        width:100% !important;\n        border:0px;\n        padding:0px;\n    }\n\n    .jdropdown-list .jdropdown-container\n    {\n        min-width:100%;\n    }\n}\n\n.app .jdropdown-item {\n    text-transform:uppercase;\n}\r\n\r\n/**\r\n * (c) jTools Text Editor\r\n * https://github.com/paulhodel/jtools\r\n *\r\n * @author: Paul Hodel <paul.hodel@gmail.com>\r\n * @description: Inline richtext editor\r\n */\r\n\r\n .jeditor-container {\r\n    border:1px solid #ccc;\r\n}\r\n\r\n.jeditor-dragging {\r\n     border:1px dashed #000;\r\n}\r\n\r\n.jeditor-container.jeditor-padding {\r\n    padding:10px;\r\n}\r\n\r\n.jeditor {\r\n    outline:none;\r\n    word-break: break-word;\r\n\r\n}\r\n\r\n.jeditor-container.jeditor-padding .jeditor {\r\n    min-height:120px;\r\n    margin-bottom:10px;\r\n    padding:10px;\r\n}\r\n\r\n.jeditor-toolbar {\r\n    cursor: pointer;\r\n    display: -webkit-inline-box;\r\n    display: -webkit-inline-flex;\r\n    display: -ms-inline-flexbox;\r\n    display: inline-flex;\r\n    -webkit-align-items: center;\r\n    align-items: center;\r\n    border: none;\r\n    -webkit-border-radius: 2px;\r\n    border-radius: 2px;\r\n    -webkit-box-shadow: 0 4px 5px 0 rgba(0,0,0,0.14), 0 1px 10px 0 rgba(0,0,0,0.12), 0 2px 4px -1px rgba(0,0,0,0.2);\r\n    box-shadow: 0 4px 5px 0 rgba(0,0,0,0.14), 0 1px 10px 0 rgba(0,0,0,0.12), 0 2px 4px -1px rgba(0,0,0,0.2);\r\n    margin: 0px;\r\n    margin-bottom:5px;\r\n    padding: 5px;\r\n    white-space: nowrap;\r\n    border-radius:2px;\r\n}\r\n\r\n.jeditor-toolbar .jeditor-toolbar-group {\r\n    background-color:#f3f3f3;\r\n}\r\n\r\n.jeditor-toolbar div {\r\n    padding:4px;\r\n}\r\n\r\n.jeditor-toolbar div.jeditor-toolbar-button {\r\n    padding-left:20px;\r\n    padding-right:20px;\r\n}\r\n\r\n.jeditor-toolbar div {\r\n    -webkit-user-select: none;  /* Chrome all / Safari all */\r\n    -moz-user-select: none;     /* Firefox all */\r\n    -ms-user-select: none;      /* IE 10+ */\r\n    user-select: none;          /* Likely future */   \r\n}\r\n\r\n.jeditor-toolbar div i {\r\n    display:block;\r\n    font-size:20px;\r\n    width:20px;\r\n    height:20px;\r\n    line-height:20px;\r\n    color:#777;\r\n}\r\n\r\n.jeditor-toolbar select {\r\n    border:0px;\r\n    background-color:transparent;\r\n    padding:0px;\r\n    padding-left:5px;\r\n    padding-right:5px;\r\n    display:block;\r\n    height:32px;\r\n    outline:none;\r\n    border-radius:4px;\r\n    margin:1px;\r\n}\r\n\r\n.jeditor-toolbar .jtoolbar-divisor {\r\n    width: 2px;\r\n    height: 28px;\r\n    padding: 0px;\r\n    margin: 4px;\r\n    background-color: #f2f2f2;\r\n}\r\n\r\n.jeditor-toolbar select option {\r\n    background-color:#fff;\r\n    padding:20px;\r\n}\r\n\r\n.jeditor-toolbar div:hover, .toolbar select:hover {\r\n    background-color:#f2f2f2;\r\n    border-radius:2px;\r\n}\r\n\r\n.jeditor-toolbar div:hover i {\r\n    color:#222;\r\n}\r\n\r\n.jeditor-toolbar div.selected {\r\n    background-color:#cecece;\r\n}\r\n\r\n.jeditor-thumbs {\r\n    display:inline-block;\r\n    margin-right:5px;\r\n}\r\n\r\n.jeditor-thumbs-container {\r\n    margin-top:15px;\r\n}\r\n\r\n.jeditor-thumbs .close {\r\n    position:absolute;\r\n    height:1px;\r\n}\r\n\r\n.jeditor-thumbs .close i {\r\n    color:#fff;\r\n    text-shadow: 0px 0px 2px #000;\r\n    position:relative;\r\n    top:5px;\r\n    left:72px;\r\n}\r\n\r\n.jeditor-thumbs img {\r\n    border:1px solid #eee;\r\n    width:100px;\r\n    height:100px;\r\n}\r\n\r\n.jeditor-users {\r\n    position:absolute;\r\n    border:1px solid #ccc;\r\n    background-color:#fff;\r\n    padding-top:5px;\r\n    padding-bottom:5px;\r\n    max-height:220px;\r\n    overflow-y:scroll;\r\n}\r\n\r\n.jeditor-users > div\r\n{\r\n    display:flex;\r\n    align-items:center;\r\n    min-width:220px;\r\n    padding:10px;\r\n    padding-top:5px;\r\n    padding-bottom:5px;\r\n}\r\n\r\n.jeditor-users > div:hover\r\n{\r\n    background-color:#efefef;\r\n}\r\n\r\n.jeditor-users > div img\r\n{\r\n    width:24px;\r\n    height:24px;\r\n    border-radius:12px;\r\n    margin-right:5px;\r\n}\r\n\r\n/** Snippet **/\r\n\r\n.snippet {\r\n    margin-top:15px;\r\n    cursor:pointer;\r\n    border: 1px solid #eee;\r\n    position:relative;\r\n}\r\n\r\n.snippet:focus {\r\n    outline: none;\r\n}\r\n\r\n.snippet img {\r\n    width:25%;\r\n    max-width:120px;\r\n    float:left;\r\n    margin-right:10px;\r\n    margin-bottom:10px;\r\n}\r\n\r\n.snippet .snippet-title {\r\n    margin-top:15px;\r\n    font-size:1.4em;\r\n}\r\n\r\n.snippet .snippet-description {\r\n    margin-top:5px;\r\n    font-size:1em;\r\n}\r\n\r\n.snippet .snippet-host {\r\n    margin-top:10px;\r\n    margin-bottom:10px;\r\n    text-transform:uppercase;\r\n    font-size:0.8em;\r\n    color:#777;\r\n    text-align:right;\r\n}\r\n\r\n.snippet .snippet-url {\r\n    display:none;\r\n}\r\n\r\n.jeditor .snippet:after {\r\n    content:'';\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath d='M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\r\n    position:absolute;\r\n    top:0;\r\n    right:0;\r\n    margin:14px;\r\n    font-size:24px;\r\n    width:24px;\r\n    height:24px;\r\n    cursor:pointer;\r\n    text-shadow: 0px 0px 5px #fff;\r\n}\r\n\r\n.snippet div, .snippet img {\r\n    -webkit-user-select: none;\r\n    -khtml-user-select: none;\r\n    -moz-user-select: none;\r\n    -o-user-select: none;\r\n    user-select: none;\r\n\r\n    -webkit-user-drag: none;\r\n    -khtml-user-drag: none;\r\n    -moz-user-drag: none;\r\n    -o-user-drag: none;\r\n}\r\n\r\n.jeditor img {\r\n    border:2px solid transparent;\r\n    box-sizing: border-box;\r\n}\r\n\r\n.jeditor img:focus {\r\n    border:2px solid #0096FD;\r\n}\r\n\r\n.jeditor .pdf {\r\n    background-image: url(\"data:image/svg+xml,%3Csvg version='1.1' id='Layer_1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' x='0px' y='0px' viewBox='0 0 512 512' style='enable-background:new 0 0 512 512;' xml:space='preserve'%3E%3Cpath style='fill:%23C30B15;' d='M511.344,274.266C511.77,268.231,512,262.143,512,256C512,114.615,397.385,0,256,0S0,114.615,0,256 c0,117.769,79.53,216.949,187.809,246.801L511.344,274.266z'/%3E%3Cpath style='fill:%2385080E;' d='M511.344,274.266L314.991,77.913L119.096,434.087l68.714,68.714C209.522,508.787,232.385,512,256,512 C391.243,512,501.976,407.125,511.344,274.266z'/%3E%3Cpolygon style='fill:%23FFFFFF;' points='278.328,333.913 255.711,77.913 119.096,77.913 119.096,311.652 '/%3E%3Cpolygon style='fill:%23E8E6E6;' points='392.904,311.652 392.904,155.826 337.252,133.565 314.991,77.913 255.711,77.913 256.067,333.913 '/%3E%3Cpolygon style='fill:%23FFFFFF;' points='314.991,155.826 314.991,77.913 392.904,155.826 '/%3E%3Crect x='119.096' y='311.652' style='fill:%23FC0F1A;' width='273.809' height='122.435'/%3E%3Cg%3E%3Cpath style='fill:%23FFFFFF;' d='M204.871,346.387c13.547,0,21.341,6.659,21.341,18.465c0,12.412-7.795,19.601-21.341,19.601h-9.611 v14.909h-13.471v-52.975L204.871,346.387L204.871,346.387z M195.26,373.858h8.93c5.904,0,9.308-2.952,9.308-8.552 c0-5.525-3.406-8.324-9.308-8.324h-8.93V373.858z'/%3E%3Cpath style='fill:%23FFFFFF;' d='M257.928,346.387c16.649,0,28.152,10.746,28.152,26.487c0,15.666-11.655,26.488-28.683,26.488 h-22.25v-52.975H257.928z M248.619,388.615h9.611c8.249,0,14.151-6.357,14.151-15.665c0-9.384-6.205-15.817-14.757-15.817h-9.006 V388.615z'/%3E%3Cpath style='fill:%23FFFFFF;' d='M308.563,356.982v12.26h23.763v10.596h-23.763v19.525h-13.471v-52.975h39.277v10.595h-25.806 V356.982z'/%3E%3C/g%3E%3C/svg%3E%0A\");\r\n    background-repeat: no-repeat;\r\n    background-size: cover;\r\n    width:60px;\r\n    height:60px;\r\n}\r\n\r\n\r\n\r\n/**\r\n * (c) jLoading\r\n * https://github.com/paulhodel/jtools\r\n *\r\n * @author: Paul Hodel <paul.hodel@gmail.com>\r\n * @description: Page loading spin\r\n */\r\n\r\n.jloading {\r\n    position:fixed;\r\n    z-index:10001;\r\n    width:100%;\r\n    left:0;\r\n    right:0;\r\n    top:0;\r\n    bottom:0;\r\n    background-color: rgba(0,0,0,0.7);\r\n}\r\n\r\n.jloading::after {\r\n    content:'';\r\n    display:block;\r\n    margin:0 auto;\r\n    margin-top:50vh;\r\n    width:40px;\r\n    height:40px;\r\n    border-style:solid;\r\n    border-color:white;\r\n    border-top-color:transparent;\r\n    border-width:4px;\r\n    border-radius:50%;\r\n    -webkit-animation: spin .8s linear infinite;\r\n    animation: spin .8s linear infinite;\r\n}\r\n\r\n.jloading.spin {\r\n    background-color:transparent;\r\n}\r\n\r\n.jloading.spin::after {\r\n    margin:0 auto;\r\n    margin-top:80px;\r\n    border-color:#aaa;\r\n    border-top-color:transparent;\r\n}\r\n\r\n\r\n.jlogin {\r\n    width: 100%;\r\n    box-sizing: border-box;\r\n    margin:0 auto;\r\n    vertical-align:middle;\r\n    border-radius: 5px;\r\n    -webkit-border-radius: 5px;\r\n    -moz-border-radius: 5px;\r\n    font-size:1em;\r\n}\r\n\r\n.jlogin-fullscreen {\r\n    position:absolute;\r\n    top:0px;\r\n    left:0px;\r\n    width:100%;\r\n    height:100%;\r\n    background-color:#fff;\r\n    z-index:9000;\r\n}\r\n\r\n.jlogin > form {\r\n    max-width:480px;\r\n    padding:20px;\r\n    margin: 0 auto;\r\n}\r\n\r\n.jlogin > form > div {\r\n    margin-bottom:10px;\r\n}\r\n\r\n.jlogin label {\r\n    display:block;\r\n}\r\n\r\n.jlogin > form > div > input {\r\n    width:100%;\r\n    outline:none;\r\n    padding:15px;\r\n    margin:0px;\r\n}\r\n\r\n.jlogin input[type='checkbox'] {\r\n    float:left;\r\n}\r\n\r\n.jlogin input[type='button'] {\r\n    padding:10px;\r\n    background-color: var(--button-color);\r\n    border: 1px solid var(--button-color);\r\n    color: #fff;\r\n    cursor:pointer;\r\n    -webkit-appearance: none;\r\n    -moz-appearance: none;\r\n    appearance: none;\r\n}\r\n\r\n.jlogin span\r\n{\r\n    margin:0 auto;\r\n}\r\n.jlogin img\r\n{\r\n    text-align:center;\r\n    max-width:220px;\r\n}\r\n\r\n.jlogin .jlogin-logo\r\n{\r\n    text-align:center;\r\n    padding:20px;\r\n}\r\n\r\n.jlogin .captcha\r\n{\r\n    width:100%;\r\n    margin-top:4px;\r\n    margin-bottom:4px;\r\n    border:1px solid #ccc;\r\n    display:block;\r\n}\r\n\r\n.jlogin .facebookButton\r\n{\r\n    padding:10px;\r\n    background-color: var(--button-color);\r\n    border: 1px solid var(--button-color);\r\n    color: #fff;\r\n    text-align:center;\r\n    background-repeat:no-repeat;\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' width='24px' height='24px'%3E%3Cpath d='M19,3H5C3.895,3,3,3.895,3,5v14c0,1.105,0.895,2,2,2h7.621v-6.961h-2.343v-2.725h2.343V9.309 c0-2.324,1.421-3.591,3.495-3.591c0.699-0.002,1.397,0.034,2.092,0.105v2.43h-1.428c-1.13,0-1.35,0.534-1.35,1.322v1.735h2.7 l-0.351,2.725h-2.365V21H19c1.105,0,2-0.895,2-2V5C21,3.895,20.105,3,19,3z' fill='white'/%3E%3C/svg%3E%0A\");\r\n    background-position:10px 40%;\r\n    cursor:pointer;\r\n}\r\n\r\n.jlogin .rememberButton\r\n{\r\n    padding:10px;\r\n    display:none;\r\n}\r\n\r\n.jlogin .requestButton, .jlogin .cancelButton, .jlogin .newProfileButton\r\n{\r\n    padding:20px;\r\n    padding-bottom:0px;\r\n    text-align:center;\r\n    cursor:pointer;\r\n}\r\n\r\n.jlogin-captcha img {\r\n    min-width:280px;\r\n}\r\n\r\n.jlogin-loading:before {\r\n    content: \"\";\r\n    display: block;\r\n    position: fixed;\r\n    top: 0px;\r\n    left: 0px;\r\n    width: 200px;\r\n    height: 4px;\r\n    background-color: var(--button-color);\r\n    animation: loading 2s linear infinite;\r\n}\r\n\r\n@keyframes loading {\r\n    from { left: -200px; width: 30%; }\r\n    50% { width: 30%; }\r\n    70% { width: 70%; }\r\n    80% { left: 50%; }\r\n    95% { left: 120%; }\r\n    to { left: 100%; }\r\n}\r\n\r\n@media only screen and (max-device-width : 800px)\r\n{\r\n    .jsuites * {\r\n        -webkit-tap-highlight-color: transparent;\r\n        -webkit-touch-callout: none;\r\n    }\r\n\r\n    html.jsuites {\r\n        height:100%;\r\n    }\r\n\r\n    .jsuites body {\r\n        margin:0px;\r\n        padding:0px;\r\n        width:100%;\r\n        height:100%;\r\n        min-height:100%;\r\n        line-height:1.4;\r\n        font-family:-apple-system,SF UI Text,Helvetica Neue,Helvetica,Arial,sans-serif !important;\r\n        background-color:#fff;\r\n    }\r\n\r\n    .jsuites input, .jsuites select, .jsuites textarea, .jsuites div {\r\n        font-family:-apple-system,SF UI Text,Helvetica Neue,Helvetica,Arial,sans-serif !important;\r\n    }\r\n}\r\n\r\n.japp\r\n{\r\n    height:100%;\r\n    box-sizing: border-box;\r\n    overflow:scroll;\r\n    background-color:#fafafa;\r\n}\r\n\r\n.jwarning::before {\r\n    content:'No internet connection';\r\n    background-color:red;\r\n    color:#fff;\r\n    padding:2px;\r\n    position:fixed;\r\n    top:0px;\r\n    left:0px;\r\n    z-index:20000;\r\n    width:100%;\r\n    font-size:0.55em;\r\n    text-align:center;\r\n}\r\n\r\n/*\r\n.japp .activeHighLight\r\n{\r\n    color:var(--active-color);\r\n}\r\n\r\n.japp .active a, .japp .active span, .japp .active i\r\n{\r\n    color:var(--active-color);\r\n}\r\n\r\n.japp .no-padding\r\n{\r\n    padding:0px;\r\n}\r\n\r\n.japp .action\r\n{\r\n    color:var(--active-color);\r\n    cursor:pointer;\r\n}\r\n\r\n\r\n.japp i.action\r\n{\r\n    position:absolute;\r\n    right:0px;\r\n    margin-right:15px;\r\n    cursor:pointer;\r\n}\r\n*/\r\n\r\n.japp button {\r\n    border-radius: 4px;\r\n    width: 100%;\r\n    border: 1px solid var(--active-color);\r\n    color: var(--active-color);\r\n    background-color: transparent;\r\n    padding: 4px;\r\n    outline: none;\r\n}\r\n\r\n.japp button:active {\r\n    border: 1px solid #000;\r\n    color: #000;\r\n}\r\n\r\n.japp .red {\r\n    color: red;\r\n    border-color: 1px solid red;\r\n}\r\n\r\n.japp .link {\r\n    color: var(--active-color);\r\n    cursor: pointer;\r\n}\r\n\r\n.japp .uppercase {\r\n    text-transform: uppercase;\r\n}\r\n\r\n/** Navbar **/\r\n\r\n.japp .navbar {\r\n    position:fixed;\r\n    top: 0;\r\n    width: 100%;\r\n    z-index: 500;\r\n    margin: 0;\r\n    -webkit-backface-visibility: hidden;\r\n    -webkit-transform: translate3d(0,0,0);\r\n    -webkit-box-sizing: border-box;\r\n    backface-visibility: hidden;\r\n    box-sizing: border-box;\r\n    transform: translate3d(0,0,0);\r\n    height: 44px;\r\n    background-color: #fff;\r\n    box-shadow: 0 1px 2px rgba(0,0,0,.1);\r\n}\r\n\r\n.jwarning .navbar {\r\n    top:16px;\r\n}\r\n\r\n.japp .navbar-container {\r\n    padding: 0 8px;\r\n    position: absolute;\r\n    left: 0;\r\n    top: 0;\r\n    width: 100%;\r\n    height: 100%;\r\n    -webkit-box-sizing: border-box;\r\n    box-sizing: border-box;\r\n    vertical-align:middle;\r\n\r\n    display: flex;\r\n\r\n    -webkit-flex-flow: row wrap;\r\n    justify-content: space-between;\r\n    align-items:center;\r\n}\r\n\r\n.japp .navbar-container div {\r\n    text-align:center;\r\n}\r\n\r\n.japp .navbar-container div.title {\r\n    display: flex;\r\n}\r\n\r\n.japp .navbar-container div.title div\r\n{\r\n    line-height:24px;\r\n}\r\n\r\n.japp .navbar-container div.icon {\r\n    width:24px;\r\n}\r\n\r\n.japp .navbar-container div i {\r\n    display:block;\r\n}\r\n\r\n.japp .navbar-container div img {\r\n    height:28px;\r\n    display:block;\r\n}\r\n\r\n.japp .navbar-container div.title div img {\r\n    border-radius:12px;\r\n    width:24px;\r\n    height:24px;\r\n    margin-right:6px;\r\n}\r\n\r\n.japp .navbar .icon {\r\n    color:var(--active-color);\r\n}\r\n\r\n.japp .title {\r\n    font-size:1.2em;\r\n}\r\n\r\n.japp .block {\r\n    padding:15px;\r\n    color: #6d6d72;\r\n    font-size:0.9em;\r\n    box-sizing: border-box;\r\n}\r\n\r\n.japp .block-title {\r\n    text-transform: uppercase;\r\n    color: #6d6d72;\r\n    margin: 25px 15px 10px;\r\n    line-height: 17px;\r\n    position: relative;\r\n    overflow: hidden;\r\n    white-space: nowrap;\r\n    text-overflow: ellipsis;\r\n    line-height: 1;\r\n    font-size:0.9em;\r\n}\r\n\r\n.japp .block-strong {\r\n    background-color:#fff;\r\n    color: #000;\r\n}\r\n\r\n.japp .block-border {\r\n    border-top:1px solid #ddd;\r\n    border-bottom:1px solid #ddd; \r\n}\r\n\r\n.japp .block-footer {\r\n\ttext-transform: uppercase;\r\n    padding:15px;\r\n    color: #6d6d72;\r\n    font-size:0.7em;\r\n}\r\n\r\n.japp .block-collapse {\r\n    max-height:100px;\r\n    overflow-y:hidden;\r\n}\r\n\r\n.japp .block-instruction {\r\n    text-transform: uppercase;\r\n    padding:15px;\r\n    color: #6d6d72;\r\n    font-size:0.7em;\r\n    text-align:center;\r\n}\r\n\r\n.japp .pages {\r\n    display: flex;\r\n    flex-wrap: nowrap;\r\n    align-items: flex-start;\r\n    height: 100%;\r\n}\r\n\r\n.japp .page {\r\n    padding-top: 45px;\r\n    padding-bottom: 45px;\r\n    min-height: 100%;\r\n    min-width: 100%;\r\n    box-sizing: border-box;\r\n    overflow-y: auto;\r\n    /*will-change: scroll-position;\r\n    -webkit-overflow-scrolling: touch;\r\n    -webkit-transform: translateZ(0px);\r\n    -webkit-transform: translate3d(0,0,0);\r\n    -webkit-perspective: 1000;*/\r\n}\r\n\r\n.warning .page {\r\n    padding-top: 60px;\r\n}\r\n\r\n.japp .progressbar-container {\r\n    margin: 15px;\r\n    margin-left: 0px;\r\n    margin-right: 0px;\r\n    margin-top: 5px;\r\n}\r\n\r\n.japp .progressbar {\r\n    width:100%;\r\n    border:1px solid var(--active-color);\r\n    border-radius:1px;\r\n}\r\n\r\n.japp .progressbar-title {\r\n    margin-bottom:2px;\r\n    text-transform:uppercase;\r\n    display:flex;\r\n    justify-content:space-between;\r\n}\r\n\r\n.japp .progressbar div {\r\n    background-color:var(--active-color);\r\n    height:4px;\r\n    width:0%;\r\n}\r\n\r\n.japp .panel {\r\n    position:fixed;\r\n    top: 0;\r\n    left: 0;\r\n    margin: 0;\r\n    width:60vw;\r\n    max-width:220px;\r\n    height:100vh;\r\n    background: #fff;\r\n    z-index: 1003;\r\n    -webkit-box-sizing: border-box;\r\n    box-sizing: border-box;\r\n    box-shadow: 0 -1px 2px rgba(0,0,0,.1);\r\n    padding:4px;\r\n}\r\n\r\n.japp .panel-left {\r\n    -webkit-box-shadow: 0px 2px 15px -5px rgba(0, 0, 0, 0.7);\r\n    box-shadow: 0px 2px 15px -5px rgba(0, 0, 0, 0.7);\r\n}\r\n\r\n.japp .panel a {\r\n    color:var(--active-color);\r\n}\r\n\r\n/** Toolbar **/\r\n\r\n.japp .jtoolbar\r\n{\r\n    position:fixed;\r\n    bottom: 0;\r\n    margin: 0;\r\n    left: 0;\r\n    width: 100%;\r\n    background: #f7f7f8;\r\n    z-index: 500;\r\n    -webkit-box-sizing: border-box;\r\n    box-sizing: border-box;\r\n    box-shadow: 0 -1px 2px rgba(0,0,0,.1);\r\n    padding:4px;\r\n}\r\n\r\n.japp .jtoolbar > div\r\n{\r\n    -webkit-box-sizing: border-box;\r\n    box-sizing: border-box;\r\n    vertical-align:middle;\r\n\r\n    display: -webkit-box;\r\n    display: -moz-box;\r\n    display: -ms-flexbox;\r\n    display: -webkit-flex;\r\n    display: flex;\r\n\r\n    -webkit-flex-flow: row wrap;\r\n    justify-content: space-evenly;\r\n    align-items:center;\r\n    width: 100%;\r\n    cursor:pointer;\r\n}\r\n\r\n.japp .jtoolbar > div > div\r\n{\r\n    text-align:center;\r\n    flex:1;\r\n    margin:auto;\r\n}\r\n\r\n.japp .jtoolbar a\r\n{\r\n    text-decoration:none;\r\n    display:inline-block;\r\n}\r\n\r\n.japp .jtoolbar i\r\n{\r\n    color:#929292;\r\n}\r\n\r\n.japp .jtoolbar span\r\n{\r\n    font-size:0.7em;\r\n    display:block;\r\n    color:#929292;\r\n}\r\n\r\n.japp .jtoolbar .selected a,\r\n.japp .jtoolbar .selected i,\r\n.japp .jtoolbar .selected span\r\n{\r\n    color:var(--active-color);\r\n}\r\n\r\n\r\n/** Options **/\r\n\r\n.japp .options\r\n{\r\n    background-color:#fff;\r\n    border-top:1px solid #e6e6e8;\r\n    border-bottom:1px solid #e6e6e8;\r\n    padding-left:15px;\r\n    margin-top:10px;\r\n}\r\n\r\n.japp .options:empty\r\n{\r\n    display:none;\r\n}\r\n\r\n.japp .options .option\r\n{\r\n    padding-top:10px;\r\n    padding-bottom:10px;\r\n    text-transform:uppercase;\r\n    font-size:1em;\r\n    border-bottom:1px solid #e6e6e8;\r\n    overflow-x:hidden;\r\n\r\n    -webkit-box-sizing: border-box;\r\n    box-sizing: border-box;\r\n    vertical-align:middle;\r\n\r\n    display: -webkit-box;\r\n    display: -moz-box;\r\n    display: -ms-flexbox;\r\n    display: -webkit-flex;\r\n    display: flex;\r\n\r\n    -webkit-flex-flow: row nowrap;\r\n    justify-content: space-between;\r\n    align-items:center;\r\n    flex-wrap:nowrap;\r\n}\r\n\r\n.japp .options .option:last-child\r\n{\r\n    border-bottom:0px;\r\n}\r\n\r\n.japp .options label\r\n{\r\n    width:100%;\r\n}\r\n\r\n.japp .options input[type='text'], .japp .options textarea\r\n{\r\n    outline:none;\r\n    border:1px solid transparent;\r\n    font-size:1em;\r\n    margin:0px;\r\n    padding:0px;\r\n    width:100%;\r\n    box-sizing:border-box;\r\n}\r\n\r\n.japp .options textarea\r\n{\r\n    height:100px;\r\n}\r\n\r\n.japp .options input[type='checkbox'], .japp .options input[type='radio']\r\n{\r\n    visibility: hidden;\r\n}\r\n\r\n.japp .options input[type='checkbox'] ~ i, .japp .options input[type='radio'] ~ i\r\n{\r\n    background-image: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0Ij48cGF0aCBkPSJNMCAwaDI0djI0SDB6IiBmaWxsPSJub25lIi8+PHBhdGggZD0iTTkgMTYuMTdMNC44MyAxMmwtMS40MiAxLjQxTDkgMTkgMjEgN2wtMS40MS0xLjQxeiIgZmlsbD0iIzAwN2FmZiIvPjwvc3ZnPg==');\r\n    background-repeat: no-repeat;\r\n    content:'';\r\n    visibility: hidden;\r\n    margin-right:10px;\r\n    line-height:24px;\r\n    width:24px;\r\n    height:24px;\r\n}\r\n\r\n.japp .options input[type='checkbox']:checked ~ i, .japp .options input[type='radio']:checked  ~ i\r\n{\r\n    visibility: visible;\r\n}\r\n\r\n.japp .options .jdropdown {\r\n    display: block;\r\n}\r\n\r\n.japp .options .jdropdown .jdropdown-header {\r\n    border: 0px;\r\n    border-bottom: 1px solid #e6e6e8;\r\n    padding: 15px;\r\n    text-transform: uppercase;\r\n}\r\n\r\n.japp .options .jdropdown:last-child .jdropdown-header {\r\n    border-bottom: 0px;\r\n}\r\n\r\n.japp .options .jdropdown-searchbar.jdropdown-focus .jdropdown-header {\r\n    border:0px;\r\n    padding: 5px;\r\n} \r\n\r\n.japp .options .icon {\r\n    float:left;\r\n    margin-right:10px;\r\n    max-width:40px;\r\n    max-height:40px;\r\n    border-radius:20px;\r\n    color:#929292;\r\n}\r\n\r\n.japp .options .option .option-actions {\r\n    display:flex;\r\n    transform: translateX(100%);\r\n    width:0px;\r\n}\r\n\r\n.japp .options .option .option-actions > div {\r\n    padding-right:5px;\r\n}\r\n\r\n.japp .options .option .option-actions > div > i {\r\n    width:40px;\r\n    height:40px;\r\n    color:#fff;\r\n    font-size:24px;\r\n    line-height:40px;\r\n    text-align:center;\r\n    border-radius:30px;\r\n    background-color:red;\r\n}\r\n\r\n.japp .options .option .option-actions.small > div > i\r\n{\r\n    color:#000;\r\n    width:24px;\r\n    height:24px;\r\n    font-size:24px;\r\n    line-height:24px;\r\n    border-radius:24px;\r\n    background-color:transparent;\r\n}\r\n\r\n.japp .options .option-title {\r\n    display:block;\r\n    padding-top:10px;\r\n    padding-bottom:10px;\r\n    text-transform:uppercase;\r\n    font-size:1em;\r\n    vertical-align:center;\r\n}\r\n\r\n.japp .options .option-title::after {\r\n    content:'\\e313';\r\n    font-family: 'material icons';\r\n    font-size:24px;\r\n    margin-right:10px;\r\n    float:right;\r\n    width:24px;\r\n    height:24px;\r\n    line-height:24px;\r\n}\r\n\r\n.japp .options .option-title.selected::after\r\n{\r\n    content:'\\e316';\r\n}\r\n\r\n.japp .options .option-title.selected ~ div {\r\n    display:block;\r\n}\r\n\r\n.japp .options .option-group {\r\n    border-top:1px solid #e6e6e8;\r\n    background-color:#fff;\r\n    display:none;\r\n}\r\n\r\n.japp .options .option-link:after {\r\n    content:'\\e315';\r\n    font-family: 'material icons';\r\n    color:var(--active-color);\r\n    font-size:24px;\r\n    margin-right:10px;\r\n    float:right;\r\n    width:24px;\r\n    height:24px;\r\n    line-height:24px;\r\n    display:block;\r\n}\r\n\r\n.japp .options .option-header {\r\n    padding-left:10px;\r\n    padding-right:10px;\r\n    flex-grow:10;\r\n    white-space: nowrap;\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n}\r\n\r\n.japp .options .option .option-name {\r\n    font-size:1em;\r\n    text-overflow: ellipsis;\r\n    width: 100%;\r\n    overflow: hidden;\r\n}\r\n\r\n.japp .options .option .option-small {\r\n    font-size:0.7em;\r\n    color: #6d6d72;\r\n    text-overflow: ellipsis;\r\n    overflow: hidden;\r\n    white-space: nowrap;\r\n    display:block;\r\n}\r\n\r\n.japp .options .option .option-image img {\r\n    width:40px;\r\n    height:40px;\r\n    border-radius:20px;\r\n    display:block;\r\n}\r\n\r\n.japp .options .option .option-image-small img {\r\n    width:24px;\r\n    height:auto;\r\n    border-radius:50px;\r\n    display:block;\r\n}\r\n\r\n.japp .options .option .option-image .option-badge {\r\n    position: absolute;\r\n    background-color: red;\r\n    color: #fff;\r\n    width: 16px;\r\n    height: 16px;\r\n    line-height: 16px;\r\n    border-radius: 16px;\r\n    text-align: center;\r\n    font-size: 7px;\r\n    margin: 28px;\r\n}\r\n\r\n.japp .options .option .option-image-small .option-badge {\r\n    position: absolute;\r\n    background-color: red;\r\n    color: #fff;\r\n    width: 16px;\r\n    height: 16px;\r\n    line-height: 16px;\r\n    border-radius: 16px;\r\n    text-align: center;\r\n    font-size: 7px;\r\n    margin: 12px;\r\n}\r\n\r\n.japp .options .option .option-badge.solid {\r\n    background-color: red;\r\n    color: red;\r\n}\r\n\r\n.japp .options .option .option-badge.solid-green {\r\n    background-color: green;\r\n    color: green;\r\n}\r\n\r\n.japp .options .option .option-badge:empty {\r\n    display:none;\r\n}\r\n\r\n.japp .options .option .option-date {\r\n    float:right;\r\n    font-size:0.6em;\r\n    color:#888;\r\n    margin-right:15px;\r\n    white-space: nowrap;\r\n}\r\n\r\n.japp .options .option .option-right {\r\n    margin-right:15px;\r\n}\r\n\r\n.japp .options .option .option-badget {\r\n    background-color:red;\r\n    border-radius:12px;\r\n    width:24px;\r\n    height:24px;\r\n    line-height:24px;\r\n    font-size:0.7em;\r\n    color:#fff;\r\n    text-align:center;\r\n}\r\n\r\n.japp .options .option .option-badget:empty {\r\n    display:none;\r\n}\r\n\r\n/** Badge **/\r\n\r\n.japp .jbadge\r\n{\r\n    position:relative;\r\n    display:inline-block;\r\n    top:-12px;\r\n    left:-12px;\r\n}\r\n\r\n.japp .jbadge > div\r\n{\r\n    background-color:red;\r\n    color:#fff;\r\n    width:16px;\r\n    height:16px;\r\n    line-height:16px;\r\n    border-radius:16px;\r\n    text-align:center;\r\n    font-size:8px;\r\n    position:absolute;\r\n}\r\n\r\n.japp .jbadge > div:empty\r\n{\r\n    display:none;\r\n}\r\n\r\n/** Picker **/\r\n\r\n.japp .picker \r\n{\r\n    background-color:#fff;\r\n    border-top:1px solid #e6e6e8;\r\n    border-bottom:1px solid #e6e6e8;\r\n    padding-left:15px;\r\n    margin-top:10px;\r\n    position:absolute;\r\n    bottom:0px;\r\n    width:100%;\r\n    z-index:700;\r\n}\r\n\r\n.japp .picker .picker-options\r\n{\r\n    -webkit-mask-image: linear-gradient(to bottom, rgba(0,0,0,1), rgba(0,0,0,.2)), linear-gradient(to top, rgba(0,0,0,1), rgba(0,0,0,.2));\r\n    -webkit-mask-size: 100% 50%;\r\n    -webkit-mask-repeat: no-repeat;\r\n    -webkit-mask-position: center bottom, top center;\r\n    overflow-y:scroll;\r\n    padding-top:100px;\r\n    padding-bottom:100px;\r\n}\r\n\r\n.japp .picker label\r\n{\r\n    display: block;\r\n    padding-top: 10px;\r\n    padding-bottom: 10px;\r\n}\r\n\r\n.japp .picker .picker-selected\r\n{\r\n    border-top:1px solid #e6e6e8;\r\n    border-bottom:1px solid #e6e6e8;\r\n}\r\n\r\n.japp .picker input\r\n{\r\n    display:none;\r\n}\r\n\r\n/** Topsearch **/\r\n\r\n.japp .top-search {\r\n    margin:0px;\r\n    padding:10px;\r\n    border-bottom:1px solid #ddd; \r\n}\r\n\r\n.japp .top-search input {\r\n    background-color: #e6e6e6;\r\n    border: 0px;\r\n    border-radius: 4px;\r\n    outline: none;\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='gray'%3E%3Cpath d='M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\r\n    background-repeat: no-repeat;\r\n    background-position: 5px center;\r\n    padding-left: 32px;\r\n    width: 100%;\r\n}\r\n\r\n.japp .searchbar-container i {\r\n    position:absolute;\r\n    margin-top:5px;\r\n    margin-left:8px;\r\n    color:#bbb;\r\n}\r\n\r\n/** Range **/\r\n\r\n.japp .range\r\n{\r\n  -webkit-appearance: none;\r\n  margin: 18px 0;\r\n  width: 100%;\r\n}\r\n\r\n.japp .range:focus\r\n{\r\n  outline: none;\r\n}\r\n\r\n.japp .range::-webkit-slider-runnable-track\r\n{\r\n    width: 100%;\r\n    height: 4px;\r\n    cursor: pointer;\r\n    animation: 0.2s;\r\n    background: #ccc;\r\n    border-radius: 1.3px;\r\n}\r\n\r\n.japp .range::-webkit-slider-thumb\r\n{\r\n    -webkit-appearance:none;\r\n    appearance:none;\r\n    width:24px;\r\n    height:24px;\r\n    background:#fff;\r\n    cursor:pointer;\r\n    border-radius:24px;\r\n    margin-top:-10px;\r\n    border:0px;\r\n    box-shadow:0px 1px 3px 1px #bbb;\r\n}\r\n\r\n.japp .range::-moz-range-track\r\n{\r\n    width:100%;\r\n    cursor:pointer;\r\n    animation:0.2s;\r\n    background:#ccc;\r\n    border-radius:1.3px;\r\n}\r\n\r\n.japp .range::-moz-range-thumb\r\n{\r\n    width:24px;\r\n    height:24px;\r\n    background:#fff;\r\n    cursor:pointer;\r\n    border-radius:24px;\r\n    border:0px;\r\n    box-shadow:0px 1px 3px 1px #bbb;\r\n}\r\n\r\n.japp .range::-ms-track\r\n{\r\n    width: 100%;\r\n    cursor: pointer;\r\n    animation: 0.2s;\r\n    background: transparent;\r\n    border-color: transparent;\r\n    border-width: 16px 0;\r\n    color: transparent;\r\n    border-radius:1.3px;\r\n}\r\n\r\n.japp .range::-ms-fill-lower\r\n{\r\n    background:#ccc;\r\n    height:5px;\r\n}\r\n\r\n.japp .range::-ms-fill-upper\r\n{\r\n    background:#ccc;\r\n    height:5px;\r\n}\r\n\r\n.japp .range::-ms-thumb {\r\n    width:24px;\r\n    height:24px;\r\n    background:#fff;\r\n    cursor:pointer;\r\n    border-radius:24px;\r\n    border:0px;\r\n    box-shadow:0px 1px 3px 1px #bbb;\r\n}\r\n\r\n.japp .range:focus::-ms-fill-lower\r\n{\r\n  background: #ccc;\r\n}\r\n\r\n.japp .range:focus::-ms-fill-upper\r\n{\r\n  background: #ccc;\r\n}\r\n\r\n\r\n/** Actionsheet **/\r\n\r\n.jactionsheet\r\n{\r\n    position:fixed;\r\n    left: 0;\r\n    bottom: 0;\r\n    width: 100%;\r\n    min-height:100%;\r\n    z-index:10000;\r\n\r\n    background-color:rgba(0,0,0,0.5);\r\n    -webkit-transition-duration: .2s;\r\n    transition-duration: .2s;\r\n    display: flex;\r\n    -ms-flex-align: baseline;\r\n    -webkit-align-items: baseline;\r\n    -webkit-box-align: baseline;\r\n\r\n    align-items: baseline;\r\n}\r\n\r\n.jactionsheet .jactionsheet-content\r\n{\r\n    width:100%;\r\n    align-self: flex-end;\r\n}\r\n\r\n.jactionsheet .jactionsheet-title\r\n{\r\n    font-size:1em;\r\n    font-weight:bold;\r\n    padding:8px;\r\n}\r\n\r\n.jactionsheet .jactionsheet-message\r\n{\r\n    padding:4px;\r\n}\r\n\r\n.jactionsheet .jactionsheet-group\r\n{\r\n    box-sizing: border-box;\r\n    margin:10px;\r\n    background-color:#fff;\r\n    border-radius:5px;\r\n}\r\n\r\n.jactionsheet .jactionsheet-group > div\r\n{\r\n    font-size:1.4em;\r\n    font-weight:bold;\r\n    padding:4px;\r\n    border-top:1px solid #ccc;\r\n    text-align:center;\r\n    width:100%;\r\n}\r\n.jactionsheet .jactionsheet-group > div:first-child\r\n{\r\n    border-top:0px;\r\n}\r\n\r\n.jactionsheet .jactionsheet-group input\r\n{\r\n    border:0px;\r\n    margin:0px;\r\n    background-color:transparent;\r\n    color:var(--active-color);\r\n    width:100%;\r\n    outline:none;\r\n    font-size:1em;\r\n}\r\n\r\n.jactionsheet .jactionsheet-group input.jactionsheet-cancel\r\n{\r\n    color:red;\r\n}\r\n\r\n/** Toggle **/\r\n\r\n.jtoggle {\r\n    display: inline-block;\r\n    cursor: pointer;\r\n    -webkit-tap-highlight-color: transparent;\r\n}\r\n\r\n.jtoggle i {\r\n    position: relative;\r\n    display: inline-block;\r\n    margin-right: .5rem;\r\n    border-radius: 23px;\r\n    vertical-align: text-bottom;\r\n    transition: all 0.3s linear;\r\n    width: 46px !important;\r\n    height: 27px !important;\r\n    background: #e6e6e6 !important;\r\n    visibility: visible !important;\r\n}\r\n\r\n.jtoggle i::before {\r\n  content: \"\";\r\n  position: absolute;\r\n  left: 0;\r\n  width: 42px;\r\n  height: 22px;\r\n  background-color: #fff;\r\n  border-radius: 11px;\r\n  transform: translate3d(2px, 2px, 0) scale3d(1, 1, 1);\r\n  transition: all 0.25s linear;\r\n}\r\n\r\n.jtoggle i::after {\r\n  content: \"\";\r\n  position: absolute;\r\n  left: 0;\r\n  width: 22px;\r\n  height: 22px;\r\n  background-color: #fff;\r\n  border-radius: 11px;\r\n  box-shadow: 0 2px 2px rgba(0, 0, 0, 0.24);\r\n  transform: translate3d(2px, 2px, 0);\r\n  transition: all 0.2s ease-in-out;\r\n}\r\n\r\n.jtoggle:active i::after {\r\n  width: 28px;\r\n  transform: translate3d(2px, 2px, 0);\r\n}\r\n\r\n.jtoggle:active input:checked + i::after {\r\n    transform: translate3d(16px, 2px, 0);\r\n}\r\n\r\n.jtoggle input {\r\n    display: none;\r\n}\r\n\r\n.jtoggle input:checked + i {\r\n    background-color: #4BD763 !important;\r\n}\r\n\r\n.jtoggle input:checked + i::before {\r\n    transform: translate3d(18px, 2px, 0) scale3d(0, 0, 0);\r\n}\r\n\r\n.jtoggle input:checked + i::after {\r\n    transform: translate3d(22px, 2px, 0);\r\n}\r\n\r\n/** Placeholders **/\r\n\r\n.japp .options input::-webkit-input-placeholder\r\n{\r\n    text-transform:uppercase;\r\n}\r\n\r\n.japp .options input::-moz-placeholder\r\n{\r\n    text-transform:uppercase;\r\n}\r\n\r\n.japp .options input:-ms-input-placeholder\r\n{\r\n    text-transform:uppercase;\r\n}\r\n\r\n.japp .options input:-moz-placeholder\r\n{\r\n    text-transform:uppercase;\r\n}\r\n\r\n::placeholder\r\n{\r\n    color: #cccccc;\r\n    opacity: 1;\r\n}\r\n\r\n:-ms-input-placeholder\r\n{\r\n    color: #cccccc;\r\n}\r\n\r\n::-ms-input-placeholder\r\n{\r\n    color: #cccccc;\r\n}\r\n\r\n::-webkit-input-placeholder\r\n{\r\n    color: #cccccc;\r\n}\r\n\r\n\r\n.jmodal {\r\n    position:fixed;\r\n    top:50%;\r\n    left:50%;\r\n    width:60%;\r\n    height:60%;\r\n    -webkit-box-shadow: 0 2px 10px rgba(0,0,0,.2);\r\n    -moz-box-shadow: 0 2px 10px rgba(0,0,0,.2);\r\n    border:1px solid #ccc;\r\n    background-color:#fff;\r\n    transform: translate(-50%, -50%);\r\n    box-sizing: border-box;\r\n    padding-top:50px;\r\n    z-index:9002;\r\n    border-radius:5px;\r\n}\r\n\r\n.jmodal:before {\r\n    position:absolute;\r\n    top:0;\r\n    left:0;\r\n    width:100%;\r\n    content:attr(title);\r\n    padding:15px;\r\n    box-sizing: border-box;\r\n    background: #e3e3e3;\r\n    filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#ededed', endColorstr='#e3e3e3');\r\n    background: -webkit-gradient(linear, left top, left bottom, from(#ededed), to(#e3e3e3));\r\n    background: -moz-linear-gradient(top,  #ededed,  #e3e3e3);\r\n    font-size:1.2em;\r\n}\r\n\r\n.jmodal_content {\r\n    padding:20px;\r\n    overflow-y:auto;\r\n    max-height:100%;\r\n}\r\n.jmodal.no-title {\r\n    padding-top:0px;\r\n}\r\n\r\n.jmodal.no-title:before {\r\n    display:none;\r\n}\r\n\r\n.jmodal:after {\r\n    content:'';\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath d='M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\r\n    position:absolute;\r\n    top:0;\r\n    right:0;\r\n    margin:14px;\r\n    font-size:24px;\r\n    width:24px;\r\n    height:24px;\r\n    cursor:pointer;\r\n    text-shadow: 0px 0px 5px #fff;\r\n}\r\n\r\n.jmodal_fullscreen {\r\n    width: 100% !important;\r\n    height: 100% !important;\r\n    top: 0px;\r\n    left: 0px;\r\n    transform: none;\r\n    border-radius: 0px;\r\n}\r\n\r\n\r\n.jmodal_backdrop {\r\n    position: fixed;\r\n    top: 0px;\r\n    left: 0px;\r\n    min-width: 100%;\r\n    min-height: 100%;\r\n    background-color: rgba(0,0,0,0.5);\r\n    border: 0px;\r\n    padding: 0px;\r\n    z-index: 8000;\r\n    display: none;\r\n\r\n  -webkit-touch-callout: none; /* iOS Safari */\r\n    -webkit-user-select: none; /* Safari */\r\n     -khtml-user-select: none; /* Konqueror HTML */\r\n       -moz-user-select: none; /* Firefox */\r\n        -ms-user-select: none; /* Internet Explorer/Edge */\r\n            user-select: none; /* Non-prefixed version, currently\r\n                                  supported by Chrome and Opera */\r\n}\r\n\r\n\r\n.jnotification {\r\n    position: fixed;\r\n    z-index: 10000;\r\n    -webkit-box-sizing: border-box;\r\n    box-sizing: border-box;\r\n    padding: 10px;\r\n}\r\n\r\n.jnotification-container {\r\n    -webkit-box-shadow: 0px 2px 15px -5px rgba(0, 0, 0, 0.7);\r\n    box-shadow: 0px 2px 15px -5px rgba(0, 0, 0, 0.7);\r\n    padding: 12px;\r\n    border-radius: 8px;\r\n}\r\n\r\n.jnotification-close {\r\n    content: '';\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 24 24' fill='gray'%3E%3Cpath d='M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\r\n    font-size: 20px;\r\n    width: 20px;\r\n    height: 20px;\r\n    cursor: pointer;\r\n}\r\n\r\n.jnotification-title {\r\n    font-weight: bold;\r\n}\r\n\r\n.jnotification-header {\r\n    display: flex;\r\n    padding-bottom: 5px;\r\n}\r\n\r\n.jnotification-header:empty {\r\n    display: none;\r\n}\r\n\r\n.jnotification-image {\r\n    margin-right: 5px;\r\n}\r\n\r\n.jnotification-image:empty {\r\n    display: none;\r\n}\r\n\r\n.jnotification-image img {\r\n    width: 24px;\r\n}\r\n\r\n.jnotification-name {\r\n    text-transform: uppercase;\r\n    font-size: 0.9em;\r\n    flex: 1;\r\n    letter-spacing: 0.1em;\r\n}\r\n\r\n@media (min-width: 320px) and (max-width: 800px) {\r\n    .jnotification {\r\n        top: 0px;\r\n        width: 100%;\r\n    }\r\n    .jnotification-container {\r\n        background: rgba(255,255,255,0.95);\r\n        border: 1px solid #eee;\r\n    }\r\n}\r\n\r\n@media (min-width: 801px) {\r\n    .jnotification {\r\n        bottom: 0px;\r\n    }\r\n    .jnotification-container {\r\n        background-color: #000;\r\n        background: rgba(92,92,92,1);\r\n        background: linear-gradient(0deg, rgba(92,92,92,1) 0%, rgba(77,77,77,1) 100%);\r\n        color: #fff;\r\n        width: 320px;\r\n        margin: 30px;\r\n        padding: 20px;\r\n    }\r\n}\r\n\r\n.jnotification-header {\r\n    display: -webkit-box;\r\n    display: -webkit-flex;\r\n    display: -ms-flexbox;\r\n    display: flex;\r\n    -webkit-box-pack: start;\r\n    -webkit-justify-content: flex-start;\r\n    -ms-flex-pack: start;\r\n    justify-content: flex-start;\r\n    -webkit-box-align: center;\r\n    -webkit-align-items: center;\r\n    -ms-flex-align: center;\r\n    align-items: center;\r\n}\r\n\r\n.jrating {\n    display:flex;\n}\n.jrating > div {\n    width:24px;\n    height:24px;\n    line-height:24px;\n    background-image: url(\"data:image/svg+xml,%0A%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'%3E%3Cpath d='M22 9.24l-7.19-.62L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.63-7.03L22 9.24zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z' fill='gray'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\n}\n\n.jrating .jrating-over {\n    background-image: url(\"data:image/svg+xml,%0A%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='black'%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3Cpath d='M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\n    opacity: 0.7;\n}\n\n.jrating .jrating-selected {\n    background-image: url(\"data:image/svg+xml,%0A%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='red'%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3Cpath d='M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\n}\n\r\n\r\n/**\r\n * (c) Image slider\r\n * https://github.com/paulhodel/jtools\r\n *\r\n * @author: Paul Hodel <paul.hodel@gmail.com>\r\n * @description: Image Slider\r\n */\r\n\r\n.jslider {\r\n    margin-top:10px;\r\n    margin-bottom:10px;\r\n}\r\n\r\n.jslider-container img {\r\n    width:60px;\r\n    margin-right:5px;\r\n    margin-bottom:5px;\r\n}\r\n\r\n.jslider-attach {\r\n    cursor:pointer;\r\n}\r\n\r\n.jslider-left::before {\r\n    position: fixed;\r\n    left: 10px;\r\n    content:'arrow_back_ios';\r\n    color: #fff;\r\n    width: 30px;\r\n    height: 30px;\r\n    font-family: 'Material Icons';\r\n    font-size: 30px;\r\n    text-shadow: 0px 0px 0px #000;\r\n    text-align: center;\r\n}\r\n\r\n.jslider-right::after {\r\n    position: fixed;\r\n    right: 5px;\r\n    content: 'arrow_forward_ios';\r\n    color: #fff;\r\n    width: 30px;\r\n    height: 30px;\r\n    font-family: 'Material Icons';\r\n    font-size: 30px;\r\n    text-shadow: 0px 0px 0px #000;\r\n    text-align: center;\r\n}\r\n\r\n.jslider-close {\r\n    width:24px;\r\n    height:24px;\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='white'%3E%3Cpath d='M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\r\n    position:fixed;\r\n    top:15px;\r\n    right:15px;\r\n    display:none;\r\n    cursor:pointer;\r\n    z-index:3000;\r\n}\r\n\r\n.jslider-preview {\r\n    position:fixed;\r\n    left:0;\r\n    top:0;\r\n    width: 100%;\r\n    min-height:100%;\r\n    z-index:2000;\r\n    margin:0px;\r\n    box-sizing:border-box;\r\n\r\n    background-color:rgba(0,0,0,0.9);\r\n    -webkit-transition-duration: .4s;\r\n    transition-duration: .4s;\r\n    display: flex;\r\n    -ms-flex-align: center;\r\n    -webkit-align-items: center;\r\n    -webkit-box-align: center;\r\n\r\n    align-items: center;\r\n}\r\n\r\n.jslider-preview img {\r\n    min-width:70%;\r\n    max-width:100%;\r\n    height:auto;\r\n    box-sizing: border-box;\r\n    margin:0 auto;\r\n    vertical-align:middle;\r\n    display:none;\r\n}\r\n\r\n\r\n.jtabs {\r\n    max-width: calc(100vw - 24px);\r\n    position: relative;\r\n}\r\n.jtabs > .jtabs-headers {\r\n    display: flex;\r\n    overflow-x: auto;\r\n}\r\n\r\n.jtabs > .jtabs-headers > div {\r\n    padding: 6px;\r\n    padding-left: 20px;\r\n    padding-right: 20px;\r\n    margin-left: 1px;\r\n    margin-right: 1px;\r\n    margin-bottom: 1px;\r\n    background-color: #f1f1f1;\r\n    cursor: pointer;\r\n}\r\n\r\n.jtabs > .jtabs-headers > div.jtabs-selected {\r\n    background-color: #e8e8e8;\r\n    color: #000;\r\n}\r\n\r\n.jtabs > .jtabs-content > div {\r\n    display: none;\r\n}\r\n\r\n.jtabs > .jtabs-content > div.jtabs-selected {\r\n    display: block;\r\n}\r\n\r\n.jtabs > .jtabs-border {\r\n    position: absolute;\r\n    height: 2px;\r\n    background-color: #888;\r\n    transform-origin: left;\r\n    transition: all .2s cubic-bezier(0.4,0,0.2,1);\r\n    transition-property: color,left,transform;\r\n}\r\n\r\n.jtabs .jtabs-add {\r\n    background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' height='24' viewBox='0 0 24 24' width='24'%3E%3Cpath d='M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 10h-4v4h-2v-4H7v-2h4V7h2v4h4v2z' fill='%23bbbbbb'/%3E%3Cpath d='M0 0h24v24H0z' fill='none'/%3E%3C/svg%3E\");\r\n    cursor: pointer;\r\n    background-position: center;\r\n    background-repeat: no-repeat;\r\n    width: 24px;\r\n    height: 24px;\r\n    line-height: 24px;\r\n    margin: 3px;\r\n    margin-left: 10px;\r\n}\r\n\r\n.jtags {\r\n    display: flex;\r\n    flex-wrap: wrap;\r\n    -ms-flex-direction: row;\r\n    -webkit-flex-direction: row;\r\n    flex-direction: row;\r\n    -ms-flex-pack: flex-start;\r\n    -webkit-justify-content: space-between;\r\n    justify-content: flex-start;\r\n    padding: 2px;\r\n    border: 1px solid #ccc;\r\n} \r\n\r\n.jtags > div {\r\n    padding: 3px;\r\n    padding-left: 10px;\r\n    padding-right: 22px;\r\n    position: relative;\r\n    border-radius: 1px;\r\n    margin: 2px;\r\n    display: block;\r\n    outline: none;\r\n}\r\n\r\n.jtags > div::after {\r\n    content: 'x';\r\n    position: absolute;\r\n    top: 4px;\r\n    right: 4px;\r\n    width: 12px;\r\n    height: 12px;\r\n    cursor: pointer;\r\n    font-size: 11px;\r\n    display: none;\r\n}\r\n\r\n.jtags_label {\r\n    background-color: #eeeeee !important;\r\n}\r\n\r\n.jtags_label::after {\r\n    display: inline-block !important;\r\n}\r\n\r\n.jtags_error::after {\r\n    color: #fff  !important;\r\n}\r\n\r\n.jtags_error {\r\n    background-color: #d93025 !important;\r\n    color: #fff;\r\n}\r\n\r\n\r\n.jtags_search {\r\n    position: absolute;\r\n    display: none;\r\n    box-shadow: 0 1px 2px 0 rgba(60,64,67,0.302), 0 2px 6px 2px rgba(60,64,67,0.149);\r\n    border: none;\r\n    -webkit-border-radius: 4px;\r\n    border-radius: 4px;\r\n    width: 280px;\r\n    padding: 8px 0;\r\n\r\n    -webkit-box-shadow: 0 2px 4px rgba(0,0,0,0.2);\r\n    box-shadow: 0 2px 4px rgba(0,0,0,0.2);\r\n    -webkit-transition: opacity .218s;\r\n    transition: opacity .218s;\r\n    background: #fff;\r\n    border: 1px solid rgba(0,0,0,.2);\r\n    cursor: pointer;\r\n    margin: 0;\r\n    min-width: 300px;\r\n    outline: none;\r\n    width: auto;\r\n    user-select: none;\r\n}\r\n\r\n.jtags_search > div {\r\n    color: #333;\r\n    cursor: pointer;\r\n    display: -webkit-box;\r\n    display: -webkit-flex;\r\n    display: flex;\r\n    padding: 5px 10px;\r\n    user-select: none;\r\n    -webkit-align-items: center;\r\n    align-items: center;\r\n}\r\n\r\n.jtags_search > div:hover {\r\n    background-color: #e8eaed;\r\n}\r\n\r\n.jtags_search > div > img {\r\n    width: 32px;\r\n    height: 32px;\r\n    user-select: none;\r\n    border-radius: 16px;\r\n    margin-right: 2px;\r\n}\r\n\r\n.jtags_search > div > div {\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n    margin-left: 2px;\r\n    max-width: 300px;\r\n    white-space: nowrap;\r\n    user-select: none;\r\n}\r\n\r\n.jtags_search .selected {\r\n    background-color: #e8eaed;\r\n}\r\n\r\n\r\n",""]);const i=o},10:function(module,__unused_webpack_exports,__webpack_require__){if(!jSuites){var jSuites=__webpack_require__(551);__webpack_require__(294)}var factory;factory=function(){"use strict";var jexcel=function(el,options){var obj={options:{}};if(!(el instanceof Element||el instanceof HTMLDocument))return console.error("JEXCEL: el is not a valid DOM element"),!1;if("TABLE"==el.tagName){if(!(options=jexcel.createFromTable(el,options)))return console.error("JEXCEL: el is not a valid DOM element"),!1;var div=document.createElement("div");el.parentNode.insertBefore(div,el),el.remove(),el=div}var defaults={url:null,data:null,copyCompatibility:!1,root:null,rows:[],columns:[],colHeaders:[],colWidths:[],colAlignments:[],nestedHeaders:null,defaultColWidth:50,defaultColAlign:"center",minSpareRows:0,minSpareCols:0,minDimensions:[0,0],allowExport:!0,includeHeadersOnDownload:!1,includeHeadersOnCopy:!1,columnSorting:!0,columnDrag:!1,columnResize:!0,rowResize:!1,rowDrag:!0,editable:!0,allowInsertRow:!0,allowManualInsertRow:!0,allowInsertColumn:!0,allowManualInsertColumn:!0,allowDeleteRow:!0,allowDeletingAllRows:!1,allowDeleteColumn:!0,allowRenameColumn:!0,allowComments:!1,wordWrap:!1,imageOptions:null,csv:null,csvFileName:"jexcel",csvHeaders:!0,csvDelimiter:",",parseTableFirstRowAsHeader:!1,parseTableAutoCellType:!1,selectionCopy:!0,mergeCells:{},toolbar:null,search:!1,pagination:!1,paginationOptions:null,fullscreen:!1,lazyLoading:!1,loadingSpin:!1,tableOverflow:!1,tableHeight:"300px",tableWidth:null,meta:null,style:null,parseFormulas:!0,autoIncrement:!0,autoCasting:!0,secureFormulas:!0,stripHTML:!0,filters:!1,footers:null,onundo:null,onredo:null,onload:null,onchange:null,onbeforechange:null,onafterchanges:null,onbeforeinsertrow:null,oninsertrow:null,onbeforeinsertcolumn:null,oninsertcolumn:null,onbeforedeleterow:null,ondeleterow:null,onbeforedeletecolumn:null,ondeletecolumn:null,onmoverow:null,onmovecolumn:null,onresizerow:null,onresizecolumn:null,onsort:null,onselection:null,oncopy:null,onpaste:null,onbeforepaste:null,onmerge:null,onfocus:null,onblur:null,onchangeheader:null,oneditionstart:null,oneditionend:null,onchangestyle:null,onchangemeta:null,onchangepage:null,onbeforesave:null,onsave:null,onevent:null,persistance:!1,updateTable:null,detachForUpdates:!1,freezeColumns:null,text:{noRecordsFound:"No records found",showingPage:"Showing page {0} of {1} entries",show:"Show ",search:"Search",entries:" entries",columnName:"Column name",insertANewColumnBefore:"Insert a new column before",insertANewColumnAfter:"Insert a new column after",deleteSelectedColumns:"Delete selected columns",renameThisColumn:"Rename this column",orderAscending:"Order ascending",orderDescending:"Order descending",insertANewRowBefore:"Insert a new row before",insertANewRowAfter:"Insert a new row after",deleteSelectedRows:"Delete selected rows",editComments:"Edit comments",addComments:"Add comments",comments:"Comments",clearComments:"Clear comments",copy:"Copy...",paste:"Paste...",saveAs:"Save as...",about:"About",areYouSureToDeleteTheSelectedRows:"Are you sure to delete the selected rows?",areYouSureToDeleteTheSelectedColumns:"Are you sure to delete the selected columns?",thisActionWillDestroyAnyExistingMergedCellsAreYouSure:"This action will destroy any existing merged cells. Are you sure?",thisActionWillClearYourSearchResultsAreYouSure:"This action will clear your search results. Are you sure?",thereIsAConflictWithAnotherMergedCell:"There is a conflict with another merged cell",invalidMergeProperties:"Invalid merged properties",cellAlreadyMerged:"Cell already merged",noCellsSelected:"No cells selected"},about:"jExcel CE Spreadsheet\nVersion 4.2.0\nAuthor: Paul Hodel <paul.hodel@gmail.com>\nWebsite: https://bossanova.uk/jexcel/v3"};for(var property in defaults)if(options&&options.hasOwnProperty(property))if("text"===property)for(var textKey in obj.options[property]=defaults[property],options[property])options[property].hasOwnProperty(textKey)&&(obj.options[property][textKey]=options[property][textKey]);else obj.options[property]=options[property];else obj.options[property]=defaults[property];obj.el=el,obj.corner=null,obj.contextMenu=null,obj.textarea=null,obj.ads=null,obj.content=null,obj.table=null,obj.thead=null,obj.tbody=null,obj.rows=[],obj.results=null,obj.searchInput=null,obj.toolbar=null,obj.pagination=null,obj.pageNumber=null,obj.headerContainer=null,obj.colgroupContainer=null,obj.headers=[],obj.records=[],obj.history=[],obj.formula=[],obj.colgroup=[],obj.selection=[],obj.highlighted=[],obj.selectedCell=null,obj.selectedContainer=null,obj.style=[],obj.data=null,obj.filter=null,obj.filters=[],obj.cursor=null,obj.historyIndex=-1,obj.ignoreEvents=!1,obj.ignoreHistory=!1,obj.edition=null,obj.hashString=null,obj.resizing=null,obj.dragging=null,1==obj.options.lazyLoading&&0==obj.options.tableOverflow&&0==obj.options.fullscreen&&(console.error("JEXCEL: The lazyloading only works when tableOverflow = yes or fullscreen = yes"),obj.options.lazyLoading=!1),obj.fullscreen=function(e){null==e&&(e=!obj.options.fullscreen),obj.options.fullscreen!=e&&(obj.options.fullscreen=e,1==e?el.classList.add("fullscreen"):el.classList.remove("fullscreen"))},obj.dispatch=function(e){if(!obj.ignoreEvents){if("function"==typeof obj.options.onevent)var t=obj.options.onevent.apply(this,arguments);"function"==typeof obj.options[e]&&(t=obj.options[e].apply(this,Array.prototype.slice.call(arguments,1)))}if("onafterchanges"==e&&obj.options.persistance){var n=1==obj.options.persistance?obj.options.url:obj.options.persistance,r=obj.prepareJson(arguments[2]);obj.save(n,r)}return t},obj.prepareTable=function(){var e=obj.options.columns.length;if(obj.options.data&&void 0!==obj.options.data[0]){var t=Object.keys(obj.options.data[0]);t.length>e&&(e=t.length)}obj.options.minDimensions[0]>e&&(e=obj.options.minDimensions[0]);for(var n=[],r=0;r<e;r++)obj.options.colHeaders[r]||(obj.options.colHeaders[r]=""),obj.options.colWidths[r]||(obj.options.colWidths[r]=obj.options.defaultColWidth),obj.options.colAlignments[r]||(obj.options.colAlignments[r]=obj.options.defaultColAlign),obj.options.columns[r]?obj.options.columns[r].type||(obj.options.columns[r].type="text"):obj.options.columns[r]={type:"text"},obj.options.columns[r].name||(obj.options.columns[r].name=t&&t[r]?t[r]:r),obj.options.columns[r].source||(obj.options.columns[r].source=[]),obj.options.columns[r].options||(obj.options.columns[r].options=[]),obj.options.columns[r].editor||(obj.options.columns[r].editor=null),obj.options.columns[r].allowEmpty||(obj.options.columns[r].allowEmpty=!1),obj.options.columns[r].title||(obj.options.columns[r].title=obj.options.colHeaders[r]?obj.options.colHeaders[r]:""),obj.options.columns[r].width||(obj.options.columns[r].width=obj.options.colWidths[r]?obj.options.colWidths[r]:obj.options.defaultColWidth),obj.options.columns[r].align||(obj.options.columns[r].align=obj.options.colAlignments[r]?obj.options.colAlignments[r]:"center"),"autocomplete"==obj.options.columns[r].type||"dropdown"==obj.options.columns[r].type?obj.options.columns[r].url&&n.push(jSuites.ajax({url:obj.options.columns[r].url,index:r,method:"GET",dataType:"json",multiple:n,success:function(e){for(var t=0;t<e.length;t++)obj.options.columns[this.index].source.push(e[t])},complete:function(){obj.createTable()}})):"calendar"==obj.options.columns[r].type&&(obj.options.columns[r].options.format||(obj.options.columns[r].options.format="DD/MM/YYYY"));n.length||obj.createTable()},obj.createTable=function(){obj.table=document.createElement("table"),obj.thead=document.createElement("thead"),obj.tbody=document.createElement("tbody"),obj.headers=[],obj.colgroup=[],obj.content=document.createElement("div"),obj.content.classList.add("jexcel_content"),obj.content.onscroll=function(e){obj.scrollControls(e)},obj.content.onwheel=function(e){obj.wheelControls(e)},obj.toolbar=document.createElement("div"),obj.toolbar.classList.add("jexcel_toolbar");var e=document.createElement("div"),t=document.createTextNode(obj.options.text.search+": ");obj.searchInput=document.createElement("input"),obj.searchInput.classList.add("jexcel_search"),e.appendChild(t),e.appendChild(obj.searchInput),obj.searchInput.onfocus=function(){obj.resetSelection()};var n=document.createElement("div");if(obj.options.pagination>0&&obj.options.paginationOptions&&obj.options.paginationOptions.length>0){obj.paginationDropdown=document.createElement("select"),obj.paginationDropdown.classList.add("jexcel_pagination_dropdown"),obj.paginationDropdown.onchange=function(){obj.options.pagination=parseInt(this.value),obj.page(0)};for(var r=0;r<obj.options.paginationOptions.length;r++){var o=document.createElement("option");o.value=obj.options.paginationOptions[r],o.innerHTML=obj.options.paginationOptions[r],obj.paginationDropdown.appendChild(o)}n.appendChild(document.createTextNode(obj.options.text.show)),n.appendChild(obj.paginationDropdown),n.appendChild(document.createTextNode(obj.options.text.entries))}var i,a=document.createElement("div");if(a.classList.add("jexcel_filter"),a.appendChild(n),a.appendChild(e),obj.colgroupContainer=document.createElement("colgroup"),(i=document.createElement("col")).setAttribute("width","50"),obj.colgroupContainer.appendChild(i),obj.options.nestedHeaders&&obj.options.nestedHeaders.length>0)if(obj.options.nestedHeaders[0]&&obj.options.nestedHeaders[0][0])for(var l=0;l<obj.options.nestedHeaders.length;l++)obj.thead.appendChild(obj.createNestedHeader(obj.options.nestedHeaders[l]));else obj.thead.appendChild(obj.createNestedHeader(obj.options.nestedHeaders));for(obj.headerContainer=document.createElement("tr"),(i=document.createElement("td")).classList.add("jexcel_selectall"),obj.headerContainer.appendChild(i),r=0;r<obj.options.columns.length;r++)obj.createCellHeader(r),obj.headerContainer.appendChild(obj.headers[r]),obj.colgroupContainer.appendChild(obj.colgroup[r]);if(obj.thead.appendChild(obj.headerContainer),1==obj.options.filters){obj.filter=document.createElement("tr");var s=document.createElement("td");for(obj.filter.appendChild(s),r=0;r<obj.options.columns.length;r++)(s=document.createElement("td")).innerHTML="&nbsp;",s.setAttribute("data-x",r),s.className="jexcel_column_filter",obj.filter.appendChild(s);obj.thead.appendChild(obj.filter)}obj.table=document.createElement("table"),obj.table.classList.add("jexcel"),obj.table.setAttribute("cellpadding","0"),obj.table.setAttribute("cellspacing","0"),obj.table.setAttribute("unselectable","yes"),obj.table.appendChild(obj.colgroupContainer),obj.table.appendChild(obj.thead),obj.table.appendChild(obj.tbody),obj.corner=document.createElement("div"),obj.corner.className="jexcel_corner",obj.corner.setAttribute("unselectable","on"),obj.corner.setAttribute("onselectstart","return false"),0==obj.options.selectionCopy&&(obj.corner.style.display="none"),obj.textarea=document.createElement("textarea"),obj.textarea.className="jexcel_textarea",obj.textarea.id="jexcel_textarea",obj.textarea.tabIndex="-1",obj.contextMenu=document.createElement("div"),obj.contextMenu.className="jexcel_contextmenu",jSuites.contextmenu(obj.contextMenu,{onclick:function(){obj.contextMenu.contextmenu.close(!1)}});var u=document.createElement("a");if(u.setAttribute("href","https://bossanova.uk/jexcel/"),obj.ads=document.createElement("div"),obj.ads.className="jexcel_about","undefined"!=typeof sessionStorage&&!sessionStorage.getItem("jexcel")){sessionStorage.setItem("jexcel",!0);var g=document.createElement("img");g.src="//bossanova.uk/jexcel/logo.png",u.appendChild(g)}var c=document.createElement("span");c.innerHTML="Jexcel spreadsheet",u.appendChild(c),obj.ads.appendChild(u),document.createElement("div").classList.add("jexcel_table"),obj.pagination=document.createElement("div"),obj.pagination.classList.add("jexcel_pagination");var d=document.createElement("div"),p=document.createElement("div");obj.pagination.appendChild(d),obj.pagination.appendChild(p),obj.options.pagination||(obj.pagination.style.display="none"),1==obj.options.search&&el.appendChild(a),obj.content.appendChild(obj.table),obj.content.appendChild(obj.corner),obj.content.appendChild(obj.textarea),el.appendChild(obj.toolbar),el.appendChild(obj.content),el.appendChild(obj.pagination),el.appendChild(obj.contextMenu),el.appendChild(obj.ads),el.classList.add("jexcel_container"),obj.options.toolbar&&obj.options.toolbar.length&&obj.createToolbar(),1==obj.options.fullscreen?el.classList.add("fullscreen"):1==obj.options.tableOverflow&&(obj.options.tableHeight&&(obj.content.style["overflow-y"]="auto",obj.content.style.maxHeight=obj.options.tableHeight),obj.options.tableWidth&&(obj.content.style["overflow-x"]="auto",obj.content.style.width=obj.options.tableWidth)),1!=obj.options.tableOverflow&&obj.options.toolbar&&el.classList.add("with-toolbar"),1==obj.options.columnDrag&&obj.thead.classList.add("draggable"),1==obj.options.columnResize&&obj.thead.classList.add("resizable"),1==obj.options.rowDrag&&obj.tbody.classList.add("draggable"),1==obj.options.rowResize&&obj.tbody.classList.add("resizable"),obj.setData(),obj.options.style&&obj.setStyle(obj.options.style,null,null,1,1)},obj.refresh=function(){obj.options.url?(1==obj.options.loadingSpin&&jSuites.loading.show(),jSuites.ajax({url:obj.options.url,method:"GET",dataType:"json",success:function(e){obj.options.data=e.data?e.data:e,obj.setData(),1==obj.options.loadingSpin&&jSuites.loading.hide()}})):obj.setData()},obj.setData=function(e){if(e&&("string"==typeof e&&(e=JSON.parse(e)),obj.options.data=e),obj.options.data||(obj.options.data=[]),obj.options.data&&obj.options.data[0]&&!Array.isArray(obj.options.data[0])){e=[];for(var t=0;t<obj.options.data.length;t++){for(var n=[],r=0;r<obj.options.columns.length;r++)n[r]=obj.options.data[t][obj.options.columns[r].name];e.push(n)}obj.options.data=e}t=0,r=0;var o=obj.options.columns.length,i=obj.options.data.length,a=obj.options.minDimensions[0],l=obj.options.minDimensions[1],s=a>o?a:o,u=l>i?l:i;for(t=0;t<u;t++)for(r=0;r<s;r++)null==obj.options.data[t]&&(obj.options.data[t]=[]),null==obj.options.data[t][r]&&(obj.options.data[t][r]="");if(obj.rows=[],obj.results=null,obj.records=[],obj.history=[],obj.historyIndex=-1,obj.tbody.innerHTML="",1==obj.options.lazyLoading){var g=0,c=obj.options.data.length<100?obj.options.data.length:100;obj.options.pagination&&(obj.options.pagination=!1,console.error("JEXCEL: Pagination will be disable due the lazyLoading"))}else obj.options.pagination?(obj.pageNumber||(obj.pageNumber=0),obj.options.pagination,g=obj.options.pagination*obj.pageNumber,c=obj.options.pagination*obj.pageNumber+obj.options.pagination,obj.options.data.length<c&&(c=obj.options.data.length)):(g=0,c=obj.options.data.length);for(t=0;t<obj.options.data.length;t++){var d=obj.createRow(t,obj.options.data[t]);t>=g&&t<c&&obj.tbody.appendChild(d)}if(1==obj.options.lazyLoading||obj.options.pagination&&obj.updatePagination(),obj.options.mergeCells){var p=Object.keys(obj.options.mergeCells);for(r=0;r<p.length;r++){var C=obj.options.mergeCells[p[r]];obj.setMerge(p[r],C[0],C[1],1)}}obj.updateTable(),obj.dispatch("onload",el,obj)},obj.getData=function(e,t){for(var n=[],r=0,o=0,i=1==t||0==obj.options.copyCompatibility,a=obj.options.columns.length,l=obj.options.data.length,s=0;s<l;s++){r=0;for(var u=0;u<a;u++)e&&!obj.records[s][u].classList.contains("highlight")||(n[o]||(n[o]=[]),n[o][r]=i?obj.options.data[s][u]:obj.records[s][u].innerHTML,r++);r>0&&o++}return n},obj.getJson=function(e){for(var t=[],n=obj.options.columns.length,r=obj.options.data.length,o=0;o<r;o++){for(var i=null,a=0;a<n;a++)e&&!obj.records[o][a].classList.contains("highlight")||(null==i&&(i={}),obj.options.columns[a].name||(obj.options.columns[a].name=a),i[obj.options.columns[a].name]=obj.options.data[o][a]);null!=i&&t.push(i)}return t},obj.prepareJson=function(e){for(var t=[],n=0;n<e.length;n++){var r=e[n].x,o=e[n].y,i=obj.options.columns[r].name?obj.options.columns[r].name:r;t[o]||(t[o]={row:o,data:{}}),t[o].data[i]=e[n].newValue}return t.filter((function(e){return null!=e}))},obj.save=function(e,t){var n=obj.dispatch("onbeforesave",el,obj,t);if(console.log(n),n)t=n;else if(!1===n)return!1;jSuites.ajax({url:e,method:"POST",dataType:"json",data:{data:JSON.stringify(t)},success:function(e){obj.dispatch("onsave",el,obj,t)}})},obj.getRowData=function(e){return obj.options.data[e]},obj.setRowData=function(e,t){for(var n=0;n<obj.headers.length;n++){var r=jexcel.getColumnNameFromId([n,e]);null!=t[n]&&obj.setValue(r,t[n])}},obj.getColumnData=function(e){for(var t=[],n=0;n<obj.options.data.length;n++)t.push(obj.options.data[n][e]);return t},obj.setColumnData=function(e,t){for(var n=0;n<obj.rows.length;n++){var r=jexcel.getColumnNameFromId([e,n]);null!=t[n]&&obj.setValue(r,t[n])}},obj.createRow=function(e,t){obj.records[e]||(obj.records[e]=[]),t||(t=obj.options.data[e]),obj.rows[e]=document.createElement("tr"),obj.rows[e].setAttribute("data-y",e),obj.options.rows[e]&&obj.options.rows[e].height&&(obj.rows[e].style.height=obj.options.rows[e].height);var n=document.createElement("td");n.innerHTML=parseInt(e+1),n.setAttribute("data-y",e),n.className="jexcel_row",obj.rows[e].appendChild(n);for(var r=0;r<obj.options.columns.length;r++)obj.records[e][r]=obj.createCell(r,e,t[r]),obj.rows[e].appendChild(obj.records[e][r]);return obj.rows[e]},obj.parseValue=function(e,t,n){if("="==(""+n).substr(0,1)&&1==obj.options.parseFormulas&&(n=obj.executeFormula(n,e,t)),obj.options.columns[e].mask){var r=obj.options.columns[e].decimal||".";n=""+jSuites.mask.run(n,obj.options.columns[e].mask,r)}return n},obj.createCell=function(e,t,n){var r=document.createElement("td");if(r.setAttribute("data-x",e),r.setAttribute("data-y",t),"="==(""+n).substr(0,1)&&1==obj.options.secureFormulas){var o=secureFormula(n);o!=n&&(n=o)}if(obj.options.columns[e].editor)1==obj.options.stripHTML?r.innerText=n:r.innerHTML=n,"function"==typeof obj.options.columns[e].editor.createCell&&(r=obj.options.columns[e].editor.createCell(r));else if("hidden"==obj.options.columns[e].type)r.style.display="none",r.innerText=n;else if("checkbox"==obj.options.columns[e].type||"radio"==obj.options.columns[e].type){var i=document.createElement("input");i.type=obj.options.columns[e].type,i.name="c"+e,i.checked=1==n||1==n||"true"==n,i.onclick=function(){obj.setValue(r,this.checked)},1!=obj.options.columns[e].readOnly&&0!=obj.options.editable||i.setAttribute("disabled","disabled"),r.appendChild(i),obj.options.data[t][e]=i.checked}else if("calendar"==obj.options.columns[e].type){var a=jSuites.calendar.extractDateFromString(n,obj.options.columns[e].options.format);r.innerText=jSuites.calendar.getDateString(a||n,obj.options.columns[e].options.format)}else if("dropdown"==obj.options.columns[e].type||"autocomplete"==obj.options.columns[e].type)r.classList.add("jexcel_dropdown"),r.innerText=obj.getDropDownValue(e,n);else if("color"==obj.options.columns[e].type)if("square"==obj.options.columns[e].render){var l=document.createElement("div");l.className="color",l.style.backgroundColor=n,r.appendChild(l)}else r.style.color=n,r.innerText=n;else if("image"==obj.options.columns[e].type){if(n&&"data:image"==n.substr(0,10)){var s=document.createElement("img");s.src=n,r.appendChild(s)}}else"html"==obj.options.columns[e].type?r.innerHTML=stripScript(obj.parseValue(e,t,n)):1==obj.options.stripHTML?r.innerText=obj.parseValue(e,t,n):r.innerHTML=stripScript(obj.parseValue(e,t,n));1==obj.options.columns[e].readOnly&&(r.className="readonly");var u=obj.options.columns[e].align?obj.options.columns[e].align:"center";return r.style.textAlign=u,0!=obj.options.columns[e].wordWrap&&(1==obj.options.wordWrap||1==obj.options.columns[e].wordWrap||r.innerHTML.length>200)&&(r.style.whiteSpace="pre-wrap"),e>0&&(n||r.innerHTML?obj.records[t][e-1].style.overflow="hidden":e==obj.options.columns.length-1&&(r.style.overflow="hidden")),r},obj.createCellHeader=function(e){var t=obj.options.columns[e].width?obj.options.columns[e].width:obj.options.defaultColWidth,n=obj.options.columns[e].align?obj.options.columns[e].align:obj.options.defaultColAlign;obj.headers[e]=document.createElement("td"),obj.headers[e].innerText=obj.options.columns[e].title?obj.options.columns[e].title:jexcel.getColumnName(e),obj.headers[e].setAttribute("data-x",e),obj.headers[e].style.textAlign=n,obj.options.columns[e].title&&obj.headers[e].setAttribute("title",obj.options.columns[e].title),obj.colgroup[e]=document.createElement("col"),obj.colgroup[e].setAttribute("width",t),"hidden"==obj.options.columns[e].type&&(obj.headers[e].style.display="none",obj.colgroup[e].style.display="none")},obj.updateNestedHeader=function(e,t,n){obj.options.nestedHeaders[t][e].title&&(obj.options.nestedHeaders[t][e].title=n,obj.options.nestedHeaders[t].element.children[e+1].innerText=n)},obj.createNestedHeader=function(e){var t=document.createElement("tr");t.classList.add("jexcel_nested");var n=document.createElement("td");t.appendChild(n),e.element=t;for(var r=0,o=0;o<e.length;o++){e[o].colspan||(e[o].colspan=1),e[o].align||(e[o].align="center"),e[o].title||(e[o].title="");for(var i=e[o].colspan,a=[],l=0;l<i;l++)obj.options.columns[r]&&"hidden"==obj.options.columns[r].type&&i++,a.push(r),r++;(n=document.createElement("td")).setAttribute("data-column",a.join(",")),n.setAttribute("colspan",e[o].colspan),n.setAttribute("align",e[o].align),n.innerText=e[o].title,t.appendChild(n)}return t},obj.createToolbar=function(e){e?obj.options.toolbar=e:e=obj.options.toolbar;for(var t=0;t<e.length;t++)if("i"==e[t].type)(o=document.createElement("i")).classList.add("jexcel_toolbar_item"),o.classList.add("material-icons"),o.setAttribute("data-k",e[t].k),o.setAttribute("data-v",e[t].v),e[t].tooltip&&o.setAttribute("title",e[t].tooltip),e[t].onclick&&(e[t].onclick,1)?o.onclick=e[t].onclick:o.onclick=function(){var e=this.getAttribute("data-k"),t=this.getAttribute("data-v");obj.setStyle(obj.highlighted,e,t)},o.innerText=e[t].content,obj.toolbar.appendChild(o);else if("select"==e[t].type){(o=document.createElement("select")).classList.add("jexcel_toolbar_item"),o.setAttribute("data-k",e[t].k),e[t].tooltip&&o.setAttribute("title",e[t].tooltip),e[t].onchange&&(e[t].onchange,1)?o.onchange=e[t].onchange:o.onchange=function(){var e=this.getAttribute("data-k");obj.setStyle(obj.highlighted,e,this.value)};for(var n=0;n<e[t].v.length;n++){var r=document.createElement("option");r.value=e[t].v[n],r.innerText=e[t].v[n],o.appendChild(r)}obj.toolbar.appendChild(o)}else if("color"==e[t].type){var o;(o=document.createElement("i")).classList.add("jexcel_toolbar_item"),o.classList.add("material-icons"),o.setAttribute("data-k",e[t].k),o.setAttribute("data-v",""),e[t].tooltip&&o.setAttribute("title",e[t].tooltip),obj.toolbar.appendChild(o),o.onclick=function(){this.color.open()},o.innerText=e[t].content,jSuites.color(o,{onchange:function(e,t){var n=e.getAttribute("data-k");obj.setStyle(obj.highlighted,n,t)}})}},obj.setMerge=function(e,t,n,r){var o=!1;if(!e){if(!obj.highlighted.length)return alert(obj.options.text.noCellsSelected),null;var i=parseInt(obj.highlighted[0].getAttribute("data-x")),a=parseInt(obj.highlighted[0].getAttribute("data-y")),l=parseInt(obj.highlighted[obj.highlighted.length-1].getAttribute("data-x")),s=parseInt(obj.highlighted[obj.highlighted.length-1].getAttribute("data-y"));e=jexcel.getColumnNameFromId([i,a]),t=l-i+1,n=s-a+1}var u=jexcel.getIdFromColumnName(e,!0);if(obj.options.mergeCells[e])obj.records[u[1]][u[0]].getAttribute("data-merged")&&(o=obj.options.text.cellAlreadyMerged);else if((!t||t<2)&&(!n||n<2))o=obj.options.text.invalidMergeProperties;else for(var g=u[1];g<u[1]+n;g++)for(var c=u[0];c<u[0]+t;c++)jexcel.getColumnNameFromId([c,g]),obj.records[g][c].getAttribute("data-merged")&&(o=obj.options.text.thereIsAConflictWithAnotherMergedCell);if(o)alert(o);else{t>1?obj.records[u[1]][u[0]].setAttribute("colspan",t):t=1,n>1?obj.records[u[1]][u[0]].setAttribute("rowspan",n):n=1,obj.options.mergeCells[e]=[t,n,[]],obj.records[u[1]][u[0]].setAttribute("data-merged","true"),obj.records[u[1]][u[0]].style.overflow="hidden";for(var d=[],p=u[1];p<u[1]+n;p++)for(var C=u[0];C<u[0]+t;C++)u[0]==C&&u[1]==p||(d.push(obj.options.data[p][C]),obj.updateCell(C,p,"",!0),obj.options.mergeCells[e][2].push(obj.records[p][C]),obj.records[p][C].style.display="none",obj.records[p][C]=obj.records[u[1]][u[0]]);obj.updateSelection(obj.records[u[1]][u[0]]),r||(obj.setHistory({action:"setMerge",column:e,colspan:t,rowspan:n,data:d}),obj.dispatch("onmerge",el,e,t,n))}},obj.getMerge=function(e){var t={};if(e)t=obj.options.mergeCells[e]?[obj.options.mergeCells[e][0],obj.options.mergeCells[e][1]]:null;else if(obj.options.mergeCells){obj.options.mergeCells;for(var n=Object.keys(obj.options.mergeCells),r=0;r<n.length;r++)t[n[r]]=[obj.options.mergeCells[n[r]][0],obj.options.mergeCells[n[r]][1]]}return t},obj.removeMerge=function(e,t,n){if(obj.options.mergeCells[e]){var r=jexcel.getIdFromColumnName(e,!0);obj.records[r[1]][r[0]].removeAttribute("colspan"),obj.records[r[1]][r[0]].removeAttribute("rowspan"),obj.records[r[1]][r[0]].removeAttribute("data-merged");for(var o=obj.options.mergeCells[e],i=0,a=0;a<o[1];a++)for(var l=0;l<o[0];l++)(a>0||l>0)&&(obj.records[r[1]+a][r[0]+l]=o[2][i],obj.records[r[1]+a][r[0]+l].style.display="",t&&t[i]&&obj.updateCell(r[0]+l,r[1]+a,t[i]),i++);obj.updateSelection(obj.records[r[1]][r[0]],obj.records[r[1]+a-1][r[0]+l-1]),n||delete obj.options.mergeCells[e]}},obj.destroyMerged=function(e){if(obj.options.mergeCells){obj.options.mergeCells;for(var t=Object.keys(obj.options.mergeCells),n=0;n<t.length;n++)obj.removeMerge(t[n],null,e)}},obj.isColMerged=function(e,t){var n=[];if(obj.options.mergeCells)for(var r=Object.keys(obj.options.mergeCells),o=0;o<r.length;o++){var i=jexcel.getIdFromColumnName(r[o],!0),a=obj.options.mergeCells[r[o]][0],l=i[0],s=i[0]+(a>1?a-1:0);null==t?l<=e&&s>=e&&n.push(r[o]):t?l<e&&s>=e&&n.push(r[o]):l<=e&&s>e&&n.push(r[o])}return n},obj.isRowMerged=function(e,t){var n=[];if(obj.options.mergeCells)for(var r=Object.keys(obj.options.mergeCells),o=0;o<r.length;o++){var i=jexcel.getIdFromColumnName(r[o],!0),a=obj.options.mergeCells[r[o]][1],l=i[1],s=i[1]+(a>1?a-1:0);null==t?l<=e&&s>=e&&n.push(r[o]):t?l<e&&s>=e&&n.push(r[o]):l<=e&&s>e&&n.push(r[o])}return n},obj.openFilter=function(e){if(obj.options.filters){e=parseInt(e),obj.resetSelection();for(var t=[],n=0;n<obj.options.data.length;n++){var r=obj.options.data[n][e],o=obj.records[n][e].innerHTML;r&&o&&(t[r]=o)}var i=Object.keys(t),a=[];for(n=0;n<i.length;n++)a.push({id:i[n],name:t[i[n]]});var l=document.createElement("div");obj.filter.children[e+1].innerHTML="",obj.filter.children[e+1].appendChild(l),obj.filter.children[e+1].style.paddingLeft="0px",obj.filter.children[e+1].style.paddingRight="20px",obj.filter.children[e+1].style.overflow="initial",jSuites.dropdown(l,{data:a,multiple:!0,autocomplete:!0,opened:!0,value:obj.filters[e]?obj.filters[e]:"",width:"100%",position:1==obj.options.tableOverflow||1==obj.options.fullscreen,onclose:function(t){obj.resetFilters(),obj.filters[e]=t.dropdown.getValue(!0),obj.filter.children[e+1].innerHTML=t.dropdown.getText(),obj.filter.children[e+1].style.paddingLeft="",obj.filter.children[e+1].style.paddingRight="",obj.filter.children[e+1].style.overflow="",obj.closeFilter(e)}})}else console.log("JEXCEL: filters not enabled.")},obj.resetFilters=function(){if(obj.options.filters)for(var e=0;e<obj.filter.children.length;e++)obj.filter.children[e].innerHTML="&nbsp;",obj.filters[e]=null},obj.closeFilter=function(e){if(!e)for(var t=0;t<obj.filter.children.length;t++)obj.filters[t]&&(e=t);var n=function(e,t,n){for(var r=0;r<e.length;r++)if((""+obj.options.data[n][t]).search(e[r])>=0||(""+obj.records[n][t].innerHTML).search(e[r])>=0)return!0;return!1},r=obj.filters[e];obj.results=[];for(var o=0;o<obj.options.data.length;o++)n(r,e,o)&&obj.results.push(o);obj.results.length||(obj.results=null),obj.updateResult()},obj.openEditor=function(e,t,n){var r=e.getAttribute("data-y"),o=e.getAttribute("data-x");obj.dispatch("oneditionstart",el,e,o,r),o>0&&(obj.records[r][o-1].style.overflow="hidden");var i=function(t){var n=e.getBoundingClientRect(),r=document.createElement(t);return r.style.width=n.width+"px",r.style.height=n.height-2+"px",r.style.minHeight=n.height-2+"px",e.classList.add("editor"),e.innerHTML="",e.appendChild(r),r};if(1==e.classList.contains("readonly"));else if(obj.edition=[obj.records[r][o],obj.records[r][o].innerHTML,o,r],obj.options.columns[o].editor)obj.options.columns[o].editor.openEditor(e,el,t,n);else if("hidden"==obj.options.columns[o].type);else if("checkbox"==obj.options.columns[o].type||"radio"==obj.options.columns[o].type){var a=!e.children[0].checked;obj.setValue(e,a),obj.edition=null}else if("dropdown"==obj.options.columns[o].type||"autocomplete"==obj.options.columns[o].type){if(a=obj.options.data[r][o],"function"==typeof obj.options.columns[o].filter)var l=obj.options.columns[o].filter(el,e,o,r,obj.options.columns[o].source);else l=obj.options.columns[o].source;var s=i("div"),u={data:l,multiple:!!obj.options.columns[o].multiple,autocomplete:!(!obj.options.columns[o].autocomplete&&"autocomplete"!=obj.options.columns[o].type),opened:!0,value:obj.options.columns[o].multiple?a.split(";"):a,width:"100%",height:s.style.minHeight,position:1==obj.options.tableOverflow||1==obj.options.fullscreen,onclose:function(){obj.closeEditor(e,!0)}};obj.options.columns[o].options&&obj.options.columns[o].options.type&&(u.type=obj.options.columns[o].options.type),jSuites.dropdown(s,u)}else if("calendar"==obj.options.columns[o].type||"color"==obj.options.columns[o].type)a=obj.options.data[r][o],(s=i("input")).value=a,1!=obj.options.tableOverflow&&1!=obj.options.fullscreen||(obj.options.columns[o].options.position=!0),obj.options.columns[o].options.value=obj.options.data[r][o],obj.options.columns[o].options.opened=!0,obj.options.columns[o].options.onclose=function(t,n){obj.closeEditor(e,!0)},"color"==obj.options.columns[o].type?jSuites.color(s,obj.options.columns[o].options):jSuites.calendar(s,obj.options.columns[o].options),s.focus();else if("html"==obj.options.columns[o].type){a=obj.options.data[r][o],(s=i("div")).style.position="relative",(g=document.createElement("div")).classList.add("jexcel_richtext"),s.appendChild(g),jSuites.editor(g,{focus:!0,value:a});const t=e.getBoundingClientRect(),n=g.getBoundingClientRect();window.innerHeight<t.bottom+n.height?g.style.top=t.top-(n.height+2)+"px":g.style.top=t.top+"px"}else if("image"==obj.options.columns[o].type){var g,c=e.children[0];(s=i("div")).style.position="relative",(g=document.createElement("div")).classList.add("jclose"),c&&c.src&&g.appendChild(c),s.appendChild(g),jSuites.image(g,obj.options.imageOptions);const t=e.getBoundingClientRect(),n=g.getBoundingClientRect();window.innerHeight<t.bottom+n.height?g.style.top=t.top-(n.height+2)+"px":g.style.top=t.top+"px"}else{if(a=1==t?"":obj.options.data[r][o],0==obj.options.columns[o].wordWrap||1!=obj.options.wordWrap&&1!=obj.options.columns[o].wordWrap)s=i("input"),obj.options.columns[o].mask&&s.setAttribute("data-mask",obj.options.columns[o].mask);else s=i("textarea");s.onblur=function(){obj.closeEditor(e,!0)},s.focus(),s.value=a}},obj.closeEditor=function(e,t){var n=parseInt(e.getAttribute("data-x")),r=parseInt(e.getAttribute("data-y"));if(1==t){if(obj.options.columns[n].editor)var o=obj.options.columns[n].editor.closeEditor(e,t);else if("checkbox"==obj.options.columns[n].type||"radio"==obj.options.columns[n].type||"hidden"==obj.options.columns[n].type);else if("dropdown"==obj.options.columns[n].type||"autocomplete"==obj.options.columns[n].type)o=e.children[0].dropdown.close(!0);else if("calendar"==obj.options.columns[n].type)o=e.children[0].calendar.close(!0);else if("color"==obj.options.columns[n].type)o=e.children[0].color.close(!0);else if("html"==obj.options.columns[n].type)o=e.children[0].children[0].editor.getData();else if("image"==obj.options.columns[n].type){var i=e.children[0].children[0].children[0];o=i&&"IMG"==i.tagName?i.src:""}else"numeric"==obj.options.columns[n].type?("="!=(o=e.children[0].value).substr(0,1)&&""==o&&(o=obj.options.columns[n].allowEmpty?"":0),e.children[0].onblur=null):(o=e.children[0].value,e.children[0].onblur=null);obj.options.data[r][n]==o?e.innerHTML=obj.edition[1]:obj.setValue(e,o)}else obj.options.columns[n].editor?obj.options.columns[n].editor.closeEditor(e,t):"dropdown"==obj.options.columns[n].type||"autocomplete"==obj.options.columns[n].type?e.children[0].dropdown.close(!0):"calendar"==obj.options.columns[n].type?e.children[0].calendar.close(!0):"color"==obj.options.columns[n].type?e.children[0].color.close(!0):e.children[0].onblur=null,e.innerHTML=obj.edition&&obj.edition[1]?obj.edition[1]:"";obj.dispatch("oneditionend",el,e,n,r,o,t),e.classList.remove("editor"),obj.edition=null},obj.getCell=function(e){var t=(e=jexcel.getIdFromColumnName(e,!0))[0],n=e[1];return obj.records[n][t]},obj.getCellFromCoords=function(e,t){return obj.records[t][e]},obj.getLabel=function(e){var t=(e=jexcel.getIdFromColumnName(e,!0))[0],n=e[1];return obj.records[n][t].innerHTML},obj.getLabelFromCoords=function(e,t){return obj.records[t][e].innerHTML},obj.getValue=function(e,t){if("object"==typeof e)var n=e.getAttribute("data-x"),r=e.getAttribute("data-y");else n=(e=jexcel.getIdFromColumnName(e,!0))[0],r=e[1];var o=null;return null!=n&&null!=r&&(obj.records[r]&&obj.records[r][n]&&(t||1==obj.options.copyCompatibility)?o=obj.records[r][n].innerHTML:obj.options.data[r]&&"undefined"!=obj.options.data[r][n]&&(o=obj.options.data[r][n])),o},obj.getValueFromCoords=function(e,t,n){var r=null;return null!=e&&null!=t&&(obj.records[t]&&obj.records[t][e]&&n||1==obj.options.copyCompatibility?r=obj.records[t][e].innerHTML:obj.options.data[t]&&"undefined"!=obj.options.data[t][e]&&(r=obj.options.data[t][e])),r},obj.setValue=function(e,t,n){var r=[];if("string"==typeof e){var o=(s=jexcel.getIdFromColumnName(e,!0))[0],i=s[1];r.push(obj.updateCell(o,i,t,n)),obj.updateFormulaChain(o,i,r)}else if(o=null,i=null,e&&e.getAttribute&&(o=e.getAttribute("data-x"),i=e.getAttribute("data-y")),null!=o&&null!=i)r.push(obj.updateCell(o,i,t,n)),obj.updateFormulaChain(o,i,r);else{var a=Object.keys(e);if(a.length>0)for(var l=0;l<a.length;l++){var s;"string"==typeof e[l]?(o=(s=jexcel.getIdFromColumnName(e[l],!0))[0],i=s[1]):null!=e[l].x&&null!=e[l].y?(o=e[l].x,i=e[l].y,null!=e[l].newValue?t=e[l].newValue:null!=e[l].value&&(t=e[l].value)):(o=e[l].getAttribute("data-x"),i=e[l].getAttribute("data-y")),null!=o&&null!=i&&(r.push(obj.updateCell(o,i,t,n)),obj.updateFormulaChain(o,i,r))}}obj.setHistory({action:"setValue",records:r,selection:obj.selectedCell}),obj.updateTable(),obj.onafterchanges(el,r)},obj.setValueFromCoords=function(e,t,n,r){var o=[];o.push(obj.updateCell(e,t,n,r)),obj.updateFormulaChain(e,t,o),obj.setHistory({action:"setValue",records:o,selection:obj.selectedCell}),obj.updateTable(),obj.onafterchanges(el,o)},obj.setCheckRadioValue=function(){for(var e=[],t=Object.keys(obj.highlighted),n=0;n<t.length;n++){var r=obj.highlighted[n].getAttribute("data-x"),o=obj.highlighted[n].getAttribute("data-y");"checkbox"!=obj.options.columns[r].type&&"radio"!=obj.options.columns[r].type||e.push(obj.updateCell(r,o,!obj.options.data[o][r]))}e.length&&(obj.setHistory({action:"setValue",records:e,selection:obj.selectedCell}),obj.onafterchanges(el,e))};var stripScript=function(e){var t=new Option;t.innerHTML=e;var n=null;for(e=t.getElementsByTagName("script");n=e[0];)n.parentNode.removeChild(n);return t.innerHTML};obj.updateCell=function(e,t,n,r){if(1!=obj.records[t][e].classList.contains("readonly")||r){var o;if("="==(""+n).substr(0,1)&&1==obj.options.secureFormulas&&(o=secureFormula(n))!=n&&(n=o),null!=(o=obj.dispatch("onbeforechange",el,obj.records[t][e],e,t,n))&&(n=o),obj.options.columns[e].editor&&"function"==typeof obj.options.columns[e].editor.updateCell&&(n=obj.options.columns[e].editor.updateCell(obj.records[t][e],n,r)),u={x:e,y:t,col:e,row:t,newValue:n,oldValue:obj.options.data[t][e]},obj.options.columns[e].editor)obj.options.data[t][e]=n;else if("checkbox"==obj.options.columns[e].type||"radio"==obj.options.columns[e].type){if("radio"==obj.options.columns[e].type)for(var i=0;i<obj.options.data.length;i++)obj.options.data[i][e]=!1;obj.records[t][e].children[0].checked=1==n||1==n||"true"==n||"TRUE"==n,obj.options.data[t][e]=obj.records[t][e].children[0].checked}else if("dropdown"==obj.options.columns[e].type||"autocomplete"==obj.options.columns[e].type)obj.options.data[t][e]=n,obj.records[t][e].innerText=obj.getDropDownValue(e,n);else if("calendar"==obj.options.columns[e].type){var a=jSuites.calendar.extractDateFromString(n,obj.options.columns[e].options.format);obj.options.data[t][e]=n,obj.records[t][e].innerText=jSuites.calendar.getDateString(a||n,obj.options.columns[e].options.format)}else if("color"==obj.options.columns[e].type)if(obj.options.data[t][e]=n,"square"==obj.options.columns[e].render){var l=document.createElement("div");l.className="color",l.style.backgroundColor=n,obj.records[t][e].innerText="",obj.records[t][e].appendChild(l)}else obj.records[t][e].style.color=n,obj.records[t][e].innerText=n;else if("image"==obj.options.columns[e].type){if(n=""+n,obj.options.data[t][e]=n,obj.records[t][e].innerHTML="",n&&"data:image"==n.substr(0,10)){var s=document.createElement("img");s.src=n,obj.records[t][e].appendChild(s)}}else obj.options.data[t][e]=n,"html"==obj.options.columns[e].type?obj.records[t][e].innerHTML=stripScript(obj.parseValue(e,t,n)):1==obj.options.stripHTML?obj.records[t][e].innerText=obj.parseValue(e,t,n):obj.records[t][e].innerHTML=stripScript(obj.parseValue(e,t,n)),0!=obj.options.columns[e].wordWrap&&(1==obj.options.wordWrap||1==obj.options.columns[e].wordWrap||obj.records[t][e].innerHTML.length>200)?obj.records[t][e].style.whiteSpace="pre-wrap":obj.records[t][e].style.whiteSpace="";e>0&&(obj.records[t][e-1].style.overflow=n?"hidden":""),obj.dispatch("onchange",el,obj.records[t]&&obj.records[t][e]?obj.records[t][e]:null,e,t,n,u.oldValue)}else var u={x:e,y:t,col:e,row:t};return u},obj.copyData=function(e,t){var n=obj.getData(!0,!0),r=obj.selectedContainer,o=parseInt(e.getAttribute("data-x")),i=parseInt(e.getAttribute("data-y")),a=parseInt(t.getAttribute("data-x")),l=parseInt(t.getAttribute("data-y")),s=[],u=!1;if(r[0]==o){if(i<r[1])var g=i-r[1];else g=1;var c=0}else c=o<r[0]?o-r[0]:1,g=0;for(var d=0,p=0,C=i;C<=l;C++)if(!obj.rows[C]||"none"!=obj.rows[C].style.display){null==n[p]&&(p=0),d=0,r[0]!=o&&(c=o<r[0]?o-r[0]:1);for(var A=o;A<=a;A++){if(obj.records[C][A]&&!obj.records[C][A].classList.contains("readonly")&&"none"!=obj.records[C][A].style.display&&0==u){if(!obj.selection.length&&""!=obj.options.data[C][A]){u=!0;continue}(null==n[p]||null==n[p][d])&&(d=0);var I=n[p][d];if(I&&!n[1]&&1==obj.options.autoIncrement)if("text"==obj.options.columns[A].type||"number"==obj.options.columns[A].type)if("="==(""+I).substr(0,1)){var b=I.match(/([A-Z]+[0-9]+)/g);if(b){for(var f=[],h=0;h<b.length;h++){var m=jexcel.getIdFromColumnName(b[h],1);m[0]+=c,m[1]+=g,m[1]<0&&(m[1]=0);var j=jexcel.getColumnNameFromId([m[0],m[1]]);j!=b[h]&&(f[b[h]]=j)}f&&(I=obj.updateFormula(I,f))}}else I==Number(I)&&(I=Number(I)+g);else if("calendar"==obj.options.columns[A].type){var v=new Date(I);v.setDate(v.getDate()+g),I=v.getFullYear()+"-"+jexcel.doubleDigitFormat(parseInt(v.getMonth()+1))+"-"+jexcel.doubleDigitFormat(v.getDate())+" 00:00:00"}s.push(obj.updateCell(A,C,I)),obj.updateFormulaChain(A,C,s)}d++,r[0]!=o&&c++}p++,g++}obj.setHistory({action:"setValue",records:s,selection:obj.selectedCell}),obj.updateTable(),obj.onafterchanges(el,s)},obj.refreshSelection=function(){obj.selectedCell&&obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3])},obj.conditionalSelectionUpdate=function(e,t,n){if(1==e){if(obj.selectedCell&&(t>=obj.selectedCell[1]&&t<=obj.selectedCell[3]||n>=obj.selectedCell[1]&&n<=obj.selectedCell[3]))return void obj.resetSelection()}else if(obj.selectedCell&&(t>=obj.selectedCell[0]&&t<=obj.selectedCell[2]||n>=obj.selectedCell[0]&&n<=obj.selectedCell[2]))return void obj.resetSelection()},obj.resetSelection=function(e){if(obj.highlighted.length){u=1;for(var t=0;t<obj.highlighted.length;t++){obj.highlighted[t].classList.remove("highlight"),obj.highlighted[t].classList.remove("highlight-left"),obj.highlighted[t].classList.remove("highlight-right"),obj.highlighted[t].classList.remove("highlight-top"),obj.highlighted[t].classList.remove("highlight-bottom"),obj.highlighted[t].classList.remove("highlight-selected");var n=parseInt(obj.highlighted[t].getAttribute("data-x")),r=parseInt(obj.highlighted[t].getAttribute("data-y"));if(obj.highlighted[t].getAttribute("data-merged"))var o=parseInt(obj.highlighted[t].getAttribute("colspan")),i=parseInt(obj.highlighted[t].getAttribute("rowspan")),a=o>0?n+(o-1):n,l=i>0?r+(i-1):r;else a=n,l=r;for(var s=n;s<=a;s++)obj.headers[s]&&obj.headers[s].classList.remove("selected");for(s=r;s<=l;s++)obj.rows[s]&&obj.rows[s].classList.remove("selected")}}else var u=0;return obj.highlighted=[],obj.selectedCell=null,obj.corner.style.top="-2000px",obj.corner.style.left="-2000px",1==e&&1==u&&obj.dispatch("onblur",el),u},obj.updateSelection=function(e,t,n){var r=e.getAttribute("data-x"),o=e.getAttribute("data-y");if(t)var i=t.getAttribute("data-x"),a=t.getAttribute("data-y");else i=r,a=o;obj.updateSelectionFromCoords(r,o,i,a,n)},obj.updateSelectionFromCoords=function(e,t,n,r,o){var i=obj.resetSelection();if(null==n&&(n=e),null==r&&(r=t),e>=obj.headers.length&&(e=obj.headers.length-1),t>=obj.rows.length&&(t=obj.rows.length-1),n>=obj.headers.length&&(n=obj.headers.length-1),r>=obj.rows.length&&(r=obj.rows.length-1),obj.selectedCell=[e,t,n,r],null!=e){if(obj.records[t][e]&&obj.records[t][e].classList.add("highlight-selected"),parseInt(e)<parseInt(n))var a=parseInt(e),l=parseInt(n);else a=parseInt(n),l=parseInt(e);if(parseInt(t)<parseInt(r))var s=parseInt(t),u=parseInt(r);else s=parseInt(r),u=parseInt(t);for(var g=a;g<=l;g++)for(var c=s;c<=u;c++)if(obj.records[c][g]&&obj.records[c][g].getAttribute("data-merged")){var d=parseInt(obj.records[c][g].getAttribute("data-x")),p=parseInt(obj.records[c][g].getAttribute("data-y")),C=parseInt(obj.records[c][g].getAttribute("colspan")),A=parseInt(obj.records[c][g].getAttribute("rowspan"));C>1&&(d<a&&(a=d),d+C>l&&(l=d+C-1)),A&&(p<s&&(s=p),p+A>u&&(u=p+A-1))}var I=null,b=null,f=null,h=null;for(c=s;c<=u;c++)"none"!=obj.rows[c].style.display&&(null==f&&(f=c),h=c);for(g=a;g<=l;g++){for(c=s;c<=u;c++)"none"!=obj.rows[c].style.display&&"none"!=obj.records[c][g].style.display&&(obj.records[c][g].classList.add("highlight"),obj.highlighted.push(obj.records[c][g]));"hidden"!=obj.options.columns[g].type&&(null==I&&(I=g),b=g)}for(I||(I=0),b||(b=0),g=I;g<=b;g++)"hidden"!=obj.options.columns[g].type&&(obj.records[f][g]&&obj.records[f][g].classList.add("highlight-top"),obj.records[h][g]&&obj.records[h][g].classList.add("highlight-bottom"),obj.headers[g].classList.add("selected"));for(c=f;c<=h;c++)"none"!=obj.rows[c].style.display&&(obj.records[c][I].classList.add("highlight-left"),obj.records[c][b].classList.add("highlight-right"),obj.rows[c].classList.add("selected"));obj.selectedContainer=[I,f,b,h]}0==i&&(obj.dispatch("onfocus",el),obj.removeCopyingSelection()),obj.dispatch("onselection",el,I,f,b,h,o),obj.updateCornerPosition()},obj.removeCopySelection=function(){for(var e=0;e<obj.selection.length;e++)obj.selection[e].classList.remove("selection"),obj.selection[e].classList.remove("selection-left"),obj.selection[e].classList.remove("selection-right"),obj.selection[e].classList.remove("selection-top"),obj.selection[e].classList.remove("selection-bottom");obj.selection=[]},obj.updateCopySelection=function(e,t){obj.removeCopySelection();var n=obj.selectedContainer[0],r=obj.selectedContainer[1],o=obj.selectedContainer[2],i=obj.selectedContainer[3];if(null!=e&&null!=t){if(e-o>0)var a=parseInt(o)+1,l=parseInt(e);else a=parseInt(e),l=parseInt(n)-1;if(t-i>0)var s=parseInt(i)+1,u=parseInt(t);else s=parseInt(t),u=parseInt(r)-1;l-a<=u-s?(a=parseInt(n),l=parseInt(o)):(s=parseInt(r),u=parseInt(i));for(var g=s;g<=u;g++)for(var c=a;c<=l;c++)obj.records[g][c]&&"none"!=obj.rows[g].style.display&&"none"!=obj.records[g][c].style.display&&(obj.records[g][c].classList.add("selection"),obj.records[s][c].classList.add("selection-top"),obj.records[u][c].classList.add("selection-bottom"),obj.records[g][a].classList.add("selection-left"),obj.records[g][l].classList.add("selection-right"),obj.selection.push(obj.records[g][c]))}},obj.updateCornerPosition=function(){if(obj.highlighted.length){var e=obj.highlighted[obj.highlighted.length-1];const g=obj.content.getBoundingClientRect();var t=g.left,n=g.top;const c=e.getBoundingClientRect();var r=c.left,o=c.top,i=c.width,a=c.height,l=r-t+obj.content.scrollLeft+i-4,s=o-n+obj.content.scrollTop+a-4;if(obj.corner.style.top=s+"px",obj.corner.style.left=l+"px",obj.options.freezeColumns){var u=obj.getFreezeWidth();obj.corner.style.display=r-t+i<u?"none":""}else obj.corner.style.display=""}else obj.corner.style.top="-2000px",obj.corner.style.left="-2000px"},obj.updateScroll=function(e){const t=obj.content.getBoundingClientRect();var n=t.left,r=t.top,o=t.width,i=t.height;const a=obj.records[obj.selectedCell[3]][obj.selectedCell[2]].getBoundingClientRect();var l=a.left,s=a.top,u=a.width,g=a.height;if(0==e||1==e)var c=l-n+obj.content.scrollLeft,d=s-r+obj.content.scrollTop-2;else c=l-n+obj.content.scrollLeft+u,d=s-r+obj.content.scrollTop+g;d>obj.content.scrollTop+30&&d<obj.content.scrollTop+i||(d<obj.content.scrollTop+30?obj.content.scrollTop=d-g:obj.content.scrollTop=d-(i-2));var p=obj.getFreezeWidth();c>obj.content.scrollLeft+p&&c<obj.content.scrollLeft+o||(c<obj.content.scrollLeft+30?(obj.content.scrollLeft=c,obj.content.scrollLeft<50&&(obj.content.scrollLeft=0)):c<obj.content.scrollLeft+p?obj.content.scrollLeft=c-p-1:obj.content.scrollLeft=c-(o-20))},obj.getWidth=function(e){if(e)"object"==typeof e&&(e=$(e).getAttribute("data-x")),t=obj.colgroup[e].getAttribute("width");else for(var t=[],n=0;n<obj.headers.length;n++)t.push(obj.options.columns[n].width);return t},obj.setWidth=function(e,t,n){if(t){if(Array.isArray(e)){n||(n=[]);for(var r=0;r<e.length;r++){n[r]||(n[r]=obj.colgroup[e[r]].getAttribute("width"));var o=Array.isArray(t)&&t[r]?t[r]:t;obj.colgroup[e[r]].setAttribute("width",o),obj.options.columns[e[r]].width=o}}else n||(n=obj.colgroup[e].getAttribute("width")),obj.colgroup[e].setAttribute("width",t),obj.options.columns[e].width=t;obj.setHistory({action:"setWidth",column:e,oldValue:n,newValue:t}),obj.dispatch("onresizecolumn",el,e,t,n),obj.updateCornerPosition()}},obj.setHeight=function(e,t,n){t>0&&("object"==typeof e&&(e=e.getAttribute("data-y")),n||(n=obj.rows[e].getAttribute("height"))||(n=obj.rows[e].getBoundingClientRect().height),t=parseInt(t),obj.rows[e].style.height=t+"px",obj.options.rows[e]||(obj.options.rows[e]={}),obj.options.rows[e].height=t,obj.setHistory({action:"setHeight",row:e,oldValue:n,newValue:t}),obj.dispatch("onresizerow",el,e,t,n),obj.updateCornerPosition())},obj.getHeight=function(e){if(e)"object"==typeof e&&(e=$(e).getAttribute("data-y")),t=obj.rows[e].style.height;else for(var t=[],n=0;n<obj.rows.length;n++){var r=obj.rows[n].style.height;r&&(t[n]=r)}return t},obj.setFooter=function(e){if(e&&(obj.options.footers=e),obj.options.footers){obj.tfoot||(obj.tfoot=document.createElement("tfoot"),obj.table.appendChild(obj.tfoot));for(var t=0;t<obj.options.footers.length;t++){if(obj.tfoot.children[t])var n=obj.tfoot.children[t];else{n=document.createElement("tr");var r=document.createElement("td");n.appendChild(r),obj.tfoot.appendChild(n)}for(var o=0;o<obj.headers.length;o++){if(obj.options.footers[t][o]||(obj.options.footers[t][o]=""),obj.tfoot.children[t].children[o+1])r=obj.tfoot.children[t].children[o+1];else{r=document.createElement("td"),n.appendChild(r);var i=obj.options.columns[o].align?obj.options.columns[o].align:"center";r.style.textAlign=i}r.innerText=obj.parseValue(o,t,obj.options.footers[t][o])}}}},obj.getHeader=function(e){return obj.headers[e].innerText},obj.setHeader=function(e,t){if(obj.headers[e]){var n=obj.headers[e].innerText;t||(t=prompt(obj.options.text.columnName,n)),t&&(obj.headers[e].innerText=t,obj.headers[e].setAttribute("title",t),obj.options.columns[e].title=t),obj.setHistory({action:"setHeader",column:e,oldValue:n,newValue:t}),obj.dispatch("onchangeheader",el,e,n,t)}},obj.getHeaders=function(e){for(var t=[],n=0;n<obj.headers.length;n++)t.push(obj.getHeader(n));return e?t:t.join(obj.options.csvDelimiter)},obj.getMeta=function(e,t){return e?t?obj.options.meta[e]&&obj.options.meta[e][t]?obj.options.meta[e][t]:null:obj.options.meta[e]?obj.options.meta[e]:null:obj.options.meta},obj.setMeta=function(e,t,n){if(obj.options.meta||(obj.options.meta={}),t&&n)obj.options.meta[e]||(obj.options.meta[e]={}),obj.options.meta[e][t]=n;else for(var r=Object.keys(e),o=0;o<r.length;o++){obj.options.meta[r[o]]||(obj.options.meta[r[o]]={});for(var i=Object.keys(e[r[o]]),a=0;a<i.length;a++)obj.options.meta[r[o]][i[a]]=e[r[o]][i[a]]}obj.dispatch("onchangemeta",el,e,t,n)},obj.updateMeta=function(e){if(obj.options.meta){for(var t={},n=Object.keys(obj.options.meta),r=0;r<n.length;r++)e[n[r]]?t[e[n[r]]]=obj.options.meta[n[r]]:t[n[r]]=obj.options.meta[n[r]];obj.options.meta=t}},obj.getStyle=function(e,t){if(e)return e=jexcel.getIdFromColumnName(e,!0),t?obj.records[e[1]][e[0]].style[t]:obj.records[e[1]][e[0]].getAttribute("style");for(var n={},r=obj.options.data[0].length,o=obj.options.data.length,i=0;i<o;i++)for(var a=0;a<r;a++){var l=t?obj.records[i][a].style[t]:obj.records[i][a].getAttribute("style");l&&(n[jexcel.getColumnNameFromId([a,i])]=l)}return n},obj.resetStyle=function(e,t){for(var n=Object.keys(e),r=0;r<n.length;r++){var o=jexcel.getIdFromColumnName(n[r],!0);obj.records[o[1]]&&obj.records[o[1]][o[0]]&&obj.records[o[1]][o[0]].setAttribute("style","")}obj.setStyle(e,null,null,null,t)},obj.setStyle=function(e,t,n,r,o){var i={},a={},l=function(e,t,n){var o=jexcel.getIdFromColumnName(e,!0);if(obj.records[o[1]]&&obj.records[o[1]][o[0]]){var l=obj.records[o[1]][o[0]].style[t];l!=n||r?obj.records[o[1]][o[0]].style[t]=n:(n="",obj.records[o[1]][o[0]].style[t]=""),a[e]||(a[e]=[]),i[e]||(i[e]=[]),a[e].push([t+":"+l]),i[e].push([t+":"+n])}};if(t&&n)if("string"==typeof e)l(e,t,n);else for(var s=[],u=0;u<e.length;u++){var g=e[u].getAttribute("data-x"),c=e[u].getAttribute("data-y"),d=jexcel.getColumnNameFromId([g,c]);s[d]||(l(d,t,n),s[d]=!0)}else{var p=Object.keys(e);for(u=0;u<p.length;u++){var C=e[p[u]];"string"==typeof C&&(C=C.split(";"));for(var A=0;A<C.length;A++)"string"==typeof C[A]&&(C[A]=C[A].split(":")),C[A][0].trim()&&l(p[u],C[A][0].trim(),C[A][1])}}for(p=Object.keys(a),u=0;u<p.length;u++)a[p[u]]=a[p[u]].join(";");for(p=Object.keys(i),u=0;u<p.length;u++)i[p[u]]=i[p[u]].join(";");o||obj.setHistory({action:"setStyle",oldValue:a,newValue:i}),obj.dispatch("onchangestyle",el,e,t,n)},obj.getComments=function(e,t){if(e)return"string"==typeof e&&(e=jexcel.getIdFromColumnName(e,!0)),t?[obj.records[e[1]][e[0]].getAttribute("title"),obj.records[e[1]][e[0]].getAttribute("author")]:obj.records[e[1]][e[0]].getAttribute("title")||"";for(var n={},r=0;r<obj.options.data.length;r++)for(var o=0;o<obj.options.columns.length;o++){var i=obj.records[r][o].getAttribute("title");i&&(n[e=jexcel.getColumnNameFromId([o,r])]=i)}return n},obj.setComments=function(e,t,n){if("string"==typeof e)var r=jexcel.getIdFromColumnName(e,!0);else r=e;var o=[obj.records[r[1]][r[0]].getAttribute("title"),n=obj.records[r[1]][r[0]].getAttribute("data-author")];obj.records[r[1]][r[0]].setAttribute("title",t||""),obj.records[r[1]][r[0]].setAttribute("data-author",n||""),t?obj.records[r[1]][r[0]].classList.add("jexcel_comments"):obj.records[r[1]][r[0]].classList.remove("jexcel_comments"),obj.setHistory({action:"setComments",column:e,newValue:[t,n],oldValue:o})},obj.getConfig=function(){var e=obj.options;return e.style=obj.getStyle(),e.mergeCells=obj.getMerge(),e.comments=obj.getComments(),e},obj.orderBy=function(e,t){if(e>=0){if(Object.keys(obj.options.mergeCells).length>0){if(!confirm(obj.options.text.thisActionWillDestroyAnyExistingMergedCellsAreYouSure))return!1;obj.destroyMerged()}t=null==t?obj.headers[e].classList.contains("arrow-down")?1:0:t?1:0,Array.prototype.orderBy=function(e,t){return this.slice(0).sort((function(n,r){var o=n[e],i=r[e];return t?""==o&&""!=i?1:""!=o&&""==i||o>i?-1:o<i?1:0:""==o&&""!=i?1:""!=o&&""==i?-1:o>i?1:o<i?-1:0}))};var n=[];if("number"==obj.options.columns[e].type||"percentage"==obj.options.columns[e].type||"autonumber"==obj.options.columns[e].type||"color"==obj.options.columns[e].type)for(var r=0;r<obj.options.data.length;r++)n[r]=[r,Number(obj.options.data[r][e])];else if("calendar"==obj.options.columns[e].type||"checkbox"==obj.options.columns[e].type||"radio"==obj.options.columns[e].type)for(r=0;r<obj.options.data.length;r++)n[r]=[r,obj.options.data[r][e]];else for(r=0;r<obj.options.data.length;r++)n[r]=[r,obj.records[r][e].innerText.toLowerCase()];n=n.orderBy(1,t);var o=[];for(r=0;r<n.length;r++)o[r]=n[r][0];return obj.setHistory({action:"orderBy",rows:o,column:e,order:t}),obj.updateOrderArrow(e,t),obj.updateOrder(o),obj.dispatch("onsort",el,e,t),!0}},obj.updateOrderArrow=function(e,t){for(var n=0;n<obj.headers.length;n++)obj.headers[n].classList.remove("arrow-up"),obj.headers[n].classList.remove("arrow-down");t?obj.headers[e].classList.add("arrow-up"):obj.headers[e].classList.add("arrow-down")},obj.updateOrder=function(e){for(var t=[],n=0;n<e.length;n++)t[n]=obj.options.data[e[n]];for(obj.options.data=t,t=[],n=0;n<e.length;n++)t[n]=obj.records[e[n]];for(obj.records=t,t=[],n=0;n<e.length;n++)t[n]=obj.rows[e[n]];if(obj.rows=t,obj.updateTableReferences(),obj.results&&obj.results.length)obj.searchInput.value?obj.search(obj.searchInput.value):obj.closeFilter();else if(obj.results=null,obj.pageNumber=0,obj.options.pagination>0)obj.page(0);else if(1==obj.options.lazyLoading)obj.loadPage(0);else for(n=0;n<obj.rows.length;n++)obj.tbody.appendChild(obj.rows[n])},obj.moveRow=function(e,t,n){if(Object.keys(obj.options.mergeCells).length>0){if(e>t)var r=1;else r=0;if(obj.isRowMerged(e).length||obj.isRowMerged(t,r).length){if(!confirm(obj.options.text.thisActionWillDestroyAnyExistingMergedCellsAreYouSure))return!1;obj.destroyMerged()}}if(1==obj.options.search){if(obj.results&&obj.results.length!=obj.rows.length){if(!confirm(obj.options.text.thisActionWillClearYourSearchResultsAreYouSure))return!1;obj.resetSearch()}obj.results=null}n||(Array.prototype.indexOf.call(obj.tbody.children,obj.rows[t])>=0?e>t?obj.tbody.insertBefore(obj.rows[e],obj.rows[t]):obj.tbody.insertBefore(obj.rows[e],obj.rows[t].nextSibling):obj.tbody.removeChild(obj.rows[e])),obj.rows.splice(t,0,obj.rows.splice(e,1)[0]),obj.records.splice(t,0,obj.records.splice(e,1)[0]),obj.options.data.splice(t,0,obj.options.data.splice(e,1)[0]),obj.options.pagination>0&&obj.tbody.children.length!=obj.options.pagination&&obj.page(obj.pageNumber),obj.setHistory({action:"moveRow",oldValue:e,newValue:t}),obj.updateTableReferences(),obj.dispatch("onmoverow",el,e,t)},obj.insertRow=function(e,t,n){if(1==obj.options.allowInsertRow){var r=[];if(e>0)var o=e;else o=1,e&&(r=e);n=!!n;var i=obj.options.data.length-1;if((null==t||t>=parseInt(i)||t<0)&&(t=i),!1===obj.dispatch("onbeforeinsertrow",el,t,o,n))return console.log("onbeforeinsertrow returned false"),!1;if(Object.keys(obj.options.mergeCells).length>0&&obj.isRowMerged(t,n).length){if(!confirm(obj.options.text.thisActionWillDestroyAnyExistingMergedCellsAreYouSure))return!1;obj.destroyMerged()}if(1==obj.options.search){if(obj.results&&obj.results.length!=obj.rows.length){if(!confirm(obj.options.text.thisActionWillClearYourSearchResultsAreYouSure))return!1;obj.resetSearch()}obj.results=null}for(var a=n?t:t+1,l=obj.records.splice(a),s=obj.options.data.splice(a),u=obj.rows.splice(a),g=[],c=[],d=[],p=a;p<o+a;p++){obj.options.data[p]=[];for(var C=0;C<obj.options.columns.length;C++)obj.options.data[p][C]=r[C]?r[C]:"";var A=obj.createRow(p,obj.options.data[p]);u[0]?Array.prototype.indexOf.call(obj.tbody.children,u[0])>=0&&obj.tbody.insertBefore(A,u[0]):Array.prototype.indexOf.call(obj.tbody.children,obj.rows[t])>=0&&obj.tbody.appendChild(A),g.push(obj.records[p]),c.push(obj.options.data[p]),d.push(A)}Array.prototype.push.apply(obj.records,l),Array.prototype.push.apply(obj.options.data,s),Array.prototype.push.apply(obj.rows,u),obj.options.pagination>0&&obj.page(obj.pageNumber),obj.setHistory({action:"insertRow",rowNumber:t,numOfRows:o,insertBefore:n,rowRecords:g,rowData:c,rowNode:d}),obj.updateTableReferences(),obj.dispatch("oninsertrow",el,t,o,g,n)}},obj.deleteRow=function(e,t){if(1==obj.options.allowDeleteRow)if(1==obj.options.allowDeletingAllRows||obj.options.data.length>1){if(null==e){var n=obj.getSelectedRows();n[0]?(e=parseInt(n[0].getAttribute("data-y")),t=n.length):(e=obj.options.data.length-1,t=1)}var r=obj.options.data.length-1;if((null==e||e>r||e<0)&&(e=r),t||(t=1),e+t>=obj.options.data.length&&(t=obj.options.data.length-e),!1===obj.dispatch("onbeforedeleterow",el,e,t))return console.log("onbeforedeleterow returned false"),!1;if(parseInt(e)>-1){var o=!1;if(Object.keys(obj.options.mergeCells).length>0)for(var i=e;i<e+t;i++)obj.isRowMerged(i,!1).length&&(o=!0);if(o){if(!confirm(obj.options.text.thisActionWillDestroyAnyExistingMergedCellsAreYouSure))return!1;obj.destroyMerged()}if(1==obj.options.search){if(obj.results&&obj.results.length!=obj.rows.length){if(!confirm(obj.options.text.thisActionWillClearYourSearchResultsAreYouSure))return!1;obj.resetSearch()}obj.results=null}for(i=e;i<e+t;i++)Array.prototype.indexOf.call(obj.tbody.children,obj.rows[i])>=0&&(obj.rows[i].className="",obj.rows[i].parentNode.removeChild(obj.rows[i]));var a=obj.records.splice(e,t),l=obj.options.data.splice(e,t),s=obj.rows.splice(e,t);obj.options.pagination>0&&obj.tbody.children.length!=obj.options.pagination&&obj.page(obj.pageNumber),obj.conditionalSelectionUpdate(1,e,e+t-1),obj.setHistory({action:"deleteRow",rowNumber:e,numOfRows:t,insertBefore:1,rowRecords:a,rowData:l,rowNode:s}),obj.updateTableReferences(),obj.dispatch("ondeleterow",el,e,t,a)}}else console.error("JEXCEL. It is not possible to delete the last row")},obj.moveColumn=function(e,t){if(Object.keys(obj.options.mergeCells).length>0){if(e>t)var n=1;else n=0;if(obj.isColMerged(e).length||obj.isColMerged(t,n).length){if(!confirm(obj.options.text.thisActionWillDestroyAnyExistingMergedCellsAreYouSure))return!1;obj.destroyMerged()}}if((e=parseInt(e))>(t=parseInt(t))){obj.headerContainer.insertBefore(obj.headers[e],obj.headers[t]),obj.colgroupContainer.insertBefore(obj.colgroup[e],obj.colgroup[t]);for(var r=0;r<obj.rows.length;r++)obj.rows[r].insertBefore(obj.records[r][e],obj.records[r][t])}else for(obj.headerContainer.insertBefore(obj.headers[e],obj.headers[t].nextSibling),obj.colgroupContainer.insertBefore(obj.colgroup[e],obj.colgroup[t].nextSibling),r=0;r<obj.rows.length;r++)obj.rows[r].insertBefore(obj.records[r][e],obj.records[r][t].nextSibling);for(obj.options.columns.splice(t,0,obj.options.columns.splice(e,1)[0]),obj.headers.splice(t,0,obj.headers.splice(e,1)[0]),obj.colgroup.splice(t,0,obj.colgroup.splice(e,1)[0]),r=0;r<obj.rows.length;r++)obj.options.data[r].splice(t,0,obj.options.data[r].splice(e,1)[0]),obj.records[r].splice(t,0,obj.records[r].splice(e,1)[0]);if(obj.options.footers)for(r=0;r<obj.options.footers.length;r++)obj.options.footers[r].splice(t,0,obj.options.footers[r].splice(e,1)[0]);obj.setHistory({action:"moveColumn",oldValue:e,newValue:t}),obj.updateTableReferences(),obj.dispatch("onmovecolumn",el,e,t)},obj.insertColumn=function(e,t,n,r){if(1==obj.options.allowInsertColumn){var o=[];if(e>0)var i=e;else i=1,e&&(o=e);n=!!n;var a=obj.options.columns.length-1;if((null==t||t>=parseInt(a)||t<0)&&(t=a),!1===obj.dispatch("onbeforeinsertcolumn",el,t,i,n))return console.log("onbeforeinsertcolumn returned false"),!1;if(Object.keys(obj.options.mergeCells).length>0&&obj.isColMerged(t,n).length){if(!confirm(obj.options.text.thisActionWillDestroyAnyExistingMergedCellsAreYouSure))return!1;obj.destroyMerged()}r||(r=[]);for(var l=0;l<i;l++)r[l]||(r[l]={type:"text",source:[],options:[],width:obj.options.defaultColWidth,align:obj.options.defaultColAlign});var s=n?t:t+1;obj.options.columns=jexcel.injectArray(obj.options.columns,s,r);for(var u=obj.headers.splice(s),g=obj.colgroup.splice(s),c=[],d=[],p=[],C=[],A=[],I=s;I<i+s;I++)obj.createCellHeader(I),obj.headerContainer.insertBefore(obj.headers[I],obj.headerContainer.children[I+1]),obj.colgroupContainer.insertBefore(obj.colgroup[I],obj.colgroupContainer.children[I+1]),c.push(obj.headers[I]),d.push(obj.colgroup[I]);if(obj.options.footers)for(var b=0;b<obj.options.footers.length;b++){for(A[b]=[],l=0;l<i;l++)A[b].push("");obj.options.footers[b].splice(s,0,A[b])}for(var f=0;f<obj.options.data.length;f++){var h=obj.options.data[f].splice(s),m=obj.records[f].splice(s);for(C[f]=[],p[f]=[],I=s;I<i+s;I++){var j=o[f]?o[f]:"";obj.options.data[f][I]=j;var v=obj.createCell(I,f,obj.options.data[f][I]);obj.records[f][I]=v,obj.rows[f]&&obj.rows[f].insertBefore(v,obj.rows[f].children[I+1]),C[f].push(j),p[f].push(v)}Array.prototype.push.apply(obj.options.data[f],h),Array.prototype.push.apply(obj.records[f],m)}if(Array.prototype.push.apply(obj.headers,u),Array.prototype.push.apply(obj.colgroup,g),obj.options.nestedHeaders&&obj.options.nestedHeaders.length>0)if(obj.options.nestedHeaders[0]&&obj.options.nestedHeaders[0][0])for(b=0;b<obj.options.nestedHeaders.length;b++){var x=parseInt(obj.options.nestedHeaders[b][obj.options.nestedHeaders[b].length-1].colspan)+i;obj.options.nestedHeaders[b][obj.options.nestedHeaders[b].length-1].colspan=x,obj.thead.children[b].children[obj.thead.children[b].children.length-1].setAttribute("colspan",x)}else x=parseInt(obj.options.nestedHeaders[0].colspan)+i,obj.options.nestedHeaders[0].colspan=x,obj.thead.children[0].children[obj.thead.children[0].children.length-1].setAttribute("colspan",x);obj.setHistory({action:"insertColumn",columnNumber:t,numOfColumns:i,insertBefore:n,columns:r,headers:c,colgroup:d,records:p,footers:A,data:C}),obj.updateTableReferences(),obj.dispatch("oninsertcolumn",el,t,i,p,n)}},obj.deleteColumn=function(e,t){if(1==obj.options.allowDeleteColumn)if(obj.headers.length>1){if(null==e){var n=obj.getSelectedColumns(!0);n.length?(e=parseInt(n[0]),t=parseInt(n.length)):(e=obj.headers.length-1,t=1)}var r=obj.options.data[0].length-1;if((null==e||e>r||e<0)&&(e=r),t||(t=1),t>obj.options.data[0].length-e&&(t=obj.options.data[0].length-e),!1===obj.dispatch("onbeforedeletecolumn",el,e,t))return console.log("onbeforedeletecolumn returned false"),!1;if(parseInt(e)>-1){var o=!1;if(Object.keys(obj.options.mergeCells).length>0)for(var i=e;i<e+t;i++)obj.isColMerged(i,!1).length&&(o=!0);if(o){if(!confirm(obj.options.text.thisActionWillDestroyAnyExistingMergedCellsAreYouSure))return!1;obj.destroyMerged()}var a=obj.options.columns.splice(e,t);for(i=e;i<e+t;i++)obj.colgroup[i].className="",obj.headers[i].className="",obj.colgroup[i].parentNode.removeChild(obj.colgroup[i]),obj.headers[i].parentNode.removeChild(obj.headers[i]);for(var l=obj.headers.splice(e,t),s=obj.colgroup.splice(e,t),u=[],g=[],c=[],d=0;d<obj.options.data.length;d++)for(i=e;i<e+t;i++)obj.records[d][i].className="",obj.records[d][i].parentNode.removeChild(obj.records[d][i]);for(d=0;d<obj.options.data.length;d++)g[d]=obj.options.data[d].splice(e,t),u[d]=obj.records[d].splice(e,t);if(obj.options.footers)for(d=0;d<obj.options.footers.length;d++)c[d]=obj.options.footers[d].splice(e,t);if(obj.conditionalSelectionUpdate(0,e,e+t-1),obj.options.nestedHeaders&&obj.options.nestedHeaders.length>0)if(obj.options.nestedHeaders[0]&&obj.options.nestedHeaders[0][0])for(var p=0;p<obj.options.nestedHeaders.length;p++){var C=parseInt(obj.options.nestedHeaders[p][obj.options.nestedHeaders[p].length-1].colspan)-t;obj.options.nestedHeaders[p][obj.options.nestedHeaders[p].length-1].colspan=C,obj.thead.children[p].children[obj.thead.children[p].children.length-1].setAttribute("colspan",C)}else C=parseInt(obj.options.nestedHeaders[0].colspan)-t,obj.options.nestedHeaders[0].colspan=C,obj.thead.children[0].children[obj.thead.children[0].children.length-1].setAttribute("colspan",C);obj.setHistory({action:"deleteColumn",columnNumber:e,numOfColumns:t,insertBefore:1,columns:a,headers:l,colgroup:s,records:u,footers:c,data:g}),obj.updateTableReferences(),obj.dispatch("ondeletecolumn",el,e,t,u)}}else console.error("JEXCEL. It is not possible to delete the last column")},obj.getSelectedRows=function(e){for(var t=[],n=0;n<obj.rows.length;n++)obj.rows[n].classList.contains("selected")&&(e?t.push(n):t.push(obj.rows[n]));return t},obj.getSelectedColumns=function(){for(var e=[],t=0;t<obj.headers.length;t++)obj.headers[t].classList.contains("selected")&&e.push(t);return e},obj.getHighlighted=function(){return obj.highlighted},obj.updateTableReferences=function(){for(var e=0;e<obj.headers.length;e++)(i=obj.headers[e].getAttribute("data-x"))!=e&&(obj.headers[e].setAttribute("data-x",e),obj.headers[e].getAttribute("title")||(obj.headers[e].innerHTML=jexcel.getColumnName(e)));for(var t=0;t<obj.rows.length;t++)obj.rows[t]&&(a=obj.rows[t].getAttribute("data-y"))!=t&&(obj.rows[t].setAttribute("data-y",t),obj.rows[t].children[0].setAttribute("data-y",t),obj.rows[t].children[0].innerHTML=t+1);var n=[],r=[],o=function(e,t,r,o){if(e!=r&&obj.records[o][r].setAttribute("data-x",r),t!=o&&obj.records[o][r].setAttribute("data-y",o),e!=r||t!=o){var i=jexcel.getColumnNameFromId([e,t]),a=jexcel.getColumnNameFromId([r,o]);n[i]=a}};for(t=0;t<obj.records.length;t++)for(e=0;e<obj.records[0].length;e++)if(obj.records[t][e]){var i=obj.records[t][e].getAttribute("data-x"),a=obj.records[t][e].getAttribute("data-y");if(obj.records[t][e].getAttribute("data-merged")){var l=jexcel.getColumnNameFromId([i,a]),s=jexcel.getColumnNameFromId([e,t]);if(null==r[l])if(l==s)r[l]=!1;else{var u=parseInt(e-i),g=parseInt(t-a);r[l]=[s,u,g]}}else o(i,a,e,t)}var c=Object.keys(r);if(c.length)for(e=0;e<c.length;e++)if(r[c[e]]){var d=jexcel.getIdFromColumnName(c[e],!0);for(o(i=d[0],a=d[1],i+r[c[e]][1],a+r[c[e]][2]),l=c[e],s=r[c[e]][0],t=0;t<obj.options.mergeCells[l][2].length;t++)i=parseInt(obj.options.mergeCells[l][2][t].getAttribute("data-x")),a=parseInt(obj.options.mergeCells[l][2][t].getAttribute("data-y")),obj.options.mergeCells[l][2][t].setAttribute("data-x",i+r[c[e]][1]),obj.options.mergeCells[l][2][t].setAttribute("data-y",a+r[c[e]][2]);obj.options.mergeCells[s]=obj.options.mergeCells[l],delete obj.options.mergeCells[l]}obj.updateFormulas(n),obj.updateMeta(n),obj.refreshSelection(),obj.updateTable()},obj.updateTable=function(){if(obj.options.minSpareRows>0){for(var e=0,t=obj.rows.length-1;t>=0;t--){for(var n=!1,r=0;r<obj.headers.length;r++)obj.options.data[t][r]&&(n=!0);if(n)break;e++}obj.options.minSpareRows-e>0&&obj.insertRow(obj.options.minSpareRows-e)}if(obj.options.minSpareCols>0){var o=0;for(r=obj.headers.length-1;r>=0;r--){for(n=!1,t=0;t<obj.rows.length;t++)obj.options.data[t][r]&&(n=!0);if(n)break;o++}obj.options.minSpareCols-o>0&&obj.insertColumn(obj.options.minSpareCols-o)}if("function"==typeof obj.options.updateTable){for(obj.options.detachForUpdates&&el.removeChild(obj.content),t=0;t<obj.rows.length;t++)for(r=0;r<obj.headers.length;r++)obj.options.updateTable(el,obj.records[t][r],r,t,obj.options.data[t][r],obj.records[t][r].innerText,jexcel.getColumnNameFromId([r,t]));obj.options.detachForUpdates&&el.insertBefore(obj.content,obj.pagination)}obj.options.footers&&obj.setFooter(),setTimeout((function(){obj.updateCornerPosition()}),0)},obj.showRow=function(e){obj.rows[e].style.display=""},obj.hideRow=function(e){obj.rows[e].style.display="none"},obj.showColumn=function(e){obj.headers[e].style.display="",obj.colgroup[e].style.display="";for(var t=0;t<obj.options.data.length;t++)obj.records[t][e].style.display=""},obj.hideColumn=function(e){obj.headers[e].style.display="none",obj.colgroup[e].style.display="none";for(var t=0;t<obj.options.data.length;t++)obj.records[t][e].style.display="none"},obj.showIndex=function(){obj.table.classList.remove("jexcel_hidden_index")},obj.hideIndex=function(){obj.table.classList.add("jexcel_hidden_index")};var chainLoopProtection=[];obj.updateFormulaChain=function(e,t,n){var r=jexcel.getColumnNameFromId([e,t]);if(obj.formula[r]&&obj.formula[r].length>0)if(chainLoopProtection[r])obj.records[t][e].innerHTML="#ERROR",obj.formula[r]="";else{chainLoopProtection[r]=!0;for(var o=0;o<obj.formula[r].length;o++){var i=jexcel.getIdFromColumnName(obj.formula[r][o],!0),a=""+obj.options.data[i[1]][i[0]];"="==a.substr(0,1)?n.push(obj.updateCell(i[0],i[1],a,!0)):Object.keys(obj.formula)[o]=null,obj.updateFormulaChain(i[0],i[1],n)}}chainLoopProtection=[]},obj.updateFormulas=function(e){for(var t=0;t<obj.options.data.length;t++)for(var n=0;n<obj.options.data[0].length;n++)if("="==(l=""+obj.options.data[t][n]).substr(0,1)){var r=obj.updateFormula(l,e);r!=l&&(obj.options.data[t][n]=r)}var o=[],i=Object.keys(obj.formula);for(t=0;t<i.length;t++){var a=i[t],l=obj.formula[a];for(e[a]&&(a=e[a]),o[a]=[],n=0;n<l.length;n++){var s=l[n];e[s]&&(s=e[s]),o[a].push(s)}}obj.formula=o},obj.updateFormula=function(e,t){for(var n=/[A-Z]/,r=/[0-9]/,o="",i=null,a=null,l="",s=0;s<e.length;s++)n.exec(e[s])?(i=1,a=0,l+=e[s]):r.exec(e[s])?(a=i?1:0,l+=e[s]):(i&&a&&(l=t[l]?t[l]:l),o+=l,o+=e[s],i=0,a=0,l="");return l&&(i&&a&&(l=t[l]?t[l]:l),o+=l),o};var secureFormula=function(e){for(var t="",n=0,r=0;r<e.length;r++)'"'==e[r]&&(n=0==n?1:0),t+=1==n?e[r]:e[r].toUpperCase();return t};obj.executeFormula=function(expression,x,y){var formulaResults=[],formulaLoopProtection=[],execute=function(expression,x,y){var parentId=jexcel.getColumnNameFromId([x,y]);if(formulaLoopProtection[parentId])return console.error("Reference loop detected"),"#ERROR";formulaLoopProtection[parentId]=!0;var tokensUpdate=function(e){for(var t=0;t<e.length;t++){var n=[],r=e[t].split(":"),o=jexcel.getIdFromColumnName(r[0],!0),i=jexcel.getIdFromColumnName(r[1],!0);if(o[0]<=i[0])var a=o[0],l=i[0];else a=i[0],l=o[0];if(o[1]<=i[1])var s=o[1],u=i[1];else s=i[1],u=o[1];for(var g=s;g<=u;g++)for(var c=a;c<=l;c++)n.push(jexcel.getColumnNameFromId([c,g]));expression=expression.replace(e[t],n.join(","))}},tokens=expression.match(/([A-Z]+[0-9]+)\:([A-Z]+[0-9]+)/g);tokens&&tokens.length&&tokensUpdate(tokens);var evalstring="",tokens=expression.match(/([A-Z]+[0-9]+)/g);if(tokens&&tokens.indexOf(parentId)>-1)return console.error("Self Reference detected"),"#ERROR";if(tokens)for(var i=0;i<tokens.length;i++)if(obj.formula[tokens[i]]||(obj.formula[tokens[i]]=[]),obj.formula[tokens[i]].indexOf(parentId)<0&&obj.formula[tokens[i]].push(parentId),eval("typeof("+tokens[i]+') == "undefined"')){var position=jexcel.getIdFromColumnName(tokens[i],1);if(void 0!==obj.options.data[position[1]]&&void 0!==obj.options.data[position[1]][position[0]])var value=obj.options.data[position[1]][position[0]];else var value="";if("="==(""+value).substr(0,1)&&(formulaResults[tokens[i]]?value=formulaResults[tokens[i]]:(value=execute(value,position[0],position[1]),formulaResults[tokens[i]]=value)),""==(""+value).trim())evalstring+="var "+tokens[i]+" = null;";else if(value==Number(value)&&1==obj.options.autoCasting)evalstring+="var "+tokens[i]+" = "+Number(value)+";";else{var number=obj.parseNumber(value,position[0]);1==obj.options.autoCasting&&number?evalstring+="var "+tokens[i]+" = "+number+";":evalstring+="var "+tokens[i]+" = '"+value+"';"}}try{evalstring+="function COLUMN() { return parseInt(x) + 1; }; function ROW() { return parseInt(y) + 1; }; function CELL() { return parentId; }; function TABLE() { return obj; }; function VALUE(col, row) { return obj.records[row-1][col-1].innerHTML; }; function THISROWCELL(col) { var id = jexcel.getIdFromColumnName(col+(parseInt(y)+1), true); return obj.records[id[1]][id[0]].innerHTML; }";var res=eval(evalstring+expression.substr(1))}catch(e){var res="#ERROR"}return res};return execute(expression,x,y)},obj.parseNumber=function(e,t){var n=t&&obj.options.columns[t].decimal?obj.options.columns[t].decimal:".",r=""+e;if((r=r.split(n))[0]=r[0].match(/[+-]?[0-9]/g),r[0]&&(r[0]=r[0].join("")),r[1]&&(r[1]=r[1].match(/[0-9]*/g).join("")),r[0]&&Number(r[0])>=0)if(r[1])e=Number(r[0]+"."+r[1]);else e=Number(r[0]+".00");else e=null;return e},obj.row=function(e){},obj.col=function(e){},obj.up=function(e,t){if(e?obj.selectedCell[3]>0&&obj.up.visible(1,t?0:1):(obj.selectedCell[1]>0&&obj.up.visible(0,t?0:1),obj.selectedCell[2]=obj.selectedCell[0],obj.selectedCell[3]=obj.selectedCell[1]),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]),1==obj.options.lazyLoading)if(0==obj.selectedCell[1]||0==obj.selectedCell[3])obj.loadPage(0),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]);else if(obj.loadValidation())obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]);else{var n=parseInt(obj.tbody.firstChild.getAttribute("data-y"));obj.selectedCell[1]-n<30&&(obj.loadUp(),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]))}else if(obj.options.pagination>0){var r=obj.whichPage(obj.selectedCell[3]);r!=obj.pageNumber&&obj.page(r)}obj.updateScroll(1)},obj.up.visible=function(e,t){if(0==e)var n=parseInt(obj.selectedCell[0]),r=parseInt(obj.selectedCell[1]);else n=parseInt(obj.selectedCell[2]),r=parseInt(obj.selectedCell[3]);if(0==t){for(var o=0;o<r;o++)if("none"!=obj.records[o][n].style.display&&"none"!=obj.rows[o].style.display){r=o;break}}else r=obj.up.get(n,r);0==e?(obj.selectedCell[0]=n,obj.selectedCell[1]=r):(obj.selectedCell[2]=n,obj.selectedCell[3]=r)},obj.up.get=function(e,t){e=parseInt(e);for(var n=(t=parseInt(t))-1;n>=0;n--)if("none"!=obj.records[n][e].style.display&&"none"!=obj.rows[n].style.display){if(obj.records[n][e].getAttribute("data-merged")&&obj.records[n][e]==obj.records[t][e])continue;t=n;break}return t},obj.down=function(e,t){if(e?obj.selectedCell[3]<obj.records.length-1&&obj.down.visible(1,t?0:1):(obj.selectedCell[1]<obj.records.length-1&&obj.down.visible(0,t?0:1),obj.selectedCell[2]=obj.selectedCell[0],obj.selectedCell[3]=obj.selectedCell[1]),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]),1==obj.options.lazyLoading)obj.selectedCell[1]==obj.records.length-1||obj.selectedCell[3]==obj.records.length-1?(obj.loadPage(-1),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3])):obj.loadValidation()?obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]):parseInt(obj.tbody.lastChild.getAttribute("data-y"))-obj.selectedCell[3]<30&&(obj.loadDown(),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]));else if(obj.options.pagination>0){var n=obj.whichPage(obj.selectedCell[3]);n!=obj.pageNumber&&obj.page(n)}obj.updateScroll(3)},obj.down.visible=function(e,t){if(0==e)var n=parseInt(obj.selectedCell[0]),r=parseInt(obj.selectedCell[1]);else n=parseInt(obj.selectedCell[2]),r=parseInt(obj.selectedCell[3]);if(0==t){for(var o=obj.rows.length-1;o>r;o--)if("none"!=obj.records[o][n].style.display&&"none"!=obj.rows[o].style.display){r=o;break}}else r=obj.down.get(n,r);0==e?(obj.selectedCell[0]=n,obj.selectedCell[1]=r):(obj.selectedCell[2]=n,obj.selectedCell[3]=r)},obj.down.get=function(e,t){e=parseInt(e);for(var n=(t=parseInt(t))+1;n<obj.rows.length;n++)if("none"!=obj.records[n][e].style.display&&"none"!=obj.rows[n].style.display){if(obj.records[n][e].getAttribute("data-merged")&&obj.records[n][e]==obj.records[t][e])continue;t=n;break}return t},obj.right=function(e,t){e?obj.selectedCell[2]<obj.headers.length-1&&obj.right.visible(1,t?0:1):(obj.selectedCell[0]<obj.headers.length-1&&obj.right.visible(0,t?0:1),obj.selectedCell[2]=obj.selectedCell[0],obj.selectedCell[3]=obj.selectedCell[1]),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]),obj.updateScroll(2)},obj.right.visible=function(e,t){if(0==e)var n=parseInt(obj.selectedCell[0]),r=parseInt(obj.selectedCell[1]);else n=parseInt(obj.selectedCell[2]),r=parseInt(obj.selectedCell[3]);if(0==t){for(var o=obj.headers.length-1;o>n;o--)if("none"!=obj.records[r][o].style.display){n=o;break}}else n=obj.right.get(n,r);0==e?(obj.selectedCell[0]=n,obj.selectedCell[1]=r):(obj.selectedCell[2]=n,obj.selectedCell[3]=r)},obj.right.get=function(e,t){e=parseInt(e),t=parseInt(t);for(var n=e+1;n<obj.headers.length;n++)if("none"!=obj.records[t][n].style.display){if(obj.records[t][n].getAttribute("data-merged")&&obj.records[t][n]==obj.records[t][e])continue;e=n;break}return e},obj.left=function(e,t){e?obj.selectedCell[2]>0&&obj.left.visible(1,t?0:1):(obj.selectedCell[0]>0&&obj.left.visible(0,t?0:1),obj.selectedCell[2]=obj.selectedCell[0],obj.selectedCell[3]=obj.selectedCell[1]),obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]),obj.updateScroll(0)},obj.left.visible=function(e,t){if(0==e)var n=parseInt(obj.selectedCell[0]),r=parseInt(obj.selectedCell[1]);else n=parseInt(obj.selectedCell[2]),r=parseInt(obj.selectedCell[3]);if(0==t){for(var o=0;o<n;o++)if("none"!=obj.records[r][o].style.display){n=o;break}}else n=obj.left.get(n,r);0==e?(obj.selectedCell[0]=n,obj.selectedCell[1]=r):(obj.selectedCell[2]=n,obj.selectedCell[3]=r)},obj.left.get=function(e,t){e=parseInt(e),t=parseInt(t);for(var n=e-1;n>=0;n--)if("none"!=obj.records[t][n].style.display){if(obj.records[t][n].getAttribute("data-merged")&&obj.records[t][n]==obj.records[t][e])continue;e=n;break}return e},obj.first=function(e,t){if(e?t?obj.selectedCell[3]=0:obj.left.visible(1,0):(t?obj.selectedCell[1]=0:obj.left.visible(0,0),obj.selectedCell[2]=obj.selectedCell[0],obj.selectedCell[3]=obj.selectedCell[1]),1!=obj.options.lazyLoading||0!=obj.selectedCell[1]&&0!=obj.selectedCell[3]){if(obj.options.pagination>0){var n=obj.whichPage(obj.selectedCell[3]);n!=obj.pageNumber&&obj.page(n)}}else obj.loadPage(0);obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]),obj.updateScroll(1)},obj.last=function(e,t){if(e?t?obj.selectedCell[3]=obj.records.length-1:obj.right.visible(1,0):(t?obj.selectedCell[1]=obj.records.length-1:obj.right.visible(0,0),obj.selectedCell[2]=obj.selectedCell[0],obj.selectedCell[3]=obj.selectedCell[1]),1!=obj.options.lazyLoading||obj.selectedCell[1]!=obj.records.length-1&&obj.selectedCell[3]!=obj.records.length-1){if(obj.options.pagination>0){var n=obj.whichPage(obj.selectedCell[3]);n!=obj.pageNumber&&obj.page(n)}}else obj.loadPage(-1);obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3]),obj.updateScroll(3)},obj.selectAll=function(){obj.selectedCell||(obj.selectedCell=[]),obj.selectedCell[0]=0,obj.selectedCell[1]=0,obj.selectedCell[2]=obj.headers.length-1,obj.selectedCell[3]=obj.records.length-1,obj.updateSelectionFromCoords(obj.selectedCell[0],obj.selectedCell[1],obj.selectedCell[2],obj.selectedCell[3])},obj.loadPage=function(e){if(1==obj.options.search&&obj.results)var t=obj.results;else t=obj.rows;var n=100;null!=e&&-1!=e||(e=Math.ceil(t.length/n));var r=e*n,o=e*n+n;o>t.length&&(o=t.length),(r=o-100)<0&&(r=0);for(var i=r;i<o;i++)1==obj.options.search&&obj.results?obj.tbody.appendChild(obj.rows[t[i]]):obj.tbody.appendChild(obj.rows[i]),obj.tbody.children.length>n&&obj.tbody.removeChild(obj.tbody.firstChild)},obj.loadUp=function(){if(1==obj.options.search&&obj.results)var e=obj.results;else e=obj.rows;var t=0;if(e.length>100){var n=parseInt(obj.tbody.firstChild.getAttribute("data-y"));if(1==obj.options.search&&obj.results&&(n=e.indexOf(n)),n>0)for(var r=0;r<30;r++)(n-=1)>-1&&(1==obj.options.search&&obj.results?obj.tbody.insertBefore(obj.rows[e[n]],obj.tbody.firstChild):obj.tbody.insertBefore(obj.rows[n],obj.tbody.firstChild),obj.tbody.children.length>100&&(obj.tbody.removeChild(obj.tbody.lastChild),t=1))}return t},obj.loadDown=function(){if(1==obj.options.search&&obj.results)var e=obj.results;else e=obj.rows;var t=0;if(e.length>100){var n=parseInt(obj.tbody.lastChild.getAttribute("data-y"));if(1==obj.options.search&&obj.results&&(n=e.indexOf(n)),n<obj.rows.length-1)for(var r=0;r<=30;r++)n<e.length&&(1==obj.options.search&&obj.results?obj.tbody.appendChild(obj.rows[e[n]]):obj.tbody.appendChild(obj.rows[n]),obj.tbody.children.length>100&&(obj.tbody.removeChild(obj.tbody.firstChild),t=1)),n+=1}return t},obj.loadValidation=function(){if(obj.selectedCell){var e=parseInt(obj.tbody.firstChild.getAttribute("data-y"))/100,t=parseInt(obj.selectedCell[3]/100),n=parseInt(obj.rows.length/100);if(e!=t&&t<=n&&!Array.prototype.indexOf.call(obj.tbody.children,obj.rows[obj.selectedCell[3]]))return obj.loadPage(t),!0}return!1},obj.resetSearch=function(){obj.searchInput.value="",obj.search(""),obj.results=null},obj.search=function(e){if(e&&(e=e.toLowerCase()),obj.options.filters&&obj.resetFilters(),obj.resetSelection(),obj.pageNumber=0,obj.results=[],e){var t=function(e){-1==obj.results.indexOf(e)&&obj.results.push(e)};obj.options.data.filter((function(n,r){if(function(e,t,n){for(var r=0;r<e.length;r++)if((""+e[r]).toLowerCase().search(t)>=0||(""+obj.records[n][r].innerHTML).toLowerCase().search(t)>=0)return!0;return!1}(n,e,r)){var o=obj.isRowMerged(r);if(o.length)for(var i=0;i<o.length;i++)for(var a=jexcel.getIdFromColumnName(o[i],!0),l=0;l<obj.options.mergeCells[o[i]][1];l++)t(a[1]+l);else t(r);return!0}return!1}))}else obj.results=null;return obj.updateResult()},obj.updateResult=function(){var e,t=0;for(e=1==obj.options.lazyLoading?100:obj.options.pagination>0?obj.options.pagination:obj.results?obj.results.length:obj.rows.length;obj.tbody.firstChild;)obj.tbody.removeChild(obj.tbody.firstChild);for(var n=0;n<obj.rows.length;n++)!obj.results||obj.results.indexOf(n)>-1?(t<e&&(obj.tbody.appendChild(obj.rows[n]),t++),obj.rows[n].style.display=""):obj.rows[n].style.display="none";return obj.options.pagination>0&&obj.updatePagination(),obj.updateCornerPosition(),e},obj.whichPage=function(e){return 1==obj.options.search&&obj.results&&(e=obj.results.indexOf(e)),Math.ceil((parseInt(e)+1)/parseInt(obj.options.pagination))-1},obj.page=function(e){var t=obj.pageNumber;if(1==obj.options.search&&obj.results)var n=obj.results;else n=obj.rows;var r=parseInt(obj.options.pagination);null!=e&&-1!=e||(e=Math.ceil(n.length/r)),obj.pageNumber=e;var o=e*r,i=e*r+r;for(i>n.length&&(i=n.length),o<0&&(o=0);obj.tbody.firstChild;)obj.tbody.removeChild(obj.tbody.firstChild);for(var a=o;a<i;a++)1==obj.options.search&&obj.results?obj.tbody.appendChild(obj.rows[n[a]]):obj.tbody.appendChild(obj.rows[a]);obj.options.pagination>0&&obj.updatePagination(),obj.updateCornerPosition(),obj.dispatch("onchangepage",el,e,t)},obj.updatePagination=function(){if(obj.pagination.children[0].innerHTML="",obj.pagination.children[1].innerHTML="",obj.options.pagination){if(1==obj.options.search&&obj.results)var e=obj.results.length;else e=obj.rows.length;if(e){var t=Math.ceil(e/obj.options.pagination);if(obj.pageNumber<6)var n=1,r=t<10?t:10;else t-obj.pageNumber<5?(r=t,(n=t-9)<1&&(n=1)):(n=obj.pageNumber-4,r=obj.pageNumber+5);n>1&&((i=document.createElement("div")).className="jexcel_page",i.innerHTML="<",i.title=1,obj.pagination.children[1].appendChild(i));for(var o=n;o<=r;o++){var i;(i=document.createElement("div")).className="jexcel_page",i.innerHTML=o,obj.pagination.children[1].appendChild(i),obj.pageNumber==o-1&&i.classList.add("jexcel_page_selected")}r<t&&((i=document.createElement("div")).className="jexcel_page",i.innerHTML=">",i.title=t,obj.pagination.children[1].appendChild(i)),obj.pagination.children[0].innerHTML=function(e){var t=Array.prototype.slice.call(arguments,1);return e.replace(/{(\d+)}/g,(function(e,n){return void 0!==t[n]?t[n]:e}))}(obj.options.text.showingPage,obj.pageNumber+1,t)}else obj.pagination.children[0].innerHTML=obj.options.text.noRecordsFound}},obj.download=function(e){if(0==obj.options.allowExport)console.error("Export not allowed");else{var t="";1!=e&&1!=obj.options.includeHeadersOnDownload||(t+=obj.getHeaders(),t+="\r\n"),t+=obj.copy(!1,obj.options.csvDelimiter,!0);var n=new Blob(["\ufeff"+t],{type:"text/csv;charset=utf-8;"});if(window.navigator&&window.navigator.msSaveOrOpenBlob)window.navigator.msSaveOrOpenBlob(n,options.csvFileName+".csv");else{var r=document.createElement("a"),o=URL.createObjectURL(n);r.href=o,r.setAttribute("download",obj.options.csvFileName+".csv"),document.body.appendChild(r),r.click(),r.parentNode.removeChild(r)}}},obj.setHistory=function(e){if(1!=obj.ignoreHistory){var t=++obj.historyIndex;obj.history=obj.history=obj.history.slice(0,t+1),obj.history[t]=e}},obj.copy=function(e,t,n){t||(t="\t");var r=[],o=[],i=[],a=[],l=obj.options.data[0].length,s=obj.options.data.length,u="";1==obj.options.includeHeadersOnCopy&&(1==obj.options.copyCompatibility?A.push(obj.getHeaders(!0).join(t)):C.push(obj.getHeaders(!0).join(t))),obj.style=[];for(var g=0;g<s;g++){r=[],o=[];for(var c=0;c<l;c++)if(!e||obj.records[g][c].classList.contains("highlight")){var d=obj.options.data[g][c];if(d.match&&(d.match(/,/g)||d.match(/\n/)||d.match(/\"/))&&(d='"'+(d=d.replace(new RegExp('"',"g"),'""'))+'"'),r.push(d),"checkbox"==obj.options.columns[c].type||"radio"==obj.options.columns[c].type)var p=d;else(p=obj.records[g][c].innerHTML).match&&(p.match(/,/g)||p.match(/\n/)||p.match(/\"/))&&(p='"'+(p=p.replace(new RegExp('"',"g"),'""'))+'"');o.push(p),u=(u=obj.records[g][c].getAttribute("style")).replace("display: none;",""),obj.style.push(u||"")}r.length&&i.push(r.join(t)),o.length&&a.push(o.join(t))}var C=i.join("\r\n"),A=a.join("\r\n");if(n||(1==obj.options.copyCompatibility?obj.textarea.value=A:obj.textarea.value=C,obj.textarea.select(),document.execCommand("copy")),1==obj.options.copyCompatibility?obj.data=A:obj.data=C,obj.hashString=obj.hash(obj.data),obj.highlighted)for(c=0;c<obj.highlighted.length;c++)obj.highlighted[c].classList.add("copying"),obj.highlighted[c].classList.contains("highlight-left")&&obj.highlighted[c].classList.add("copying-left"),obj.highlighted[c].classList.contains("highlight-right")&&obj.highlighted[c].classList.add("copying-right"),obj.highlighted[c].classList.contains("highlight-top")&&obj.highlighted[c].classList.add("copying-top"),obj.highlighted[c].classList.contains("highlight-bottom")&&obj.highlighted[c].classList.add("copying-bottom");return obj.dispatch("oncopy",el,1==obj.options.copyCompatibility?a:i,obj.hashString),obj.data},obj.paste=function(e,t,n){var r=obj.dispatch("onbeforepaste",el,n,e,t);if(!1===r)return!1;r&&(n=r);var o=obj.hash(n),i=o==obj.hashString?obj.style:null;if(1==obj.options.copyCompatibility&&o==obj.hashString&&(n=obj.data),n=obj.parseCSV(n,"\t"),null!=e&&null!=t&&n){for(var a=0,l=0,s=[],u={},g={},c=0,d=parseInt(e),p=parseInt(t),C=null;C=n[l];){for(a=0,d=parseInt(e);null!=C[a];){var A=obj.updateCell(d,p,C[a]);if(s.push(A),obj.updateFormulaChain(d,p,s),i&&i[c]){var I=jexcel.getColumnNameFromId([d,p]);u[I]=i[c],g[I]=obj.getStyle(I),obj.records[p][d].setAttribute("style",i[c]),c++}null!=C[++a]&&(d>=obj.headers.length-1&&obj.insertColumn(),d=obj.right.get(d,p))}n[++l]&&(p>=obj.rows.length-1&&obj.insertRow(),p=obj.down.get(e,p))}obj.updateSelectionFromCoords(e,t,d,p),obj.setHistory({action:"setValue",records:s,selection:obj.selectedCell,newStyle:u,oldStyle:g}),obj.updateTable(),obj.dispatch("onpaste",el,n),obj.onafterchanges(el,s)}obj.removeCopyingSelection()},obj.removeCopyingSelection=function(){for(var e=document.querySelectorAll(".jexcel .copying"),t=0;t<e.length;t++)e[t].classList.remove("copying"),e[t].classList.remove("copying-left"),e[t].classList.remove("copying-right"),e[t].classList.remove("copying-top"),e[t].classList.remove("copying-bottom")},obj.historyProcessRow=function(e,t){var n=t.insertBefore?t.rowNumber:t.rowNumber+1;if(1==obj.options.search&&obj.results&&obj.results.length!=obj.rows.length&&obj.resetSearch(),1==e){for(var r=t.numOfRows,o=n;o<r+n;o++)obj.rows[o].parentNode.removeChild(obj.rows[o]);obj.records.splice(n,r),obj.options.data.splice(n,r),obj.rows.splice(n,r),obj.conditionalSelectionUpdate(1,n,r+n-1)}else{obj.records=jexcel.injectArray(obj.records,n,t.rowRecords),obj.options.data=jexcel.injectArray(obj.options.data,n,t.rowData),obj.rows=jexcel.injectArray(obj.rows,n,t.rowNode);var i=0;for(o=n;o<t.numOfRows+n;o++)obj.tbody.insertBefore(t.rowNode[i],obj.tbody.children[o]),i++}obj.options.pagination>0&&obj.page(obj.pageNumber),obj.updateTableReferences()},obj.historyProcessColumn=function(e,t){var n=t.insertBefore?t.columnNumber:t.columnNumber+1;if(1==e){var r=t.numOfColumns;obj.options.columns.splice(n,r);for(var o=n;o<r+n;o++)obj.headers[o].parentNode.removeChild(obj.headers[o]),obj.colgroup[o].parentNode.removeChild(obj.colgroup[o]);obj.headers.splice(n,r),obj.colgroup.splice(n,r);for(var i=0;i<t.data.length;i++){for(o=n;o<r+n;o++)obj.records[i][o].parentNode.removeChild(obj.records[i][o]);obj.records[i].splice(n,r),obj.options.data[i].splice(n,r)}if(obj.options.footers)for(i=0;i<obj.options.footers.length;i++)obj.options.footers[i].splice(n,r)}else{obj.options.columns=jexcel.injectArray(obj.options.columns,n,t.columns),obj.headers=jexcel.injectArray(obj.headers,n,t.headers),obj.colgroup=jexcel.injectArray(obj.colgroup,n,t.colgroup);var a=0;for(o=n;o<t.numOfColumns+n;o++)obj.headerContainer.insertBefore(t.headers[a],obj.headerContainer.children[o+1]),obj.colgroupContainer.insertBefore(t.colgroup[a],obj.colgroupContainer.children[o+1]),a++;for(i=0;i<t.data.length;i++)for(obj.options.data[i]=jexcel.injectArray(obj.options.data[i],n,t.data[i]),obj.records[i]=jexcel.injectArray(obj.records[i],n,t.records[i]),a=0,o=n;o<t.numOfColumns+n;o++)obj.rows[i].insertBefore(t.records[i][a],obj.rows[i].children[o+1]),a++;if(obj.options.footers)for(i=0;i<obj.options.footers.length;i++)obj.options.footers[i]=jexcel.injectArray(obj.options.footers[i],n,t.footers[i])}if(obj.options.nestedHeaders&&obj.options.nestedHeaders.length>0)if(obj.options.nestedHeaders[0]&&obj.options.nestedHeaders[0][0])for(i=0;i<obj.options.nestedHeaders.length;i++){if(1==e)var l=parseInt(obj.options.nestedHeaders[i][obj.options.nestedHeaders[i].length-1].colspan)-t.numOfColumns;else l=parseInt(obj.options.nestedHeaders[i][obj.options.nestedHeaders[i].length-1].colspan)+t.numOfColumns;obj.options.nestedHeaders[i][obj.options.nestedHeaders[i].length-1].colspan=l,obj.thead.children[i].children[obj.thead.children[i].children.length-1].setAttribute("colspan",l)}else l=1==e?parseInt(obj.options.nestedHeaders[0].colspan)-t.numOfColumns:parseInt(obj.options.nestedHeaders[0].colspan)+t.numOfColumns,obj.options.nestedHeaders[0].colspan=l,obj.thead.children[0].children[obj.thead.children[0].children.length-1].setAttribute("colspan",l);obj.updateTableReferences()},obj.undo=function(){var e=!!obj.ignoreEvents,t=!!obj.ignoreHistory;obj.ignoreEvents=!0,obj.ignoreHistory=!0;var n=[];if(obj.historyIndex>=0){var r=obj.history[obj.historyIndex--];if("insertRow"==r.action)obj.historyProcessRow(1,r);else if("deleteRow"==r.action)obj.historyProcessRow(0,r);else if("insertColumn"==r.action)obj.historyProcessColumn(1,r);else if("deleteColumn"==r.action)obj.historyProcessColumn(0,r);else if("moveRow"==r.action)obj.moveRow(r.newValue,r.oldValue);else if("moveColumn"==r.action)obj.moveColumn(r.newValue,r.oldValue);else if("setMerge"==r.action)obj.removeMerge(r.column,r.data);else if("setStyle"==r.action)obj.setStyle(r.oldValue,null,null,1);else if("setWidth"==r.action)obj.setWidth(r.column,r.oldValue);else if("setHeight"==r.action)obj.setHeight(r.row,r.oldValue);else if("setHeader"==r.action)obj.setHeader(r.column,r.oldValue);else if("setComments"==r.action)obj.setComments(r.column,r.oldValue[0],r.oldValue[1]);else if("orderBy"==r.action){for(var o=[],i=0;i<r.rows.length;i++)o[r.rows[i]]=i;obj.updateOrderArrow(r.column,r.order?0:1),obj.updateOrder(o)}else if("setValue"==r.action){for(var a=0;a<r.records.length;a++)n.push({x:r.records[a].x,y:r.records[a].y,newValue:r.records[a].oldValue}),r.oldStyle&&obj.resetStyle(r.oldStyle);obj.setValue(n),r.selection&&obj.updateSelectionFromCoords(r.selection[0],r.selection[1],r.selection[2],r.selection[3])}}obj.ignoreEvents=e,obj.ignoreHistory=t,obj.dispatch("onundo",el,r)},obj.redo=function(){var e=!!obj.ignoreEvents,t=!!obj.ignoreHistory;if(obj.ignoreEvents=!0,obj.ignoreHistory=!0,obj.historyIndex<obj.history.length-1){var n=obj.history[++obj.historyIndex];if("insertRow"==n.action)obj.historyProcessRow(0,n);else if("deleteRow"==n.action)obj.historyProcessRow(1,n);else if("insertColumn"==n.action)obj.historyProcessColumn(0,n);else if("deleteColumn"==n.action)obj.historyProcessColumn(1,n);else if("moveRow"==n.action)obj.moveRow(n.oldValue,n.newValue);else if("moveColumn"==n.action)obj.moveColumn(n.oldValue,n.newValue);else if("setMerge"==n.action)obj.setMerge(n.column,n.colspan,n.rowspan,1);else if("setStyle"==n.action)obj.setStyle(n.newValue,null,null,1);else if("setWidth"==n.action)obj.setWidth(n.column,n.newValue);else if("setHeight"==n.action)obj.setHeight(n.row,n.newValue);else if("setHeader"==n.action)obj.setHeader(n.column,n.newValue);else if("setComments"==n.action)obj.setComments(n.column,n.newValue[0],n.newValue[1]);else if("orderBy"==n.action)obj.updateOrderArrow(n.column,n.order),obj.updateOrder(n.rows);else if("setValue"==n.action){obj.setValue(n.records);for(var r=0;r<n.records.length;r++)n.oldStyle&&obj.resetStyle(n.newStyle);n.selection&&obj.updateSelectionFromCoords(n.selection[0],n.selection[1],n.selection[2],n.selection[3])}}obj.ignoreEvents=e,obj.ignoreHistory=t,obj.dispatch("onredo",el,n)},obj.getDropDownValue=function(e,t){var n=[];if(obj.options.columns[e]&&obj.options.columns[e].source){for(var r=[],o=obj.options.columns[e].source,i=0;i<o.length;i++)"object"==typeof o[i]?r[o[i].id]=o[i].name:r[o[i]]=o[i];var a=(""+t).split(";");for(i=0;i<a.length;i++)r[a[i]]&&n.push(r[a[i]])}else console.error("Invalid column");return n.length>0?n.join("; "):""},obj.parseCSV=function(e,t){9==(e=e.replace(/\r?\n$|\r$|\n$/g,"")).charCodeAt(e.length-1)&&(e+="\0"),t=t||",";for(var n=[],r=!1,o=0,i=0,a=0;a<e.length;a++){var l=e[a],s=e[a+1];n[o]=n[o]||[],n[o][i]=n[o][i]||"",'"'==l&&r&&'"'==s?(n[o][i]+=l,++a):'"'!=l?l!=t||r?"\r"!=l||"\n"!=s||r?"\n"==l&&!r||"\r"==l&&!r?(++o,i=0):n[o][i]+=l:(++o,i=0,++a):++i:r=!r}return n},obj.hash=function(e){var t,n=0;if(0===e.length)return n;for(t=0;t<e.length;t++)n=(n<<5)-n+e.charCodeAt(t),n|=0;return n},obj.onafterchanges=function(e,t){obj.dispatch("onafterchanges",e,t)},obj.destroy=function(){jexcel.destroy(el)},obj.init=function(){jexcel.current=obj,"function"==typeof jexcel.build&&(obj.options.root?jexcel.build(obj.options.root):(jexcel.build(document),jexcel.build=null)),el.setAttribute("tabindex",1),el.addEventListener("focus",(function(e){jexcel.current&&!obj.selectedCell&&(obj.updateSelectionFromCoords(0,0,0,0),obj.left())})),obj.options.csv?(1==obj.options.loadingSpin&&jSuites.loading.show(),jSuites.ajax({url:obj.options.csv,method:"GET",dataType:"text",success:function(e){var t=obj.parseCSV(e,obj.options.csvDelimiter);if(1==obj.options.csvHeaders&&t.length>0)for(var n=t.shift(),r=0;r<n.length;r++)obj.options.columns[r]||(obj.options.columns[r]={type:"text",align:obj.options.defaultColAlign,width:obj.options.defaultColWidth}),void 0===obj.options.columns[r].title&&(obj.options.columns[r].title=n[r]);obj.options.data=t,obj.prepareTable(),1==obj.options.loadingSpin&&jSuites.loading.hide()}})):obj.options.url?(1==obj.options.loadingSpin&&jSuites.loading.show(),jSuites.ajax({url:obj.options.url,method:"GET",dataType:"json",success:function(e){obj.options.data=e.data?e.data:e,obj.prepareTable(),1==obj.options.loadingSpin&&jSuites.loading.hide()}})):obj.prepareTable()},options&&null!=options.contextMenu?obj.options.contextMenu=options.contextMenu:obj.options.contextMenu=function(e,t,n,r){var o=[];if(null==n)1==obj.options.allowInsertColumn&&o.push({title:obj.options.text.insertANewColumnBefore,onclick:function(){obj.insertColumn(1,parseInt(t),1)}}),1==obj.options.allowInsertColumn&&o.push({title:obj.options.text.insertANewColumnAfter,onclick:function(){obj.insertColumn(1,parseInt(t),0)}}),1==obj.options.allowDeleteColumn&&o.push({title:obj.options.text.deleteSelectedColumns,onclick:function(){obj.deleteColumn(obj.getSelectedColumns().length?void 0:parseInt(t))}}),1==obj.options.allowRenameColumn&&o.push({title:obj.options.text.renameThisColumn,onclick:function(){obj.setHeader(t)}}),1==obj.options.columnSorting&&(o.push({type:"line"}),o.push({title:obj.options.text.orderAscending,onclick:function(){obj.orderBy(t,0)}}),o.push({title:obj.options.text.orderDescending,onclick:function(){obj.orderBy(t,1)}}));else if(1==obj.options.allowInsertRow&&(o.push({title:obj.options.text.insertANewRowBefore,onclick:function(){obj.insertRow(1,parseInt(n),1)}}),o.push({title:obj.options.text.insertANewRowAfter,onclick:function(){obj.insertRow(1,parseInt(n))}})),1==obj.options.allowDeleteRow&&o.push({title:obj.options.text.deleteSelectedRows,onclick:function(){obj.deleteRow(obj.getSelectedRows().length?void 0:parseInt(n))}}),t&&1==obj.options.allowComments){o.push({type:"line"});var i=obj.records[n][t].getAttribute("title")||"";o.push({title:i?obj.options.text.editComments:obj.options.text.addComments,onclick:function(){var e=prompt(obj.options.text.comments,i);e&&obj.setComments([t,n],e)}}),i&&o.push({title:obj.options.text.clearComments,onclick:function(){obj.setComments([t,n],"")}})}return o.push({type:"line"}),o.push({title:obj.options.text.copy,shortcut:"Ctrl + C",onclick:function(){obj.copy(!0)}}),navigator&&navigator.clipboard&&o.push({title:obj.options.text.paste,shortcut:"Ctrl + V",onclick:function(){obj.selectedCell&&navigator.clipboard.readText().then((function(e){e&&jexcel.current.paste(obj.selectedCell[0],obj.selectedCell[1],e)}))}}),obj.options.allowExport&&o.push({title:obj.options.text.saveAs,shortcut:"Ctrl + S",onclick:function(){obj.download()}}),obj.options.about&&o.push({title:obj.options.text.about,onclick:function(){alert(obj.options.about)}}),o},obj.scrollControls=function(e){obj.wheelControls(),obj.options.freezeColumns>0&&obj.content.scrollLeft!=scrollLeft&&obj.updateFreezePosition(),1!=obj.options.lazyLoading&&1!=obj.options.tableOverflow||obj.edition&&"jdropdown"!=e.target.className.substr(0,9)&&obj.closeEditor(obj.edition[0],!0)},obj.wheelControls=function(e){1==obj.options.lazyLoading&&null==jexcel.timeControlLoading&&(jexcel.timeControlLoading=setTimeout((function(){obj.content.scrollTop+obj.content.clientHeight>=obj.content.scrollHeight?obj.loadDown()&&(obj.content.scrollTop+obj.content.clientHeight>obj.content.scrollHeight-10&&(obj.content.scrollTop=obj.content.scrollTop-obj.content.clientHeight),obj.updateCornerPosition()):obj.content.scrollTop<=obj.content.clientHeight&&obj.loadUp()&&(obj.content.scrollTop<10&&(obj.content.scrollTop=obj.content.scrollTop+obj.content.clientHeight),obj.updateCornerPosition()),jexcel.timeControlLoading=null}),100))},obj.getFreezeWidth=function(){var e=0;if(obj.options.freezeColumns>0)for(var t=0;t<obj.options.freezeColumns;t++)e+=parseInt(obj.options.columns[t].width);return e};var scrollLeft=0;return obj.updateFreezePosition=function(){var e=0;if((scrollLeft=obj.content.scrollLeft)>50)for(var t=0;t<obj.options.freezeColumns;t++){t>0&&(e+=parseInt(obj.options.columns[t-1].width)),obj.headers[t].classList.add("jexcel_freezed"),obj.headers[t].style.left=e+"px";for(var n=0;n<obj.rows.length;n++)if(obj.rows[n]&&obj.records[n][t]){var r=scrollLeft+(t>0?obj.records[n][t-1].style.width:0)-51+"px";obj.records[n][t].classList.add("jexcel_freezed"),obj.records[n][t].style.left=r}}else for(t=0;t<obj.options.freezeColumns;t++)for(obj.headers[t].classList.remove("jexcel_freezed"),obj.headers[t].style.left="",n=0;n<obj.rows.length;n++)obj.records[n][t]&&(obj.records[n][t].classList.remove("jexcel_freezed"),obj.records[n][t].style.left="");obj.updateCornerPosition()},el.addEventListener("DOMMouseScroll",obj.wheelControls),el.addEventListener("mousewheel",obj.wheelControls),el.jexcel=obj,obj.init(),obj};jexcel.current=null,jexcel.timeControl=null,jexcel.timeControlLoading=null,jexcel.destroy=function(e,t){if(e.jexcel){var n=e.jexcel.options.root?e.jexcel.options.root:document;e.removeEventListener("DOMMouseScroll",e.jexcel.scrollControls),e.removeEventListener("mousewheel",e.jexcel.scrollControls),e.jexcel=null,e.innerHTML="",t&&(n.removeEventListener("mouseup",jexcel.mouseUpControls),n.removeEventListener("mousedown",jexcel.mouseDownControls),n.removeEventListener("mousemove",jexcel.mouseMoveControls),n.removeEventListener("mouseover",jexcel.mouseOverControls),n.removeEventListener("dblclick",jexcel.doubleClickControls),n.removeEventListener("paste",jexcel.pasteControls),n.removeEventListener("contextmenu",jexcel.contextMenuControls),n.removeEventListener("touchstart",jexcel.touchStartControls),n.removeEventListener("touchend",jexcel.touchEndControls),n.removeEventListener("touchcancel",jexcel.touchEndControls),document.removeEventListener("keydown",jexcel.keyDownControls),jexcel=null)}},jexcel.build=function(e){e.addEventListener("mouseup",jexcel.mouseUpControls),e.addEventListener("mousedown",jexcel.mouseDownControls),e.addEventListener("mousemove",jexcel.mouseMoveControls),e.addEventListener("mouseover",jexcel.mouseOverControls),e.addEventListener("dblclick",jexcel.doubleClickControls),e.addEventListener("paste",jexcel.pasteControls),e.addEventListener("contextmenu",jexcel.contextMenuControls),e.addEventListener("touchstart",jexcel.touchStartControls),e.addEventListener("touchend",jexcel.touchEndControls),e.addEventListener("touchcancel",jexcel.touchEndControls),e.addEventListener("touchmove",jexcel.touchEndControls),document.addEventListener("keydown",jexcel.keyDownControls)},jexcel.keyDownControls=function(e){if(jexcel.current){if(jexcel.current.edition)if(27==e.which)jexcel.current.edition&&jexcel.current.closeEditor(jexcel.current.edition[0],!1),e.preventDefault();else if(13==e.which)if("calendar"==jexcel.current.options.columns[jexcel.current.edition[2]].type)jexcel.current.closeEditor(jexcel.current.edition[0],!0);else if("dropdown"==jexcel.current.options.columns[jexcel.current.edition[2]].type||"autocomplete"==jexcel.current.options.columns[jexcel.current.edition[2]].type);else if((1==jexcel.current.options.wordWrap||1==jexcel.current.options.columns[jexcel.current.edition[2]].wordWrap||jexcel.current.options.data[jexcel.current.edition[3]][jexcel.current.edition[2]].length>200)&&e.altKey){var t=jexcel.current.edition[0].children[0],n=jexcel.current.edition[0].children[0].value,r=t.selectionStart;n=n.slice(0,r)+"\n"+n.slice(r),t.value=n,t.focus(),t.selectionStart=r+1,t.selectionEnd=r+1}else jexcel.current.edition[0].children[0].blur();else 9==e.which&&("calendar"==jexcel.current.options.columns[jexcel.current.edition[2]].type?jexcel.current.closeEditor(jexcel.current.edition[0],!0):jexcel.current.edition[0].children[0].blur());if(!jexcel.current.edition&&jexcel.current.selectedCell)if(37==e.which)jexcel.current.left(e.shiftKey,e.ctrlKey),e.preventDefault();else if(39==e.which)jexcel.current.right(e.shiftKey,e.ctrlKey),e.preventDefault();else if(38==e.which)jexcel.current.up(e.shiftKey,e.ctrlKey),e.preventDefault();else if(40==e.which)jexcel.current.down(e.shiftKey,e.ctrlKey),e.preventDefault();else if(36==e.which)jexcel.current.first(e.shiftKey,e.ctrlKey),e.preventDefault();else if(35==e.which)jexcel.current.last(e.shiftKey,e.ctrlKey),e.preventDefault();else if(32==e.which)1==jexcel.current.options.editable&&jexcel.current.setCheckRadioValue(),e.preventDefault();else if(46==e.which)1==jexcel.current.options.editable&&(jexcel.current.selectedRow?1==jexcel.current.options.allowDeleteRow&&confirm(jexcel.current.options.text.areYouSureToDeleteTheSelectedRows)&&jexcel.current.deleteRow():jexcel.current.selectedHeader?1==jexcel.current.options.allowDeleteColumn&&confirm(jexcel.current.options.text.areYouSureToDeleteTheSelectedColumns)&&jexcel.current.deleteColumn():jexcel.current.setValue(jexcel.current.highlighted,""));else if(13==e.which)e.shiftKey?jexcel.current.up():(1==jexcel.current.options.allowInsertRow&&1==jexcel.current.options.allowManualInsertRow&&jexcel.current.selectedCell[1]==jexcel.current.options.data.length-1&&jexcel.current.insertRow(),jexcel.current.down()),e.preventDefault();else if(9==e.which)e.shiftKey?jexcel.current.left():(1==jexcel.current.options.allowInsertColumn&&1==jexcel.current.options.allowManualInsertColumn&&jexcel.current.selectedCell[0]==jexcel.current.options.data[0].length-1&&jexcel.current.insertColumn(),jexcel.current.right()),e.preventDefault();else if(!e.ctrlKey&&!e.metaKey||e.shiftKey){if(jexcel.current.selectedCell&&1==jexcel.current.options.editable){var o=jexcel.current.selectedCell[1],i=jexcel.current.selectedCell[0];"readonly"!=jexcel.current.options.columns[i].type&&(32==e.keyCode?"checkbox"==jexcel.current.options.columns[i].type||"radio"==jexcel.current.options.columns[i].type?e.preventDefault():jexcel.current.openEditor(jexcel.current.records[o][i],!0):113==e.keyCode?jexcel.current.openEditor(jexcel.current.records[o][i],!1):(8==e.keyCode||e.keyCode>=48&&e.keyCode<=57||e.keyCode>=96&&e.keyCode<=111||187==e.keyCode||189==e.keyCode||(String.fromCharCode(e.keyCode)==e.key||String.fromCharCode(e.keyCode).toLowerCase()==e.key.toLowerCase())&&jexcel.validLetter(String.fromCharCode(e.keyCode)))&&(jexcel.current.openEditor(jexcel.current.records[o][i],!0),"calendar"==jexcel.current.options.columns[i].type&&e.preventDefault()))}}else 65==e.which?(jexcel.current.selectAll(),e.preventDefault()):83==e.which?(jexcel.current.download(),e.preventDefault()):89==e.which?(jexcel.current.redo(),e.preventDefault()):90==e.which?(jexcel.current.undo(),e.preventDefault()):67==e.which||67==e.which?(jexcel.current.copy(!0),e.preventDefault()):88==e.which?(1==jexcel.current.options.editable?jexcel.cutControls():jexcel.copyControls(),e.preventDefault()):86==e.which&&jexcel.pasteControls();else e.target.classList.contains("jexcel_search")&&(jexcel.timeControl&&clearTimeout(jexcel.timeControl),jexcel.timeControl=setTimeout((function(){jexcel.current.search(e.target.value)}),200))}},jexcel.isMouseAction=!1,jexcel.mouseDownControls=function(e){if((e=e||window.event).buttons)var t=e.buttons;else t=e.button?e.button:e.which;var n=jexcel.getElement(e.target);if(n[0]?jexcel.current!=n[0].jexcel&&(jexcel.current&&(jexcel.current.edition&&jexcel.current.closeEditor(jexcel.current.edition[0],!0),jexcel.current.resetSelection()),jexcel.current=n[0].jexcel):jexcel.current&&(jexcel.current.edition&&jexcel.current.closeEditor(jexcel.current.edition[0],!0),jexcel.current.resetSelection(!0),jexcel.current=null),jexcel.current&&1==t){if(e.target.classList.contains("jexcel_selectall"))jexcel.current&&jexcel.current.selectAll();else if(e.target.classList.contains("jexcel_corner"))1==jexcel.current.options.editable&&(jexcel.current.selectedCorner=!0);else{if(1==n[1]){if(p=e.target.getAttribute("data-x")){var r=e.target.getBoundingClientRect();if(1==jexcel.current.options.columnResize&&r.width-e.offsetX<6){jexcel.current.resizing={mousePosition:e.pageX,column:p,width:r.width},jexcel.current.headers[p].classList.add("resizing");for(var o=0;o<jexcel.current.records.length;o++)jexcel.current.records[o][p]&&jexcel.current.records[o][p].classList.add("resizing")}else if(1==jexcel.current.options.columnDrag&&r.height-e.offsetY<6)if(jexcel.current.isColMerged(p).length)console.error("JEXCEL: This column is part of a merged cell.");else for(jexcel.current.resetSelection(),jexcel.current.dragging={element:e.target,column:p,destination:p},jexcel.current.headers[p].classList.add("dragging"),o=0;o<jexcel.current.records.length;o++)jexcel.current.records[o][p]&&jexcel.current.records[o][p].classList.add("dragging");else{if(jexcel.current.selectedHeader&&(e.shiftKey||e.ctrlKey))var i=jexcel.current.selectedHeader,a=p;else jexcel.current.selectedHeader==p&&1==jexcel.current.options.allowRenameColumn&&(jexcel.timeControl=setTimeout((function(){jexcel.current.setHeader(p)}),800)),jexcel.current.selectedHeader=p,i=p,a=p;jexcel.current.updateSelectionFromCoords(i,0,a,jexcel.current.options.data.length-1)}}else if(e.target.parentNode.classList.contains("jexcel_nested")){if(e.target.getAttribute("data-column"))var l=e.target.getAttribute("data-column").split(","),s=parseInt(l[0]),u=parseInt(l[l.length-1]);else s=0,u=jexcel.current.options.columns.length-1;jexcel.current.updateSelectionFromCoords(s,0,u,jexcel.current.options.data.length-1)}}else jexcel.current.selectedHeader=!1;if(2==n[1]){var g=e.target.getAttribute("data-y");if(e.target.classList.contains("jexcel_row"))r=e.target.getBoundingClientRect(),1==jexcel.current.options.rowResize&&r.height-e.offsetY<6?(jexcel.current.resizing={element:e.target.parentNode,mousePosition:e.pageY,row:g,height:r.height},e.target.parentNode.classList.add("resizing")):1==jexcel.current.options.rowDrag&&r.width-e.offsetX<6?jexcel.current.isRowMerged(g).length?console.error("JEXCEL: This row is part of a merged cell"):1==jexcel.current.options.search&&jexcel.current.results?console.error("JEXCEL: Please clear your search before perform this action"):(jexcel.current.resetSelection(),jexcel.current.dragging={element:e.target.parentNode,row:g,destination:g},e.target.parentNode.classList.add("dragging")):(jexcel.current.selectedRow&&(e.shiftKey||e.ctrlKey)?(i=jexcel.current.selectedRow,a=g):(jexcel.current.selectedRow=g,i=g,a=g),jexcel.current.updateSelectionFromCoords(0,i,jexcel.current.options.data[0].length-1,a));else if(e.target.classList.contains("jclose")&&e.target.clientWidth-e.offsetX<50&&e.offsetY<50)jexcel.current.closeEditor(jexcel.current.edition[0],!0);else{var c=function(e){var t=e.getAttribute("data-x"),n=e.getAttribute("data-y");return t&&n?[t,n]:e.parentNode?c(e.parentNode):void 0},d=c(e.target);if(d){var p=d[0];g=d[1],jexcel.current.edition&&(jexcel.current.edition[2]==p&&jexcel.current.edition[3]==g||jexcel.current.closeEditor(jexcel.current.edition[0],!0)),jexcel.current.edition||(e.shiftKey?jexcel.current.updateSelectionFromCoords(jexcel.current.selectedCell[0],jexcel.current.selectedCell[1],p,g):jexcel.current.updateSelectionFromCoords(p,g)),jexcel.current.selectedHeader=null,jexcel.current.selectedRow=null}}}else jexcel.current.selectedRow=!1;e.target.classList.contains("jexcel_page")&&("<"==e.target.innerText?jexcel.current.page(0):">"==e.target.innerText?jexcel.current.page(e.target.getAttribute("title")-1):jexcel.current.page(e.target.innerText-1))}jexcel.current.edition?jexcel.isMouseAction=!1:jexcel.isMouseAction=!0}else jexcel.isMouseAction=!1},jexcel.mouseUpControls=function(e){if(jexcel.current)if(jexcel.current.resizing){if(jexcel.current.resizing.column){var t=jexcel.current.colgroup[jexcel.current.resizing.column].getAttribute("width"),n=jexcel.current.getSelectedColumns();if(n.length>1){for(var r=[],o=0;o<n.length;o++)r.push(parseInt(jexcel.current.colgroup[n[o]].getAttribute("width")));r[n.indexOf(parseInt(jexcel.current.resizing.column))]=jexcel.current.resizing.width,jexcel.current.setWidth(n,t,r)}else jexcel.current.setWidth(jexcel.current.resizing.column,t,jexcel.current.resizing.width);jexcel.current.headers[jexcel.current.resizing.column].classList.remove("resizing");for(var i=0;i<jexcel.current.records.length;i++)jexcel.current.records[i][jexcel.current.resizing.column]&&jexcel.current.records[i][jexcel.current.resizing.column].classList.remove("resizing")}else{jexcel.current.rows[jexcel.current.resizing.row].children[0].classList.remove("resizing");var a=jexcel.current.rows[jexcel.current.resizing.row].getAttribute("height");jexcel.current.setHeight(jexcel.current.resizing.row,a,jexcel.current.resizing.height),jexcel.current.resizing.element.classList.remove("resizing")}jexcel.current.resizing=null}else if(jexcel.current.dragging){if(jexcel.current.dragging){if(jexcel.current.dragging.column){var l=e.target.getAttribute("data-x");for(jexcel.current.headers[jexcel.current.dragging.column].classList.remove("dragging"),i=0;i<jexcel.current.rows.length;i++)jexcel.current.records[i][jexcel.current.dragging.column]&&jexcel.current.records[i][jexcel.current.dragging.column].classList.remove("dragging");for(o=0;o<jexcel.current.headers.length;o++)jexcel.current.headers[o].classList.remove("dragging-left"),jexcel.current.headers[o].classList.remove("dragging-right");l&&jexcel.current.dragging.column!=jexcel.current.dragging.destination&&jexcel.current.moveColumn(jexcel.current.dragging.column,jexcel.current.dragging.destination)}else{if(jexcel.current.dragging.element.nextSibling){var s=parseInt(jexcel.current.dragging.element.nextSibling.getAttribute("data-y"));jexcel.current.dragging.row<s&&(s-=1)}else s=parseInt(jexcel.current.dragging.element.previousSibling.getAttribute("data-y"));jexcel.current.dragging.row!=s&&jexcel.current.moveRow(jexcel.current.dragging.row,s,!0),jexcel.current.dragging.element.classList.remove("dragging")}jexcel.current.dragging=null}}else jexcel.current.selectedCorner&&(jexcel.current.selectedCorner=!1,jexcel.current.selection.length>0&&(jexcel.current.copyData(jexcel.current.selection[0],jexcel.current.selection[jexcel.current.selection.length-1]),jexcel.current.removeCopySelection()));jexcel.timeControl&&(clearTimeout(jexcel.timeControl),jexcel.timeControl=null),jexcel.isMouseAction=!1},jexcel.mouseMoveControls=function(e){if((e=e||window.event).buttons)var t=e.buttons;else t=e.button?e.button:e.which;if(t||(jexcel.isMouseAction=!1),jexcel.current)if(1==jexcel.isMouseAction){if(jexcel.current.resizing)if(jexcel.current.resizing.column){var n=e.pageX-jexcel.current.resizing.mousePosition;if(jexcel.current.resizing.width+n>0){var r=jexcel.current.resizing.width+n;jexcel.current.colgroup[jexcel.current.resizing.column].setAttribute("width",r),jexcel.current.updateCornerPosition()}}else{var o=e.pageY-jexcel.current.resizing.mousePosition;if(jexcel.current.resizing.height+o>0){var i=jexcel.current.resizing.height+o;jexcel.current.rows[jexcel.current.resizing.row].setAttribute("height",i),jexcel.current.updateCornerPosition()}}}else{var a=e.target.getAttribute("data-x"),l=e.target.getAttribute("data-y"),s=e.target.getBoundingClientRect();jexcel.current.cursor&&(jexcel.current.cursor.style.cursor="",jexcel.current.cursor=null),e.target.parentNode.parentNode&&e.target.parentNode.parentNode.className&&(e.target.parentNode.parentNode.classList.contains("resizable")&&(e.target&&a&&!l&&s.width-(e.clientX-s.left)<6?(jexcel.current.cursor=e.target,jexcel.current.cursor.style.cursor="col-resize"):e.target&&!a&&l&&s.height-(e.clientY-s.top)<6&&(jexcel.current.cursor=e.target,jexcel.current.cursor.style.cursor="row-resize")),e.target.parentNode.parentNode.classList.contains("draggable")&&(e.target&&!a&&l&&s.width-(e.clientX-s.left)<6||e.target&&a&&!l&&s.height-(e.clientY-s.top)<6)&&(jexcel.current.cursor=e.target,jexcel.current.cursor.style.cursor="move"))}},jexcel.mouseOverControls=function(e){if((e=e||window.event).buttons)var t=e.buttons;else t=e.button?e.button:e.which;if(t||(jexcel.isMouseAction=!1),jexcel.current&&1==jexcel.isMouseAction){var n=jexcel.getElement(e.target);if(n[0]){if(jexcel.current!=n[0].jexcel&&jexcel.current)return!1;var r=e.target.getAttribute("data-x"),o=e.target.getAttribute("data-y");if(jexcel.current.dragging){if(jexcel.current.dragging.column){if(r)if(jexcel.current.isColMerged(r).length)console.error("JEXCEL: This column is part of a merged cell.");else{for(var i=0;i<jexcel.current.headers.length;i++)jexcel.current.headers[i].classList.remove("dragging-left"),jexcel.current.headers[i].classList.remove("dragging-right");jexcel.current.dragging.column==r?jexcel.current.dragging.destination=parseInt(r):e.target.clientWidth/2>e.offsetX?(jexcel.current.dragging.column<r?jexcel.current.dragging.destination=parseInt(r)-1:jexcel.current.dragging.destination=parseInt(r),jexcel.current.headers[r].classList.add("dragging-left")):(jexcel.current.dragging.column<r?jexcel.current.dragging.destination=parseInt(r):jexcel.current.dragging.destination=parseInt(r)+1,jexcel.current.headers[r].classList.add("dragging-right"))}}else if(o)if(jexcel.current.isRowMerged(o).length)console.error("JEXCEL: This row is part of a merged cell.");else{var a=e.target.clientHeight/2>e.offsetY?e.target.parentNode.nextSibling:e.target.parentNode;e.target.parentNode.parentNode.insertBefore(jexcel.current.dragging.element,a)}}else if(jexcel.current.resizing);else{if(1==n[1]&&jexcel.current.selectedHeader){r=e.target.getAttribute("data-x");var l=jexcel.current.selectedHeader,s=r;jexcel.current.updateSelectionFromCoords(l,0,s,jexcel.current.options.data.length-1)}2==n[1]&&(e.target.classList.contains("jexcel_row")?jexcel.current.selectedRow&&(l=jexcel.current.selectedRow,s=o,jexcel.current.updateSelectionFromCoords(0,l,jexcel.current.options.data[0].length-1,s)):jexcel.current.edition||r&&o&&(jexcel.current.selectedCorner?jexcel.current.updateCopySelection(r,o):jexcel.current.selectedCell&&jexcel.current.updateSelectionFromCoords(jexcel.current.selectedCell[0],jexcel.current.selectedCell[1],r,o)))}}}jexcel.timeControl&&(clearTimeout(jexcel.timeControl),jexcel.timeControl=null)},jexcel.doubleClickControls=function(e){if(jexcel.current)if(e.target.classList.contains("jexcel_corner")){if(jexcel.current.highlighted.length>0){var t=jexcel.current.highlighted[0].getAttribute("data-x"),n=parseInt(jexcel.current.highlighted[jexcel.current.highlighted.length-1].getAttribute("data-y"))+1,r=jexcel.current.highlighted[jexcel.current.highlighted.length-1].getAttribute("data-x"),o=jexcel.current.records.length-1;jexcel.current.copyData(jexcel.current.records[n][t],jexcel.current.records[o][r])}}else if(e.target.classList.contains("jexcel_column_filter")){var i=e.target.getAttribute("data-x");jexcel.current.openFilter(i)}else{var a=jexcel.getElement(e.target);if(1==a[1]&&1==jexcel.current.options.columnSorting&&(i=e.target.getAttribute("data-x"))&&jexcel.current.orderBy(i),2==a[1]&&1==jexcel.current.options.editable&&!jexcel.current.edition){var l=function(e){if(e.parentNode){var t=e.getAttribute("data-x"),n=e.getAttribute("data-y");return t&&n?e:l(e.parentNode)}},s=l(e.target);s&&s.classList.contains("highlight")&&jexcel.current.openEditor(s)}}},jexcel.copyControls=function(e){jexcel.current&&jexcel.copyControls.enabled&&(jexcel.current.edition||jexcel.current.copy(!0))},jexcel.cutControls=function(e){jexcel.current&&(jexcel.current.edition||(jexcel.current.copy(!0),1==jexcel.current.options.editable&&jexcel.current.setValue(jexcel.current.highlighted,"")))},jexcel.pasteControls=function(e){jexcel.current&&jexcel.current.selectedCell&&(jexcel.current.edition||1==jexcel.current.options.editable&&(e&&e.clipboardData?(jexcel.current.paste(jexcel.current.selectedCell[0],jexcel.current.selectedCell[1],e.clipboardData.getData("text")),e.preventDefault()):window.clipboardData&&jexcel.current.paste(jexcel.current.selectedCell[0],jexcel.current.selectedCell[1],window.clipboardData.getData("text"))))},jexcel.contextMenuControls=function(e){if("buttons"in(e=e||window.event)?e.buttons:e.which||e.button,jexcel.current)if(jexcel.current.edition)e.preventDefault();else if(jexcel.current.options.contextMenu&&(jexcel.current.contextMenu.contextmenu.close(),jexcel.current)){var t=e.target.getAttribute("data-x"),n=e.target.getAttribute("data-y");if(t||n){var r=jexcel.current.options.contextMenu(jexcel.current,t,n,e);jexcel.current.contextMenu.contextmenu.open(e,r),e.preventDefault()}}},jexcel.touchStartControls=function(e){var t=jexcel.getElement(e.target);if(t[0]?jexcel.current!=t[0].jexcel&&(jexcel.current&&jexcel.current.resetSelection(),jexcel.current=t[0].jexcel):jexcel.current&&(jexcel.current.resetSelection(),jexcel.current=null),jexcel.current&&!jexcel.current.edition){var n=e.target.getAttribute("data-x"),r=e.target.getAttribute("data-y");n&&r&&(jexcel.current.updateSelectionFromCoords(n,r),jexcel.timeControl=setTimeout((function(){"color"==jexcel.current.options.columns[n].type?jexcel.tmpElement=null:jexcel.tmpElement=e.target,jexcel.current.openEditor(e.target,!1,e)}),500))}},jexcel.touchEndControls=function(e){jexcel.timeControl&&(clearTimeout(jexcel.timeControl),jexcel.timeControl=null,jexcel.tmpElement&&"INPUT"==jexcel.tmpElement.children[0].tagName&&jexcel.tmpElement.children[0].focus(),jexcel.tmpElement=null)},jexcel.tabs=function(e,t){if(e.classList.contains("jexcel_tabs"))r=e.children[0],o=e.children[1];else{e.innerHTML="",e.classList.add("jexcel_tabs"),e.jexcel=[];var n=document.createElement("div"),r=e.appendChild(n),o=(n=document.createElement("div"),e.appendChild(n))}for(var i=[],a=[],l=0;l<t.length;l++){i[l]=document.createElement("div"),i[l].classList.add("jexcel_tab");var s=jexcel(i[l],t[l]);o.appendChild(i[l]),e.jexcel.push(s),a[l]=document.createElement("div"),a[l].classList.add("jexcel_tab_link"),a[l].setAttribute("data-spreadsheet",e.jexcel.length-1),a[l].innerHTML=t[l].sheetName,a[l].onclick=function(){for(var e=0;e<r.children.length;e++)r.children[e].classList.remove("selected"),o.children[e].style.display="none";var t=this.getAttribute("data-spreadsheet");o.children[t].style.display="block",r.children[t].classList.add("selected")},r.appendChild(a[l])}for(var u=0;u<r.children.length;u++)r.children[u].classList.remove("selected"),o.children[u].style.display="none";r.children[r.children.length-1].classList.add("selected"),o.children[r.children.length-1].style.display="block"},jexcel.createTabs=jexcel.tabs,jexcel.fromSpreadsheet=function(e,t){var n,r=function(e){var t=[];return e.SheetNames.forEach((function(n){var r={rows:[],columns:[],data:[],style:{}};if(r.sheetName=n,(d=e.Sheets[n]["!cols"])&&d.length)for(var o=0;o<d.length;o++)r.columns[o]={},d[o]&&d[o].wpx&&(r.columns[o].width=d[o].wpx+"px");if((d=e.Sheets[n]["!rows"])&&d.length)for(o=0;o<d.length;o++)d[o]&&d[o].hpx&&(r.rows[o]={},r.rows[o].height=d[o].hpx+"px");if((d=e.Sheets[n]["!merges"])&&d.length>0)for(r.mergeCells=[],o=0;o<d.length;o++){var i=d[o].s.c,a=d[o].s.r,l=d[o].e.c,s=d[o].e.r,u=jexcel.getColumnNameFromId([i,a]);r.mergeCells[u]=[l-i+1,s-a+1]}var g=0,c=0,d=Object.keys(e.Sheets[n]);for(o=0;o<d.length;o++)if("!"!=d[o].substr(0,1)){var p=e.Sheets[n][d[o]],C=jexcel.getIdFromColumnName(d[o],!0);r.data[C[1]]||(r.data[C[1]]=[]),r.data[C[1]][C[0]]=p.f?"="+p.f:p.w,g<C[0]&&(g=C[0]),c<C[1]&&(c=C[1]),p.style&&Object.keys(p.style).length>0&&(r.style[d[o]]=p.style),p.s&&p.s.fgColor&&(r.style[d[o]]&&(r.style[d[o]]+=";"),r.style[d[o]]+="background-color:#"+p.s.fgColor.rgb)}for(var A=r.columns,I=0;I<=c;I++)for(o=0;o<=g;o++)r.data[I]||(r.data[I]=[]),r.data[I][o]||A<o&&(r.data[I][o]="");t.push(r)})),t};(n=new XMLHttpRequest).open("GET",e,!0),"undefined"!=typeof Uint8Array?(n.responseType="arraybuffer",n.onload=function(e){var o=n.response,i=new Uint8Array(o),a=XLSX.read(i,{type:"array",cellFormula:!0,cellStyles:!0});t(r(a))}):(n.setRequestHeader("Accept-Charset","x-user-defined"),n.onreadystatechange=function(){if(4==n.readyState&&200==n.status){var e=convertResponseBodyToText(n.responseBody),o=XLSX.read(e,{type:"binary",cellFormula:!0,cellStyles:!0});t(r(o))}}),n.send()},jexcel.validLetter=function(e){return e.match(/([\u0041-\u005A\u0061-\u007A\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC-\u0400-\u04FF']+)/g)?1:0},jexcel.injectArray=function(e,t,n){return e.slice(0,t).concat(n).concat(e.slice(t))},jexcel.getColumnName=function(e){var t="";return e>701?(t+=String.fromCharCode(64+parseInt(e/676)),t+=String.fromCharCode(64+parseInt(e%676/26))):e>25&&(t+=String.fromCharCode(64+parseInt(e/26))),t+String.fromCharCode(65+e%26)},jexcel.getIdFromColumnName=function(e,t){var n=/^[a-zA-Z]+/.exec(e);if(n){for(var r=0,o=0;o<n[0].length;o++)r+=parseInt(n[0].charCodeAt(o)-64)*Math.pow(26,n[0].length-1-o);--r<0&&(r=0);var i=parseInt(/[0-9]+$/.exec(e));i>0&&i--,e=1==t?[r,i]:r+"-"+i}return e},jexcel.getColumnNameFromId=function(e){return Array.isArray(e)||(e=e.split("-")),jexcel.getColumnName(parseInt(e[0]))+(parseInt(e[1])+1)},jexcel.getElement=function(e){var t=0,n=0;return function e(r){r.className&&r.classList.contains("jexcel_container")&&(n=r),"THEAD"==r.tagName?t=1:"TBODY"==r.tagName&&(t=2),r.parentNode&&(n||e(r.parentNode))}(e),[n,t]},jexcel.doubleDigitFormat=function(e){return 1==(e=""+e).length&&(e="0"+e),e},jexcel.createFromTable=function(e,t){if("TABLE"==e.tagName){t||(t={}),t.columns=[],t.data=[];var n=e.querySelectorAll("colgroup > col");if(n.length)for(var r=0;r<n.length;r++){if(!(o=n[r].style.width))var o=n[r].getAttribute("width");o&&(t.columns[r]||(t.columns[r]={}),t.columns[r].width=o)}var i=function(e){var n=e.getBoundingClientRect(),o=n.width>50?n.width:50;t.columns[r]||(t.columns[r]={}),e.getAttribute("data-celltype")?t.columns[r].type=e.getAttribute("data-celltype"):t.columns[r].type="text",t.columns[r].width=o+"px",t.columns[r].title=e.innerText,t.columns[r].align=e.style.textAlign||"center"},a=e.querySelectorAll("thead > tr");if(a.length)for(a=a[a.length-1].children,r=0;r<a.length;r++)i(a[r]);for(var l=0,s={},u={},g={},c=e.querySelectorAll("table > tr, tbody tr"),d=0;d<c.length;d++)if(t.data[l]=[],1==t.parseTableFirstRowAsHeader&&0==d)for(r=0;r<c[d].children.length;r++)i(c[d].children[r]);else{for(r=0;r<c[d].children.length;r++){if(p=c[d].children[r].getAttribute("data-formula"))"="!=p.substr(0,1)&&(p="="+p);else var p=c[d].children[r].innerText;t.data[l].push(p);var C=jexcel.getColumnNameFromId([r,d]),A=parseInt(c[d].children[r].getAttribute("colspan"))||0,I=parseInt(c[d].children[r].getAttribute("rowspan"))||0;(A||I)&&(s[C]=[A||1,I||1]),c[d].children[r].style&&"none"==c[d].children[r].style.display&&(c[d].children[r].style.display="");var b=c[d].children[r].getAttribute("style");b&&(g[C]=b),c[d].children[r].classList.contains("styleBold")&&(g[C]?g[C]+="; font-weight:bold;":g[C]="font-weight:bold;")}c[d].style&&c[d].style.height&&(u[d]={height:c[d].style.height}),l++}if(Object.keys(g).length,Object.keys(s).length>0&&(t.mergeCells=s),Object.keys(u).length>0&&(t.rows=u),1==t.parseTableAutoCellType){var f=[];for(r=0;r<t.columns.length;r++){var h=!0,m=!0;for(f[r]=[],d=0;d<t.data.length;d++)p=t.data[d][r],f[r][p]||(f[r][p]=0),f[r][p]++,p.length>25&&(h=!1),10==p.length&&"-"==p.substr(4,1)&&"-"==p.substr(7,1)||(m=!1);var j=Object.keys(f[r]).length;m?t.columns[r].type="calendar":1==h&&j>1&&j<=parseInt(.1*t.data.length)&&(t.columns[r].type="dropdown",t.columns[r].source=Object.keys(f[r]))}}return t}console.log("Element is not a table")},"undefined"!=typeof jQuery&&function(e){e.fn.jexcel=function(t){var n=e(this).get(0);return n.jexcel?n.jexcel[t].apply(this,Array.prototype.slice.call(arguments,1)):jexcel(e(this).get(0),arguments[0])}}(jQuery);var error=(exports={},exports.nil=new Error("#NULL!"),exports.div0=new Error("#DIV/0!"),exports.value=new Error("#VALUE!"),exports.ref=new Error("#REF!"),exports.name=new Error("#NAME?"),exports.num=new Error("#NUM!"),exports.na=new Error("#N/A"),exports.error=new Error("#ERROR!"),exports.data=new Error("#GETTING_DATA"),exports),exports,utils=function(){var e={flattenShallow:function(e){return e&&e.reduce?e.reduce((function(e,t){var n=Array.isArray(e),r=Array.isArray(t);return n&&r?e.concat(t):n?(e.push(t),e):r?[e].concat(t):[e,t]})):e},isFlat:function(e){if(!e)return!1;for(var t=0;t<e.length;++t)if(Array.isArray(e[t]))return!1;return!0},flatten:function(){for(var t=e.argsToArray.apply(null,arguments);!e.isFlat(t);)t=e.flattenShallow(t);return t},argsToArray:function(t){var n=[];return e.arrayEach(t,(function(e){n.push(e)})),n},numbers:function(){var e=this.flatten.apply(null,arguments);return e.filter((function(e){return"number"==typeof e}))},cleanFloat:function(e){var t=1e14;return Math.round(e*t)/t},parseBool:function(e){if("boolean"==typeof e)return e;if(e instanceof Error)return e;if("number"==typeof e)return 0!==e;if("string"==typeof e){var t=e.toUpperCase();if("TRUE"===t)return!0;if("FALSE"===t)return!1}return e instanceof Date&&!isNaN(e)||error.value},parseNumber:function(e){return void 0===e||""===e||isNaN(e)?error.value:parseFloat(e)},parseNumberArray:function(t){var n,r;if(!t||0===(n=t.length))return error.value;for(;n--;){if((r=e.parseNumber(t[n]))===error.value)return r;t[n]=r}return t},parseMatrix:function(t){var n;if(!t||0===t.length)return error.value;for(var r=0;r<t.length;r++)if(n=e.parseNumberArray(t[r]),t[r]=n,n instanceof Error)return n;return t}},t=new Date(Date.UTC(1900,0,1));return e.parseDate=function(e){if(!isNaN(e)){if(e instanceof Date)return new Date(e);var n=parseInt(e,10);return n<0?error.num:n<=60?new Date(t.getTime()+864e5*(n-1)):new Date(t.getTime()+864e5*(n-2))}return"string"!=typeof e||(e=new Date(e),isNaN(e))?error.value:e},e.parseDateArray=function(e){for(var t,n=e.length;n--;){if((t=this.parseDate(e[n]))===error.value)return t;e[n]=t}return e},e.anyIsError=function(){for(var e=arguments.length;e--;)if(arguments[e]instanceof Error)return!0;return!1},e.arrayValuesToNumbers=function(e){for(var t,n=e.length;n--;)if("number"!=typeof(t=e[n]))if(!0!==t)if(!1!==t){if("string"==typeof t){var r=this.parseNumber(t);r instanceof Error?e[n]=0:e[n]=r}}else e[n]=0;else e[n]=1;return e},e.rest=function(e,t){return t=t||1,e&&"function"==typeof e.slice?e.slice(t):e},e.initial=function(e,t){return t=t||1,e&&"function"==typeof e.slice?e.slice(0,e.length-t):e},e.arrayEach=function(e,t){for(var n=-1,r=e.length;++n<r&&!1!==t(e[n],n,e););return e},e.transpose=function(e){return e?e[0].map((function(t,n){return e.map((function(e){return e[n]}))})):error.value},e}();jexcel.methods={},jexcel.methods.datetime=function(){var e={},t=new Date(1900,0,1),n=[[],[1,2,3,4,5,6,7],[7,1,2,3,4,5,6],[6,0,1,2,3,4,5],[],[],[],[],[],[],[],[7,1,2,3,4,5,6],[6,7,1,2,3,4,5],[5,6,7,1,2,3,4],[4,5,6,7,1,2,3],[3,4,5,6,7,1,2],[2,3,4,5,6,7,1],[1,2,3,4,5,6,7]];function r(e){return(e-t)/864e5+(e>-22038912e5?2:1)}return e.DATE=function(e,t,n){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:e<0||t<0||n<0?error.num:new Date(e,t-1,n)},e.DATEVALUE=function(e){if("string"!=typeof e)return error.value;var n=Date.parse(e);return isNaN(n)?error.value:n<=-22038912e5?(n-t)/864e5+1:(n-t)/864e5+2},e.DAY=function(e){var t=utils.parseDate(e);return t instanceof Error?t:t.getDate()},e.DAYS=function(e,t){return e=utils.parseDate(e),t=utils.parseDate(t),e instanceof Error?e:t instanceof Error?t:r(e)-r(t)},e.DAYS360=function(e,t,n){},e.EDATE=function(e,t){return(e=utils.parseDate(e))instanceof Error?e:isNaN(t)?error.value:(t=parseInt(t,10),e.setMonth(e.getMonth()+t),r(e))},e.EOMONTH=function(e,t){return(e=utils.parseDate(e))instanceof Error?e:isNaN(t)?error.value:(t=parseInt(t,10),r(new Date(e.getFullYear(),e.getMonth()+t+1,0)))},e.HOUR=function(e){return(e=utils.parseDate(e))instanceof Error?e:e.getHours()},e.INTERVAL=function(e){if("number"!=typeof e&&"string"!=typeof e)return error.value;e=parseInt(e,10);var t=Math.floor(e/94608e4);e%=94608e4;var n=Math.floor(e/2592e3);e%=2592e3;var r=Math.floor(e/86400);e%=86400;var o=Math.floor(e/3600);e%=3600;var i=Math.floor(e/60),a=e%=60;return"P"+(t=t>0?t+"Y":"")+(n=n>0?n+"M":"")+(r=r>0?r+"D":"")+"T"+(o=o>0?o+"H":"")+(i=i>0?i+"M":"")+(a>0?a+"S":"")},e.ISOWEEKNUM=function(e){if((e=utils.parseDate(e))instanceof Error)return e;e.setHours(0,0,0),e.setDate(e.getDate()+4-(e.getDay()||7));var t=new Date(e.getFullYear(),0,1);return Math.ceil(((e-t)/864e5+1)/7)},e.MINUTE=function(e){return(e=utils.parseDate(e))instanceof Error?e:e.getMinutes()},e.MONTH=function(e){return(e=utils.parseDate(e))instanceof Error?e:e.getMonth()+1},e.NETWORKDAYS=function(e,t,n){},e.NETWORKDAYS.INTL=function(e,t,n,r){},e.NOW=function(){return new Date},e.SECOND=function(e){return(e=utils.parseDate(e))instanceof Error?e:e.getSeconds()},e.TIME=function(e,t,n){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:e<0||t<0||n<0?error.num:(3600*e+60*t+n)/86400},e.TIMEVALUE=function(e){return(e=utils.parseDate(e))instanceof Error?e:(3600*e.getHours()+60*e.getMinutes()+e.getSeconds())/86400},e.TODAY=function(){return new Date},e.WEEKDAY=function(e,t){if((e=utils.parseDate(e))instanceof Error)return e;void 0===t&&(t=1);var r=e.getDay();return n[t][r]},e.WEEKNUM=function(e,t){},e.WORKDAY=function(e,t,n){},e.WORKDAY.INTL=function(e,t,n,r){},e.YEAR=function(e){return(e=utils.parseDate(e))instanceof Error?e:e.getFullYear()},e.YEARFRAC=function(e,t,n){},e}(),jexcel.methods.database=function(){var exports={};function compact(e){if(!e)return e;for(var t=[],n=0;n<e.length;++n)e[n]&&t.push(e[n]);return t}function findResultIndex(database,criterias){for(var matches={},i=1;i<database[0].length;++i)matches[i]=!0;var maxCriteriaLength=criterias[0].length;for(i=1;i<criterias.length;++i)criterias[i].length>maxCriteriaLength&&(maxCriteriaLength=criterias[i].length);for(var k=1;k<database.length;++k)for(var l=1;l<database[k].length;++l){for(var currentCriteriaResult=!1,hasMatchingCriteria=!1,j=0;j<criterias.length;++j){var criteria=criterias[j];if(!(criteria.length<maxCriteriaLength)){var criteriaField=criteria[0];if(database[k][0]===criteriaField){hasMatchingCriteria=!0;for(var p=1;p<criteria.length;++p)currentCriteriaResult=currentCriteriaResult||eval(database[k][l]+criteria[p])}}}hasMatchingCriteria&&(matches[l]=matches[l]&&currentCriteriaResult)}for(var result=[],n=0;n<database[0].length;++n)matches[n]&&result.push(n-1);return result}return exports.FINDFIELD=function(e,t){for(var n=null,r=0;r<e.length;r++)if(e[r][0]===t){n=r;break}return null==n?error.value:n},exports.DAVERAGE=function(e,t,n){if(isNaN(t)&&"string"!=typeof t)return error.value;var r=findResultIndex(e,n),o=[];if("string"==typeof t){var i=exports.FINDFIELD(e,t);o=utils.rest(e[i])}else o=utils.rest(e[t]);for(var a=0,l=0;l<r.length;l++)a+=o[r[l]];return 0===r.length?error.div0:a/r.length},exports.DCOUNT=function(e,t,n){},exports.DCOUNTA=function(e,t,n){},exports.DGET=function(e,t,n){if(isNaN(t)&&"string"!=typeof t)return error.value;var r=findResultIndex(e,n),o=[];if("string"==typeof t){var i=exports.FINDFIELD(e,t);o=utils.rest(e[i])}else o=utils.rest(e[t]);return 0===r.length?error.value:r.length>1?error.num:o[r[0]]},exports.DMAX=function(e,t,n){if(isNaN(t)&&"string"!=typeof t)return error.value;var r=findResultIndex(e,n),o=[];if("string"==typeof t){var i=exports.FINDFIELD(e,t);o=utils.rest(e[i])}else o=utils.rest(e[t]);for(var a=o[r[0]],l=1;l<r.length;l++)a<o[r[l]]&&(a=o[r[l]]);return a},exports.DMIN=function(e,t,n){if(isNaN(t)&&"string"!=typeof t)return error.value;var r=findResultIndex(e,n),o=[];if("string"==typeof t){var i=exports.FINDFIELD(e,t);o=utils.rest(e[i])}else o=utils.rest(e[t]);for(var a=o[r[0]],l=1;l<r.length;l++)a>o[r[l]]&&(a=o[r[l]]);return a},exports.DPRODUCT=function(e,t,n){if(isNaN(t)&&"string"!=typeof t)return error.value;var r=findResultIndex(e,n),o=[];if("string"==typeof t){var i=exports.FINDFIELD(e,t);o=utils.rest(e[i])}else o=utils.rest(e[t]);for(var a=[],l=0;l<r.length;l++)a[l]=o[r[l]];a=compact(a);var s=1;for(l=0;l<a.length;l++)s*=a[l];return s},exports.DSTDEV=function(e,t,n){},exports.DSTDEVP=function(e,t,n){},exports.DSUM=function(e,t,n){},exports.DVAR=function(e,t,n){},exports.DVARP=function(e,t,n){},exports.MATCH=function(e,t,n){if(!e&&!t)return error.na;if(2===arguments.length&&(n=1),!(t instanceof Array))return error.na;if(-1!==n&&0!==n&&1!==n)return error.na;for(var r,o,i=0;i<t.length;i++)if(1===n){if(t[i]===e)return i+1;t[i]<e&&(o?t[i]>o&&(r=i+1,o=t[i]):(r=i+1,o=t[i]))}else if(0===n){if("string"==typeof e){if(e=e.replace(/\?/g,"."),t[i].toLowerCase().match(e.toLowerCase()))return i+1}else if(t[i]===e)return i+1}else if(-1===n){if(t[i]===e)return i+1;t[i]>e&&(o?t[i]<o&&(r=i+1,o=t[i]):(r=i+1,o=t[i]))}return r||error.na},exports}(),jexcel.methods.engineering=function(){var e={};function t(e){return/^[01]{1,10}$/.test(e)}return e.BESSELI=function(e,t){},e.BESSELJ=function(e,t){},e.BESSELK=function(e,t){},e.BESSELY=function(e,t){},e.BIN2DEC=function(e){if(!t(e))return error.num;var n=parseInt(e,2),r=e.toString();return 10===r.length&&"1"===r.substring(0,1)?parseInt(r.substring(1),2)-512:n},e.BIN2HEX=function(e,n){if(!t(e))return error.num;var r=e.toString();if(10===r.length&&"1"===r.substring(0,1))return(0xfffffffe00+parseInt(r.substring(1),2)).toString(16);var o=parseInt(e,2).toString(16);return void 0===n?o:isNaN(n)?error.value:n<0?error.num:(n=Math.floor(n))>=o.length?REPT("0",n-o.length)+o:error.num},e.BIN2OCT=function(e,n){if(!t(e))return error.num;var r=e.toString();if(10===r.length&&"1"===r.substring(0,1))return(1073741312+parseInt(r.substring(1),2)).toString(8);var o=parseInt(e,2).toString(8);return void 0===n?o:isNaN(n)?error.value:n<0?error.num:(n=Math.floor(n))>=o.length?REPT("0",n-o.length)+o:error.num},e.BITAND=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e<0||t<0||Math.floor(e)!==e||Math.floor(t)!==t||e>0xffffffffffff||t>0xffffffffffff?error.num:e&t},e.BITLSHIFT=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e<0||Math.floor(e)!==e||e>0xffffffffffff||Math.abs(t)>53?error.num:t>=0?e<<t:e>>-t},e.BITOR=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e<0||t<0||Math.floor(e)!==e||Math.floor(t)!==t||e>0xffffffffffff||t>0xffffffffffff?error.num:e|t},e.BITRSHIFT=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e<0||Math.floor(e)!==e||e>0xffffffffffff||Math.abs(t)>53?error.num:t>=0?e>>t:e<<-t},e.BITXOR=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e<0||t<0||Math.floor(e)!==e||Math.floor(t)!==t||e>0xffffffffffff||t>0xffffffffffff?error.num:e^t},e.COMPLEX=function(e,t,n){if(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t))return e;if("i"!==(n=void 0===n?"i":n)&&"j"!==n)return error.value;if(0===e&&0===t)return 0;if(0===e)return 1===t?n:t.toString()+n;if(0===t)return e.toString();var r=t>0?"+":"";return e.toString()+r+(1===t?n:t.toString()+n)},e.CONVERT=function(e,t,n){if((e=utils.parseNumber(e))instanceof Error)return e;for(var r,o=[["a.u. of action","?",null,"action",!1,!1,105457168181818e-48],["a.u. of charge","e",null,"electric_charge",!1,!1,160217653141414e-33],["a.u. of energy","Eh",null,"energy",!1,!1,435974417757576e-32],["a.u. of length","a?",null,"length",!1,!1,529177210818182e-25],["a.u. of mass","m?",null,"mass",!1,!1,910938261616162e-45],["a.u. of time","?/Eh",null,"time",!1,!1,241888432650516e-31],["admiralty knot","admkn",null,"speed",!1,!0,.514773333],["ampere","A",null,"electric_current",!0,!1,1],["ampere per meter","A/m",null,"magnetic_field_intensity",!0,!1,1],["ångström","Å",["ang"],"length",!1,!0,1e-10],["are","ar",null,"area",!1,!0,100],["astronomical unit","ua",null,"length",!1,!1,149597870691667e-25],["bar","bar",null,"pressure",!1,!1,1e5],["barn","b",null,"area",!1,!1,1e-28],["becquerel","Bq",null,"radioactivity",!0,!1,1],["bit","bit",["b"],"information",!1,!0,1],["btu","BTU",["btu"],"energy",!1,!0,1055.05585262],["byte","byte",null,"information",!1,!0,8],["candela","cd",null,"luminous_intensity",!0,!1,1],["candela per square metre","cd/m?",null,"luminance",!0,!1,1],["coulomb","C",null,"electric_charge",!0,!1,1],["cubic ångström","ang3",["ang^3"],"volume",!1,!0,1e-30],["cubic foot","ft3",["ft^3"],"volume",!1,!0,.028316846592],["cubic inch","in3",["in^3"],"volume",!1,!0,16387064e-12],["cubic light-year","ly3",["ly^3"],"volume",!1,!0,846786664623715e-61],["cubic metre","m?",null,"volume",!0,!0,1],["cubic mile","mi3",["mi^3"],"volume",!1,!0,4168181825.44058],["cubic nautical mile","Nmi3",["Nmi^3"],"volume",!1,!0,6352182208],["cubic Pica","Pica3",["Picapt3","Pica^3","Picapt^3"],"volume",!1,!0,7.58660370370369e-8],["cubic yard","yd3",["yd^3"],"volume",!1,!0,.764554857984],["cup","cup",null,"volume",!1,!0,.0002365882365],["dalton","Da",["u"],"mass",!1,!1,166053886282828e-41],["day","d",["day"],"time",!1,!0,86400],["degree","°",null,"angle",!1,!1,.0174532925199433],["degrees Rankine","Rank",null,"temperature",!1,!0,.555555555555556],["dyne","dyn",["dy"],"force",!1,!0,1e-5],["electronvolt","eV",["ev"],"energy",!1,!0,1.60217656514141],["ell","ell",null,"length",!1,!0,1.143],["erg","erg",["e"],"energy",!1,!0,1e-7],["farad","F",null,"electric_capacitance",!0,!1,1],["fluid ounce","oz",null,"volume",!1,!0,295735295625e-16],["foot","ft",null,"length",!1,!0,.3048],["foot-pound","flb",null,"energy",!1,!0,1.3558179483314],["gal","Gal",null,"acceleration",!1,!1,.01],["gallon","gal",null,"volume",!1,!0,.003785411784],["gauss","G",["ga"],"magnetic_flux_density",!1,!0,1],["grain","grain",null,"mass",!1,!0,647989e-10],["gram","g",null,"mass",!1,!0,.001],["gray","Gy",null,"absorbed_dose",!0,!1,1],["gross registered ton","GRT",["regton"],"volume",!1,!0,2.8316846592],["hectare","ha",null,"area",!1,!0,1e4],["henry","H",null,"inductance",!0,!1,1],["hertz","Hz",null,"frequency",!0,!1,1],["horsepower","HP",["h"],"power",!1,!0,745.69987158227],["horsepower-hour","HPh",["hh","hph"],"energy",!1,!0,2684519.538],["hour","h",["hr"],"time",!1,!0,3600],["imperial gallon (U.K.)","uk_gal",null,"volume",!1,!0,.00454609],["imperial hundredweight","lcwt",["uk_cwt","hweight"],"mass",!1,!0,50.802345],["imperial quart (U.K)","uk_qt",null,"volume",!1,!0,.0011365225],["imperial ton","brton",["uk_ton","LTON"],"mass",!1,!0,1016.046909],["inch","in",null,"length",!1,!0,.0254],["international acre","uk_acre",null,"area",!1,!0,4046.8564224],["IT calorie","cal",null,"energy",!1,!0,4.1868],["joule","J",null,"energy",!0,!0,1],["katal","kat",null,"catalytic_activity",!0,!1,1],["kelvin","K",["kel"],"temperature",!0,!0,1],["kilogram","kg",null,"mass",!0,!0,1],["knot","kn",null,"speed",!1,!0,.514444444444444],["light-year","ly",null,"length",!1,!0,9460730472580800],["litre","L",["l","lt"],"volume",!1,!0,.001],["lumen","lm",null,"luminous_flux",!0,!1,1],["lux","lx",null,"illuminance",!0,!1,1],["maxwell","Mx",null,"magnetic_flux",!1,!1,1e-18],["measurement ton","MTON",null,"volume",!1,!0,1.13267386368],["meter per hour","m/h",["m/hr"],"speed",!1,!0,.00027777777777778],["meter per second","m/s",["m/sec"],"speed",!0,!0,1],["meter per second squared","m?s??",null,"acceleration",!0,!1,1],["parsec","pc",["parsec"],"length",!1,!0,0x6da012f958ee1c],["meter squared per second","m?/s",null,"kinematic_viscosity",!0,!1,1],["metre","m",null,"length",!0,!0,1],["miles per hour","mph",null,"speed",!1,!0,.44704],["millimetre of mercury","mmHg",null,"pressure",!1,!1,133.322],["minute","?",null,"angle",!1,!1,.000290888208665722],["minute","min",["mn"],"time",!1,!0,60],["modern teaspoon","tspm",null,"volume",!1,!0,5e-6],["mole","mol",null,"amount_of_substance",!0,!1,1],["morgen","Morgen",null,"area",!1,!0,2500],["n.u. of action","?",null,"action",!1,!1,105457168181818e-48],["n.u. of mass","m?",null,"mass",!1,!1,910938261616162e-45],["n.u. of speed","c?",null,"speed",!1,!1,299792458],["n.u. of time","?/(me?c??)",null,"time",!1,!1,128808866778687e-35],["nautical mile","M",["Nmi"],"length",!1,!0,1852],["newton","N",null,"force",!0,!0,1],["œrsted","Oe ",null,"magnetic_field_intensity",!1,!1,79.5774715459477],["ohm","Ω",null,"electric_resistance",!0,!1,1],["ounce mass","ozm",null,"mass",!1,!0,.028349523125],["pascal","Pa",null,"pressure",!0,!1,1],["pascal second","Pa?s",null,"dynamic_viscosity",!0,!1,1],["pferdestärke","PS",null,"power",!1,!0,735.49875],["phot","ph",null,"illuminance",!1,!1,1e-4],["pica (1/6 inch)","pica",null,"length",!1,!0,.00035277777777778],["pica (1/72 inch)","Pica",["Picapt"],"length",!1,!0,.00423333333333333],["poise","P",null,"dynamic_viscosity",!1,!1,.1],["pond","pond",null,"force",!1,!0,.00980665],["pound force","lbf",null,"force",!1,!0,4.4482216152605],["pound mass","lbm",null,"mass",!1,!0,.45359237],["quart","qt",null,"volume",!1,!0,.000946352946],["radian","rad",null,"angle",!0,!1,1],["second","?",null,"angle",!1,!1,484813681109536e-20],["second","s",["sec"],"time",!0,!0,1],["short hundredweight","cwt",["shweight"],"mass",!1,!0,45.359237],["siemens","S",null,"electrical_conductance",!0,!1,1],["sievert","Sv",null,"equivalent_dose",!0,!1,1],["slug","sg",null,"mass",!1,!0,14.59390294],["square ångström","ang2",["ang^2"],"area",!1,!0,1e-20],["square foot","ft2",["ft^2"],"area",!1,!0,.09290304],["square inch","in2",["in^2"],"area",!1,!0,64516e-8],["square light-year","ly2",["ly^2"],"area",!1,!0,895054210748189e17],["square meter","m?",null,"area",!0,!0,1],["square mile","mi2",["mi^2"],"area",!1,!0,2589988.110336],["square nautical mile","Nmi2",["Nmi^2"],"area",!1,!0,3429904],["square Pica","Pica2",["Picapt2","Pica^2","Picapt^2"],"area",!1,!0,1792111111111e-17],["square yard","yd2",["yd^2"],"area",!1,!0,.83612736],["statute mile","mi",null,"length",!1,!0,1609.344],["steradian","sr",null,"solid_angle",!0,!1,1],["stilb","sb",null,"luminance",!1,!1,1e-4],["stokes","St",null,"kinematic_viscosity",!1,!1,1e-4],["stone","stone",null,"mass",!1,!0,6.35029318],["tablespoon","tbs",null,"volume",!1,!0,147868e-10],["teaspoon","tsp",null,"volume",!1,!0,492892e-11],["tesla","T",null,"magnetic_flux_density",!0,!0,1],["thermodynamic calorie","c",null,"energy",!1,!0,4.184],["ton","ton",null,"mass",!1,!0,907.18474],["tonne","t",null,"mass",!1,!1,1e3],["U.K. pint","uk_pt",null,"volume",!1,!0,.00056826125],["U.S. bushel","bushel",null,"volume",!1,!0,.03523907],["U.S. oil barrel","barrel",null,"volume",!1,!0,.158987295],["U.S. pint","pt",["us_pt"],"volume",!1,!0,.000473176473],["U.S. survey mile","survey_mi",null,"length",!1,!0,1609.347219],["U.S. survey/statute acre","us_acre",null,"area",!1,!0,4046.87261],["volt","V",null,"voltage",!0,!1,1],["watt","W",null,"power",!0,!0,1],["watt-hour","Wh",["wh"],"energy",!1,!0,3600],["weber","Wb",null,"magnetic_flux",!0,!1,1],["yard","yd",null,"length",!1,!0,.9144],["year","yr",null,"time",!1,!0,31557600]],i={Yi:["yobi",80,12089258196146292e8,"Yi","yotta"],Zi:["zebi",70,11805916207174113e5,"Zi","zetta"],Ei:["exbi",60,0x1000000000000000,"Ei","exa"],Pi:["pebi",50,0x4000000000000,"Pi","peta"],Ti:["tebi",40,1099511627776,"Ti","tera"],Gi:["gibi",30,1073741824,"Gi","giga"],Mi:["mebi",20,1048576,"Mi","mega"],ki:["kibi",10,1024,"ki","kilo"]},a={Y:["yotta",1e24,"Y"],Z:["zetta",1e21,"Z"],E:["exa",1e18,"E"],P:["peta",1e15,"P"],T:["tera",1e12,"T"],G:["giga",1e9,"G"],M:["mega",1e6,"M"],k:["kilo",1e3,"k"],h:["hecto",100,"h"],e:["dekao",10,"e"],d:["deci",.1,"d"],c:["centi",.01,"c"],m:["milli",.001,"m"],u:["micro",1e-6,"u"],n:["nano",1e-9,"n"],p:["pico",1e-12,"p"],f:["femto",1e-15,"f"],a:["atto",1e-18,"a"],z:["zepto",1e-21,"z"],y:["yocto",1e-24,"y"]},l=null,s=null,u=t,g=n,c=1,d=1,p=0;p<o.length;p++)r=null===o[p][2]?[]:o[p][2],(o[p][1]===u||r.indexOf(u)>=0)&&(l=o[p]),(o[p][1]===g||r.indexOf(g)>=0)&&(s=o[p]);if(null===l){var C=i[t.substring(0,2)],A=a[t.substring(0,1)];"da"===t.substring(0,2)&&(A=["dekao",10,"da"]),C?(c=C[2],u=t.substring(2)):A&&(c=A[1],u=t.substring(A[2].length));for(var I=0;I<o.length;I++)r=null===o[I][2]?[]:o[I][2],(o[I][1]===u||r.indexOf(u)>=0)&&(l=o[I])}if(null===s){var b=i[n.substring(0,2)],f=a[n.substring(0,1)];"da"===n.substring(0,2)&&(f=["dekao",10,"da"]),b?(d=b[2],g=n.substring(2)):f&&(d=f[1],g=n.substring(f[2].length));for(var h=0;h<o.length;h++)r=null===o[h][2]?[]:o[h][2],(o[h][1]===g||r.indexOf(g)>=0)&&(s=o[h])}return null===l||null===s||l[3]!==s[3]?error.na:e*l[6]*c/(s[6]*d)},e.DEC2BIN=function(e,t){if((e=utils.parseNumber(e))instanceof Error)return e;if(!/^-?[0-9]{1,3}$/.test(e)||e<-512||e>511)return error.num;if(e<0)return"1"+REPT("0",9-(512+e).toString(2).length)+(512+e).toString(2);var n=parseInt(e,10).toString(2);return void 0===t?n:isNaN(t)?error.value:t<0?error.num:(t=Math.floor(t))>=n.length?REPT("0",t-n.length)+n:error.num},e.DEC2HEX=function(e,t){if((e=utils.parseNumber(e))instanceof Error)return e;if(!/^-?[0-9]{1,12}$/.test(e)||e<-549755813888||e>549755813887)return error.num;if(e<0)return(1099511627776+e).toString(16);var n=parseInt(e,10).toString(16);return void 0===t?n:isNaN(t)?error.value:t<0?error.num:(t=Math.floor(t))>=n.length?REPT("0",t-n.length)+n:error.num},e.DEC2OCT=function(e,t){if((e=utils.parseNumber(e))instanceof Error)return e;if(!/^-?[0-9]{1,9}$/.test(e)||e<-536870912||e>536870911)return error.num;if(e<0)return(1073741824+e).toString(8);var n=parseInt(e,10).toString(8);return void 0===t?n:isNaN(t)?error.value:t<0?error.num:(t=Math.floor(t))>=n.length?REPT("0",t-n.length)+n:error.num},e.DELTA=function(e,t){return t=void 0===t?0:t,e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e===t?1:0},e.ERF=function(e,t){},e.ERF.PRECISE=function(){},e.ERFC=function(e){},e.ERFC.PRECISE=function(){},e.GESTEP=function(e,t){return t=t||0,e=utils.parseNumber(e),utils.anyIsError(t,e)?e:e>=t?1:0},e.HEX2BIN=function(e,t){if(!/^[0-9A-Fa-f]{1,10}$/.test(e))return error.num;var n=10===e.length&&"f"===e.substring(0,1).toLowerCase(),r=n?parseInt(e,16)-1099511627776:parseInt(e,16);if(r<-512||r>511)return error.num;if(n)return"1"+REPT("0",9-(512+r).toString(2).length)+(512+r).toString(2);var o=r.toString(2);return void 0===t?o:isNaN(t)?error.value:t<0?error.num:(t=Math.floor(t))>=o.length?REPT("0",t-o.length)+o:error.num},e.HEX2DEC=function(e){if(!/^[0-9A-Fa-f]{1,10}$/.test(e))return error.num;var t=parseInt(e,16);return t>=549755813888?t-1099511627776:t},e.HEX2OCT=function(e,t){if(!/^[0-9A-Fa-f]{1,10}$/.test(e))return error.num;var n=parseInt(e,16);if(n>536870911&&n<0xffe0000000)return error.num;if(n>=0xffe0000000)return(n-0xffc0000000).toString(8);var r=n.toString(8);return void 0===t?r:isNaN(t)?error.value:t<0?error.num:(t=Math.floor(t))>=r.length?REPT("0",t-r.length)+r:error.num},e.IMABS=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.value:Math.sqrt(Math.pow(n,2)+Math.pow(r,2))},e.IMAGINARY=function(e){if(void 0===e||!0===e||!1===e)return error.value;if(0===e||"0"===e)return 0;if(["i","j"].indexOf(e)>=0)return 1;var t=(e=e.replace("+i","+1i").replace("-i","-1i").replace("+j","+1j").replace("-j","-1j")).indexOf("+"),n=e.indexOf("-");0===t&&(t=e.indexOf("+",1)),0===n&&(n=e.indexOf("-",1));var r=e.substring(e.length-1,e.length),o="i"===r||"j"===r;return t>=0||n>=0?o?t>=0?isNaN(e.substring(0,t))||isNaN(e.substring(t+1,e.length-1))?error.num:Number(e.substring(t+1,e.length-1)):isNaN(e.substring(0,n))||isNaN(e.substring(n+1,e.length-1))?error.num:-Number(e.substring(n+1,e.length-1)):error.num:o?isNaN(e.substring(0,e.length-1))?error.num:e.substring(0,e.length-1):isNaN(e)?error.num:0},e.IMARGUMENT=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.value:0===n&&0===r?error.div0:0===n&&r>0?Math.PI/2:0===n&&r<0?-Math.PI/2:0===r&&n>0?0:0===r&&n<0?-Math.PI:n>0?Math.atan(r/n):n<0&&r>=0?Math.atan(r/n)+Math.PI:Math.atan(r/n)-Math.PI},e.IMCONJUGATE=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",0!==r?e.COMPLEX(n,-r,o):t},e.IMCOS=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",e.COMPLEX(Math.cos(n)*(Math.exp(r)+Math.exp(-r))/2,-Math.sin(n)*(Math.exp(r)-Math.exp(-r))/2,o)},e.IMCOSH=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",e.COMPLEX(Math.cos(r)*(Math.exp(n)+Math.exp(-n))/2,Math.sin(r)*(Math.exp(n)-Math.exp(-n))/2,o)},e.IMCOT=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.value:e.IMDIV(e.IMCOS(t),e.IMSIN(t))},e.IMDIV=function(t,n){var r=e.IMREAL(t),o=e.IMAGINARY(t),i=e.IMREAL(n),a=e.IMAGINARY(n);if(utils.anyIsError(r,o,i,a))return error.value;var l=t.substring(t.length-1),s=n.substring(n.length-1),u="i";if(("j"===l||"j"===s)&&(u="j"),0===i&&0===a)return error.num;var g=i*i+a*a;return e.COMPLEX((r*i+o*a)/g,(o*i-r*a)/g,u)},e.IMEXP=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);o="i"===o||"j"===o?o:"i";var i=Math.exp(n);return e.COMPLEX(i*Math.cos(r),i*Math.sin(r),o)},e.IMLN=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",e.COMPLEX(Math.log(Math.sqrt(n*n+r*r)),Math.atan(r/n),o)},e.IMLOG10=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",e.COMPLEX(Math.log(Math.sqrt(n*n+r*r))/Math.log(10),Math.atan(r/n)/Math.log(10),o)},e.IMLOG2=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",e.COMPLEX(Math.log(Math.sqrt(n*n+r*r))/Math.log(2),Math.atan(r/n)/Math.log(2),o)},e.IMPOWER=function(t,n){n=utils.parseNumber(n);var r=e.IMREAL(t),o=e.IMAGINARY(t);if(utils.anyIsError(n,r,o))return error.value;var i=t.substring(t.length-1);i="i"===i||"j"===i?i:"i";var a=Math.pow(e.IMABS(t),n),l=e.IMARGUMENT(t);return e.COMPLEX(a*Math.cos(n*l),a*Math.sin(n*l),i)},e.IMPRODUCT=function(){for(var t=arguments[0],n=1;n<arguments.length;n++){var r=e.IMREAL(t),o=e.IMAGINARY(t),i=e.IMREAL(arguments[n]),a=e.IMAGINARY(arguments[n]);if(utils.anyIsError(r,o,i,a))return error.value;t=e.COMPLEX(r*i-o*a,r*a+o*i)}return t},e.IMREAL=function(e){if(void 0===e||!0===e||!1===e)return error.value;if(0===e||"0"===e)return 0;if(["i","+i","1i","+1i","-i","-1i","j","+j","1j","+1j","-j","-1j"].indexOf(e)>=0)return 0;var t=e.indexOf("+"),n=e.indexOf("-");0===t&&(t=e.indexOf("+",1)),0===n&&(n=e.indexOf("-",1));var r=e.substring(e.length-1,e.length),o="i"===r||"j"===r;return t>=0||n>=0?o?t>=0?isNaN(e.substring(0,t))||isNaN(e.substring(t+1,e.length-1))?error.num:Number(e.substring(0,t)):isNaN(e.substring(0,n))||isNaN(e.substring(n+1,e.length-1))?error.num:Number(e.substring(0,n)):error.num:o?isNaN(e.substring(0,e.length-1))?error.num:0:isNaN(e)?error.num:e},e.IMSEC=function(t){if(!0===t||!1===t)return error.value;var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.value:e.IMDIV("1",e.IMCOS(t))},e.IMSECH=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.value:e.IMDIV("1",e.IMCOSH(t))},e.IMSIN=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",e.COMPLEX(Math.sin(n)*(Math.exp(r)+Math.exp(-r))/2,Math.cos(n)*(Math.exp(r)-Math.exp(-r))/2,o)},e.IMSINH=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);return o="i"===o||"j"===o?o:"i",e.COMPLEX(Math.cos(r)*(Math.exp(n)-Math.exp(-n))/2,Math.sin(r)*(Math.exp(n)+Math.exp(-n))/2,o)},e.IMSQRT=function(t){var n=e.IMREAL(t),r=e.IMAGINARY(t);if(utils.anyIsError(n,r))return error.value;var o=t.substring(t.length-1);o="i"===o||"j"===o?o:"i";var i=Math.sqrt(e.IMABS(t)),a=e.IMARGUMENT(t);return e.COMPLEX(i*Math.cos(a/2),i*Math.sin(a/2),o)},e.IMCSC=function(t){if(!0===t||!1===t)return error.value;var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.num:e.IMDIV("1",e.IMSIN(t))},e.IMCSCH=function(t){if(!0===t||!1===t)return error.value;var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.num:e.IMDIV("1",e.IMSINH(t))},e.IMSUB=function(e,t){var n=this.IMREAL(e),r=this.IMAGINARY(e),o=this.IMREAL(t),i=this.IMAGINARY(t);if(utils.anyIsError(n,r,o,i))return error.value;var a=e.substring(e.length-1),l=t.substring(t.length-1),s="i";return("j"===a||"j"===l)&&(s="j"),this.COMPLEX(n-o,r-i,s)},e.IMSUM=function(){for(var e=utils.flatten(arguments),t=e[0],n=1;n<e.length;n++){var r=this.IMREAL(t),o=this.IMAGINARY(t),i=this.IMREAL(e[n]),a=this.IMAGINARY(e[n]);if(utils.anyIsError(r,o,i,a))return error.value;t=this.COMPLEX(r+i,o+a)}return t},e.IMTAN=function(t){if(!0===t||!1===t)return error.value;var n=e.IMREAL(t),r=e.IMAGINARY(t);return utils.anyIsError(n,r)?error.value:this.IMDIV(this.IMSIN(t),this.IMCOS(t))},e.OCT2BIN=function(e,t){if(!/^[0-7]{1,10}$/.test(e))return error.num;var n=10===e.length&&"7"===e.substring(0,1),r=n?parseInt(e,8)-1073741824:parseInt(e,8);if(r<-512||r>511)return error.num;if(n)return"1"+REPT("0",9-(512+r).toString(2).length)+(512+r).toString(2);var o=r.toString(2);return void 0===t?o:isNaN(t)?error.value:t<0?error.num:(t=Math.floor(t))>=o.length?REPT("0",t-o.length)+o:error.num},e.OCT2DEC=function(e){if(!/^[0-7]{1,10}$/.test(e))return error.num;var t=parseInt(e,8);return t>=536870912?t-1073741824:t},e.OCT2HEX=function(e,t){if(!/^[0-7]{1,10}$/.test(e))return error.num;var n=parseInt(e,8);if(n>=536870912)return"ff"+(n+3221225472).toString(16);var r=n.toString(16);return void 0===t?r:isNaN(t)?error.value:t<0?error.num:(t=Math.floor(t))>=r.length?REPT("0",t-r.length)+r:error.num},e}(),jexcel.methods.financial=function(){var e={};function t(e){return e&&e.getTime&&!isNaN(e.getTime())}function n(e){return e instanceof Date?e:new Date(e)}return e.ACCRINT=function(e,r,o,i,a,l,s){return e=n(e),r=n(r),o=n(o),t(e)&&t(r)&&t(o)?i<=0||a<=0||-1===[1,2,4].indexOf(l)||-1===[0,1,2,3,4].indexOf(s)||o<=e?"#NUM!":(s=s||0,(a=a||0)*i*YEARFRAC(e,o,s)):"#VALUE!"},e.ACCRINTM=null,e.AMORDEGRC=null,e.AMORLINC=null,e.COUPDAYBS=null,e.COUPDAYS=null,e.COUPDAYSNC=null,e.COUPNCD=null,e.COUPNUM=null,e.COUPPCD=null,e.CUMIPMT=function(t,n,r,o,i,a){if(t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),utils.anyIsError(t,n,r))return error.value;if(t<=0||n<=0||r<=0)return error.num;if(o<1||i<1||o>i)return error.num;if(0!==a&&1!==a)return error.num;var l=e.PMT(t,n,r,0,a),s=0;1===o&&0===a&&(s=-r,o++);for(var u=o;u<=i;u++)s+=1===a?e.FV(t,u-2,l,r,1)-l:e.FV(t,u-1,l,r,0);return s*t},e.CUMPRINC=function(t,n,r,o,i,a){if(t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),utils.anyIsError(t,n,r))return error.value;if(t<=0||n<=0||r<=0)return error.num;if(o<1||i<1||o>i)return error.num;if(0!==a&&1!==a)return error.num;var l=e.PMT(t,n,r,0,a),s=0;1===o&&(s=0===a?l+r*t:l,o++);for(var u=o;u<=i;u++)s+=a>0?l-(e.FV(t,u-2,l,r,1)-l)*t:l-e.FV(t,u-1,l,r,0)*t;return s},e.DB=function(e,t,n,r,o){if(o=void 0===o?12:o,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),utils.anyIsError(e,t,n,r,o))return error.value;if(e<0||t<0||n<0||r<0)return error.num;if(-1===[1,2,3,4,5,6,7,8,9,10,11,12].indexOf(o))return error.num;if(r>n)return error.num;if(t>=e)return 0;for(var i=(1-Math.pow(t/e,1/n)).toFixed(3),a=e*i*o/12,l=a,s=0,u=r===n?n-1:r,g=2;g<=u;g++)l+=s=(e-l)*i;return 1===r?a:r===n?(e-l)*i:s},e.DDB=function(e,t,n,r,o){if(o=void 0===o?2:o,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),utils.anyIsError(e,t,n,r,o))return error.value;if(e<0||t<0||n<0||r<0||o<=0)return error.num;if(r>n)return error.num;if(t>=e)return 0;for(var i=0,a=0,l=1;l<=r;l++)i+=a=Math.min(o/n*(e-i),e-t-i);return a},e.DISC=null,e.DOLLARDE=function(e,t){if(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;if(t<0)return error.num;if(t>=0&&t<1)return error.div0;t=parseInt(t,10);var n=parseInt(e,10);n+=e%1*Math.pow(10,Math.ceil(Math.log(t)/Math.LN10))/t;var r=Math.pow(10,Math.ceil(Math.log(t)/Math.LN2)+1);return Math.round(n*r)/r},e.DOLLARFR=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:t<0?error.num:t>=0&&t<1?error.div0:(t=parseInt(t,10),parseInt(e,10)+e%1*Math.pow(10,-Math.ceil(Math.log(t)/Math.LN10))*t)},e.DURATION=null,e.EFFECT=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e<=0||t<1?error.num:(t=parseInt(t,10),Math.pow(1+e/t,t)-1)},e.FV=function(e,t,n,r,o){if(r=r||0,o=o||0,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),utils.anyIsError(e,t,n,r,o))return error.value;var i;if(0===e)i=r+n*t;else{var a=Math.pow(1+e,t);i=1===o?r*a+n*(1+e)*(a-1)/e:r*a+n*(a-1)/e}return-i},e.FVSCHEDULE=function(e,t){if(e=utils.parseNumber(e),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t))return error.value;for(var n=t.length,r=e,o=0;o<n;o++)r*=1+t[o];return r},e.INTRATE=null,e.IPMT=function(t,n,r,o,i,a){if(i=i||0,a=a||0,t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),i=utils.parseNumber(i),a=utils.parseNumber(a),utils.anyIsError(t,n,r,o,i,a))return error.value;var l=e.PMT(t,r,o,i,a);return(1===n?1===a?0:-o:1===a?e.FV(t,n-2,l,o,1)-l:e.FV(t,n-1,l,o,0))*t},e.IRR=function(e,t){if(t=t||0,e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;for(var n=function(e,t,n){for(var r=n+1,o=e[0],i=1;i<e.length;i++)o+=e[i]/Math.pow(r,(t[i]-t[0])/365);return o},r=function(e,t,n){for(var r=n+1,o=0,i=1;i<e.length;i++){var a=(t[i]-t[0])/365;o-=a*e[i]/Math.pow(r,a+1)}return o},o=[],i=!1,a=!1,l=0;l<e.length;l++)o[l]=0===l?0:o[l-1]+365,e[l]>0&&(i=!0),e[l]<0&&(a=!0);if(!i||!a)return error.num;var s,u,g,c=t=void 0===t?.1:t,d=!0;do{s=c-(g=n(e,o,c))/r(e,o,c),u=Math.abs(s-c),c=s,d=u>1e-10&&Math.abs(g)>1e-10}while(d);return c},e.ISPMT=function(e,t,n,r){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),utils.anyIsError(e,t,n,r)?error.value:r*e*(t/n-1)},e.MDURATION=null,e.MIRR=function(t,n,r){if(t=utils.parseNumberArray(utils.flatten(t)),n=utils.parseNumber(n),r=utils.parseNumber(r),utils.anyIsError(t,n,r))return error.value;for(var o=t.length,i=[],a=[],l=0;l<o;l++)t[l]<0?i.push(t[l]):a.push(t[l]);var s=-e.NPV(r,a)*Math.pow(1+r,o-1),u=e.NPV(n,i)*(1+n);return Math.pow(s/u,1/(o-1))-1},e.NOMINAL=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e<=0||t<1?error.num:(t=parseInt(t,10),(Math.pow(e+1,1/t)-1)*t)},e.NPER=function(e,t,n,r,o){if(o=void 0===o?0:o,r=void 0===r?0:r,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),utils.anyIsError(e,t,n,r,o))return error.value;var i=t*(1+e*o)-r*e,a=n*e+t*(1+e*o);return Math.log(i/a)/Math.log(1+e)},e.NPV=function(){var e=utils.parseNumberArray(utils.flatten(arguments));if(e instanceof Error)return e;for(var t=e[0],n=0,r=1;r<e.length;r++)n+=e[r]/Math.pow(1+t,r);return n},e.ODDFPRICE=null,e.ODDFYIELD=null,e.ODDLPRICE=null,e.ODDLYIELD=null,e.PDURATION=function(e,t,n){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:e<=0?error.num:(Math.log(n)-Math.log(t))/Math.log(1+e)},e.PMT=function(e,t,n,r,o){if(r=r||0,o=o||0,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),utils.anyIsError(e,t,n,r,o))return error.value;var i;if(0===e)i=(n+r)/t;else{var a=Math.pow(1+e,t);i=1===o?(r*e/(a-1)+n*e/(1-1/a))/(1+e):r*e/(a-1)+n*e/(1-1/a)}return-i},e.PPMT=function(t,n,r,o,i,a){return i=i||0,a=a||0,t=utils.parseNumber(t),r=utils.parseNumber(r),o=utils.parseNumber(o),i=utils.parseNumber(i),a=utils.parseNumber(a),utils.anyIsError(t,r,o,i,a)?error.value:e.PMT(t,r,o,i,a)-e.IPMT(t,n,r,o,i,a)},e.PRICE=null,e.PRICEDISC=null,e.PRICEMAT=null,e.PV=function(e,t,n,r,o){return r=r||0,o=o||0,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),utils.anyIsError(e,t,n,r,o)?error.value:0===e?-n*t-r:((1-Math.pow(1+e,t))/e*n*(1+e*o)-r)/Math.pow(1+e,t)},e.RATE=function(e,t,n,r,o,i){if(i=void 0===i?.01:i,r=void 0===r?0:r,o=void 0===o?0:o,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),o=utils.parseNumber(o),i=utils.parseNumber(i),utils.anyIsError(e,t,n,r,o,i))return error.value;for(var a=0,l=!1,s=i;a<100&&!l;){var u=Math.pow(s+1,e),g=Math.pow(s+1,e-1),c=s-(r+u*n+t*(u-1)*(s*o+1)/s)/(e*g*n-t*(u-1)*(s*o+1)/Math.pow(s,2)+(e*t*g*(s*o+1)/s+t*(u-1)*o/s));Math.abs(c-s)<1e-6&&(l=!0),a++,s=c}return l?s:Number.NaN+s},e.RECEIVED=null,e.RRI=function(e,t,n){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:0===e||0===t?error.num:Math.pow(n/t,1/e)-1},e.SLN=function(e,t,n){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:0===n?error.num:(e-t)/n},e.SYD=function(e,t,n,r){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumber(r),utils.anyIsError(e,t,n,r)?error.value:0===n||r<1||r>n?error.num:(e-t)*(n-(r=parseInt(r,10))+1)*2/(n*(n+1))},e.TBILLEQ=function(e,t,n){return e=utils.parseDate(e),t=utils.parseDate(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:n<=0||e>t||t-e>31536e6?error.num:365*n/(360-n*DAYS360(e,t,!1))},e.TBILLPRICE=function(e,t,n){return e=utils.parseDate(e),t=utils.parseDate(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:n<=0||e>t||t-e>31536e6?error.num:100*(1-n*DAYS360(e,t,!1)/360)},e.TBILLYIELD=function(e,t,n){return e=utils.parseDate(e),t=utils.parseDate(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:n<=0||e>t||t-e>31536e6?error.num:360*(100-n)/(n*DAYS360(e,t,!1))},e.VDB=null,e.XIRR=function(e,t,n){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseDateArray(utils.flatten(t)),n=utils.parseNumber(n),utils.anyIsError(e,t,n))return error.value;for(var r=function(e,t,n){for(var r=n+1,o=e[0],i=1;i<e.length;i++)o+=e[i]/Math.pow(r,DAYS(t[i],t[0])/365);return o},o=function(e,t,n){for(var r=n+1,o=0,i=1;i<e.length;i++){var a=DAYS(t[i],t[0])/365;o-=a*e[i]/Math.pow(r,a+1)}return o},i=!1,a=!1,l=0;l<e.length;l++)e[l]>0&&(i=!0),e[l]<0&&(a=!0);if(!i||!a)return error.num;var s,u,g,c=n=n||.1,d=!0;do{s=c-(g=r(e,t,c))/o(e,t,c),u=Math.abs(s-c),c=s,d=u>1e-10&&Math.abs(g)>1e-10}while(d);return c},e.XNPV=function(e,t,n){if(e=utils.parseNumber(e),t=utils.parseNumberArray(utils.flatten(t)),n=utils.parseDateArray(utils.flatten(n)),utils.anyIsError(e,t,n))return error.value;for(var r=0,o=0;o<t.length;o++)r+=t[o]/Math.pow(1+e,DAYS(n[o],n[0])/365);return r},e.YIELD=null,e.YIELDDISC=null,e.YIELDMAT=null,e}(),jexcel.methods.information=function(){var e={CELL:null,ERROR:{}};return e.ERROR.TYPE=function(e){switch(e){case error.nil:return 1;case error.div0:return 2;case error.value:return 3;case error.ref:return 4;case error.name:return 5;case error.num:return 6;case error.na:return 7;case error.data:return 8}return error.na},e.INFO=null,e.ISBLANK=function(e){return null===e},e.ISBINARY=function(e){return/^[01]{1,10}$/.test(e)},e.ISERR=function(e){return[error.value,error.ref,error.div0,error.num,error.name,error.nil].indexOf(e)>=0||"number"==typeof e&&(isNaN(e)||!isFinite(e))},e.ISERROR=function(t){return e.ISERR(t)||t===error.na},e.ISEVEN=function(e){return!(1&Math.floor(Math.abs(e)))},e.ISFORMULA=null,e.ISLOGICAL=function(e){return!0===e||!1===e},e.ISNA=function(e){return e===error.na},e.ISNONTEXT=function(e){return"string"!=typeof e},e.ISNUMBER=function(e){return"number"==typeof e&&!isNaN(e)&&isFinite(e)},e.ISODD=function(e){return!!(1&Math.floor(Math.abs(e)))},e.ISREF=null,e.ISTEXT=function(e){return"string"==typeof e},e.N=function(e){return this.ISNUMBER(e)?e:e instanceof Date?e.getTime():!0===e?1:!1===e?0:this.ISERROR(e)?e:0},e.NA=function(){return error.na},e.SHEET=null,e.SHEETS=null,e.TYPE=function(e){return this.ISNUMBER(e)?1:this.ISTEXT(e)?2:this.ISLOGICAL(e)?4:this.ISERROR(e)?16:Array.isArray(e)?64:void 0},e}(),jexcel.methods.logical={AND:function(){for(var e=utils.flatten(arguments),t=!0,n=0;n<e.length;n++)e[n]||(t=!1);return t},CHOOSE:function(){if(arguments.length<2)return error.na;var e=arguments[0];return e<1||e>254||arguments.length<e+1?error.value:arguments[e]},FALSE:function(){return!1},IF:function(e,t,n){return e?t:n},IFERROR:function(e,t){return ISERROR(e)?t:e},IFNA:function(e,t){return e===error.na?t:e},NOT:function(e){return!e},OR:function(){for(var e=utils.flatten(arguments),t=!1,n=0;n<e.length;n++)e[n]&&(t=!0);return t},TRUE:function(){return!0},XOR:function(){for(var e=utils.flatten(arguments),t=0,n=0;n<e.length;n++)e[n]&&t++;return!!(1&Math.floor(Math.abs(t)))},SWITCH:function(){var e;if(arguments.length>0){var t=arguments[0],n=arguments.length-1,r=Math.floor(n/2),o=!1,i=n%2==0?null:arguments[arguments.length-1];if(r)for(var a=0;a<r;a++)if(t===arguments[2*a+1]){e=arguments[2*a+2],o=!0;break}!o&&i&&(e=i)}return e}},jexcel.methods.math=function(){var exports={ABS:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.abs(utils.parseNumber(e))},ACOS:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.acos(e)},ACOSH:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.log(e+Math.sqrt(e*e-1))},ACOT:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.atan(1/e)},ACOTH:function(e){return(e=utils.parseNumber(e))instanceof Error?e:.5*Math.log((e+1)/(e-1))},AGGREGATE:null,ARABIC:function(e){if(!/^M*(?:D?C{0,3}|C[MD])(?:L?X{0,3}|X[CL])(?:V?I{0,3}|I[XV])$/.test(e))return error.value;var t=0;return e.replace(/[MDLV]|C[MD]?|X[CL]?|I[XV]?/g,(function(e){t+={M:1e3,CM:900,D:500,CD:400,C:100,XC:90,L:50,XL:40,X:10,IX:9,V:5,IV:4,I:1}[e]})),t},ASIN:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.asin(e)},ASINH:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.log(e+Math.sqrt(e*e+1))},ATAN:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.atan(e)},ATAN2:function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:Math.atan2(e,t)},ATANH:function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.log((1+e)/(1-e))/2},BASE:function(e,t,n){if(n=n||0,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n))return error.value;n=void 0===n?0:n;var r=e.toString(t);return new Array(Math.max(n+1-r.length,0)).join("0")+r},CEILING:function(e,t,n){return t=void 0===t?1:t,n=void 0===n?0:n,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:0===t?0:(t=Math.abs(t),e>=0?Math.ceil(e/t)*t:0===n?-1*Math.floor(Math.abs(e)/t)*t:-1*Math.ceil(Math.abs(e)/t)*t)}};exports.CEILING.MATH=exports.CEILING,exports.CEILING.PRECISE=exports.CEILING,exports.COMBIN=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:exports.FACT(e)/(exports.FACT(t)*exports.FACT(e-t))},exports.COMBINA=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:0===e&&0===t?1:exports.COMBIN(e+t-1,e-1)},exports.COS=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.cos(e)},exports.COSH=function(e){return(e=utils.parseNumber(e))instanceof Error?e:(Math.exp(e)+Math.exp(-e))/2},exports.COT=function(e){return(e=utils.parseNumber(e))instanceof Error?e:1/Math.tan(e)},exports.COTH=function(e){if((e=utils.parseNumber(e))instanceof Error)return e;var t=Math.exp(2*e);return(t+1)/(t-1)},exports.CSC=function(e){return(e=utils.parseNumber(e))instanceof Error?e:1/Math.sin(e)},exports.CSCH=function(e){return(e=utils.parseNumber(e))instanceof Error?e:2/(Math.exp(e)-Math.exp(-e))},exports.DECIMAL=function(e,t){return arguments.length<1?error.value:parseInt(e,t)},exports.DEGREES=function(e){return(e=utils.parseNumber(e))instanceof Error?e:180*e/Math.PI},exports.EVEN=function(e){return(e=utils.parseNumber(e))instanceof Error?e:exports.CEILING(e,-2,-1)},exports.EXP=Math.exp;var MEMOIZED_FACT=[];return exports.FACT=function(e){if((e=utils.parseNumber(e))instanceof Error)return e;var t=Math.floor(e);return 0===t||1===t?1:(MEMOIZED_FACT[t]>0||(MEMOIZED_FACT[t]=exports.FACT(t-1)*t),MEMOIZED_FACT[t])},exports.FACTDOUBLE=function(e){if((e=utils.parseNumber(e))instanceof Error)return e;var t=Math.floor(e);return t<=0?1:t*exports.FACTDOUBLE(t-2)},exports.FLOOR=function(e,t,n){return t=void 0===t?1:t,n=void 0===n?0:n,e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:0===t?0:(t=Math.abs(t),e>=0?Math.floor(e/t)*t:0===n?-1*Math.ceil(Math.abs(e)/t)*t:-1*Math.floor(Math.abs(e)/t)*t)},exports.FLOOR.MATH=exports.FLOOR,exports.GCD=null,exports.INT=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.floor(e)},exports.LCM=function(){var e=utils.parseNumberArray(utils.flatten(arguments));if(e instanceof Error)return e;for(var t,n,r,o,i=1;void 0!==(r=e.pop());)for(;r>1;){if(r%2){for(t=3,n=Math.floor(Math.sqrt(r));t<=n&&r%t;t+=2);o=t<=n?t:r}else o=2;for(r/=o,i*=o,t=e.length;t;e[--t]%o==0&&1==(e[t]/=o)&&e.splice(t,1));}return i},exports.LN=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.log(e)},exports.LOG=function(e,t){return e=utils.parseNumber(e),t=void 0===t?10:utils.parseNumber(t),utils.anyIsError(e,t)?error.value:Math.log(e)/Math.log(t)},exports.LOG10=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.log(e)/Math.log(10)},exports.MDETERM=null,exports.MINVERSE=null,exports.MMULT=null,exports.MOD=function(e,t){if(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;if(0===t)return error.div0;var n=Math.abs(e%t);return t>0?n:-n},exports.MROUND=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e*t<0?error.num:Math.round(e/t)*t},exports.MULTINOMIAL=function(){var e=utils.parseNumberArray(utils.flatten(arguments));if(e instanceof Error)return e;for(var t=0,n=1,r=0;r<e.length;r++)t+=e[r],n*=exports.FACT(e[r]);return exports.FACT(t)/n},exports.MUNIT=null,exports.ODD=function(e){if((e=utils.parseNumber(e))instanceof Error)return e;var t=Math.ceil(Math.abs(e));return t=1&t?t:t+1,e>0?t:-t},exports.PI=function(){return Math.PI},exports.POWER=function(e,t){if(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;var n=Math.pow(e,t);return isNaN(n)?error.num:n},exports.PRODUCT=function(){var e=utils.parseNumberArray(utils.flatten(arguments));if(e instanceof Error)return e;for(var t=1,n=0;n<e.length;n++)t*=e[n];return t},exports.QUOTIENT=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:parseInt(e/t,10)},exports.RADIANS=function(e){return(e=utils.parseNumber(e))instanceof Error?e:e*Math.PI/180},exports.RAND=function(){return Math.random()},exports.RANDBETWEEN=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e+Math.ceil((t-e+1)*Math.random())-1},exports.ROMAN=null,exports.ROUND=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:Math.round(e*Math.pow(10,t))/Math.pow(10,t)},exports.ROUNDDOWN=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:(e>0?1:-1)*Math.floor(Math.abs(e)*Math.pow(10,t))/Math.pow(10,t)},exports.ROUNDUP=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:(e>0?1:-1)*Math.ceil(Math.abs(e)*Math.pow(10,t))/Math.pow(10,t)},exports.SEC=function(e){return(e=utils.parseNumber(e))instanceof Error?e:1/Math.cos(e)},exports.SECH=function(e){return(e=utils.parseNumber(e))instanceof Error?e:2/(Math.exp(e)+Math.exp(-e))},exports.SERIESSUM=function(e,t,n,r){if(e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),r=utils.parseNumberArray(r),utils.anyIsError(e,t,n,r))return error.value;for(var o=r[0]*Math.pow(e,t),i=1;i<r.length;i++)o+=r[i]*Math.pow(e,t+i*n);return o},exports.SIGN=function(e){return(e=utils.parseNumber(e))instanceof Error?e:e<0?-1:0===e?0:1},exports.SIN=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.sin(e)},exports.SINH=function(e){return(e=utils.parseNumber(e))instanceof Error?e:(Math.exp(e)-Math.exp(-e))/2},exports.SQRT=function(e){return(e=utils.parseNumber(e))instanceof Error?e:e<0?error.num:Math.sqrt(e)},exports.SQRTPI=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.sqrt(e*Math.PI)},exports.SUBTOTAL=null,exports.ADD=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e+t)},exports.MINUS=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e-t)},exports.DIVIDE=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:0===t?error.div0:e/t)},exports.MULTIPLY=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:e*t)},exports.GTE=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.error:e>=t)},exports.LT=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.error:e<t)},exports.LTE=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.error:e<=t)},exports.EQ=function(e,t){return 2!==arguments.length?error.na:e===t},exports.NE=function(e,t){return 2!==arguments.length?error.na:e!==t},exports.POW=function(e,t){return 2!==arguments.length?error.na:(e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.error:exports.POWER(e,t))},exports.SUM=function(){for(var e=0,t=Object.keys(arguments),n=0;n<t.length;++n){var r=arguments[t[n]];if("number"==typeof r)e+=r;else if("string"==typeof r){var o=parseFloat(r);!isNaN(o)&&(e+=o)}else Array.isArray(r)&&(e+=exports.SUM.apply(null,r))}return e},exports.SUMIF=function(range,criteria){if(range=utils.parseNumberArray(utils.flatten(range)),range instanceof Error)return range;for(var result=0,i=0;i<range.length;i++)result+=eval(range[i]+criteria)?range[i]:0;return result},exports.SUMIFS=function(){var args=utils.argsToArray(arguments),range=utils.parseNumberArray(utils.flatten(args.shift()));if(range instanceof Error)return range;for(var criteria=args,n_range_elements=range.length,n_criterias=criteria.length,result=0,i=0;i<n_range_elements;i++){for(var el=range[i],condition="",c=0;c<n_criterias;c++)condition+=el+criteria[c],c!==n_criterias-1&&(condition+="&&");eval(condition)&&(result+=el)}return result},exports.SUMPRODUCT=null,exports.SUMSQ=function(){var e=utils.parseNumberArray(utils.flatten(arguments));if(e instanceof Error)return e;for(var t=0,n=e.length,r=0;r<n;r++)t+=ISNUMBER(e[r])?e[r]*e[r]:0;return t},exports.SUMX2MY2=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t))return error.value;for(var n=0,r=0;r<e.length;r++)n+=e[r]*e[r]-t[r]*t[r];return n},exports.SUMX2PY2=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t))return error.value;var n=0;e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumberArray(utils.flatten(t));for(var r=0;r<e.length;r++)n+=e[r]*e[r]+t[r]*t[r];return n},exports.SUMXMY2=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t))return error.value;var n=0;e=utils.flatten(e),t=utils.flatten(t);for(var r=0;r<e.length;r++)n+=Math.pow(e[r]-t[r],2);return n},exports.TAN=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.tan(e)},exports.TANH=function(e){if((e=utils.parseNumber(e))instanceof Error)return e;var t=Math.exp(2*e);return(t-1)/(t+1)},exports.TRUNC=function(e,t){return t=void 0===t?0:t,e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:(e>0?1:-1)*Math.floor(Math.abs(e)*Math.pow(10,t))/Math.pow(10,t)},exports}(),jexcel.methods.misc=function(){var e={UNIQUE:function(){for(var e=[],t=0;t<arguments.length;++t){for(var n=!1,r=arguments[t],o=0;o<e.length&&!(n=e[o]===r);++o);n||e.push(r)}return e}};return e.FLATTEN=utils.flatten,e.ARGS2ARRAY=function(){return Array.prototype.slice.call(arguments,0)},e.REFERENCE=function(e,t){try{for(var n=t.split("."),r=e,o=0;o<n.length;++o){var i=n[o];if("]"===i[i.length-1]){var a=i.indexOf("["),l=i.substring(a+1,i.length-1);r=r[i.substring(0,a)][l]}else r=r[i]}return r}catch(e){}},e.JOIN=function(e,t){return e.join(t)},e.NUMBERS=function(){var e=utils.flatten(arguments);return e.filter((function(e){return"number"==typeof e}))},e.NUMERAL=null,e}(),jexcel.methods.text=function(){var e={ASC:null,BAHTTEXT:null,CHAR:function(e){return(e=utils.parseNumber(e))instanceof Error?e:String.fromCharCode(e)},CLEAN:function(e){return(e=e||"").replace(/[\0-\x1F]/g,"")},CODE:function(e){return(e=e||"").charCodeAt(0)},CONCATENATE:function(){for(var e=utils.flatten(arguments),t=0;(t=e.indexOf(!0))>-1;)e[t]="TRUE";for(var n=0;(n=e.indexOf(!1))>-1;)e[n]="FALSE";return e.join("")},DBCS:null,DOLLAR:null,EXACT:function(e,t){return e===t},FIND:function(e,t,n){return n=void 0===n?0:n,t?t.indexOf(e,n-1)+1:null},FIXED:null,HTML2TEXT:function(e){var t="";return e&&(e instanceof Array?e.forEach((function(e){""!==t&&(t+="\n"),t+=e.replace(/<(?:.|\n)*?>/gm,"")})):t=e.replace(/<(?:.|\n)*?>/gm,"")),t},LEFT:function(e,t){return t=void 0===t?1:t,(t=utils.parseNumber(t))instanceof Error||"string"!=typeof e?error.value:e?e.substring(0,t):null},LEN:function(e){return 0===arguments.length?error.error:"string"==typeof e?e?e.length:0:e.length?e.length:error.value},LOWER:function(e){return"string"!=typeof e?error.value:e?e.toLowerCase():e},MID:function(e,t,n){if(t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(t,n)||"string"!=typeof e)return n;var r=t-1,o=r+n;return e.substring(r,o)},NUMBERVALUE:null,PRONETIC:null,PROPER:function(e){return void 0===e||0===e.length?error.value:(!0===e&&(e="TRUE"),!1===e&&(e="FALSE"),isNaN(e)&&"number"==typeof e?error.value:("number"==typeof e&&(e=""+e),e.replace(/\w\S*/g,(function(e){return e.charAt(0).toUpperCase()+e.substr(1).toLowerCase()}))))},REGEXEXTRACT:function(e,t){var n=e.match(new RegExp(t));return n?n[n.length>1?n.length-1:0]:null},REGEXMATCH:function(e,t,n){var r=e.match(new RegExp(t));return n?r:!!r},REGEXREPLACE:function(e,t,n){return e.replace(new RegExp(t),n)},REPLACE:function(e,t,n,r){return t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(t,n)||"string"!=typeof e||"string"!=typeof r?error.value:e.substr(0,t-1)+r+e.substr(t-1+n)},REPT:function(e,t){return(t=utils.parseNumber(t))instanceof Error?t:new Array(t+1).join(e)},RIGHT:function(e,t){return t=void 0===t?1:t,(t=utils.parseNumber(t))instanceof Error?t:e?e.substring(e.length-t):null},SEARCH:function(e,t,n){var r;return"string"!=typeof e||"string"!=typeof t?error.value:(n=void 0===n?0:n,0===(r=t.toLowerCase().indexOf(e.toLowerCase(),n-1)+1)?error.value:r)},SPLIT:function(e,t){return e.split(t)},SUBSTITUTE:function(e,t,n,r){if(!(e&&t&&n))return e;if(void 0===r)return e.replace(new RegExp(t,"g"),n);for(var o=0,i=0;e.indexOf(t,o)>0;)if(o=e.indexOf(t,o+1),++i===r)return e.substring(0,o)+n+e.substring(o+t.length)},T:function(e){return"string"==typeof e?e:""},TEXT:null,TRIM:function(e){return"string"!=typeof e?error.value:e.replace(/ +/g," ").trim()}};return e.UNICHAR=e.CHAR,e.UNICODE=e.CODE,e.UPPER=function(e){return"string"!=typeof e?error.value:e.toUpperCase()},e.VALUE=null,e}(),jexcel.methods.stats=function(){var exports={},SQRT2PI=2.5066282746310002;return exports.AVEDEV=null,exports.AVERAGE=function(){for(var e=utils.numbers(utils.flatten(arguments)),t=e.length,n=0,r=0,o=0;o<t;o++)n+=e[o],r+=1;return n/r},exports.AVERAGEA=function(){for(var e=utils.flatten(arguments),t=e.length,n=0,r=0,o=0;o<t;o++){var i=e[o];"number"==typeof i&&(n+=i),!0===i&&n++,null!==i&&r++}return n/r},exports.AVERAGEIF=function(range,criteria,average_range){if(average_range=average_range||range,range=utils.flatten(range),average_range=utils.parseNumberArray(utils.flatten(average_range)),average_range instanceof Error)return average_range;for(var average_count=0,result=0,i=0;i<range.length;i++)eval(range[i]+criteria)&&(result+=average_range[i],average_count++);return result/average_count},exports.AVERAGEIFS=null,exports.COUNT=function(){return utils.numbers(utils.flatten(arguments)).length},exports.COUNTA=function(){var e=utils.flatten(arguments);return e.length-exports.COUNTBLANK(e)},exports.COUNTIN=function(e,t){for(var n=0,r=0;r<e.length;r++)e[r]===t&&n++;return n},exports.COUNTBLANK=function(){for(var e,t=utils.flatten(arguments),n=0,r=0;r<t.length;r++)null!==(e=t[r])&&""!==e||n++;return n},exports.COUNTIF=function(range,criteria){range=utils.flatten(range),/[<>=!]/.test(criteria)||(criteria='=="'+criteria+'"');for(var matches=0,i=0;i<range.length;i++)"string"!=typeof range[i]?eval(range[i]+criteria)&&matches++:eval('"'+range[i]+'"'+criteria)&&matches++;return matches},exports.COUNTIFS=function(){for(var args=utils.argsToArray(arguments),results=new Array(utils.flatten(args[0]).length),i=0;i<results.length;i++)results[i]=!0;for(i=0;i<args.length;i+=2){var range=utils.flatten(args[i]),criteria=args[i+1];/[<>=!]/.test(criteria)||(criteria='=="'+criteria+'"');for(var j=0;j<range.length;j++)"string"!=typeof range[j]?results[j]=results[j]&&eval(range[j]+criteria):results[j]=results[j]&&eval('"'+range[j]+'"'+criteria)}var result=0;for(i=0;i<results.length;i++)results[i]&&result++;return result},exports.COUNTUNIQUE=function(){return UNIQUE.apply(null,utils.flatten(arguments)).length},exports.FISHER=function(e){return(e=utils.parseNumber(e))instanceof Error?e:Math.log((1+e)/(1-e))/2},exports.FISHERINV=function(e){if((e=utils.parseNumber(e))instanceof Error)return e;var t=Math.exp(2*e);return(t-1)/(t+1)},exports.FREQUENCY=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t))return error.value;for(var n=e.length,r=t.length,o=[],i=0;i<=r;i++){o[i]=0;for(var a=0;a<n;a++)0===i?e[a]<=t[0]&&(o[0]+=1):i<r?e[a]>t[i-1]&&e[a]<=t[i]&&(o[i]+=1):i===r&&e[a]>t[r-1]&&(o[r]+=1)}return o},exports.LARGE=function(e,t){return e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t)?e:e.sort((function(e,t){return t-e}))[t-1]},exports.MAX=function(){var e=utils.numbers(utils.flatten(arguments));return 0===e.length?0:Math.max.apply(Math,e)},exports.MAXA=function(){var e=utils.arrayValuesToNumbers(utils.flatten(arguments));return 0===e.length?0:Math.max.apply(Math,e)},exports.MIN=function(){var e=utils.numbers(utils.flatten(arguments));return 0===e.length?0:Math.min.apply(Math,e)},exports.MINA=function(){var e=utils.arrayValuesToNumbers(utils.flatten(arguments));return 0===e.length?0:Math.min.apply(Math,e)},exports.MODE={},exports.MODE.MULT=function(){var e=utils.parseNumberArray(utils.flatten(arguments));if(e instanceof Error)return e;for(var t,n=e.length,r={},o=[],i=0,a=0;a<n;a++)r[t=e[a]]=r[t]?r[t]+1:1,r[t]>i&&(i=r[t],o=[]),r[t]===i&&(o[o.length]=t);return o},exports.MODE.SNGL=function(){var e=utils.parseNumberArray(utils.flatten(arguments));return e instanceof Error?e:exports.MODE.MULT(e).sort((function(e,t){return e-t}))[0]},exports.PERCENTILE={},exports.PERCENTILE.EXC=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;var n=(e=e.sort((function(e,t){return e-t}))).length;if(t<1/(n+1)||t>1-1/(n+1))return error.num;var r=t*(n+1)-1,o=Math.floor(r);return utils.cleanFloat(r===o?e[r]:e[o]+(r-o)*(e[o+1]-e[o]))},exports.PERCENTILE.INC=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;var n=t*((e=e.sort((function(e,t){return e-t}))).length-1),r=Math.floor(n);return utils.cleanFloat(n===r?e[n]:e[r]+(n-r)*(e[r+1]-e[r]))},exports.PERCENTRANK={},exports.PERCENTRANK.EXC=function(e,t,n){if(n=void 0===n?3:n,e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n))return error.value;e=e.sort((function(e,t){return e-t}));for(var r=UNIQUE.apply(null,e),o=e.length,i=r.length,a=Math.pow(10,n),l=0,s=!1,u=0;!s&&u<i;)t===r[u]?(l=(e.indexOf(r[u])+1)/(o+1),s=!0):t>=r[u]&&(t<r[u+1]||u===i-1)&&(l=(e.indexOf(r[u])+1+(t-r[u])/(r[u+1]-r[u]))/(o+1),s=!0),u++;return Math.floor(l*a)/a},exports.PERCENTRANK.INC=function(e,t,n){if(n=void 0===n?3:n,e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n))return error.value;e=e.sort((function(e,t){return e-t}));for(var r=UNIQUE.apply(null,e),o=e.length,i=r.length,a=Math.pow(10,n),l=0,s=!1,u=0;!s&&u<i;)t===r[u]?(l=e.indexOf(r[u])/(o-1),s=!0):t>=r[u]&&(t<r[u+1]||u===i-1)&&(l=(e.indexOf(r[u])+(t-r[u])/(r[u+1]-r[u]))/(o-1),s=!0),u++;return Math.floor(l*a)/a},exports.PERMUT=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:FACT(e)/FACT(e-t)},exports.PERMUTATIONA=function(e,t){return e=utils.parseNumber(e),t=utils.parseNumber(t),utils.anyIsError(e,t)?error.value:Math.pow(e,t)},exports.PHI=function(e){return(e=utils.parseNumber(e))instanceof Error?error.value:Math.exp(-.5*e*e)/SQRT2PI},exports.PROB=function(e,t,n,r){if(void 0===n)return 0;if(r=void 0===r?n:r,e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumberArray(utils.flatten(t)),n=utils.parseNumber(n),r=utils.parseNumber(r),utils.anyIsError(e,t,n,r))return error.value;if(n===r)return e.indexOf(n)>=0?t[e.indexOf(n)]:0;for(var o=e.sort((function(e,t){return e-t})),i=o.length,a=0,l=0;l<i;l++)o[l]>=n&&o[l]<=r&&(a+=t[e.indexOf(o[l])]);return a},exports.QUARTILE={},exports.QUARTILE.EXC=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;switch(t){case 1:return exports.PERCENTILE.EXC(e,.25);case 2:return exports.PERCENTILE.EXC(e,.5);case 3:return exports.PERCENTILE.EXC(e,.75);default:return error.num}},exports.QUARTILE.INC=function(e,t){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;switch(t){case 1:return exports.PERCENTILE.INC(e,.25);case 2:return exports.PERCENTILE.INC(e,.5);case 3:return exports.PERCENTILE.INC(e,.75);default:return error.num}},exports.RANK={},exports.RANK.AVG=function(e,t,n){if(e=utils.parseNumber(e),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t))return error.value;for(var r=(n=n||!1)?function(e,t){return e-t}:function(e,t){return t-e},o=(t=(t=utils.flatten(t)).sort(r)).length,i=0,a=0;a<o;a++)t[a]===e&&i++;return i>1?(2*t.indexOf(e)+i+1)/2:t.indexOf(e)+1},exports.RANK.EQ=function(e,t,n){if(e=utils.parseNumber(e),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t))return error.value;var r=(n=n||!1)?function(e,t){return e-t}:function(e,t){return t-e};return(t=t.sort(r)).indexOf(e)+1},exports.RSQ=function(e,t){return e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumberArray(utils.flatten(t)),utils.anyIsError(e,t)?error.value:Math.pow(exports.PEARSON(e,t),2)},exports.SMALL=function(e,t){return e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t)?e:e.sort((function(e,t){return e-t}))[t-1]},exports.STANDARDIZE=function(e,t,n){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:(e-t)/n},exports.STDEV={},exports.STDEV.P=function(){var e=exports.VAR.P.apply(this,arguments);return Math.sqrt(e)},exports.STDEV.S=function(){var e=exports.VAR.S.apply(this,arguments);return Math.sqrt(e)},exports.STDEVA=function(){var e=exports.VARA.apply(this,arguments);return Math.sqrt(e)},exports.STDEVPA=function(){var e=exports.VARPA.apply(this,arguments);return Math.sqrt(e)},exports.VAR={},exports.VAR.P=function(){for(var e=utils.numbers(utils.flatten(arguments)),t=e.length,n=0,r=exports.AVERAGE(e),o=0;o<t;o++)n+=Math.pow(e[o]-r,2);return n/t},exports.VAR.S=function(){for(var e=utils.numbers(utils.flatten(arguments)),t=e.length,n=0,r=exports.AVERAGE(e),o=0;o<t;o++)n+=Math.pow(e[o]-r,2);return n/(t-1)},exports.VARA=function(){for(var e=utils.flatten(arguments),t=e.length,n=0,r=0,o=exports.AVERAGEA(e),i=0;i<t;i++){var a=e[i];n+="number"==typeof a?Math.pow(a-o,2):!0===a?Math.pow(1-o,2):Math.pow(0-o,2),null!==a&&r++}return n/(r-1)},exports.VARPA=function(){for(var e=utils.flatten(arguments),t=e.length,n=0,r=0,o=exports.AVERAGEA(e),i=0;i<t;i++){var a=e[i];n+="number"==typeof a?Math.pow(a-o,2):!0===a?Math.pow(1-o,2):Math.pow(0-o,2),null!==a&&r++}return n/r},exports.WEIBULL={},exports.WEIBULL.DIST=function(e,t,n,r){return e=utils.parseNumber(e),t=utils.parseNumber(t),n=utils.parseNumber(n),utils.anyIsError(e,t,n)?error.value:r?1-Math.exp(-Math.pow(e/n,t)):Math.pow(e,t-1)*Math.exp(-Math.pow(e/n,t))*t/Math.pow(n,t)},exports.Z={},exports.Z.TEST=function(e,t,n){if(e=utils.parseNumberArray(utils.flatten(e)),t=utils.parseNumber(t),utils.anyIsError(e,t))return error.value;n=n||exports.STDEV.S(e);var r=e.length;return 1-exports.NORM.S.DIST((exports.AVERAGE(e)-t)/(n/Math.sqrt(r)),!0)},exports}(),jexcel.methods.utils={PROGRESS:function(e,t){return'<div style="width:'+(e||"0")+"%;height:4px;background-color:"+(t||"red")+';margin-top:1px;"></div>'},RATING:function(e){for(var t='<div class="jrating">',n=0;n<5;n++)t+=n<e?'<div class="jrating-selected"></div>':"<div></div>";return t+"</div>"}};for(var i=0;i<Object.keys(jexcel.methods).length;i++)for(var methods=jexcel.methods[Object.keys(jexcel.methods)[i]],j=0;j<Object.keys(methods).length;j++)"function"==typeof methods[Object.keys(methods)[j]]?window[Object.keys(methods)[j]]=methods[Object.keys(methods)[j]]:window[Object.keys(methods)[j]]=function(){return Object.keys(methods)[j]+"Not implemented"};return jexcel},module.exports=factory()},551:function(module){var factory;factory=function(){"use strict";var jSuites=function(e){var t={init:function(){var e=document.querySelector(".japp");t.el=e||document.body;for(var n=document.querySelectorAll("[data-autoload]"),r=0;r<n.length;r++){var o=n[r].getAttribute("data-autoload");"function"==typeof window[o]&&window[o](n[r])}},guid:function(){for(var e="",t=0;t<32;t++)e+=Math.floor(15*Math.random()).toString(15);return e},getWindowWidth:function(){var e=window,t=document,n=t.documentElement,r=t.getElementsByTagName("body")[0];return e.innerWidth||n.clientWidth||r.clientWidth},getWindowHeight:function(){var e=window,t=document,n=t.documentElement,r=t.getElementsByTagName("body")[0];return e.innerHeight||n.clientHeight||r.clientHeight},getPosition:function(e){if(e.changedTouches&&e.changedTouches[0])var t=e.changedTouches[0].pageX,n=e.changedTouches[0].pageY;else t=window.Event?e.pageX:e.clientX+(document.documentElement.scrollLeft?document.documentElement.scrollLeft:document.body.scrollLeft),n=window.Event?e.pageY:e.clientY+(document.documentElement.scrollTop?document.documentElement.scrollTop:document.body.scrollTop);return[t,n]},click:function(e){if(e.click)e.click();else{var t=new MouseEvent("click",{bubbles:!0,cancelable:!0,view:window});e.dispatchEvent(t)}},getElement:function(e,t){var n=!1;return function e(r){r.className&&r.classList.contains(t)&&(n=r),r.parentNode&&e(r.parentNode)}(e),n},getLinkElement:function(e){var t=!1;return function e(n){"A"!=n.tagName&&"DIV"!=n.tagName||!n.getAttribute("data-href")||(t=n),n.parentNode&&e(n.parentNode)}(e),t},getFormElements:function(e){var t={};if(e)var n=e.querySelectorAll("input, select, textarea");else n=document.querySelectorAll("input, select, textarea");for(var r=0;r<n.length;r++){var o=n[r],i=o.name,a=o.value;i&&(t[i]=a)}return t},exists:function(e,t){var n=new XMLHttpRequest;n.open("HEAD",e,!1),n.send(),n.status&&t(n.status)},getFiles:function(e){e||console.error("No element defined in the arguments of your method");var t=e.querySelectorAll(".jfile");if(t.length>0){for(var n=[],r=0;r<t.length;r++){var o={},i=t[r].getAttribute("src");t[r].classList.contains("jremove")?o.remove=1:("data"==i.substr(0,4)?(o.content=i.substr(i.indexOf(",")+1),o.extension=t[r].getAttribute("data-extension")):(o.file=i,o.extension=t[r].getAttribute("data-extension"),o.extension||(o.extension=i.substr(i.lastIndexOf(".")+1)),jSuites.files[o.file]&&(o.content=jSuites.files[o.file])),t[r].getAttribute("data-name")&&(o.name=t[r].getAttribute("data-name")),t[r].getAttribute("data-file")&&(o.file=t[r].getAttribute("data-file")),t[r].getAttribute("data-size")&&(o.size=t[r].getAttribute("data-size")),t[r].getAttribute("data-date")&&(o.date=t[r].getAttribute("data-date")),t[r].getAttribute("data-cover")&&(o.cover=t[r].getAttribute("data-cover"))),n[r]=o}return n}},ajax:function(e){if(e.data||(e.data={}),e.type&&(e.method=e.type),e.data){var n=[],r=Object.keys(e.data);if(r.length)for(var o=0;o<r.length;o++)if("object"==typeof e.data[r[o]])for(var i=e.data[r[o]],a=0;a<i.length;a++)if("string"==typeof i[a])n.push(r[o]+"["+a+"]="+encodeURIComponent(i[a]));else for(var l=Object.keys(i[a]),s=0;s<l.length;s++)n.push(r[o]+"["+a+"]["+l[s]+"]="+encodeURIComponent(i[a][l[s]]));else n.push(r[o]+"="+encodeURIComponent(e.data[r[o]]));"GET"==e.method&&n.length>0&&(e.url.indexOf("?")<0&&(e.url+="?"),e.url+=n.join("&"))}var u=new XMLHttpRequest;return u.open(e.method,e.url,!0),u.setRequestHeader("X-Requested-With","XMLHttpRequest"),"POST"==e.method?(u.setRequestHeader("Accept","application/json"),u.setRequestHeader("Content-Type","application/x-www-form-urlencoded")):"json"==e.dataType&&u.setRequestHeader("Content-Type","text/json"),1!=e.cache&&(u.setRequestHeader("pragma","no-cache"),u.setRequestHeader("cache-control","no-cache")),1==e.withCredentials&&(u.withCredentials=!0),"function"==typeof e.beforeSend&&e.beforeSend(u),u.onload=function(){if(200===u.status)if("json"==e.dataType)try{var n=JSON.parse(u.responseText);e.success&&"function"==typeof e.success&&e.success(n)}catch(t){e.error&&"function"==typeof e.error&&e.error(n)}else n=u.responseText,e.success&&"function"==typeof e.success&&e.success(n);else e.error&&"function"==typeof e.error&&e.error(u.responseText);if(t.ajax.requests&&t.ajax.requests.length){var r=t.ajax.requests.indexOf(u);t.ajax.requests.splice(r,1),t.ajax.requests.length||e.complete&&"function"==typeof e.complete&&e.complete(n)}},n?u.send(n.join("&")):u.send(),t.ajax.requests.push(u),u}};t.ajax.requests=[],t.slideLeft=function(e,t,n){1==t?(e.classList.add("slide-left-in"),setTimeout((function(){e.classList.remove("slide-left-in"),"function"==typeof n&&n()}),400)):(e.classList.add("slide-left-out"),setTimeout((function(){e.classList.remove("slide-left-out"),"function"==typeof n&&n()}),400))},t.slideRight=function(e,t,n){1==t?(e.classList.add("slide-right-in"),setTimeout((function(){e.classList.remove("slide-right-in"),"function"==typeof n&&n()}),400)):(e.classList.add("slide-right-out"),setTimeout((function(){e.classList.remove("slide-right-out"),"function"==typeof n&&n()}),400))},t.slideTop=function(e,t,n){1==t?(e.classList.add("slide-top-in"),setTimeout((function(){e.classList.remove("slide-top-in"),"function"==typeof n&&n()}),400)):(e.classList.add("slide-top-out"),setTimeout((function(){e.classList.remove("slide-top-out"),"function"==typeof n&&n()}),400))},t.slideBottom=function(e,t,n){1==t?(e.classList.add("slide-bottom-in"),setTimeout((function(){e.classList.remove("slide-bottom-in"),"function"==typeof n&&n()}),400)):(e.classList.add("slide-bottom-out"),setTimeout((function(){e.classList.remove("slide-bottom-out"),"function"==typeof n&&n()}),100))},t.fadeIn=function(e,t){e.classList.add("fade-in"),setTimeout((function(){e.classList.remove("fade-in"),"function"==typeof t&&t()}),2e3)},t.fadeOut=function(e,t){e.classList.add("fade-out"),setTimeout((function(){e.classList.remove("fade-out"),"function"==typeof t&&t()}),1e3)},t.keyDownControls=function(e){if(27==e.which){var t=document.querySelectorAll(".jslider");if(t.length>0)for(var n=0;n<t.length;n++)t[n].slider.close();document.querySelector(".jdialog")&&jSuites.dialog.close()}else 13==e.which&&document.querySelector(".jdialog")&&("function"==typeof jSuites.dialog.options.onconfirm&&jSuites.dialog.options.onconfirm(),jSuites.dialog.close());jSuites.mask&&jSuites.mask.apply(e)};var n=function(e){var t=null;if(t=jSuites.getLinkElement(e.target)){var n=t.getAttribute("data-href");"#back"==n?window.history.back():"#panel"==n?jSuites.panel():jSuites.pages(n)}};return document.addEventListener("swipeleft",(function(e){var t;(t=jSuites.getElement(e.target,"option"))&&t.querySelector(".option-actions")?t.scrollTo({left:100,behavior:"smooth"}):(t=jSuites.getElement(e.target,"jcalendar"))&&jSuites.calendar.current?jSuites.calendar.current.prev():jSuites.panel&&(t=jSuites.panel.get())&&"none"!=t.style.display&&jSuites.panel.close()})),document.addEventListener("swiperight",(function(e){var t;(t=jSuites.getElement(e.target,"option"))&&t.querySelector(".option-actions")?t.scrollTo({left:0,behavior:"smooth"}):(t=jSuites.getElement(e.target,"jcalendar"))&&jSuites.calendar.current?jSuites.calendar.current.next():jSuites.panel&&(t=jSuites.panel.get())&&"none"==t.style.display&&jSuites.panel()})),document.addEventListener("keydown",t.keyDownControls),"ontouchend"in document.documentElement==1?document.addEventListener("touchend",n):document.addEventListener("mouseup",n),document.addEventListener("mouseover",(function(e){jSuites.tooltip&&jSuites.tooltip(e)})),document.addEventListener("mouseout",(function(e){jSuites.tooltip&&jSuites.tooltip.hide()})),document.addEventListener("DOMContentLoaded",(function(){t.init()})),window.onpopstate=function(e){e.state&&e.state.route&&jSuites.pages.get(e.state.route)&&jSuites.pages(e.state.route,{ignoreHistory:!0})},t}();return jSuites.files=[],jSuites.calendar=function(e,t){var n={options:{}};jSuites.calendar.current||(jSuites.calendar.current=null);var r={data:null,type:null,validRange:null,startingDay:null,format:"DD/MM/YYYY",readonly:!0,today:!1,time:!1,resetButton:!0,placeholder:"",months:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdays_short:["S","M","T","W","T","F","S"],value:null,onclose:null,onchange:null,fullscreen:!1,mode:null,position:null,opened:!1};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];if(n.options.value||"INPUT"==e.tagName&&e.value&&(n.options.value=e.value),n.options.format=n.options.format.toUpperCase(),n.options.value){var i=(a=n.options.value.split(" "))[1],a=a[0].split("-"),l=parseInt(a[0]),s=parseInt(a[1]),u=parseInt(a[2]);if(i){i=i.split(":");var g=parseInt(i[0]),c=parseInt(i[1])}else g=0,c=0}else l=(a=new Date).getFullYear(),s=a.getMonth()+1,u=a.getDate(),g=a.getHours(),c=a.getMinutes();n.date=[l,s,u,g,c,0];var d=function(e){return 1==(e=""+e).length&&(e="0"+e),e},p=document.createElement("div");p.className="jcalendar-reset",p.innerHTML="Reset";var C=document.createElement("div");C.className="jcalendar-confirm",C.innerHTML="Done";var A=document.createElement("div");A.className="jcalendar-controls",n.options.resetButton&&A.appendChild(p),A.appendChild(C);var I=document.createElement("div");I.className="jcalendar-container";var b=document.createElement("div");b.className="jcalendar-content",b.appendChild(A),I.appendChild(b);var f=document.createElement("div");if(f.className="jcalendar-table",b.appendChild(f),"INPUT"==e.tagName)var h=document.createElement("div");else h=e;h.className="jcalendar",h.appendChild(I);var m=document.createElement("td");m.setAttribute("colspan","2"),m.className="jcalendar-prev";var j=document.createElement("span");j.className="jcalendar-year";var v=document.createElement("span");v.className="jcalendar-month";var x=document.createElement("td");x.className="jcalendar-header",x.setAttribute("colspan","3"),x.appendChild(v),x.appendChild(j);var w=document.createElement("td");w.setAttribute("colspan","2"),w.className="jcalendar-next";var y=document.createElement("tr");y.appendChild(m),y.appendChild(x),y.appendChild(w);var E=document.createElement("thead");E.appendChild(y);var N=document.createElement("tbody"),L=document.createElement("tfoot"),M=document.createElement("table");M.setAttribute("cellpadding","0"),M.setAttribute("cellspacing","0"),M.appendChild(E),M.appendChild(N),M.appendChild(L),f.appendChild(M);var S=document.createElement("select");for(S.className="jcalendar-select",S.onchange=function(){n.date[3]=this.value},c=0;c<24;c++)(D=document.createElement("option")).value=c,D.innerHTML=d(c),S.appendChild(D);var k=document.createElement("select");for(k.className="jcalendar-select",k.onchange=function(){n.date[4]=this.value},c=0;c<60;c++){var D;(D=document.createElement("option")).value=c,D.innerHTML=d(c),k.appendChild(D)}var T=document.createElement("div");T.className="jcalendar-controls";var R=document.createElement("div");R.className="jcalendar-time",R.style.maxWidth="140px",R.appendChild(S),R.appendChild(k);var F=document.createElement("input");F.setAttribute("type","button"),F.className="jcalendar-update",F.value="Update";var O=document.createElement("div");O.style.flexGrow="10",O.appendChild(F),T.appendChild(R),T.appendChild(O),b.appendChild(T);var H=document.createElement("div");H.className="jcalendar-backdrop",h.appendChild(H);var P=function(){var e=h.querySelector(".jcalendar-selected");e&&e.classList.contains("jcalendar-disabled")?(F.setAttribute("disabled","disabled"),S.setAttribute("disabled","disabled"),k.setAttribute("disabled","disabled")):(F.removeAttribute("disabled"),S.removeAttribute("disabled"),k.removeAttribute("disabled"))};n.open=function(t){if(!h.classList.contains("jcalendar-focus"))if(jSuites.calendar.current&&jSuites.calendar.current.close(),jSuites.calendar.current=n,h.classList.add("jcalendar-focus"),n.getDays(),n.options.time&&(S.value=n.date[3],k.value=n.date[4]),jSuites.getWindowWidth()<800||n.options.fullscreen)h.classList.add("jcalendar-fullsize"),jSuites.slideBottom(b,1);else{const t=e.getBoundingClientRect(),r=b.getBoundingClientRect();n.options.position?(I.style.position="fixed",window.innerHeight<t.bottom+r.height?I.style.top=t.top-(r.height+2)+"px":I.style.top=t.top+t.height+2+"px",I.style.left=t.left+"px"):window.innerHeight<t.bottom+r.height?I.style.bottom=1*t.height+r.height+2+"px":I.style.top="2px"}},n.close=function(t,r){if(jSuites.calendar.current){if(jSuites.calendar.current=null,!1!==r){var o=h.querySelector(".jcalendar-selected");if("string"==typeof r)var i=r;else i=o&&o.classList.contains("jcalendar-disabled")?n.options.value:n.getValue();n.setValue(i)}t||"function"!=typeof n.options.onclose||n.options.onclose(e),h.classList.remove("jcalendar-focus")}return n.options.value},n.prev=function(){"years"==n.options.mode?(n.date[0]=n.date[0]-12,n.getYears()):(n.date[1]<2?(n.date[0]=n.date[0]-1,n.date[1]=12):n.date[1]=n.date[1]-1,n.getDays())},n.next=function(){"years"==n.options.mode?(n.date[0]=parseInt(n.date[0])+12,n.getYears()):(n.date[1]>11?(n.date[0]=parseInt(n.date[0])+1,n.date[1]=1):n.date[1]=parseInt(n.date[1])+1,n.getDays())},n.setValue=function(t){t||(t=""+t);var r=t,o=n.options.value;n.setLabel(r,n.options.format),(a=r.split(" "))[1]||(a[1]="00:00:00");var i=a[1].split(":"),a=a[0].split("-"),l=parseInt(a[0]),s=parseInt(a[1]),u=parseInt(a[2]),g=parseInt(i[0]),c=parseInt(i[1]);n.date=[l,s,u,g,c,0],t=n.setLabel(r,n.options.format),o!=r&&("INPUT"==e.tagName&&(e.value=t),n.options.value=r,"function"==typeof n.options.onchange&&n.options.onchange(e,r,o)),n.getDays()},n.getValue=function(){return n.date?n.options.time?d(n.date[0])+"-"+d(n.date[1])+"-"+d(n.date[2])+" "+d(n.date[3])+":"+d(n.date[4])+":"+d(0):d(n.date[0])+"-"+d(n.date[1])+"-"+d(n.date[2])+" "+d(0)+":"+d(0)+":"+d(0):""},n.update=function(e){if(e.classList.contains("jcalendar-disabled"));else{n.date[2]=e.innerText,n.options.time?(n.date[3]=S.value,n.date[4]=k.value):n.close();var t=h.querySelector(".jcalendar-selected");t&&t.classList.remove("jcalendar-selected"),e.classList.add("jcalendar-selected")}P()},n.reset=function(){n.close(!1,"")},n.getDays=function(){n.options.mode="days";var e=new Date,t=n.date&&n.date[0]?n.date[0]:parseInt(e.getFullYear()),r=n.date&&n.date[1]?n.date[1]:parseInt(e.getMonth())+1,o=n.date&&n.date[2]?n.date[2]:parseInt(e.getDay()),i=n.date&&n.date[3]?n.date[3]:parseInt(e.getHours()),a=n.date&&n.date[4]?n.date[4]:parseInt(e.getMinutes());n.date=[t,r,o,i,a,0],j.innerHTML=t,v.innerHTML=n.options.months[r-1];var l=e.getMonth()==r-1&&e.getFullYear()==t,s=e.getDate(),u=(e=new Date(t,r,0,0,0)).getDate(),g=(e=new Date(t,r-1,0,0,0)).getDay()+1;g-=d=n.options.startingDay||0,N.innerHTML="",(A=document.createElement("tr")).setAttribute("align","center"),N.appendChild(A);for(var c=0;c<7;c++)(b=document.createElement("td")).classList.add("jcalendar-weekday"),b.innerHTML=n.options.weekdays_short[d],A.appendChild(b),++d>6&&(d=0);for(var d=0,p=0,C=0;C<5;C++){var A;(A=document.createElement("tr")).setAttribute("align","center");var I=!0;for(c=0;c<7;c++){var b;if((b=document.createElement("td")).classList.add("jcalendar-set-day"),d>=g&&d<g+u){p++,b.innerHTML=p,p==o&&b.classList.add("jcalendar-selected"),l&&s==p&&(b.style.fontWeight="bold");var f=jSuites.calendar.now(new Date(t,r-1,p),!0);if(n.options.validRange){if(!n.options.validRange[0]||f>=n.options.validRange[0])var h=!0;else h=!1;if(!n.options.validRange[1]||f<=n.options.validRange[1])var m=!0;else m=!1;h&&m||b.classList.add("jcalendar-disabled")}I=!1}A.appendChild(b),d++}0==I&&N.appendChild(A)}n.options.time?R.style.display="":R.style.display="none",P()},n.getMonths=function(){n.options.mode="months";var e=n.options.months;j.innerHTML=n.date[0],v.innerHTML="";var t='<td colspan="7"><table width="100%"><tr align="center">';for(c=0;c<12;c++)c>0&&!(c%4)&&(t+='</tr><tr align="center">'),t+='<td class="jcalendar-set-month" data-value="'+(parseInt(c)+1)+'">'+e[c]+"</td>";t+="</tr></table></td>",N.innerHTML=t},n.getYears=function(){n.options.mode="years";var e=[];for(c=0;c<25;c++)e[c]=parseInt(n.date[0])+(c-12);var t='<td colspan="7"><table width="100%"><tr align="center">';for(c=0;c<25;c++)c>0&&!(c%5)&&(t+='</tr><tr align="center">'),t+='<td class="jcalendar-set-year">'+e[c]+"</td>";t+="</tr></table></td>",N.innerHTML=t},n.setLabel=function(e,t){return jSuites.calendar.getDateString(e,t)},n.fromFormatted=function(e,t){return jSuites.calendar.extractDateFromString(e,t)};var B=function(e){var t=e.target.className;"jcalendar-prev"==t?(n.prev(),e.stopPropagation(),e.preventDefault()):"jcalendar-next"==t?(n.next(),e.stopPropagation(),e.preventDefault()):"jcalendar-month"==t?(n.getMonths(),e.stopPropagation(),e.preventDefault()):"jcalendar-year"==t?(n.getYears(),e.stopPropagation(),e.preventDefault()):"jcalendar-set-year"==t?(n.date[0]=e.target.innerText,n.getDays(),e.stopPropagation(),e.preventDefault()):"jcalendar-set-month"==t?(n.date[1]=parseInt(e.target.getAttribute("data-value")),n.getDays(),e.stopPropagation(),e.preventDefault()):"jcalendar-confirm"==t||"jcalendar-update"==t||"jcalendar-close"==t?(n.close(),e.stopPropagation(),e.preventDefault()):"jcalendar-backdrop"==t?(n.close(!1,!1),e.stopPropagation(),e.preventDefault()):"jcalendar-reset"==t?(n.reset(),e.stopPropagation(),e.preventDefault()):e.target.classList.contains("jcalendar-set-day")&&e.target.innerText&&(n.update(e.target),e.stopPropagation(),e.preventDefault())};return e.addEventListener("keyup",(function(e){if(e.target.value&&e.target.value.length>3){var t=jSuites.calendar.extractDateFromString(e.target.value,n.options.format);t&&"true"==e.target.getAttribute("data-completed")&&n.setValue(t)}})),h.addEventListener("swipeleft",(function(e){jSuites.slideLeft(M,0,(function(){n.next(),jSuites.slideRight(M,1)})),e.preventDefault(),e.stopPropagation()})),h.addEventListener("swiperight",(function(e){jSuites.slideRight(M,0,(function(){n.prev(),jSuites.slideLeft(M,1)})),e.preventDefault(),e.stopPropagation()})),"ontouchend"in document.documentElement==1?(h.addEventListener("touchend",B),e.addEventListener("touchend",(function(e){n.open()}))):(h.addEventListener("mouseup",B),e.addEventListener("mouseup",(function(e){n.open()}))),"INPUT"==e.tagName&&(e.parentNode.insertBefore(h,e.nextSibling),e.setAttribute("autocomplete","off"),e.setAttribute("data-mask",n.options.format.toLowerCase()),n.options.readonly&&e.setAttribute("readonly","readonly"),n.options.placeholder&&e.setAttribute("placeholder",n.options.placeholder),e.classList.add("jcalendar-input"),e.value=n.setLabel(n.getValue(),n.options.format)),e.calendar=n,1==n.options.opened&&n.open(),n},jSuites.calendar.prettify=function(e,t){t||(t={justNow:"Just now",xMinutesAgo:"{0}m ago",xHoursAgo:"{0}h ago",xDaysAgo:"{0}d ago",xWeeksAgo:"{0}w ago",xMonthsAgo:"{0} mon ago",xYearsAgo:"{0}y ago"});var n=new Date,r=new Date(e),o=parseInt((n-r)/1e3/60);if(String.prototype.format=function(e){return this.replace("{0}",e)},0==o)var i=t.justNow;else i=o<90?t.xMinutesAgo.format(o):o<1440?t.xHoursAgo.format(Math.round(o/60)):o<20160?t.xDaysAgo.format(Math.round(o/1440)):o<43200?t.xWeeksAgo.format(Math.round(o/10080)):o<1036800?t.xMonthsAgo.format(Math.round(o/43200)):t.xYearsAgo.format(Math.round(o/525600));return i},jSuites.calendar.prettifyAll=function(){for(var e=document.querySelectorAll(".prettydate"),t=0;t<e.length;t++)e[t].getAttribute("data-date")?e[t].innerHTML=jSuites.calendar.prettify(e[t].getAttribute("data-date")):(e[t].setAttribute("data-date",e[t].innerHTML),e[t].innerHTML=jSuites.calendar.prettify(e[t].innerHTML))},jSuites.calendar.now=function(e,t){e||(e=new Date);var n=e.getFullYear(),r=e.getMonth()+1,o=e.getDate(),i=e.getHours(),a=e.getMinutes(),l=e.getSeconds(),s=function(e){return 1==(e=""+e).length&&(e="0"+e),e};return 1==t?s(n)+"-"+s(r)+"-"+s(o):s(n)+"-"+s(r)+"-"+s(o)+" "+s(i)+":"+s(a)+":"+s(l)},jSuites.calendar.extractDateFromString=function(e,t){var n=""+e,r=t.replace(/[0-9]/g,""),o=1,i=r.search("YYYY");i=n.substr(i,4),parseInt(i)!=i&&(o=0);var a=r.search("MM");a=n.substr(a,2),(parseInt(a)!=a||l>12)&&(o=0);var l=r.search("DD");l=n.substr(l,2),(parseInt(l)!=l||l>31)&&(o=0);var s=r.search("HH");s>=0?(s=n.substr(s,2),(!parseInt(s)||s>23)&&(s="00")):s="00";var u=r.search("MI");u>=0?(u=n.substr(u,2),(!parseInt(u)||u>59)&&(u="00")):u="00";var g=r.search("SS");return g>=0?(g=n.substr(g,2),(!parseInt(g)||g>59)&&(g="00")):g="00",1==o&&e.length==r.length?i+"-"+a+"-"+l+" "+s+":"+u+":"+g:""},jSuites.calendar.getDateString=function(e,t){if(t||(t="DD/MM/YYYY"),e){var n=""+e,r="",o="",i="";if((n=n.split(" "))[1]?(o=(r=n[1].split(":"))[1]?r[1]:"00",i=r[2]?r[2]:"00",r=r[0]?r[0]:"00"):(r="00",o="00",i="00"),(n=n[0].split("-"))[0]&&n[1]&&n[2]&&n[0]>0&&n[1]>0&&n[1]<13&&n[2]>0&&n[2]<32){var a=new Date(n[0],n[1]-1,n[2]),l=new Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"),s=new Array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");n[1]=(n[1].length<2?"0":"")+n[1],n[2]=(n[2].length<2?"0":"")+n[2],r=(r.length<2?"0":"")+r,o=(o.length<2?"0":"")+o,i=(i.length<2?"0":"")+i,e=(e=(e=(e=(e=(e=(e=t).replace("WD",l[a.getDay()])).replace("DD",n[2])).replace("MM",n[1])).replace("YYYY",n[0])).replace("YY",n[0].substring(2,4))).replace("MON",s[parseInt(n[1])-1].toUpperCase()),r&&(e=e.replace("HH24",r)),e=(e=(e=(e=r>12?(e=e.replace("HH12",r-12)).replace("HH",r):(e=e.replace("HH12",r)).replace("HH",r)).replace("MI",o)).replace("MM",o)).replace("SS",i)}else e=""}return e},jSuites.calendar.isOpen=function(e){jSuites.calendar.current&&(e.target.className&&-1!=e.target.className.indexOf("jcalendar")||jSuites.calendar.current.close(!1,!1))},"ontouchstart"in document.documentElement==1?document.addEventListener("touchstart",jSuites.calendar.isOpen):document.addEventListener("mousedown",jSuites.calendar.isOpen),jSuites.color=function(e,t){var n={options:{},values:[]};jSuites.color.current||(jSuites.color.current=null);var r={placeholder:"",value:null,onclose:null,onchange:null,closeOnChange:!0};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];for(var i={red:{50:"#ffebee",100:"#ffcdd2",200:"#ef9a9a",300:"#e57373",400:"#ef5350",500:"#f44336",600:"#e53935",700:"#d32f2f",800:"#c62828",900:"#b71c1c"},pink:{50:"#fce4ec",100:"#f8bbd0",200:"#f48fb1",300:"#f06292",400:"#ec407a",500:"#e91e63",600:"#d81b60",700:"#c2185b",800:"#ad1457",900:"#880e4f"},purple:{50:"#f3e5f5",100:"#e1bee7",200:"#ce93d8",300:"#ba68c8",400:"#ab47bc",500:"#9c27b0",600:"#8e24aa",700:"#7b1fa2",800:"#6a1b9a",900:"#4a148c"},indigo:{50:"#e8eaf6",100:"#c5cae9",200:"#9fa8da",300:"#7986cb",400:"#5c6bc0",500:"#3f51b5",600:"#3949ab",700:"#303f9f",800:"#283593",900:"#1a237e"},blue:{50:"#e3f2fd",100:"#bbdefb",200:"#90caf9",300:"#64b5f6",400:"#42a5f5",500:"#2196f3",600:"#1e88e5",700:"#1976d2",800:"#1565c0",900:"#0d47a1"},cyan:{50:"#e0f7fa",100:"#b2ebf2",200:"#80deea",300:"#4dd0e1",400:"#26c6da",500:"#00bcd4",600:"#00acc1",700:"#0097a7",800:"#00838f",900:"#006064"},teal:{50:"#e0f2f1",100:"#b2dfdb",200:"#80cbc4",300:"#4db6ac",400:"#26a69a",500:"#009688",600:"#00897b",700:"#00796b",800:"#00695c",900:"#004d40"},green:{50:"#e8f5e9",100:"#c8e6c9",200:"#a5d6a7",300:"#81c784",400:"#66bb6a",500:"#4caf50",600:"#43a047",700:"#388e3c",800:"#2e7d32",900:"#1b5e20"},lightgreen:{50:"#f1f8e9",100:"#dcedc8",200:"#c5e1a5",300:"#aed581",400:"#9ccc65",500:"#8bc34a",600:"#7cb342",700:"#689f38",800:"#558b2f",900:"#33691e"},lime:{50:"#f9fbe7",100:"#f0f4c3",200:"#e6ee9c",300:"#dce775",400:"#d4e157",500:"#cddc39",600:"#c0ca33",700:"#afb42b",800:"#9e9d24",900:"#827717"},yellow:{50:"#fffde7",100:"#fff9c4",200:"#fff59d",300:"#fff176",400:"#ffee58",500:"#ffeb3b",600:"#fdd835",700:"#fbc02d",800:"#f9a825",900:"#f57f17"},amber:{50:"#fff8e1",100:"#ffecb3",200:"#ffe082",300:"#ffd54f",400:"#ffca28",500:"#ffc107",600:"#ffb300",700:"#ffa000",800:"#ff8f00",900:"#ff6f00"},orange:{50:"#fff3e0",100:"#ffe0b2",200:"#ffcc80",300:"#ffb74d",400:"#ffa726",500:"#ff9800",600:"#fb8c00",700:"#f57c00",800:"#ef6c00",900:"#e65100"},deeporange:{50:"#fbe9e7",100:"#ffccbc",200:"#ffab91",300:"#ff8a65",400:"#ff7043",500:"#ff5722",600:"#f4511e",700:"#e64a19",800:"#d84315",900:"#bf360c"},brown:{50:"#efebe9",100:"#d7ccc8",200:"#bcaaa4",300:"#a1887f",400:"#8d6e63",500:"#795548",600:"#6d4c41",700:"#5d4037",800:"#4e342e",900:"#3e2723"},grey:{50:"#fafafa",100:"#f5f5f5",200:"#eeeeee",300:"#e0e0e0",400:"#bdbdbd",500:"#9e9e9e",600:"#757575",700:"#616161",800:"#424242",900:"#212121"},bluegrey:{50:"#eceff1",100:"#cfd8dc",200:"#b0bec5",300:"#90a4ae",400:"#78909c",500:"#607d8b",600:"#546e7a",700:"#455a64",800:"#37474f",900:"#263238"}},a=[],l=Object.keys(i),s=Object.keys(i[l[0]]),u=0;u<l.length;u++)for(var g=0;g<s.length;g++)a[g]||(a[g]=[]),a[g][u]=i[l[u]][s[g]];n.options.value&&(e.value=n.options.value);var c=document.createElement("div");c.className="jcolor";var d=document.createElement("div");d.className="jcolor-backdrop",c.appendChild(d);var p=document.createElement("div");p.className="jcolor-content";var C=document.createElement("div");C.className="jcolor-close",C.innerHTML="Done",C.onclick=function(){n.close()},p.appendChild(C);var A=document.createElement("table");for(A.setAttribute("cellpadding","7"),A.setAttribute("cellspacing","0"),u=0;u<a.length;u++){var I=document.createElement("tr");for(g=0;g<a[u].length;g++){var b=document.createElement("td");b.style.backgroundColor=a[u][g],b.setAttribute("data-value",a[u][g]),b.innerHTML="",I.appendChild(b),n.options.value==a[u][g]&&b.classList.add("jcolor-selected"),n.values[a[u][g]]=b}A.appendChild(I)}return n.open=function(){if(jSuites.color.current&&jSuites.color.current!=n&&jSuites.color.current.close(),!jSuites.color.current){jSuites.color.current=n,c.classList.add("jcolor-focus");const t=p.getBoundingClientRect();if(jSuites.getWindowWidth()<800)p.style.top="",p.classList.add("jcolor-fullscreen"),jSuites.slideBottom(p,1),d.style.display="block";else{p.classList.contains("jcolor-fullscreen")&&(p.classList.remove("jcolor-fullscreen"),d.style.display="");const n=e.getBoundingClientRect();window.innerHeight<n.bottom+t.height?p.style.top=-1*(t.height+n.height+2)+"px":p.style.top="2px"}c.focus()}},n.close=function(t){return jSuites.color.current&&(jSuites.color.current=null,t||"function"!=typeof n.options.onclose||n.options.onclose(e),c.classList.remove("jcolor-focus")),d.style.display="",n.options.value},n.setValue=function(t){t&&(e.value=t,n.options.value=t);var r=c.querySelector(".jcolor-selected");r&&r.classList.remove("jcolor-selected"),n.values[t].classList.add("jcolor-selected"),"function"==typeof n.options.onchange&&n.options.onchange(e,t),1==n.options.closeOnChange&&n.close()},n.getValue=function(){return n.options.value},e.addEventListener("focus",(function(e){n.open()})),e.addEventListener("mousedown",(function(e){jSuites.color.current||setTimeout((function(){n.open(),e.preventDefault()}),200)})),c.addEventListener("mouseup",(function(e){"TD"==e.target.tagName&&(jSuites.color.current.setValue(e.target.getAttribute("data-value")),jSuites.color.current&&jSuites.color.current.close())})),document.addEventListener("mousedown",(function(e){jSuites.color.current&&(jSuites.getElement(e.target,"jcolor")||jSuites.color.current.close())})),c.setAttribute("tabindex","900"),n.options.placeholder&&e.setAttribute("placeholder",n.options.placeholder),p.appendChild(A),c.appendChild(p),"INPUT"==e.tagName?e.parentNode.insertBefore(c,e.nextSibling):e.appendChild(c),e.color=n,n},jSuites.contextmenu=function(e,t){var n={options:{}},r={items:null,onclick:null};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];return e.classList.add("jcontextmenu"),e.setAttribute("tabindex","900"),n.open=function(t,r){if(r&&(n.options.items=r,n.create(r)),t.target)var o=t.clientX,i=t.clientY;else o=t.x,i=t.y;e.classList.add("jcontextmenu-focus"),e.focus();const a=e.getBoundingClientRect();window.innerHeight<i+a.height?e.style.top=i-a.height+"px":e.style.top=i+"px",window.innerWidth<o+a.width?o-a.width>0?e.style.left=o-a.width+"px":e.style.left="10px":e.style.left=o+"px"},n.close=function(){e.classList.contains("jcontextmenu-focus")&&e.classList.remove("jcontextmenu-focus")},n.create=function(t){e.innerHTML="";for(var n=0;n<t.length;n++){if(t[n].type&&"line"==t[n].type)var r=document.createElement("hr");else{r=document.createElement("div");var o=document.createElement("a");if(o.innerHTML=t[n].title,t[n].disabled?r.className="jcontextmenu-disabled":t[n].onclick&&(r.method=t[n].onclick,r.addEventListener("mouseup",(function(){this.method(this)}))),r.appendChild(o),t[n].shortcut){var i=document.createElement("span");i.innerHTML=t[n].shortcut,r.appendChild(i)}}e.appendChild(r)}},"function"==typeof n.options.onclick&&e.addEventListener("click",(function(e){n.options.onclick(n)})),e.addEventListener("blur",(function(e){setTimeout((function(){n.close()}),120)})),window.addEventListener("mousewheel",(function(){n.close()})),n.options.items&&n.create(n.options.items),e.contextmenu=n,n},jSuites.contextmenu.getElement=function(e){var t=0;return function e(n){n.parentNode&&n.getAttribute("aria-contextmenu-id")?t=n.getAttribute("aria-contextmenu-id"):n.parentNode&&e(n.parentNode)}(e),t},document.addEventListener("contextmenu",(function(e){var t=jSuites.contextmenu.getElement(e.target);if(t){var n=document.querySelector("#"+t);n?(n.contextmenu.open(e),e.preventDefault()):console.error("JSUITES: Contextmenu id not found")}})),jSuites.dialog=function(){var e={options:{}},t=document.createElement("div");t.setAttribute("tabindex","901"),t.className="jdialog",t.id="dialog";var n=document.createElement("div");n.className="jdialog-header";var r=document.createElement("div");r.className="jdialog-title",n.appendChild(r);var o=document.createElement("div");o.className="jdialog-message",n.appendChild(o);var i=document.createElement("div");i.className="jdialog-footer";var a=document.createElement("div");a.className="jdialog-container",a.appendChild(n),a.appendChild(i);var l=document.createElement("div"),s=document.createElement("input");s.value=e.options.confirmLabel,s.type="button",s.onclick=function(){"function"==typeof e.options.onconfirm&&e.options.onconfirm(),e.close()},l.appendChild(s),i.appendChild(l);var u=document.createElement("div"),g=document.createElement("input");return g.value=e.options.cancelLabel,g.type="button",g.onclick=function(){"function"==typeof e.options.oncancel&&e.options.oncancel(),e.close()},u.appendChild(g),i.appendChild(u),t.appendChild(a),e.open=function(n){e.options=n,e.options.title&&(r.innerHTML=e.options.title),e.options.message&&(o.innerHTML=e.options.message),e.options.confirmLabel||(e.options.confirmLabel="OK"),s.value=e.options.confirmLabel,e.options.cancelLabel||(e.options.cancelLabel="Cancel"),g.value=e.options.cancelLabel,"confirm"==e.options.type?g.parentNode.style.display="":g.parentNode.style.display="none",t.style.opacity=100,jSuites.el?jSuites.el.appendChild(t):document.body.appendChild(t),t.focus(),setTimeout((function(){a.style.opacity=100}),0)},e.close=function(){t.style.opacity=0,a.style.opacity=0,setTimeout((function(){t.remove()}),100)},e}(),jSuites.confirm=function(e,t){jSuites.getWindowWidth()<800?jSuites.dialog.open({type:"confirm",message:e,title:"Confirmation",onconfirm:t}):confirm(e)&&t()},jSuites.alert=function(e){jSuites.getWindowWidth()<800?jSuites.dialog.open({title:"Alert",message:e}):alert(e)},jSuites.dropdown=function(e,t){var n={options:{}};if("SELECT"==e.tagName){var r=jSuites.dropdown.extractFromDom(e,t);e=r.el,t=r.options}var o={url:null,data:[],multiple:!1,autocomplete:!1,type:null,width:null,opened:!1,value:null,placeholder:"",position:!1,onchange:null,onload:null,onopen:null,onclose:null,onblur:null};for(var i in o)t&&t.hasOwnProperty(i)?n.options[i]=t[i]:n.options[i]=o[i];jSuites.dropdown.current||(jSuites.dropdown.current=null),n.items=[],n.groups=[],n.selected=[],e.classList.add("jdropdown"),"searchbar"==n.options.type?e.classList.add("jdropdown-searchbar"):"list"==n.options.type?e.classList.add("jdropdown-list"):"picker"==n.options.type?e.classList.add("jdropdown-picker"):jSuites.getWindowWidth()<800?(e.classList.add("jdropdown-picker"),n.options.type="picker"):(n.options.width&&(e.style.width=n.options.width,e.style.minWidth=n.options.width),e.classList.add("jdropdown-default"),n.options.type="default");var a=document.createElement("div");a.className="jdropdown-container-header";var l=document.createElement("input");l.className="jdropdown-header","function"==typeof n.options.onblur&&(l.onblur=function(){n.options.onblur(e)});var s=document.createElement("div");s.className="jdropdown-container";var u=document.createElement("div");u.className="jdropdown-content";var g=document.createElement("div");g.className="jdropdown-close",g.innerHTML="Done";var c=document.createElement("div");if(c.className="jdropdown-backdrop",1==n.options.autocomplete){e.setAttribute("data-autocomplete",!0);var d=null;l.addEventListener("keyup",(function(t){d&&clearTimeout(d),d=setTimeout((function(){n.find(l.value),d=null}),500),e.classList.contains("jdropdown-focus")||t.which>65&&n.open()}))}else l.setAttribute("readonly","readonly");return!n.options.placeholder&&e.getAttribute("placeholder")&&(n.options.placeholder=e.getAttribute("placeholder")),n.options.placeholder&&l.setAttribute("placeholder",n.options.placeholder),a.appendChild(l),"searchbar"==n.options.type?a.appendChild(g):s.appendChild(g),s.appendChild(u),e.appendChild(a),e.appendChild(s),e.appendChild(c),n.init=function(){n.options.url?jSuites.ajax({url:n.options.url,method:"GET",dataType:"json",success:function(t){t&&(n.setData(t),null!=n.options.value&&n.setValue(n.options.value),"function"==typeof n.options.onload&&n.options.onload(e,n,t))}}):(n.setData(),null!=n.options.value&&n.setValue(n.options.value),"function"==typeof n.options.onload&&n.options.onload(e,n,data)),1==n.options.opened&&n.open()},n.getUrl=function(){return n.options.url},n.setUrl=function(e){n.options.url=e,jSuites.ajax({url:n.options.url,method:"GET",dataType:"json",success:function(e){n.setData(e)}})},n.createItem=function(e){var t={};if(t.element=document.createElement("div"),t.element.className="jdropdown-item",t.value=e.id,t.text=e.name,t.textLowerCase=""+e.name.toLowerCase(),e.image){var n=document.createElement("img");n.className="jdropdown-image",n.src=e.image,e.title||n.classList.add("jdropdown-image-small"),t.element.appendChild(n)}var r=document.createElement("div");if(r.className="jdropdown-description",r.innerHTML=e.name,e.title){var o=document.createElement("div");o.className="jdropdown-title",o.innerHTML=e.title,r.appendChild(o)}return t.element.appendChild(r),t},n.setData=function(e){e&&(n.options.data=e),e=n.options.data,s.removeChild(u),u.innerHTML="",n.reset(),n.items=[];var t=[],r=[];if(e.length){for(var o=0;o<e.length;o++)"object"!=typeof e[o]&&(n.options.data[o]=e[o]={id:e[o],name:e[o]}),e[o].group?(r[e[o].group]||(r[e[o].group]=[]),r[e[o].group].push(o)):t.push(o);var i=Object.keys(r);if(i.length>0)for(o=0;o<i.length;o++){var a=document.createElement("div");a.className="jdropdown-group";var l=document.createElement("div");l.className="jdropdown-group-name",l.innerHTML=i[o];var g=document.createElement("i");g.className="jdropdown-group-arrow jdropdown-group-arrow-down",l.appendChild(g);var c=document.createElement("div");c.className="jdropdown-group-items";for(var d=0;d<r[i[o]].length;d++){var p=n.createItem(e[r[i[o]][d]]);c.appendChild(p.element),n.items.push(p)}a.appendChild(l),a.appendChild(g),a.appendChild(c),u.appendChild(a)}if(t.length)for(o=0;o<t.length;o++)p=n.createItem(e[t[o]]),n.items.push(p),u.appendChild(p.element);for(o=0;o<n.items.length;o++)n.items[o].element.setAttribute("data-index",o)}s.appendChild(u)},n.getText=function(e){for(var t=[],r=0;r<n.selected.length;r++)n.items[n.selected[r]]&&t.push(n.items[n.selected[r]].text);return e?t:t.join("; ")},n.getValue=function(e){for(var t=[],r=0;r<n.selected.length;r++)n.items[n.selected[r]]&&t.push(n.items[n.selected[r]].value);return e?t:t.join(";")},n.setValue=function(e){for(var t=0;t<n.selected.length;t++)n.items[n.selected[t]].element.classList.remove("jdropdown-selected");if(n.selected=[],null!=e)if(Array.isArray(e))for(t=0;t<n.items.length;t++)for(var r=0;r<e.length;r++)n.items[t].value==e[r]&&(n.selected.push(t),n.items[t].element.classList.add("jdropdown-selected"));else for(t=0;t<n.items.length;t++)n.items[t].value==e&&(n.selected.push(t),n.items[t].element.classList.add("jdropdown-selected"));n.updateLabel()},n.selectIndex=function(t){if(n.items&&n.items[t]){t=t=parseInt(t);var r=n.getValue(),o=n.getText();if(null!=n.currentIndex&&n.items[n.currentIndex].element.classList.remove("jdropdown-cursor"),n.items[t].element.classList.add("jdropdown-cursor"),n.currentIndex=t,n.options.multiple){if(n.items[t].element.classList.contains("jdropdown-selected")){n.items[t].element.classList.remove("jdropdown-selected");var i=n.selected.indexOf(t);n.selected.splice(i,1)}else n.items[t].element.classList.add("jdropdown-selected"),n.selected.push(t);n.options.autocomplete||n.updateLabel()}else n.items[t].element.classList.contains("jdropdown-selected")?n.resetSelected():(n.resetSelected(),n.items[t].element.classList.add("jdropdown-selected"),n.selected.push(t),n.close());var a=n.getValue(),l=n.getText();"function"==typeof n.options.onchange&&n.options.onchange(e,t,r,a,o,l)}},n.selectItem=function(e){if(jSuites.dropdown.current){var t=e.getAttribute("data-index");null!=t&&n.selectIndex(t)}},n.find=function(e){e=e?e.toLowerCase():null;for(var t=0;t<n.items.length;t++)null==e||-1!=n.items[t].textLowerCase.indexOf(e)?n.items[t].element.style.display="":-1==n.selected.indexOf(t)?n.items[t].element.style.display="none":n.items[t].element.style.display=""},n.updateLabel=function(){l.value=n.getText()},n.open=function(){if(jSuites.dropdown.current!=e&&(jSuites.dropdown.current&&jSuites.dropdown.current.dropdown.close(),jSuites.dropdown.current=e),!e.classList.contains("jdropdown-focus")){e.classList.add("jdropdown-focus"),jSuites.getWindowWidth()<800&&(null!=n.options.type&&"picker"!=n.options.type||jSuites.slideBottom(s,1)),1==n.options.autocomplete&&(n.find(),l.value="",l.focus());var t=n.selected&&n.selected[0]?n.selected[0]:0;if(n.updateCursor(t),!n.options.type||"default"==n.options.type){const t=e.getBoundingClientRect(),r=s.getBoundingClientRect();n.options.position?(s.style.position="fixed",window.innerHeight<t.bottom+r.height?(s.style.top="",s.style.bottom=window.innerHeight-t.top+1+"px"):(s.style.top=t.bottom+"px",s.style.bottom=""),s.style.left=t.left+"px"):window.innerHeight<t.bottom+r.height?(s.style.top="",s.style.bottom=t.height+1+"px"):(s.style.top="",s.style.bottom=""),s.style.minWidth=t.width+"px"}}"function"==typeof n.options.onopen&&n.options.onopen(e)},n.close=function(t){return jSuites.dropdown.current&&(jSuites.dropdown.current=null,n.resetCursor(),n.updateLabel(),t||"function"!=typeof n.options.onclose||n.options.onclose(e),l.blur&&l.blur(),e.classList.remove("jdropdown-focus")),n.getValue()},n.updateCursor=function(e){if(n.items&&n.items[e]&&n.items[e].element){n.resetCursor(),n.items[e].element.classList.add("jdropdown-cursor"),n.currentIndex=parseInt(e),u.scrollTop;var t=n.items[n.currentIndex].element;u.scrollTop=t.offsetTop-t.scrollTop+t.clientTop-95}},n.resetCursor=function(){null!=n.currentIndex&&(n.items&&n.items[n.currentIndex]&&n.items[n.currentIndex].element.classList.remove("jdropdown-cursor"),n.currentIndex=null)},n.resetSelected=function(){if(n.selected){for(var e=0;e<n.selected.length;e++)n.items[n.selected[e]]&&n.items[n.selected[e]].element.classList.remove("jdropdown-selected");n.selected=[]}},n.reset=function(){n.resetCursor(),n.resetSelected(),n.updateLabel()},n.firstVisible=function(){for(var e=null,t=0;t<n.items.length;t++)if("none"!=n.items[t].element.style.display){e=t;break}if(null==e)return!1;n.updateCursor(e)},n.first=function(){for(var e=null,t=n.currentIndex-1;t>=0;t--)"none"!=n.items[t].element.style.display&&(e=t);if(null==e)return!1;n.updateCursor(e)},n.last=function(){for(var e=null,t=n.currentIndex+1;t<n.items.length;t++)"none"!=n.items[t].element.style.display&&(e=t);if(null==e)return!1;n.updateCursor(e)},n.next=function(){for(var e=null,t=n.currentIndex+1;t<n.items.length;t++)if("none"!=n.items[t].element.style.display){e=t;break}if(null==e)return!1;n.updateCursor(e)},n.prev=function(){for(var e=null,t=n.currentIndex-1;t>=0;t--)if("none"!=n.items[t].element.style.display){e=t;break}if(null==e)return!1;n.updateCursor(e)},jSuites.dropdown.hasEvents||("ontouchsend"in document.documentElement==1?document.addEventListener("touchsend",jSuites.dropdown.mouseup):document.addEventListener("mouseup",jSuites.dropdown.mouseup),document.addEventListener("keydown",jSuites.dropdown.onkeydown),jSuites.dropdown.hasEvents=!0),n.init(),e.dropdown=n,n},jSuites.dropdown.hasEvents=!1,jSuites.dropdown.mouseup=function(e){var t=jSuites.getElement(e.target,"jdropdown");if(t){var n=t.dropdown;if(e.target.classList.contains("jdropdown-header"))t.classList.contains("jdropdown-focus")&&t.classList.contains("jdropdown-default")?n.close():n.open();else if(e.target.classList.contains("jdropdown-group-name")){var r=e.target.nextSibling.children;if("none"!=e.target.nextSibling.style.display)for(var o=0;o<r.length;o++)"none"!=r[o].style.display&&n.selectItem(r[o])}else e.target.classList.contains("jdropdown-group-arrow")?e.target.classList.contains("jdropdown-group-arrow-down")?(e.target.classList.remove("jdropdown-group-arrow-down"),e.target.classList.add("jdropdown-group-arrow-up"),e.target.parentNode.nextSibling.style.display="none"):(e.target.classList.remove("jdropdown-group-arrow-up"),e.target.classList.add("jdropdown-group-arrow-down"),e.target.parentNode.nextSibling.style.display=""):e.target.classList.contains("jdropdown-item")?n.selectItem(e.target):e.target.classList.contains("jdropdown-image")||e.target.classList.contains("jdropdown-description")?n.selectIndex(e.target.parentNode.getAttribute("data-index")):e.target.classList.contains("jdropdown-title")?n.selectIndex(e.target.parentNode.parentNode.getAttribute("data-index")):(e.target.classList.contains("jdropdown-close")||e.target.classList.contains("jdropdown-backdrop"))&&n.close();e.stopPropagation(),e.preventDefault()}else jSuites.dropdown.current&&jSuites.dropdown.current.dropdown.close()},jSuites.dropdown.onkeydown=function(e){if(jSuites.dropdown.current){var t=jSuites.dropdown.current.dropdown,n=t.currentIndex;e.shiftKey||13!=e.which&&27!=e.which&&35!=e.which&&36!=e.which&&38!=e.which&&40!=e.which||(13==e.which?t.selectIndex(n):38==e.which?null==n?t.firstVisible():n>0&&t.prev():40==e.which?null==n?t.firstVisible():n+1<t.options.data.length&&t.next():36==e.which?t.first():35==e.which?t.last():27==e.which&&t.close(),e.stopPropagation(),e.preventDefault())}},jSuites.dropdown.extractFromDom=function(e,t){var n=e;if(t||(t={}),!e.getAttribute("multiple")||t&&null!=t.multiple||(t.multiple=!0),!e.getAttribute("placeholder")||t&&null!=t.placeholder||(t.placeholder=e.getAttribute("placeholder")),!e.getAttribute("data-autocomplete")||t&&null!=t.autocomplete||(t.autocomplete=!0),t&&null!=t.width||(t.width=e.offsetWidth),!e.value||t&&null!=t.value||(t.value=e.value),!t||null==t.data){t.data=[];for(var r=0;r<e.children.length;r++)if("OPTGROUP"==e.children[r].tagName)for(var o=0;o<e.children[r].children.length;o++)t.data.push({id:e.children[r].children[o].value,name:e.children[r].children[o].innerHTML,group:e.children[r].getAttribute("label")});else t.data.push({id:e.children[r].value,name:e.children[r].innerHTML})}t&&null!=t.onchange||(t.onchange=function(e,r,o,i){1==t.multiple?obj.items[r].classList.contains("jdropdown-selected")?n.options[r].setAttribute("selected","selected"):n.options[r].removeAttribute("selected"):n.value=i});var i=document.createElement("div");return e.parentNode.insertBefore(i,e),e.style.display="none",{el:e=i,options:t}},jSuites.editor=function(e,t){var n={options:{}},r={value:null,snippet:null,toolbar:null,maxHeight:null,remoteParser:null,youtubeKey:null,userSearch:null,parseURL:!1,dropZone:!0,dropAsAttachment:!1,acceptImages:!0,acceptFiles:!1,maxFileSize:5e6,border:!0,padding:!0,focus:!1,onclick:null,onfocus:null,onblur:null,onload:null,onenter:null,onkeyup:null,onkeydown:null};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];var i=null,a=null;e.innerHTML="",e.classList.add("jeditor-container"),1==n.options.padding&&e.classList.add("jeditor-padding"),0==n.options.border&&(e.style.border="0px");var l=document.createElement("div");l.className="snippet",l.setAttribute("contenteditable",!1);var s=document.createElement("div");s.className="jeditor-toolbar";var u=document.createElement("div");if(u.setAttribute("contenteditable",!0),u.setAttribute("spellcheck",!1),u.className="jeditor",n.options.maxHeight&&(u.style.overflowY="auto",u.style.maxHeight=n.options.maxHeight),n.options.value)var g=n.options.value;else g=e.innerHTML?e.innerHTML:"";g||(g="<br>");var c=function(e){var t=document.createElement("div");t.innerHTML=e;var r=t.querySelectorAll("img");if(r.length)for(var o=0;o<r.length;o++)n.addImage(r[o].src)},d=function(e){var t,n;window.getSelection&&(t=window.getSelection()).rangeCount&&((n=t.getRangeAt(0)).toString(),n.deleteContents(),n.insertNode(e),n.setStartAfter(e),n.setEndAfter(e),t.removeAllRanges(),t.addRange(n))},p=function(e){if(l.innerHTML="",e.image){(n=document.createElement("div")).className="snippet-image",n.setAttribute("data-k","image"),l.appendChild(n);var t=document.createElement("img");t.src=e.image,n.appendChild(t)}var n;(n=document.createElement("div")).className="snippet-title",n.setAttribute("data-k","title"),n.innerHTML=e.title,l.appendChild(n),(n=document.createElement("div")).className="snippet-description",n.setAttribute("data-k","description"),n.innerHTML=e.description,l.appendChild(n),(n=document.createElement("div")).className="snippet-host",n.setAttribute("data-k","host"),n.innerHTML=e.host,l.appendChild(n),(n=document.createElement("div")).className="snippet-url",n.setAttribute("data-k","url"),n.innerHTML=e.url,l.appendChild(n),u.appendChild(l)},C=function(){clearTimeout(i),i=setTimeout((function(){var t=u.querySelector(".snippet"),r=e.querySelector(".jeditor-thumbs-container");if(!t&&!r){var o=u.innerHTML.replace(/\n/g," "),i=document.createElement("div");i.innerHTML=o,(r=i.querySelector(".jeditor-thumbs-container"))&&r.remove();var a=i.innerText,l=jSuites.editor.detectUrl(a);if(l)if("jpg"==l[0].substr(-3)||"png"==l[0].substr(-3)||"gif"==l[0].substr(-3))jSuites.editor.getDomain(l[0])==window.location.hostname?n.importImage(l[0],""):n.importImage(n.options.remoteParser+l[0],"");else{var s=jSuites.editor.youtubeParser(l[0]);s?n.getYoutube(s):n.getWebsite(l[0])}}}),1e3)};n.parseContent=function(){C()},n.getYoutube=function(e){n.options.youtubeKey?jSuites.ajax({url:"https://www.googleapis.com/youtube/v3/videos?part=snippet,statistics&key="+n.options.youtubeKey+"&id="+e,method:"GET",dataType:"json",success:function(t){if(t.items&&t.items[0]){var n={title:"",description:"",image:"",host:"www.youtube.com",url:"https://www.youtube.com?watch="+e};t.items[0].snippet.title&&(n.title=t.items[0].snippet.title),t.items[0].snippet.description&&(n.description=t.items[0].snippet.description,n.description.length>150&&(n.description=n.description.substr(0,150)+"...")),t.items[0].snippet.thumbnails.medium.url&&(n.image=t.items[0].snippet.thumbnails.medium.url),p(n)}}}):console.error("The youtubeKey is not defined")},n.getWebsite=function(e){n.options.remoteParser?jSuites.ajax({url:n.options.remoteParser+encodeURI(e.trim()),method:"GET",dataType:"json",success:function(t){var n={title:"",description:"",image:"",host:e,url:e};t.title&&(n.title=t.title),t.description&&(n.description=t.description),t.image?n.image=t.image:t["og:image"]&&(n.image=t["og:image"]),t.host&&(n.host=t.host),t.url&&(n.url=t.url),p(n)}}):console.log("The remoteParser is not defined")},n.setData=function(e){u.innerHTML=e,cursor()},n.getData=function(e){if(e){a={content:""};var t=u.querySelectorAll(".post-tag");if(t.length){a.users=[];for(var n=0;n<t.length;n++){var r=t[n].getAttribute("data-user");r&&a.users.push(r)}a.users=a.users.join(",")}if(l.innerHTML){for(a.snippet={},n=0;n<l.children.length;n++){var o=l.children[n].getAttribute("data-k");o&&("image"==o?a.snippet.image=l.children[n].children[0].getAttribute("src"):a.snippet[o]=l.children[n].innerHTML)}l.innerHTML="",l.remove()}var i=u.innerHTML;i=(i=(i=i.replace(/<br>/g,"\n")).replace(/<\/div>/g,"</div>\n")).replace(/<(?:.|\n)*?>/gm,""),a.content=i.trim(),a=JSON.stringify(a)}else var a=u.innerHTML;return a},n.reset=function(){u.innerHTML=""},n.addPdf=function(e){if("data"!=e.result.substr(0,4))console.error("Invalid source");else{var t=document.createElement("canvas");t.width=60,t.height=60;var n=new Image;t.getContext("2d").drawImage(n,0,0,t.width,t.height),t.toBlob((function(t){var n=document.createElement("img");n.src=window.URL.createObjectURL(t),n.setAttribute("data-extension","pdf"),e.name&&n.setAttribute("data-name",e.name),e.size&&n.setAttribute("data-size",e.size),e.date&&n.setAttribute("data-date",e.date),n.className="jfile pdf",d(n),jSuites.files[n.src]=e.result.substr(e.result.indexOf(",")+1)}))}},n.addImage=function(e,t,r,o){if("data"==e.substr(0,4)||n.options.remoteParser){if("data"==e.substr(0,4))i=(i=(i=e.split(";"))[0].split("/"))[1];else{var i=e.substr(e.lastIndexOf(".")+1);e=n.options.remoteParser+e}var a=new Image;a.onload=function(){var e=document.createElement("canvas");e.width=a.width,e.height=a.height,e.getContext("2d").drawImage(a,0,0,e.width,e.height),e.toBlob((function(n){var a=document.createElement("img");a.src=window.URL.createObjectURL(n),a.setAttribute("tabindex","900"),a.setAttribute("data-extension",i),t&&a.setAttribute("data-name",t),r&&a.setAttribute("data-size",r),o&&a.setAttribute("data-date",o),a.className="jfile";var l=e.toDataURL();d(a),jSuites.files[a.src]=l.substr(l.indexOf(",")+1)}))},a.src=e}else console.error("remoteParser not defined in your initialization")},n.addFile=function(e){for(var t=[],r=0;r<e.length;r++)if(e[r].size>n.options.maxFileSize)alert("The file is too big");else{var o=e[r].type.split("/");(o="image"==o[0]?1:"pdf"==o[1]?2:0)?(t[r]=new FileReader,t[r].index=r,t[r].type=o,t[r].name=e[r].name,t[r].date=e[r].lastModified,t[r].size=e[r].size,t[r].addEventListener("load",(function(e){2==e.target.type?1==n.options.acceptFiles&&n.addPdf(e.target):n.addImage(e.target.result,e.target.name,e.total,e.target.lastModified)}),!1),t[r].readAsDataURL(e[r])):alert("The extension is not allowed")}},n.destroy=function(){u.removeEventListener("mouseup",A),u.removeEventListener("mousedown",I),u.removeEventListener("mousemove",b),u.removeEventListener("keyup",f),u.removeEventListener("keydown",h),u.removeEventListener("dragstart",j),u.removeEventListener("dragenter",v),u.removeEventListener("dragover",x),u.removeEventListener("drop",w),u.removeEventListener("paste",m),"function"==typeof n.options.onblur&&u.removeEventListener("blur",y),"function"==typeof n.options.onfocus&&u.removeEventListener("focus",E),e.editor=null,e.classList.remove("jeditor-container"),s.remove(),l.remove(),u.remove()};var A=function(e){a=!1},I=function(e){var t=function(t){var n=t.getBoundingClientRect();n.width-(e.clientX-n.left)<40&&e.clientY-n.top<40&&(t.innerHTML="",t.remove())};if("IMG"==e.target.tagName)if(e.target.style.cursor){var n=e.target.getBoundingClientRect();a={e:e.target,x:e.clientX,y:e.clientY,w:n.width,h:n.height,d:e.target.style.cursor},e.target.style.width||(e.target.style.width=n.width+"px"),e.target.style.height||(e.target.style.height=n.height+"px");var r=window.getSelection();if(r.rangeCount)for(var o=0;o<r.rangeCount;o++)r.removeRange(r.getRangeAt(o))}else a=!0;else e.target.classList.contains("snippet")?t(e.target):e.target.parentNode.classList.contains("snippet")&&t(e.target.parentNode),a=!0},b=function(e){if("IMG"==e.target.tagName&&e.target.getAttribute("tabindex")){var t=e.target.getBoundingClientRect();e.clientY-t.top<5?t.width-(e.clientX-t.left)<5?e.target.style.cursor="ne-resize":e.clientX-t.left<5?e.target.style.cursor="nw-resize":e.target.style.cursor="n-resize":t.height-(e.clientY-t.top)<5?t.width-(e.clientX-t.left)<5?e.target.style.cursor="se-resize":e.clientX-t.left<5?e.target.style.cursor="sw-resize":e.target.style.cursor="s-resize":t.width-(e.clientX-t.left)<5?e.target.style.cursor="e-resize":e.clientX-t.left<5?e.target.style.cursor="w-resize":e.target.style.cursor=""}if(1==e.which&&a&&a.d){if("e-resize"==a.d||"ne-resize"==a.d||"se-resize"==a.d)if(a.e.style.width=a.w+(e.clientX-a.x)+"px",e.shiftKey){var n=(e.clientX-a.x)*(a.h/a.w);a.e.style.height=a.h+n+"px"}else n=null;n||"s-resize"!=a.d&&"se-resize"!=a.d&&"sw-resize"!=a.d||e.shiftKey||(a.e.style.height=a.h+(e.clientY-a.y))}},f=function(t){u.innerHTML||(u.innerHTML="<div><br></div>"),"function"==typeof n.options.onkeyup&&n.options.onkeyup(t,e)},h=function(t){if(1==n.options.parseURL&&C(),"function"==typeof n.options.onenter&&13==t.which){var r=n.getData();n.options.onenter(n,e,r,t)}"function"==typeof n.options.onkeydown&&n.options.onkeydown(t,e)},m=function(e){if(e.clipboardData||e.originalEvent.clipboardData)var t=(e.originalEvent||e).clipboardData.getData("text/html"),r=(e.originalEvent||e).clipboardData.getData("text/plain"),o=(e.originalEvent||e).clipboardData.files;else window.clipboardData&&(t=window.clipboardData.getData("Html"),r=window.clipboardData.getData("Text"),o=window.clipboardData.files);if(o.length)n.addFile(o);else{r=r.split("\r\n");var i="";if("DIV"!=e.target.nodeName||e.target.classList.contains("jeditor"))for(a=0;a<r.length;a++)r[a]?i+="<div>"+r[a]+"</div>":i+="<div><br></div>";else for(var a=0;a<r.length;a++)r[a]&&(i+=r[a]+"<br>\r\n");document.execCommand("insertHtml",!1,i),1==n.options.acceptImages&&c(t)}e.preventDefault()},j=function(e){a&&a.e&&e.preventDefault()},v=function(t){a||0==n.options.dropZone||e.classList.add("jeditor-dragging")},x=function(t){a||0==n.options.dropZone||(i&&clearTimeout(i),i=setTimeout((function(){e.classList.remove("jeditor-dragging")}),100))},w=function(t){if(a||0==n.options.dropZone);else{var r=null;document.caretRangeFromPoint?r=document.caretRangeFromPoint(t.clientX,t.clientY):t.rangeParent&&(r=document.createRange()).setStart(t.rangeParent,t.rangeOffset);var o=window.getSelection();o.removeAllRanges(),o.addRange(r),o.anchorNode.parentNode.focus();var i=(t.originalEvent||t).dataTransfer.getData("text/html"),l=(t.originalEvent||t).dataTransfer.getData("text/plain"),s=(t.originalEvent||t).dataTransfer.files;s.length?n.addFile(s):l&&c(i),e.classList.remove("jeditor-dragging"),t.preventDefault()}},y=function(){n.options.onblur(n,e,n.getData())},E=function(){n.options.onfocus(n,e,n.getData())};if(u.addEventListener("mouseup",A),u.addEventListener("mousedown",I),u.addEventListener("mousemove",b),u.addEventListener("keyup",f),u.addEventListener("keydown",h),u.addEventListener("dragstart",j),u.addEventListener("dragenter",v),u.addEventListener("dragover",x),u.addEventListener("drop",w),u.addEventListener("paste",m),"function"==typeof n.options.onblur&&u.addEventListener("blur",y),"function"==typeof n.options.onfocus&&u.addEventListener("focus",E),"function"==typeof n.options.onload&&n.options.onload(e,u),u.innerHTML=g,e.appendChild(u),n.options.snippet&&p(n.options.snippet),null==n.options.toolbar&&(n.options.toolbar=jSuites.editor.getDefaultToolbar()),n.options.toolbar){for(var N=0;N<n.options.toolbar.length;N++)if(n.options.toolbar[N].icon){(M=document.createElement("div")).style.userSelect="none";var L=document.createElement("i");L.className="material-icons",L.innerHTML=n.options.toolbar[N].icon,L.onclick=function(t){var r=t;return function(){n.options.toolbar[r].onclick(e,n,this)}}(N),M.appendChild(L),s.appendChild(M)}else if("divisor"==n.options.toolbar[N].type)(M=document.createElement("div")).className="jeditor-toolbar-divisor",s.appendChild(M);else if("button"==n.options.toolbar[N].type){var M;(M=document.createElement("div")).classList.add("jeditor-toolbar-button"),M.innerHTML=n.options.toolbar[N].value,s.appendChild(M)}e.appendChild(s)}return n.options.focus&&jSuites.editor.setCursor(u,"initial"==n.options.focus),e.editor=n,n},jSuites.editor.setCursor=function(e,t){e.focus(),document.execCommand("selectAll");var n=window.getSelection(),r=n.getRangeAt(0);if(1==t)var o=r.startContainer,i=0;else i=(o=r.endContainer).length;r.setStart(o,i),r.setEnd(o,i),n.removeAllRanges(),n.addRange(r)},jSuites.editor.getDomain=function(e){return e.replace("http://","").replace("https://","").replace("www.","").split(/[/?#]/)[0].split(/:/g)[0]},jSuites.editor.detectUrl=function(e){var t=e.match(/(((https?:\/\/)|(www\.))[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|]+)/gi);return t&&"www"==t[0].substr(0,3)&&(t[0]="http://"+t[0]),t},jSuites.editor.youtubeParser=function(e){var t=e.match(/^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#\&\?]*).*/);return!(!t||11!=t[7].length)&&t[7]},jSuites.editor.getDefaultToolbar=function(){return[{icon:"undo",onclick:function(){document.execCommand("undo")}},{icon:"redo",onclick:function(){document.execCommand("redo")}},{type:"divisor"},{icon:"format_bold",onclick:function(e,t,n){document.execCommand("bold"),document.queryCommandState("bold")?n.classList.add("selected"):n.classList.remove("selected")}},{icon:"format_italic",onclick:function(e,t,n){document.execCommand("italic"),document.queryCommandState("italic")?n.classList.add("selected"):n.classList.remove("selected")}},{icon:"format_underline",onclick:function(e,t,n){document.execCommand("underline"),document.queryCommandState("underline")?n.classList.add("selected"):n.classList.remove("selected")}},{type:"divisor"},{icon:"format_list_bulleted",onclick:function(e,t,n){document.execCommand("insertUnorderedList"),document.queryCommandState("insertUnorderedList")?n.classList.add("selected"):n.classList.remove("selected")}},{icon:"format_list_numbered",onclick:function(e,t,n){document.execCommand("insertOrderedList"),document.queryCommandState("insertOrderedList")?n.classList.add("selected"):n.classList.remove("selected")}},{icon:"format_indent_increase",onclick:function(e,t,n){document.execCommand("indent",!0,null),document.queryCommandState("indent")?n.classList.add("selected"):n.classList.remove("selected")}},{icon:"format_indent_decrease",onclick:function(e,t,n){document.execCommand("outdent"),document.queryCommandState("outdent")?n.classList.add("selected"):n.classList.remove("selected")}}]},jSuites.image=function(e,t){var n={options:{}},r={minWidth:!1,onchange:null,singleFile:!0,remoteParser:null,text:{extensionNotAllowed:"The extension is not allowed",imageTooSmall:"The resolution is too low, try a image with a better resolution. width > 800px"}};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];e.classList.add("jupload"),n.addImage=function(e){e.date||(e.date="");var t=document.createElement("img");return t.setAttribute("data-date",e.lastmodified?e.lastmodified:e.date),t.setAttribute("data-name",e.name),t.setAttribute("data-size",e.size),t.setAttribute("data-small",e.small?e.small:""),t.setAttribute("data-cover",e.cover?1:0),t.setAttribute("data-extension",e.extension),t.setAttribute("src",e.file),t.className="jfile",t.style.width="100%",t},n.addImages=function(t){1==n.options.singleFile&&(e.innerHTML="");for(var r=0;r<t.length;r++)e.appendChild(n.addImage(t[r]))},n.addFromFile=function(t){if("image"==t.type.split("/")[0]){1==n.options.singleFile&&(e.innerHTML="");var r=new FileReader;r.addEventListener("load",(function(r){var o=new Image;o.onload=function(){var r=document.createElement("canvas");r.width=o.width,r.height=o.height,r.getContext("2d").drawImage(o,0,0,r.width,r.height);var i={file:r.toDataURL(),extension:t.name.substr(t.name.lastIndexOf(".")+1),name:t.name,size:t.size,lastmodified:t.lastModified},a=n.addImage(i);e.appendChild(a),"function"==typeof n.options.onchange&&n.options.onchange(a)},o.src=r.srcElement.result})),r.readAsDataURL(t)}else alert(text.extentionNotAllowed)},n.addFromUrl=function(t){if("data"==t.substr(0,4)||n.options.remoteParser){if("data"==t.substr(0,4))r=(r=(r=t.split(";"))[0].split("/"))[1];else{var r=t.substr(t.lastIndexOf(".")+1);t=n.options.remoteParser+t}var o=new Image;o.onload=function(){var t=document.createElement("canvas");t.width=o.width,t.height=o.height,t.getContext("2d").drawImage(o,0,0,t.width,t.height),t.toBlob((function(o){var i={file:window.URL.createObjectURL(o),extension:r},a=n.addImage(i);e.appendChild(a);var l=t.toDataURL();jSuites.files[i.file]=l.substr(l.indexOf(",")+1),"function"==typeof n.options.onchange&&n.options.onchange(a)}))},o.src=t}else console.error("remoteParser not defined in your initialization")};var i=document.createElement("input");return i.type="file",i.setAttribute("accept","image/*"),i.onchange=function(){for(var e=0;e<this.files.length;e++)n.addFromFile(this.files[e])},e.addEventListener("dblclick",(function(e){jSuites.click(i)})),e.addEventListener("dragenter",(function(t){e.style.border="1px dashed #000"})),e.addEventListener("dragleave",(function(t){e.style.border="1px solid #eee"})),e.addEventListener("dragstop",(function(t){e.style.border="1px solid #eee"})),e.addEventListener("dragover",(function(e){e.preventDefault()})),e.addEventListener("drop",(function(t){t.preventDefault(),t.stopPropagation();var r=(t.originalEvent||t).dataTransfer.getData("text/html");if((t.originalEvent||t).dataTransfer.files.length)for(var o=0;o<t.dataTransfer.files.length;o++)n.addFromFile(t.dataTransfer.files[o]);else if(r){1==n.options.singleFile&&(e.innerHTML="");var i=document.createElement("div");i.innerHTML=r;var a=i.querySelectorAll("img");if(a.length)for(o=0;o<a.length;o++)n.addFromUrl(a[o].src)}return e.style.border="1px solid #eee",!1})),e.image=n,n},jSuites.loading=function(){var e={},t=document.createElement("div");return t.className="jloading",e.show=function(){document.body.appendChild(t)},e.hide=function(){document.body.removeChild(t)},e}(),jSuites.login=function(e,t){var n={options:{}},r={url:window.location.href,prepareRequest:null,accessToken:null,deviceToken:null,facebookUrl:null,facebookAuthentication:null,maxHeight:null,onload:null,onsuccess:null,onerror:null,message:null,logo:null,newProfile:!1,newProfileUrl:!1,newProfileLogin:!1,fullscreen:!1,newPasswordValidation:null};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];if(!n.options.message){var i=document.querySelector(".message");i&&(n.options.message=i)}var a=null,l=document.createElement("form");e.appendChild(l);var s=document.createElement("div");if(s.className="jlogin-logo",l.appendChild(s),n.options.logo){var u=document.createElement("img");u.src=n.options.logo,s.appendChild(u)}var g=document.createElement("label");g.innerHTML="Please enter here the code received";var c=document.createElement("input");c.type="number",c.id="code",c.setAttribute("maxlength",6);var d=document.createElement("div");d.appendChild(g),d.appendChild(c);var p=document.createElement("input");p.type="hidden",p.name="h";var C=document.createElement("div");C.appendChild(p);var A=document.createElement("input");A.type="hidden",A.name="recovery",A.value="1";var I=document.createElement("div");I.appendChild(A);var b=document.createElement("label");b.innerHTML="Login";var f=document.createElement("input");f.type="text",f.name="login",f.setAttribute("autocomplete","off"),f.onkeyup=function(){this.value=this.value.toLowerCase().replace(/[^a-zA-Z0-9_+]+/gi,"")};var h=document.createElement("div");h.appendChild(b),h.appendChild(f);var m=document.createElement("label");m.innerHTML="Name";var j=document.createElement("input");j.type="text",j.name="name";var v=document.createElement("div");v.appendChild(m),v.appendChild(j);var x=document.createElement("label");x.innerHTML="E-mail";var w=document.createElement("input");w.type="text",w.name="username",w.setAttribute("autocomplete","new-username");var y=document.createElement("div");y.appendChild(x),y.appendChild(w);var E=document.createElement("label");E.innerHTML="New password";var N=document.createElement("input");N.type="password",N.name="password",N.setAttribute("autocomplete","new-password");var L=document.createElement("div");L.appendChild(E),L.appendChild(N),L.onkeydown=function(e){13==e.keyCode&&n.execute()};var M=document.createElement("label");M.innerHTML="Repeat the new password";var S=document.createElement("input");S.type="password",S.name="password";var k=document.createElement("div");k.appendChild(M),k.appendChild(S);var D=document.createElement("label");D.innerHTML="Remember me on this device";var T=document.createElement("input");T.type="checkbox",T.name="remember",T.value="1",D.appendChild(T);var R=document.createElement("div");R.className="rememberButton",R.appendChild(D);var F=document.createElement("input");F.type="button",F.value="Log In",F.onclick=function(){n.execute()};var O=document.createElement("div");O.appendChild(F);var H=document.createElement("div");H.innerHTML="Cancel",H.className="cancelButton",H.onclick=function(){n.requestAccess()};var P=document.createElement("div");P.appendChild(H);var B=document.createElement("label");B.innerHTML="Please type here the code below";var z=document.createElement("input");z.type="text",z.name="captcha";var V=document.createElement("img"),Y=document.createElement("div");Y.className="jlogin-captcha",Y.appendChild(B),Y.appendChild(z),Y.appendChild(V);var U=document.createElement("div");U.innerHTML="Login with Facebook",U.className="facebookButton";var W=document.createElement("div");W.appendChild(U),W.onclick=function(){n.requestLoginViaFacebook()};var G=document.createElement("span");G.innerHTML="Request a new password";var Z=document.createElement("div");Z.className="requestButton",Z.appendChild(G),Z.onclick=function(){n.requestNewPassword()};var X=document.createElement("span");X.innerHTML="Create a new profile";var _=document.createElement("div");_.className="newProfileButton",_.appendChild(X),_.onclick=function(){n.newProfile()},e.className="jlogin",1==n.options.fullscreen&&e.classList.add("jlogin-fullscreen"),n.showMessage=function(e){"object"==typeof e&&e.message,"function"==typeof n.options.showMessage?n.options.showMessage(e):jSuites.alert(e)},n.newProfile=function(){l.innerHTML="",l.appendChild(s),n.options.newProfileLogin&&l.appendChild(h),l.appendChild(v),l.appendChild(y),l.appendChild(O),1==n.options.facebookAuthentication&&l.appendChild(W),l.appendChild(P),f.value="",w.value="",N.value="",F.value="Create new profile",a="newProfile"},n.requestNewPassword=function(){if(Array.prototype.indexOf.call(l.children,Y)>=0)var e=!0;l.innerHTML="",l.appendChild(s),l.appendChild(I),l.appendChild(y),e&&l.appendChild(Y),l.appendChild(O),l.appendChild(P),F.value="Request a new password",A.value=1,a="requestNewPassword"},n.codeConfirmation=function(){l.innerHTML="",l.appendChild(s),l.appendChild(C),l.appendChild(d),l.appendChild(O),l.appendChild(P),F.value="Confirm code",A.value=2,a="codeConfirmation"},n.changeMyPassword=function(e){l.innerHTML="",l.appendChild(s),l.appendChild(C),l.appendChild(L),l.appendChild(k),l.appendChild(O),l.appendChild(P),F.value="Change my password",p.value=e,a="changeMyPassword"},n.requestAccess=function(){l.innerHTML="",l.appendChild(s),l.appendChild(y),l.appendChild(L),l.appendChild(O),1==n.options.facebookAuthentication&&l.appendChild(W),l.appendChild(Z),l.appendChild(R),l.appendChild(Z),1==n.options.newProfile&&l.appendChild(_),F.value="Login",N.value="",window.localStorage.getItem("username")?(w.value=window.localStorage.getItem("username"),N.focus()):w.focus(),a="requestAccess"},n.requestLoginViaFacebook=function(){"undefined"==typeof deviceNotificationToken?FB.getLoginStatus((function(e){e.status&&"connected"==e.status?n.execute({f:e.authResponse.accessToken}):FB.login((function(e){e.authResponse?n.execute({f:e.authResponse.accessToken}):n.showMessage("Not authorized by facebook")}),{scope:"public_profile,email"})}),!0):(jDestroy=function(){fbLogin.removeEventListener("loadstart",jStart),fbLogin.removeEventListener("loaderror",jError),fbLogin.removeEventListener("exit",jExit),fbLogin.close(),fbLogin=null},jStart=function(e){var t=e.url;t.indexOf("access_token")>=0&&setTimeout((function(){var e=t.match(/=(.*?)&/);e[1].length>32&&n.execute({f:e[1]}),jDestroy()}),500),t.indexOf("error=access_denied")>=0&&(setTimeout(jDestroy,500),n.showMessage("Not authorized by facebook"))},jError=function(e){jDestroy()},jExit=function(e){jDestroy()},fbLogin=window.open(n.options.facebookUrl,"_blank","location=no,closebuttoncaption=Exit,disallowoverscroll=yes,toolbar=no"),fbLogin.addEventListener("loadstart",jStart),fbLogin.addEventListener("loaderror",jError),fbLogin.addEventListener("exit",jExit)),a="requestLoginViaFacebook"},n.execute=function(t){if("newProfile"==a){var r=new RegExp(/^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/);if(!w.value||!r.test(w.value))var o="Invalid e-mail address";if(r=new RegExp(/^[a-zA-Z0-9\_\-\.\s+]+$/),f.value&&r.test(f.value)||(o="Invalid username, please use only characters and numbers"),o)return n.showMessage(o),!1}else if("changeMyPassword"==a){if(N.value.length<3)o="Password is too short";else if(N.value!=S.value)o="Password should match";else if("function"==typeof n.options.newPasswordValidation){var i=n.options.newPasswordValidation(n,N.value,N.value);null!=i&&(o=i)}if(o)return n.showMessage(o),!1}if(""!=w.value&&window.localStorage.setItem("username",w.value),Array.prototype.indexOf.call(l.children,Y)>=0&&""==z.value)return n.showMessage("Please enter the captch code below"),!1;var s=n.options.url;n.options.deviceToken&&(s+="?token="+n.options.deviceToken),t||((t=jSuites.getFormElements(e)).password&&(t.password=jSuites.login.sha512(t.password)),Array.prototype.indexOf.call(l.children,d)>=0&&c.value&&(t.h=jSuites.login.sha512(c.value))),e.classList.add("jlogin-loading"),s="newProfile"==a&&n.options.newProfileUrl?n.options.newProfileUrl:n.options.url,jSuites.ajax({url:s,method:"POST",dataType:"json",data:t,success:function(t){e.classList.remove("jlogin-loading"),function(e){e&&(1==e.success&&("requestNewPassword"==a?n.codeConfirmation():"codeConfirmation"==a?n.requestAccess():"newProfile"==a&&(n.requestAccess(),e.newProfile=!0),e.token&&(n.options.accessToken=e.token,window.localStorage.setItem("Access-Token",e.token))),e.message&&n.showMessage(e.message),e.data?(l.insertBefore(Y,O),V.setAttribute("src","data:image/png;base64,"+e.data)):Array.prototype.indexOf.call(l.children,Y)>=0&&Y.remove(),e.hash?n.changeMyPassword(e.hash):e.url&&(1==e.success?"function"==typeof n.options.onsuccess?n.options.onsuccess(e):e.message?setTimeout((function(){window.location.href=e.url}),2e3):window.location.href=e.url:"function"==typeof n.options.onerror&&n.options.onerror(e)))}(t)},error:function(t){e.classList.remove("jlogin-loading"),"function"==typeof n.options.onerror&&n.options.onerror(t)}})};var K=window.location.href.split("?");return K[1]&&130==K[1].length&&"h="==K[1].substr(0,2)?n.changeMyPassword(K[1].substr(2)):n.requestAccess(),n},jSuites.login.sha512=function(e){function t(e,t){this.highOrder=e,this.lowOrder=t}var n,r,o,i,a,l,s,u,g,c,d=[new t(1779033703,4089235720),new t(3144134277,2227873595),new t(1013904242,4271175723),new t(2773480762,1595750129),new t(1359893119,2917565137),new t(2600822924,725511199),new t(528734635,4215389547),new t(1541459225,327033209)],p=[new t(1116352408,3609767458),new t(1899447441,602891725),new t(3049323471,3964484399),new t(3921009573,2173295548),new t(961987163,4081628472),new t(1508970993,3053834265),new t(2453635748,2937671579),new t(2870763221,3664609560),new t(3624381080,2734883394),new t(310598401,1164996542),new t(607225278,1323610764),new t(1426881987,3590304994),new t(1925078388,4068182383),new t(2162078206,991336113),new t(2614888103,633803317),new t(3248222580,3479774868),new t(3835390401,2666613458),new t(4022224774,944711139),new t(264347078,2341262773),new t(604807628,2007800933),new t(770255983,1495990901),new t(1249150122,1856431235),new t(1555081692,3175218132),new t(1996064986,2198950837),new t(2554220882,3999719339),new t(2821834349,766784016),new t(2952996808,2566594879),new t(3210313671,3203337956),new t(3336571891,1034457026),new t(3584528711,2466948901),new t(113926993,3758326383),new t(338241895,168717936),new t(666307205,1188179964),new t(773529912,1546045734),new t(1294757372,1522805485),new t(1396182291,2643833823),new t(1695183700,2343527390),new t(1986661051,1014477480),new t(2177026350,1206759142),new t(2456956037,344077627),new t(2730485921,1290863460),new t(2820302411,3158454273),new t(3259730800,3505952657),new t(3345764771,106217008),new t(3516065817,3606008344),new t(3600352804,1432725776),new t(4094571909,1467031594),new t(275423344,851169720),new t(430227734,3100823752),new t(506948616,1363258195),new t(659060556,3750685593),new t(883997877,3785050280),new t(958139571,3318307427),new t(1322822218,3812723403),new t(1537002063,2003034995),new t(1747873779,3602036899),new t(1955562222,1575990012),new t(2024104815,1125592928),new t(2227730452,2716904306),new t(2361852424,442776044),new t(2428436474,593698344),new t(2756734187,3733110249),new t(3204031479,2999351573),new t(3329325298,3815920427),new t(3391569614,3928383900),new t(3515267271,566280711),new t(3940187606,3454069534),new t(4118630271,4000239992),new t(116418474,1914138554),new t(174292421,2731055270),new t(289380356,3203993006),new t(460393269,320620315),new t(685471733,587496836),new t(852142971,1086792851),new t(1017036298,365543100),new t(1126000580,2618297676),new t(1288033470,3409855158),new t(1501505948,4234509866),new t(1607167915,987167468),new t(1816402316,1246189591)],C=new Array(64);function A(e,n){var r,o,i;return r=(65535&e.lowOrder)+(65535&n.lowOrder),i=(65535&(o=(e.lowOrder>>>16)+(n.lowOrder>>>16)+(r>>>16)))<<16|65535&r,r=(65535&e.highOrder)+(65535&n.highOrder)+(o>>>16),new t((65535&(o=(e.highOrder>>>16)+(n.highOrder>>>16)+(r>>>16)))<<16|65535&r,i)}function I(e,n,r,o){var i,a,l;return i=(65535&e.lowOrder)+(65535&n.lowOrder)+(65535&r.lowOrder)+(65535&o.lowOrder),l=(65535&(a=(e.lowOrder>>>16)+(n.lowOrder>>>16)+(r.lowOrder>>>16)+(o.lowOrder>>>16)+(i>>>16)))<<16|65535&i,i=(65535&e.highOrder)+(65535&n.highOrder)+(65535&r.highOrder)+(65535&o.highOrder)+(a>>>16),new t((65535&(a=(e.highOrder>>>16)+(n.highOrder>>>16)+(r.highOrder>>>16)+(o.highOrder>>>16)+(i>>>16)))<<16|65535&i,l)}function b(e,n,r,o,i){var a,l,s;return a=(65535&e.lowOrder)+(65535&n.lowOrder)+(65535&r.lowOrder)+(65535&o.lowOrder)+(65535&i.lowOrder),s=(65535&(l=(e.lowOrder>>>16)+(n.lowOrder>>>16)+(r.lowOrder>>>16)+(o.lowOrder>>>16)+(i.lowOrder>>>16)+(a>>>16)))<<16|65535&a,a=(65535&e.highOrder)+(65535&n.highOrder)+(65535&r.highOrder)+(65535&o.highOrder)+(65535&i.highOrder)+(l>>>16),new t((65535&(l=(e.highOrder>>>16)+(n.highOrder>>>16)+(r.highOrder>>>16)+(o.highOrder>>>16)+(i.highOrder>>>16)+(a>>>16)))<<16|65535&a,s)}function f(e,n,r){return new t(e.highOrder&n.highOrder^e.highOrder&r.highOrder^n.highOrder&r.highOrder,e.lowOrder&n.lowOrder^e.lowOrder&r.lowOrder^n.lowOrder&r.lowOrder)}function h(e,n,r){return new t(e.highOrder&n.highOrder^~e.highOrder&r.highOrder,e.lowOrder&n.lowOrder^~e.lowOrder&r.lowOrder)}function m(e,n){return n<=32?new t(e.highOrder>>>n|e.lowOrder<<32-n,e.lowOrder>>>n|e.highOrder<<32-n):new t(e.lowOrder>>>n|e.highOrder<<32-n,e.highOrder>>>n|e.lowOrder<<32-n)}function j(e){var n=m(e,28),r=m(e,34),o=m(e,39);return new t(n.highOrder^r.highOrder^o.highOrder,n.lowOrder^r.lowOrder^o.lowOrder)}function v(e){var n=m(e,14),r=m(e,18),o=m(e,41);return new t(n.highOrder^r.highOrder^o.highOrder,n.lowOrder^r.lowOrder^o.lowOrder)}function x(e){var n=m(e,1),r=m(e,8),o=w(e,7);return new t(n.highOrder^r.highOrder^o.highOrder,n.lowOrder^r.lowOrder^o.lowOrder)}function w(e,n){return n<=32?new t(e.highOrder>>>n,e.lowOrder>>>n|e.highOrder<<32-n):new t(0,e.highOrder<<32-n)}var y,E,N,L,M=8*(e=function(e){return unescape(encodeURIComponent(e))}(e)).length;(e=function(e){for(var t=[],n=8*e.length,r=0;r<n;r+=8)t[r>>5]|=(255&e.charCodeAt(r/8))<<24-r%32;return t}(e))[M>>5]|=128<<24-M%32,e[31+(M+128>>10<<5)]=M;for(var S=0;S<e.length;S+=32){n=d[0],r=d[1],o=d[2],i=d[3],a=d[4],l=d[5],s=d[6],u=d[7];for(var k=0;k<80;k++)C[k]=k<16?new t(e[2*k+S],e[2*k+S+1]):I((void 0,void 0,void 0,E=m(y=C[k-2],19),N=m(y,61),L=w(y,6),new t(E.highOrder^N.highOrder^L.highOrder,E.lowOrder^N.lowOrder^L.lowOrder)),C[k-7],x(C[k-15]),C[k-16]),g=b(u,v(a),h(a,l,s),p[k],C[k]),c=A(j(n),f(n,r,o)),u=s,s=l,l=a,a=A(i,g),i=o,o=r,r=n,n=A(g,c);d[0]=A(n,d[0]),d[1]=A(r,d[1]),d[2]=A(o,d[2]),d[3]=A(i,d[3]),d[4]=A(a,d[4]),d[5]=A(l,d[5]),d[6]=A(s,d[6]),d[7]=A(u,d[7])}var D=[];for(S=0;S<d.length;S++)D.push(d[S].highOrder),D.push(d[S].lowOrder);return function(e){for(var t,n="0123456789abcdef",r="",o=4*e.length,i=0;i<o;i+=1)t=e[i>>2]>>8*(3-i%4),r+=n.charAt(t>>4&15)+n.charAt(15&t);return r}(D)},jSuites.mask=function(){var e={},t=0,n=[],r=[];return e.run=function(r,o,i){if(r&&o){if(i||(i="."),r==Number(r))var a=(""+r).split("."),l=(r=a[0],a[1]);else r=""+r;var s;if(t=0,n=[],e.prepare(o),s=r)for(var u=0;u<s.length;u++)null!=s[u]&&e.process(s[u]);if(l&&(e.process(i),s=l))for(u=0;u<s.length;u++)null!=s[u]&&e.process(s[u]);return n.join("")}return""},e.apply=function(o){if(o.target&&!o.target.getAttribute("readonly")){var i=o.target.getAttribute("data-mask");if(i&&o.keyCode>46){if(t=0,n=[],e.prepare(i),o.target.selectionStart<o.target.selectionEnd)var a=o.target.value.substring(0,o.target.selectionStart);else a=o.target.value;if(a)for(var l=0;l<a.length;l++)null!=a[l]&&e.process(a[l]);e.process(e.fromKeyCode(o)),o.target.value=n.join(""),r.length==n.length&&r[r.length-1].length==n[n.length-1].length?o.target.setAttribute("data-completed","true"):o.target.setAttribute("data-completed","false"),o.preventDefault()}}},e.process=function(e){do{if("mm"==r[t])return null==n[t]||""==n[t]?parseInt(e)>1&&parseInt(e)<10?(n[t]="0"+e,t++,!0):parseInt(e)<10&&(n[t]=e,!0):(1==n[t]&&n[t]<2&&parseInt(e)<3||0==n[t]&&n[t]<10)&&(n[t]+=e,t++,!0);if("dd"==r[t])return null==n[t]||""==n[t]?parseInt(e)>3&&parseInt(e)<10?(n[t]="0"+e,t++,!0):parseInt(e)<10&&(n[t]=e,!0):(3==n[t]&&parseInt(e)<2||n[t]<3&&parseInt(e)<10)&&(n[t]+=e,t++,!0);if("hh24"==r[t])return null==n[t]||""==n[t]?parseInt(e)>2&&parseInt(e)<10?(n[t]="0"+e,t++,!0):parseInt(e)<10&&(n[t]=e,!0):(2==n[t]&&parseInt(e)<4||n[t]<2&&parseInt(e)<10)&&(n[t]+=e,t++,!0);if("hh"==r[t])return null==n[t]||""==n[t]?parseInt(e)>1&&parseInt(e)<10?(n[t]="0"+e,t++,!0):parseInt(e)<10&&(n[t]=e,!0):(1==n[t]&&parseInt(e)<3||n[t]<1&&parseInt(e)<10)&&(n[t]+=e,t++,!0);if("mi"==r[t]||"ss"==r[t])return null==n[t]||""==n[t]?parseInt(e)>5&&parseInt(e)<10?(n[t]="0"+e,t++,!0):parseInt(e)<10&&(n[t]=e,!0):parseInt(e)<10&&(n[t]+=e,t++,!0);if("yy"==r[t]||"yyyy"==r[t])return parseInt(e)<10&&(null==n[t]||""==n[t]?n[t]=e:n[t]+=e,n[t].length==r[t].length&&t++,!0);if("#"==r[t]||"#.##"==r[t]||"#,##"==r[t]||"# ##"==r[t]){if(e.match(/[0-9]/g)){if("#.##"==r[t])var o=".";else o="#,##"==r[t]?",":"# ##"==r[t]?" ":"";if(null==n[t]||""==n[t])n[t]=e;else if(n[t]+=e,o){n[t]=n[t].match(/[0-9]/g).join("");for(var i=[],a=0,l=n[t].length-1;l>=0;l--)i.push(n[t][l]),++a%3||i.push(o);i=i.reverse(),n[t]=i.join(""),n[t].substr(0,1)==o&&(n[t]=n[t].substr(1))}return!0}if("#.##"==r[t]&&"."==e);else if("#,##"==r[t]&&","==e);else if("# ##"==r[t]&&" "==e);else if(n[t]&&(t++,r[t])){if(r[t]==e)return n[t]=e,!0;if("0"==r[t]&&r[t+1]==e)return t++,n[t]=e,!0}return!1}if("0"==r[t])return!!e.match(/[0-9]/g)&&(n[t]=e,t++,!0);if("a"==r[t])return!!e.match(/[a-zA-Z]/g)&&(n[t]=e,t++,!0);if(null!=r[t]){if("\\a"==r[t])var s="a";else s="\\0"==r[t]?"0":"[-]"==r[t]?"-"==e||"+"==e?e:" ":r[t];if(n[t]=s,e==s)return t++,!0}t++}while(r[t])},e.prepare=function(e){r=[];for(var t=0;t<e.length;t++)e[t].match(/[0-9]|[a-z]|\\/g)?"y"==e[t]&&"y"==e[t+1]&&"y"==e[t+2]&&"y"==e[t+3]?(r.push("yyyy"),t+=3):"y"==e[t]&&"y"==e[t+1]?(r.push("yy"),t++):"m"==e[t]&&"m"==e[t+1]&&"m"==e[t+2]&&"m"==e[t+3]?(r.push("mmmm"),t+=3):"m"==e[t]&&"m"==e[t+1]&&"m"==e[t+2]?(r.push("mmm"),t+=2):"m"==e[t]&&"m"==e[t+1]?(r.push("mm"),t++):"d"==e[t]&&"d"==e[t+1]?(r.push("dd"),t++):"h"==e[t]&&"h"==e[t+1]&&"2"==e[t+2]&&"4"==e[t+3]?(r.push("hh24"),t+=3):"h"==e[t]&&"h"==e[t+1]?(r.push("hh"),t++):"m"==e[t]&&"i"==e[t+1]?(r.push("mi"),t++):"s"==e[t]&&"s"==e[t+1]?(r.push("ss"),t++):"a"==e[t]&&"m"==e[t+1]?(r.push("am"),t++):"p"==e[t]&&"m"==e[t+1]?(r.push("pm"),t++):"\\"==e[t]&&"0"==e[t+1]?(r.push("\\0"),t++):"\\"==e[t]&&"a"==e[t+1]?(r.push("\\a"),t++):r.push(e[t]):"#"==e[t]&&"."==e[t+1]&&"#"==e[t+2]&&"#"==e[t+3]?(r.push("#.##"),t+=3):"#"==e[t]&&","==e[t+1]&&"#"==e[t+2]&&"#"==e[t+3]?(r.push("#,##"),t+=3):"#"==e[t]&&" "==e[t+1]&&"#"==e[t+2]&&"#"==e[t+3]?(r.push("# ##"),t+=3):"["==e[t]&&"-"==e[t+1]&&"]"==e[t+2]?(r.push("[-]"),t+=2):r.push(e[t])},e.fromKeyCode=function(e){var t={188:"44",109:"45",190:"46",191:"47",192:"96",220:"92",222:"39",221:"93",219:"91",173:"45",187:"61",186:"59",189:"45"},n={96:"~",49:"!",50:"@",51:"#",52:"$",53:"%",54:"^",55:"&",56:"*",57:"(",48:")",45:"_",61:"+",91:"{",93:"}",92:"|",59:":",39:'"',44:"<",46:">",47:"?"},r=e.which;return t.hasOwnProperty(r)&&(r=t[r]),!e.shiftKey&&r>=65&&r<=90?String.fromCharCode(r+32):e.shiftKey&&n.hasOwnProperty(r)?n[r]:96<=r&&r<=105?String.fromCharCode(r-48):String.fromCharCode(r)},e}(),jSuites.mobile=(jSuites.el&&jSuites.el.addEventListener("mousedown",(function(e){e.target.classList.contains("option-title")&&(e.target.classList.contains("selected")?e.target.classList.remove("selected"):e.target.classList.add("selected"))})),{options:{}}),jSuites.pages=function(){var container=null,current=null,createPage=function(options,callback){var page=document.createElement("div");return page.classList.add("page"),page.style.display="none",page.options=options||{},current?container.insertBefore(page,current.nextSibling):container.appendChild(page),jSuites.ajax({url:page.options.url,method:"GET",success:function(result){jSuites.refresh(page,page.options.onpush),page.innerHTML=result;for(var script=page.getElementsByTagName("script"),i=0;i<script.length;i++){var type=script[i].getAttribute("type");type&&"text/javascript"!=type||eval(script[i].innerHTML)}page.setTitle=function(e){this.children[0].children[0].children[1].innerHTML=e},page.options.closed||showPage(page),"function"==typeof page.options.onload&&page.options.onload(page),"function"==typeof callback&&callback(page)}}),page},showPage=function(e,t,n){if(current)if(current==e)current=e;else{window.scrollTo({top:0}),e.style.display="";var r=Array.prototype.indexOf.call(container.children,current),o=Array.prototype.indexOf.call(container.children,e);"function"==typeof current.options.onleave&&current.options.onleave(current,e,t),jSuites.slideLeft(container,r<o?0:1,(function(){current.style.display="none",current=e})),"function"==typeof e.options.onenter&&e.options.onenter(e,current,t)}else e.style.display="",current=e,"function"==typeof e.options.onenter&&e.options.onenter(e);t||window.history.pushState({route:e.options.route},e.options.title,e.options.route),"function"==typeof n&&n(e)},obj=function(e,t){if(container||((container=document.querySelector(".pages"))||((container=document.createElement("div")).className="pages"),jSuites.el?jSuites.el.appendChild(container):document.body.appendChild(container)),obj.pages[e]){if(t){var n=0;"function"==typeof t?o=t:("function"==typeof t.onenter&&(obj.pages[e].options.onenter=t.onenter),"function"==typeof t.onleave&&(obj.pages[e].options.onleave=t.onleave),n=t.ignoreHistory?1:0)}showPage(obj.pages[e],n,o||null)}else if(e){if("function"==typeof t)var r={},o=t;else r=t||{};if(r.closed=t&&t.closed?1:0,r.route=e,!r.url){var i=e.split("#");r.url=jSuites.pages.path+i[0]+".html"}r.title||(r.title="Untitled"),obj.pages[e]=createPage(r,o||null)}else alert("Error, no route provided")};return obj.pages={},obj.get=function(e){if(obj.pages[e])return obj.pages[e]},obj.getContainer=function(){return container},obj.destroy=function(){current=null,obj.pages={},container&&(container.innerHTML="")},obj}(),jSuites.pages.path="pages",jSuites.panel=function(){var panel=null,obj=function(e){panel||obj.create(jSuites.pages.path+e+".html"),panel.style.display="",panel.classList.contains("panel-left")?jSuites.slideLeft(panel,1):jSuites.slideRight(panel,1)};return obj.create=function(route){if(panel||(panel=document.createElement("div"),panel.classList.add("panel"),panel.classList.add("panel-left"),panel.style.display="none",jSuites.el?jSuites.el.appendChild(panel):document.body.appendChild(panel)),route){var url=jSuites.pages.path+route+".html";jSuites.ajax({url,method:"GET",success:function(result){panel.innerHTML=result;for(var script=panel.getElementsByTagName("script"),i=0;i<script.length;i++){var type=script[i].getAttribute("type");type&&"text/javascript"!=type||eval(script[i].innerHTML)}}})}},obj.close=function(){panel&&(panel.classList.contains("panel-left")?jSuites.slideLeft(panel,0,(function(){panel.style.display="none"})):jSuites.slideRight(panel,0,(function(){panel.style.display="none"})))},obj.get=function(){return panel},obj.destroy=function(){panel.remove(),panel=null},obj}(),jSuites.toolbar=function(e,t){var n={};n.options=t,n.selectItem=function(e){for(var t=o.children,n=0;n<t.length;n++)t[n].classList.remove("selected");e.classList.add("selected")},n.hide=function(){jSuites.slideBottom(r,0,(function(){r.style.display="none"}))},n.show=function(){r.style.display="",jSuites.slideBottom(r,1)},n.get=function(){return r},n.setBadge=function(e,t){o.children[e].children[1].firstChild.innerHTML=t},n.destroy=function(){r.remove(),r=null};var r=document.createElement("div");r.classList.add("jtoolbar"),r.onclick=function(e){var t=jSuites.getElement(e.target,"jtoolbar-item");t&&n.selectItem(t)};var o=document.createElement("div");r.appendChild(o);for(var i=0;i<t.items.length;i++){var a=document.createElement("div");if(a.classList.add("jtoolbar-item"),t.items[i].route&&(a.setAttribute("data-href",t.items[i].route),jSuites.pages(t.items[i].route,{closed:!0,onenter:function(){n.selectItem(a)}})),t.items[i].icon){var l=document.createElement("i");l.classList.add("material-icons"),l.innerHTML=t.items[i].icon,a.appendChild(l)}var s=document.createElement("div");s.classList.add("jbadge");var u=document.createElement("div");if(u.innerHTML=t.items[i].badge?t.items[i].badge:"",s.appendChild(u),a.appendChild(s),t.items[i].title){var g=document.createElement("span");g.innerHTML=t.items[i].title,a.appendChild(g)}o.appendChild(a)}return e.toolbar=n,e.appendChild(r),n},jSuites.actionsheet=function(){var e=document.createElement("div");e.className="jactionsheet",e.style.display="none";var t=document.createElement("div");t.className="jactionsheet-content",e.appendChild(t);var n=function(r){r&&(n.options=r),t.innerHTML="";for(var o=0;o<n.options.length;o++){var i=document.createElement("div");i.className="jactionsheet-group";for(var a=0;a<n.options[o].length;a++){var l=n.options[o][a],s=document.createElement("div"),u=document.createElement("input");u.type="button",u.value=l.title,l.className&&(u.className=l.className),l.onclick&&(u.onclick=l.onclick),"cancel"==l.action&&(u.style.color="red"),s.appendChild(u),i.appendChild(s)}t.appendChild(i)}e.style.display="",jSuites.el.appendChild(e),jSuites.slideBottom(t,!0)};return n.close=function(){"none"!=e.style.display&&jSuites.slideBottom(t,!1,(function(){e.remove(),e.style.display="none"}))},e.addEventListener("mouseup",(function(e){n.close()})),n.options={},n}(),jSuites.modal=function(e,t){var n={options:{}},r={url:null,onopen:null,onclose:null,closed:!1,width:null,height:null,title:null};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];!n.options.title&&e.getAttribute("title")&&(n.options.title=e.getAttribute("title"));for(var i=document.createElement("div"),a=0;a<e.children.length;a++)i.appendChild(e.children[a]);for(n.content=document.createElement("div"),n.content.className="jmodal_content",n.content.innerHTML=e.innerHTML,a=0;a<i.children.length;a++)n.content.appendChild(i.children[a]);n.container=document.createElement("div"),n.container.className="jmodal",n.container.appendChild(n.content),n.options.width&&(n.container.style.width=n.options.width),n.options.height&&(n.container.style.height=n.options.height),n.options.title?n.container.setAttribute("title",n.options.title):n.container.classList.add("no-title"),e.innerHTML="",e.style.display="none",e.appendChild(n.container);var l=document.createElement("div");return l.className="jmodal_backdrop",e.appendChild(l),n.open=function(){e.style.display="block";const t=n.container.getBoundingClientRect();jSuites.getWindowWidth()<t.width?(n.container.style.top="",n.container.style.left="",n.container.classList.add("jmodal_fullscreen"),jSuites.slideBottom(n.container,1)):l.style.display="block",jSuites.modal.current=n,"function"==typeof n.options.onopen&&n.options.onopen(e,n)},n.resetPosition=function(){n.container.style.top="",n.container.style.left=""},n.isOpen=function(){return"none"!=e.style.display},n.close=function(){e.style.display="none",l.style.display="",jSuites.modal.current=null,n.container.classList.remove("jmodal_fullscreen"),"function"==typeof n.options.onclose&&n.options.onclose(e,n)},jSuites.modal.hasEvents||(jSuites.modal.current=n,"ontouchstart"in document.documentElement==1?document.addEventListener("touchstart",jSuites.modal.mouseDownControls):(document.addEventListener("mousedown",jSuites.modal.mouseDownControls),document.addEventListener("mousemove",jSuites.modal.mouseMoveControls),document.addEventListener("mouseup",jSuites.modal.mouseUpControls)),document.addEventListener("keydown",jSuites.modal.keyDownControls),jSuites.modal.hasEvents=!0),n.options.url?jSuites.ajax({url:n.options.url,method:"GET",success:function(e){n.content.innerHTML=e,n.options.closed||n.open()}}):n.options.closed||n.open(),e.modal=n,n},jSuites.modal.current=null,jSuites.modal.position=null,jSuites.modal.keyDownControls=function(e){27==e.which&&jSuites.modal.current&&jSuites.modal.current.close()},jSuites.modal.mouseUpControls=function(e){jSuites.modal.current&&(jSuites.modal.current.container.style.cursor="auto"),jSuites.modal.position=null},jSuites.modal.mouseMoveControls=function(e){if(jSuites.modal.current&&jSuites.modal.position)if(1==e.which||3==e.which){var t=jSuites.modal.position;jSuites.modal.current.container.style.top=t[1]+(e.clientY-t[3])+t[5]/2+"px",jSuites.modal.current.container.style.left=t[0]+(e.clientX-t[2])+t[4]/2+"px",jSuites.modal.current.container.style.cursor="move"}else jSuites.modal.current.container.style.cursor="auto"},jSuites.modal.mouseDownControls=function(e){jSuites.modal.position=[],e.target.classList.contains("jmodal")&&setTimeout((function(){var t=e.target.getBoundingClientRect();if(e.changedTouches&&e.changedTouches[0])var n=e.changedTouches[0].clientX,r=e.changedTouches[0].clientY;else n=e.clientX,r=e.clientY;t.width-(n-t.left)<50&&r-t.top<50?setTimeout((function(){jSuites.modal.current.close()}),100):e.target.getAttribute("title")&&r-t.top<50&&(document.selection?document.selection.empty():window.getSelection&&window.getSelection().removeAllRanges(),jSuites.modal.position=[t.left,t.top,e.clientX,e.clientY,t.width,t.height])}),100)},jSuites.notification=function(e){var t={options:{}},n={icon:null,name:"Notification",date:null,title:null,message:null,timeout:4e3,autoHide:!0,closeable:!0};for(var r in n)e&&e.hasOwnProperty(r)?t.options[r]=e[r]:t.options[r]=n[r];var o=document.createElement("div");o.className="jnotification";var i=document.createElement("div");i.className="jnotification-container",o.appendChild(i);var a=document.createElement("div");a.className="jnotification-header",i.appendChild(a);var l=document.createElement("div");if(l.className="jnotification-image",a.appendChild(l),t.options.icon){var s=document.createElement("img");s.src=t.options.icon,l.appendChild(s)}var u=document.createElement("div");if(u.className="jnotification-name",u.innerHTML=t.options.name,a.appendChild(u),1==t.options.closeable){var g=document.createElement("div");g.className="jnotification-close",g.onclick=function(){t.hide()},a.appendChild(g)}var c=document.createElement("div");c.className="jnotification-date",a.appendChild(c);var d=document.createElement("div");if(d.className="jnotification-content",i.appendChild(d),t.options.title){var p=document.createElement("div");p.className="jnotification-title",p.innerHTML=t.options.title,d.appendChild(p)}var C=document.createElement("div");return C.className="jnotification-message",C.innerHTML=t.options.message,d.appendChild(C),t.show=function(){document.body.appendChild(o),jSuites.getWindowWidth()>800?jSuites.fadeIn(o):jSuites.slideTop(o,1)},t.hide=function(){jSuites.getWindowWidth()>800?jSuites.fadeOut(o,(function(){o.parentNode.removeChild(o)})):jSuites.slideTop(o,0,(function(){o.parentNode.removeChild(o)}))},t.show(),1==t.options.autoHide&&setTimeout((function(){t.hide()}),t.options.timeout),jSuites.getWindowWidth()<800&&o.addEventListener("swipeup",(function(e){t.hide(),e.preventDefault(),e.stopPropagation()})),t},jSuites.rating=function(e,t){var n={options:{}},r={number:5,value:0,tooltip:["Very bad","Bad","Average","Good","Very good"],onchange:null};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];e.classList.add("jrating");for(var i=0;i<n.options.number;i++){var a=document.createElement("div");a.setAttribute("data-index",i+1),a.setAttribute("title",n.options.tooltip[i]),e.appendChild(a)}if(n.setValue=function(t){for(var r=0;r<n.options.number;r++)r<t?e.children[r].classList.add("jrating-selected"):(e.children[r].classList.remove("jrating-over"),e.children[r].classList.remove("jrating-selected"));n.options.value=t,"function"==typeof n.options.onchange&&n.options.onchange(e,t)},n.getValue=function(){return n.options.value},n.options.value)for(i=0;i<n.options.number;i++)i<n.options.value&&e.children[i].classList.add("jrating-selected");return e.addEventListener("click",(function(e){var t=e.target.getAttribute("data-index");null!=t&&(t==n.options.value?n.setValue(0):n.setValue(t))})),e.addEventListener("mouseover",(function(t){for(var r=t.target.getAttribute("data-index"),o=0;o<n.options.number;o++)o<r?e.children[o].classList.add("jrating-over"):e.children[o].classList.remove("jrating-over")})),e.addEventListener("mouseout",(function(t){for(var r=0;r<n.options.number;r++)e.children[r].classList.remove("jrating-over")})),e.rating=n,n},jSuites.slider=function(e,t){var n={options:{},currentImage:null};if(t&&(n.options=t),n.options.items=[],e.classList.contains("jslider"))r=e.querySelector("slider-container");else{var r;if(e.classList.add("jslider"),(r=document.createElement("div")).className="jslider-container",e.children.length>0)for(var o=0;o<e.children.length;o++)n.options.items.push(e.children[o]);if(n.options.items.length>0)for(o=0;o<n.options.items.length;o++){n.options.items[o].classList.add("jfile"),(i=n.options.items[o].src.lastIndexOf("/"))<0?n.options.items[o].setAttribute("data-name",n.options.items[o].src):n.options.items[o].setAttribute("data-name",n.options.items[o].src.substr(i+1));var i=n.options.items[o].src.lastIndexOf("/");r.appendChild(n.options.items[o])}e.appendChild(r);var a=document.createElement("div");a.className="jslider-close",a.innerHTML="",a.onclick=function(){n.close()},e.appendChild(a)}if(n.show=function(e){e||(e=r.children[0]),r.classList.contains("jslider-preview")||(r.classList.add("jslider-preview"),a.style.display="block");for(var t=0;t<r.children.length;t++)r.children[t].style.display="none";e.style.display="block",e.previousSibling?r.classList.add("jslider-left"):r.classList.remove("jslider-left"),e.nextSibling?r.classList.add("jslider-right"):r.classList.remove("jslider-right"),n.currentImage=e},n.open=function(){n.show(),"function"==typeof n.options.onopen&&n.options.onopen(e)},n.close=function(){r.classList.remove("jslider-preview"),r.classList.remove("jslider-left"),r.classList.remove("jslider-right");for(var t=0;t<r.children.length;t++)r.children[t].style.display="";a.style.display="",n.currentImage=null,"function"==typeof n.options.onclose&&n.options.onclose(e)},n.reset=function(){r.innerHTML=""},n.addFile=function(t,o){var i=document.createElement("img");i.setAttribute("data-lastmodified",t.lastmodified),i.setAttribute("data-name",t.name),i.setAttribute("data-size",t.size),i.setAttribute("data-extension",t.extension),i.setAttribute("data-cover",t.cover),i.setAttribute("src",t.file),i.className="jfile",r.appendChild(i),n.options.items.push(i),o||"function"==typeof n.options.onchange&&n.options.onchange(e,t)},n.addFiles=function(e){for(var t=0;t<e.length;t++)n.addFile(e[t])},n.next=function(){n.currentImage.nextSibling&&n.show(n.currentImage.nextSibling)},n.prev=function(){n.currentImage.previousSibling&&n.show(n.currentImage.previousSibling)},n.getData=function(){return jSuites.getFiles(r)},n.options.data&&n.options.data.length)for(o=0;o<n.options.data.length;o++)n.options.data[o]&&n.addFile(n.options.data[o]);if(n.options.allowAttachment){var l=document.createElement("input");l.type="file",l.className="slider-attachment",l.setAttribute("accept","image/*"),l.style.display="none",l.onchange=function(){for(var e=[],t=0;t<this.files.length;t++)if("image"==this.files[t].type.split("/")[0]){var r=this.files[t].name;r=(r=r.split("."))[r.length-1];var o={size:this.files[t].size,name:this.files[t].name,extension:r,cover:0,lastmodified:this.files[t].lastModified};e[t]=new FileReader,e[t].addEventListener("load",(function(e){o.file=e.target.result,n.addFile(o)}),!1),e[t].readAsDataURL(this.files[t])}else alert("The extension is not allowed")};var s=document.createElement("i");s.innerHTML="attachment",s.className="jslider-attach material-icons",s.onclick=function(){jSuites.click(l)},e.appendChild(l),e.appendChild(s)}var u=null,g=function(t){"IMG"==t.target.tagName&&(t.target,u=setTimeout((function(){"data"==t.target.src.substr(0,4)?t.target.remove():t.target.classList.contains("jremove")?t.target.classList.remove("jremove"):t.target.classList.add("jremove"),"function"==typeof n.options.onchange&&n.options.onchange(e,t.target)}),1e3))},c=function(e){u&&clearTimeout(u),"IMG"==e.target.tagName?e.target.classList.contains("jremove")||n.show(e.target):e.target.clientWidth-e.offsetX<40?n.next():e.offsetX<40&&n.prev()};return r.addEventListener("mousedown",g),r.addEventListener("touchstart",g),r.addEventListener("mouseup",c),r.addEventListener("touchend",c),e.addEventListener("swipeleft",(function(e){n.next(),e.preventDefault(),e.stopPropagation()})),e.addEventListener("swiperight",(function(e){n.prev(),e.preventDefault(),e.stopPropagation()})),e.slider=n,n},jSuites.sorting=function(e,t){e.classList.add("jsorting"),e.addEventListener("dragstart",(function(e){e.target.classList.add("dragging")})),e.addEventListener("dragover",(function(e){e.preventDefault(),e.target.clientHeight/2>e.offsetY?(e.path[0].style.borderTop="1px dotted #ccc",e.path[0].style.borderBottom=""):(e.path[0].style.borderTop="",e.path[0].style.borderBottom="1px dotted #ccc")})),e.addEventListener("dragleave",(function(e){e.path[0].style.borderTop="",e.path[0].style.borderBottom=""})),e.addEventListener("dragend",(function(e){e.path[1].querySelector(".dragging").classList.remove("dragging")})),e.addEventListener("drop",(function(e){var t=e.path[1].querySelector(".dragging");e.target.clientHeight/2>e.offsetY?e.path[1].insertBefore(t,e.path[0]):e.path[1].insertBefore(t,e.path[0].nextSibling),e.path[0].style.borderTop="",e.path[0].style.borderBottom=""}));for(var n=0;n<e.children.length;n++)e.children[n].setAttribute("draggable","true");return e},jSuites.tabs=function(e,t){var n={options:{}},r={data:null,allowCreate:!1,onload:null,onchange:null,oncreate:null,animation:!1,create:null,autoName:!1,prefixName:"",hideHeaders:!1};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];if(e.classList.add("jtabs"),1==n.options.animation){var i=document.createElement("div");i.className="jtabs-border",e.appendChild(i);var a=function(e){var t=l.children[e].getBoundingClientRect(),n=s.children[e].getBoundingClientRect();i.style.width=t.width+"px",i.style.left=t.left-n.left+"px",i.style.top=t.height+"px"}}if(n.open=function(e){for(var t=0;t<l.children.length;t++)l.children[t].classList.remove("jtabs-selected"),s.children[t]&&s.children[t].classList.remove("jtabs-selected");l.children[e].classList.add("jtabs-selected"),s.children[e]&&s.children[e].classList.add("jtabs-selected"),1==n.options.hideHeaders&&l.children.length<2&&0==n.options.allowCreate?l.style.display="none":(l.style.display="",1==n.options.animation&&setTimeout((function(){a(e)}),100))},n.selectIndex=function(e){var t=Array.prototype.indexOf.call(l.children,e);t>=0&&n.open(t)},n.create=function(t,r){"function"==typeof n.options.create?n.options.create():(n.appendElement(t,r),"function"==typeof n.options.oncreate&&n.options.oncreate(e,r))},n.appendElement=function(e,t){if(e||(1==n.options.autoName?(e=n.options.prefixName,e+=" "+(parseInt(s.children.length)+1)):e=prompt("Title?","")),e){var r=document.createElement("div");r.innerHTML=e,n.options.allowCreate?l.insertBefore(r,l.lastChild):l.appendChild(r),t||(t=document.createElement("div")),s.appendChild(t),n.selectIndex(r)}},n.options.data){e.innerHTML="";var l=document.createElement("div"),s=document.createElement("div");l.classList.add("jtabs-headers"),s.classList.add("jtabs-content"),e.appendChild(l),e.appendChild(s);for(var u=0;u<n.options.data.length;u++){var g=document.createElement("div");l.appendChild(g);var c=document.createElement("div");s.appendChild(c),g.innerHTML=n.options.data[u].title,n.options.data[u].content?c.innerHTML=n.options.data[u].content:n.options.data[u].url&&jSuites.ajax({url:n.options.data[u].url,type:"GET",success:function(e){c.innerHTML=e},complete:function(){"function"==typeof n.options.onload&&(n.options.onload(e),n.open(0))}})}}else e.children[0]&&e.children[1]?(l=e.children[0],s=e.children[1],l.classList.add("jtabs-headers"),s.classList.add("jtabs-content")):(e.innerHTML="",l=document.createElement("div"),s=document.createElement("div"),l.classList.add("jtabs-headers"),s.classList.add("jtabs-content"),e.appendChild(l),e.appendChild(s));if(1==n.options.allowCreate){var d=document.createElement("i");d.className="jtabs-add",l.appendChild(d)}return l.addEventListener("click",(function(e){"DIV"==e.target.tagName?n.selectIndex(e.target):n.create()})),l.children.length&&n.open(0),e.tabs=n,n},jSuites.tags=function(e,t){var n={options:{}},r={value:null,limit:null,limitMessage:"The limit of entries is: ",search:null,placeholder:null,validation:null,onbeforechange:null,onchange:null,onfocus:null,onblur:null,onload:null,colors:null};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];var i=null,a=null,l=0,s=0;n.add=function(t,r){if("function"==typeof n.options.onbeforechange){var o=n.options.onbeforechange(e,n,t);null!=o&&(t=o)}if(i&&(i.style.display=""),n.options.limit>0&&e.children.length>=n.options.limit)alert(n.options.limitMessage+" "+n.options.limit);else{var a=c();if(t&&"string"!=typeof t){a&&a.parentNode.classList.contains("jtags")&&(a.innerText.replace("\n","")||e.removeChild(a));for(var l=0;l<=t.length;l++)(!n.options.limit||e.children.length<n.options.limit)&&((s=document.createElement("div")).innerHTML=t[l]?t[l]:"<br>",e.appendChild(s))}else{var s;(s=document.createElement("div")).innerHTML=t||"<br>",a&&a.parentNode.classList.contains("jtags")?e.insertBefore(s,a.nextSibling):e.appendChild(s)}r&&setTimeout((function(){g(s)}),0),u(),"function"==typeof n.options.onchange&&n.options.onchange(e,n,t||"")}},n.getData=function(){for(var t=[],r=0;r<e.children.length;r++){var o=n.getValue(r);if(o){var i=e.children[r].getAttribute("data-id");i||(i=o),t.push({id:i,value:o})}}return t},n.getValue=function(t){var r=null;if(null!=t)r=e.children[t].innerText.replace("\n","");else{for(var o=[],i=0;i<e.children.length;i++)(r=e.children[i].innerText.replace("\n",""))&&o.push(n.getValue(i));r=o.join(",")}return r},n.setValue=function(e){if(e=e.trim()){var t=d(e);n.add(t)}},n.reset=function(){e.innerHTML="<div><br></div>"},n.isValid=function(){for(var t=0,n=0;n<e.children.length;n++)e.children[n].classList.contains("jtags_error")&&t++;return 0==t},n.selectIndex=function(e){a="";var t=c();t.innerText=e.children[1].innerText,e.children[1].getAttribute("data-id")&&t.setAttribute("data-id",e.children[1].getAttribute("data-id")),i&&(i.style.display="",i.innerHTML=""),t.classList.remove("jtags_error"),n.add()},n.search=function(t){if(!i){var r=document.createElement("div");r.style.position="relative",e.parentNode.insertBefore(r,e.nextSibling),(i=document.createElement("div")).classList.add("jtags_search"),r.appendChild(i)}var o=t.anchorNode.nodeValue;t.anchorNode.nodeValue&&o!=a&&(a=t.anchorNode.nodeValue,l=0,jSuites.ajax({url:n.options.search+a,method:"GET",dataType:"json",success:function(e){if(i.innerHTML="",e.length){i.style.display="block";for(var t=e.length<11?e.length:10,r=0;r<t;r++){var o=document.createElement("div");0==r&&o.classList.add("selected");var a=document.createElement("img");e[r].image?a.src=e[r].image:a.style.display="none",o.appendChild(a);var l=document.createElement("div");l.setAttribute("data-id",e[r].id),l.innerHTML=e[r].name,o.onclick=function(){n.selectIndex(this)},o.appendChild(l),i.appendChild(o)}}else i.style.display=""}}))},n.destroy=function(){e.removeEventListener("mouseup",b),e.removeEventListener("keydown",C),e.removeEventListener("keyup",A),e.removeEventListener("paste",I),e.removeEventListener("focus",f),e.removeEventListener("blur",h),e.parentNode.removeChild(e)};var u=function(){for(var t=0;t<e.children.length;t++)n.getValue(t)?(e.children[t].classList.add("jtags_label"),"function"==typeof n.options.validation&&(n.getValue(t)?n.options.validation(e.children[t],e.children[t].innerText,e.children[t].getAttribute("data-id"))?e.children[t].classList.remove("jtags_error"):e.children[t].classList.add("jtags_error"):e.children[t].classList.remove("jtags_error"))):e.children[t].classList.remove("jtags_label")},g=function(e){var t=document.createRange(),n=window.getSelection();t.setStart(e,e.innerText.length),t.collapse(!0),n.removeAllRanges(),n.addRange(t)},c=function(){var e=document.getSelection().anchorNode;return e?3==e.nodeType?e.parentNode:e:null},d=function(e){var t=[],n="";if(e=e.trim()){for(var r=0;r<e.length;r++)","==e[r]||";"==e[r]||"\r\n"==e[r]?n&&(t.push(n),n=""):n+=e[r];n&&t.push(n)}return t},p=0,C=function(t){if(p=window.getSelection().anchorOffset,!e.children.length){var r=document.createElement("div");r.innerHTML="<br>",e.appendChild(r)}9==t.which||186==t.which||188==t.which?(window.getSelection().anchorOffset>1&&(!n.options.limit||e.children.length<n.options.limit)&&n.add("",!0),t.preventDefault()):13==t.which?(i&&""!=i.style.display?n.selectIndex(i.children[l]):window.getSelection().anchorOffset>1&&(!n.options.limit||e.children.length<n.options.limit)&&n.add("",!0),t.preventDefault()):38==t.which?i&&""!=i.style.display&&(i.children[l].classList.remove("selected"),l>0&&l--,i.children[l].classList.add("selected"),t.preventDefault()):40==t.which&&i&&""!=i.style.display&&(i.children[l].classList.remove("selected"),l<9&&l++,i.children[l].classList.add("selected"),t.preventDefault())},A=function(e){if(39==e.which){var t=window.getSelection().anchorOffset;t>1&&t==p&&n.add()}else 13==e.which||38==e.which||40==e.which?e.preventDefault():(s&&clearTimeout(s),s=setTimeout((function(){var e=window.getSelection();n.options.search&&n.search(e),s=null}),300));u()},I=function(e){if(e.clipboardData||e.originalEvent.clipboardData){(e.originalEvent||e).clipboardData.getData("text/html");var t=(e.originalEvent||e).clipboardData.getData("text/plain")}else window.clipboardData&&(window.clipboardData.getData("Html"),t=window.clipboardData.getData("Text"));n.setValue(t),e.preventDefault()},b=function(t){if(t.target.parentNode&&t.target.parentNode.classList.contains("jtags")&&(t.target.classList.contains("jtags_label")||t.target.classList.contains("jtags_error"))){const n=t.target.getBoundingClientRect();n.width-(t.clientX-n.left)<16&&(e.removeChild(t.target),e.focus())}i&&(i.style.display="")},f=function(t){if((!e.children.length||n.getValue(e.children.length-1))&&(!n.options.limit||e.children.length<n.options.limit)){var r=document.createElement("div");r.innerHTML="<br>",e.appendChild(r)}"function"==typeof n.options.onfocus&&n.options.onfocus(e,n,n.getValue())},h=function(t){i&&setTimeout((function(){i.style.display=""}),200);for(var r=0;r<e.children.length-1;r++)n.getValue(r)||e.removeChild(e.children[r]);"function"==typeof n.options.onblur&&n.options.onblur(e,n,n.getValue())};return e.addEventListener("mouseup",b),e.addEventListener("keydown",C),e.addEventListener("keyup",A),e.addEventListener("paste",I),e.addEventListener("focus",f),e.addEventListener("blur",h),e.classList.add("jtags"),e.setAttribute("contenteditable",!0),e.setAttribute("spellcheck",!1),n.options.placeholder&&(e.placeholder=n.options.placeholder),n.options.value?n.setValue(n.options.value):e.innerHTML="<div><br></div>","function"==typeof n.options.onload&&n.options.onload(e,n),e.tags=n,n},jSuites.tracker=function(e,t){var n={options:{}},r={url:null,message:"Are you sure? There are unsaved information in your form",ignore:!1,currentHash:null,submitButton:null,onload:null,onbeforesave:null,onsave:null};for(var o in r)t&&t.hasOwnProperty(o)?n.options[o]=t[o]:n.options[o]=r[o];return n.setUrl=function(e){n.options.url=e},n.load=function(){jSuites.ajax({url:n.options.url,method:"GET",dataType:"json",success:function(t){for(var r=e.querySelectorAll("input, select, textarea"),o=0;o<r.length;o++){var i=r[o].getAttribute("name");t[i]&&(r[o].value=t[i])}"function"==typeof n.options.onload&&n.options.onload(e,t)}})},n.save=function(){var t=n.validate();if(t)jSuites.alert(t);else{var r=n.getElements(!0);if("function"==typeof n.options.onbeforesave&&!1===(r=n.options.onbeforesave(e,r)))return void console.log("Onbeforesave returned false");jSuites.ajax({url:n.options.url,method:"POST",dataType:"json",data:r,success:function(t){jSuites.alert(t.message),"function"==typeof n.options.onsave&&n.options.onsave(e,t),n.reset()}})}},n.validateElement=function(t){var r=function(e){return!!new RegExp(/^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/).test(e)},o=function(e){return e.classList.add("error"),n.options.submitButton&&n.options.submitButton.setAttribute("disabled",!0),e.getAttribute("data-error")||"There is an error in the form"},i="";return t.value?t.getAttribute("data-email")&&!r(t.value)||t.getAttribute("data-password")&&!r(t.value)?i=o(t):t.classList.contains("error")&&function(t){var r=!1;t.classList.remove("error");for(var o=e.querySelectorAll("input, select, textarea"),i=0;i<o.length;i++)o[i].getAttribute("data-validation")&&o[i].classList.contains("error")&&(r=!0);n.options.submitButton&&(r?n.options.submitButton.setAttribute("disabled",!0):n.options.submitButton.removeAttribute("disabled"))}(t):i=o(t),i},n.validate=function(){for(var t="",r=e.querySelectorAll("input, select, textarea"),o=0;o<r.length;o++)r[o].getAttribute("data-validation")&&(t&&(t+="<br>\r\n"),t+=n.validateElement(r[o]));return t},n.getError=function(){return!!n.validation()},n.setHash=function(){return n.getHash(n.getElements())},n.getHash=function(e){var t,n=0;if(0===e.length)return n;for(t=0;t<e.length;t++)n=(n<<5)-n+e.charCodeAt(t),n|=0;return n},n.isChanged=function(){var e=n.setHash();return n.options.currentHash!=e},n.resetTracker=function(){n.options.currentHash=n.setHash(),n.options.ignore=!1},n.reset=function(){n.options.currentHash=n.setHash(),n.options.ignore=!1},n.setIgnore=function(e){n.options.ignore=!!e},n.getElements=function(t){for(var n={},r=e.querySelectorAll("input, select, textarea"),o=0;o<r.length;o++){var i=r[o],a=i.name,l=i.value;a&&(n[a]=l)}return 1==t?n:JSON.stringify(n)},setTimeout((function(){n.options.currentHash=n.setHash()}),1e3),window.addEventListener("beforeunload",(function(e){if(n.isChanged()&&0==n.options.ignore){var t=n.options.message?n.options.message:"o/";return t?(void 0===e&&(e=window.event),e&&(e.returnValue=t),t):void 0}})),e.addEventListener("keyup",(function(e){e.target.getAttribute("data-validation")&&n.validateElement(e.target)})),e.tracker=n,n},jSuites},module.exports=factory()},294:(e,t,n)=>{"use strict";n.r(t),n.d(t,{default:()=>a});var r=n(379),o=n.n(r),i=n(524);o()(i.Z,{insert:"head",singleton:!1});const a=i.Z.locals||{}}}]);