"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelloWorld = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const automation_document_1 = require("../document/automation-document");
const data_type_1 = require("../domain/data-type");
const input_1 = require("../domain/input");
const string_variable_1 = require("../interface/variables/string-variable");
const aws_api_step_1 = require("../parent-steps/automation/aws-api-step");
const execute_script_step_1 = require("../parent-steps/automation/execute-script-step");
class HelloWorld extends aws_cdk_lib_1.Stack {
    constructor(app, id) {
        super(app, id);
        const doc = new automation_document_1.AutomationDocument(this, 'HelloWorld', {
            docInputs: [
                input_1.Input.ofTypeString('Someone', { allowedPattern: '[a-zA-Z]+' }),
                input_1.Input.ofTypeString('SnsTopic'),
            ],
        });
        const greeting = new execute_script_step_1.ExecuteScriptStep(this, 'PrependWithGreeting', {
            language: execute_script_step_1.ScriptLanguage.PYTHON,
            inlineCode: 'def my_func(args, context):\n' +
                '    return {"Greeting": "Hello " + args["Someone"]}\n' +
                '\n',
            handlerName: 'my_func',
            inputs: ['Someone'],
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'Greeting',
                    selector: '$.Payload.Greeting',
                }],
        });
        doc.addStep(greeting);
        doc.addStep(new aws_api_step_1.AwsApiStep(this, 'PublishToSns', {
            outputs: [],
            service: 'SNS',
            pascalCaseApi: 'publish',
            apiParams: {
                TargetArn: new string_variable_1.StringVariable('SnsTopic'),
                Message: greeting.variables().Greeting,
            },
        }));
    }
}
exports.HelloWorld = HelloWorld;
_a = JSII_RTTI_SYMBOL_1;
HelloWorld[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HelloWorld", version: "0.0.17" };
//# sourceMappingURL=data:application/json;base64,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