"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTagsStep = exports.ResourceTypeVariable = exports.HardCodedResourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
class HardCodedResourceType extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedResourceType = HardCodedResourceType;
_a = JSII_RTTI_SYMBOL_1;
HardCodedResourceType[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedResourceType", version: "0.0.17" };
HardCodedResourceType.EC2 = new HardCodedResourceType('EC2');
HardCodedResourceType.MANAGED_INSTANCE = new HardCodedResourceType('ManagedInstance');
HardCodedResourceType.MAINTENANCE_WINDOW = new HardCodedResourceType('MaintenanceWindow');
HardCodedResourceType.PARAMETER = new HardCodedResourceType('Parameter');
class ResourceTypeVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['EC2', 'ManagedInstance', 'MaintenanceWindow', 'Parameter'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.ResourceTypeVariable = ResourceTypeVariable;
_b = JSII_RTTI_SYMBOL_1;
ResourceTypeVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.ResourceTypeVariable", version: "0.0.17" };
/**
 * AutomationStep implemenation for aws:createTags
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-createtag.html
 */
class CreateTagsStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:createTags';
        this.resourceIds = props.resourceIds;
        this.tags = props.tags;
        this.resourceType = props.resourceType;
    }
    /**
       * This step has no outputs.
       */
    listOutputs() {
        return [];
    }
    listInputs() {
        const inputs = [
            this.resourceIds,
            this.tags,
            this.resourceType,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entryMap = {
            ResourceIds: this.resourceIds,
            Tags: this.tags,
            ResourceType: this.resourceType,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.CreateTagsStep = CreateTagsStep;
_c = JSII_RTTI_SYMBOL_1;
CreateTagsStep[_c] = { fqn: "@cdklabs/cdk-ssm-documents.CreateTagsStep", version: "0.0.17" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3JlYXRlLXRhZ3Mtc3RlcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9wYXJlbnQtc3RlcHMvYXV0b21hdGlvbi9jcmVhdGUtdGFncy1zdGVwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0VBQTJIO0FBRTNILHVGQUFpRjtBQUNqRix3REFBeUU7QUEyQnpFLE1BQWEscUJBQXNCLFNBQVEsaUNBQWU7SUFLeEQsWUFBb0IsR0FBVztRQUM3QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDYixDQUFDOztBQVBILHNEQVFDOzs7QUFQd0IseUJBQUcsR0FBRyxJQUFJLHFCQUFxQixDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ3ZDLHNDQUFnQixHQUFHLElBQUkscUJBQXFCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztBQUNoRSx3Q0FBa0IsR0FBRyxJQUFJLHFCQUFxQixDQUFDLG1CQUFtQixDQUFDLENBQUM7QUFDcEUsK0JBQVMsR0FBRyxJQUFJLHFCQUFxQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0FBTTVFLE1BQWEsb0JBQXFCLFNBQVEsZ0NBQWM7SUFBeEQ7O1FBQ1csZ0JBQVcsR0FBRyxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRSxtQkFBbUIsRUFBRSxXQUFXLENBQUMsQ0FBQztLQVFyRjtJQU5XLFVBQVUsQ0FBQyxLQUFVO1FBQzdCLDhCQUFZLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDcEIsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3JDLE1BQU0sSUFBSSxLQUFLLENBQUMsR0FBRyxLQUFLLDRCQUE0QixDQUFDLENBQUM7U0FDdkQ7SUFDSCxDQUFDOztBQVJILG9EQVNDOzs7QUFHRDs7O0dBR0c7QUFDSCxNQUFhLGNBQWUsU0FBUSxnQ0FBYztJQU1oRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBTmpCLFdBQU0sR0FBRyxnQkFBZ0IsQ0FBQztRQU9qQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztJQUN6QyxDQUFDO0lBRUQ7O1NBRUs7SUFDRSxXQUFXO1FBQ2hCLE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUVNLFVBQVU7UUFDZixNQUFNLE1BQU0sR0FBRztZQUNiLElBQUksQ0FBQyxXQUFXO1lBQ2hCLElBQUksQ0FBQyxJQUFJO1lBQ1QsSUFBSSxDQUFDLFlBQVk7U0FDbEIsQ0FBQztRQUVGLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxjQUFjLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBRU0sVUFBVTtRQUNmLE1BQU0sUUFBUSxHQUFpRDtZQUM3RCxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1NBQ2hDLENBQUM7UUFDRixNQUFNLE9BQU8sR0FBRyxvREFBdUIsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUNsRSxPQUFPLEtBQUssQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDeEMsQ0FBQzs7QUF0Q0gsd0NBdUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBPdXRwdXQgfSBmcm9tICcuLi8uLi9kb21haW4vb3V0cHV0JztcbmltcG9ydCB7IElNYXBMaXN0VmFyaWFibGUgfSBmcm9tICcuLi8uLi9pbnRlcmZhY2UvdmFyaWFibGVzL21hcC1saXN0LXZhcmlhYmxlJztcbmltcG9ydCB7IElTdHJpbmdMaXN0VmFyaWFibGUgfSBmcm9tICcuLi8uLi9pbnRlcmZhY2UvdmFyaWFibGVzL3N0cmluZy1saXN0LXZhcmlhYmxlJztcbmltcG9ydCB7IGFzc2VydFN0cmluZywgSGFyZENvZGVkU3RyaW5nLCBJU3RyaW5nVmFyaWFibGUsIFN0cmluZ1ZhcmlhYmxlIH0gZnJvbSAnLi4vLi4vaW50ZXJmYWNlL3ZhcmlhYmxlcy9zdHJpbmctdmFyaWFibGUnO1xuaW1wb3J0IHsgSUdlbmVyaWNWYXJpYWJsZSB9IGZyb20gJy4uLy4uL2ludGVyZmFjZS92YXJpYWJsZXMvdmFyaWFibGUnO1xuaW1wb3J0IHsgcHJ1bmVBbmRUcmFuc2Zvcm1SZWNvcmQgfSBmcm9tICcuLi8uLi91dGlscy9wcnVuZS1hbmQtdHJhbnNmb3JtLXJlY29yZCc7XG5pbXBvcnQgeyBBdXRvbWF0aW9uU3RlcCwgQXV0b21hdGlvblN0ZXBQcm9wcyB9IGZyb20gJy4uL2F1dG9tYXRpb24tc3RlcCc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgQ3JlYXRlVGFnU3RlcFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENyZWF0ZVRhZ3NTdGVwUHJvcHMgZXh0ZW5kcyBBdXRvbWF0aW9uU3RlcFByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBJRHMgb2YgdGhlIHJlc291cmNlKHMpIHRvIGJlIHRhZ2dlZC4gSWYgcmVzb3VyY2UgdHlwZSBpc24ndCDigJxFQzLigJ0sIHRoaXMgZmllbGQgY2FuIGNvbnRhaW4gb25seSBhIHNpbmdsZSBpdGVtLlxuICAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VJZHM6IElTdHJpbmdMaXN0VmFyaWFibGU7XG5cbiAgLyoqXG4gICAqIFRoZSB0YWdzIHRvIGFzc29jaWF0ZSB3aXRoIHRoZSByZXNvdXJjZShzKS5cbiAgICovXG4gIHJlYWRvbmx5IHRhZ3M6IElNYXBMaXN0VmFyaWFibGU7XG5cbiAgLyoqXG4gICAqIChPcHRpb25hbCkgVGhlIHR5cGUgb2YgcmVzb3VyY2UocykgdG8gYmUgdGFnZ2VkLlxuICAgKiBWYWxpZCB2YWx1ZXM6IEVDMiB8IE1hbmFnZWRJbnN0YW5jZSB8IE1haW50ZW5hbmNlV2luZG93IHwgUGFyYW1ldGVyXG4gICAqIEBkZWZhdWx0IEVDMlxuICAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VUeXBlPzogSVJlc291cmNlVHlwZVZhcmlhYmxlO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIElSZXNvdXJjZVR5cGVWYXJpYWJsZSBleHRlbmRzIElTdHJpbmdWYXJpYWJsZSB7XG59XG5cbmV4cG9ydCBjbGFzcyBIYXJkQ29kZWRSZXNvdXJjZVR5cGUgZXh0ZW5kcyBIYXJkQ29kZWRTdHJpbmcgaW1wbGVtZW50cyBJUmVzb3VyY2VUeXBlVmFyaWFibGUge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEVDMiA9IG5ldyBIYXJkQ29kZWRSZXNvdXJjZVR5cGUoJ0VDMicpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IE1BTkFHRURfSU5TVEFOQ0UgPSBuZXcgSGFyZENvZGVkUmVzb3VyY2VUeXBlKCdNYW5hZ2VkSW5zdGFuY2UnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBNQUlOVEVOQU5DRV9XSU5ET1cgPSBuZXcgSGFyZENvZGVkUmVzb3VyY2VUeXBlKCdNYWludGVuYW5jZVdpbmRvdycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFBBUkFNRVRFUiA9IG5ldyBIYXJkQ29kZWRSZXNvdXJjZVR5cGUoJ1BhcmFtZXRlcicpO1xuICBwcml2YXRlIGNvbnN0cnVjdG9yKHZhbDogc3RyaW5nKSB7XG4gICAgc3VwZXIodmFsKTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgUmVzb3VyY2VUeXBlVmFyaWFibGUgZXh0ZW5kcyBTdHJpbmdWYXJpYWJsZSBpbXBsZW1lbnRzIElSZXNvdXJjZVR5cGVWYXJpYWJsZSB7XG4gIHJlYWRvbmx5IHZhbGlkVmFsdWVzID0gWydFQzInLCAnTWFuYWdlZEluc3RhbmNlJywgJ01haW50ZW5hbmNlV2luZG93JywgJ1BhcmFtZXRlciddO1xuXG4gIHByb3RlY3RlZCBhc3NlcnRUeXBlKHZhbHVlOiBhbnkpOiB2b2lkIHtcbiAgICBhc3NlcnRTdHJpbmcodmFsdWUpO1xuICAgIGlmICghdGhpcy52YWxpZFZhbHVlcy5pbmNsdWRlcyh2YWx1ZSkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgJHt2YWx1ZX0gaXMgbm90IGEgdmFsaWQgZW51bSB2YWx1ZWApO1xuICAgIH1cbiAgfVxufVxuXG5cbi8qKlxuICogQXV0b21hdGlvblN0ZXAgaW1wbGVtZW5hdGlvbiBmb3IgYXdzOmNyZWF0ZVRhZ3NcbiAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zeXN0ZW1zLW1hbmFnZXIvbGF0ZXN0L3VzZXJndWlkZS9hdXRvbWF0aW9uLWFjdGlvbi1jcmVhdGV0YWcuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ3JlYXRlVGFnc1N0ZXAgZXh0ZW5kcyBBdXRvbWF0aW9uU3RlcCB7XG4gIHJlYWRvbmx5IGFjdGlvbiA9ICdhd3M6Y3JlYXRlVGFncyc7XG4gIHJlYWRvbmx5IHJlc291cmNlSWRzOiBJU3RyaW5nTGlzdFZhcmlhYmxlO1xuICByZWFkb25seSB0YWdzOiBJTWFwTGlzdFZhcmlhYmxlO1xuICByZWFkb25seSByZXNvdXJjZVR5cGU/OiBJUmVzb3VyY2VUeXBlVmFyaWFibGU7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENyZWF0ZVRhZ3NTdGVwUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLnJlc291cmNlSWRzID0gcHJvcHMucmVzb3VyY2VJZHM7XG4gICAgdGhpcy50YWdzID0gcHJvcHMudGFncztcbiAgICB0aGlzLnJlc291cmNlVHlwZSA9IHByb3BzLnJlc291cmNlVHlwZTtcbiAgfVxuXG4gIC8qKlxuICAgICAqIFRoaXMgc3RlcCBoYXMgbm8gb3V0cHV0cy5cbiAgICAgKi9cbiAgcHVibGljIGxpc3RPdXRwdXRzKCk6IE91dHB1dFtdIHtcbiAgICByZXR1cm4gW107XG4gIH1cblxuICBwdWJsaWMgbGlzdElucHV0cygpOiBzdHJpbmdbXSB7XG4gICAgY29uc3QgaW5wdXRzID0gW1xuICAgICAgdGhpcy5yZXNvdXJjZUlkcyxcbiAgICAgIHRoaXMudGFncyxcbiAgICAgIHRoaXMucmVzb3VyY2VUeXBlLFxuICAgIF07XG5cbiAgICByZXR1cm4gaW5wdXRzLmZsYXRNYXAoaSA9PiBpPy5yZXF1aXJlZElucHV0cygpID8/IFtdKTtcbiAgfVxuXG4gIHB1YmxpYyB0b1NzbUVudHJ5KCk6IFJlY29yZDxzdHJpbmcsIGFueT4ge1xuICAgIGNvbnN0IGVudHJ5TWFwOiBSZWNvcmQ8c3RyaW5nLCBJR2VuZXJpY1ZhcmlhYmxlIHwgdW5kZWZpbmVkPiA9IHtcbiAgICAgIFJlc291cmNlSWRzOiB0aGlzLnJlc291cmNlSWRzLFxuICAgICAgVGFnczogdGhpcy50YWdzLFxuICAgICAgUmVzb3VyY2VUeXBlOiB0aGlzLnJlc291cmNlVHlwZSxcbiAgICB9O1xuICAgIGNvbnN0IGVudHJpZXMgPSBwcnVuZUFuZFRyYW5zZm9ybVJlY29yZChlbnRyeU1hcCwgeCA9PiB4LnByaW50KCkpO1xuICAgIHJldHVybiBzdXBlci5wcmVwYXJlU3NtRW50cnkoZW50cmllcyk7XG4gIH1cbn0iXX0=