"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericVariable = exports.HardCodedValueBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class HardCodedValueBase {
    constructor(val) {
        this.assertType(val);
        this.val = val;
    }
    resolve(_inputs) {
        return this.val;
    }
    print() {
        return this.val;
    }
    requiredInputs() {
        return [];
    }
    toJSON() {
        return this.val;
    }
    toString() {
        return this.print() ?? '';
    }
}
exports.HardCodedValueBase = HardCodedValueBase;
_a = JSII_RTTI_SYMBOL_1;
HardCodedValueBase[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedValueBase", version: "0.0.17" };
/**
 * Abstraction of SSM variables.
 * Variables are printed as using this syntax: {{ myVariable }}
 * To resolve a variable, you must supply the available inputs and the variable will resolve the value.
 */
class GenericVariable {
    constructor(reference) {
        this.reference = reference;
    }
    resolve(inputs) {
        const result = inputs[this.reference];
        if (result === undefined) {
            return result;
        }
        this.assertType(result);
        return result;
    }
    print() {
        return this.toPlaceholder();
    }
    toPlaceholder() {
        return `{{ ${this.reference} }}`;
    }
    requiredInputs() {
        return [this.reference];
    }
    toJSON() {
        return this.toPlaceholder();
    }
    toString() {
        return this.print() ?? '';
    }
}
exports.GenericVariable = GenericVariable;
_b = JSII_RTTI_SYMBOL_1;
GenericVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.GenericVariable", version: "0.0.17" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFyaWFibGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvaW50ZXJmYWNlL3ZhcmlhYmxlcy92YXJpYWJsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWdDQSxNQUFzQixrQkFBa0I7SUFHdEMsWUFBWSxHQUFXO1FBQ3JCLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDckIsSUFBSSxDQUFDLEdBQUcsR0FBRyxHQUFHLENBQUM7SUFDakIsQ0FBQztJQUVELE9BQU8sQ0FBQyxPQUE0QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUVELEtBQUs7UUFDSCxPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUVELGNBQWM7UUFDWixPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7SUFFRCxNQUFNO1FBQ0osT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDO0lBQ2xCLENBQUM7SUFJRCxRQUFRO1FBQ04sT0FBTyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDO0lBQzVCLENBQUM7O0FBNUJILGdEQTZCQzs7O0FBRUQ7Ozs7R0FJRztBQUNILE1BQXNCLGVBQWU7SUFHbkMsWUFBWSxTQUFpQjtRQUMzQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBRUQsT0FBTyxDQUFDLE1BQTJCO1FBQ2pDLE1BQU0sTUFBTSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDdEMsSUFBSSxNQUFNLEtBQUssU0FBUyxFQUFFO1lBQUUsT0FBTyxNQUFNLENBQUM7U0FBRTtRQUM1QyxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3hCLE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxLQUFLO1FBQ0gsT0FBTyxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDOUIsQ0FBQztJQUVPLGFBQWE7UUFDbkIsT0FBTyxNQUFNLElBQUksQ0FBQyxTQUFTLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBRUQsY0FBYztRQUNaLE9BQU8sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMUIsQ0FBQztJQUVELE1BQU07UUFDSixPQUFPLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM5QixDQUFDO0lBSUQsUUFBUTtRQUNOLE9BQU8sSUFBSSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsQ0FBQztJQUM1QixDQUFDOztBQWxDSCwwQ0FtQ0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFZhcmlhYmxlcyBob2xkIHJlZmVyZW5jZXMgdG8gYSB2YWx1ZS5cbiAqIFRoZXJlIGFyZSB0d28gaW1wbGVtZW50YXRpb25zOiBIYXJkQ29kZWRWYWx1ZSBhbmQgRXhwb3J0ZWRWYXJpYWJsZS5cbiAqIFRoaXMgaW50ZXJmYWNlIGFsbG93cyB5b3UgdG8gcmVmZXJlbmNlIHZhcmlhYmxlIG91dHB1dHMgZnJvbSBwcmV2aW91cyBzdGVwcyB2aWEgdGhlIGV4cG9ydGVkIHN0ZXAudmFyaWFibGUoKS5cbiAqIElmIHlvdSBkbyBub3QgaGF2ZSBhIHJlZmVyZW5jZSB0byBhIHZhcmlhYmxlLCB5b3UgbWF5IGdlbmVyYXRlIHlvdXIgb3duIHZhcmlhYmxlIHVzaW5nIHRoZSBFeHBvcnRlZFZhcmlhYmxlIGN0b3IuXG4gKiBJbiB0aGUgZXZlbnQgdGhhdCBhIGhhcmRjb2RlZCB2YWx1ZSBpcyBwYXNzZWQgaW50byBhIHN0ZXAsIHlvdSBjYW4gcmVmZXJlbmNlIHRoZSB2YWx1ZSB3aXRoIGEgSGFyZENvZGVkVmFsdWUuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUdlbmVyaWNWYXJpYWJsZSB7XG4gIC8qKlxuICAgICAqIEdpdmVuIHRoZSBleGVjdXRpb24gaW5wdXRzLCByZXR1cm4gdGhlIHJlc29sdmVkIHZhbHVlIG9mIHRoaXMgdmFyaWFibGUuXG4gICAgICogQHBhcmFtIGlucHV0cyBhcmUgdGhlIGV4ZWN1dGlvbiBpbnB1dHMuXG4gICAgICovXG4gIHJlc29sdmUoaW5wdXRzOiBSZWNvcmQ8c3RyaW5nLCBhbnk+KTogYW55O1xuXG4gIC8qKlxuICAgICAqIFByaW50cyB0aGUgdmFyaWFibGUgaW4gYSB3YXkgdGhhdCBTU00gdW5kZXJzdGFuZHMuIFRoaXMgaXMgdHlwaWNhbGx5IGluIHRoZSBmb3JtIG9mIHt7IFZhcmlhYmxlIH19IG9yIHRoZSB2YWx1ZS5cbiAgICAgKiBAZXhhbXBsZSB7eyBNeVZhcmlhYmxlIH19XG4gICAgICovXG4gIHByaW50KCk6IHN0cmluZyB8IGFueTtcblxuICAvKipcbiAgICAgKiBUaGUgaW5wdXRzIHRoYXQgYXJlIHJlcXVpcmVkIGZvciBkZXRlcm1pbmluZyB0aGUgdmFsdWUgb2YgdGhpcyB2YXJpYWJsZS5cbiAgICAgKiBJbiB0aGUgY2FzZSBvZiBhIHNpbmdsZSB2YXJpYWJsZSBzdHJpbmcsIHRoaXMgd2lsbCByZXR1cm4gYSBzaW5nbGUgdmFsdWUuXG4gICAgICovXG4gIHJlcXVpcmVkSW5wdXRzKCk6IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgICAqIEpTT04uc3RyaW5naWZ5KHZhcmlhYmxlKSB3aWxsIGltcGxpY2l0bHkgaW52b2tlIHRoaXMgdmFyaWFibGUuXG4gICAgICovXG4gIHRvSlNPTigpOiBhbnk7XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBIYXJkQ29kZWRWYWx1ZUJhc2U8VFZhbHVlPiBpbXBsZW1lbnRzIElHZW5lcmljVmFyaWFibGUge1xuICByZWFkb25seSB2YWw6IFRWYWx1ZTtcblxuICBjb25zdHJ1Y3Rvcih2YWw6IFRWYWx1ZSkge1xuICAgIHRoaXMuYXNzZXJ0VHlwZSh2YWwpO1xuICAgIHRoaXMudmFsID0gdmFsO1xuICB9XG5cbiAgcmVzb2x2ZShfaW5wdXRzOiBSZWNvcmQ8c3RyaW5nLCBhbnk+KTogYW55IHtcbiAgICByZXR1cm4gdGhpcy52YWw7XG4gIH1cblxuICBwcmludCgpOiBzdHJpbmcgfCBhbnkge1xuICAgIHJldHVybiB0aGlzLnZhbDtcbiAgfVxuXG4gIHJlcXVpcmVkSW5wdXRzKCk6IHN0cmluZ1tdIHtcbiAgICByZXR1cm4gW107XG4gIH1cblxuICB0b0pTT04oKTogYW55IHtcbiAgICByZXR1cm4gdGhpcy52YWw7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWJzdHJhY3QgYXNzZXJ0VHlwZSh2YWx1ZTogYW55KTogdm9pZDtcblxuICB0b1N0cmluZygpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLnByaW50KCkgPz8gJyc7XG4gIH1cbn1cblxuLyoqXG4gKiBBYnN0cmFjdGlvbiBvZiBTU00gdmFyaWFibGVzLlxuICogVmFyaWFibGVzIGFyZSBwcmludGVkIGFzIHVzaW5nIHRoaXMgc3ludGF4OiB7eyBteVZhcmlhYmxlIH19XG4gKiBUbyByZXNvbHZlIGEgdmFyaWFibGUsIHlvdSBtdXN0IHN1cHBseSB0aGUgYXZhaWxhYmxlIGlucHV0cyBhbmQgdGhlIHZhcmlhYmxlIHdpbGwgcmVzb2x2ZSB0aGUgdmFsdWUuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBHZW5lcmljVmFyaWFibGUgaW1wbGVtZW50cyBJR2VuZXJpY1ZhcmlhYmxlIHtcbiAgcmVhZG9ubHkgcmVmZXJlbmNlOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IocmVmZXJlbmNlOiBzdHJpbmcpIHtcbiAgICB0aGlzLnJlZmVyZW5jZSA9IHJlZmVyZW5jZTtcbiAgfVxuXG4gIHJlc29sdmUoaW5wdXRzOiBSZWNvcmQ8c3RyaW5nLCBhbnk+KTogYW55IHtcbiAgICBjb25zdCByZXN1bHQgPSBpbnB1dHNbdGhpcy5yZWZlcmVuY2VdO1xuICAgIGlmIChyZXN1bHQgPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gcmVzdWx0OyB9XG4gICAgdGhpcy5hc3NlcnRUeXBlKHJlc3VsdCk7XG4gICAgcmV0dXJuIHJlc3VsdDtcbiAgfVxuXG4gIHByaW50KCk6IHN0cmluZyB8IGFueSB7XG4gICAgcmV0dXJuIHRoaXMudG9QbGFjZWhvbGRlcigpO1xuICB9XG5cbiAgcHJpdmF0ZSB0b1BsYWNlaG9sZGVyKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGB7eyAke3RoaXMucmVmZXJlbmNlfSB9fWA7XG4gIH1cblxuICByZXF1aXJlZElucHV0cygpOiBzdHJpbmdbXSB7XG4gICAgcmV0dXJuIFt0aGlzLnJlZmVyZW5jZV07XG4gIH1cblxuICB0b0pTT04oKTogYW55IHtcbiAgICByZXR1cm4gdGhpcy50b1BsYWNlaG9sZGVyKCk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWJzdHJhY3QgYXNzZXJ0VHlwZSh2YWx1ZTogYW55KTogdm9pZDtcblxuICB0b1N0cmluZygpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLnByaW50KCkgPz8gJyc7XG4gIH1cbn0iXX0=