"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStringList = exports.assertStringList = exports.StringListVariable = exports.HardCodedStringList = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("./string-variable");
const variable_1 = require("./variable");
/**
 * A hard-coded string list variable.
 * Used when not dependent on step inputs.
 */
class HardCodedStringList extends variable_1.HardCodedValueBase {
    static of(val) {
        return new HardCodedStringList(val);
    }
    resolveToStringList(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertStringList(value);
    }
}
exports.HardCodedStringList = HardCodedStringList;
_a = JSII_RTTI_SYMBOL_1;
HardCodedStringList[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedStringList", version: "0.0.17" };
/**
 * A string list variable reference.
 * Used to resolve the value from step inputs.
 */
class StringListVariable extends variable_1.GenericVariable {
    static of(reference) {
        return new StringListVariable(reference);
    }
    resolveToStringList(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertStringList(value);
    }
}
exports.StringListVariable = StringListVariable;
_b = JSII_RTTI_SYMBOL_1;
StringListVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.StringListVariable", version: "0.0.17" };
/**
 * Assert that the given value is a NullableStringList.
 * @param value value to assert
 */
function assertStringList(value) {
    if (!isStringList(value)) {
        throw new Error(`${value} is not a string list`);
    }
}
exports.assertStringList = assertStringList;
/**
 * Whether the given value is a NullableStringList.
 * @param value value to check
 * @returns true if the value is a NullableStringList, otherwise false
 */
function isStringList(value) {
    if (value === null) {
        return true;
    }
    return Array.isArray(value) && value.every(string_variable_1.isString);
}
exports.isStringList = isStringList;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RyaW5nLWxpc3QtdmFyaWFibGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvaW50ZXJmYWNlL3ZhcmlhYmxlcy9zdHJpbmctbGlzdC12YXJpYWJsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHVEQUE2QztBQUM3Qyx5Q0FBbUY7QUFrQm5GOzs7R0FHRztBQUNILE1BQWEsbUJBQW9CLFNBQVEsNkJBQTRCO0lBQzVELE1BQU0sQ0FBQyxFQUFFLENBQUMsR0FBYTtRQUM1QixPQUFPLElBQUksbUJBQW1CLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVELG1CQUFtQixDQUFDLE1BQTJCO1FBQzdDLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRVMsVUFBVSxDQUFDLEtBQVU7UUFDN0IsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDMUIsQ0FBQzs7QUFYSCxrREFZQzs7O0FBRUQ7OztHQUdHO0FBQ0gsTUFBYSxrQkFBbUIsU0FBUSwwQkFBZTtJQUM5QyxNQUFNLENBQUMsRUFBRSxDQUFDLFNBQWlCO1FBQ2hDLE9BQU8sSUFBSSxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBRUQsbUJBQW1CLENBQUMsTUFBMkI7UUFDN0MsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFFUyxVQUFVLENBQUMsS0FBVTtRQUM3QixnQkFBZ0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMxQixDQUFDOztBQVhILGdEQVlDOzs7QUFFRDs7O0dBR0c7QUFDSCxTQUFnQixnQkFBZ0IsQ0FBQyxLQUFVO0lBQ3pDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLEVBQUU7UUFBRSxNQUFNLElBQUksS0FBSyxDQUFDLEdBQUcsS0FBSyx1QkFBdUIsQ0FBQyxDQUFDO0tBQUU7QUFDakYsQ0FBQztBQUZELDRDQUVDO0FBRUQ7Ozs7R0FJRztBQUNILFNBQWdCLFlBQVksQ0FBQyxLQUFVO0lBQ3JDLElBQUksS0FBSyxLQUFLLElBQUksRUFBRTtRQUFFLE9BQU8sSUFBSSxDQUFDO0tBQUU7SUFDcEMsT0FBTyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssQ0FBQyxLQUFLLENBQUMsMEJBQVEsQ0FBQyxDQUFDO0FBQ3ZELENBQUM7QUFIRCxvQ0FHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGlzU3RyaW5nIH0gZnJvbSAnLi9zdHJpbmctdmFyaWFibGUnO1xuaW1wb3J0IHsgSUdlbmVyaWNWYXJpYWJsZSwgR2VuZXJpY1ZhcmlhYmxlLCBIYXJkQ29kZWRWYWx1ZUJhc2UgfSBmcm9tICcuL3ZhcmlhYmxlJztcblxuLyoqXG4gKiBTdHJpbmdMaXN0IHR5cGUgdGhhdCBjYW4gYmUgbnVsbFxuICovXG5leHBvcnQgdHlwZSBOdWxsYWJsZVN0cmluZ0xpc3QgPSBzdHJpbmdbXTtcblxuLyoqXG4gKiBBIHN0cmluZyBsaXN0IHZhcmlhYmxlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVN0cmluZ0xpc3RWYXJpYWJsZSBleHRlbmRzIElHZW5lcmljVmFyaWFibGUge1xuICAvKipcbiAgICAgKiBHaXZlbiB0aGUgZXhlY3V0aW9uIGlucHV0cywgcmV0dXJuIHRoZSByZXNvbHZlZCB2YWx1ZSBvZiB0aGlzIHZhcmlhYmxlLlxuICAgICAqIEBwYXJhbSBpbnB1dHMgYXJlIHRoZSBleGVjdXRpb24gaW5wdXRzLlxuICAgICAqL1xuICByZXNvbHZlVG9TdHJpbmdMaXN0KGlucHV0czogUmVjb3JkPHN0cmluZywgYW55Pik6IE51bGxhYmxlU3RyaW5nTGlzdDtcbn1cblxuLyoqXG4gKiBBIGhhcmQtY29kZWQgc3RyaW5nIGxpc3QgdmFyaWFibGUuXG4gKiBVc2VkIHdoZW4gbm90IGRlcGVuZGVudCBvbiBzdGVwIGlucHV0cy5cbiAqL1xuZXhwb3J0IGNsYXNzIEhhcmRDb2RlZFN0cmluZ0xpc3QgZXh0ZW5kcyBIYXJkQ29kZWRWYWx1ZUJhc2U8c3RyaW5nW10+IGltcGxlbWVudHMgSVN0cmluZ0xpc3RWYXJpYWJsZSB7XG4gIHB1YmxpYyBzdGF0aWMgb2YodmFsOiBzdHJpbmdbXSk6IEhhcmRDb2RlZFN0cmluZ0xpc3Qge1xuICAgIHJldHVybiBuZXcgSGFyZENvZGVkU3RyaW5nTGlzdCh2YWwpO1xuICB9XG5cbiAgcmVzb2x2ZVRvU3RyaW5nTGlzdChpbnB1dHM6IFJlY29yZDxzdHJpbmcsIGFueT4pOiBOdWxsYWJsZVN0cmluZ0xpc3Qge1xuICAgIHJldHVybiB0aGlzLnJlc29sdmUoaW5wdXRzKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhc3NlcnRUeXBlKHZhbHVlOiBhbnkpOiB2b2lkIHtcbiAgICBhc3NlcnRTdHJpbmdMaXN0KHZhbHVlKTtcbiAgfVxufVxuXG4vKipcbiAqIEEgc3RyaW5nIGxpc3QgdmFyaWFibGUgcmVmZXJlbmNlLlxuICogVXNlZCB0byByZXNvbHZlIHRoZSB2YWx1ZSBmcm9tIHN0ZXAgaW5wdXRzLlxuICovXG5leHBvcnQgY2xhc3MgU3RyaW5nTGlzdFZhcmlhYmxlIGV4dGVuZHMgR2VuZXJpY1ZhcmlhYmxlIGltcGxlbWVudHMgSVN0cmluZ0xpc3RWYXJpYWJsZSB7XG4gIHB1YmxpYyBzdGF0aWMgb2YocmVmZXJlbmNlOiBzdHJpbmcpOiBTdHJpbmdMaXN0VmFyaWFibGUge1xuICAgIHJldHVybiBuZXcgU3RyaW5nTGlzdFZhcmlhYmxlKHJlZmVyZW5jZSk7XG4gIH1cblxuICByZXNvbHZlVG9TdHJpbmdMaXN0KGlucHV0czogUmVjb3JkPHN0cmluZywgYW55Pik6IE51bGxhYmxlU3RyaW5nTGlzdCB7XG4gICAgcmV0dXJuIHRoaXMucmVzb2x2ZShpbnB1dHMpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFzc2VydFR5cGUodmFsdWU6IGFueSk6IHZvaWQge1xuICAgIGFzc2VydFN0cmluZ0xpc3QodmFsdWUpO1xuICB9XG59XG5cbi8qKlxuICogQXNzZXJ0IHRoYXQgdGhlIGdpdmVuIHZhbHVlIGlzIGEgTnVsbGFibGVTdHJpbmdMaXN0LlxuICogQHBhcmFtIHZhbHVlIHZhbHVlIHRvIGFzc2VydFxuICovXG5leHBvcnQgZnVuY3Rpb24gYXNzZXJ0U3RyaW5nTGlzdCh2YWx1ZTogYW55KTogYXNzZXJ0cyB2YWx1ZSBpcyBOdWxsYWJsZVN0cmluZ0xpc3Qge1xuICBpZiAoIWlzU3RyaW5nTGlzdCh2YWx1ZSkpIHsgdGhyb3cgbmV3IEVycm9yKGAke3ZhbHVlfSBpcyBub3QgYSBzdHJpbmcgbGlzdGApOyB9XG59XG5cbi8qKlxuICogV2hldGhlciB0aGUgZ2l2ZW4gdmFsdWUgaXMgYSBOdWxsYWJsZVN0cmluZ0xpc3QuXG4gKiBAcGFyYW0gdmFsdWUgdmFsdWUgdG8gY2hlY2tcbiAqIEByZXR1cm5zIHRydWUgaWYgdGhlIHZhbHVlIGlzIGEgTnVsbGFibGVTdHJpbmdMaXN0LCBvdGhlcndpc2UgZmFsc2VcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGlzU3RyaW5nTGlzdCh2YWx1ZTogYW55KTogdmFsdWUgaXMgTnVsbGFibGVTdHJpbmdMaXN0IHtcbiAgaWYgKHZhbHVlID09PSBudWxsKSB7IHJldHVybiB0cnVlOyB9XG4gIHJldHVybiBBcnJheS5pc0FycmF5KHZhbHVlKSAmJiB2YWx1ZS5ldmVyeShpc1N0cmluZyk7XG59Il19