import { IGenericVariable, GenericVariable, HardCodedValueBase } from './variable';
/**
 * MapList type that can be null
 */
export declare type NullableMapList = Record<string, any>[];
/**
 * A map list variable
 */
export interface IMapListVariable extends IGenericVariable {
    /**
       * Given the execution inputs, return the resolved value of this variable.
       * @param inputs are the execution inputs.
       */
    resolveToMapList(inputs: Record<string, any>): NullableMapList;
}
/**
 * A hard-coded map list variable.
 * Used when not dependent on step inputs.
 */
export declare class HardCodedMapList extends HardCodedValueBase<Record<string, any>[]> implements IMapListVariable {
    static of(val: Record<string, any>[]): HardCodedMapList;
    resolveToMapList(inputs: Record<string, any>): NullableMapList;
    protected assertType(value: any): void;
}
/**
 * A map list variable reference.
 * Used to resolve the value from step inputs.
 */
export declare class MapListVariable extends GenericVariable implements IMapListVariable {
    static of(reference: string): MapListVariable;
    resolveToMapList(inputs: Record<string, any>): NullableMapList;
    protected assertType(value: any): void;
}
/**
 * Assert that the given value is a NullableMapList.
 * @param value value to assert
 */
export declare function assertMapList(value: any): asserts value is NullableMapList;
/**
 * Whether the given value is a NullableMapList.
 * @param value value to check
 * @returns true if the value is a NullableMapList, otherwise false
 */
export declare function isMapList(value: any): value is NullableMapList;
