import { IGenericVariable } from '..';
import { Operation } from './operation';
import { Platform } from './platform';
/**
 * The precondition parameter is used as a comparator of SSM documents inputs
 * to determine whether a command step would be executed or not.
 * See https://docs.aws.amazon.com/systems-manager/latest/userguide/document-schemas-features.html
 */
export interface PreconditionProps {
    /**
      * (Required) the operation used to compare the parameter with the variable.
      */
    readonly operationType: Operation;
    /**
        * (Required) the variable to compare against the constant.
        */
    readonly variable1: IGenericVariable;
    /**
        * (Required) the being compared against the variable.
        */
    readonly variable2: IGenericVariable;
}
export declare class Precondition {
    static readonly INJECTED_PLAYFORM_TYPE_KEY = "injected_platform_type";
    /**
       * Returns a new Precondition
       * @param platform The platform the preconditions tests against
       * @returns new Precondition with platformType EnvironmentVariable, operation and a constant
       */
    static newPlatformPrecondition(platform: Platform): Precondition;
    readonly operationType: Operation;
    readonly variable1: IGenericVariable;
    readonly variable2: IGenericVariable;
    private constructor();
    /**
       * Evaluates if the precondition is met, by comparing the variable with the constant using the operator.
       * @returns true if the evaluation is true. False otherwise.
       */
    evaluate(inputs: {
        [name: string]: any;
    }): boolean;
    /**
       * @returns an object that can be used to print this choice into yaml/json format.
       */
    asSsmEntry(): {
        [name: string]: any;
    };
}
