#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['flakehell',
 'flakehell._logic',
 'flakehell._patched',
 'flakehell.commands',
 'flakehell.formatters',
 'flakehell.parsers',
 'flakehell.plugins']

package_data = \
{'': ['*']}

install_requires = \
['colorama', 'entrypoints', 'flake8==3.8.4', 'pygments', 'toml', 'urllib3']

extras_require = \
{'dev': ['dlint',
         'flake8-2020',
         'flake8-aaa',
         'flake8-absolute-import',
         'flake8-alfred',
         'flake8-annotations-complexity',
         'flake8-bandit',
         'flake8-black',
         'flake8-broken-line',
         'flake8-bugbear',
         'flake8-builtins',
         'flake8-coding',
         'flake8-cognitive-complexity',
         'flake8-commas',
         'flake8-comprehensions',
         'flake8-debugger',
         'flake8-django',
         'flake8-docstrings',
         'flake8-eradicate',
         'flake8-executable',
         'flake8-expression-complexity',
         'flake8-fixme',
         'flake8-functions',
         'flake8-future-import',
         'flake8-import-order',
         'flake8-isort',
         'flake8-logging-format',
         'flake8-mock',
         'flake8-mutable',
         'flake8-mypy',
         'flake8-pep3101',
         'flake8-pie',
         'flake8-print',
         'flake8-printf-formatting',
         'flake8-pyi',
         'flake8-pytest-style',
         'flake8-pytest',
         'flake8-quotes',
         'flake8-requirements',
         'flake8-rst-docstrings',
         'flake8-scrapy',
         'flake8-spellcheck',
         'flake8-sql',
         'flake8-strict',
         'flake8-string-format',
         'flake8-tidy-imports',
         'flake8-todo',
         'flake8-use-fstring',
         'flake8-variables-names',
         'mccabe',
         'pandas-vet',
         'pep8-naming',
         'pylint',
         'typing-extensions',
         'wemake-python-styleguide',
         'pytest',
         'isort[pyproject]'],
 'docs': ['alabaster', 'pygments-github-lexers', 'recommonmark', 'sphinx']}

entry_points = \
{'console_scripts': ['flake8helled = flakehell:flake8_entrypoint',
                     'flakehell = flakehell:entrypoint'],
 'flake8.extension': ['pylint = flakehell.plugins:PyLintChecker'],
 'flake8.report': ['baseline = flakehell.formatters:BaseLineFormatter',
                   'colored = flakehell.formatters:ColoredFormatter',
                   'gitlab = flakehell.formatters:GitlabFormatter',
                   'grouped = flakehell.formatters:GroupedFormatter',
                   'json = flakehell.formatters:JSONFormatter',
                   'stat = flakehell.formatters:StatFormatter']}

setup(name='ezflakehell',
      version='0.9.2',
      description='Flake8 wrapper to make it nice and configurable',
      author='Gram (@orsinium)',
      author_email='master_fess@mail.ru',
      url='https://github.com/life4/flakehell',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.5',
     )
