"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
/**
 * A load balancer that can host a VPC Endpoint Service
 */
class DummyEndpointLoadBalacer {
    constructor(arn) {
        this.loadBalancerArn = arn;
    }
}
class CnVpcEndpointServiceStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const nlb = new DummyEndpointLoadBalacer('arn:aws-cn:elasticloadbalancing:cn-north-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
        const service1 = new ec2.VpcEndpointService(this, 'MyCnVpcEndpointService', {
            vpcEndpointServiceLoadBalancers: [nlb],
            acceptanceRequired: false,
        });
        new cdk.CfnOutput(this, 'MyCnVpcEndpointServiceServiceName', {
            exportName: 'ServiceName',
            value: service1.vpcEndpointServiceName,
            description: 'Give this to service consumers so they can connect via VPC Endpoint',
        });
    }
}
new CnVpcEndpointServiceStack(app, 'aws-cdk-ec2-cn-vpc-endpoint-service', {
    env: {
        account: '123456789012',
        region: 'cn-north-1',
    },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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