import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadVolumesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/volumes#id DataNomadVolumes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Volume namespace filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/volumes#namespace DataNomadVolumes#namespace}
    */
    readonly namespace?: string;
    /**
    * Volume node filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/volumes#node_id DataNomadVolumes#node_id}
    */
    readonly nodeId?: string;
    /**
    * Plugin ID filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/volumes#plugin_id DataNomadVolumes#plugin_id}
    */
    readonly pluginId?: string;
    /**
    * Volume Type (currently only 'csi')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/volumes#type DataNomadVolumes#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/d/volumes nomad_volumes}
*/
export declare class DataNomadVolumes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_volumes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/d/volumes nomad_volumes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadVolumesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadVolumesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _nodeId?;
    get nodeId(): string;
    set nodeId(value: string);
    resetNodeId(): void;
    get nodeIdInput(): string | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    resetPluginId(): void;
    get pluginIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _volumes;
    get volumes(): cdktf.StringMapList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
