import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadPluginsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/plugins#id DataNomadPlugins#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Volume Type (currently only 'csi')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/plugins#type DataNomadPlugins#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/d/plugins nomad_plugins}
*/
export declare class DataNomadPlugins extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_plugins";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/d/plugins nomad_plugins} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadPluginsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadPluginsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _plugins;
    get plugins(): cdktf.StringMapList;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
