import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_policy#description AclPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_policy#id AclPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_policy#name AclPolicy#name}
    */
    readonly name: string;
    /**
    * HCL or JSON representation of the rules to enforce on this policy. Use file() to specify a file as input.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_policy#rules_hcl AclPolicy#rules_hcl}
    */
    readonly rulesHcl: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/acl_policy nomad_acl_policy}
*/
export declare class AclPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_acl_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/acl_policy nomad_acl_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclPolicyConfig
    */
    constructor(scope: Construct, id: string, config: AclPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rulesHcl?;
    get rulesHcl(): string;
    set rulesHcl(value: string);
    get rulesHclInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
