"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.MSTeamsIncomingWebhook = exports.SlackChannel = exports.SnsTopic = void 0;
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const aws_sns_1 = require("@aws-cdk/aws-sns");
class SnsTopic {
    constructor(topic) {
        this.topic = topic;
    }
    bind(_scope, _rule) {
        this.topic.grantPublish(new aws_iam_1.ServicePrincipal('codestar-notifications.amazonaws.com'));
        return {
            targetType: TargetType.SNS,
            targetAddress: this.topic.topicArn,
        };
    }
}
exports.SnsTopic = SnsTopic;
class SlackChannel {
    constructor(channel) {
        this.channel = channel;
    }
    bind(_scope, _rule) {
        return {
            targetType: TargetType.AWS_CHATBOT_SLACK,
            targetAddress: this.channel.configurationArn,
        };
    }
}
exports.SlackChannel = SlackChannel;
class MSTeamsIncomingWebhook {
    constructor(webhook) {
        this.webhook = webhook;
    }
    bind(scope, _rule) {
        const msTeamsTopic = new aws_sns_1.Topic(scope, `${scope.node.id}MSTeamsTopic`);
        msTeamsTopic.grantPublish(new aws_iam_1.ServicePrincipal('codestar-notifications.amazonaws.com'));
        this.webhook.addEventSource(new aws_lambda_event_sources_1.SnsEventSource(msTeamsTopic));
        return {
            targetType: TargetType.SNS,
            targetAddress: msTeamsTopic.topicArn,
        };
    }
}
exports.MSTeamsIncomingWebhook = MSTeamsIncomingWebhook;
var TargetType;
(function (TargetType) {
    TargetType["SNS"] = "SNS";
    TargetType["AWS_CHATBOT_SLACK"] = "AWSChatbotSlack";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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