"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiCallHandler = exports.flatten = void 0;
/* eslint-disable no-console */
const base_1 = require("./base");
const utils_1 = require("./utils");
/**
 * Flattens a nested object
 *
 * @param object the object to be flattened
 * @returns a flat object with path as keys
 */
function flatten(object) {
    return Object.assign({}, ...function _flatten(child, path = []) {
        return [].concat(...Object.keys(child)
            .map(key => {
            const childKey = Buffer.isBuffer(child[key]) ? child[key].toString('utf8') : child[key];
            return typeof childKey === 'object' && childKey !== null
                ? _flatten(childKey, path.concat([key]))
                : ({ [path.concat([key]).join('.')]: childKey });
        }));
    }(object));
}
exports.flatten = flatten;
class AwsApiCallHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        // eslint-disable-next-line
        const AWS = require('aws-sdk');
        console.log(`AWS SDK VERSION: ${AWS.VERSION}`);
        const service = new AWS[request.service]();
        const response = await service[request.api](request.parameters && utils_1.decode(request.parameters)).promise();
        console.log(`SDK response received ${JSON.stringify(response)}`);
        delete response.ResponseMetadata;
        const respond = {
            apiCallResponse: response,
        };
        const flatData = {
            ...flatten(respond),
        };
        return request.flattenResponse === 'true' ? flatData : respond;
    }
}
exports.AwsApiCallHandler = AwsApiCallHandler;
//# sourceMappingURL=data:application/json;base64,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