# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['mock_alchemy']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.3.22,<2.0.0']

setup_kwargs = {
    'name': 'mock-alchemy',
    'version': '0.2.2',
    'description': 'SQLAlchemy mock helpers.',
    'long_description': '<p align="center"><a href="https://raw.githubusercontent.com/rajivsarvepalli/mock-alchemy/master/docs/_static/alchemy.svg"><img src="https://raw.githubusercontent.com/rajivsarvepalli/mock-alchemy/master/docs/_static/alchemy.svg" alt="alchemy bottle icon" height="60"/></a></p>\n<h1 align="center">mock-alchemy</h1>\n<p align="center">Simple and intuitive SQLAlchemy mock helpers.</p>\n\n<p align="center">\n    <a href="https://mock-alchemy.readthedocs.io/en/latest/?badge=latest"><img src="https://readthedocs.org/projects/mock-alchemy/badge/?version=latest"/></a>\n    <a href="https://pypi.org/project/mock-alchemy/"><img src="https://img.shields.io/pypi/v/mock-alchemy.svg"/></a>\n    <a href="https://pypi.org/project/mock-alchemy/"><img src="https://raw.githubusercontent.com/rajivsarvepalli/mock-alchemy/master/imgs/python_versions.svg"/></a>\n    <a href="https://github.com/rajivsarvepalli/mock-alchemy/actions?workflow=Tests"><img src="https://github.com/rajivsarvepalli/mock-alchemy/workflows/Tests/badge.svg"/></a>\n    <a href="https://codecov.io/gh/rajivsarvepalli/mock-alchemy"><img src="https://codecov.io/gh/rajivsarvepalli/mock-alchemy/branch/master/graph/badge.svg"/></a>\n\n</p><br/><br/>\n\n## 🤖 Mocking SQLAlchemy\n\nSQLAlchemy is awesome.\n\nUnittests are great.\n\nAccessing DB during tests -\nnot so much. This library provides an easy way to mock SQLAlchemy\'s\nsession in unittests while preserving the ability to do sane asserts.\n\n- Free software: MIT license\n- GitHub: <https://github.com/rajivsarvepalli/mock-alchemy>\n\n## 📚 Documentation\n\nFull documentation is available at <http://mock-alchemy.rtfd.io/>. On\nthe documentation, you should be able to select a version of your choice\nin order to view documentation of an older version if need be.\n\nThis README includes some basic examples, but more detailed examples are\nincluded in the documentation, especially in the [user guide][]. If you\nare looking for an API reference, it is also available on the\n[documentation][].\n\n## 📦 Installing\n\nYou can install `mock-alchemy` using pip:\n\n    $ pip install mock-alchemy\n\nIf you want to use this package on Python 2.7 or Python 3.6, then\ninstall `mock-alchemy` using:\n\n    $ pip install "mock-alchemy>=0.1.0,<0.2.0"\n\nPip should auto-detect the correct version but this ensures the correct\nversion is downloaded for your needs.\n\n[user guide]: https://mock-alchemy.readthedocs.io/en/latest/user_guide/\n[documentation]: https://mock-alchemy.readthedocs.io/en/latest/api_reference/mock_alchemy.mocking.html\n\n# 🔖 Versioning\n\nThere are several different versions of `mock-alchemy` available\ndepending on your needs. The versions `0.1.x` are available for use on\nPython 2.7, Python 3.6+. The newer versions serve users who are on\nPython 3.7+. For people interested in contributing, if you want to work\non Python 2.7 version checkout the branch <span\nclass="title-ref">0.1.x</span> and then create pull-requests to that\nbranch. There is a set of specific tests run for that branch on pushes\nand pull-requests since there are different tests for the newer versions\nof `mock-alchemy`. Check out [contributor guide][] for more information.\n\nDocumentation for the 0.1.0 version is [available][]. However, the\ncurrent documentation should do a sufficient job at illustrating both\nthe past and the features of the present version at least as of now.\nTherefore, I suggest using the most recent documentation for now, and if\nyou want, you can switch using the readthedocs version system (click on\nthe drop-down menu on the bottom right of the screen on the\ndocumentation or go to the [project page][]).\n\n# 📤 Credit\n\nThe original library (`alchemy-mock`) was created by Miroslav\nShubernetskiy and Serkan Hoscai. This is a forked version due to a lack\nof updates in the original library. It appeared that the `alchemy-mock`\nproject was no longer supported. Therefore, since I desired to add some\nbasic support for deleting, I created my own version of the library.\n\nFull credit goes to the original creators for starting and building this\nproject. You can find the original package on [PyPi][] and [Github][].\n\n[contributor guide]: http://mock-alchemy.rtfd.io/en/latest/contributor_guide\n[available]: https://mock-alchemy.readthedocs.io/en/v0.1.0/\n[project page]: https://readthedocs.org/projects/mock-alchemy/\n[pypi]: https://pypi.org/project/alchemy-mock/\n[github]: https://github.com/miki725/alchemy-mock\n\n# ⚙ Using\n\nNormally SQLAlchemy\'s expressions cannot be easily compared\nas comparison on binary expression produces yet another binary expression:\n\n    >>> type((Model.foo == 5) == (Model.bar == 5))\n    <class \'sqlalchemy.sql.elements.BinaryExpression\'>\n\nBut they can be compared with this library:\n\n    >>> ExpressionMatcher(Model.foo == 5) == (Model.bar == 5)\n    False\n\n`ExpressionMatcher` can be directly used:\n\n    >>> from mock_alchemy.comparison import ExpressionMatcher\n    >>> ExpressionMatcher(Model.foo == 5) == (Model.foo == 5)\n    True\n\nAlternatively `AlchemyMagicMock` can be used to mock out SQLAlchemy session:\n\n    >>> from mock_alchemy.mocking import AlchemyMagicMock\n    >>> session = AlchemyMagicMock()\n    >>> session.query(Model).filter(Model.foo == 5).all()\n\n    >>> session.query.return_value.filter.assert_called_once_with(Model.foo == 5)\n\nIn real world though session can be interacted with multiple times to query some data.\nIn those cases `UnifiedAlchemyMagicMock` can be used which combines various calls for easier assertions:\n\n    >>> from mock_alchemy.mocking import UnifiedAlchemyMagicMock\n    >>> session = UnifiedAlchemyMagicMock()\n\n    >>> m = session.query(Model)\n    >>> q = m.filter(Model.foo == 5)\n    >>> if condition:\n    ...     q = q.filter(Model.bar > 10).all()\n    >>> data1 = q.all()\n    >>> data2 = m.filter(Model.note == \'hello world\').all()\n\n    >>> session.filter.assert_has_calls([\n    ...     mock.call(Model.foo == 5, Model.bar > 10),\n    ...     mock.call(Model.note == \'hello world\'),\n    ... ])\n\nAlso real-data can be stubbed by criteria:\n\n    >>> from mock_alchemy.mocking import UnifiedAlchemyMagicMock\n    >>> session = UnifiedAlchemyMagicMock(data=[\n    ...     (\n    ...         [mock.call.query(Model),\n    ...          mock.call.filter(Model.foo == 5, Model.bar > 10)],\n    ...         [Model(foo=5, bar=11)]\n    ...     ),\n    ...     (\n    ...         [mock.call.query(Model),\n    ...          mock.call.filter(Model.note == \'hello world\')],\n    ...         [Model(note=\'hello world\')]\n    ...     ),\n    ...     (\n    ...         [mock.call.query(AnotherModel),\n    ...          mock.call.filter(Model.foo == 5, Model.bar > 10)],\n    ...         [AnotherModel(foo=5, bar=17)]\n    ...     ),\n    ... ])\n    >>> session.query(Model).filter(Model.foo == 5).filter(Model.bar > 10).all()\n    [Model(foo=5, bar=11)]\n    >>> session.query(Model).filter(Model.note == \'hello world\').all()\n    [Model(note=\'hello world\')]\n    >>> session.query(AnotherModel).filter(Model.foo == 5).filter(Model.bar > 10).all()\n    [AnotherModel(foo=5, bar=17)]\n    >>> session.query(AnotherModel).filter(Model.note == \'hello world\').all()\n    []\n\nThe `UnifiedAlchemyMagicMock` can partially fake session mutations\nsuch as `session.add(instance)`. For example:\n\n    >>> session = UnifiedAlchemyMagicMock()\n    >>> session.add(Model(pk=1, foo=\'bar\'))\n    >>> session.add(Model(pk=2, foo=\'baz\'))\n    >>> session.query(Model).all()\n    [Model(foo=\'bar\'), Model(foo=\'baz\')]\n    >>> session.query(Model).get(1)\n    Model(foo=\'bar\')\n    >>> session.query(Model).get(2)\n    Model(foo=\'baz\')\n\nNote that its partially correct since if added models are filtered on,\nsession is unable to actually apply any filters so it returns everything:\n\n    >>> session.query(Model).filter(Model.foo == \'bar\').all()\n    [Model(foo=\'bar\'), Model(foo=\'baz\')]\n\nFinally, `UnifiedAlchemyMagicMock` can partially fake deleting. Anything that can be\naccessed with `all` can also be deleted. For example:\n\n    >>> s = UnifiedAlchemyMagicMock()\n    >>> s.add(SomeClass(pk1=1, pk2=1))\n    >>> s.add_all([SomeClass(pk1=2, pk2=2)])\n    >>> s.query(SomeClass).all()\n    [1, 2]\n    >>> s.query(SomeClass).delete()\n    2\n    >>> s.query(SomeClass).all()\n    []\n\nNote the limitation for dynamic sessions remains the same. Additionally, the delete will not be propagated across\nqueries (only unified in the exact same query). As in, if there are multiple queries in which the \'same\'\nobject is present, this library considers them separate objects. For example:\n\n    >>> s = UnifiedAlchemyMagicMock(data=[\n    ...     (\n    ...         [mock.call.query(\'foo\'),\n    ...          mock.call.filter(c == \'one\', c == \'two\')],\n    ...         [SomeClass(pk1=1, pk2=1), SomeClass(pk1=2, pk2=2)]\n    ...     ),\n    ...     (\n    ...         [mock.call.query(\'foo\'),\n    ...          mock.call.filter(c == \'one\', c == \'two\'),\n    ...          mock.call.order_by(c)],\n    ...         [SomeClass(pk1=2, pk2=2), SomeClass(pk1=1, pk2=1)]\n    ...     ),\n    ...     (\n    ...         [mock.call.filter(c == \'three\')],\n    ...         [SomeClass(pk1=3, pk2=3)]\n    ...     ),\n    ...     (\n    ...         [mock.call.query(\'foo\'),\n    ...          mock.call.filter(c == \'one\', c == \'two\', c == \'three\')],\n    ...         [SomeClass(pk1=1, pk2=1), SomeClass(pk1=2, pk2=2), SomeClass(pk1=3, pk2=3)]\n    ...     ),\n    ... ])\n\n    >>> s.query(\'foo\').filter(c == \'three\').delete()\n    1\n    >>> s.query(\'foo\').filter(c == \'three\').all()\n    []\n    >>> s.query(\'foo\').filter(c == \'one\').filter(c == \'two\').filter(c == \'three\').all()\n    [1, 2, 3]\n\nThe item referred to by `c == \'three\'` is still present in the filtered query despite the individual item being deleted.\n\n# 👷 Contributing\n\nContributions are welcome. To learn more, see the [Contributor Guide][].\n\n# 📕 License\n\nDistributed under the terms of the [MIT][] license, _mock-alchemy_ is\nfree and open source software.\n\n# 💥 Issues\n\nIf you encounter any issues or problems, please [file an issue][] along\nwith a detailed description.\n\n[contributor guide]: https://mock-alchemy.readthedocs.io/en/latest/contributor_guide/\n[mit]: http://opensource.org/licenses/MIT\n[file an issue]: https://github.com/rajivsarvepalli/mock-alchemy/issues\n',
    'author': 'Rajiv Sarvepalli',
    'author_email': 'rajiv@sarvepalli.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rajivsarvepalli/mock-alchemy',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
