# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_inst.ipynb.

# %% auto 0
__all__ = ['itertype', 'boolic', 'bool01', 'bools', 'intq', 'ints', 'floatq', 'floats', 'real', 'realq', 'reals', 'num', 'numq',
           'nums', 'iternum', 'none', 'nan', 'nanq', 'nans', 'numstr', 'pttn', 'strtmpl', 'strq', 'nilstr', 'strbytes',
           'notnilstr', 'notstrbytes', 'strs', 'iterstr', 'size', 'array', 'tensor', 'nantensor', 'nnmodule',
           'neuralode', 'neuralsde', 'neuraldynamics', 'odefunc', 'sdefunc', 'sdeito', 'brownianintervial', 'groupkey',
           'indextype', 'indexlike', 'catindex', 'boolindex', 'seriestype', 'serieslike', 'serialized', 'datatype',
           'shaped', 'graphtype', 'dimmed', 'dim1', 'dim2', 'dim3', 'dim4']

# %% ../nbs/10_inst.ipynb 6
import math

# %% ../nbs/10_inst.ipynb 8
from typing import (Literal, Iterable, )

# %% ../nbs/10_inst.ipynb 10
#| export


# %% ../nbs/10_inst.ipynb 12
from matr import matr, matrs
from matr import (
    nan, nonetype, npnan, npNaN, npNAN, pdna, ptnan, number, npbool, repattern, strtemplate, 
    npmatrix, nparray, recarray, npempty, sparray, spmatrix, 
    pdindex, pdseries, pdcatindex, pddataframe, 
    
    ptsize, ptmodule, ptdataset, ptdataloader, 
    pttensorbase, pttensor, ptinttensor, ptbooltensor, 
    ptfloattensor, plmodule, pldatamodule, 
    
    odefn, sdefn, neurode, neursde, augmenter, 
    ito, brownian, 
    anndata, 
    
    gtbase, gtdata, bgraph, dgraph, 
    lgraph, kgraph, tgraph, mgraph, 
    klgraph, mlgraph, tlgraph
)

# %% ../nbs/10_inst.ipynb 14
from .prot import Prototype, Opt, Not

# %% ../nbs/10_inst.ipynb 16
@Prototype(Iterable)
class itertype: '''iterable type'''

# %% ../nbs/10_inst.ipynb 20
@Prototype(bool, npbool)
class boolic: '''bool, np.bool_'''

@Prototype(bool, npbool, 0, 1)
class bool01: '''bool, np.bool_, 0, 1'''

@Prototype(list, tuple, itertype, attrs=dict(dtype=bool01))
class bools: '''list of bool01'''

# %% ../nbs/10_inst.ipynb 26
@Opt(int)
class intq: '''int or None'''

@Prototype(int, list, tuple, itertype, nparray, attrs=dict(dtype=int))
class ints: '''iterable of ints'''

# %% ../nbs/10_inst.ipynb 28
@Opt(float)
class floatq: '''float or None'''

@Prototype(float, list, tuple, itertype, nparray, attrs=dict(dtype=float))
class floats: '''iterable of floats'''

# %% ../nbs/10_inst.ipynb 30
@Prototype(int, float)
class real: '''R (i.e. int or float)'''

@Opt(real)
class realq: '''real or None'''

@Prototype(real, list, tuple, itertype, nparray, attrs=dict(dtype=real))
class reals: '''iterable of `real`'''

# %% ../nbs/10_inst.ipynb 32
@Prototype(int, float, complex, number)
class num: '''int, float, complex, or Number'''

@Opt(num)
class numq: '''num or None'''

@Prototype(num, list, tuple, itertype, nparray, attrs=dict(dtype=num))
class nums: '''list of `num`'''

@Prototype(itertype, attrs=dict(dtype=num))
class iternum: '''iterable of `num``'''

# %% ../nbs/10_inst.ipynb 36
@Prototype(None, nonetype)
class none: '''`None` or `NoneType`'''

# %% ../nbs/10_inst.ipynb 37
@Prototype(math.nan, pdna, npnan, npNaN, npNAN, ptnan)
class nan: '''`math.nan`, `pd.NA`, `np.nan`, `np.NaN`, or `np.NAN`'''

@Opt(nan)
class nanq: '''`math.nan`, `pd.NA`, `np.nan`, `np.NaN`, `np.NAN`, or `None`'''

@Prototype(nan, list, tuple, itertype, nparray, attrs=dict(dtype=nan))
class nans: '''list of `nan`'''

# %% ../nbs/10_inst.ipynb 41
@Prototype(num, str)
class numstr: '''`num` or str'''

# %% ../nbs/10_inst.ipynb 43
@Prototype(repattern)
class pttn: '''`re.Pattern`'''

@Prototype(str, strtemplate)
class strtmpl: '''`str or string.Template`'''

# %% ../nbs/10_inst.ipynb 44
@Opt(str)
class strq: '''str or `None`'''

@Prototype(Literal[''])
class nilstr: '''`''` (the nil string)'''

# %% ../nbs/10_inst.ipynb 45
@Prototype(str, bytes)
class strbytes: '''str or bytes'''

@Not(nilstr)
class notnilstr: '''not `nilstr` (not `''`, the nil string)'''

@Not(str, bytes)
class notstrbytes: '''not (str or bytes)'''

@Prototype(list, tuple, itertype, notstrbytes, attrs=dict(dtype=str))
class strs: '''iterable of `str`'''

@Prototype(itertype, notstrbytes, attrs=dict(dtype=str))
class iterstr: '''iterable of `str`'''

# %% ../nbs/10_inst.ipynb 47
@Prototype(tuple, ptsize, itertype, attrs=dict(dtype=int))
class size: '''size type (e.g. `tuple`, `torch.Size`, `itertype`)'''

# %% ../nbs/10_inst.ipynb 49
@Prototype(nparray, recarray, sparray, itertype, list)
class array: '''array type
    (e.g. `np.array`, `np.recarray`, `sp.sparray`, `itertype`, or `list`)'''

@Prototype(pttensor, ptinttensor, ptbooltensor, ptfloattensor)
class tensor: '''tensor type
    (e.g. `torch.tensor`, `torch.IntTensor`, `torch.BoolTensor`, or `torch.FloatTensor`)'''

@Prototype(tensor, nans, attrs=dict(dtype=nan))
class nantensor: '''tensor of `nan`s'''

# %% ../nbs/10_inst.ipynb 51
@Prototype(ptmodule, plmodule)
class nnmodule: ''' module type 
    (e.g. `torch.nn.Module` or `pytorch_lightning.LightningModule`)'''


# %% ../nbs/10_inst.ipynb 53
@Prototype(neurode)
class neuralode: '''torchdyn neural ODE'''

@Prototype(neursde)
class neuralsde: '''torchdyn neural SDE'''

@Prototype(neuralode, neuralsde)
class neuraldynamics: '''neuralode or neuralsde'''

# %% ../nbs/10_inst.ipynb 54
@Prototype(odefn)
class odefunc: '''`torchdyn.ODEFunc`'''

@Prototype(sdefn)
class sdefunc: '''`torchdyn.SDEFunc`'''

@Prototype(ito)
class sdeito: '''`torchsde.ito`'''

@Prototype(brownian)
class brownianintervial: '''`torchsde.BrownianInterval`'''

# %% ../nbs/10_inst.ipynb 57
@Prototype(str, tuple, num, attrs=dict(dtype=numstr))
class groupkey: '''groupby key (e.g. `str`, `tuple`, or `numstr`)'''

@Prototype(list, bools, nums, itertype, pdindex, pdcatindex, nparray)
class indextype: '''index type 
    (e.g. `list`, `bools`, `nums`, `itertype`, `pd.Index`, `pd.CategoricalIndex`, or `np.array`)'''

@Prototype(indextype)
class indexlike: '''index-like type'''

@Prototype(pdcatindex)
class catindex: '''categorical index'''

@Prototype(indexlike, nparray, list, attrs=dict(dtype=bool01))
class boolindex: '''boolean index'''

# %% ../nbs/10_inst.ipynb 59
@Prototype(pdseries, nparray, recarray, list, indexlike)
class seriestype: '''series type 
    (e.g. `pd.Series`, `np.array`, `np.recarray`, `list`, or `indexlike`)'''

@Prototype(seriestype)
class serieslike: '''series-like type'''

@Prototype(seriestype)
class serialized: '''serialized'''

# %% ../nbs/10_inst.ipynb 61
@Prototype(npmatrix, nparray, recarray, sparray, spmatrix, anndata)
class datatype: '''data type 
    (e.g. `np.matrix`, `np.array`, `np.recarray`, `sp.array`, `sp.matrix`, or `anndata`)'''

@Prototype(datatype, pdindex, pdseries, pdcatindex, pddataframe, tensor, hasattrs=('shape', ))
class shaped: '''shaped `datatype`'''

@Prototype(bgraph, dgraph, kgraph, tgraph, lgraph, mgraph, tlgraph, klgraph, mlgraph)
class graphtype: '''graph type 
    (e.g. `BaseGraph`, `DataGraph`, `LandmarkGraph`, `kNNGraph`, `TraditionalGraph`, 
    `MNNGraph`, `kNNLandmarkGraph`, `TraditionalLandmarkGraph`, or `MNNLandmarkGraph`)'''

# %% ../nbs/10_inst.ipynb 63
@Prototype(list, nparray, hasattrs=('ndim', ))
class dimmed: 'np.ndarray with shape (i, )'

@Prototype(list, nparray, attrs=dict(ndim=1))
class dim1: 'np.ndarray with shape (i, )'

@Prototype(list, nparray, attrs=dict(ndim=2))
class dim2: 'np.ndarray with shape (i, j, )'

@Prototype(list, nparray, attrs=dict(ndim=3))
class dim3: 'np.ndarray with shape (i, j, k, )'

@Prototype(list, nparray, attrs=dict(ndim=4))
class dim4: 'np.ndarray with shape (i, j, k, l, )'
