# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/06_impr.ipynb.

# %% auto 0
__all__ = ['imod', 'itry', 'ImportedAttribute', 'iattr', 'iattrs']

# %% ../nbs/06_impr.ipynb 6
import os, io, math, inspect
from abc import abstractmethod
from math import isnan as math_isnan, nan as math_nan
from enum import StrEnum, auto
from inspect import signature, Signature
from operator import eq, is_, attrgetter
from functools import wraps, partial
from importlib import import_module
from itertools import accumulate
from contextlib import redirect_stderr

# %% ../nbs/06_impr.ipynb 8
from types import (
    NoneType, MethodType, ModuleType, FunctionType, SimpleNamespace, 
    MethodWrapperType, BuiltinFunctionType, BuiltinMethodType
)

import typing
from typing import (
    Any, Dict, Self, Type, Tuple, Union, Literal,
    TypeVar, TypeAlias, TypeGuard, ClassVar, ParamSpec, Generic, _SpecialForm,
    Callable, Iterable, Optional, Protocol, _ProtocolMeta, NamedTuple,
    get_args, get_origin, runtime_checkable, overload, 
)

# %% ../nbs/06_impr.ipynb 10
#| export


# %% ../nbs/06_impr.ipynb 12
from pdec import slotprops, Property

# %% ../nbs/06_impr.ipynb 14
from .atyp import T, Types, Namespace, ImportedAsset
from .util import setsig, newtype

# %% ../nbs/06_impr.ipynb 16
def imod(
    name: str, 
    attr: Optional[str] = None,
    bases: Union[Types, type] = tuple(), 
    namespace: Namespace = dict(),
    default: Optional[T] = None,
    **kwargs
) -> ImportedAsset:
    '''Import a specific attribute from a module or return a default value if import fails.

    Parameters
    ----------
    name : str
        The name of the module to import from.
        
    attr : Optional[str]
        The name of the attribute to import from the module, defaults to None.
        
    bases : Union[Types, type]
        Base classes for creating a new type if import fails and default is None.
        
    namespace : dict
        A namespace dictionary for creating a new type.
        
    default : Optional[type]
        A default value to return if import fails.
        
    **kwargs
        Additional keyword arguments passed to tnew.

    Returns
    -------
    Optional[type]
        The imported attribute, or the default value, or a new type created using newtype.
    '''
    cls = kwargs.pop('cls', None)
    if not isinstance(bases, tuple): 
        bases = (bases, )
    
    try: 
        mod = import_module(name)
        attr = getattr(mod, attr) if attr is not None else mod
        
        if isinstance(attr, (FunctionType, MethodType, BuiltinFunctionType, )):
            
            @wraps(attr)
            def wrapper(*args, **kwargs): 
                return attr(*args, **kwargs)
            
            wrapper = setsig(wrapper, attr)
            return wrapper
        
        else: 
            return attr
    
    except (ImportError, AttributeError):
        if default is not None: 
            return default
        try: 
            return namespace.get(attr, newtype(attr, bases, namespace, cls=cls, **kwargs))
        except TypeError: 
            return default

# %% ../nbs/06_impr.ipynb 17
def itry(
    name: str, 
    *attrs: str, 
    bases: Union[Types, type] = tuple(), 
    namespace: Namespace = dict(), 
    **kwargs
) -> Tuple[ImportedAsset, ...]:
    '''Try to import multiple attributes from a module, returning a tuple of results.

    Parameters
    ----------
    name : str
        The name of the module to import from.

    attrs : str
        Variable number of attribute names to import from the module.

    bases : Union[Tuple[type, ...], type]
        Base classes for creating new types if import fails.

    namespace : dict
        A namespace dictionary for creating new types.

    **kwargs
        Additional keyword arguments passed to imod.

    Returns
    -------
    Tuple[Optional[type], ...]
        A tuple of the imported attributes or default values.
    '''
    return tuple(imod(name, attr, bases, namespace, **kwargs) for attr in attrs)

# %% ../nbs/06_impr.ipynb 18
@slotprops(dict(
    asset = Property('asset', ImportedAsset, gen = lambda self: self.__import__()),
    arepr = Property('arepr', ImportedAsset, gen = lambda self: self.__asset_repr__()),
))
class ImportedAttribute:
    '''A class representing an attribute imported from a module.

    Attributes
    ----------
    name : ClassVar[str]
        The name of the module or attribute.
        
    attr : ClassVar[Optional[str]]
        The specific attribute to import, if any.
        
    bases : ClassVar[Union[Types, type]]
        Base classes for creating new types if import fails.
        
    namespace : ClassVar[Namespace]
        A namespace dictionary for creating new types.
        
    default : ClassVar[Optional[T]]
        Default value if the import fails.
        
    _imported : bool
        Indicates if the import was successful.
        
    asset : property
        The imported asset.
        
    arepr : property
        String representation of the imported asset.

    Methods
    -------
    io(ins: 'ImportedAttribute')
        Import an instance of ImportedAttribute class.
        
    ib(bases: Types)
        Import bases using the `io` method.
        
    __init__(self, name, attr, bases, namespace, default, eager, **kwargs)
        Initialize the ImportedAttribute instance.
        
    __import__(self)
        Import the asset using the `imod` method.
        
    __asset_repr__(self)
        Return the string representation of the asset.
        
    __call__(self, *args, **kwargs)
        Call the imported asset if callable.
        
    __repr__(self)
        Return the string representation of the ImportedAttribute instance.
        
    __getitem__(self, key)
        Get an item from the imported asset.
        
    __getattribute__(self, __name)
        Override getattribute to prioritize the asset's attributes.
    '''
    name: ClassVar[str]
    attr: ClassVar[Optional[str]] = None
    bases: ClassVar[Union[Types, type]] = tuple()
    namespace: ClassVar[Namespace] = dict()
    default: ClassVar[Optional[T]] = None
    _imported: bool = False
    asset: property
    arepr: property
    
    @classmethod
    def io(cls, ins: 'ImportedAttribute') -> ImportedAsset:
        '''Import instance of Imported Attribute class'''
        if not isinstance(ins, cls): return ins
        if not isinstance(ins, ImportedAttribute): return ins
        return ins.__import__()
    
    @classmethod
    def ib(cls, bases: Types = tuple()) -> Types:
        '''Import bases using `io` method which is fault tolerant'''
        return tuple(cls.io(base) for base in bases)
    
    def __init__(
        self: Self, name: str, attr: Optional[str] = None, bases: Types = tuple(), 
        namespace: Namespace = dict(), default: Optional[T] = None, eager: bool = False, **kwargs
    ):
        self.name = name
        kwargs.update(dict(attr=attr, bases=bases, namespace=namespace, default=default))
        for key in ('attr', 'bases', 'namespace', 'default'):
            val = kwargs.get(key, getattr(type(self), key, None))
            setattr(self, key, val)
            
        self._imported = False
        if eager: self.__import__()
            
    def __import__(self: Self) -> ImportedAsset:
        '''Import asset using `imod` method which is fault tolerant. 
        
        If any of the classes in `self.bases` are `ImportedAttribute` instances,
        they will be imported first and then passed to `imod` as bases.
        '''
        if hasattr(self, '_asset'): return self._asset
        if self._imported: return self._asset
        self._asset = imod(self.name, self.attr, self.ib(self.bases), self.namespace, self.default)
        # self.__wrap_call__()
        if self._asset != self.default: self._imported = True
        return self._asset
    
    def __asset_repr__(self: Self) -> Optional[str]:
        '''Return repr of asset if it exists, otherwise return None.'''
        if not hasattr(self, '_asset'): return None
        if getattr(self, '_arepr', None) is None: return repr(self._asset)
        return self._arepr
    
    def __call__(self: Self, *args, **kwargs) -> ImportedAsset:
        try:
            if callable(self.asset): 
                return self.asset(*args, **kwargs)
        except: ...
        return self.asset
        
    def __repr__(self) -> str:
        return self.arepr or f'{self.name}({self.attr})'
    
    def __getitem__(self: Self, key: str) -> ImportedAsset:
        if hasattr(self, '_asset'): return getattr(self.asset, key)
        return getattr(self, key)
    
    def __getattribute__(self: Self, __name: str):
        # prioritize self first
        try: return super().__getattribute__(__name)
        except AttributeError: ...
        # then try asset
        try:
            asset = object.__getattribute__(self, '_asset')
            return object.__getattribute__(asset, __name)
        except AttributeError: ...
        # then back to self and raise error if not found
        return super().__getattribute__(__name)
    
    
# Alias for `ImportedAttribute` class
@wraps(ImportedAttribute, updated=())
class iattr(ImportedAttribute):
    '''An alias for the ImportedAttribute class.'''

# %% ../nbs/06_impr.ipynb 19
def iattrs(
    name: str, 
    *attrs: str, 
    bases: Union[Types, type] = tuple(), 
    namespace: Namespace = dict(), 
    **kwargs
) -> tuple[ImportedAttribute, ...]:
    '''Try to import multiple attributes from a module, returning a tuple of results.

    Parameters
    ----------
    name : str
        The name of the module to import from.

    attrs : str
        Variable number of attribute names to import from the module.

    bases : Union[Tuple[type, ...], type]
        Base classes for creating new types if import fails.

    namespace : dict
        A namespace dictionary for creating new types.

    **kwargs
        Additional keyword arguments passed to imod.

    Returns
    -------
    Tuple[ImportedAttribute, ...]
        A tuple of the imported attributes or default values.
    '''
    return tuple(iattr(name, attr, bases, namespace, **kwargs) for attr in attrs)

