# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_inst.ipynb.

# %% auto 0
__all__ = ['nan', 'nonetype', 'number', 'npbool', 'npmatrix', 'nparray', 'recarray', 'npempty', 'npnan', 'npNaN', 'npNAN', 'pdna',
           'ptnan', 'repattern', 'strtemplate', 'ptsize', 'pdindex', 'pdseries', 'pdcatindex', 'pddataframe', 'sparray',
           'spmatrix', 'ptmodule', 'ptdataset', 'ptdataloader', 'pttensorbase', 'pttensor', 'ptinttensor',
           'ptbooltensor', 'ptfloattensor', 'plmodule', 'pldatamodule', 'odefn', 'sdefn', 'neurode', 'neursde',
           'augmenter', 'ito', 'brownian', 'anndata', 'gtbase', 'gtdata', 'bgraph', 'dgraph', 'lgraph', 'kgraph',
           'tgraph', 'mgraph', 'klgraph', 'mlgraph', 'tlgraph']

# %% ../nbs/10_inst.ipynb 6
import os, io, math, inspect
from abc import abstractmethod
from math import isnan as math_isnan, nan as math_nan
from enum import StrEnum, auto
from inspect import signature, Signature, signature
from operator import eq, is_, attrgetter
from functools import wraps, partial
from importlib import import_module
from itertools import accumulate
from contextlib import redirect_stderr

# %% ../nbs/10_inst.ipynb 8
from types import (
    NoneType, MethodType, ModuleType, FunctionType, SimpleNamespace, 
    MethodWrapperType, BuiltinFunctionType, BuiltinMethodType
)

import typing
from typing import (
    Any, Dict, Self, Type, Tuple, Union, Literal,
    TypeVar, TypeAlias, TypeGuard, ClassVar, ParamSpec, Generic, _SpecialForm,
    Callable, Iterable, Optional, Protocol, _ProtocolMeta, NamedTuple,
    get_args, get_origin, runtime_checkable, overload, 
)

# %% ../nbs/10_inst.ipynb 10
#| export


# %% ../nbs/10_inst.ipynb 12
#| export


# %% ../nbs/10_inst.ipynb 14
#| export


# %% ../nbs/10_inst.ipynb 17
nan = iattr('math', 'nan')
nonetype = iattr('types', 'NoneType')
number = iattr('numbers', 'Number')
npbool = iattr('numpy', 'bool_', default=bool)
npmatrix, nparray, recarray, npempty = \
    iattrs('numpy', 'matrix', 'ndarray', 'recarray', 'empty', default=list)

npnan, npNaN, npNAN = iattrs('numpy', 'nan', 'NaN', 'NAN', default=nan)
pdna = iattr('pandas', 'NA', default=nan)
ptnan = iattr('torch', 'nan', default=nan)
repattern = iattr('re', 'Pattern')
strtemplate = iattr('string', 'Template')
ptsize = iattr('torch', 'size', default=tuple)
pdindex, pdseries, pdcatindex, pddataframe = \
    iattrs('pandas', 'Index', 'Series', 'CategoricalIndex', 'DataFrame', default=list)

sparray = iattr('scipy.sparse._arrays', '_sparray')
sparray = iattr('scipy.sparse', 'sparray', default=(sparray or list))
spmatrix = iattr('scipy.sparse', 'spmatrix', default=list)
ptmodule = iattr('torch.nn', 'Module')
ptdataset, ptdataloader = iattrs('torch.utils.data', 'Dataset', 'DataLoader')
pttensorbase = iattr('torch._C', '_TensorBase')
pttensor = iattr('torch', 'Tensor', bases=(pttensorbase, ))
ptinttensor, ptbooltensor, ptfloattensor = \
    iattrs('torch', 'IntTensor', 'BoolTensor', 'FloatTensor', bases=(pttensor, ))

plmodule = iattr('pytorch_lightning', 'LightningModule', default=ptmodule)
pldatamodule = iattr('pytorch_lightning', 'LightningDataModule', default=list)

odefn, sdefn = iattrs('torchdyn.core.defunc', 'ODEFunc', 'SDEFunc')
neurode, neursde = iattrs('torchdyn.core', 'NeuralODE', 'NeuralSDE', default=ptmodule)
augmenter = iattr('torchdyn.nn', 'Augmenter')

ito = iattr('torchsde', 'SDEIto')
brownian = iattr('torchsde', 'BrownianInterval')
anndata = iattr('anndata', 'AnnData')

gtbase = iattr('graphtools.base', 'Base')
gtdata = iattr('graphtools.base', 'Data', bases=(gtbase, ))
bgraph = iattr('graphtools.base', 'BaseGraph', bases=(gtbase, ))
dgraph = iattr('graphtools.base', 'Data', bases=(gtdata, bgraph))

lgraph, kgraph, tgraph, mgraph = \
    iattrs('graphtools.graphs', 'LandmarkGraph', 'kNNGraph', 'TraditionalGraph', 'MNNGraph', bases=(dgraph, ))

klgraph = iattr('graphtools.graphs', 'kNNLandmarkGraph', bases=(kgraph, lgraph, ))
mlgraph = iattr('graphtools.graphs', 'MNNLandmarkGraph', bases=(mgraph, lgraph, ))
tlgraph = iattr('graphtools.graphs', 'TraditionalLandmarkGraph', bases=(tgraph, lgraph, ))
