"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroApps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const MicroAppsAPIGwy_1 = require("./MicroAppsAPIGwy");
const MicroAppsCF_1 = require("./MicroAppsCF");
const MicroAppsEdgeToOrigin_1 = require("./MicroAppsEdgeToOrigin");
const MicroAppsS3_1 = require("./MicroAppsS3");
const MicroAppsSvcs_1 = require("./MicroAppsSvcs");
const ReverseDomain_1 = require("./utils/ReverseDomain");
/**
 * Create a new MicroApps "turnkey" construct for simple
 * deployments and for initial evaulation of the MicroApps framework.
 *
 * Use this construct to create a PoC working entire stack.
 *
 * Do not use this construct when adding MicroApps to an existing
 * CloudFront, API Gateway, S3 Bucket, etc. or where access
 * to all features of the AWS Resources are needed (e.g. to
 * add additional Behaviors to the CloudFront distribution, set authorizors
 * on API Gateway, etc.).
 *
 * @warning This construct is not intended for production use.
 * In a production stack the DynamoDB Table, API Gateway, S3 Buckets,
 * etc. should be created in a "durable" stack where the IDs will not
 * change and where changes to the MicroApps construct will not
 * cause failures to deploy or data to be deleted.
 *
 *  @see {@link https://github.com/pwrdrvr/microapps-core/blob/main/packages/cdk/lib/MicroApps.ts | example usage in a CDK Stack }
 */
class MicroApps extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { domainNameEdge, domainNameOrigin, assetNameRoot, assetNameSuffix, r53Zone, certEdge, appEnv = 'dev', certOrigin, removalPolicy, s3PolicyBypassAROAs, s3PolicyBypassPrincipalARNs, s3StrictBucketPolicy, rootPathPrefix, createAPIPathRoute = true, addXForwardedHostHeader = true, replaceHostHeader = true, signingMode = 'sign', originRegion, table, tableNameForEdgeToOrigin, } = props;
        this._s3 = new MicroAppsS3_1.MicroAppsS3(this, 's3', {
            removalPolicy,
            bucketLogsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-logs` : undefined,
            bucketAppsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}` : undefined,
            bucketAppsStagingName: domainNameEdge
                ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-staging`
                : undefined,
            assetNameRoot,
            assetNameSuffix,
        });
        this._apigwy = new MicroAppsAPIGwy_1.MicroAppsAPIGwy(this, 'api', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            r53Zone,
            certOrigin,
            rootPathPrefix,
            requireIAMAuthorization: signingMode !== 'none',
        });
        this._svcs = new MicroAppsSvcs_1.MicroAppsSvcs(this, 'svcs', {
            httpApi: this.apigwy.httpApi,
            removalPolicy,
            bucketApps: this._s3.bucketApps,
            bucketAppsOAI: this._s3.bucketAppsOAI,
            bucketAppsStaging: this._s3.bucketAppsStaging,
            assetNameRoot,
            assetNameSuffix,
            appEnv,
            s3PolicyBypassAROAs,
            s3PolicyBypassPrincipalARNs,
            s3StrictBucketPolicy,
            rootPathPrefix,
            requireIAMAuthorization: signingMode !== 'none',
            table,
        });
        if (signingMode !== 'none' || replaceHostHeader || addXForwardedHostHeader) {
            this._edgeToOrigin = new MicroAppsEdgeToOrigin_1.MicroAppsEdgeToOrigin(this, 'edgeToOrigin', {
                assetNameRoot,
                assetNameSuffix,
                removalPolicy,
                addXForwardedHostHeader,
                replaceHostHeader,
                originRegion,
                signingMode,
                rootPathPrefix,
                tableRulesArn: tableNameForEdgeToOrigin || this._svcs.table.tableName,
            });
        }
        this._cf = new MicroAppsCF_1.MicroAppsCF(this, 'cft', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            httpApi: this._apigwy.httpApi,
            r53Zone,
            certEdge,
            bucketAppsOrigin: this._s3.bucketAppsOrigin,
            bucketLogs: this._s3.bucketLogs,
            rootPathPrefix,
            createAPIPathRoute,
            edgeToOriginLambdas: this._edgeToOrigin ? this._edgeToOrigin.edgeToOriginLambdas : undefined,
        });
    }
    get cf() {
        return this._cf;
    }
    get edgeToOrigin() {
        return this._edgeToOrigin;
    }
    get s3() {
        return this._s3;
    }
    get apigwy() {
        return this._apigwy;
    }
    get svcs() {
        return this._svcs;
    }
}
exports.MicroApps = MicroApps;
_a = JSII_RTTI_SYMBOL_1;
MicroApps[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroApps", version: "0.3.2-alpha.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTWljcm9BcHBzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL01pY3JvQXBwcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBLDJDQUF1QztBQUN2Qyx1REFBc0U7QUFDdEUsK0NBQTBEO0FBQzFELG1FQUF3RjtBQUN4RiwrQ0FBMEQ7QUFDMUQsbURBQWdFO0FBQ2hFLHlEQUFzRDtBQStRdEQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FtQkc7QUFDSCxNQUFhLFNBQVUsU0FBUSxzQkFBUztJQTBCdEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM5RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixNQUFNLElBQUksS0FBSyxDQUFDLG1CQUFtQixDQUFDLENBQUM7U0FDdEM7UUFFRCxNQUFNLEVBQ0osY0FBYyxFQUNkLGdCQUFnQixFQUNoQixhQUFhLEVBQ2IsZUFBZSxFQUNmLE9BQU8sRUFDUCxRQUFRLEVBQ1IsTUFBTSxHQUFHLEtBQUssRUFDZCxVQUFVLEVBQ1YsYUFBYSxFQUNiLG1CQUFtQixFQUNuQiwyQkFBMkIsRUFDM0Isb0JBQW9CLEVBQ3BCLGNBQWMsRUFDZCxrQkFBa0IsR0FBRyxJQUFJLEVBQ3pCLHVCQUF1QixHQUFHLElBQUksRUFDOUIsaUJBQWlCLEdBQUcsSUFBSSxFQUN4QixXQUFXLEdBQUcsTUFBTSxFQUNwQixZQUFZLEVBQ1osS0FBSyxFQUNMLHdCQUF3QixHQUN6QixHQUFHLEtBQUssQ0FBQztRQUVWLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSx5QkFBVyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUU7WUFDckMsYUFBYTtZQUNiLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQyxDQUFDLEdBQUcsNkJBQWEsQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3BGLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQyxDQUFDLEdBQUcsNkJBQWEsQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQy9FLHFCQUFxQixFQUFFLGNBQWM7Z0JBQ25DLENBQUMsQ0FBQyxHQUFHLDZCQUFhLENBQUMsY0FBYyxDQUFDLFVBQVU7Z0JBQzVDLENBQUMsQ0FBQyxTQUFTO1lBQ2IsYUFBYTtZQUNiLGVBQWU7U0FDaEIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLGlDQUFlLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRTtZQUM5QyxhQUFhO1lBQ2IsYUFBYTtZQUNiLGVBQWU7WUFDZixjQUFjO1lBQ2QsZ0JBQWdCO1lBQ2hCLE9BQU87WUFDUCxVQUFVO1lBQ1YsY0FBYztZQUNkLHVCQUF1QixFQUFFLFdBQVcsS0FBSyxNQUFNO1NBQ2hELENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSw2QkFBYSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDM0MsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTztZQUM1QixhQUFhO1lBQ2IsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVTtZQUMvQixhQUFhLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxhQUFhO1lBQ3JDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsaUJBQWlCO1lBQzdDLGFBQWE7WUFDYixlQUFlO1lBQ2YsTUFBTTtZQUNOLG1CQUFtQjtZQUNuQiwyQkFBMkI7WUFDM0Isb0JBQW9CO1lBQ3BCLGNBQWM7WUFDZCx1QkFBdUIsRUFBRSxXQUFXLEtBQUssTUFBTTtZQUMvQyxLQUFLO1NBQ04sQ0FBQyxDQUFDO1FBQ0gsSUFBSSxXQUFXLEtBQUssTUFBTSxJQUFJLGlCQUFpQixJQUFJLHVCQUF1QixFQUFFO1lBQzFFLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSw2Q0FBcUIsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO2dCQUNuRSxhQUFhO2dCQUNiLGVBQWU7Z0JBQ2YsYUFBYTtnQkFDYix1QkFBdUI7Z0JBQ3ZCLGlCQUFpQjtnQkFDakIsWUFBWTtnQkFDWixXQUFXO2dCQUNYLGNBQWM7Z0JBQ2QsYUFBYSxFQUFFLHdCQUF3QixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLFNBQVM7YUFDdEUsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxJQUFJLENBQUMsR0FBRyxHQUFHLElBQUkseUJBQVcsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO1lBQ3RDLGFBQWE7WUFDYixhQUFhO1lBQ2IsZUFBZTtZQUNmLGNBQWM7WUFDZCxnQkFBZ0I7WUFDaEIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTztZQUM3QixPQUFPO1lBQ1AsUUFBUTtZQUNSLGdCQUFnQixFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsZ0JBQWdCO1lBQzNDLFVBQVUsRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVU7WUFDL0IsY0FBYztZQUNkLGtCQUFrQjtZQUNsQixtQkFBbUIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTO1NBQzdGLENBQUMsQ0FBQztJQUNMLENBQUM7SUF2SEQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDO0lBQ2xCLENBQUM7SUFHRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFHRCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUdELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBR0QsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7O0FBeEJILDhCQTBIQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFJlbW92YWxQb2xpY3kgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgKiBhcyBhY20gZnJvbSAnYXdzLWNkay1saWIvYXdzLWNlcnRpZmljYXRlbWFuYWdlcic7XG5pbXBvcnQgKiBhcyBkeW5hbW9kYiBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZHluYW1vZGInO1xuaW1wb3J0ICogYXMgcjUzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1yb3V0ZTUzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSU1pY3JvQXBwc0FQSUd3eSwgTWljcm9BcHBzQVBJR3d5IH0gZnJvbSAnLi9NaWNyb0FwcHNBUElHd3knO1xuaW1wb3J0IHsgSU1pY3JvQXBwc0NGLCBNaWNyb0FwcHNDRiB9IGZyb20gJy4vTWljcm9BcHBzQ0YnO1xuaW1wb3J0IHsgSU1pY3JvQXBwc0VkZ2VUb09yaWdpbiwgTWljcm9BcHBzRWRnZVRvT3JpZ2luIH0gZnJvbSAnLi9NaWNyb0FwcHNFZGdlVG9PcmlnaW4nO1xuaW1wb3J0IHsgSU1pY3JvQXBwc1MzLCBNaWNyb0FwcHNTMyB9IGZyb20gJy4vTWljcm9BcHBzUzMnO1xuaW1wb3J0IHsgSU1pY3JvQXBwc1N2Y3MsIE1pY3JvQXBwc1N2Y3MgfSBmcm9tICcuL01pY3JvQXBwc1N2Y3MnO1xuaW1wb3J0IHsgcmV2ZXJzZURvbWFpbiB9IGZyb20gJy4vdXRpbHMvUmV2ZXJzZURvbWFpbic7XG5cbi8qKlxuICogQSBDREsgQ29uc3RydWN0IGZvciBjcmVhdGluZyBhIE1pY3JvQXBwcyBydW50aW1lIGVudmlyb25tZW50IHVzZWRcbiAqIHRvIGhvc3QgTmV4dC5qcywgUmVhY3QsIG9yIGFueSBvdGhlciBzb3J0IG9mIHdlYiBhcHBsaWNhdGlvbiB3aXRoXG4gKiBtdWx0aXBsZSB2ZXJzaW9ucyBhdmFpbGFibGUgZm9yIGNvbXBhcmlzb24sIHF1aWNrIHJvbGxiYWNrcywgcXVpY2tcbiAqIHJlbGVhc2VzLCBhbmQgYSBjb21wbGV0ZSBsYWNrIG9mIHVzZXIgZGlzdHVyYmFuY2Ugb24gZGVwbG95cy5cbiAqXG4gKiBAcmVtYXJrc1xuICpcbiAqIHtAbGluayBNaWNyb0FwcHN9IHByb3ZpZGVzIGEgdHVybi1rZXkgY29uc3RydWN0IHRoYXQgY3JlYXRlcyBhbGxcbiAqIGRlcGVuZGVuY2llcyB3aXRoIGxpbWl0ZWQgZXhwb3N1cmUgb2YgdW5kZXJseWluZyBBV1MgUmVzb3VyY2Ugb3B0aW9ucy5cbiAqIFRoaXMgY29uc3RydWN0IGlzIHRoZSBlYXNpZXN0IHRvIHVzZSB3aGVuIGV4cGxvcmluZyBNaWNyb0FwcHMgZm9yIHRoZVxuICogZmlyc3QgdGltZS5cbiAqXG4gKiB7QGxpbmsgTWljcm9BcHBzQVBJR3d5fSwge0BsaW5rIE1pY3JvQXBwc0NGfSwge0BsaW5rIE1pY3JvQXBwc1MzfSxcbiAqIGFuZCB7QGxpbmsgTWljcm9BcHBzU3Zjc30sIGFuZCB0aGVpciBoZWxwZXIgc3RhdGljIG1ldGhvZHMsIGNhbiBiZSB1c2VkXG4gKiB0byBjcmVhdGUgQVdTIFJlc291cmNlcyBtb3JlIGRpcmVjdGx5LCB0byBwcm92aWRlIHlvdXIgb3duIEFXUyBSZXNvdXJjZXNcbiAqIChlLmcuIGFuIGV4aXN0aW5nIENsb3VkRnJvbnQgRGlzdHJpYnV0aW9uKSwgYW5kIHRvIGhhdmUgbW9yZSBmbGV4aWJpbGl0eVxuICogdGhhbiB0aGUge0BsaW5rIE1pY3JvQXBwc30gY29uc3RydWN0IG9mZmVycy5cbiAqXG4gKiBAcGFja2FnZURvY3VtZW50YXRpb25cbiAqL1xuXG4vKipcbiAqIFByb3BlcnRpZXMgdG8gaW5pdGlhbGl6ZSBhbiBpbnN0YW5jZSBvZiBgTWljcm9BcHBzYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNaWNyb0FwcHNQcm9wcyB7XG4gIC8qKlxuICAgKiBSZW1vdmFsUG9saWN5IG92ZXJyaWRlIGZvciBjaGlsZCByZXNvdXJjZXNcbiAgICpcbiAgICogTm90ZTogaWYgc2V0IHRvIERFU1RST1kgdGhlIFMzIGJ1Y2tlcyB3aWxsIGhhdmUgYGF1dG9EZWxldGVPYmplY3RzYCBzZXQgdG8gYHRydWVgXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gcGVyIHJlc291cmNlIGRlZmF1bHRcbiAgICovXG4gIHJlYWRvbmx5IHJlbW92YWxQb2xpY3k/OiBSZW1vdmFsUG9saWN5O1xuXG4gIC8qKlxuICAgKiBQYXNzZWQgdG8gTk9ERV9FTlYgb2YgUm91dGVyIGFuZCBEZXBsb3llciBMYW1iZGEgZnVuY3Rpb25zLlxuICAgKlxuICAgKiBAZGVmYXVsdCBkZXZcbiAgICovXG4gIHJlYWRvbmx5IGFwcEVudjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBPcHRpb25hbCBhc3NldCBuYW1lIHJvb3RcbiAgICpcbiAgICogQGV4YW1wbGUgbWljcm9hcHBzXG4gICAqIEBkZWZhdWx0IC0gcmVzb3VyY2UgbmFtZXMgYXV0byBhc3NpZ25lZFxuICAgKi9cbiAgcmVhZG9ubHkgYXNzZXROYW1lUm9vdD86IHN0cmluZztcblxuICAvKipcbiAgICogT3B0aW9uYWwgYXNzZXQgbmFtZSBzdWZmaXhcbiAgICpcbiAgICogQGV4YW1wbGUgLWRldi1wci0xMlxuICAgKiBAZGVmYXVsdCBub25lXG4gICAqL1xuICByZWFkb25seSBhc3NldE5hbWVTdWZmaXg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFJvdXRlNTMgem9uZSBpbiB3aGljaCB0byBjcmVhdGUgb3B0aW9uYWwgYGRvbWFpbk5hbWVFZGdlYCByZWNvcmRcbiAgICovXG4gIHJlYWRvbmx5IHI1M1pvbmU/OiByNTMuSUhvc3RlZFpvbmU7XG5cbiAgLyoqXG4gICAqIENlcnRpZmljYXRlIGluIFVTLUVhc3QtMSBmb3IgdGhlIENsb3VkRnJvbnQgZGlzdHJpYnV0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgY2VydEVkZ2U/OiBhY20uSUNlcnRpZmljYXRlO1xuXG4gIC8qKlxuICAgKiBDZXJ0aWZpY2F0ZSBpbiBkZXBsb3llZCByZWdpb24gZm9yIHRoZSBBUEkgR2F0ZXdheS5cbiAgICovXG4gIHJlYWRvbmx5IGNlcnRPcmlnaW4/OiBhY20uSUNlcnRpZmljYXRlO1xuXG4gIC8qKlxuICAgKiBVc2UgYSBzdHJpY3QgUzMgQnVja2V0IFBvbGljeSB0aGF0IHByZXZlbnRzIGFwcGxpY2F0aW9uc1xuICAgKiBmcm9tIHJlYWRpbmcvd3JpdGluZy9tb2RpZnlpbmcvZGVsZXRpbmcgZmlsZXMgaW4gdGhlIFMzIEJ1Y2tldFxuICAgKiBvdXRzaWRlIG9mIHRoZSBwYXRoIHRoYXQgaXMgc3BlY2lmaWMgdG8gdGhlaXIgYXBwL3ZlcnNpb24uXG4gICAqXG4gICAqIFRoaXMgc2V0dGluZyBzaG91bGQgYmUgdXNlZCB3aGVuIGFwcGxpY2F0aW9ucyBhcmUgbGVzcyB0aGFuXG4gICAqIGZ1bGx5IHRydXN0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBzM1N0cmljdEJ1Y2tldFBvbGljeT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEFwcGxpZXMgd2hlbiB1c2luZyBzM1N0cmljdEJ1Y2tldFBvbGljeSA9IHRydWVcbiAgICpcbiAgICogSUFNIFJvbGUgb3IgSUFNIFVzZXIgbmFtZXMgdG8gZXhjbHVkZSBmcm9tIHRoZSBERU5ZIHJ1bGVzIG9uIHRoZSBTMyBCdWNrZXQgUG9saWN5LlxuICAgKlxuICAgKiBSb2xlcyB0aGF0IGFyZSBBc3N1bWVkIG11c3QgaW5zdGVhZCBoYXZlIHRoZWlyIEFST0EgYWRkZWQgdG8gYHMzUG9saWN5QnlwYXNzQVJPQXNgLlxuICAgKlxuICAgKiBUeXBpY2FsbHkgYW55IGFkbWluIHJvbGVzIC8gdXNlcnMgdGhhdCBuZWVkIHRvIHZpZXcgb3IgbWFuYWdlIHRoZSBTMyBCdWNrZXRcbiAgICogd291bGQgYmUgYWRkZWQgdG8gdGhpcyBsaXN0LlxuICAgKlxuICAgKiBAZXhhbXBsZSBbJ2Fybjphd3M6aWFtOjoxMjM0NTY3ODkwMTIzOnJvbGUvQWRtaW5BY2Nlc3MnLCAnYXJuOmF3czppYW06OjEyMzQ1Njc4OTAxMjM6dXNlci9NeUFkbWluVXNlciddXG4gICAqXG4gICAqIEBzZWUgczNQb2xpY3lCeXBhc3NBUk9Bc1xuICAgKi9cbiAgcmVhZG9ubHkgczNQb2xpY3lCeXBhc3NQcmluY2lwYWxBUk5zPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEFwcGxpZXMgd2hlbiB1c2luZyBzM1N0cmljdEJ1Y2tldFBvbGljeSA9IHRydWVcbiAgICpcbiAgICogQVJPQXMgb2YgdGhlIElBTSBSb2xlIHRvIGV4Y2x1ZGUgZnJvbSB0aGUgREVOWSBydWxlcyBvbiB0aGUgUzMgQnVja2V0IFBvbGljeS5cbiAgICogVGhpcyBhbGxvd3Mgc2Vzc2lvbnMgdGhhdCBhc3N1bWUgdGhlIElBTSBSb2xlIHRvIGJlIGV4Y2x1ZGVkIGZyb20gdGhlXG4gICAqIERFTlkgcnVsZXMgb24gdGhlIFMzIEJ1Y2tldCBQb2xpY3kuXG4gICAqXG4gICAqIFR5cGljYWxseSBhbnkgYWRtaW4gcm9sZXMgLyB1c2VycyB0aGF0IG5lZWQgdG8gdmlldyBvciBtYW5hZ2UgdGhlIFMzIEJ1Y2tldFxuICAgKiB3b3VsZCBiZSBhZGRlZCB0byB0aGlzIGxpc3QuXG4gICAqXG4gICAqIFJvbGVzIC8gdXNlcnMgdGhhdCBhcmUgdXNlZCBkaXJlY3RseSwgbm90IGFzc3VtZWQsIGNhbiBiZSBhZGRlZCB0byBgczNQb2xpY3lCeXBhc3NSb2xlTmFtZXNgIGluc3RlYWQuXG4gICAqXG4gICAqIE5vdGU6IFRoaXMgQVJPQSBtdXN0IGJlIHNwZWNpZmllZCB0byBwcmV2ZW50IHRoaXMgcG9saWN5IGZyb20gbG9ja2luZ1xuICAgKiBvdXQgbm9uLXJvb3Qgc2Vzc2lvbnMgdGhhdCBoYXZlIGFzc3VtZWQgdGhlIGFkbWluIHJvbGUuXG4gICAqXG4gICAqIFRoZSBub3RQcmluY2lwYWxzIHdpbGwgb25seSBtYXRjaCB0aGUgcm9sZSBuYW1lIGV4YWN0bHkgYW5kIHdpbGwgbm90IG1hdGNoXG4gICAqIGFueSBzZXNzaW9uIHRoYXQgaGFzIGFzc3VtZWQgdGhlIHJvbGUgc2luY2Ugbm90UHJpbmNpcGFscyBkb2VzIG5vdCBhbGxvd1xuICAgKiB3aWxkY2FyZCBtYXRjaGVzIGFuZCBkb2VzIG5vdCBkbyB3aWxkY2FyZCBtYXRjaGVzIGltcGxpY2l0bHkgZWl0aGVyLlxuICAgKlxuICAgKiBUaGUgQVJPQSBtdXN0IGJlIHVzZWQgYmVjYXVzZSB0aGVyZSBhcmUgb25seSAzIFByaW5jaXBhbCB2YXJpYWJsZXMgYXZhaWxhYmxlOlxuICAgKiAgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc192YXJpYWJsZXMuaHRtbCNwcmluY2lwYWx0YWJsZVxuICAgKiAgYXdzOnVzZXJuYW1lLCBhd3M6dXNlcmlkLCBhd3M6UHJpbmNpcGFsVGFnXG4gICAqXG4gICAqIEZvciBhbiBhc3N1bWVkIHJvbGUsIGF3czp1c2VybmFtZSBpcyBibGFuaywgYXdzOnVzZXJpZCBpczpcbiAgICogIFt1bmlxdWUgaWQgQUtBIEFST0EgZm9yIFJvbGVdOltzZXNzaW9uIG5hbWVdXG4gICAqXG4gICAqIFRhYmxlIG9mIHVuaXF1ZSBJRCBwcmVmaXhlcyBzdWNoIGFzIEFST0E6XG4gICAqICBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX2lkZW50aWZpZXJzLmh0bWwjaWRlbnRpZmllcnMtcHJlZml4ZXNcbiAgICpcbiAgICogVGhlIG5hbWUgb2YgdGhlIHJvbGUgaXMgc2ltcGx5IG5vdCBhdmFpbGFibGUgZm9yIGFuIGFzc3VtZWQgcm9sZSBhbmQsIGlmIGl0IHdhcyxcbiAgICogYSBjb21wbGljYXRlZCBjb21wYXJpc29uIHdvdWxkIGJlIHJlcXVpZXJkIHRvIHByZXZlbnQgZXhjbHVzaW9uXG4gICAqIG9mIGFwcGx5aW5nIHRoZSBEZW55IFJ1bGUgdG8gcm9sZXMgZnJvbSBvdGhlciBhY2NvdW50cy5cbiAgICpcbiAgICogVG8gZ2V0IHRoZSBBUk9BIHdpdGggdGhlIEFXUyBDTEk6XG4gICAqICAgYXdzIGlhbSBnZXQtcm9sZSAtLXJvbGUtbmFtZSBST0xFLU5BTUVcbiAgICogICBhd3MgaWFtIGdldC11c2VyIC3igJN1c2VyLW5hbWUgVVNFUi1OQU1FXG4gICAqXG4gICAqIEBleGFtcGxlIFsgJ0FST0ExMjM0NTY3ODkwMTIzJyBdXG4gICAqXG4gICAqIEBzZWUgczNTdHJpY3RCdWNrZXRQb2xpY3lcbiAgICovXG4gIHJlYWRvbmx5IHMzUG9saWN5QnlwYXNzQVJPQXM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogT3B0aW9uYWwgY3VzdG9tIGRvbWFpbiBuYW1lIGZvciB0aGUgQ2xvdWRGcm9udCBkaXN0cmlidXRpb24uXG4gICAqXG4gICAqIEBleGFtcGxlIGFwcHMucHdyZHJ2ci5jb21cbiAgICogQGRlZmF1bHQgYXV0by1hc3NpZ25lZFxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZUVkZ2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIGN1c3RvbSBkb21haW4gbmFtZSBmb3IgdGhlIEFQSSBHYXRld2F5IEhUVFB2MiBBUEkuXG4gICAqXG4gICAqIEBleGFtcGxlIGFwcHMtb3JpZ2luLnB3cmRydnIuY29tXG4gICAqIEBkZWZhdWx0IGF1dG8tYXNzaWduZWRcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbk5hbWVPcmlnaW4/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFBhdGggcHJlZml4IG9uIHRoZSByb290IG9mIHRoZSBDbG91ZEZyb250IGRpc3RyaWJ1dGlvblxuICAgKlxuICAgKiBAZXhhbXBsZSBkZXYvXG4gICAqL1xuICByZWFkb25seSByb290UGF0aFByZWZpeD86IHN0cmluZztcblxuICAvKipcbiAgICogQ3JlYXRlIGFuIGV4dHJhIEJlaGF2aW9yIChSb3V0ZSkgZm9yIC9hcGkvIHRoYXQgYWxsb3dzXG4gICAqIEFQSSByb3V0ZXMgdG8gaGF2ZSBhIHBlcmlvZCBpbiB0aGVtLlxuICAgKlxuICAgKiBXaGVuIGZhbHNlIEFQSSByb3V0ZXMgd2l0aCBhIHBlcmlvZCBpbiB0aGUgcGF0aCB3aWxsIGdldCByb3V0ZWQgdG8gUzMuXG4gICAqXG4gICAqIFdoZW4gdHJ1ZSBBUEkgcm91dGVzIHRoYXQgY29udGFpbiAvYXBpLyBpbiB0aGUgcGF0aCB3aWxsIGdldCByb3V0ZWQgdG8gQVBJIEdhdGV3YXlcbiAgICogZXZlbiBpZiB0aGV5IGhhdmUgYSBwZXJpb2QgaW4gdGhlIHBhdGguXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGNyZWF0ZUFQSVBhdGhSb3V0ZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEFkZHMgYW4gWC1Gb3J3YXJkZWQtSG9zdC1IZWFkZXIgd2hlbiBjYWxsaW5nIEFQSSBHYXRld2F5XG4gICAqXG4gICAqIENhbiBvbmx5IGJlIHRydXN0ZWQgaWYgYHNpZ25pbmdNb2RlYCBpcyBlbmFibGVkLCB3aGljaCByZXN0cmljdHNcbiAgICogYWNjZXNzIHRvIEFQSSBHYXRld2F5IHRvIG9ubHkgSUFNIHNpZ25lZCByZXF1ZXN0cy5cbiAgICpcbiAgICogTm90ZTogaWYgdHJ1ZSwgY3JlYXRlcyBPcmlnaW5SZXF1ZXN0IExhbWJkYSBAIEVkZ2UgZnVuY3Rpb24gZm9yIEFQSSBHYXRld2F5IE9yaWdpblxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBhZGRYRm9yd2FyZGVkSG9zdEhlYWRlcj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFJlcGxhY2VzIEhvc3QgaGVhZGVyICh3aGljaCB3aWxsIGJlIHRoZSBFZGdlIGRvbWFpbiBuYW1lKSB3aXRoIHRoZSBPcmlnaW4gZG9tYWluIG5hbWVcbiAgICogd2hlbiBlbmFibGVkLiAgVGhpcyBpcyBuZWNlc3Nhcnkgd2hlbiBBUEkgR2F0ZXdheSBoYXMgbm90IGJlZW4gY29uZmlndXJlZFxuICAgKiB3aXRoIGEgY3VzdG9tIGRvbWFpbiBuYW1lIHRoYXQgbWF0Y2hlcyB0aGUgZXhhY3QgZG9tYWluIG5hbWUgdXNlZCBieSB0aGUgQ2xvdWRGcm9udFxuICAgKiBEaXN0cmlidXRpb24gQU5EIHdoZW4gdGhlIE9yaWdpblJlcXVlc3RQb2xpY3kuSGVhZGVyc0JlaGF2aW9yIGlzIHNldFxuICAgKiB0byBwYXNzIGFsbCBoZWFkZXJzIHRvIHRoZSBvcmlnaW4uXG4gICAqXG4gICAqIE5vdGU6IGlmIHRydWUsIGNyZWF0ZXMgT3JpZ2luUmVxdWVzdCBMYW1iZGEgQCBFZGdlIGZ1bmN0aW9uIGZvciBBUEkgR2F0ZXdheSBPcmlnaW5cbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVwbGFjZUhvc3RIZWFkZXI/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBSZXF1aXJlcyBJQU0gYXV0aCBvbiB0aGUgQVBJIEdhdGV3YXkgb3JpZ2luIGlmIG5vdCBzZXQgdG8gJ25vbmUnLlxuICAgKlxuICAgKiAnc2lnbicgLSBVc2VzIHJlcXVlc3QgaGVhZGVycyBmb3IgYXV0aC5cbiAgICogJ3ByZXNpZ24nIC0gVXNlcyBxdWVyeSBzdHJpbmcgZm9yIGF1dGguXG4gICAqXG4gICAqIElmIGVuYWJsZWQsXG4gICAqXG4gICAqIE5vdGU6IGlmICdzaWduJyBvciAncHJlc2lnbicsIGNyZWF0ZXMgT3JpZ2luUmVxdWVzdCBMYW1iZGEgQCBFZGdlIGZ1bmN0aW9uIGZvciBBUEkgR2F0ZXdheSBPcmlnaW5cbiAgICogQGRlZmF1bHQgJ3NpZ24nXG4gICAqL1xuICByZWFkb25seSBzaWduaW5nTW9kZT86ICdzaWduJyB8ICdwcmVzaWduJyB8ICdub25lJztcblxuICAvKipcbiAgICogT3JpZ2luIHJlZ2lvbiB0aGF0IEFQSSBHYXRld2F5IHdpbGwgYmUgZGVwbG95ZWQgdG8sIHVzZWRcbiAgICogZm9yIHRoZSBjb25maWcueW1sIG9uIHRoZSBFZGdlIGZ1bmN0aW9uIHRvIHNpZ24gcmVxdWVzdHMgZm9yXG4gICAqIHRoZSBjb3JyZWN0IHJlZ2lvblxuICAgKlxuICAgKiBAZGVmYXVsdCB1bmRlZmluZWRcbiAgICovXG4gIHJlYWRvbmx5IG9yaWdpblJlZ2lvbj86IHN0cmluZztcblxuICAvKipcbiAgICogRXhpc3RpbmcgdGFibGUgZm9yIGFwcHMvdmVyc2lvbnMvcnVsZXNcbiAgICpcbiAgICogQHdhcm5pbmcgLSBJdCBpcyAqc3Ryb25nbHkqIHN1Z2dlc3RlZCB0aGF0IHByb2R1Y3Rpb24gc3RhY2tzIGNyZWF0ZVxuICAgKiB0aGVpciBvd24gRHluYW1vREIgVGFibGUgYW5kIHBhc3MgaXQgaW50byB0aGlzIGNvbnN0cnVjdCwgZm9yIHByb3RlY3Rpb25cbiAgICogYWdhaW5zdCBkYXRhIGxvc3MgZHVlIHRvIGxvZ2ljYWwgSUQgY2hhbmdlcywgdGhlIGFiaWxpdHkgdG8gY29uZmlndXJlXG4gICAqIFByb3Zpc2lvbmVkIGNhcGFjaXR5IHdpdGggQXV0byBTY2FsaW5nLCB0aGUgYWJpbGl0eSB0byBhZGQgYWRkaXRpb25hbCBpbmRpY2VzLCBldGMuXG4gICAqXG4gICAqIFJlcXVpcmVtZW50czpcbiAgICogLSBIYXNoIEtleTogYFBLYFxuICAgKiAtIFNvcnQgS2V5OiBgU0tgXG4gICAqXG4gICAqIEBkZWZhdWx0IGNyZWF0ZWQgYnkgY29uc3RydWN0XG4gICAqL1xuICByZWFkb25seSB0YWJsZT86IGR5bmFtb2RiLklUYWJsZTtcblxuICAvKipcbiAgICogUHJlLXNldCB0YWJsZSBuYW1lIGZvciBhcHBzL3ZlcnNpb25zL3J1bGVzXG4gICAqXG4gICAqIFRoaXMgaXMgcmVxdWlyZWQgd2hlbiB1c2luZyB2MiByb3V0aW5nXG4gICAqL1xuICByZWFkb25seSB0YWJsZU5hbWVGb3JFZGdlVG9PcmlnaW4/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIE1pY3JvQXBwc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIElNaWNyb0FwcHMge1xuICAvKioge0Bpbmhlcml0ZG9jIElNaWNyb0FwcHNDRn0gKi9cbiAgcmVhZG9ubHkgY2Y6IElNaWNyb0FwcHNDRjtcblxuICAvKioge0Bpbmhlcml0ZG9jIElNaWNyb0FwcHNFZGdlVG9PcmlnaW59ICovXG4gIHJlYWRvbmx5IGVkZ2VUb09yaWdpbj86IElNaWNyb0FwcHNFZGdlVG9PcmlnaW47XG5cbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzUzN9ICovXG4gIHJlYWRvbmx5IHMzOiBJTWljcm9BcHBzUzM7XG5cbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzU3Zjc30gKi9cbiAgcmVhZG9ubHkgc3ZjczogSU1pY3JvQXBwc1N2Y3M7XG5cbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzQVBJR3d5fSAqL1xuICByZWFkb25seSBhcGlnd3k6IElNaWNyb0FwcHNBUElHd3k7XG59XG5cbi8qKlxuICogQ3JlYXRlIGEgbmV3IE1pY3JvQXBwcyBcInR1cm5rZXlcIiBjb25zdHJ1Y3QgZm9yIHNpbXBsZVxuICogZGVwbG95bWVudHMgYW5kIGZvciBpbml0aWFsIGV2YXVsYXRpb24gb2YgdGhlIE1pY3JvQXBwcyBmcmFtZXdvcmsuXG4gKlxuICogVXNlIHRoaXMgY29uc3RydWN0IHRvIGNyZWF0ZSBhIFBvQyB3b3JraW5nIGVudGlyZSBzdGFjay5cbiAqXG4gKiBEbyBub3QgdXNlIHRoaXMgY29uc3RydWN0IHdoZW4gYWRkaW5nIE1pY3JvQXBwcyB0byBhbiBleGlzdGluZ1xuICogQ2xvdWRGcm9udCwgQVBJIEdhdGV3YXksIFMzIEJ1Y2tldCwgZXRjLiBvciB3aGVyZSBhY2Nlc3NcbiAqIHRvIGFsbCBmZWF0dXJlcyBvZiB0aGUgQVdTIFJlc291cmNlcyBhcmUgbmVlZGVkIChlLmcuIHRvXG4gKiBhZGQgYWRkaXRpb25hbCBCZWhhdmlvcnMgdG8gdGhlIENsb3VkRnJvbnQgZGlzdHJpYnV0aW9uLCBzZXQgYXV0aG9yaXpvcnNcbiAqIG9uIEFQSSBHYXRld2F5LCBldGMuKS5cbiAqXG4gKiBAd2FybmluZyBUaGlzIGNvbnN0cnVjdCBpcyBub3QgaW50ZW5kZWQgZm9yIHByb2R1Y3Rpb24gdXNlLlxuICogSW4gYSBwcm9kdWN0aW9uIHN0YWNrIHRoZSBEeW5hbW9EQiBUYWJsZSwgQVBJIEdhdGV3YXksIFMzIEJ1Y2tldHMsXG4gKiBldGMuIHNob3VsZCBiZSBjcmVhdGVkIGluIGEgXCJkdXJhYmxlXCIgc3RhY2sgd2hlcmUgdGhlIElEcyB3aWxsIG5vdFxuICogY2hhbmdlIGFuZCB3aGVyZSBjaGFuZ2VzIHRvIHRoZSBNaWNyb0FwcHMgY29uc3RydWN0IHdpbGwgbm90XG4gKiBjYXVzZSBmYWlsdXJlcyB0byBkZXBsb3kgb3IgZGF0YSB0byBiZSBkZWxldGVkLlxuICpcbiAqICBAc2VlIHtAbGluayBodHRwczovL2dpdGh1Yi5jb20vcHdyZHJ2ci9taWNyb2FwcHMtY29yZS9ibG9iL21haW4vcGFja2FnZXMvY2RrL2xpYi9NaWNyb0FwcHMudHMgfCBleGFtcGxlIHVzYWdlIGluIGEgQ0RLIFN0YWNrIH1cbiAqL1xuZXhwb3J0IGNsYXNzIE1pY3JvQXBwcyBleHRlbmRzIENvbnN0cnVjdCBpbXBsZW1lbnRzIElNaWNyb0FwcHMge1xuICBwcml2YXRlIF9jZjogTWljcm9BcHBzQ0Y7XG4gIHB1YmxpYyBnZXQgY2YoKTogSU1pY3JvQXBwc0NGIHtcbiAgICByZXR1cm4gdGhpcy5fY2Y7XG4gIH1cblxuICBwcml2YXRlIF9lZGdlVG9PcmlnaW4/OiBNaWNyb0FwcHNFZGdlVG9PcmlnaW47XG4gIHB1YmxpYyBnZXQgZWRnZVRvT3JpZ2luKCk6IElNaWNyb0FwcHNFZGdlVG9PcmlnaW4gfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB0aGlzLl9lZGdlVG9PcmlnaW47XG4gIH1cblxuICBwcml2YXRlIF9zMzogTWljcm9BcHBzUzM7XG4gIHB1YmxpYyBnZXQgczMoKTogSU1pY3JvQXBwc1MzIHtcbiAgICByZXR1cm4gdGhpcy5fczM7XG4gIH1cblxuICBwcml2YXRlIF9hcGlnd3k6IE1pY3JvQXBwc0FQSUd3eTtcbiAgcHVibGljIGdldCBhcGlnd3koKTogSU1pY3JvQXBwc0FQSUd3eSB7XG4gICAgcmV0dXJuIHRoaXMuX2FwaWd3eTtcbiAgfVxuXG4gIHByaXZhdGUgX3N2Y3M6IE1pY3JvQXBwc1N2Y3M7XG4gIHB1YmxpYyBnZXQgc3ZjcygpOiBJTWljcm9BcHBzU3ZjcyB7XG4gICAgcmV0dXJuIHRoaXMuX3N2Y3M7XG4gIH1cblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IE1pY3JvQXBwc1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGlmIChwcm9wcyA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ3Byb3BzIG11c3QgYmUgc2V0Jyk7XG4gICAgfVxuXG4gICAgY29uc3Qge1xuICAgICAgZG9tYWluTmFtZUVkZ2UsXG4gICAgICBkb21haW5OYW1lT3JpZ2luLFxuICAgICAgYXNzZXROYW1lUm9vdCxcbiAgICAgIGFzc2V0TmFtZVN1ZmZpeCxcbiAgICAgIHI1M1pvbmUsXG4gICAgICBjZXJ0RWRnZSxcbiAgICAgIGFwcEVudiA9ICdkZXYnLFxuICAgICAgY2VydE9yaWdpbixcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgICBzM1BvbGljeUJ5cGFzc0FST0FzLFxuICAgICAgczNQb2xpY3lCeXBhc3NQcmluY2lwYWxBUk5zLFxuICAgICAgczNTdHJpY3RCdWNrZXRQb2xpY3ksXG4gICAgICByb290UGF0aFByZWZpeCxcbiAgICAgIGNyZWF0ZUFQSVBhdGhSb3V0ZSA9IHRydWUsXG4gICAgICBhZGRYRm9yd2FyZGVkSG9zdEhlYWRlciA9IHRydWUsXG4gICAgICByZXBsYWNlSG9zdEhlYWRlciA9IHRydWUsXG4gICAgICBzaWduaW5nTW9kZSA9ICdzaWduJyxcbiAgICAgIG9yaWdpblJlZ2lvbixcbiAgICAgIHRhYmxlLFxuICAgICAgdGFibGVOYW1lRm9yRWRnZVRvT3JpZ2luLFxuICAgIH0gPSBwcm9wcztcblxuICAgIHRoaXMuX3MzID0gbmV3IE1pY3JvQXBwc1MzKHRoaXMsICdzMycsIHtcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgICBidWNrZXRMb2dzTmFtZTogZG9tYWluTmFtZUVkZ2UgPyBgJHtyZXZlcnNlRG9tYWluKGRvbWFpbk5hbWVFZGdlKX0tbG9nc2AgOiB1bmRlZmluZWQsXG4gICAgICBidWNrZXRBcHBzTmFtZTogZG9tYWluTmFtZUVkZ2UgPyBgJHtyZXZlcnNlRG9tYWluKGRvbWFpbk5hbWVFZGdlKX1gIDogdW5kZWZpbmVkLFxuICAgICAgYnVja2V0QXBwc1N0YWdpbmdOYW1lOiBkb21haW5OYW1lRWRnZVxuICAgICAgICA/IGAke3JldmVyc2VEb21haW4oZG9tYWluTmFtZUVkZ2UpfS1zdGFnaW5nYFxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICAgIGFzc2V0TmFtZVJvb3QsXG4gICAgICBhc3NldE5hbWVTdWZmaXgsXG4gICAgfSk7XG4gICAgdGhpcy5fYXBpZ3d5ID0gbmV3IE1pY3JvQXBwc0FQSUd3eSh0aGlzLCAnYXBpJywge1xuICAgICAgcmVtb3ZhbFBvbGljeSxcbiAgICAgIGFzc2V0TmFtZVJvb3QsXG4gICAgICBhc3NldE5hbWVTdWZmaXgsXG4gICAgICBkb21haW5OYW1lRWRnZSxcbiAgICAgIGRvbWFpbk5hbWVPcmlnaW4sXG4gICAgICByNTNab25lLFxuICAgICAgY2VydE9yaWdpbixcbiAgICAgIHJvb3RQYXRoUHJlZml4LFxuICAgICAgcmVxdWlyZUlBTUF1dGhvcml6YXRpb246IHNpZ25pbmdNb2RlICE9PSAnbm9uZScsXG4gICAgfSk7XG4gICAgdGhpcy5fc3ZjcyA9IG5ldyBNaWNyb0FwcHNTdmNzKHRoaXMsICdzdmNzJywge1xuICAgICAgaHR0cEFwaTogdGhpcy5hcGlnd3kuaHR0cEFwaSxcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgICBidWNrZXRBcHBzOiB0aGlzLl9zMy5idWNrZXRBcHBzLFxuICAgICAgYnVja2V0QXBwc09BSTogdGhpcy5fczMuYnVja2V0QXBwc09BSSxcbiAgICAgIGJ1Y2tldEFwcHNTdGFnaW5nOiB0aGlzLl9zMy5idWNrZXRBcHBzU3RhZ2luZyxcbiAgICAgIGFzc2V0TmFtZVJvb3QsXG4gICAgICBhc3NldE5hbWVTdWZmaXgsXG4gICAgICBhcHBFbnYsXG4gICAgICBzM1BvbGljeUJ5cGFzc0FST0FzLFxuICAgICAgczNQb2xpY3lCeXBhc3NQcmluY2lwYWxBUk5zLFxuICAgICAgczNTdHJpY3RCdWNrZXRQb2xpY3ksXG4gICAgICByb290UGF0aFByZWZpeCxcbiAgICAgIHJlcXVpcmVJQU1BdXRob3JpemF0aW9uOiBzaWduaW5nTW9kZSAhPT0gJ25vbmUnLFxuICAgICAgdGFibGUsXG4gICAgfSk7XG4gICAgaWYgKHNpZ25pbmdNb2RlICE9PSAnbm9uZScgfHwgcmVwbGFjZUhvc3RIZWFkZXIgfHwgYWRkWEZvcndhcmRlZEhvc3RIZWFkZXIpIHtcbiAgICAgIHRoaXMuX2VkZ2VUb09yaWdpbiA9IG5ldyBNaWNyb0FwcHNFZGdlVG9PcmlnaW4odGhpcywgJ2VkZ2VUb09yaWdpbicsIHtcbiAgICAgICAgYXNzZXROYW1lUm9vdCxcbiAgICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgICByZW1vdmFsUG9saWN5LFxuICAgICAgICBhZGRYRm9yd2FyZGVkSG9zdEhlYWRlcixcbiAgICAgICAgcmVwbGFjZUhvc3RIZWFkZXIsXG4gICAgICAgIG9yaWdpblJlZ2lvbixcbiAgICAgICAgc2lnbmluZ01vZGUsXG4gICAgICAgIHJvb3RQYXRoUHJlZml4LFxuICAgICAgICB0YWJsZVJ1bGVzQXJuOiB0YWJsZU5hbWVGb3JFZGdlVG9PcmlnaW4gfHwgdGhpcy5fc3Zjcy50YWJsZS50YWJsZU5hbWUsXG4gICAgICB9KTtcbiAgICB9XG4gICAgdGhpcy5fY2YgPSBuZXcgTWljcm9BcHBzQ0YodGhpcywgJ2NmdCcsIHtcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgICBhc3NldE5hbWVSb290LFxuICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgZG9tYWluTmFtZUVkZ2UsXG4gICAgICBkb21haW5OYW1lT3JpZ2luLFxuICAgICAgaHR0cEFwaTogdGhpcy5fYXBpZ3d5Lmh0dHBBcGksXG4gICAgICByNTNab25lLFxuICAgICAgY2VydEVkZ2UsXG4gICAgICBidWNrZXRBcHBzT3JpZ2luOiB0aGlzLl9zMy5idWNrZXRBcHBzT3JpZ2luLFxuICAgICAgYnVja2V0TG9nczogdGhpcy5fczMuYnVja2V0TG9ncyxcbiAgICAgIHJvb3RQYXRoUHJlZml4LFxuICAgICAgY3JlYXRlQVBJUGF0aFJvdXRlLFxuICAgICAgZWRnZVRvT3JpZ2luTGFtYmRhczogdGhpcy5fZWRnZVRvT3JpZ2luID8gdGhpcy5fZWRnZVRvT3JpZ2luLmVkZ2VUb09yaWdpbkxhbWJkYXMgOiB1bmRlZmluZWQsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==