# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['renotize']

package_data = \
{'': ['*']}

install_requires = \
['arrow>=0.15.6,<0.16.0',
 'click>=7.1.2,<8.0.0',
 'logzero>=1.5.0,<2.0.0',
 'pyyaml>=5.3.1,<6.0.0',
 'tqdm>=4.46.1,<5.0.0']

entry_points = \
{'console_scripts': ['renotize = renotize.renotize:cli']}

setup_kwargs = {
    'name': 'renotize',
    'version': '1.1.0',
    'description': "A utility script for quickly and automatically notarizing Ren'Py applications for macOS.",
    'long_description': '# reNotize\n[![CircleCI](https://circleci.com/gh/kobaltcore/renotize.svg?style=svg)](https://circleci.com/gh/kobaltcore/renotize)\n[![Downloads](https://pepy.tech/badge/renotize)](https://pepy.tech/project/renotize)\n\nA utility script for quickly and automatically notarizing Ren\'Py applications for macOS.\n\nreNotize supports the entire pipeline of app notarization, starting with the basic ZIP file generated by Ren\'Py\'s build process and automatically generating a fully-notarized DMG for distribution to your users.\n\n## Installation\nreNotize can be installed via pip:\n```bash\n$ pip install renotize\n```\n\nPlease note that reNotize requires Python 3 and will not provide backwards compatibility for Python 2 for the foreseeable future.\n\n## Usage\nreNotize operates in stages. Each stage can be executed standalone, making it easy to add intermediary steps if required. For convenience, the subcommand `full-run` offers full automation, executing all stages in order as well as waiting for notarization to finish at the particular steps that require it.\n\nThe general process flow is as follows:\n- `unpack-app`: Takes the ZIP file of the macOS build generated by Ren\'Py\'s build process and unpacks it into a directory.\n- `sign-app`: Signs the `.app` bundle using the provided developer identity.\n- `notarize-app`: Repacks the signed app bundle into a new ZIP file and uploads it to Apple\'s notarization service for review.\n- `staple-app`: Staples the ticket generated by the notarization service to the `.app` bundle.\n- `pack-dmg`: Creates a DMG file containing the signed and stapled `.app` bundle.\n- `sign-dmg`: Signs the DMG file using the provided developer identity.\n- `notarize-dmg`: Uploads the DMG file to Apple\'s notarization service for review.\n- `staple-dmg`: Staples the ticket generated by the notarization service to the DMG file.\n\nThe output of this process will be a properly signed and stapled DMG file which can be distributed to your users.\n\n\n### Configuration\nreNotize requires a configuration file to be supplied containing the information required to sign apps on macOS. An empty template is provided in this repository under the name `config.empty.yml`\n\nIt consists of the following keys:\n- `apple_id`: The e-Mail address belonging to the Apple ID you want to use for signing applications.\n- `password`: An app-specific password generated through the [management portal](https://appleid.apple.com/account/manage) of your Apple ID.\n- `identity`: The identity associated with your Developer Certificate which can be found in `Keychain Access` under the category "My Certificates". It starts with `Developer ID Application:`, however it suffices to provide the 10-character code in the title of the certificate.\n- `bundle`: The internal name for your app. This is typically the reverse domain notation of your website plus your application name, i.e. `com.example.mygame`.\n- `altool_extra`: An optional string that will be passed on to all `altool` runs in all commands. Useful for selecting an organization when your Apple ID belongs to multiple, for example. Typically you will not have to touch this and you can leave it empty.\n\n### Example\n```bash\nrenotize -c config.yaml MyGame-1.0-mac.zip full-run\n```\n\n### Command Line Interface\n```\nUsage: renotize [OPTIONS] PROJECT COMMAND [ARGS]...\n\n  A utility script for quickly and automatically notarizing Ren\'Py\n  applications for macOS.\n\n  Commands can be abbreviated by the shortest unique string.\n\n  For example:\n      unpack-app -> u\n      sign-app -> sign-a\n      sign-dmg -> sign-d\n\n  The fully automatic process can be started using:\n      renotize -c <path_to_config> <path_to_ZIP_file> full-run\n\nOptions:\n  -c, --config TEXT\n  -d, --debug / -nd, --no-debug  Print debug information or only regular\n                                 output\n\n  --help                         Show this message and exit.\n\nCommands:\n  full-run\n  notarize-app\n  notarize-dmg\n  pack-dmg\n  sign-app\n  sign-dmg\n  staple-app\n  staple-dmg\n  status\n  unpack-app\n```\n\n# Disclaimer\nreNotize is a hobby project and not in any way affiliated with Ren\'Py. This means that there is no way I can guarantee that it will work at all, or continue to work once it does.\n',
    'author': 'CobaltCore',
    'author_email': 'cobaltcore@yandex.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kobaltcore/renotize',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
