"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudwatchAutoRetention = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const DefaultsCloudwatchAutoRetentionProps = {
    schedule: aws_events_1.Schedule.cron({ minute: '0', hour: '1', day: '1' }),
    retention: aws_logs_1.RetentionDays.ONE_MONTH,
};
/**
 * @stability stable
 */
class CloudwatchAutoRetention extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        // Check if values are set
        this.props = { ...DefaultsCloudwatchAutoRetentionProps, ...props };
        // Create Lambda function
        const handler = new aws_lambda_1.Function(this, 'LambdaCloudwatchAutoRetention', {
            handler: 'run.handler',
            code: aws_lambda_1.Code.fromAsset('functions'),
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            architecture: aws_lambda_1.Architecture.ARM_64,
            description: 'Lambda that gets triggered the first of the month. Checks all Cloudwatch log groups and changes those with never-expire to one month.',
            environment: {
                RETENTION_DAYS: this.props.retention.toString(),
            },
        });
        // Set task role and permissions
        const cloudwatchListSetRetention = new aws_iam_1.PolicyStatement({
            actions: [
                'logs:DescribeLogGroups',
                'logs:PutRetentionPolicy',
            ],
            resources: ['arn:aws:logs:*:*:log-group:*'],
        });
        (_b = handler.role) === null || _b === void 0 ? void 0 : _b.attachInlinePolicy(new aws_iam_1.Policy(this, 'cloudwatch-list-set-retention', {
            statements: [cloudwatchListSetRetention],
        }));
        // Run this script according to schedule.
        const rule = new aws_events_1.Rule(this, 'ScheduleCloudwatchAutoRetention', {
            schedule: this.props.schedule,
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(handler));
    }
}
exports.CloudwatchAutoRetention = CloudwatchAutoRetention;
_a = JSII_RTTI_SYMBOL_1;
CloudwatchAutoRetention[_a] = { fqn: "cloudwatch-auto-retention.CloudwatchAutoRetention", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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