"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaPairAddition = exports.DiskReplicaPairAdditionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaPairAdditionProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaPairAddition; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EBS::DiskReplicaPairAddition`, which is used to add a replication pair to a replication pair-consistent group.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskReplicaPairAddition`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ebs-diskreplicapairaddition
 */
class DiskReplicaPairAddition extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskReplicaPairAddition = new ebs_generated_1.RosDiskReplicaPairAddition(this, id, {
            replicaPairId: props.replicaPairId,
            replicaGroupId: props.replicaGroupId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaPairAddition;
        this.attrReplicaGroupId = rosDiskReplicaPairAddition.attrReplicaGroupId;
        this.attrReplicaPairId = rosDiskReplicaPairAddition.attrReplicaPairId;
    }
}
exports.DiskReplicaPairAddition = DiskReplicaPairAddition;
//# sourceMappingURL=data:application/json;base64,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