"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaPair = exports.DiskReplicaPairProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaPairProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaPair; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EBS::DiskReplicaPair`, which is used to create a replication pair.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskReplicaPair`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ebs-diskreplicapair
 */
class DiskReplicaPair extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskReplicaPair = new ebs_generated_1.RosDiskReplicaPair(this, id, {
            diskReplicaPairName: props.diskReplicaPairName,
            description: props.description,
            destinationDiskId: props.destinationDiskId,
            resourceGroupId: props.resourceGroupId,
            period: props.period,
            rpo: props.rpo,
            destinationRegionId: props.destinationRegionId,
            bandwidth: props.bandwidth,
            destinationZoneId: props.destinationZoneId,
            paymentType: props.paymentType,
            sourceZoneId: props.sourceZoneId,
            tags: props.tags,
            periodUnit: props.periodUnit,
            diskId: props.diskId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaPair;
        this.attrBandwidth = rosDiskReplicaPair.attrBandwidth;
        this.attrCreateTime = rosDiskReplicaPair.attrCreateTime;
        this.attrDescription = rosDiskReplicaPair.attrDescription;
        this.attrDestinationDiskId = rosDiskReplicaPair.attrDestinationDiskId;
        this.attrDestinationRegionId = rosDiskReplicaPair.attrDestinationRegionId;
        this.attrDestinationZoneId = rosDiskReplicaPair.attrDestinationZoneId;
        this.attrDiskId = rosDiskReplicaPair.attrDiskId;
        this.attrDiskReplicaPairName = rosDiskReplicaPair.attrDiskReplicaPairName;
        this.attrPaymentType = rosDiskReplicaPair.attrPaymentType;
        this.attrRpo = rosDiskReplicaPair.attrRpo;
        this.attrReplicaPairId = rosDiskReplicaPair.attrReplicaPairId;
        this.attrResourceGroupId = rosDiskReplicaPair.attrResourceGroupId;
        this.attrSourceZoneId = rosDiskReplicaPair.attrSourceZoneId;
        this.attrTags = rosDiskReplicaPair.attrTags;
    }
}
exports.DiskReplicaPair = DiskReplicaPair;
//# sourceMappingURL=data:application/json;base64,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