"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StripeEventBusProducer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_apigateway_1 = require("@aws-cdk/aws-apigateway");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class StripeEventBusProducer extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const handler = new aws_lambda_1.Function(this, 'Function', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'stripe-event-bus-producer')),
            handler: 'index.handler',
        });
        handler.addEnvironment('SOURCE', (_b = props.source) !== null && _b !== void 0 ? _b : 'Stripe');
        if (props.eventBus) {
            handler.addEnvironment('EVENT_BUS_NAME', props.eventBus.eventBusArn);
            handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                actions: ['events:PutEvents'],
                resources: [props.eventBus.eventBusArn],
            }));
        }
        else {
            handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                actions: ['events:PutEvents'],
                resources: [
                    core_1.Arn.format({
                        resource: 'event-bus',
                        service: 'events',
                        resourceName: 'default',
                    }, core_1.Stack.of(this)),
                ],
            }));
        }
        if (props.endpointSecret.grantRead) {
            props.endpointSecret.grantRead(handler);
        }
        handler.addEnvironment('ENDPOINT_SECRET_STRING', props.endpointSecret.serialize());
        if (props.secretKey.grantRead) {
            props.secretKey.grantRead(handler);
        }
        handler.addEnvironment('SECRET_KEY_STRING', props.secretKey.serialize());
        const api = new aws_apigateway_1.RestApi(this, 'Endpoint', {
            description: 'Stripe event bridge producer webhook',
            deployOptions: {
                throttlingBurstLimit: props.throttlingBurstLimit,
                throttlingRateLimit: props.throttlingRateLimit,
            },
        });
        api.root.addMethod('POST', new aws_apigateway_1.LambdaIntegration(handler));
        this.url = api.url;
    }
}
exports.StripeEventBusProducer = StripeEventBusProducer;
_a = JSII_RTTI_SYMBOL_1;
StripeEventBusProducer[_a] = { fqn: "@cloudcomponents/cdk-stripe-webhook.StripeEventBusProducer", version: "1.40.1" };
//# sourceMappingURL=data:application/json;base64,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