"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticateCognitoAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A Listener Action to authenticate with Cognito.
 *
 * @stability stable
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC).
     *
     * @stability stable
     */
    constructor(options) {
        var _b;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_b = options.sessionTimeout) === null || _b === void 0 ? void 0 : _b.toSeconds().toString(),
            },
        }, options.next);
        jsiiDeprecationWarnings._aws_cdk_aws_elasticloadbalancingv2_actions_AuthenticateCognitoActionProps(options);
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
_a = JSII_RTTI_SYMBOL_1;
AuthenticateCognitoAction[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2-actions.AuthenticateCognitoAction", version: "1.140.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29nbml0by1hY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjb2duaXRvLWFjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSw2REFBNkQ7Ozs7OztBQWtDN0QsTUFBYSx5QkFBMEIsU0FBUSxLQUFLLENBQUMsY0FBYzs7Ozs7O0lBRWpFLFlBQVksT0FBdUM7O1FBQ2pELEtBQUssQ0FBQztZQUNKLElBQUksRUFBRSxzQkFBc0I7WUFDNUIseUJBQXlCLEVBQUU7Z0JBQ3pCLFdBQVcsRUFBRSxPQUFPLENBQUMsUUFBUSxDQUFDLFdBQVc7Z0JBQ3pDLGdCQUFnQixFQUFFLE9BQU8sQ0FBQyxjQUFjLENBQUMsZ0JBQWdCO2dCQUN6RCxjQUFjLEVBQUUsT0FBTyxDQUFDLGNBQWMsQ0FBQyxVQUFVO2dCQUNqRCxnQ0FBZ0MsRUFBRSxPQUFPLENBQUMsZ0NBQWdDO2dCQUMxRSx3QkFBd0IsRUFBRSxPQUFPLENBQUMsd0JBQXdCO2dCQUMxRCxLQUFLLEVBQUUsT0FBTyxDQUFDLEtBQUs7Z0JBQ3BCLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxpQkFBaUI7Z0JBQzVDLGNBQWMsUUFBRSxPQUFPLENBQUMsY0FBYywwQ0FBRSxTQUFTLEdBQUcsUUFBUSxFQUFFO2FBQy9EO1NBQ0YsRUFBRSxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7O0tBQ2xCOztBQWhCSCw4REFpQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjb2duaXRvIGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2duaXRvJztcbmltcG9ydCAqIGFzIGVsYnYyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBBdXRoZW50aWNhdGVDb2duaXRvQWN0aW9uUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBuZXh0OiBlbGJ2Mi5MaXN0ZW5lckFjdGlvbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB1c2VyUG9vbDogY29nbml0by5JVXNlclBvb2w7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHVzZXJQb29sQ2xpZW50OiBjb2duaXRvLklVc2VyUG9vbENsaWVudDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXNlclBvb2xEb21haW46IGNvZ25pdG8uSVVzZXJQb29sRG9tYWluO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhdXRoZW50aWNhdGlvblJlcXVlc3RFeHRyYVBhcmFtcz86IFJlY29yZDxzdHJpbmcsIHN0cmluZz47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBvblVuYXV0aGVudGljYXRlZFJlcXVlc3Q/OiBlbGJ2Mi5VbmF1dGhlbnRpY2F0ZWRBY3Rpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNjb3BlPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZXNzaW9uQ29va2llTmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2Vzc2lvblRpbWVvdXQ/OiBEdXJhdGlvbjtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXV0aGVudGljYXRlQ29nbml0b0FjdGlvbiBleHRlbmRzIGVsYnYyLkxpc3RlbmVyQWN0aW9uIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Iob3B0aW9uczogQXV0aGVudGljYXRlQ29nbml0b0FjdGlvblByb3BzKSB7XG4gICAgc3VwZXIoe1xuICAgICAgdHlwZTogJ2F1dGhlbnRpY2F0ZS1jb2duaXRvJyxcbiAgICAgIGF1dGhlbnRpY2F0ZUNvZ25pdG9Db25maWc6IHtcbiAgICAgICAgdXNlclBvb2xBcm46IG9wdGlvbnMudXNlclBvb2wudXNlclBvb2xBcm4sXG4gICAgICAgIHVzZXJQb29sQ2xpZW50SWQ6IG9wdGlvbnMudXNlclBvb2xDbGllbnQudXNlclBvb2xDbGllbnRJZCxcbiAgICAgICAgdXNlclBvb2xEb21haW46IG9wdGlvbnMudXNlclBvb2xEb21haW4uZG9tYWluTmFtZSxcbiAgICAgICAgYXV0aGVudGljYXRpb25SZXF1ZXN0RXh0cmFQYXJhbXM6IG9wdGlvbnMuYXV0aGVudGljYXRpb25SZXF1ZXN0RXh0cmFQYXJhbXMsXG4gICAgICAgIG9uVW5hdXRoZW50aWNhdGVkUmVxdWVzdDogb3B0aW9ucy5vblVuYXV0aGVudGljYXRlZFJlcXVlc3QsXG4gICAgICAgIHNjb3BlOiBvcHRpb25zLnNjb3BlLFxuICAgICAgICBzZXNzaW9uQ29va2llTmFtZTogb3B0aW9ucy5zZXNzaW9uQ29va2llTmFtZSxcbiAgICAgICAgc2Vzc2lvblRpbWVvdXQ6IG9wdGlvbnMuc2Vzc2lvblRpbWVvdXQ/LnRvU2Vjb25kcygpLnRvU3RyaW5nKCksXG4gICAgICB9LFxuICAgIH0sIG9wdGlvbnMubmV4dCk7XG4gIH1cbn1cbiJdfQ==