# DO NOT EDIT! This file is automatically generated

import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    LoggedResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._channel import ChannelResourceIdentifier
    from ._common import CreatedBy, LastModifiedBy
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "InventoryEntry",
    "InventoryEntryAddQuantityAction",
    "InventoryEntryChangeQuantityAction",
    "InventoryEntryDraft",
    "InventoryEntryReference",
    "InventoryEntryRemoveQuantityAction",
    "InventoryEntryResourceIdentifier",
    "InventoryEntrySetCustomFieldAction",
    "InventoryEntrySetCustomTypeAction",
    "InventoryEntrySetExpectedDeliveryAction",
    "InventoryEntrySetRestockableInDaysAction",
    "InventoryEntrySetSupplyChannelAction",
    "InventoryEntryUpdate",
    "InventoryEntryUpdateAction",
    "InventoryPagedQueryResponse",
]


class InventoryEntry(LoggedResource):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntrySchema`."
    #: :class:`str`
    sku: str
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: :class:`int` `(Named` ``quantityOnStock`` `in Commercetools)`
    quantity_on_stock: int
    #: :class:`int` `(Named` ``availableQuantity`` `in Commercetools)`
    available_quantity: int
    #: Optional :class:`int` `(Named` ``restockableInDays`` `in Commercetools)`
    restockable_in_days: typing.Optional[int]
    #: Optional :class:`datetime.datetime` `(Named` ``expectedDelivery`` `in Commercetools)`
    expected_delivery: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]

    def __init__(
        self,
        *,
        id: str = None,
        version: int = None,
        created_at: datetime.datetime = None,
        last_modified_at: datetime.datetime = None,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        sku: str = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        quantity_on_stock: int = None,
        available_quantity: int = None,
        restockable_in_days: typing.Optional[int] = None,
        expected_delivery: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFields"] = None
    ) -> None:
        self.sku = sku
        self.supply_channel = supply_channel
        self.quantity_on_stock = quantity_on_stock
        self.available_quantity = available_quantity
        self.restockable_in_days = restockable_in_days
        self.expected_delivery = expected_delivery
        self.custom = custom
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
        )

    def __repr__(self) -> str:
        return (
            "InventoryEntry(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sku=%r, supply_channel=%r, quantity_on_stock=%r, available_quantity=%r, restockable_in_days=%r, expected_delivery=%r, custom=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sku,
                self.supply_channel,
                self.quantity_on_stock,
                self.available_quantity,
                self.restockable_in_days,
                self.expected_delivery,
                self.custom,
            )
        )


class InventoryEntryDraft(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryDraftSchema`."
    #: :class:`str`
    sku: str
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: :class:`int` `(Named` ``quantityOnStock`` `in Commercetools)`
    quantity_on_stock: int
    #: Optional :class:`int` `(Named` ``restockableInDays`` `in Commercetools)`
    restockable_in_days: typing.Optional[int]
    #: Optional :class:`datetime.datetime` `(Named` ``expectedDelivery`` `in Commercetools)`
    expected_delivery: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]

    def __init__(
        self,
        *,
        sku: str = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        quantity_on_stock: int = None,
        restockable_in_days: typing.Optional[int] = None,
        expected_delivery: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None
    ) -> None:
        self.sku = sku
        self.supply_channel = supply_channel
        self.quantity_on_stock = quantity_on_stock
        self.restockable_in_days = restockable_in_days
        self.expected_delivery = expected_delivery
        self.custom = custom
        super().__init__()

    def __repr__(self) -> str:
        return (
            "InventoryEntryDraft(sku=%r, supply_channel=%r, quantity_on_stock=%r, restockable_in_days=%r, expected_delivery=%r, custom=%r)"
            % (
                self.sku,
                self.supply_channel,
                self.quantity_on_stock,
                self.restockable_in_days,
                self.expected_delivery,
                self.custom,
            )
        )


class InventoryEntryReference(Reference):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryReferenceSchema`."
    #: Optional :class:`commercetools.types.InventoryEntry`
    obj: typing.Optional["InventoryEntry"]

    def __init__(
        self,
        *,
        type_id: "ReferenceTypeId" = None,
        id: str = None,
        obj: typing.Optional["InventoryEntry"] = None
    ) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.INVENTORY_ENTRY, id=id)

    def __repr__(self) -> str:
        return "InventoryEntryReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class InventoryEntryResourceIdentifier(ResourceIdentifier):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryResourceIdentifierSchema`."

    def __init__(
        self,
        *,
        type_id: typing.Optional["ReferenceTypeId"] = None,
        id: typing.Optional[str] = None,
        key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.INVENTORY_ENTRY, id=id, key=key)

    def __repr__(self) -> str:
        return "InventoryEntryResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class InventoryEntryUpdate(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryUpdateSchema`."
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int = None, actions: list = None) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "InventoryEntryUpdate(version=%r, actions=%r)" % (
            self.version,
            self.actions,
        )


class InventoryEntryUpdateAction(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryUpdateActionSchema`."
    #: :class:`str`
    action: str

    def __init__(self, *, action: str = None) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "InventoryEntryUpdateAction(action=%r)" % (self.action,)


class InventoryPagedQueryResponse(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryPagedQueryResponseSchema`."
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.InventoryEntry`
    results: typing.Sequence["InventoryEntry"]

    def __init__(
        self,
        *,
        limit: int = None,
        count: int = None,
        total: typing.Optional[int] = None,
        offset: int = None,
        results: typing.Sequence["InventoryEntry"] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "InventoryPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class InventoryEntryAddQuantityAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryAddQuantityActionSchema`."
    #: :class:`int`
    quantity: int

    def __init__(self, *, action: str = None, quantity: int = None) -> None:
        self.quantity = quantity
        super().__init__(action="addQuantity")

    def __repr__(self) -> str:
        return "InventoryEntryAddQuantityAction(action=%r, quantity=%r)" % (
            self.action,
            self.quantity,
        )


class InventoryEntryChangeQuantityAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryChangeQuantityActionSchema`."
    #: :class:`int`
    quantity: int

    def __init__(self, *, action: str = None, quantity: int = None) -> None:
        self.quantity = quantity
        super().__init__(action="changeQuantity")

    def __repr__(self) -> str:
        return "InventoryEntryChangeQuantityAction(action=%r, quantity=%r)" % (
            self.action,
            self.quantity,
        )


class InventoryEntryRemoveQuantityAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntryRemoveQuantityActionSchema`."
    #: :class:`int`
    quantity: int

    def __init__(self, *, action: str = None, quantity: int = None) -> None:
        self.quantity = quantity
        super().__init__(action="removeQuantity")

    def __repr__(self) -> str:
        return "InventoryEntryRemoveQuantityAction(action=%r, quantity=%r)" % (
            self.action,
            self.quantity,
        )


class InventoryEntrySetCustomFieldAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntrySetCustomFieldActionSchema`."
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: str = None,
        name: str = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "InventoryEntrySetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class InventoryEntrySetCustomTypeAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntrySetCustomTypeActionSchema`."
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: str = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "InventoryEntrySetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class InventoryEntrySetExpectedDeliveryAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntrySetExpectedDeliveryActionSchema`."
    #: Optional :class:`datetime.datetime` `(Named` ``expectedDelivery`` `in Commercetools)`
    expected_delivery: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        action: str = None,
        expected_delivery: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.expected_delivery = expected_delivery
        super().__init__(action="setExpectedDelivery")

    def __repr__(self) -> str:
        return (
            "InventoryEntrySetExpectedDeliveryAction(action=%r, expected_delivery=%r)"
            % (self.action, self.expected_delivery)
        )


class InventoryEntrySetRestockableInDaysAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntrySetRestockableInDaysActionSchema`."
    #: Optional :class:`int` `(Named` ``restockableInDays`` `in Commercetools)`
    restockable_in_days: typing.Optional[int]

    def __init__(
        self, *, action: str = None, restockable_in_days: typing.Optional[int] = None
    ) -> None:
        self.restockable_in_days = restockable_in_days
        super().__init__(action="setRestockableInDays")

    def __repr__(self) -> str:
        return (
            "InventoryEntrySetRestockableInDaysAction(action=%r, restockable_in_days=%r)"
            % (self.action, self.restockable_in_days)
        )


class InventoryEntrySetSupplyChannelAction(InventoryEntryUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.InventoryEntrySetSupplyChannelActionSchema`."
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]

    def __init__(
        self,
        *,
        action: str = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None
    ) -> None:
        self.supply_channel = supply_channel
        super().__init__(action="setSupplyChannel")

    def __repr__(self) -> str:
        return "InventoryEntrySetSupplyChannelAction(action=%r, supply_channel=%r)" % (
            self.action,
            self.supply_channel,
        )
