# DO NOT EDIT! This file is automatically generated

import marshmallow

from commercetools import helpers, types
from commercetools.schemas._common import (
    LoggedResourceSchema,
    ReferenceSchema,
    ResourceIdentifierSchema,
)
from commercetools.schemas._type import FieldContainerField

__all__ = [
    "InventoryEntryAddQuantityActionSchema",
    "InventoryEntryChangeQuantityActionSchema",
    "InventoryEntryDraftSchema",
    "InventoryEntryReferenceSchema",
    "InventoryEntryRemoveQuantityActionSchema",
    "InventoryEntryResourceIdentifierSchema",
    "InventoryEntrySchema",
    "InventoryEntrySetCustomFieldActionSchema",
    "InventoryEntrySetCustomTypeActionSchema",
    "InventoryEntrySetExpectedDeliveryActionSchema",
    "InventoryEntrySetRestockableInDaysActionSchema",
    "InventoryEntrySetSupplyChannelActionSchema",
    "InventoryEntryUpdateActionSchema",
    "InventoryEntryUpdateSchema",
    "InventoryPagedQueryResponseSchema",
]


class InventoryEntryDraftSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryDraft`."
    sku = marshmallow.fields.String(allow_none=True)
    supply_channel = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    quantity_on_stock = marshmallow.fields.Integer(
        allow_none=True, data_key="quantityOnStock"
    )
    restockable_in_days = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="restockableInDays"
    )
    expected_delivery = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="expectedDelivery"
    )
    custom = marshmallow.fields.Nested(
        nested="commercetools.schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.InventoryEntryDraft(**data)


class InventoryEntryReferenceSchema(ReferenceSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryReference`."
    obj = marshmallow.fields.Nested(
        nested="commercetools.schemas._inventory.InventoryEntrySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.InventoryEntryReference(**data)


class InventoryEntryResourceIdentifierSchema(ResourceIdentifierSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryResourceIdentifier`."

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.InventoryEntryResourceIdentifier(**data)


class InventoryEntrySchema(LoggedResourceSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntry`."
    sku = marshmallow.fields.String(allow_none=True)
    supply_channel = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    quantity_on_stock = marshmallow.fields.Integer(
        allow_none=True, data_key="quantityOnStock"
    )
    available_quantity = marshmallow.fields.Integer(
        allow_none=True, data_key="availableQuantity"
    )
    restockable_in_days = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="restockableInDays"
    )
    expected_delivery = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="expectedDelivery"
    )
    custom = marshmallow.fields.Nested(
        nested="commercetools.schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.InventoryEntry(**data)


class InventoryEntryUpdateActionSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryUpdateAction`."
    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntryUpdateAction(**data)


class InventoryEntryUpdateSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryUpdate`."
    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addQuantity": "commercetools.schemas._inventory.InventoryEntryAddQuantityActionSchema",
                "changeQuantity": "commercetools.schemas._inventory.InventoryEntryChangeQuantityActionSchema",
                "removeQuantity": "commercetools.schemas._inventory.InventoryEntryRemoveQuantityActionSchema",
                "setCustomField": "commercetools.schemas._inventory.InventoryEntrySetCustomFieldActionSchema",
                "setCustomType": "commercetools.schemas._inventory.InventoryEntrySetCustomTypeActionSchema",
                "setExpectedDelivery": "commercetools.schemas._inventory.InventoryEntrySetExpectedDeliveryActionSchema",
                "setRestockableInDays": "commercetools.schemas._inventory.InventoryEntrySetRestockableInDaysActionSchema",
                "setSupplyChannel": "commercetools.schemas._inventory.InventoryEntrySetSupplyChannelActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.InventoryEntryUpdate(**data)


class InventoryPagedQueryResponseSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.InventoryPagedQueryResponse`."
    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = marshmallow.fields.Nested(
        nested="commercetools.schemas._inventory.InventoryEntrySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.InventoryPagedQueryResponse(**data)


class InventoryEntryAddQuantityActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryAddQuantityAction`."
    quantity = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntryAddQuantityAction(**data)


class InventoryEntryChangeQuantityActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryChangeQuantityAction`."
    quantity = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntryChangeQuantityAction(**data)


class InventoryEntryRemoveQuantityActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryRemoveQuantityAction`."
    quantity = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntryRemoveQuantityAction(**data)


class InventoryEntrySetCustomFieldActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntrySetCustomFieldAction`."
    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntrySetCustomFieldAction(**data)


class InventoryEntrySetCustomTypeActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntrySetCustomTypeAction`."
    type = marshmallow.fields.Nested(
        nested="commercetools.schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntrySetCustomTypeAction(**data)


class InventoryEntrySetExpectedDeliveryActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntrySetExpectedDeliveryAction`."
    expected_delivery = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="expectedDelivery"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntrySetExpectedDeliveryAction(**data)


class InventoryEntrySetRestockableInDaysActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntrySetRestockableInDaysAction`."
    restockable_in_days = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="restockableInDays"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntrySetRestockableInDaysAction(**data)


class InventoryEntrySetSupplyChannelActionSchema(InventoryEntryUpdateActionSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntrySetSupplyChannelAction`."
    supply_channel = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.InventoryEntrySetSupplyChannelAction(**data)
