# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['abmodel',
 'abmodel.agent',
 'abmodel.analysis',
 'abmodel.models',
 'abmodel.population',
 'abmodel.utils',
 'abmodel.utils.helpers']

package_data = \
{'': ['*']}

install_requires = \
['bokeh>=2.4.3,<3.0.0',
 'dask>=2022.4.0,<2023.0.0',
 'munch>=2.5.0,<3.0.0',
 'numpy>=1.21,<2.0',
 'pandas>=1.2.4,<2.0.0',
 'pydantic>=1.8.2,<2.0.0',
 'scikit-learn>=0.24.2,<0.25.0',
 'scipy>=1.6.3,<2.0.0',
 'snakeviz>=2.1.1,<3.0.0']

setup_kwargs = {
    'name': 'cdslib-agents',
    'version': '0.0.7a1',
    'description': 'Contagious diseases simulation using Agent-Based Models',
    'long_description': '# CDSLib - Agents\n\nWelcome to **CDSLib - Agents** package.\n\n[![Open Source Love svg2](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)\n[![PyPI](https://img.shields.io/pypi/v/cdslib-agents?color=color=%2310d510)](https://pypi.org/project/cdslib-agents/)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/cdslib-agents?color=%2310d510)](https://pypi.org/project/cdslib-agents/)\n[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/fenfisdi/cdslib_agents/graphs/commit-activity)\n[![GitHub contributors](https://img.shields.io/github/contributors/fenfisdi/cdslib_agents)](https://github.com/fenfisdi/cdslib_agents/graphs/contributors)\n\n## License\n\n[![license](https://img.shields.io/github/license/fenfisdi/cdslib_agents)](./LICENSE)\n\n## Sponsors\n\n| [![Sponsored by](https://img.shields.io/badge/sponsored%20by-UdeA-yellow)](https://www.udea.edu.co/) | [![Sponsored by](https://img.shields.io/badge/sponsored%20by-minciencias-yellow)](https://minciencias.gov.co/) | [![Sponsored by](https://img.shields.io/badge/sponsored%20by-sena-yellow)](https://www.sena.edu.co/) |\n| :---: | :---: | :---: |\n| <img src="https://raw.githubusercontent.com/fenfisdi/cdslib_agents/2335693f162e3cca97f7bba8591db9b0076a3823/images/Escudo-UdeA.svg" alt="UdeA logo" height="34"> | <img src="https://raw.githubusercontent.com/fenfisdi/cdslib_agents/1755d1fc4e45e94fcdc4275709b93fdf4eabd5f2/images/Minciencias_Colombia.svg" alt="Minciencias logo" width="160" height="34"> | <img src="https://raw.githubusercontent.com/fenfisdi/cdslib_agents/2335693f162e3cca97f7bba8591db9b0076a3823/images/Sena_Colombia_logo.svg" alt="Sena logo" height="34"> |\n\n\n## Code quality metrics\n\n[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Bugs](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=bugs)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Code Smells](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=code_smells)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Coverage](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=coverage)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Duplicated Lines (%)](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=duplicated_lines_density)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Lines of Code](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=ncloc)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=sqale_rating)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Reliability Rating](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=reliability_rating)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Security Rating](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=security_rating)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Technical Debt](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=sqale_index)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n[![Vulnerabilities](https://sonarcloud.io/api/project_badges/measure?project=fenfisdi_cdslib_agents&metric=vulnerabilities)](https://sonarcloud.io/summary/new_code?id=fenfisdi_cdslib_agents)\n\n## Description\n\nAs part of the **Contagious Disease Simulation Library**, the\n**CDSLib - Agents** package is intended to be used for modelling and simulating\ncontagious diseases using Agent-Based Models and it has been used for the development\nof the [Contagious Disease Simulation Laboratory](https://github.com/fenfisdi/cdslab).\n\nThe package consists of different implementations of a heterogeneous population\nof agents following rules of behavior that determine their movement and the evolution\nof their infectious and clinical states.\n\nThe current implementation allows Agents to move in a bidemensional space following\na distribution of velocities based on population data. This can be achieved thanks to\nthe inclusion Distribution module which is a wrapper for different tools that provides\ndistribution-like function support.\n\nIn regards to the disease states, the current implementation also allows the user to\nadd as much states as preferred, and to create custom natural history of the disease\n(i.e. the design a custom graph for evolution of disease states).\n\nFor more information, please refer to the official documentation of the project.\n\n## Testing\n\nAll the tests were developed with the python tool pytest. To see them properly, type\nin the command line:\n\n`$ poetry run pytest <name_of_test_file>`\n\nin the same ubication of the test file.\n\nFlags are used with pytest for modifying the aspect of the output\nreport. Typing flags using pytest might be tedious, however, it is possible modify the `pytest.init` file for\n[change defaulting command line options](https://docs.pytest.org/en/6.2.x/example/simple.html#how-to-change-command-line-options-defaults). This allows to adopt as many flags\nas necesary. In our case, it was adopted the flags: `-s`, `--no-header`, `-rA`, `-vv`,\n`--cov`, `--cov-branch`.\n\nDuring test execution with pytest, any output sent to stdout and stderr is\n[captured](https://docs.pytest.org/en/6.2.x/capture.html). The `-s` flag  \ndisable all capturing and lets the user look at all the outputs, this is very\nimportant because the description of all tests was typed in the docstring of each method.\n\nThe `--no-header` flag disables the [initial header](https://docs.pytest.org/en/stable/changelog.html#id33).\n\nThe `-rA` flag shows extra test [summary info](https://docs.pytest.org/en/6.2.x/usage.html#detailed-summary-report) of all the tests.\n\nThe `-vv` flag indicates to pytest run in [verbosity](https://docs.pytest.org/en/latest/how-to/output.html) mode, this controls all the pytest outputs.\n\nThe flag `--cov` produces a [coverage](https://pytest-cov.readthedocs.io/en/latest/#welcome-to-pytest-cov-s-documentation) reports. It shows the percentage of code lines covered by the test, while `--cov-branch` shows the branches covered. A branch is\na decision taken by the code when it finds an if sentence or similar.\n\nFor more information about [pytest flags](https://docs.pytest.org/en/6.2.x/usage.html).\n\nInstead of running one test, it is possible to run all the tests at the same time. You must be inside of `tests` directory, and type in the command line:\n\n`$ poetry run pytest`\n\nSo as to Modify the initial conditions of the test, use the fixtures methods at the beginning\nof all the tests files.\n\n![repo_logo](https://raw.githubusercontent.com/fenfisdi/cdslib_agents/main/images/CDSLib_agents_white-background.png "CDSLib - Agents Logo")\n\n## Authors and main contributors\n\n[![GitHub contributors](https://img.shields.io/github/contributors/fenfisdi/cdslib_agents)](https://github.com/fenfisdi/cdslib_agents/graphs/contributors)\n\nThis package is authored by \n[Camilo Hincapié](https://www.linkedin.com/in/camilo-hincapie-gutierrez/) (main author),\n[Ian Mejía](https://github.com/IanMejia),\n[Emil Rueda](https://www.linkedin.com/in/emil-rueda-424012207/),\n[Nicole Rivera](https://github.com/nicolerivera1)\nand\n[Carolina Rojas Duque](https://github.com/carolinarojasd)\nand the conceptual contributions about epidemiology of\n[Lina Marcela Ruiz Galvis](mailto:lina.ruiz2@udea.edu.co).\n\nOther remarkably contributors to this work were\n[Alejandro Campillo](https://www.linkedin.com/in/alucardcampillo/)\nand\n[Daniel Alfonso Montoya](https://www.linkedin.com/in/daniel-montoya-ds/).\n\n\n\n\n## Contact us\n\nFor any suggestion on the development of this type of models, please our official\nchannels of [dicussions](https://github.com/fenfisdi/cdslib_agents/discussions)\nprovided by GitHub.\n\n## Development\n\n### Create the virtualenv\n\nThis package is managed using [Pyenv](https://github.com/pyenv/pyenv) and \n[Poetry](https://python-poetry.org/docs/). In order to create the\nvirtualenv correctly use:\n\n```\n$ pyenv install 3.9.7\n$ poetry env use 3.9.7\n$ poetry install\n```\n\nThen activate the virtualenv running `poetry shell`, and to deactivate the virtual\nenvironment and exit this new shell type `exit`.\n',
    'author': 'Camilo Hincapié Gutiérrez',
    'author_email': 'camilo.hincapie@udea.edu.co',
    'maintainer': 'Vladimir Emil Rueda Gómez',
    'maintainer_email': 'vladimir.rueda@udea.edu.co',
    'url': 'https://pypi.org/project/cdslib-agents/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>3.9.7,<3.11',
}


setup(**setup_kwargs)
