# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ubiops.configuration import Configuration


class PipelineVersionUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'version': 'str',
        'description': 'str',
        'labels': 'dict(str, str)',
        'monitoring': 'str',
        'request_retention_time': 'int',
        'request_retention_mode': 'str',
        'default_notification_group': 'str',
        'objects': 'list[PipelineVersionObjectCreate]',
        'attachments': 'list[AttachmentsCreate]'
    }

    attribute_map = {
        'version': 'version',
        'description': 'description',
        'labels': 'labels',
        'monitoring': 'monitoring',
        'request_retention_time': 'request_retention_time',
        'request_retention_mode': 'request_retention_mode',
        'default_notification_group': 'default_notification_group',
        'objects': 'objects',
        'attachments': 'attachments'
    }

    def __init__(self, version=None, description=None, labels=None, monitoring=None, request_retention_time=None, request_retention_mode=None, default_notification_group=None, objects=None, attachments=None, local_vars_configuration=None):  # noqa: E501
        """PipelineVersionUpdate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._version = None
        self._description = None
        self._labels = None
        self._monitoring = None
        self._request_retention_time = None
        self._request_retention_mode = None
        self._default_notification_group = None
        self._objects = None
        self._attachments = None
        self.discriminator = None

        if version is not None:
            self.version = version
        if description is not None:
            self.description = description
        self.labels = labels
        self.monitoring = monitoring
        if request_retention_time is not None:
            self.request_retention_time = request_retention_time
        if request_retention_mode is not None:
            self.request_retention_mode = request_retention_mode
        self.default_notification_group = default_notification_group
        if objects is not None:
            self.objects = objects
        if attachments is not None:
            self.attachments = attachments

    @property
    def version(self):
        """Gets the version of this PipelineVersionUpdate.  # noqa: E501


        :return: The version of this PipelineVersionUpdate.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this PipelineVersionUpdate.


        :param version: The version of this PipelineVersionUpdate.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                version is not None and not isinstance(version, str)):
            raise ValueError("Parameter `version` must be a string")  # noqa: E501

        if (self.local_vars_configuration.client_side_validation and
                version is not None and len(version) < 1):
            raise ValueError("Invalid value for `version`, length must be greater than or equal to `1`")  # noqa: E501

        self._version = version

    @property
    def description(self):
        """Gets the description of this PipelineVersionUpdate.  # noqa: E501


        :return: The description of this PipelineVersionUpdate.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PipelineVersionUpdate.


        :param description: The description of this PipelineVersionUpdate.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and not isinstance(description, str)):
            raise ValueError("Parameter `description` must be a string")  # noqa: E501

        self._description = description

    @property
    def labels(self):
        """Gets the labels of this PipelineVersionUpdate.  # noqa: E501


        :return: The labels of this PipelineVersionUpdate.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this PipelineVersionUpdate.


        :param labels: The labels of this PipelineVersionUpdate.  # noqa: E501
        :type: dict(str, str)
        """
        if (self.local_vars_configuration.client_side_validation and
                labels is not None and not isinstance(labels, dict)):
            raise ValueError("Parameter `labels` must be a dictionary")  # noqa: E501

        self._labels = labels

    @property
    def monitoring(self):
        """Gets the monitoring of this PipelineVersionUpdate.  # noqa: E501


        :return: The monitoring of this PipelineVersionUpdate.  # noqa: E501
        :rtype: str
        """
        return self._monitoring

    @monitoring.setter
    def monitoring(self, monitoring):
        """Sets the monitoring of this PipelineVersionUpdate.


        :param monitoring: The monitoring of this PipelineVersionUpdate.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                monitoring is not None and not isinstance(monitoring, str)):
            raise ValueError("Parameter `monitoring` must be a string")  # noqa: E501

        if (self.local_vars_configuration.client_side_validation and
                monitoring is not None and len(monitoring) < 1):
            raise ValueError("Invalid value for `monitoring`, length must be greater than or equal to `1`")  # noqa: E501

        self._monitoring = monitoring

    @property
    def request_retention_time(self):
        """Gets the request_retention_time of this PipelineVersionUpdate.  # noqa: E501


        :return: The request_retention_time of this PipelineVersionUpdate.  # noqa: E501
        :rtype: int
        """
        return self._request_retention_time

    @request_retention_time.setter
    def request_retention_time(self, request_retention_time):
        """Sets the request_retention_time of this PipelineVersionUpdate.


        :param request_retention_time: The request_retention_time of this PipelineVersionUpdate.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                request_retention_time is not None and not isinstance(request_retention_time, int)):
            raise ValueError("Parameter `request_retention_time` must be an integer")  # noqa: E501

        self._request_retention_time = request_retention_time

    @property
    def request_retention_mode(self):
        """Gets the request_retention_mode of this PipelineVersionUpdate.  # noqa: E501


        :return: The request_retention_mode of this PipelineVersionUpdate.  # noqa: E501
        :rtype: str
        """
        return self._request_retention_mode

    @request_retention_mode.setter
    def request_retention_mode(self, request_retention_mode):
        """Sets the request_retention_mode of this PipelineVersionUpdate.


        :param request_retention_mode: The request_retention_mode of this PipelineVersionUpdate.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                request_retention_mode is not None and not isinstance(request_retention_mode, str)):
            raise ValueError("Parameter `request_retention_mode` must be a string")  # noqa: E501
        allowed_values = ["none", "metadata", "full"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and request_retention_mode not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `request_retention_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(request_retention_mode, allowed_values)
            )

        self._request_retention_mode = request_retention_mode

    @property
    def default_notification_group(self):
        """Gets the default_notification_group of this PipelineVersionUpdate.  # noqa: E501


        :return: The default_notification_group of this PipelineVersionUpdate.  # noqa: E501
        :rtype: str
        """
        return self._default_notification_group

    @default_notification_group.setter
    def default_notification_group(self, default_notification_group):
        """Sets the default_notification_group of this PipelineVersionUpdate.


        :param default_notification_group: The default_notification_group of this PipelineVersionUpdate.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_notification_group is not None and not isinstance(default_notification_group, str)):
            raise ValueError("Parameter `default_notification_group` must be a string")  # noqa: E501

        if (self.local_vars_configuration.client_side_validation and
                default_notification_group is not None and len(default_notification_group) < 1):
            raise ValueError("Invalid value for `default_notification_group`, length must be greater than or equal to `1`")  # noqa: E501

        self._default_notification_group = default_notification_group

    @property
    def objects(self):
        """Gets the objects of this PipelineVersionUpdate.  # noqa: E501


        :return: The objects of this PipelineVersionUpdate.  # noqa: E501
        :rtype: list[PipelineVersionObjectCreate]
        """
        return self._objects

    @objects.setter
    def objects(self, objects):
        """Sets the objects of this PipelineVersionUpdate.


        :param objects: The objects of this PipelineVersionUpdate.  # noqa: E501
        :type: list[PipelineVersionObjectCreate]
        """
        if (self.local_vars_configuration.client_side_validation and
                objects is not None and not isinstance(objects, list)):
            raise ValueError("Parameter `objects` must be a list")  # noqa: E501
        if self.local_vars_configuration.client_side_validation and objects is not None:
            from ubiops.models.pipeline_version_object_create import PipelineVersionObjectCreate

            objects = [
                PipelineVersionObjectCreate(**item) if isinstance(item, dict) else item  # noqa: E501
                for item in objects
            ]

        self._objects = objects

    @property
    def attachments(self):
        """Gets the attachments of this PipelineVersionUpdate.  # noqa: E501


        :return: The attachments of this PipelineVersionUpdate.  # noqa: E501
        :rtype: list[AttachmentsCreate]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this PipelineVersionUpdate.


        :param attachments: The attachments of this PipelineVersionUpdate.  # noqa: E501
        :type: list[AttachmentsCreate]
        """
        if (self.local_vars_configuration.client_side_validation and
                attachments is not None and not isinstance(attachments, list)):
            raise ValueError("Parameter `attachments` must be a list")  # noqa: E501
        if self.local_vars_configuration.client_side_validation and attachments is not None:
            from ubiops.models.attachments_create import AttachmentsCreate

            attachments = [
                AttachmentsCreate(**item) if isinstance(item, dict) else item  # noqa: E501
                for item in attachments
            ]

        self._attachments = attachments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PipelineVersionUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PipelineVersionUpdate):
            return True

        return self.to_dict() != other.to_dict()
