# Generated by Django 3.2.12 on 2022-08-29 14:31

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import wagtailthemes.storage


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("wagtailthemes", "0002_auto_20161124_1107"),
    ]

    operations = [
        migrations.CreateModel(
            name="Theme",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="Naam")),
                (
                    "pathname",
                    models.CharField(
                        help_text="The pathname of the theme which must match the pathname used in your templates.",
                        max_length=255,
                        unique=True,
                        verbose_name="Pathname",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Aangemaakt"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
            ],
            options={
                "verbose_name": "Theme",
                "verbose_name_plural": "Themes",
                "ordering": ["name"],
            },
        ),
        migrations.AlterField(
            model_name="themesettings",
            name="theme",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="wagtailthemes.theme",
                verbose_name="Theme",
            ),
        ),
        migrations.CreateModel(
            name="Template",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("path", models.TextField(verbose_name="Path")),
                (
                    "hash",
                    models.TextField(editable=False, null=True, verbose_name="Hash"),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Aangemaakt"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                ("value", models.TextField(verbose_name="Bericht")),
                (
                    "modified_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Modified by",
                    ),
                ),
                (
                    "theme",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtailthemes.theme",
                        verbose_name="Theme",
                    ),
                ),
            ],
            options={
                "verbose_name": "Template",
                "verbose_name_plural": "Templates",
                "unique_together": {("theme", "path")},
            },
        ),
        migrations.CreateModel(
            name="StaticFile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("path", models.TextField(verbose_name="Path")),
                (
                    "hash",
                    models.TextField(editable=False, null=True, verbose_name="Hash"),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Aangemaakt"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                (
                    "file",
                    wagtailthemes.storage.StaticFileField(
                        upload_to=wagtailthemes.storage.static_file_path,
                        verbose_name="File",
                    ),
                ),
                (
                    "modified_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Modified by",
                    ),
                ),
                (
                    "theme",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtailthemes.theme",
                        verbose_name="Theme",
                    ),
                ),
            ],
            options={
                "verbose_name": "Static file",
                "verbose_name_plural": "Static files",
                "unique_together": {("theme", "path")},
            },
        ),
    ]
