# WiFi Radio

This package works with [MicroBlocks](https://microblocks.fun/) WiFi Radio library.

## Install

```
pip install microblocks_wifi_radio
```

## Usage

```
import time
from microblocks_wifi_radio import Radio
r = Radio()
r.send_number(123)
time.sleep(1)
r.send_string("hello")
time.sleep(1)
r.send_pair("light", 10)

while True:
    time.sleep(0.01)
    if r.message_received():
        print(r.last_number)
        print(r.last_string)
```

[MicroBlocks Demo](https://microblocks.fun/run-pilot/microblocks.html#project=projectName%20%27%27%0A%0Amodule%20main%0Aauthor%20unknown%0Aversion%201%200%20%0Adescription%20%27%27%0A%0Ascript%2040%2070%20%7B%0AwhenStarted%0AwifiConnect%20%27Network_Name%27%20%27%27%0Aforever%20%7B%0A%20%20if%20%28wifiRadio_messageReceived%29%20%7BsayIt%20%28wifiRadio_receivedString%29%20%28wifiRadio_receivedInteger%29%7D%0A%7D%0A%7D%0A%0Ascript%2044%20296%20%7B%0AwifiRadio_sendNumber%20123%0A%7D%0A%0Ascript%2046%20347%20%7B%0AwifiRadio_sendString%20%27Hello%21%27%0A%7D%0A%0Ascript%2041%20399%20%7B%0AwifiRadio_sendPair%20%27light%27%2010%0A%7D%0A%0A%0Amodule%20%27HTTP%20client%27%20Comm%0Aauthor%20MicroBlocks%0Aversion%201%204%20%0Adepends%20WiFi%20%0Atags%20http%20network%20get%20post%20put%20delete%20%0Achoices%20requestTypes%20GET%20POST%20PUT%20DELETE%20%0Adescription%20%27Send%20HTTP%20requests%20and%20get%20responses%20back.%20You%20can%20use%20this%20library%20to%20fetch%20or%20store%20data%20in%20online%20servers%2C%20or%20to%20control%20other%20Wifi-enabled%20boards.%0A%27%0A%0A%20%20spec%20%27r%27%20%27_http_body_start%27%20%27_http_body_start%20_%27%20%27auto%27%20%27%27%0A%20%20spec%20%27r%27%20%27_http_header_text%27%20%27_http_header_text%20_%27%20%27auto%27%20%27%27%0A%20%20spec%20%27r%27%20%27_http_status_text%27%20%27_http_status_text%20_%27%20%27auto%27%20%27%27%0A%20%20spec%20%27r%27%20%27_http_header%27%20%27_header%20_%20of%20response%20_%27%20%27auto%20auto%27%20%27content-length%27%20%27%27%0A%20%20spec%20%27r%27%20%27_http_status%27%20%27_status%20of%20response%20_%27%20%27auto%27%20%27%27%0A%20%20spec%20%27r%27%20%27_line_end%27%20%27_line_end%27%0A%20%20spec%20%27r%27%20%27_lowercase%27%20%27_lowercase%20_%27%20%27auto%27%20%27ABC%20Def%20gH%27%0A%20%20spec%20%27r%27%20%27_request_url%27%20%27_request_url%20_%20method%20_%20body%20_%20%3A%20port%20_%27%20%27str%20menu.requestTypes%20str%20num%27%20%27%27%20%27GET%27%20%27%27%2080%0A%20%20spec%20%27r%27%20%27_readHTTPResponse%27%20%27_readHTTPResponse%27%0A%20%20spec%20%27r%27%20%27http%DC%83%2F%2F%27%20%27http%DC%83%2F%2F%20_%20%20%3A%20port%20_%27%20%27auto%20num%27%20%27microblocks.fun%2Fexample.txt%27%2080%0A%20%20spec%20%27%20%27%20%27request%27%20%27_%20data%20_%20to%20http%DC%83%2F%2F%20_%20%20%3A%20port%20_%27%20%27menu.requestTypes%20str%20str%20num%27%20%27POST%27%20%27MicroBlocks%20is%20fun%27%20%27microblocks.fun%27%2080%0A%0Ato%20%27_http_body_start%27%20response%20%7B%0A%20%20return%20%28%28%27%5Bdata%3Afind%5D%27%20%28%27%5Bdata%3AunicodeString%5D%27%20%28%27%5Bdata%3AmakeList%5D%27%2013%2010%2013%2010%29%29%20response%29%20%2B%204%29%0A%7D%0A%0Ato%20%27_http_header%27%20header%20response%20%7B%0A%20%20local%20%27header%20text%27%20%28%27_http_header_text%27%20response%29%0A%20%20header%20%3D%20%28%27_lowercase%27%20header%29%0A%20%20repeatUntil%20%28%28size%20%28v%20%27header%20text%27%29%29%20%3C%203%29%20%7B%0A%20%20%20%20local%20%27key%27%20%28%27%5Bdata%3AcopyFromTo%5D%27%20%28v%20%27header%20text%27%29%201%20%28%28%27%5Bdata%3Afind%5D%27%20%27%3A%27%20%28v%20%27header%20text%27%29%29%20-%201%29%29%0A%20%20%20%20if%20%28%28%27_lowercase%27%20key%29%20%3D%3D%20header%29%20%7B%0A%20%20%20%20%20%20return%20%28%27%5Bdata%3AcopyFromTo%5D%27%20%28v%20%27header%20text%27%29%20%28%28%27%5Bdata%3Afind%5D%27%20%27%3A%27%20%28v%20%27header%20text%27%29%29%20%2B%202%29%20%28%28%27%5Bdata%3Afind%5D%27%20%28%27_line_end%27%29%20%28v%20%27header%20text%27%29%29%20-%201%29%29%0A%20%20%20%20%7D%0A%20%20%20%20%27header%20text%27%20%3D%20%28%27%5Bdata%3AcopyFromTo%5D%27%20%28v%20%27header%20text%27%29%20%28%28%27%5Bdata%3Afind%5D%27%20%28%27_line_end%27%29%20%28v%20%27header%20text%27%29%29%20%2B%202%29%29%0A%20%20%7D%0A%20%20return%20%28booleanConstant%20false%29%0A%7D%0A%0Ato%20%27_http_header_text%27%20response%20%7B%0A%20%20local%20%27headersStart%27%20%28%28%27%5Bdata%3Afind%5D%27%20%28%27_line_end%27%29%20response%29%20%2B%202%29%0A%20%20return%20%28%27%5Bdata%3AcopyFromTo%5D%27%20response%20headersStart%20%28%28%27_http_body_start%27%20response%29%20%2B%202%29%29%0A%7D%0A%0Ato%20%27_http_status%27%20response%20%7B%0A%20%20return%20%28%28%27%5Bdata%3AcopyFromTo%5D%27%20%28%27_http_status_text%27%20response%29%201%204%29%20%2B%200%29%0A%7D%0A%0Ato%20%27_http_status_text%27%20response%20%7B%0A%20%20return%20%28%27%5Bdata%3AcopyFromTo%5D%27%20response%20%28%27%5Bdata%3Afind%5D%27%20%27%20%27%20response%29%20%28%27%5Bdata%3Afind%5D%27%20%28%27_line_end%27%29%20response%29%29%0A%7D%0A%0Ato%20%27_line_end%27%20%7B%0A%20%20return%20%28%27%5Bdata%3AunicodeString%5D%27%20%28%27%5Bdata%3AmakeList%5D%27%2013%2010%29%29%0A%7D%0A%0Ato%20%27_lowercase%27%20string%20%7B%0A%20%20local%20%27lowercased%27%20%27%27%0A%20%20local%20%27char%20code%27%20%27%27%0A%20%20for%20c%20%28size%20string%29%20%7B%0A%20%20%20%20%27char%20code%27%20%3D%20%28%27%5Bdata%3AunicodeAt%5D%27%20c%20string%29%0A%20%20%20%20if%20%28and%20%28%28v%20%27char%20code%27%29%20%3E%3D%2065%29%20%28%28v%20%27char%20code%27%29%20%3C%3D%2090%29%29%20%7B%0A%20%20%20%20%20%20%27char%20code%27%20%3D%20%28%28v%20%27char%20code%27%29%20%2B%2032%29%0A%20%20%20%20%7D%0A%20%20%20%20lowercased%20%3D%20%28%27%5Bdata%3Ajoin%5D%27%20lowercased%20%28%27%5Bdata%3AunicodeString%5D%27%20%28v%20%27char%20code%27%29%29%29%0A%20%20%7D%0A%20%20return%20lowercased%0A%7D%0A%0Ato%20%27_readHTTPResponse%27%20%7B%0A%20%20local%20%27response%27%20%27%27%0A%20%20local%20%27lastChunkTime%27%20%28millisOp%29%0A%20%20repeatUntil%20%28not%20%28%27%5Bnet%3AhttpIsConnected%5D%27%29%29%20%7B%0A%20%20%20%20local%20%27chunk%27%20%28%27%5Bnet%3AhttpResponse%5D%27%29%0A%20%20%20%20if%20%28%28size%20chunk%29%20%3E%200%29%20%7B%0A%20%20%20%20%20%20response%20%3D%20%28%27%5Bdata%3Ajoin%5D%27%20response%20chunk%29%0A%20%20%20%20%20%20lastChunkTime%20%3D%20%28millisOp%29%0A%20%20%20%20%7D%20%28%28%28millisOp%29%20-%20lastChunkTime%29%20%3E%2010000%29%20%7B%0A%20%20%20%20%20%20return%20response%0A%20%20%20%20%7D%0A%20%20%20%20waitMillis%2020%0A%20%20%7D%0A%20%20response%20%3D%20%28%27%5Bdata%3Ajoin%5D%27%20response%20%28%27%5Bnet%3AhttpResponse%5D%27%29%29%0A%20%20return%20response%0A%7D%0A%0Ato%20%27_request_url%27%20url%20method%20body%20optionalPort%20%7B%0A%20%20local%20%27port%27%2080%0A%20%20if%20%28%28pushArgCount%29%20%3E%203%29%20%7B%0A%20%20%20%20port%20%3D%20optionalPort%0A%20%20%7D%0A%20%20local%20%27host%27%20%27%27%0A%20%20local%20%27path%27%20%27%27%0A%20%20local%20%27slashPosition%27%20%28%27%5Bdata%3Afind%5D%27%20%27%2F%27%20url%29%0A%20%20if%20%28slashPosition%20%3E%200%29%20%7B%0A%20%20%20%20host%20%3D%20%28%27%5Bdata%3AcopyFromTo%5D%27%20url%201%20%28slashPosition%20-%201%29%29%0A%20%20%20%20path%20%3D%20%28%27%5Bdata%3AcopyFromTo%5D%27%20url%20%28slashPosition%20%2B%201%29%29%0A%20%20%7D%20else%20%7B%0A%20%20%20%20host%20%3D%20url%0A%20%20%7D%0A%20%20if%20%28%28%27%5Bnet%3AwifiStatus%5D%27%29%20%21%3D%20%27Connected%27%29%20%7B%0A%20%20%20%20return%20%28%27%5Bdata%3Ajoin%5D%27%20%270%20Not%20Connected%27%20%28%27_line_end%27%29%29%0A%20%20%7D%0A%20%20%27%5Bnet%3AhttpConnect%5D%27%20host%20port%0A%20%20if%20%28not%20%28%27%5Bnet%3AhttpIsConnected%5D%27%29%29%20%7B%0A%20%20%20%20return%20%28%27%5Bdata%3Ajoin%5D%27%20%270%20Could%20not%20connect%20to%20server%27%20%28%27_line_end%27%29%29%0A%20%20%7D%0A%20%20%27%5Bnet%3AhttpRequest%5D%27%20method%20host%20path%0A%20%20return%20%28%27_readHTTPResponse%27%29%0A%7D%0A%0Ato%20%27http%DC%83%2F%2F%27%20url%20optionalPort%20%7B%0A%20%20local%20%27port%27%2080%0A%20%20if%20%28%28pushArgCount%29%20%3E%201%29%20%7B%0A%20%20%20%20port%20%3D%20optionalPort%0A%20%20%7D%0A%20%20local%20%27response%27%20%28%27_request_url%27%20url%20%27GET%27%20%27%27%20port%29%0A%20%20if%20%28response%20%21%3D%20%27%27%29%20%7B%0A%20%20%20%20if%20%28%28%27_http_status%27%20response%29%20%3D%3D%20200%29%20%7B%0A%20%20%20%20%20%20return%20%28%27%5Bdata%3AcopyFromTo%5D%27%20response%20%28%27_http_body_start%27%20response%29%29%0A%20%20%20%20%7D%20else%20%7B%0A%20%20%20%20%20%20return%20%28%27_http_status_text%27%20response%29%0A%20%20%20%20%7D%0A%20%20%7D%20else%20%7B%0A%20%20%20%20return%20%27Failed%20to%20get%20response%27%0A%20%20%7D%0A%7D%0A%0Ato%20request%20method%20data%20url%20optionalPort%20%7B%0A%20%20local%20%27port%27%2080%0A%20%20if%20%28%28pushArgCount%29%20%3E%203%29%20%7B%0A%20%20%20%20port%20%3D%20optionalPort%0A%20%20%7D%0A%20%20local%20%27response%27%20%28%27_request_url%27%20url%20method%20data%20port%29%0A%20%20if%20%28response%20%21%3D%20%27%27%29%20%7B%0A%20%20%20%20local%20%27status%27%20%28%27_http_status%27%20response%29%0A%20%20%20%20local%20%27body%20start%27%20%28%27_http_body_start%27%20response%29%0A%20%20%20%20if%20%28and%20%28200%20%3D%3D%20status%29%20%28%28v%20%27body%20start%27%29%20%3E%200%29%29%20%7B%0A%20%20%20%20%20%20sayIt%20%28%27%5Bdata%3AcopyFromTo%5D%27%20response%20%28v%20%27body%20start%27%29%29%0A%20%20%20%20%7D%20else%20%7B%0A%20%20%20%20%20%20sayIt%20%28%27_http_status_text%27%20response%29%0A%20%20%20%20%7D%0A%20%20%7D%20else%20%7B%0A%20%20%20%20sayIt%20%27Failed%20to%20get%20response%27%0A%20%20%7D%0A%7D%0A%0A%0Amodule%20WiFi%20Comm%0Aauthor%20MicroBlocks%0Aversion%201%205%20%0Atags%20communication%20network%20%0Adescription%20%27Connect%20to%20a%20WiFi%20network.%20Used%20in%20conjunction%20with%20other%20network%20libraries%2C%20such%20as%20HTTP%20client%2C%20HTTP%20server%20or%20Web%20Thing.%0A%27%0A%0A%20%20spec%20%27%20%27%20%27wifiConnect%27%20%27wifi%20connect%20to%20_%20password%20_%20%3A%20IP%20_%20gateway%20_%20subnet%20_%27%20%27str%20str%20auto%20auto%20auto%27%20%27Network_Name%27%20%27%27%20%27192.168.1.42%27%20%27192.168.1.1%27%20%27255.255.255.0%27%0A%20%20spec%20%27%20%27%20%27wifiCreateHotspot%27%20%27wifi%20create%20hotspot%20_%20password%20_%27%20%27str%20str%27%20%27Network_Name%27%20%27Network_Password%27%0A%20%20spec%20%27r%27%20%27getIPAddress%27%20%27IP%20address%27%0A%20%20spec%20%27r%27%20%27%5Bnet%3AmyMAC%5D%27%20%27MAC%20address%27%0A%0Ato%20getIPAddress%20%7B%0A%20%20return%20%28%27%5Bnet%3AmyIPAddress%5D%27%29%0A%7D%0A%0Ato%20wifiConnect%20ssid%20password%20fixedIP%20gatewayIP%20subnetIP%20%7B%0A%20%20if%20%28not%20%28%27%5Bnet%3AhasWiFi%5D%27%29%29%20%7Breturn%7D%0A%20%20%27%5Bnet%3AstopWiFi%5D%27%0A%20%20if%20%28%28pushArgCount%29%20%3C%205%29%20%7B%0A%20%20%20%20%27%5Bnet%3AstartWiFi%5D%27%20ssid%20password%0A%20%20%7D%20else%20%7B%0A%20%20%20%20%27%5Bnet%3AstartWiFi%5D%27%20ssid%20password%20false%20fixedIP%20gatewayIP%20subnetIP%0A%20%20%7D%0A%20%20local%20%27startMSecs%27%20%28millisOp%29%0A%20%20repeatUntil%20%28%28%27%5Bnet%3AmyIPAddress%5D%27%29%20%21%3D%20%270.0.0.0%27%29%20%7B%0A%20%20%20%20comment%20%27Timeout%20after%20N%20seconds%27%0A%20%20%20%20if%20%28%28%28millisOp%29%20-%20startMSecs%29%20%3E%2010000%29%20%7B%0A%20%20%20%20%20%20sayIt%20%27Could%20not%20connect%27%0A%20%20%20%20%20%20return%200%0A%20%20%20%20%7D%0A%20%20%20%20comment%20%27Slow%20blink%20while%20trying%20to%20connect%27%0A%20%20%20%20setUserLED%20true%0A%20%20%20%20waitMillis%20300%0A%20%20%20%20setUserLED%20false%0A%20%20%20%20waitMillis%20300%0A%20%20%7D%0A%20%20repeat%206%20%7B%0A%20%20%20%20comment%20%27Quick%20blinks%20when%20connected%27%0A%20%20%20%20setUserLED%20true%0A%20%20%20%20waitMillis%2050%0A%20%20%20%20setUserLED%20false%0A%20%20%20%20waitMillis%2050%0A%20%20%7D%0A%20%20sayIt%20%27My%20IP%20address%20is%3A%27%20%28%27%5Bnet%3AmyIPAddress%5D%27%29%0A%7D%0A%0Ato%20wifiCreateHotspot%20ssid%20password%20%7B%0A%20%20if%20%28not%20%28%27%5Bnet%3AhasWiFi%5D%27%29%29%20%7Breturn%7D%0A%20%20%27%5Bnet%3AstartWiFi%5D%27%20ssid%20password%20true%0A%20%20if%20%28%27Connected%27%20%21%3D%20%28%27%5Bnet%3AwifiStatus%5D%27%29%29%20%7B%0A%20%20%20%20sayIt%20%27Could%20not%20create%20hotspot%27%0A%20%20%20%20return%200%0A%20%20%7D%0A%20%20repeat%206%20%7B%0A%20%20%20%20comment%20%27Quick%20blinks%20when%20connected%27%0A%20%20%20%20setUserLED%20true%0A%20%20%20%20waitMillis%2050%0A%20%20%20%20setUserLED%20false%0A%20%20%20%20waitMillis%2050%0A%20%20%7D%0A%20%20sayIt%20%27My%20IP%20address%20is%3A%27%20%28%27%5Bnet%3AmyIPAddress%5D%27%29%0A%7D%0A%0A%0Amodule%20%27WiFi%20Radio%27%20Comm%0Aauthor%20MicroBlocks%0Aversion%201%200%20%0Atags%20radio%20communication%20messaging%20network%20%0Adescription%20%27This%20library%20supports%20easy%20message%20exchange%20among%20WiFi-enabled%20boards%20on%20the%20same%20network.%0A%0AA%20message%20can%20contain%20a%20string%2C%20a%20number%2C%20or%20both.%20Messages%20are%20received%20by%20all%20boards%20in%20the%20same%20radio%20group%20as%20the%20sender.%0A%0AThis%20library%20is%20similar%20to%20the%20Radio%20library%2C%20but%20messages%20are%20sent%20via%20UDP%20over%20WiFi%20instead%20of%20the%20Nordic%20radio%20system.%20Since%20UDP%20supports%20larger%20packets%2C%20this%20library%20can%20send%20longer%20strings.%0A%0AThis%20library%20can%20only%20communicate%20with%20other%20boards%20that%20support%20WiFi%3B%20it%20cannot%20interoperate%20with%20Nordic-based%20boards%20like%20the%20micro%3Abit.%0A%27%0Avariables%20_wifiRadio_Started%20_wifiRadio_group%20_wifiRadio_lastNumber%20_wifiRadio_lastString%20%0A%0A%20%20spec%20%27%20%27%20%27wifiRadio_sendNumber%27%20%27wifi%20send%20number%20_%27%20%27num%27%20123%0A%20%20spec%20%27%20%27%20%27wifiRadio_sendString%27%20%27wifi%20send%20string%20_%27%20%27str%27%20%27Hello%21%27%0A%20%20spec%20%27%20%27%20%27wifiRadio_sendPair%27%20%27wifi%20send%20pair%20_%20%3D%20_%27%20%27str%20num%27%20%27light%27%2010%0A%20%20space%0A%20%20spec%20%27r%27%20%27wifiRadio_messageReceived%27%20%27wifi%20message%20received%3F%27%0A%20%20spec%20%27r%27%20%27wifiRadio_receivedInteger%27%20%27wifi%20last%20number%27%0A%20%20spec%20%27r%27%20%27wifiRadio_receivedString%27%20%27wifi%20last%20string%27%0A%20%20space%0A%20%20spec%20%27%20%27%20%27wifiRadio_setGroup%27%20%27wifi%20set%20group%20_%20%280-255%29%27%20%27num%27%200%0A%20%20space%0A%20%20spec%20%27%20%27%20%27_wifiRadio_init%27%20%27_wifiRadio_init%27%0A%0Ato%20%27_wifiRadio_init%27%20%7B%0A%20%20comment%20%27Open%20WiFi%20Radio%20UDP%20port%20if%20necessary.%27%0A%20%20if%20%28not%20_wifiRadio_Started%29%20%7B%0A%20%20%20%20%27%5Bnet%3AudpStart%5D%27%2034567%0A%20%20%20%20_wifiRadio_group%20%3D%200%0A%20%20%20%20_wifiRadio_Started%20%3D%20true%0A%20%20%7D%0A%7D%0A%0Ato%20wifiRadio_messageReceived%20%7B%0A%20%20%27_wifiRadio_init%27%0A%20%20local%20%27msg%27%20%28%27%5Bnet%3AudpReceivePacket%5D%27%20true%29%0A%20%20if%20%28%28size%20msg%29%20%3C%208%29%20%7B%0A%20%20%20%20return%20%28booleanConstant%20false%29%0A%20%20%7D%0A%20%20if%20%28not%20%28and%20%28%28at%201%20msg%29%20%3D%3D%2077%29%20%28and%20%28%28at%202%20msg%29%20%3D%3D%2066%29%20%28%28at%203%20msg%29%20%3D%3D%2082%29%29%29%29%20%7B%0A%20%20%20%20return%20%28booleanConstant%20false%29%0A%20%20%7D%0A%20%20if%20%28%28at%204%20msg%29%20%21%3D%20_wifiRadio_group%29%20%7B%0A%20%20%20%20return%20%28booleanConstant%20false%29%0A%20%20%7D%0A%20%20_wifiRadio_lastNumber%20%3D%20%28%28at%205%20msg%29%20%7C%20%28%28%28at%206%20msg%29%20%3C%3C%208%29%20%7C%20%28%28%28at%207%20msg%29%20%3C%3C%2016%29%20%7C%20%28%28at%208%20msg%29%20%3C%3C%2024%29%29%29%29%0A%20%20_wifiRadio_lastString%20%3D%20%28%27%5Bdata%3Ajoin%5D%27%20%27%27%20%28%27%5Bdata%3AcopyFromTo%5D%27%20msg%209%29%29%0A%20%20return%20%28booleanConstant%20true%29%0A%7D%0A%0Ato%20wifiRadio_receivedInteger%20%7B%0A%20%20return%20_wifiRadio_lastNumber%0A%7D%0A%0Ato%20wifiRadio_receivedString%20%7B%0A%20%20if%20%28_wifiRadio_lastString%20%3D%3D%200%29%20%7B_wifiRadio_lastString%20%3D%20%27%27%7D%0A%20%20return%20_wifiRadio_lastString%0A%7D%0A%0Ato%20wifiRadio_sendNumber%20n%20%7B%0A%20%20wifiRadio_sendPair%20%27%27%20n%0A%7D%0A%0Ato%20wifiRadio_sendPair%20s%20n%20%7B%0A%20%20%27_wifiRadio_init%27%0A%20%20local%20%27msg%27%20%28%27%5Bdata%3AnewByteArray%5D%27%208%29%0A%20%20comment%20%27MicroBlocks%20WiFi%20Radio%20message%20format%3A%0A%20%20tag%3A%20%27%27MBR%27%27%20%283%20bytes%29%0A%20%20group%20%281%20byte%29%0A%20%20number%2C%20LSB%20%284%20bytes%29%0A%20%20utf8%20string%20datat%20%28variable%20length%29%27%0A%20%20atPut%201%20msg%2077%0A%20%20atPut%202%20msg%2066%0A%20%20atPut%203%20msg%2082%0A%20%20atPut%204%20msg%20_wifiRadio_group%0A%20%20atPut%205%20msg%20%28n%20%26%20255%29%0A%20%20atPut%206%20msg%20%28%28n%20%3E%3E%208%29%20%26%20255%29%0A%20%20atPut%207%20msg%20%28%28n%20%3E%3E%2016%29%20%26%20255%29%0A%20%20atPut%208%20msg%20%28%28n%20%3E%3E%2024%29%20%26%20255%29%0A%20%20msg%20%3D%20%28%27%5Bdata%3Ajoin%5D%27%20msg%20%28%27%5Bdata%3AasByteArray%5D%27%20s%29%29%0A%20%20comment%20%27Broadcast%20msg%20to%20the%20WiFi%20Radio%20port%20number%20on%20all%20boards%20on%20the%20WiFi%20network.%27%0A%20%20%27%5Bnet%3AudpSendPacket%5D%27%20msg%20%27255.255.255.255%27%2034567%0A%7D%0A%0Ato%20wifiRadio_sendString%20s%20%7B%0A%20%20wifiRadio_sendPair%20s%200%0A%7D%0A%0Ato%20wifiRadio_setGroup%20n%20%7B%0A%20%20%27_wifiRadio_init%27%0A%20%20_wifiRadio_group%20%3D%20n%0A%7D%0A%0A)

## Note

Most code is written by GPT4: [GPT4 translated the MicroBlocks code](https://chat.openai.com/share/86846465-edc5-4703-b25f-c726f4cde580)