import os
import sys
import setuptools
import warnings

with open("README.md", "r") as fh:
	long_description = fh.read()


if sys.argv[-1] == 'publish':
	if os.system("pip freeze | grep twine"):
		print("twine not installed.\nUse `pip install twine`.\nExiting.")
		sys.exit()
	os.system("python3 setup.py sdist bdist_wheel")
	os.system("twine upload dist/*")
	sys.exit()

def get_packages():
	warnings.warn(
		message="This package will be removed in the future.",
		category=UserWarning
	)
	return setuptools.find_packages()

setuptools.setup(
	name="model_import_export",
	version="0.1.4",
	author="Ajesh Sen Thapa",
	author_email="aj3sshh@gmail.com",
	description="Import/Export feature for django models",
	long_description=long_description,
	long_description_content_type="text/markdown",
	url="https://github.com/aj3sh/model_import_export",
	packages=setuptools.find_packages(),
	install_requires=[
		'numpy',
		'pandas',
		'python-dateutil',
		'pytz'
	],
	classifiers=[

		'Environment :: Web Environment',
		'Framework :: Django',
		'Framework :: Django :: 1.11',
		'Framework :: Django :: 2.0',
		'Framework :: Django :: 2.1',
		'Programming Language :: Python :: 3',
		'License :: OSI Approved :: MIT License',
		'Operating System :: OS Independent',
	
	],
)