# Generated by Django 2.2.6 on 2020-07-24 08:32

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_enumfield.db.fields
import xchk_core.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Repo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=500)),
                ('course', models.CharField(max_length=500)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='repos', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'course')},
            },
        ),
        migrations.CreateModel(
            name='SubmissionV2',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('checksum', models.CharField(max_length=40, null=True)),
                ('timestamp', models.DateTimeField()),
                ('state', django_enumfield.db.fields.EnumField(default=1, enum=xchk_core.models.SubmissionState)),
                ('feedback', models.TextField(blank=True, null=True)),
                ('content_uid', models.CharField(max_length=40)),
                ('repo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='xchk_core.Repo')),
                ('submitter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='FeedbackTicket',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('feedback_type', django_enumfield.db.fields.EnumField(enum=xchk_core.models.FeedbackType)),
                ('message', models.TextField()),
                ('timestamp', models.DateTimeField()),
                ('sender', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
