/*List global variables in this script for use throughout the viewers*/
let urlParamsObj = {};pageUrl = document.URL;tinyURL = '';urlParams = {};

function setUrl(url){
  const obj = { Title: 'test', Url: url };
  history.pushState(obj, obj.Title, obj.Url);
}
function baseUrl(){
  return window.location.protocol + "//" + window.location.host  + window.location.pathname;
}
function eliminateSearchUrl(){
  setUrl(baseUrl());
}
function updatePageUrl(){
  pageUrl = window.location.protocol + "//" + window.location.host  + window.location.pathname + constructUrlSearch();
}
var fullShareURL;
function TweetThis(preURL='',postURL='',openInNewTab=false,showMessageBox=true,onlyURL=false){
    updatePageUrl();
    

    $.get(
        "https://tinyurl.com/api-create.php",
        {url: pageUrl},
        function(tinyURL){
            let key = tinyURL.split('https://tinyurl.com/')[1];
            let shareURL = pageUrl.split('?')[0] + '?id='+key;
            let fullURL = preURL+shareURL+postURL;
            // console.log(fullURL);
            ga('send', 'event', mode + '-share', pageUrl, shareURL);
            console.log('shared');
            if(openInNewTab){
               let win = window.open(fullURL, '_blank');
               win.focus(); 
            }else if(showMessageBox){
                var message = `<div class="input-group-prepend" id = 'shareLinkMessageBox'>
                                <button onclick = 'copyText("shareLinkText","copiedMessageBox")'' title = 'Click to copy link to clipboard' class="py-0  fa fa-copy btn input-group-text bg-white"></button>
                                <input type="text" value="${fullURL}" id="shareLinkText" style = "max-width:70%;" class = "form-control mx-1">
                               </div>
                               <div id = 'copiedMessageBox' class = 'pl-4'</div>
                               `
               showMessage('Share link',message); 
               if(mode !== 'geeViz'){
                $('#shareLinkMessageBox').append(staticTemplates.shareButtons);
                }
            }else if(onlyURL){
              fullShareURL=fullURL
            }
            if(openInNewTab === false && !onlyURL){
              setUrl(fullURL);
            }
        }
    );
}

function copyText(element,messageBoxId) {
    var $temp = $("<input>");
    $("body").append($temp);
    var text = $('#'+element).text();
    if(text === ''){text = $('#'+element).val()}
    $temp.val(text).select();
    // $temp.setSelectionRange(0, 99999); /*For mobile devices*/
    document.execCommand("copy");
    $temp.remove();
     /* Alert the copied text */
    if(messageBoxId !== null && messageBoxId !== undefined){
      $('#'+messageBoxId).html("Copied text to clipboard");
    }
}
function parseUrlSearch(){
  // console.log(window.location.search == '')
    let urlParamsStr = window.location.search;
      console.log(urlParamsStr);
    if(urlParamsStr !== ''){
      urlParamsStr = urlParamsStr.split('?')[1].split('&');
    
      urlParamsStr.map(function(str){
        // if(str.indexOf('OBJECT---')>-1){
          // var strT = str.split('---');
          // if(urlParams[strT[1]] === undefined){
          //   urlParams[strT[1]] = {};
          // }
          // urlParams[strT[1]][strT[2].split('=')[0]] = strT[2].split('=')[1];
          // urlParams[str.split('=')[0]] = JSON.parse(decodeURIComponent(str.split('=')[1].split('OBJECT---')[1]));
        // }else{
          var decodedParam = decodeURIComponent(str.split('=')[1]);
          try{
            urlParams[str.split('=')[0]] = JSON.parse(decodedParam);
          }catch(err){
            urlParams[str.split('=')[0]] = decodedParam;
          }
          
        // }
    })}
    if(urlParams.id !== undefined){
      window.open("https://tinyurl.com/"+urlParams.id,"_self");
       if(typeof(Storage) !== "undefined"){
        localStorage.setItem("cachedID",urlParams.id);
      }
    }
    else{
      // TweetThis(null,null,false,false);
      if(typeof(Storage) !== "undefined"){
        var id = localStorage.getItem("cachedID");
        if(id !== null && id !== undefined && id !== 'null'){
          setUrl(baseUrl() + '?id='+id);
          localStorage.setItem("cachedID",null)
        }
        
      }
    }
   
}
function constructUrlSearch(){
  var outURL = '?';
  Object.keys(urlParams).map(function(p){
    outURL += p+'='+encodeURIComponent(JSON.stringify(urlParams[p]))  + '&'; 
  })
  outURL = outURL.slice(0,outURL.length-1)
  return outURL
}
/*Load global variables*/
let cachedSettingskey = 'settings';
let startYear = 1985;
let endYear = 2022;
let startJulian = 153;//190;
let endJulian = 274;//250;
let layerObj = null;
let crs = 'EPSG:5070';
let transform = [30,0,-2361915.0,0,-30,3177735.0];
let scale = null;//30;

// Query charting floating point prevision parameters
let chartPrecision = 3;
let chartDecimalProportion=0.25;

let queryObj = {},timeLapseObj = {};dashboardObj={};
let addLCMSTimeLapsesOn;
parseUrlSearch();
let initialCenter = [37.5334105816903,-105.6787109375];
let initialZoomLevel = 5;
let studyAreaSpecificPage = false;
const studyAreaDict = {
                    'USFS LCMS 1984-2020':{
                      isPilot: false,
                      name:'USFS LCMS 1984-2020',
                      center:[37.5334105816903,-105.6787109375,5],
                      crs:'EPSG:5070',
                      startYear:1985,
                      endYear:2022,
                      conusSA : 'projects/lcms-292214/assets/CONUS-Ancillary-Data/conus',
                      conusLossThresh : 0.23,
                      conusFastLossThresh : 0.29,
                      conusSlowLossThresh : 0.18,
                      conusGainThresh : 0.29,
                      akSA :  'projects/lcms-292214/assets/R10/CoastalAK/TCC_Boundary',//'projects/lcms-292214/assets/R10/CoastalAK/CoastalAK_Simple_StudyArea',
                      akLossThresh : 0.26,
                      akFastLossThresh : 0.34,
                      akSlowLossThresh : 0.17,
                      akGainThresh : 0.24,
                      lcClassDict :{1: {'modelName': 'TREES','legendName': 'Trees','color': '005e00'},
                                  2: {'modelName': 'TS-TREES','legendName': 'Tall Shrubs & Trees Mix','color': '008000'},
                                  3: {'modelName': 'SHRUBS-TRE','legendName': 'Shrubs & Trees Mix','color': '00cc00'},
                                  4: {'modelName': 'GRASS-TREE','legendName': 'Grass/Forb/Herb & Trees Mix','color': 'b3ff1a'},
                                  5: {'modelName': 'BARREN-TRE','legendName': 'Barren & Trees Mix','color': '99ff99'},
                                  6: {'modelName': 'TS','legendName': 'Tall Shrubs','color': 'b30088'},//'b30000'},
                                  7: {'modelName': 'SHRUBS','legendName': 'Shrubs','color': 'e68a00'},
                                  8: {'modelName': 'GRASS-SHRU','legendName': 'Grass/Forb/Herb & Shrubs Mix','color': 'ffad33'},
                                  9: {'modelName': 'BARREN-SHR','legendName': 'Barren & Shrubs Mix','color': 'ffe0b3'},
                                  10: {'modelName': 'GRASS','legendName': 'Grass/Forb/Herb','color': 'ffff00'},
                                  11: {'modelName': 'BARREN-GRA','legendName': 'Barren & Grass/Forb/Herb Mix','color': 'AA7700'},
                                  12: {'modelName': 'BARREN-IMP','legendName': 'Barren or Impervious','color': 'd3bf9b'},
                                  13: {'modelName': 'SNOW','legendName': 'Snow or Ice','color': 'ffffff'},
                                  14: {'modelName': 'WATER','legendName': 'Water','color': '4780f3'}},
                      luClassDict :{1: {'modelName': 'Agriculture','legendName': 'Agriculture','color': 'efff6b'},
                                2: {'modelName': 'Developed','legendName': 'Developed','color': 'ff2ff8'},
                                3: {'modelName': 'Forest','legendName': 'Forest','color': '1b9d0c'},
                                4: {'modelName': 'Non_Forest_Wetland','legendName': 'Non-Forest Wetland','color': '97ffff'},
                                5: {'modelName': 'Other','legendName': 'Other','color': 'a1a1a1'},
                                6: {'modelName': 'Rangeland','legendName': 'Rangeland or Pasture','color': 'c2b34a'}},
                      final_collections  : ['USFS/GTAC/LCMS/v2022-8'],
                      composite_collections : ['projects/lcms-tcc-shared/assets/CONUS/Composites/Composite-Collection-yesL7',
                      'projects/lcms-tcc-shared/assets/OCONUS/R10/AK/Composites/Composite-Collection',
                      'projects/lcms-tcc-shared/assets/OCONUS/R8/PR_USVI/Composites/Composite-Collection',
                      'projects/lcms-tcc-shared/assets/OCONUS/Hawaii/Composites/Composite-Collection'],
                      lt_collections: ['projects/lcms-tcc-shared/assets/CONUS/Base-Learners/LandTrendr-Collection',
                      'projects/lcms-tcc-shared/assets/OCONUS/Hawaii/Base-Learners/LandTrendr-Collection',
                      'projects/lcms-tcc-shared/assets/OCONUS/R8/PR_USVI/Base-Learners/LandTrendr-Collection',
                      'projects/lcms-tcc-shared/assets/OCONUS/R10/AK/Base-Learners/LandTrendr-Collection'],
                      ccdc_collections:['projects/lcms-292214/assets/R10/CoastalAK/Base-Learners/CCDC-Collection','projects/lcms-292214/assets/CONUS-LCMS/Base-Learners/CCDC-Collection-1984-2022','projects/lcms-292214/assets/R8/PR_USVI/Base-Learners/CCDC-Landsat-1984-2020']
                    }                        
                }

////////////////////////////////////////////////////////////////////////////////
/*Initialize parameters for loading study area when none is chosen or chached*/
let defaultStudyArea = 'USFS LCMS 1984-2020';
let studyAreaName = studyAreaDict[defaultStudyArea].name;
let longStudyAreaName = defaultStudyArea;
let cachedStudyAreaName = null;
let viewBeta = 'yes';

let lowerThresholdDecline = studyAreaDict[defaultStudyArea].lossThresh;
let upperThresholdDecline = 1.0;
let lowerThresholdRecovery = studyAreaDict[defaultStudyArea].gainThresh;
let upperThresholdRecovery = 1.0;

let lowerThresholdSlowLoss = studyAreaDict[defaultStudyArea].lossSlowThresh;
let upperThresholdSlowLoss = 1.0;
let lowerThresholdFastLoss = studyAreaDict[defaultStudyArea].lossFastThresh;
let upperThresholdFastLoss = 1.0;
if(lowerThresholdSlowLoss === undefined){lowerThresholdSlowLoss = lowerThresholdDecline}
if(lowerThresholdFastLoss === undefined){lowerThresholdFastLoss = lowerThresholdDecline} 


 
/*Set up some boundaries of different areas to zoom to*/
const clientBoundsDict = {'All':{"geodesic": false,"type": "Polygon","coordinates": [[[-169.215141654273, 71.75307977193499],
        [-169.215141654273, 15.643479915898974],
        [-63.043266654273, 15.643479915898974],
        [-63.043266654273, 71.75307977193499]]]},
                    'CONUS':{"geodesic": false,"type": "Polygon","coordinates": [[[-148.04139715349993,30.214881196707502],[-63.66639715349993,30.214881196707502],[-63.66639715349993,47.18482008797388],[-148.04139715349993,47.18482008797388],[-148.04139715349993,30.214881196707502]]]},
                    'Alaska':{"geodesic": false,"type": "Polygon","coordinates": [[[-168.91542059099993, 71.62680009186087],
        [-168.91542059099993, 52.67867842404269],
        [-129.54042059099993, 52.67867842404269],
        [-129.54042059099993, 71.62680009186087]]]},
                    'CONUS_SEAK':{"type":"Polygon","coordinates":[[[171.00872335506813,59.78242951494817],[171.00872335506813,26.87020622017523],[-53.99127664493189,26.87020622017523],[-53.99127664493189,59.78242951494817],[171.00872335506813,59.78242951494817]]]},
                    'Hawaii':{"geodesic": false,"type": "Polygon","coordinates": [[[-162.7925163471209,18.935659110261664],[-152.2511345111834,18.935659110261664],[-152.2511345111834,22.134763696750557],[-162.7925163471209,22.134763696750557],[-162.7925163471209,18.935659110261664]]]},
                    'Puerto-Rico':{"geodesic": false,"type": "Polygon","coordinates": [[[-67.98169635150003,17.751237971831113],[-65.34635089251566,17.751237971831113],[-65.34635089251566,18.532938160084615],[-67.98169635150003,18.532938160084615],[-67.98169635150003,17.751237971831113]]]},
                    'R4':{
  "geodesic": false,
  "type": "Polygon",
  "coordinates": [
    [
      [
        -120.14785145677105,
        35.00187373433839
      ],
      [
        -108.8802160007048,
        35.00187373433839
      ],
      [
        -108.8802160007048,
        45.70613418897154
      ],
      [
        -120.14785145677105,
        45.70613418897154
      ],
      [
        -120.14785145677105,
        35.00187373433839
      ]
    ]
  ]
}
         }
/*Initialize a bunch of variables*/
let toExport;
let exportArea;
let taskCount = 0;//Keeping track of the number of export tasks each session submitted
let canAddToMap = true;//Set whether addToMap function can add to the map
let canExport = false;//Set whether exports are allowed
let colorRampIndex = 1;
let NEXT_LAYER_ID = 1,layerChildID = 0;
let layerCount = 0,refreshNumber = 0;
let uri,uriName,csvName,dataTable,chartOptions,infowindow,queryGeoJSON,marker,mtbsSummaryMethod;


const selectedFeaturesJSON = {};
const selectionTracker = {};

let selectionUNID = 1;

let updateViewList = true;
let viewList = [];
let viewIndex = 0;

let outputURL;
let tableConverter = null;
let groundOverlayOn = false;

let chartIncludeDate = true,chartCollection,pixelChartCollections = {},areaChartCollections = {},queryClassDict = {},exportImage,exportVizParams,eeBoundsPoly,shapesMap;
var whichPixelChartCollection,whichAreaChartCollection;
let mouseLat,mouseLng,area = 0,distance = 0,areaPolygon,markerList = [],distancePolylineT,clickCoords,distanceUpdater;
let updateArea,updateDistance,areaPolygonObj = {},udpPolygonObj = {},udpPolygonNumber = 1,mapHammer,chartMTBS,chartMTBSByNLCD,chartMTBSByAspect;

let walkThroughAdded = false;
let distancePolyline;
const distancePolylineOptions = {
              strokeColor: '#FF0',
              icons: [{
                icon:  {
              path: 'M 0,-1 0,1',
              strokeOpacity: 1,
              scale: 4
            },
                offset: '0',
                repeat: '20px'
              }],
              strokeOpacity: 0,
              strokeWeight: 3,
              draggable: true,
              editable: true,
              geodesic:true
            };

let polyNumber = 1,polyOn = false;


const areaPolygonOptions = {
              strokeColor:'#FF0',
                fillOpacity:0.2,
              strokeOpacity: 1,
              strokeWeight: 3,
              draggable: true,
              editable: true,
              geodesic:true,
              polyNumber: polyNumber
            
            };

let userDefinedI = 1;

const udpOptions = {
          strokeColor:'#FF0',
            fillOpacity:0.2,
          strokeOpacity: 1,
          strokeWeight: 3,
          draggable: true,
          editable: true,
          geodesic:true,
          polyNumber: 1
        };
const exportAreaPolylineOptions = {
          strokeColor:'#FF0',
            fillOpacity:0.2,
          strokeOpacity: 1,
          strokeWeight: 3,
          draggable: true,
          editable: true,
          geodesic:true,
          polyNumber: 1
        };
const exportAreaPolygonOptions = {
          strokeColor:'#FF0',
            fillOpacity:0.2,
          strokeOpacity: 1,
          strokeWeight: 3,
          draggable: false,
          editable: false,
          geodesic:true,
          polyNumber: 1
        };
let exportImageDict = {};
let featureObj = {},geeRunID,outstandingGEERequests = 0,geeTileLayersDownloading = 0;

let plotDictID = 1,exportID = 1;


const unitMultiplierDict = {imperial:
{area:[10.7639,0.000247105],distance:[3.28084,0.000621371]},
metric:
{area:[1,0.0001],distance:[1,0.001]}};

const unitNameDict = {imperial:
{area:['ft<sup>2</sup>','acres'],distance:['ft','miles']},
metric:
{area:['m<sup>2</sup>','hectares'],distance:['m','km']}};


//Chart variables
let plotRadius = 15;
let plotScale = 30;

var yLabelMaxLength = 30;// Max len total per y axis label
var yLabelBreakLength = 10;// Max len per line of a given y label
var yLabelMaxLines = 5;// Max lines per y label
var yLabelFontSize = 10;// Font size of y label
var yLabelMaxTotalLines = 18;// Max lines for all y labels to avoid over-crowding 

var defaultQueryDateFormat = 'YYYY-MM-dd';//Default format for dates in query time series charts

let clickBoundsColor = '#FF0';
var areaChartFormat = 'Percentage';
const areaChartFormatDict = {'Percentage': {'mult':100,'label':'% Area'}, 'Acres': {'mult':0.000247105,'label':'Acres'}, 'Hectares': {'mult':0.0001,'label':'Hectares'}};

let areaGeoJson;
let areaChartingCount = 0;
let center;let globalChartValues;



//Chart color properties
let chartColorI = 0;
let chartColorsDict = {
  'standard':['#050','#0A0','#e6194B','#14d4f4'],
  'advanced':['#050','#0A0','#9A6324','#6f6f6f','#e6194B','#14d4f4'],
  'advancedBeta':['#050','#0A0','#9A6324','#6f6f6f','#e6194B','#14d4f4','#808','#f58231'],
  'coreLossGain':['#050','#0A0','#e6194B','#14d4f4'],
  'allLossGain':['#050','#0A0','#e6194B','#808','#f58231','#14d4f4'],
  'allLossGain2':['#050','#0A0','#0E0','f39268','d54309','00a398'],
  'allLossGain2Area':['f39268','d54309','00a398','ffbe2e'],
  'test':['#9A6324','#6f6f6f','#e6194B','#14d4f4','#880088','#f58231'],
  'testArea':['#e6194B','#14d4f4','#880088','#f58231'],
  'ancillary':['#cc0066','#660033','#9933ff','#330080','#ff3300','#47d147','#00cc99','#ff9966','#b37700']
  }

let chartColors = chartColorsDict.standard;


//Dictionary of zoom level map scales
const zoomDict = {20 : '1,128',
                19 : '2,257',
                18 : '4,514',
                17 : '9,028',
                16 : '18,056',
                15 : '36,112',
                14 : '72,224',
                13 : '144,448',
                12 : '288,892',
                11 : '577,791',
                10 : '1,155,581',
                9  : '2,311,162',
                8  : '4,622,325',
                7  : '9,244,649',
                6  : '18,489,298',
                5  : '36,978,597',
                4  : '73,957,194',
                3  : '147,914,388',
                2  : '295,828,775',
                1  : '591,657,551'}

// See https://github.com/google/earthengine-api/blob/327fd96cf4fefda30c8a0d5da62d18c1d6844ea5/javascript/src/ee.js#L76 for param info for initializing to GEE
// Allow GEE to be initialized either using a server-side proxy or an access token
if(urlParams.geeAuthProxyURL == null || urlParams.geeAuthProxyURL == undefined){
    urlParams.geeAuthProxyURL = "https://rcr-ee-proxy-2.herokuapp.com";
    
}
let authProxyAPIURL = urlParams.geeAuthProxyURL;
let geeAPIURL = "https://earthengine.googleapis.com";

if(urlParams.accessToken !== null && urlParams.accessToken !== undefined && urlParams.accessToken !== 'null' && urlParams.accessToken !== 'None'){
    authProxyAPIURL = null;
    geeAPIURL = null;
    ee.data.setAuthToken('', 'Bearer', urlParams.accessToken, 3600, [], undefined, false);
   
}
var projectID = null;
if(urlParams.projectID !== null && urlParams.projectID !== undefined && urlParams.projectID !== 'None'){
  projectID = urlParams.projectID;
}

var plotsOn = false;

/////////////////////////////////////////////////////
//Taken from: https://stackoverflow.com/questions/1669190/find-the-min-max-element-of-an-array-in-javascript
Array.prototype.max = function() {
  return Math.max.apply(null, this);
};

Array.prototype.min = function() {
  return Math.min.apply(null, this);
};
/////////////////////////////////////////////////////
//Taken from: https://stackoverflow.com/questions/196972/convert-string-to-title-case-with-javascript/6475125
String.prototype.toProperCase = function () {
    return this.replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();});
};
/////////////////////////////////////////////////////
//Taken from: https://stackoverflow.com/questions/2116558/fastest-method-to-replace-all-instances-of-a-character-in-a-string
String.prototype.replaceAll = function(str1, str2, ignore) 
{
    return this.replace(new RegExp(str1.replace(/([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g,"\\$&"),(ignore?"gi":"g")),(typeof(str2)=="string")?str2.replace(/\$/g,"$$$$"):str2);
} 
/////////////////////////////////////////////////////
// Taken from: https://stackoverflow.com/questions/586182/how-to-insert-an-item-into-an-array-at-a-specific-index-javascript
Array.prototype.insert = function(index) {
  this.splice.apply(this, [index, 0].concat(
      Array.prototype.slice.call(arguments, 1)));
  return this;
};
/////////////////////////////////////////////////////
Number.prototype.formatNumber = function(n=2){
  return this.toFixed(n).replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
}
/////////////////////////////////////////////////////
// Function that tries to find the best way of limiting precision for floating point numbers
// Will limit to the maximum of chartDecimalProportion the length of decimals or whatever chartPrecision is set to
function smartToFixed(v){
  if(Number.isInteger(v) || !isNumber(v)){
    return v;
  }else{
    let currentDecimalL = v.toString().split('.')[1].length;
    let maxToFixedL =Math.ceil(currentDecimalL*chartDecimalProportion);
    let toFixedL = Math.max(chartPrecision,maxToFixedL)
    let out = parseFloat(v.toFixed(toFixedL))
    // console.log(`${v}-${currentDecimalL}-${maxToFixedL}-${toFixedL}-${out}`)
    return out;
  }
}
////////////////////////////////////////////
// Adapted from: https://stackoverflow.com/questions/43952126/javascript-round-numeric-values-of-n-dimensional-array
function isNumber(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}

function arraySmartToFixed(array, precision=chartPrecision){
    var roundedArray = [];

    array.forEach(function round(elem){
        if(isNumber(elem)) {
            roundedArray.push(smartToFixed(elem));
        } else if(elem.constructor === Array){
            roundedArray.push(arraySmartToFixed(elem, precision));
        } else {
            roundedArray.push(elem);
        }
    })

    return roundedArray;
}
////////////////////////////////////////////
Number.prototype.round = function(n=2){
  return Math.round(this*10**n)/10**n;
}

// Taken from: https://stackoverflow.com/questions/2901102/how-to-format-a-number-with-commas-as-thousands-separators
Number.prototype.numberWithCommas = function() {
  return this.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}
String.prototype.numberWithCommas = function() {
  return this.replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

//Taken from: https://stackoverflow.com/questions/196972/convert-string-to-title-case-with-javascript 
String.prototype.toTitle = function() {
  return this.replace(/(^|\s)\S/g, function(t) { return t.toUpperCase() });
}
String.prototype.chunk = function( size) {
  return this.match(new RegExp('.{1,' + size + '}', 'g'));
}
//Function to produce monthDayNumber monthName year format date string
Date.prototype.toStringFormat = function(){
  const  months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
  const yr = this.getFullYear();
  const month = months[this.getMonth()];
  const day = this.getDate();
  return `${day} ${month} ${yr}`;
}
// Taken from: https://stackoverflow.com/questions/8619879/javascript-calculate-the-day-of-the-year-1-366
Date.prototype.dayOfYear= function(){
  var j1= new Date(this);
  j1.setMonth(0, 0);
  return Math.round((this-j1)/8.64e7);
}
//
//Taken from: https://stackoverflow.com/questions/22015684/how-do-i-zip-two-arrays-in-javascript
const zip = (a, b) => a.map((k, i) => [k, b[i]]);

//Taken from: https://stackoverflow.com/questions/11688692/how-to-create-a-list-of-unique-items-in-javascript
function unique(arr) {
    let u = {}, a = [];
    for(let i = 0, l = arr.length; i < l; ++i){
        if(!u.hasOwnProperty(arr[i])) {
            a.push(arr[i]);
            u[arr[i]] = 1;
        }
    }
    return a;
}
function auto_grow(element) {
    element.style.height = "5px";
    element.style.height = (element.scrollHeight)+"px";
}

function convertRemToPixels(rem) {    
  return rem * parseFloat(getComputedStyle(document.documentElement).fontSize);
}
function isWrapped(id){
  $(id).addClass('noWrap');
  var isWrapped = $(id)[0].scrollWidth > $(id).width();
  $(id).removeClass('noWrap');
  return isWrapped
}
function sleepFor(sleepDuration){
  var now = new Date().getTime();
  while(new Date().getTime() < now + sleepDuration){ 
      /* Do nothing */ 
  }
}
function uniqueMultiDimensional(array){
  array = array.map(r=>r.join(','));
  array =  [...new Set(array)];
  return array.map(r=>r.split(','));
}
function dict(array){
  let out = {}
  array.map(r=>out[r[0]]=r[1]);
  return out
}
////////////////////////
//Taken from: https://stackoverflow.com/questions/48719873/how-to-get-median-and-quartiles-percentiles-of-an-array-in-javascript-or-php
// sort array ascending
const asc = arr => arr.sort((a, b) => a - b);

const sum = arr => arr.reduce((a, b) => a + b, 0);

const mean = arr => sum(arr) / arr.length;

// sample standard deviation
const std = (arr) => {
    const mu = mean(arr);
    const diffArr = arr.map(a => (a - mu) ** 2);
    return Math.sqrt(sum(diffArr) / (arr.length - 1));
};

const quantile = (arr, q) => {
    const sorted = asc(arr);
    const pos = (sorted.length - 1) * q;
    const base = Math.floor(pos);
    const rest = pos - base;
    if (sorted[base + 1] !== undefined) {
        return sorted[base] + rest * (sorted[base + 1] - sorted[base]);
    } else {
        return sorted[base];
    }
};
////////////////////////
// Load a js file as code
// Taken from: https://www.educative.io/answers/how-to-dynamically-load-a-js-file-in-javascript
function loadJS(FILE_URL, async = true,callback,quiet=true) {
  let scriptEle = document.createElement("script");

  scriptEle.setAttribute("src", FILE_URL);
  scriptEle.setAttribute("type", "text/javascript");
  scriptEle.setAttribute("async", async);

  document.body.appendChild(scriptEle);

  // success event 
  scriptEle.addEventListener("load", () => {
    if(!quiet){
      console.log("File loaded");
    }
    callback()
  });
   // error event
  scriptEle.addEventListener("error", (ev) => {
    if(!quiet){
      console.log("Error on loading file", ev);
    }
    callback();
  });
}/*Templates for elements and various functions to create more pre-defined elements*/
/////////////////////////////////////////////////////////////////////
/*Provide titles to be shown for each mode*/
const  titles = {
	'LCMS-pilot': {
		    leftWords: 'LCMS',
		    centerWords: 'DATA',
		    rightWords:'EXPLORER',
		    title:'LCMS Data Explorer'
			},
    'LCMS': {
            leftWords: `LCMS`,
            centerWords: 'DATA',
            rightWords:'EXPLORER',
            title:'LCMS Data Explorer'
            },
    'lcms-base-learner': {
            leftWords: `LCMS`,
            centerWords: 'Base-Learner',
            rightWords:'EXPLORER',
            title:'LCMS Base Learner Explorer'
            },
	'Ancillary': {
		    leftWords: 'Ancillary',
		    centerWords: 'DATA',
		    rightWords:'Viewer',
		    title:'TimeSync Ancillary Data Viewer'
			},
    'LT': {
            leftWords: `LandTrendr`,
            centerWords: 'DATA',
            rightWords:'EXPLORER',
            title:'LandTrendr Data Explorer'
            },
    'MTBS': {
            leftWords: `MTBS`,
            centerWords: 'DATA',
            rightWords:'EXPLORER',
            title:'MTBS Data Explorer'
            },
    'TEST': {
            leftWords: 'TEST',
            centerWords: 'DATA',
            rightWords:'Explorer',
            title:'TEST Data Viewer'
            },
    'IDS' : {
            leftWords: 'IDS',
            centerWords: 'DATA',
            rightWords:'EXPLORER',
            title:'Insect and Disease Detection Survey Data Viewer'
            },
    'geeViz': {
            leftWords: 'geeViz',
            centerWords: 'DATA',
            rightWords:'Viewer',
            title:'geeViz Data Viewer'
            },
    'STORM': {
            leftWords: 'Storm',
            centerWords: 'Damage',
            rightWords:'Viewer',
            title:'Storm Damage Viewer'
            },
    'LAMDA': {
            leftWords: 'LAMDA',
            centerWords: 'DATA',
            rightWords:'EXPLORER',
            title:'LAMDA Data Explorer'
            },
    'lcms-dashboard': {
            leftWords: 'LCMS',
            centerWords: 'DASHBOARD',
            rightWords:'',
            title:'LCMS Dashboard'
            } ,
    'Bloom-Mapper': {
            leftWords: 'Bloom',
            centerWords: 'MAPPER',
            rightWords:'',
            title:'Bloom Mapper'
            } ,
    'TreeMap': {
                leftWords: '',
                centerWords: 'TreeMap',
                rightWords:'Explorer',
                title:'TreeMap Explorer'
                } ,    
    'sequoia-view': {
                    leftWords: 'Giant',
                    centerWords: 'Sequoia',
                    rightWords:'Viewer',
                    title:'Sequoia View'
                    } ,
}
///////////////////////////////////////////////////////////////////////
let specificAuthErrorMessages = {'LCMS':`<p>Try <a class = 'support-text' title = "A simple LCMS output viewer" href = "lcms-in-motion.html" target="_blank">this viewer</a> for a simple visualization of LCMS data products.</p>
                                <p>The <kbd>DOWNLOAD DATA</kbd> menu on the left (of this page) is still available for downloading LCMS data.</p>
                                <p>For more information on LCMS please visit the <a class = 'support-text' title = "LCMS Clearinghouse Page" href = "https://data.fs.usda.gov/geodata/rastergateway/LCMS/" target="_blank">LCMS Clearinghouse Page</a>.</p>`,
                                'MTBS':`<p>Try <a class = 'support-text' title = "MTBS Interactive Data Viewer" href = "https://www.mtbs.gov/viewer/?region=all" target="_blank">this viewer</a> for a simple MTBS product viewer.</p>`         
                                }
let specificAuthErrorMessage =specificAuthErrorMessages[mode];
if(specificAuthErrorMessage === undefined){specificAuthErrorMessage=``;}
let authErrorMessageContact =`<p>Please contact the LCMS help desk <a class = 'intro-modal-links' href = "mailto: sm.fs.lcms@usda.gov">(sm.fs.lcms@usda.gov)</a> if you have questions/comments about the ${mode} viewer or have feedback.</p>`;
if(mode==='MTBS'){
    authErrorMessageContact = `<p style = "margin-bottom:0px;">If you have any further questions about this, please <a class = 'intro-modal-links' href="https://www.mtbs.gov/contact" target="_blank" > contact us</a>.</p>`
}
//////////////////////////////////////////////////////////////////////
/*Add anything to head not already there*/
$('head').append(`<title>${titles[mode].title}</title>`);
// $('head').append(`<script type="text/javascript" src="./js/gena-gee-palettes.js"></script>`);
let topBannerParams = titles[mode];
let studyAreaDropdownLabel = `<h5 class = 'teal p-0 caret nav-link dropdown-toggle ' id = 'studyAreaDropdownLabel'>Bridger-Teton National Forest</h5> `;
/////////////////////////////////////////////////////////////////////
//Provide a bunch of templates to use for various elements
function getIntroModal(iconPath,welcomeText,topText,middleText,bottomText,loadingText='Creating map services within Google Earth Engine'){
    return `<div class="modal fade modal-full-screen-styling"  id="introModal" tabindex="-1" role="dialog" >
                <div style='max-width:700px;' class="modal-dialog" role="document">
                    <div class="modal-content text-dark modal-content-full-screen-styling" >
                       
                        <div class="modal-body" id = 'introModal-body'>
                        <button type="button" class="close m-0 ml-auto text-dark" data-dismiss="modal">&times;</button>
                            <span>
                                <img class = 'logo' src="${iconPath}"   alt="logo image">
                                <h1 id = 'intro-modal-title-banner' title="" class = '  splash-title' style="font-weight:100;font-family: 'Roboto';">${titles[mode].leftWords}<span  style="font-weight:1000;font-family: 'Roboto Black', sans-serif;"> ${titles[mode].centerWords} </span>${titles[mode].rightWords}</h1>
                            </span>
                         
                        <div style = 'block;margin-top:0.5rem;'>
                            <span  style="font-weight:bold">${welcomeText}</span>
                            ${topText}
                        </div>
                        ${middleText}
                        ${bottomText}
                        <div class = ' ml-0 m-0' id = 'intro-modal-loading-div'>
                            <p >
                              <img style="width:1.8em;" class="image-icon fa-spin mr-1" alt= "Google Earth Engine logo spinner" src="images/GEE_logo_transparent.png">
                                ${loadingText}. 
                             </p>
                        </div>
                       
                        <div class="form-check  pl-0 mt-3 mb-2">
                            <input role="option" type="checkbox" class="form-check-input" id="dontShowAgainCheckbox"   name = 'dontShowAgain' value = 'true'>
                            <label class=" text-uppercase form-check-label " for="dontShowAgainCheckbox" >Don't show again</label>
                        </div>
                    </div>
                        
                           
                        
                </div>
                </div>
            </div>`
}
const staticTemplates = {
	map:`<section aria-label="Map where all map outputs are displayed" onclick = "$('#study-area-list').hide();" class = 'map' id = 'map'> </section>`,
	mainContainer: `<main aria-label="Main container to contain all elements" class = 'container main-container' id = 'main-container'></main>`,
	sidebarLeftToggler:`<img  title = 'Click to toggle sidebar visibility' class='sidebar-toggler' src='./images/menu-hamburger_ffffff.svg' onclick = 'toggleSidebar()' >`,
    sidebarLeftContainer: `
						<nav onclick = "$('#study-area-list').hide();" class = ' col-sm-6 col-md-4 col-lg-3  sidebar  p-0 m-0 flexcroll  ' id = 'sidebar-left-container'>

					        <header id = 'sidebar-left-header'>
                                
                                </header>
                            
					        <div role="list" id = 'sidebar-left'></div>
					    </nav>`,
	geeSpinner : `<div id='summary-spinner' style='position:absolute;right:40%; bottom:40%;width:8rem;height:8rem;z-index:10000000;display:none;'><img  alt= "Google Earth Engine logo spinner" title="Background processing is occurring in Google Earth Engine" class="fa fa-spin" src="images/GEE_logo_transparent.png"  style='width:100%;height:100%'><span id = 'summary-spinner-message'></span></div>`,
    lcmsSpinner : `<div id='lcms-spinner' style='position:absolute;right:40%; bottom:40%;width:10rem;height:8rem;z-index:10000000;display:none;'><img  alt= "LCMS logo spinner" title="Background processing is occurring" class="fa fa-spin" src="./images/lcms-icon.png"  style='width:100%;height:100%'><span id = 'lcms-spinner-message'></span></div>`,
    authErrorMessage:`<p>---  Error --- Map Loading Error ---</p>
                                                              <p>Map data did not load correctly and cannot be used at this time. We apologize for this inconvenience and are working to resolve this issue.</p>
                                                              ${specificAuthErrorMessage} 
                                                              ${authErrorMessageContact}
    `,
    exportContainer:`<div class = 'py-2' id = 'export-list-container'>
                        <h5>Choose which images to export:</h5>
                        <div class = 'py-2' id="export-list"></div>
                        <hr>
                        <div class = 'pl-3'>
                            <form class="form-inline" title = 'Provide projection. Web mercator: "EPSG:4326", USGS Albers: "EPSG:5070", WGS 84 UTM Northern Hemisphere: "EPSG:326" + zone number (e.g. zone 17 would be EPSG:32617), NAD 83 UTM Northern Hemisphere: "EPSG:269" + zone number (e.g. zone 17 would be EPSG:26917) '>
                              <label for="export-crs">Projection: </label>
                              <div class="form-group pl-1">
                                <input type="text" id="export-crs" oninput = 'cacheCRS()' name="rg-from" value="EPSG:4326" class="form-control">
                              </div>
                            </form>
                            <div class = 'py-2' id = 'export-area-drawing-div'>
                                <button class = 'btn' onclick = 'selectExportArea()' title = 'Draw polygon by clicking on map. Double-click to complete polygon, press ctrl+z to undo most recent point, press Delete or Backspace to start over.'><i class="pr-1 fa fa-pencil" aria-hidden="true"></i> Draw area to download</button>
                                <a href="#" onclick = 'undoExportArea()' title = 'Click to undo last drawn point (ctrl z)'><i class="btn fa fa-undo"></i></a>
                                <a href="#" onclick = 'deleteExportArea()' title = 'Click to clear current drawing'><i class="btn fa fa-trash"></i></a>
                            </div>
                            <hr>  
                            <div class = 'pt-1 pb-3' >
                                <div id = 'export-button-div'>
                                    <button class = 'btn' onclick = 'exportImages()' title = 'Click to export selected images across selected area'><i class="pr-1 fa fa-cloud-download" aria-hidden="true"></i>Export Images</button>
                                    <button class = 'btn' onclick = 'cancelAllTasks()' title = 'Click to cancel all active exports'></i>Cancel All Exports</button>
                                </div>
                                <hr>
                                <span style = 'display:none;' class="fa-stack fa-2x py-0" id='export-spinner' title="">
						    		<img alt= "Google Earth Engine logo spinner" class="fa fa-spin fa-stack-2x" src="images/GEE_logo_transparent.png" alt="" style='width:4rem;height:4rem;'>
						   			<strong id = 'export-count'  class="fa-stack-1x" style = 'padding-top: 0.1rem;cursor:pointer;'></strong>
								</span>
                                <div id = 'export-count-div' ></div>
                            </div>  
                        </div>
                        
                    </div>`,
	topBanner:` <div id = 'title-banner' class = 'white  title-banner '>
                    <img id='title-banner-icon-left' class = 'title-banner-icon' style = 'height:1.7rem;margin-top:0.25rem;'  alt="USDA Forest Service icon" src="images/logos_usda-fs.svg">
                    <div class="vl title-banner-icon"></div>
                    <img id='title-banner-icon-right' class = 'title-banner-icon' style = 'height:1.7rem;margin-left:0.0rem;margin-right:0.1rem;margin-top:0.25rem;' >
                    <div  class='my-0 title-banner-label'>
                    ${topBannerParams.leftWords} <span class = 'gray' style="font-weight:1000;font-family: 'Roboto Black', sans-serif;">${topBannerParams.centerWords}</span> ${topBannerParams.rightWords}</div>
                </div>`,

	studyAreaDropdown:`<li   id = 'study-area-dropdown' class="nav-item dropdown navbar-dark navbar-nav nav-link p-0 col-12  "  data-toggle="dropdown">
		                <h5 href = '#' onclick = "$('#sidebar-left').show('fade');$('#study-area-list').toggle();" class = 'teal-study-area-label p-0 caret nav-link dropdown-toggle ' id='study-area-label'></h5> 
		                <div class="dropdown-menu" id="study-area-list">  
		                </div>
		            </li>`,
	placesSearchDiv:`<section id = 'search-share-div' class="input-group  text-center search-bar" '>
			            <div role='list' class="input-group-prepend">
                            <button onclick = 'getLocation()' title = 'Click to center map at your location' class=" btn input-group-text bg-white search-box pr-1 pl-2" id="get-location-button"><i class="fa fa-map-marker text-black "></i></button>
	    					<button onclick = 'TweetThis()' title = 'Click to share your current view' class=" btn input-group-text bg-white search-box pr-1 pl-2" id="share-button"><i class="fa fa-share-alt teal "></i></button>
                            <buttom class="input-group-text bg-white search-box" id="search-icon"><i class="fa fa-search text-black "></i></buttom>
	  					</div>
			            <input id = 'pac-input' class="form-control bg-white search-box" title = 'Search for places on the map' type="text" placeholder="Search Places">
                        <div class="input-group-prepend">
                            <button onclick = 'backView()' title = 'Click to go back a view' class=" btn input-group-text bg-white search-box pr-1 pl-2" id="back-view-button"><i class="fa fa-chevron-left teal "></i></button>
                            <button onclick = 'forwardView()' title = 'Click to go forward a view' style = 'border-radius: 0px 3px 3px 0px' class=" btn input-group-text bg-white search-box pr-1 pl-2" id="forward-view-button"><i class="fa fa-chevron-right teal "></i></button>
                        </div>
                    </section>
                    <p class = 'mt-0 mb-1 text-center white' style = 'display:none;font-size:1.25rem;font-weight:bold' id = 'time-lapse-year-label'></p>`,
	introModal:{'LCMS':getIntroModal('./images/lcms-icon.png',
                                    'Welcome to the Landscape Change Monitoring System (LCMS) Data Explorer!',
                                    `<p class='my-2'>
                                    This Data Explorer provides the ability to view, analyze, summarize, and download LCMS data. 
                                    </p>
                                    <div class ='my-3'> For an overview of LCMS and to find links to other LCMS Explorers, visit the
                                      <a class="intro-modal-links" href="home.html" target="_blank">LCMS Homepage.</a>
                                    </div>
                            LCMS is a remote sensing-based system for mapping and monitoring landscape change across the United States produced by the USDA Forest Service. LCMS provides a "best available" map of landscape change that leverages advances in time series-based change detection techniques, Landsat and Sentinel 2 data availability, cloud-based computing power, and big data analysis methods.

                            </p>
                            `,
                            `<div style='display:inline-block;margin-top:0.5rem;'>
                            <div style ='float:left;' title='LCMS is produced by the USDA Forest Service'>
                                <img class = 'logo' alt="USDA Forest Service icon" src="images/logos_usda-fs_bn-dk-01.svg">
                                
                            </div>
                            <div style ='float:left;'>
                                <ul class="intro-list">
                                  <li title = "The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. All operational LCMS production and support takes place at GTAC."><a class="intro-modal-links" href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">GTAC</a> Geospatial Technology and Applications Center
                                  </li>
                                  <li title = 'RedCastle Resources Inc. is the on-site contractor that has provided the technical expertise for LCMS' operational production, documentation, and delivery at GTAC.'><a class="intro-modal-links" href="https://www.redcastleresources.com/" target="_blank">RCR</a> RedCastle Resources Inc.
                                  </li>
                                  <li title = 'The Rocky Mountain Research Station provides the scientific foundation LCMS is built upon. They have been instrumental in developing and publishing the original LCMS methodology and continue to provide ongoing research and development to further improve LCMS methods.'><a class="intro-modal-links" href="https://www.fs.usda.gov/rmrs/tools/landscape-change-monitoring-system-lcms" target="_blank">RMRS</a> Rocky Mountain Research Station
                                  </li>
                                  <li title = 'LCMS utilizes Google Earth Engine for most of its data acqusition, processing, and visualization through an enterprise agreement between the USDA Forest Service and Google. In its current form, LCMS would not be possible without Google Earth Engine.'><a class="intro-modal-links" href="https://earthengine.google.com/" target="_blank">GEE</a> Google Earth Engine
                                  </li>
                                </ul>
                                
                            </div>
                        
                        </div>`,
                        `<p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
                        <div class ='my-3'>
                           <a  class = 'intro-modal-links' onclick = 'downloadTutorial()' title="Click to launch tutorial that explains how to utilize the Data Explorer">TUTORIAL</a>
                            <a class="intro-modal-links" onclick="downloadMethods('v2022-8')" title="Open in-depth LCMS v2022.8 methods documentation">LCMS METHODS</a>
                            <a  class = 'intro-modal-links'  onclick = 'openLCMSSurvey("splashScreen")' title="Click to help us learn how you use LCMS and how we can make it better">LCMS USER SURVEY</a>
                            <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK/FEEDBACK</a> 
                        </div>
                        
                        `),
            'lcms-base-learner':getIntroModal('./images/lcms-icon.png',
                                    'Welcome to the Landscape Change Monitoring System (LCMS) Base-Learner Explorer!',
                                    `<div class ='my-3'> LCMS is a landscape change detection program developed by the USDA Forest Service. For an overview of LCMS and to find links to other LCMS Explorers, visit the
                                        <a class="intro-modal-links" href="home.html" target="_blank">LCMS Homepage.</a>
                                    </div> 
                                    <p>The Base Learner application is designed to provide a visualization of the change detection algorithm outputs that are used to produce LCMS products.</p>`,
                                    `<p>In addition to the map layers, LandTrendr and CCDC outputs can be compared through charting under the <kbd>Tools</kbd> -> <kbd>Pixel Tools</kbd> and <kbd>Area Tools</kbd>
                                    </p>`,
                                    `<p>Please review this <a class = 'support-text' onclick = 'downloadMethods("v2022-8")' title = 'Open in-depth LCMS v2022.8 methods documentation'>methods document</a> for more information about how these datasets are used to create LCMS products.   
                            </p>
                            <p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
                            <div class ='my-3'>
                                <a class="intro-modal-links" onclick="downloadMethods('v2022-8')" title="Open in-depth LCMS v2022.8 methods documentation">LCMS METHODS</a>
                                <a  class = 'intro-modal-links'  onclick = 'openLCMSSurvey("splashScreen")' title="Click to help us learn how you use LCMS and how we can make it better">LCMS USER SURVEY</a>
                                <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK/FEEDBACK</a> 
                            </div>`
                ),
                'lcms-dashboard':getIntroModal('./images/lcms-icon.png',
                                    'Welcome to the Landscape Change Monitoring System (LCMS) Data Dashboard!',
                                    `<div class ='my-3'> LCMS is a landscape change detection program developed by the USDA Forest Service. For an overview of LCMS and to find links to other LCMS Explorers, visit the
                                        <a class="intro-modal-links" href="home.html" target="_blank">LCMS Homepage.</a>
                                    </div>
                                    <p>The LCMS Dashboard application is designed to provide the ability to quickly visualize and generate reports of how our landscapes are changing.</p>`,
                                    `<p>Pre-calculated summary areas are available for generating custom reports.</p>
                                    <p>Disclaimer: All summary numbers are based on modeled LCMS outputs. These tables are useful for understanding broad patterns of change on our landscape. Known as model-based inference, error margins are difficult to compute directly from the summary pixel counts. Currently, error margins are calculated from the LCMS reference sample for each year from each summary area, plus a 210km buffer. This assumes the statistical properties of the model-based and reference sample-based estimates are similar. Since this assumption is difficult to uphold, this method is still under scientific review. For details on valid statistical conclusions and understanding map error, please refer to the <a class="intro-modal-links" onclick="downloadMethods('v2022-8')" title="Open in-depth LCMS v2022.8 methods documentation">LCMS METHODS</a> document or reach out to the <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK</a>.
                                    </p>`,
                                    `<p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
                            <div class ='my-3'>
                            <a class="intro-modal-links" onclick="startTour()" title="Click to take a tour of the LCMS Dashboard's features">DASHBOARD TOUR</a>
                            <a class="intro-modal-links" onclick="downloadMethods('v2022-8')" title="Open in-depth LCMS v2022.8 methods documentation">LCMS METHODS</a>
                            <a  class = 'intro-modal-links'  onclick = 'openLCMSSurvey("splashScreen")' title="Click to help us learn how you use LCMS and how we can make it better">LCMS USER SURVEY</a>
                            <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK/FEEDBACK</a> 
                        </div>

                        </div>`,'Loading LCMS summary areas. This can take some time'
                ),
            'IDS':getIntroModal('./images/lcms-icon.png',
            'Welcome to the Landscape Change Monitoring System (LCMS) Insect and Disease Detection Survey (IDS) Explorer!',
            `<div class ='my-3'> LCMS is a landscape change detection program developed by the USDA Forest Service. For an overview of LCMS and to find links to other LCMS Explorers, visit the
                <a class="intro-modal-links" href="home.html" target="_blank">LCMS Homepage.</a>
            </div>
            <p> The Insect and Disease Explorer (IDS) application is designed to provide a visualization of the LCMS outputs alongside outputs from the USFS Forest Health Protection's <a class='intro-modal-links' href='https://www.fs.usda.gov/foresthealth/applied-sciences/mapping-reporting/detection-surveys.shtml' title = 'IDS homepage' target="_blank">Insect and Disease Detection Survey (IDS)</a>outputs.</p>
           
           <p>LCMS Change and IDS polygon data can be viewed simultaneously for each coincident year. These data can also be compared through charting under the <kbd>Tools</kbd> -> <kbd>Pixel Tools</kbd> and <kbd>Area Tools</kbd>
           </p>`,
            `
    <p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
    <div class ='my-3'>
    <a class="intro-modal-links" onclick="downloadMethods('v2022-8')" title="Open in-depth LCMS v2022.8 methods documentation">LCMS METHODS</a>
    <a  class = 'intro-modal-links'  onclick = 'openLCMSSurvey("splashScreen")' title="Click to help us learn how you use LCMS and how we can make it better">LCMS USER SURVEY</a>
    <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK/FEEDBACK</a> 
</div>`,''
)
,
            'Ancillary':`<div class="modal fade "  id="introModal" tabindex="-1" role="dialog" >
                <div class="modal-dialog modal-md " role="document">
                    <div class="modal-content text-dark" style = 'background-color:rgba(230,230,230,0.95);'>
                        <button type="button" class="close p-2 ml-auto text-dark" data-dismiss="modal">&times;</button>
                        <div class = 'modal-header'>
                            <h3 class="mb-0 ">Welcome to the TimeSync Ancillary Data Viewer!</h3>
                        </div>
                        <div class="modal-body" id = 'introModal-body'>
                            <p class="pb-2 ">This viewer is intended to provide an efficient way of looking at ancillary data to help with responses for the TimeSync tool.</p>
                        </div>
                        <div class = 'modal-footer' id = 'introModal-footer'>
                        <div class = ' ml-0' id = 'intro-modal-loading-div'>
                            <p>
                              <img style="width:1.8em;" class="image-icon fa-spin mr-1" alt= "Google Earth Engine logo spinner" src="images/GEE_logo_transparent.png">
                                Creating map services within Google Earth Engine. 
                             </p>
                        </div>
						<div class="form-check  mr-0">
                                <input role="option" type="checkbox" class="form-check-input" id="dontShowAgainCheckbox"   name = 'dontShowAgain' value = 'true'>
                                <label class=" text-uppercase form-check-label " for="dontShowAgainCheckbox" >Don't show again</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>`,
            'LT':getIntroModal('./images/lcms-icon.png',
            'Welcome to the LandTrendr Data Explorer!',
           `<li>
           <p class="pb-2 ">This tool allows for quick exploration of significant changes visible in the Landsat time series using the <a class = 'intro-modal-links' href="https://emapr.github.io/LT-GEE/" target="_blank">LandTrendr temporal segmentation algorithm</a>. While this tool can run across any area on earth, the quality of the output will be related to the availability of cloud-free Landsat observations.</p>
       </li>
       <li>
           <p class="pb-2 ">LandTrendr will run across the entire extent of the map when it is loaded. If you would like to map a different area, move to the view extent you would like to map, and then press the <kbd>Submit</kbd> button at the bottom of the <kbd>PARAMETERS</kbd> collapse menu.</p>
       </li>
        <li>
           <p class="pb-2 ">All Landsat image processing and LandTrendr algorithm application is being performed on-the-fly. This can take some time to run. If you try to run this tool across a very large extent (zoom level < 9), it may not run.</p>
       </li>`,
            `
    <p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
    <div class ='my-3'>
    <a class="intro-modal-links" href="https://emapr.github.io/LT-GEE/" target="_blank" title="Open additional LandTrendr resources">LandTrendr Guide</a>
    <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK/FEEDBACK</a> 
</div>

<div class ='my-3' title='There are additional data visualization tools available in these other sites'>Other LCMS EXPLORERS:
    <a class = 'intro-modal-links' title = "Visualize and explore LCMS final outputs" href = "index.html" target="_blank">LCMS Data Explorer</a>
    <a class = 'intro-modal-links' title = "Visualize and explore time series datasets used to create the LCMS map outputs (Includes both LandTrendr and CCDC outputs)" href = "lcms-base-learner.html" target="_blank">LCMS Base Learner Explorer</a>
    <a class = 'intro-modal-links' title = "Visualize and explore summaries of LCMS data over different areas" href = "dashboard.html" target="_blank">LCMS Dashboard</a>
    <a class = 'intro-modal-links' title = "Visualize pre-made gifs illustrating patterns of change across USFS Forests and Districts" href = "lcms-in-motion.html" target="_blank">LCMS-in-Motion</a>
    
</div>`,''
),
            'MTBS':getIntroModal('./images/mtbs-logo.png',
            'Welcome to the MTBS Data Explorer!',
            `<p class='my-2'>This tool is intended to allow for interactive exploration of the Monitoring Trends in Burn Severity (MTBS) data record.
            </p>
            <p class='my-2'>
            Monitoring Trends in Burn Severity (MTBS) is a multiagency program designed to consistently map the burn severity and perimeters of fires across all lands of the United States from 1984 and beyond. MTBS maps wildland and prescribed fires greater than 1,000 acres in the Western US and 500 acres in the Eastern US. 
    </p>
    <p class='my-2'>
    MTBS burn severity data are used to assess the impacts to landscape health and can be used to monitor trends in wildfire over time.
    </p>
    `,
    `<div style='display:inline-block;margin-top:0.5rem;'>
    <div style ='float:left;display:block' title='MTBS is jointly produced by the USDA Forest Service and USGS'>
        <img class = 'logo' alt="USDA Forest Service icon" src="images/logos_usda-fs_bn-dk-01.svg">
        <br>
        <img class = 'logo' style = 'margin-left:0.3rem;height:2.5rem;' alt="USGS icon" src="images/USGS_logo_green.svg">
    </div>
    <div style ='float:left;'>
        <ul class="intro-list">
          <li title = "The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. This Explorer was developed at GTAC.""><a class="intro-modal-links" href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">GTAC</a> Geospatial Technology and Applications Center
          </li>
          <li title = "The Earth Resources Observation and Science (EROS) Center studies land change and produce land change data products used by researchers, resource managers, and policy makers across the nation and around the world. They also operate the Landsat satellite program with NASA, and maintain the largest civilian collection of images of the Earth's land surface in existence, including tens of millions of satellite images.""><a class="intro-modal-links" href="https://www.usgs.gov/centers/eros" target="_blank">EROS</a> Earth Resources Observation and Science Center
          </li>
          <li title = "This site utilizes Google Earth Engine for most of its data acqusition, processing, and visualization through an enterprise agreement between the USDA Forest Service and Google.""><a class="intro-modal-links" href="https://earthengine.google.com/" target="_blank">GEE</a> Google Earth Engine
          </li>
        </ul>
        
    </div>

</div>`,
`<p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
<div class ='my-3'>
   <a  class = 'intro-modal-links' onclick = 'toggleWalkThroughCollapse()' title="Run interactive walk-through of the features of the MTBS Data Explorer">Run Walk-Through</a>

    <a class = "intro-modal-links" title = "Contact us" href="https://www.mtbs.gov/contact" target="_blank"  >CONTACT</a> 
</div>

`),
            'LAMDA':getIntroModal('./Icons_svg/logo_gtac_color-wt.svg',
            'Welcome to the Landscape Automated Monitoring and Detection Algorithm (LAMDA) Data Explorer!',
           `<li>
           <p class="pb-2 ">LAMDA is a near real-time landscape-scale change detection program developed by the USDA Forest Service to serve as a 'hot spot' indicator for areas where finer resolution data may be used for further investigation and to serve as an indicator of severe changes over forested regions. This application is designed to provide a visualization of LAMDA outputs.</p>
       </li>
       `,
            `
    <p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
    <div class ='my-3'>
    <a class = "intro-modal-links" title = "Publication outlining the methods used to derive these products" href = "https://www.mdpi.com/2072-4292/10/8/1184" target="_blank" >LAMDA Methods Publication</a>
    <a class="intro-modal-links" href="./lamda-downloads.html" target="_blank" title="LAMDA product download page">Download LAMDA Data</a>
    <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >HELPDESK/FEEDBACK</a> 
</div>
<div class ='my-3' title='There are additional change data visualization tools available in these other sites'>Other EXPLORERS:
    <a class = 'intro-modal-links' title = "Visualize and explore LCMS final outputs" href = "index.html" target="_blank">LCMS Data Explorer</a>
    <a class = 'intro-modal-links' title = "Visualize and explore time series datasets used to create the LCMS map outputs (Includes both LandTrendr and CCDC outputs)" href = "lcms-base-learner.html" target="_blank">LCMS Base Learner Explorer</a>
    <a class = 'intro-modal-links' title = "Visualize and explore summaries of LCMS data over different areas" href = "dashboard.html" target="_blank">LCMS Dashboard</a>
    <a class = 'intro-modal-links' title = "Visualize pre-made gifs illustrating patterns of change across USFS Forests and Districts" href = "lcms-in-motion.html" target="_blank">LCMS-in-Motion</a>
    
</div>`,''
),'sequoia-view':getIntroModal('./Icons_svg/logo_gtac_color-wt.svg',
'Welcome to the Giant Sequoia Viewer!',
`<li>
<p class="pb-2 ">This near real-time program developed by the USDA Forest Service to serve as a 'hot spot' indicator for areas where finer resolution data may be used for further investigation and to serve as an indicator of severe changes over forested regions. This application is designed to provide first cut alarm of potentially declining named Giant Sequoias and the ability to view available remote sensing image data.</p>
</li>
`,
`
<p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
<h5>For access please contact Sequoia Viewer project coordinator.</h5>
<div class ='my-3'>
<a class="intro-modal-links" onclick="startTour()" title="Click to take a tour of the ${mode}'s features">TOUR</a>
<a class = "intro-modal-links" title = "Publication outlining the methods used to derive these products" href = "https://www.mdpi.com/2072-4292/10/8/1184" target="_blank" >LAMDA Methods Publication</a>

<a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >HELPDESK/FEEDBACK</a> 
</div>
<div class ='my-3' title='There are additional change data visualization tools available in these other sites'>Other EXPLORERS:
<a class = 'intro-modal-links' title = "Visualize and explore LAMDA products" href = "lamda-downloads.html" target="_blank">LAMDA Explorer</a>


</div>`,''
),
            'STORM':getIntroModal('./Icons_svg/logo_gtac_color-wt.svg',
            'Welcome to the Storm Damage Viewer!',
            `<p class='my-2'>
                            This tool provides an interactive ability to upload storm tracks and produce modeled wind fields and tree damage. These outputs can then be downloaded for further analysis.

                            </p>`,
    `<div style='display:inline-block;margin-top:0.5rem;'>
    <div style ='float:left;display:block' title='This tool is produced by the USDA Forest Service'>
        <img class = 'logo' alt="USDA Forest Service icon" src="images/logos_usda-fs_bn-dk-01.svg">
    </div>
    <div style ='float:left;'>
        <ul class="intro-list">
          <li title = "The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. This Explorer was developed at GTAC."><a class="intro-modal-links" href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">GTAC</a> Geospatial Technology and Applications Center
          </li>
          <li title = 'The Southern Research Station provided the original methods for this data explorer.'><a class="intro-modal-links" href="https://www.srs.fs.usda.gov/" target="_blank">SRS</a> Southern Research Station
                                  </li>
            <li title = 'RedCastle Resources Inc. is the on-site contractor that has provided the technical expertise for adapting the original workflow from the SRS and developing this Viewer.'><a class="intro-modal-links" href="https://www.redcastleresources.com/" target="_blank">RCR</a> RedCastle Resources Inc.
            </li>
          <li title = 'This site utilizes Google Earth Engine for most of its data acqusition, processing, and visualization through an enterprise agreement between the USDA Forest Service and Google.'><a class="intro-modal-links" href="https://earthengine.google.com/" target="_blank">GEE</a> Google Earth Engine
          </li>
        </ul>
        
    </div>

</div>`,
`<p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>

<div class ='my-3'>
    <a class = "intro-modal-links" title = "Report highlighting a project that used this tool" href = "https://apps.fs.usda.gov/gtac/publications/2022/tree-structure-damage-impact-predictive-trees-dip-modeling-phase-ii" target="_blank" >PROJECT REPORT</a>
    <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >HELPDESK/FEEDBACK</a> 
</div>
<div class ='my-3' title='There are additional change data visualization tools available in these other sites'>Other EXPLORERS:
    <a class = 'intro-modal-links' title = "Visualize and explore LCMS final outputs" href = "index.html" target="_blank">LCMS Data Explorer</a>
    <a class = 'intro-modal-links' title = "Visualize and explore time series datasets used to create the LCMS map outputs (Includes both LandTrendr and CCDC outputs)" href = "lcms-base-learner.html" target="_blank">LCMS Base Learner Explorer</a>
    <a class = 'intro-modal-links' title = "Visualize and explore summaries of LCMS data over different areas" href = "dashboard.html" target="_blank">LCMS Dashboard</a>
    <a class = 'intro-modal-links' title = "Visualize pre-made gifs illustrating patterns of change across USFS Forests and Districts" href = "lcms-in-motion.html" target="_blank">LCMS-in-Motion</a>
    
</div>`),
'Bloom-Mapper':getIntroModal('./Icons_svg/logo_gtac_color-wt.svg',
            'Welcome to the Bloom MAPPER!',
            `<p class='my-2'>
            This prototype tool provides an interactive map with the ability to view lakes with potential cyanobacteria or algae blooms. These outputs have been created as a collaborative effort between field experts throughout Wyoming and the Geospatial Technology and Applications Center. Current methods are being tested for preliminary review. These products are not conclusive and are intended for review purposes only. 
            </p>`,
    `<div style='display:inline-block;margin-top:0.5rem;'>
    <div style ='float:left;display:block' title='Bloom mapper is a joint effort between GTAC and WY USFS partners'>
        <img class = 'logo' alt="USDA Forest Service icon" src="images/logos_usda-fs_bn-dk-01.svg">
        
       
        
    </div>
    <div style ='float:left;'>
        <ul class="intro-list">
          <li title = "The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. This Explorer was developed at GTAC."><a class="intro-modal-links" href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">GTAC</a> Geospatial Technology and Applications Center
          </li>
          
         
            <li title = 'RedCastle Resources Inc. is the on-site contractor that has provided the technical expertise for adapting the original workflow from the SRS and developing this Viewer.'><a class="intro-modal-links" href="https://www.redcastleresources.com/" target="_blank">RCR</a> RedCastle Resources Inc.
            </li>
          <li title = 'This site utilizes Google Earth Engine for most of its data acqusition, processing, and visualization through an enterprise agreement between the USDA Forest Service and Google.'><a class="intro-modal-links" href="https://earthengine.google.com/" target="_blank">GEE</a> Google Earth Engine
          </li>
        </ul>
        
    </div>
    <div class ='my-3'>
                            <a class="intro-modal-links" onclick="startTour()" title="Click to take a tour of the ${mode}'s features">TOUR</a>
                            <a class="intro-modal-links" onclick="downloadAnyMethods('./literature/Bloom_Mapper_v3_Methods_2023.pdf')" title="Open Bloom Mapper data creation methods documentation">METHODS</a>
                            <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >HELPDESK/FEEDBACK</a> 
                        </div>

</div>`,
`<p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>

`),
'TreeMap':getIntroModal('./Icons_svg/logo_gtac_color-wt.svg',
            'Welcome to the TreeMap Explorer!',
            `<p class='my-2'>
            This prototype tool provides an interactive map with the ability to view the 2016 TreeMap attributes. Source Data: Riley, Karin L.; Grenfell, Isaac C.; Finney, Mark A.; Shaw, John D. (2023). TreeMap 2016: A tree-level model of the forests of the conterminous United States circa 2016. Forest Service Research Data Archive. https://doi.org/10.2737/RDS-2021-0074. Accessed 2023-03-13. 
            </p>`,
    `<div style='display:inline-block;margin-top:0.5rem;'>
    <div style ='float:left;display:block' title='TreeMap Explorer is a joint effort between GTAC and USDA Forest Service Research'>
        <img class = 'logo' alt="USDA Forest Service icon" src="images/logos_usda-fs_bn-dk-01.svg">
        
       
        
    </div>
    <div style ='float:left;'>
        <ul class="intro-list">
          <li title = "The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. This Explorer was developed at GTAC."><a class="intro-modal-links" href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">GTAC</a> Geospatial Technology and Applications Center
          </li>
          
         
            <li title = 'RedCastle Resources Inc. is the on-site contractor that has provided the technical expertise for adapting the original workflow from the SRS and developing this Viewer.'><a class="intro-modal-links" href="https://www.redcastleresources.com/" target="_blank">RCR</a> RedCastle Resources Inc.
            </li>
          <li title = 'This site utilizes Google Earth Engine for most of its data acqusition, processing, and visualization through an enterprise agreement between the USDA Forest Service and Google.'><a class="intro-modal-links" href="https://earthengine.google.com/" target="_blank">GEE</a> Google Earth Engine
          </li>
          <li title = 'TreeMap 2016 Research Dataset source data.'><a class="intro-modal-links" href="https://data.nal.usda.gov/dataset/treemap-2016-tree-level-model-forests-conterminous-united-states-circa-2016" target="_blank">RDS</a> TreeMap 2016 Data Source
          </li>
          <li title = "The Raster Data Gateway (RDG) is the location for TreeMap attribute downloads."><a class="intro-modal-links" href="https://staging-data.fs.usda.gov/geodata/rastergateway/treemap/index.php" target="_blank">RDG</a> Download TreeMap data on the Raster Data Gateway
          </li>
        </ul>
        
    </div>
    <div class ='my-3'>
                            <a class="intro-modal-links" onclick="startTour()" title="Click to take a tour of the ${mode}'s features">TOUR</a>
                            <a class="intro-modal-links" href="https://academic.oup.com/jof/article/120/6/607/6701541" target="_blank" title="Open 2016 TreeMap documentation">METHODS</a>
                            <a class = "intro-modal-links" title = "Send us an E-mail" href = "mailto: sm.fs.gtactreemap@usda.gov" >HELPDESK/FEEDBACK</a> 
                        </div>

</div>`,
`<p>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>

`)
        },
    loadingModal:{'all':function(logoPath,word,whatIsLoading='map services within Google Earth Engine'){
                                    let logoLine= `<img class = 'logo' src="./images/${logoPath}"   alt="${mode} logo image">`;
                                    if(logoPath === '' || logoPath === null || logoPath === undefined){
                                        logoLine=``
                                    }
                                    return `<span>
                                                           ${logoLine} 
                                                            <h2 id = 'intro-modal-title-banner' title="" class = 'splash-title' style="font-weight:100;font-family: 'Roboto';">${topBannerParams.leftWords}<span  style="font-weight:1000;font-family: 'Roboto Black', sans-serif;"> ${topBannerParams.centerWords} </span> ${topBannerParams.rightWords}</h2>
                                                        </span>

                            

                        <p style = 'margin-top:1rem;'>Google Earth Engine data acquisition, processing, and visualization is possible by a USDA Forest Service enterprise agreement with Google.</p>
                <p style='font-weight:bold;margin-top:1rem;' title='Creating map services within Google Earth Engine. This can take some time. Thank you for your patience!'>
                  <img style="width:2.1em;" class="image-icon fa-spin mr-1" alt= "Google Earth Engine logo spinner" src="images/GEE_logo_transparent.png">
                    ${word} ${whatIsLoading}. This can take some time.
                  
                 </p>
                  `},
                  'geeViz':`
                <p>
                  <img style="width:2.1em;" class="image-icon fa-spin mr-1" alt= "Google Earth Engine logo spinner" src="images/GEE_logo_transparent.png">
                    Creating map services within Google Earth Engine. 
                  <br>
                   <img style="width:2.1em;" class="image-icon fa-spin mr-1" alt= "Google Earth Engine logo spinner" src="images/GEE_logo_transparent.png">
                    This can take some time. Thank you for your patience!
                   <div id = 'loading-number-box'></div>
                 </p>
                  `},
	bottomBar:`<footer class = 'bottombar'  id = 'bottombar' >
        			<span class = 'px-1'  id='current-tool-selection' title="Any tool that is currently active is shown here."></span>
        			<span id = 'gee-queue-len' class = 'px-1' style="display:none;" title="All map layers are dynamically requested from Google Earth Engine.  The number of outstanding requests is shown here.">Queue length for maps from GEE: <span id='outstanding-gee-requests'>0</span></span>
                    <span class = 'px-1' title="The number of outstanding map layers currently loading tiles.">Number of map layers loading: <span id='number-gee-tiles-downloading'>0</span></span>
                    <span title="Current location and elevation of mouse pointer and map zoom level and respective map scale" class = 'px-1'  id='current-mouse-position'  ></span>
                    <span id = 'contributor-logos' style='display:none;'> 
                        <a href="https://earthengine.google.com/" target="_blank">
                            <img src="images/GEE.png"   class = 'image-icon-bar' alt="Powered by Google Earth Engine"  href="#" title="Click to learn more about Google Earth Engine">
                        </a>
                        <a href="https://www.fs.usda.gov/" target="_blank">
                            <img src="images/usfslogo.png" class = 'image-icon-bar'  href="#"  alt= "USDA Forest Service logo" title="Click to learn more about the US Forest Service">
                        </a>
                        <a href="http://www.usda.gov" target="_blank">
                            <img src="images/usdalogo.png" class = 'image-icon-bar'  href="#"   alt= "USDA logo" title="Click to learn more about the USDA">
                        </a>
                    </span>
                </footer>`,
        dashboardResultsDiv:`<div class = 'dashboard-results-container' id = 'dashboard-results-container' style='display:none;'>
                                <div id ='dashboard-results-expander' title='Click and drag up and down to resize charts'></div>
                                <div id='dashboard-results-div22' class='bg-black dashboard-results'></div>
                            </div>`,
        dashboardHighlightsDisclaimerText:`LCMS Dashboard Disclaimer: All summary numbers are based on modeled LCMS outputs. These tables are useful for understanding broad patterns of change on our landscape. Known as model-based inference, error margins are difficult to compute directly from the summary pixel counts. Currently, error margins are calculated from the LCMS reference sample for each year from each summary area, plus a 210km buffer. This assumes the statistical properties of the model-based and reference sample-based estimates are similar. Since this assumption is difficult to uphold, this method is still under scientific review. For details on valid statistical conclusions and understanding map error, please refer to the LCMS methods document or reach out to the LCMS HELPDESK (sm.fs.lcms@usda.gov)`,
        dashboardResultsContainer:`<div id='dashboard-results-container-right' class='dashboard-highlights bg-black  col-md-6 col-lg-4 '>
        
        <div id = 'dashboard-download-button-container'>
            <button class=' dashboard-download-button ' id='dashboard-download-button' onclick='makeDashboardReport()' title='Click to download PDF report containing the summaries currently being displayed.' >
                    <i class="fa fa-download dashboard-download-icon" aria-hidden="true"></i>
                    Download Report
            </button>
        </div>
        
        <div id = 'dashboard-results-list'></div>                            
                                    </div>`,
        dashboardResultsToggler:`<img  title = 'Click to toggle results pane visibility' id = 'dashboard-results-sidebar-toggler' class='dashboard-results-toggler' src='./images/menu-hamburger_ffffff.svg' onclick = 'toggleHighlights()' >`,
        dashboardHighlightsContainer:`<div id='highlights-tables-container'>
        <ul class="nav nav-tabs px-2 highlights-table-tabs"  role="tablist" id='highlights-table-tabs'></ul>
        <div class="tab-content" id="highlights-table-divs"></div>
        <div id ='highlights-disclaimer-div' >
        <p class = 'highlights-disclaimer'>Disclaimer: All summary numbers are based on modeled LCMS outputs. These tables are useful for understanding broad patterns of change on our landscape. Known as model-based inference, error margins are difficult to compute directly from the summary pixel counts. Currently, error margins are calculated from the LCMS reference sample for each year from each summary area, plus a 210km buffer. This assumes the statistical properties of the model-based and reference sample-based estimates are similar. Since this assumption is difficult to uphold, this method is still under scientific review. For details on valid statistical conclusions and understanding map error, please refer to the <a class="teal" onclick="downloadMethods('v2022-8')" title="Open in-depth LCMS v2022.8 methods documentation">LCMS METHODS</a> document or reach out to the <a class = "teal" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK</a>.
    </p></div>
    </div>`,                          
        dashboardHighlightsDiv:`<div id='dashboard-highlights-container' class='dashboard-highlights bg-black col-sm-7 col-md-4 col-xl-3'>
        <img style='height:3rem;' title = 'Click to toggle highlights visibility' id = 'dashboard-results-sidebar-toggler' class='sidebar-toggler' src='./images/menu-hamburger_ffffff.svg' onclick = 'toggleHighlights()' >
        <p class='highlights-title highlights-div' style='' title = 'As you move the map around, summary areas that are visible will be ranked according to classes selected within the PARAMETERS menu'>Change Highlights</p>
        <div class='dashboard-download-div' id = 'download-dashboard-report-container' title='Click to download charts and tables in a single pdf report.'>
        <button class='btn dashboard-download-button' id='dashboard-download-button' onclick='makeDashboardReport()' >
          <i class="fa fa-download dashboard-download-icon" aria-hidden="true"></i>
          Download Report
          
        </button>
        
        
      </div>
      <div id = 'dashboard-results-div'>
        </div>
        <div id='highlights-tables-container'>
            <ul class="nav nav-tabs px-2 highlights-table-tabs"  role="tablist" id='highlights-table-tabs'></ul>
            <div class="tab-content" id="highlights-table-divs"></div>
            <p class = 'highlights-disclaimer'>Disclaimer: All summary numbers are based on modeled LCMS outputs. These tables are useful for understanding broad patterns of change on our landscape. Known as model-based inference, error margins are difficult to compute directly from the summary pixel counts. Currently, error margins are calculated from the LCMS reference sample for each year from each summary area, plus a 210km buffer. This assumes the statistical properties of the model-based and reference sample-based estimates are similar. Since this assumption is difficult to uphold, this method is still under scientific review. For details on valid statistical conclusions and understanding map error, please refer to the <a class="teal" onclick="downloadMethods('v2022-8')" title="Open in-depth LCMS v2022.8 methods documentation">LCMS METHODS</a> document or reach out to the <a class = "teal" title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov" >LCMS HELPDESK</a>.
            </p>
        </div>
        `,
        dashboardProgressDiv:`<div id = 'dashboard-progress-container' class='ml-3'>
        <span  style = 'display: flex;'>
        <img id = 'loading-spinner-logo' class = 'fa-spin progress-spinner' style='display:none;' src="./images/GEE_logo_transparent.png" height="${convertRemToPixels(0.8)}"  alt="GEE logo image">
        
        <div class="progressbar progress-pulse" id='highlights-progressbar' class = 'px-2' title='Percent of summary areas that have finished downloading LCMS summary data'>
            <span  style="width: 0%;">0%</span>
        </div>
        <i  onclick='clearAllSelectedDashboardFeatures()' id='erase-all-dashboard-selected' title="Click to clear all selected features from this layer" class="fa fa-eraser eraser-all" ></i>
        
        </span>
        
        
        
        </div>`,
    //     dashboardDownloadReportButton:`<div class='dashboard-download-div' id = 'download-dashboard-report-container' title='Click to download charts and tables in a single pdf report.'>
    //     <button class='btn dashboard-download-button' id='dashboard-download-button' onclick='makeDashboardReport()' >
    //       <i class="fa fa-download dashboard-download-icon" aria-hidden="true"></i>
    //       Download Report
          
    //     </button>
        
        
    //   </div>
    //  `,
        walkThroughPopup:`<div class = 'walk-through-popup'>
                            <div id = 'walk-through-popup-content' class = 'walk-through-popup-content'></div>
	                       		<hr>
		                        <div class="icon-bar py-1 ">
								  <a onclick = 'previousWalkThrough()' title = 'Previous tutorial slide'><i class="fa fa-chevron-left text-black"></i></a>
								  <a onclick = 'nextWalkThrough()'  title = 'Next tutorial slide'><i class="fa fa-chevron-right text-black"></i></a>
								  <a id = 'walk-through-popup-progress'></a>
                                  <a onclick = 'removeWalkThroughCollapse()' style = 'float:right;'  title = 'Turn off Walk-Through'><i class="fa fa-stop text-black" aria-hidden="true"></i></a>
                                </div>
						</div>`,
        studyAreaDropdownButtonEnabledTooltip:`Choose your study area`,
        studyAreaDropdownButtonDisabledTooltip:`Still waiting on previous map layer requests. Can change study area once the previous requests are finished.`,
        reRunButtonEnabledTooltip:`Once finished changing parameters, press this button to refresh map layers`,
        reRunButtonDisabledTooltip:`Still waiting on previous map layer requests. Can re-submit once the previous requests are finished.`,
        reRunButton:`<button id = 'reRun-button' onclick = 'reRun()' class = 'mb-1 ml-1 btn ' title="">Submit</button>`,
        addTimelapsesButton:`<button id = 'addTimelapses-button' onclick = 'addLCMSTimeLapses()' class = 'mb-1 ml-1 btn ' title="Add interactive time lapse of LCMS Change and Land Cover products. This will slow down the map loading">Add LCMS Time Lapses To Map</button>`,
        downloadDiv :`<div class = 'py-2'>
                        <a id = 'product-descriptions' target = '_blank'>Detailed Product Description</a>
        				<hr>
                        <label  title = 'Choose from dropdown below to download LCMS products. There can be a small delay before a download will begin, especially over slower networks.' for="downloadDropdown">Select product to download:</label>
    					<select class="form-control" id = "downloadDropdown" onchange = "downloadSelectedArea()""></select>
    				 </div>`,
        lcmsProductionDownloadDiv:`<ul id="downloadTree" class = 'pl-0 mb-0' title = 'Click through available LCMS products. Select which outputs to download, and then click the download button. Hold ctrl key to select multiples or shift to select blocks.'>
                                          <li class = 'pl-0'><span class="caret caret-down">Conterminous United States (v2022.8)</span>
                                            <ul class="nested active">
                                              <li><span class="caret">Change</span>
                                                <ul class="nested">
                                                  <li><span class="caret" title = 'Single layer summaries of what year change was mapped by LCMS serve as the foundational LCMS product that is easiest to work with in your local GIS. These are the same as the Slow Loss, Fast Loss, and Gain Year layers in the viewer.'>Summary</span>
                                                    <ul class="nested" id = 'CONUS-change-summary-downloads'></ul>
                                                  </li>
                                                  <li><span class="caret" title = 'Annual change layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the change time lapse.'>Annual</span>
                                                    <ul class="nested" id = 'CONUS-change-annual-downloads'></ul>
                                                  </li>
                                                </ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual land cover layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the land cover time lapse.'>Land Cover</span>
                                                <ul class="nested" id = 'CONUS-land_cover-annual-downloads'></ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual land use layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the land use time lapse.'>Land Use</span>
                                                <ul class="nested" id = 'CONUS-land_use-annual-downloads'></ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual QA-bits depict ancillary information about the origin of the data used to produce LCMS products.'>QA Bits</span>
                                                <ul class="nested" id = 'CONUS-qa_bits-annual-downloads'></ul>
                                              </li>
                                            </ul>
                                          </li>
                                          <li><span class="caret caret-down">Southeastern Alaska (v2022.8)</span>
                                            <ul class="nested active">
                                              <li><span class="caret">Change</span>
                                                <ul class="nested">
                                                  <li><span class="caret" title = 'Single layer summaries of what year change was mapped by LCMS serve as the foundational LCMS product that is easiest to work with in your local GIS. These are the same as the Slow Loss, Fast Loss, and Gain Year layers in the viewer.'>Summary</span>
                                                    <ul class="nested" id = 'SEAK-change-summary-downloads'></ul>
                                                  </li>
                                                  <li><span class="caret" title = 'Annual change layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the change time lapse.'>Annual</span>
                                                    <ul class="nested" id = 'SEAK-change-annual-downloads'></ul>
                                                  </li>
                                                </ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual land cover layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the land cover time lapse.'>Land Cover</span>
                                                <ul class="nested" id = 'SEAK-land_cover-annual-downloads'></ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual land use layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the land use time lapse.'>Land Use</span>
                                                <ul class="nested" id = 'SEAK-land_use-annual-downloads'></ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual QA-bits depict ancillary information about the origin of the data used to produce LCMS products.'>QA Bits</span>
                                                <ul class="nested" id = 'SEAK-qa_bits-annual-downloads'></ul>
                                              </li>
                                            </ul>
                                          </li>
                                          <li><span class="caret caret-down">Puerto Rico - US Virgin Islands (v2020.6)</span>
                                            <ul class="nested active">
                                              <li><span class="caret">Change</span>
                                                <ul class="nested">
                                                  <li><span class="caret" title = 'Single layer summaries of what year change was mapped by LCMS serve as the foundational LCMS product that is easiest to work with in your local GIS. These are the same as the Fast Loss, and Gain Year layers in the viewer.'>Summary</span>
                                                    <ul class="nested" id = 'PRUSVI-change-summary-downloads'></ul>
                                                  </li>
                                                  <li><span class="caret" title = 'Annual change layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the change time lapse.'>Annual</span>
                                                    <ul class="nested" id = 'PRUSVI-change-annual-downloads'></ul>
                                                  </li>
                                                </ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual land cover layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the land cover time lapse.'>Land Cover</span>
                                                <ul class="nested" id = 'PRUSVI-land_cover-annual-downloads'></ul>
                                              </li>
                                              <li><span class="caret" title = 'Annual land use layers provide a more flexible product that can suite more customized data analysis. These are the same as the layers shown in the land use time lapse.'>Land Use</span>
                                                <ul class="nested" id = 'PRUSVI-land_use-annual-downloads'></ul>
                                              </li>
                                            </ul>
                                          </li>
                                        </ul>`,
        TreeMapDownloadDiv:`<ul id="downloadTree" class="pl-0 mb-0" title="Click through available TreeMap products. Select which outputs to download, and then click the download button. Hold ctrl key to select multiples or shift to select blocks.">
                                    <li class="pl-0"><span class="caret caret-down">2016</span>
                                      <ul class="nested active">
                                        <li><span class="caret" title="Download individual attributes of TreeMap.">Individual Attributes</span>
                                          <ul class="nested" id="TreeMap2016-attribute-downloads"></ul>
                                        </li>
                                        <li><span class="caret" title="Download the full TreeMap RDS.">RDS</span>
                                          <ul class="nested" id="TreeMap2016-RDS-downloads"></ul>
                                        </li>
                                      </ul>
                                    </li>
                                </ul>`,
        supportDiv :`<div  class = 'py-2 pl-3 pr-1'>
                        <header class = 'row ' title = 'Open LCMS Data Explorer tutorial'>
                            <h3 class = ' text-capitalize'>Tutorial</h3>
                        </header>
                        <div class = 'row ' title = 'Open LCMS Data Explorer tutorial'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <img class = 'support-icons' alt = 'Information icon' src = './images/information--v2.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                <a id = 'tutorial-download' class = 'links' onclick = 'downloadTutorial()'>
                                Click to launch a tutorial that explains how to utilize the Data Explorer</a>
                            </div>
                        </div>
                        <hr>
                        
                        <header class = 'row ' title = 'Click to help us learn how you use LCMS and how we can make it better'>
                        <h3 class = ' text-capitalize'>LCMS Survey</h3>
                    </header>
                    <div class = 'row ' title = 'Click to help us learn how you use LCMS and how we can make it better'>
                        <div class = 'col-lg-2 p-0 m-0'>
                            <img class = 'support-icons' alt = 'Methods icon' src = './Icons_svg/documentation_372e2c.svg'></a> 
                        </div>
                        <div class = 'col-lg-10'>
                            Click to open the LCMS Survey:
                            <li>
                            <a  class = 'intro-modal-links'  onclick = 'openLCMSSurvey("supportMenu")' title="Click to help us learn how you use LCMS and how we can make it better">SURVEY</a>
                            </li>
                             
                        </div>
                    </div>
                    <hr>
                         <header class = 'row ' title = 'Open in-depth LCMS methods documentation'>
                            <h3 class = ' text-capitalize'>LCMS Methods</h3>
                        </header>
                        <div class = 'row ' title = 'Open in-depth LCMS methods documentation'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <img class = 'support-icons' alt = 'Methods icon' src = './images/methods-icon.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                Click to open in-depth methods document:
                                <li>
                                    <a class = 'links' onclick = 'downloadMethods("v2022-8")' title = 'Open in-depth LCMS v2022.8 methods documentation'>Version 2022.8 (CONUS and SEAK)</a>
                                </li>
                                <li>
                                    <a class = 'links' onclick = 'downloadMethods("v2020-6")' title = 'Open in-depth LCMS v2020.6 methods documentation'>Version 2020.6 (PRUSVI)</a>
                                </li>   
                            </div>
                        </div>
                        <hr>
                        <header class = 'row'>
                            <h3 class = ' text-capitalize' title = "In addition to this viewer, the LCMS Homepage provides an overview of LCMS and links to other viewers to help visualize and explore other aspects of the LCMS data flow">LCMS Homepage</h3>
                        </header>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a title = "In addition to this viewer, the LCMS Homepage provides an overview of LCMS and links to other viewers to help visualize and explore other aspects of the LCMS data flow" ><img class = 'support-icons' alt = 'Email icon' src = './images/lcms-icon.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                <li>
                                    <a class = 'links' title = "An overview of LCMS" href = "home.html" target="_blank">Introduction</a>
                                </li>
                                <li>
                                    <a class = 'links' title = "Other LCMS Explorers" href = "home.html#data-explorer" target="_blank">Other Data Explorers</a>
                                </li>
                            </div>
                        </section>
                        <hr>
                        <header class = 'row'>
                            <h3 class = ' text-capitalize'>Acknowledgements</h3>
                        </header>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">
                                <img src="./images/GTAC_Logo.png" class = 'support-icons' alt="GTAC Logo"  href="#" alt = "Geospatial Technology and Applications Center logo" title="Click to learn more about the Geospatial Technology and Applications Center (GTAC)">
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">
                                    <p class = 'support-text'>The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. All operational LCMS production and support takes place at GTAC.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.redcastleresources.com/" target="_blank">
                                    <img src="images/RCR-logo.jpg"  class = 'support-icons' alt="RedCastle Inc. Logo"  href="#"   title="Click to learn more about RedCastle Resources Inc."> 
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.redcastleresources.com/" target="_blank">
                                    <p class = 'support-text'>RedCastle Resources Inc. is the on-site contractor that has provided the technical expertise for LCMS' operational production, documentation, and delivery at GTAC.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.fs.usda.gov/rmrs/tools/landscape-change-monitoring-system-lcms" target="_blank">
                                <img src="./images/usfslogo.png" class = 'support-icons' alt="USFS Logo"  href="#"  title="Click to learn more about the Rocky Mountain Research Station (RMRS)">
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.fs.usda.gov/rmrs/tools/landscape-change-monitoring-system-lcms" target="_blank">
                                    <p class = 'support-text'>The Rocky Mountain Research Station provides the scientific foundation LCMS is built upon. They have been instrumental in developing and publishing the original LCMS methodology and continue to provide ongoing research and development to further improve LCMS methods.</p>
                                </a>
                            </div>
                        </section>
                        
                        <hr>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://earthengine.google.com/" target="_blank">
                                    <img src="images/GEE_logo_transparent.png"  class = 'support-icons' alt="Google Earth Engine Logo"  href="#"   title="Click to learn more about Google Earth Engine">
                                    
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://earthengine.google.com/" target="_blank">
                                    <p class = 'support-text'>LCMS utilizes Google Earth Engine for most of its data acqusition, processing, and visualization, through an enterprise agreement between the USDA Forest Service and Google. In its current form, LCMS would not be possible without Google Earth Engine.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <h2>"..."</h2>
                            </div>
                            <div class = 'col-lg-10  support-text'>
                                    Suggested citation: 
                                    <p class = 'support-text' onclick = 'copyText("suggested-citation-text","copiedCitationMessageBox")' id = 'suggested-citation-text' title='Click to copy suggested citation to clipboard'>Forest Service, U.S. Department of Agriculture (2023). Landscape Change Monitoring System Data Explorer [Online]. Available at: https://apps.fs.usda.gov/lcms-viewer (Accessed: ${new Date().toStringFormat()}).
                                    </p>
                                    <span>
                                        <button onclick = 'copyText("suggested-citation-text","copiedCitationMessageBox")'' title = 'Click to copy suggested citation to clipboard' class="py-0 pr-1 fa fa-copy btn input-group-text bg-white" >
                                        </button>
                                        <p id = 'copiedCitationMessageBox'></p>
                                    </span>
                            </div>
                        </section>
                        <hr>
                        <header class ='row'>
                            <h3 class ='text-capitalize'>Contact</h3>
                        </header>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov"><img class = 'support-icons' alt = 'Email icon' src = './images/email.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                <a class = 'support-text' title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov">
                                Please contact the LCMS help desk <span href = "mailto: sm.fs.lcms@usda.gov">(sm.fs.lcms@usda.gov)</span> if you have questions/comments about LCMS or have feedback on the LCMS Data Explorer.</a>
                            </div>
                        </section>
        			</div>`,
                    supportDivDashboard :`<div  class = 'py-2 pl-3 pr-1'>
                        <header class = 'row ' title = 'Open LCMS Data Explorer tutorial'>
                            <h3 class = ' text-capitalize'>Tutorial</h3>
                        </header>
                        <div class = 'row ' onclick="startTour()" title="Click to take a tour of the LCMS Dashboard's features">
                            <div class = 'col-lg-2 p-0 m-0'>
                                <img class = 'support-icons' alt = 'Information icon' src = './images/information--v2.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                            <a class="intro-modal-links" onclick="startTour()" title="Click to take a tour of the LCMS Dashboard's features">DASHBOARD TOUR</a>
                            </div>
                        </div>
                        <hr>
                                                
                        <header class = 'row ' title = 'Click to help us learn how you use LCMS and how we can make it better'>
                        <h3 class = ' text-capitalize'>LCMS Survey</h3>
                    </header>
                    <div class = 'row ' title = 'Click to help us learn how you use LCMS and how we can make it better'>
                        <div class = 'col-lg-2 p-0 m-0'>
                            <img class = 'support-icons' alt = 'Methods icon' src = './Icons_svg/documentation_372e2c.svg'></a> 
                        </div>
                        <div class = 'col-lg-10'>
                            Click to open the LCMS Survey:
                            <li>
                            <a  class = 'intro-modal-links'  onclick = 'openLCMSSurvey("supportMenu")' title="Click to help us learn how you use LCMS and how we can make it better">SURVEY</a>
                            </li>
                             
                        </div>
                    </div>
                    <hr>
                         
                         <header class = 'row ' title = 'Open in-depth LCMS methods documentation'>
                            <h3 class = ' text-capitalize'>LCMS Methods</h3>
                        </header>
                        <div class = 'row ' title = 'Open in-depth LCMS methods documentation'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <img class = 'support-icons' alt = 'Methods icon' src = './images/methods-icon.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                Click to open in-depth methods document:
                                <li>
                                    <a class = 'links' onclick = 'downloadMethods("v2022-8")' title = 'Open in-depth LCMS v2022.8 methods documentation'>Version 2022.8 (CONUS and SEAK)</a>
                                </li>
                                <li>
                                    <a class = 'links' onclick = 'downloadMethods("v2020-6")' title = 'Open in-depth LCMS v2020.6 methods documentation'>Version 2020.6 (PRUSVI)</a>
                                </li>   
                            </div>
                        </div>
                        <hr>
                        <header class = 'row'>
                            <h3 class = ' text-capitalize' title = "In addition to this viewer, the LCMS Homepage provides an overview of LCMS and links to other viewers to help visualize and explore other aspects of the LCMS data flow">LCMS Homepage</h3>
                        </header>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a title = "In addition to this viewer, the LCMS Homepage provides an overview of LCMS and links to other viewers to help visualize and explore other aspects of the LCMS data flow" ><img class = 'support-icons' alt = 'LCMS icon' src = './images/lcms-icon.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                            <li>
                                <a class = 'links' title = "An overview of LCMS" href = "home.html" target="_blank">Introduction</a>
                            </li>
                            <li>
                                <a class = 'links' title = "Other LCMS Explorers" href = "home.html#data-explorer" target="_blank">Other Data Explorers</a>
                            </li>
                            </div>
                        </section>
                        <hr>
                        <header class = 'row'>
                            <h3 class = ' text-capitalize'>Acknowledgements</h3>
                        </header>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">
                                <img src="./images/GTAC_Logo.png" class = 'support-icons' alt="GTAC Logo"  href="#" alt = "Geospatial Technology and Applications Center logo" title="Click to learn more about the Geospatial Technology and Applications Center (GTAC)">
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">
                                    <p class = 'support-text'>The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. All operational LCMS production and support takes place at GTAC.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.redcastleresources.com/" target="_blank">
                                    <img src="images/RCR-logo.jpg"  class = 'support-icons' alt="RedCastle Inc. Logo"  href="#"   title="Click to learn more about RedCastle Resources Inc."> 
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.redcastleresources.com/" target="_blank">
                                    <p class = 'support-text'>RedCastle Resources Inc. is the on-site contractor that has provided the technical expertise for LCMS' operational production, documentation, and delivery at GTAC.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.fs.usda.gov/rmrs/tools/landscape-change-monitoring-system-lcms" target="_blank">
                                <img src="./images/usfslogo.png" class = 'support-icons' alt="USFS Logo"  href="#"  title="Click to learn more about the Rocky Mountain Research Station (RMRS)">
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.fs.usda.gov/rmrs/tools/landscape-change-monitoring-system-lcms" target="_blank">
                                    <p class = 'support-text'>The Rocky Mountain Research Station provides the scientific foundation LCMS is built upon. They have been instrumental in developing and publishing the original LCMS methodology and continue to provide ongoing research and development to further improve LCMS methods.</p>
                                </a>
                            </div>
                        </section>
                        
                        <hr>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://earthengine.google.com/" target="_blank">
                                    <img src="images/GEE_logo_transparent.png"  class = 'support-icons' alt="Google Earth Engine Logo"  href="#"   title="Click to learn more about Google Earth Engine">
                                    
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://earthengine.google.com/" target="_blank">
                                    <p class = 'support-text'>LCMS utilizes Google Earth Engine for most of its data acqusition, processing, and visualization, through an enterprise agreement between the USDA Forest Service and Google. In its current form, LCMS would not be possible without Google Earth Engine.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <h2>"..."</h2>
                            </div>
                            <div class = 'col-lg-10  support-text'>
                                    Suggested citation: 
                                    <p class = 'support-text' onclick = 'copyText("suggested-citation-text","copiedCitationMessageBox")' id = 'suggested-citation-text' title='Click to copy suggested citation to clipboard'>Forest Service, U.S. Department of Agriculture (2023). Landscape Change Monitoring System Dashboard [Online]. Available at: https://apps.fs.usda.gov/lcms-viewer/dashboard.html (Accessed: ${new Date().toStringFormat()}).
                                    </p>
                                    <span>
                                        <button onclick = 'copyText("suggested-citation-text","copiedCitationMessageBox")'' title = 'Click to copy suggested citation to clipboard' class="py-0 pr-1 fa fa-copy btn input-group-text bg-white" >
                                        </button>
                                        <p id = 'copiedCitationMessageBox'></p>
                                    </span>
                            </div>
                        </section>
                        <hr>
                        <header class ='row'>
                            <h3 class ='text-capitalize'>Contact</h3>
                        </header>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov"><img class = 'support-icons' alt = 'Email icon' src = './images/email.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                <a class = 'support-text' title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov">
                                Please contact the LCMS help desk <span href = "mailto: sm.fs.lcms@usda.gov">(sm.fs.lcms@usda.gov)</span> if you have questions/comments about LCMS or have feedback on the LCMS Dashboard.</a>
                            </div>
                        </section>
        			</div>`,
                    supportDivAlgal :`<div  class = 'py-2 pl-3 pr-1'>
                        <header class = 'row ' title = 'Open ${mode} tutorial'>
                            <h3 class = ' text-capitalize'>Tutorial</h3>
                        </header>
                        <div class = 'row ' onclick="startTour()" title="Click to take a tour of the ${mode}'s features">
                            <div class = 'col-lg-2 p-0 m-0'>
                                <img class = 'support-icons' alt = 'Information icon' src = './images/information--v2.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                            <a class="intro-modal-links" onclick="startTour()" title="Click to take a tour of the LCMS ${mode}'s features">${mode} TOUR</a>
                            </div>
                        </div>
                        <hr>
                         <header class = 'row ' title = 'Open in-depth ${mode} methods documentation'>
                            <h3 class = ' text-capitalize'>${mode} Methods</h3>
                        </header>
                        <div class = 'row ' title = 'Open in-depth ${mode} methods documentation'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <img class = 'support-icons' alt = 'Methods icon' src = './images/methods-icon.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                Click to open in-depth methods document:
                                <li>
                                <a class="intro-modal-links" onclick="downloadAnyMethods('./literature/Bloom_Mapper_v3_Methods_2023.pdf')" title="Open Bloom Mapper data creation methods documentation">Bloom Mapper V3 METHODS</a>
                                </li>
                            </div>
                        </div>
                        
                        <hr>
                        <header class = 'row'>
                            <h3 class = ' text-capitalize'>Acknowledgements</h3>
                        </header>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">
                                <img src="./images/GTAC_Logo.png" class = 'support-icons' alt="GTAC Logo"  href="#" alt = "Geospatial Technology and Applications Center logo" title="Click to learn more about the Geospatial Technology and Applications Center (GTAC)">
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.fs.usda.gov/about-agency/gtac" target="_blank">
                                    <p class = 'support-text'>The Geospatial Technology and Applications Center (GTAC) provides leadership in geospatial science implementation in the USDA Forest Service by delivering vital services, data products, tools, training, and innovation to solve today's land and resource management challenges. All operational LCMS production and support takes place at GTAC.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://www.redcastleresources.com/" target="_blank">
                                    <img src="images/RCR-logo.jpg"  class = 'support-icons' alt="RedCastle Inc. Logo"  href="#"   title="Click to learn more about RedCastle Resources Inc."> 
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://www.redcastleresources.com/" target="_blank">
                                    <p class = 'support-text'>RedCastle Resources Inc. is the on-site contractor that has provided the technical expertise for ${mode}'s methods development, documentation, and visualization (this viewer) at GTAC.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="" target="_blank">
                                    <img src="./images/usfslogo.png" class = 'support-icons' alt="USFS Logo"  href="#"  title="Click to learn more about our field collaborators ">
                                </a>
                                
                                <a href="" target="_blank" >
                                    <img class = 'support-icons' alt="Wyoming Department of Environmental Quality icon" src="images/WY-DEQ-Logo.png" style="margin-top: 1rem;padding-right: 0.5rem;">
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="" target="_blank">
                                    <p class = 'support-text'>
                                    USFS units in Regions 2 and 4 in Wyoming collaborated to help GTAC develop and train this tool based on actual bloom data collected by the Wyoming Department of Environmental Quality, Water Quality Division, Watershed Protection Program as part of their state-wide monitoring efforts to document the occurrence of Harmful Cyanobacterial Blooms. Thousands of lakes over ~1 acre exist on Forest system lands in Wyoming. This tool is critical in helping Forest staff focus efforts to address this public safety concern.</p>
                                </a>
                            </div>
                        </section>
                        
                        <hr>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a href="https://earthengine.google.com/" target="_blank">
                                    <img src="images/GEE_logo_transparent.png"  class = 'support-icons' alt="Google Earth Engine Logo"  href="#"   title="Click to learn more about Google Earth Engine">
                                    
                                </a>
                            </div>
                            <div class = 'col-lg-10'>
                                <a href="https://earthengine.google.com/" target="_blank">
                                    <p class = 'support-text'>${mode} utilizes Google Earth Engine for most of its data acqusition, processing, and visualization, through an enterprise agreement between the USDA Forest Service and Google. In its current form, ${mode} would not be possible without Google Earth Engine.</p>
                                </a>
                            </div>
                        </section>
                        <hr>
                        <section class = 'row'>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <h2>"..."</h2>
                            </div>
                            <div class = 'col-lg-10  support-text'>
                                    Suggested citation: 
                                    <p class = 'support-text' onclick = 'copyText("suggested-citation-text","copiedCitationMessageBox")' id = 'suggested-citation-text' title='Click to copy suggested citation to clipboard'>Forest Service, U.S. Department of Agriculture (2023). ${mode} [Online]. Available at: https://apps.fs.usda.gov/lcms-viewer/${mode}.html (Accessed: ${new Date().toStringFormat()}).
                                    </p>
                                    <span>
                                        <button onclick = 'copyText("suggested-citation-text","copiedCitationMessageBox")'' title = 'Click to copy suggested citation to clipboard' class="py-0 pr-1 fa fa-copy btn input-group-text bg-white" >
                                        </button>
                                        <p id = 'copiedCitationMessageBox'></p>
                                    </span>
                            </div>
                        </section>
                        <hr>
                        <header class ='row'>
                            <h3 class ='text-capitalize'>Contact</h3>
                        </header>
                        <section class = 'row '>
                            <div class = 'col-lg-2 p-0 m-0'>
                                <a title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov"><img class = 'support-icons' alt = 'Email icon' src = './images/email.png'></a> 
                            </div>
                            <div class = 'col-lg-10'>
                                <a class = 'support-text' title = "Send us an E-mail" href = "mailto: sm.fs.lcms@usda.gov">
                                Please contact the ${mode} help desk <span href = "mailto: sm.fs.lcms@usda.gov">(sm.fs.lcms@usda.gov)</span> if you have questions/comments about ${mode} or have feedback on the ${mode}.</a>
                            </div>
                        </section>
        			</div>`,
                    tooltipToggle:` <label class = 'mt-2'>If you turned off tool tips, but want them back:</label>
                        <button  class = 'btn  bg-black' onclick = 'showToolTipsAgain()'>Show tooltips</button>`,
        walkThroughButton:`<div >
                            <label class = 'mt-2'>Run a walk-through of the ${mode} Data Explorer's features</label>
                            <a  class = 'intro-modal-links ' onclick = 'toggleWalkThroughCollapse()' title = 'Run interactive walk-through of the features of the ${mode} Data Explorer'>Run Walk-Through</a>
                          </div>`,
        distanceDiv : `Click on map to measure distance`,
        distanceTip : "Click on map to measure distance. Press <kbd>ctrl+z</kbd> to undo most recent point. Double-click, press <kbd>Delete</kbd>, or press <kbd>Backspace</kbd> to clear measurment and start over.",
        areaDiv : `Click on map to measure area<variable-radio onclick1 = 'updateArea()' onclick2 = 'updateArea()' var='metricOrImperialArea' title2='' name2='Metric' name1='Imperial' value2='metric' value1='imperial' type='string' title='Toggle between imperial or metric units'></variable-radio>
       `,
        areaTip : "Click on map to measure area. Double-click to complete polygon, press <kbd>ctrl+z</kbd> to undo most recent point, press <kbd>Delete</kbd> or <kbd>Backspace</kbd> to start over. Any number of polygons can be defined by repeating this process.",
        queryDiv : "<div>Double-click on map to query values of displayed layers at that location</div>",
        queryTip : 'Double-click on map to query the values of the visible layers.  Only layers that are turned on will be queried.',
        pixelChartDiv : `<div>Double-click on map to query ${mode} data time series<br></div>`,
        pixelChartTip : 'Double-click on map to look at the full time series of '+mode+' outputs for a pixel.',
        userDefinedAreaChartDiv : `<div  id="user-defined" >
                                            <label>Provide name for area selected for charting (optional):</label>
                                            <input title = 'Provide a name for your chart. A default one will be provided if left blank.'  type="user-defined-area-name" class="form-control my-1" id="user-defined-area-name" placeholder="Name your charting area!" style='width:80%;'>
                                            <hr>
                                            <div>Total area selected: <i id = "user-defined-area-spinner" style = 'display:none;' class="fa fa-spinner fa-spin text-dark pl-1"></i></div>
                                            <div id = 'user-defined-features-area' class = 'select-layer-name'>0 hectares / 0 acres</div>
                                            <div id = 'user-defined-edit-toolbar'></div>
                                            <button class = 'btn' style = 'margin-bottom: 0.5em!important;' onclick = 'chartUserDefinedArea()' title = 'Click to summarize across drawn polygons'>Chart Selected Areas</button>
        		            			</div>
                                	</div>`,
        showChartButton:`<div class = 'py-2'>
                                <button onclick = "$('#chart-modal').modal()" class = 'btn bg-black' title = "If you turned off the chart, but want to show it again" >Turn on Chart</button>
                                </div>`,
        userDefinedAreaChartTip : 'Click on map to select an area to summarize '+mode+' products across. Press <kbd>ctrl+z</kbd> to undo most recent point.  Press <kbd>Delete</kbd>, or press <kbd>Backspace</kbd> to start over. Double-click to finish polygon. Any number of polygons can be defined by repeating this process. Once finished defining areas, click on the <kbd>Chart Selected Areas</kbd> button to create chart.',
        uploadAreaChartDiv : `<hr>
                                <label title = 'Powered by: https://ogre.adc4gis.com/'>Choose a zipped shapefile, kml, kmz, or geoJSON file to summarize across. Then hit "Chart across chosen file" button below to produce chart.</label>
                                <input class = 'file-input my-1' type="file" id="areaUpload" name="upload" accept=".zip,.geojson,.json,.kmz,.kml" style="display: inline-block;">
                                <hr>
                                <div id = 'upload-reduction-factor-container'></div>
                                <hr>
                                <div>Uploaded areas:</div>
                                <div id="area-charting-shp-layer-list"></div>
                                <hr>
                                <button class = 'btn' style = 'margin-bottom: 0.5em!important;' onclick = 'runShpDefinedCharting()' title = 'Click to summarize across chosen .zip shapefile, .kmz, .kml, or .geojson.'>Chart across chosen file</button>`,
        uploadShpToMapLayerDiv : `<hr>
                                <label title = 'Powered by: https://ogre.adc4gis.com/'>Choose a zipped shapefile, kml, kmz, or geoJSON file to add to the viewer for reference. Then click "Add file to viewer" button below to add the layer.</label>
                                <input class = 'file-input my-1' type="file" id="areaUpload" name="upload" accept=".zip,.geojson,.json,.kmz,.kml" style="display: inline-block;">
                                <div>Uploaded areas:</div>
                                <div id="area-charting-shp-layer-list"></div>
                                <hr>
                                <button class = 'btn' style = 'margin-bottom: 0.5em!important;' onclick = 'runShpDefinedAddLayer()' title = 'Click to add .zip shapefile, .kmz, .kml, or .geojson. Layer will appear in Reference Data.'>Add file to viewer</button>`,                        
        uploadAreaChartTip : 'Select zipped shapefile (zip into .zip all files related to the shapefile) or a single .kmz, .kml (If the .kmz or .kml has embedded pngs or any other non vector data, the conversion will likely fail), or .geojson file to summarize products across.',
        selectAreaDropdownChartDiv : `<i title="Selecting pre-defined summary areas for chosen study area" id = "select-area-spinner" class="text-dark px-2 fa fa-spin fa-spinner"></i>
                            <select class = 'form-control' style = 'width:100%;'  id='forestBoundaries' onchange='chartChosenArea()'></select>
                            <hr>`,
        selectAreaDropdownChartTip : 'Select from pre-defined areas to summarize products across.',
        selectAreaInteractiveChartDiv : `<div>Choose from layers below and click on map to select areas to include in chart</div>
                                        <hr>
                                        <label>Provide name for area selected for charting (optional):</label>
                                        <input title = 'Provide a name for your chart. A default one will be provided if left blank.'  type="user-selected-area-name" class="form-control" id="user-selected-area-name" placeholder="Name your charting area!" style='width:80%;'>
                                        <hr>
                                        <div id = 'simplify-error-range-container'></div>
                                        <hr>
                                        <div id="area-charting-select-layer-list"></div>
                                        <hr>
                                        <div>Selected areas:</div>
                                        <i id = "select-features-list-spinner" style = 'display:none;' class="fa fa-spinner fa-spin text-dark"></i>
                                        <li class = 'selected-features-list' id = 'selected-features-list'></li>
                                        <div id="area-charting-selected-layer-list"></div>
                                        <hr>
                                        <div>Total area selected: <i id = "select-features-area-spinner" style = 'display:none;' class="fa fa-spinner fa-spin text-dark pl-1"></i></div>
                                        <div id = 'selected-features-area' class = 'select-layer-name'>0 hectares / 0 acres</div>
                                        <div id = 'select-features-edit-toolbar'></div>
                                        <button class = 'btn' onclick = 'chartSelectedAreas()'>Chart Selected Areas</button>
                                        `,
        selectAreaInteractiveChartTip : 'Select from pre-defined areas on map to summarize products across.',
        shareButtons : `<!-- Email -->
                        <a title = 'Share via E-mail' onclick = 'TweetThis("mailto:?Subject=USDA Forest Service Landscape Change Monitoring System&amp;Body=I%20saw%20this%20and%20thought%20you%20might%20be%20interested.%20 ","",true)'>
                            <img class = 'image-icon-bar' src="./images/email.png" alt="Email" />
                        </a>
                        <a title = 'Share on Reddit' onclick = 'TweetThis("http://reddit.com/submit?url=","&amp;title=USDA Forest Service Landscape Change Monitoring System",true)' >
                            <img class = 'image-icon-bar' src="./images/reddit.png" alt="Reddit" />
                        </a>
                        <a title = 'Share on Twitter' onclick = 'TweetThis("https://twitter.com/share?url=","&amp;text=USDA Forest Service Landscape Change Monitoring System&amp;hashtags=USFSLCMS",true)' >
                            <img class = 'image-icon-bar' src="./images/twitter.png" alt="Twitter" />
                        </a>
                        <a  title = 'Share on Facebook' onclick = 'TweetThis("http://www.facebook.com/sharer.php?u=","",true)' >
                            <img class = 'image-icon-bar' src="./images/facebook.png" alt="Facebook" />
                        </a>`
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Go through each tip and remove kbd tag for shoing in hover titles
Object.keys(staticTemplates).filter(word => word.indexOf('Tip') > -1).map(function(t){
	let tip = staticTemplates[t].replaceAll(`<kbd>`,``);
	tip = tip.replaceAll(`</kbd>`,``);
	staticTemplates[t+'Hover'] = tip;
})
//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
//Start functions that add/remove and control elements
//////////////////////////////////////////////////////////////////////////////////////////////
//Center map on user's location
//Adapted from https://www.w3schools.com/html/html5_geolocation.asp
function getLocation() {
    if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(showPosition, showLocationError);
  }else{ 
    showMessage('Cannot acquire location','Geolocation is not supported by this browser.');
    ga('send', 'event', mode + '-getLocation', 'failure', 'failure');
  };
}
function showPosition(position) {
    const pt = {lng:position.coords.longitude,lat:position.coords.latitude};
    ga('send', 'event', mode + '-getLocation', 'success', JSON.stringify(pt));
    let locationMarker  = new google.maps.Marker({
              map: map,
              position: pt,
              icon: {
                  path: google.maps.SymbolPath.CIRCLE,
                  scale: 5,
                  strokeColor: '#FF0',
                  map: map
                }
            });
    map.setCenter(pt);
    map.setZoom(10);
    showMessage('Acquired location',"Latitude: " + position.coords.latitude + "<br>Longitude: " + position.coords.longitude);
}
function showLocationError(error){
    switch(error.code) {
    case error.PERMISSION_DENIED:
        showMessage('Cannot acquire location','User denied the request for Geolocation.');
        break;
    case error.POSITION_UNAVAILABLE:
        showMessage('Cannot acquire location','Location information is unavailable.');
        break;
    case error.TIMEOUT:
        showMessage('Cannot acquire location','The request to get user location timed out.');
        break;
    case error.UNKNOWN_ERROR:
        showMessage('Cannot acquire location','An unknown error occurred.');
        break;
  }
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to add a Bootstrap dropdown
function addDropdown(containerID,dropdownID,title,variable,tooltip){
	if(tooltip === undefined || tooltip === null){tooltip = ''}
	$('#' + containerID).append(`<div id="${dropdownID}-container" class="form-group" title="${tooltip}">
								  <label for="${dropdownID}"><p class = 'param-title'>${title}:</p></label>
								  <select class="form-control" id="${dropdownID}"></select>
								</div>`);
	  $("select#"+dropdownID).on("change", function(value) {
	  	eval(`window.${variable} = $(this).val()`);
	  });
}

//Function to add an item to a dropdown
function addDropdownItem(dropdownID,label,value,tooltip){
    if(tooltip === undefined || tooltip === null){tooltip = ''};
	$('#'+dropdownID).append(`<option class = '${dropdownID}-dropdown-item' $title = '${tooltip}' value = "${value}">${label}</option>`)
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to add a standard shape editor toolbar
function addShapeEditToolbar(containerID, toolbarID,undoFunction,restartFunction,undoTip,deleteTip){
    if(undoTip === undefined || undoTip === null){undoTip = 'Click to undo last drawn point (ctrl z)'};
    if(deleteTip === undefined || deleteTip === null){deleteTip = 'Click to clear current drawing and start a new one (Delete, or Backspace)'};
	$('#'+containerID).append(`<hr>
								    <div id = '${toolbarID}' class="icon-bar ">
								    	<a href="#" onclick = '${undoFunction}' title = '${undoTip}''><i class="btn fa fa-undo"></i></a>
									  	<a href="#" onclick = '${restartFunction}' title = '${deleteTip}'><i class="btn fa fa-trash"></i></a>
									</div>
									<hr>`);
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to set up a custom toggle radio
const setRadioValue =function(variable,value){
	console.log(value)
	window[variable] = value;
	};
function getRadio(id,label,name1,name2,variable,value1,value2){
	return `<div class = 'container'>
                <div id = '${id}-row' class = 'row'>
            		<label class="col-sm-4">${label}</label>
            		<div class = 'col-sm-8'>
                		<div  id = '${id}' class="toggle_radio">
                            <input type="radio" checked class="toggle_option first_toggle" id="first_toggle${id}" name="toggle_option" onclick="setRadioValue('${variable}','${value1}')"  >
                	       <input type="radio"  class="toggle_option second_toggle" id="second_toggle${id}" name="toggle_option" onclick="setRadioValue('${variable}','${value2}')">
                	       <label for="first_toggle${id}"><p>${name1}</p></label>
                	       <label for="second_toggle${id}"><p>${name2}</p></label>
                	       <div class="toggle_option_slider"></div>
            	        </div>
            	   </div>
        	   </div>
        	</div>`
}
//////////////////////////////////////////////////////////////////////////////////////////////
function getDiv(containerID,divID,label,variable,value){
	eval(`var ${variable} = ${value}`);
	console.log(eval(variable));
	var div = `<div id = "${divID}">${label}</div>`;
	$('#'+containerID).append(div);
	$('#'+ divID).click(function(){eval(`${variable}++`);console.log(eval(variable));$('#'+divID).append(eval(variable));})
}
//////////////////////////////////////////////////////////////////////////////////////////////
function getToggle(containerID,toggleID,onLabel,offLabel,onValue,offValue,variable,checked){
	if(checked === undefined || checked === null || checked === 'true' || checked === 'checked'){
		checked = true;
	}
	else if(checked === 'false' || checked === ''){
		checked = false;
	}

	var valueDict = {true:onValue,false:offValue};

	eval(`window.${variable} = valueDict[checked]`)
	var toggle = `<input role="option" id = "${toggleID}" class = 'p-0 m-0' type="checkbox"  data-toggle="toggle" data-on="${onLabel}" data-off="${offLabel}" data-onstyle="toggle-on" data-offstyle="toggle-off"><br>`;
	$('#'+containerID).append(toggle);
	if(checked){
		$('#'+toggleID).bootstrapToggle('on')
	}
	$('#'+containerID).click(function(){
		var value = $('#'+toggleID).prop('checked');
		console.log(value);
		eval(`window.${variable} = valueDict[${value}]`)

	})
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Provide color picker and allow updating of drawn polygons
function updateDistanceColor(jscolor) {
    distancePolylineOptions.strokeColor = '#' + jscolor;
    if(distancePolyline !== undefined){
        distancePolyline.setOptions(distancePolylineOptions);
    }
}
function updateUDPColor(jscolor) {
    udpOptions.strokeColor = '#' + jscolor;
    Object.keys(udpPolygonObj).map(function(k){
        udpPolygonObj[k].setOptions(udpOptions) ;       
    })
}
function updateAreaColor(jscolor) {
    areaPolygonOptions.strokeColor = '#' + jscolor;
    Object.keys(areaPolygonObj).map(function(k){
    	areaPolygonObj[k].setOptions(areaPolygonOptions);
    	console.log(areaPolygonObj[k])
    })
}
function addColorPicker(containerID,pickerID,updateFunction,value){
    if(value === undefined	|| value === null){value = 'FFFF00'}
	   $('#'+containerID).append(`<button id = '${pickerID}' data-toggle="tooltip" title="If needed, change the color of shape you are drawing"
							    class=" fa fa-paint-brush text-dark color-button jscolor {valueElement:null,value:'${value}',onFineChange:'${updateFunction}(this)'} "
							    ></button>`);
}

//Functions to add and change content of BS modals
function addModal(containerID,modalID,bodyOnly){
	if(bodyOnly === null || bodyOnly === undefined){bodyOnly = false};
	if(containerID === null || containerID === undefined){containerID = 'main-container'};
	if(modalID === null || modalID === undefined){modalID = 'modal-id'};
	$('#'+modalID).remove();
	if(bodyOnly){
	   $('#'+ containerID).append(`<div id = "${modalID}" class="modal fade " role="dialog">
            	<div class="modal-dialog modal-md ">
            		<div class="modal-content modal-content-not-full-screen-styling">
	            		<div style = ' border-bottom: 0 none;'class="modal-header pb-0" id ="${modalID}-header">
	            			<button style = 'float:right;' id = 'close-modal-button' type="button" class="close text-dark" data-dismiss="modal">&times;</button>
	            		</div>
	      				<div id ="${modalID}-body" class="modal-body " ></div>
        			</div>
        		</div> 
        	</div>`
        	);
	}else{
	   $('#'+ containerID).append(`
            <div id = "${modalID}" class="modal fade " role="dialog">
            	<div class="modal-dialog modal-lg ">
            		<div class="modal-content bg-black">
            		<button type="button" class="close p-2 ml-auto" data-dismiss="modal">&times;</button>
	            		<div class="modal-header py-0" id ="${modalID}-header"></div>
	      				<div id ="${modalID}-body" class="modal-body " style = 'background:#DDD;' ></div>
			          	<div class="modal-footer" id ="${modalID}-footer"></div>
        			</div>
        		</div> 
        	</div>`
        	);
	}
}
function addModalTitle(modalID,title){
	if(modalID === null || modalID === undefined){modalID = 'modal-id'};
	   $('#'+modalID+' .modal-header').prepend(`<h4 class="modal-title" id = '${modalID}-title'>${title}</h4>`);
}

function clearModal(modalID){
	if(modalID === null || modalID === undefined){modalID = 'modal-id'};
	// $('#'+modalID).empty();

	$('#'+modalID+'-title .modal-title').html('')
	$('#'+modalID+'-header').html('');
	$('#'+modalID+'-body').html('');
	$('#'+modalID+'-footer').html('');
	$('.modal').modal('hide');
	$('.modal-backdrop').remove()
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to plae a message in a BS modal and show it
function showMessage(title,message,modalID,show){
	if(title === undefined || title === null){title = ''}
	if(message === undefined || message === null){message = ''}
	if(show === undefined || show === null){show = true}
	if(modalID === undefined || modalID === null){modalID = 'error-modal'}
	
	clearModal(modalID);
	addModal('main-container',modalID,true);
    if(title !== '' && title !== undefined && title !== null){
        addModalTitle(modalID,title);
    }
	
	$('#'+modalID+'-body').append(message);
	if(show){$('#'+modalID).modal();}
};
function appendMessage2(message,modalID){
	if(message === undefined || message === null){message = ''}
	if(modalID === undefined || modalID === null){modalID = 'error-modal'}
	$('#'+modalID+'-body').append(message);
};
//////////////////////////////////////////////////////////////////////////////////////////////
//Show a basic tip BS modal
function showTip(title,message){
	
	if(localStorage.showToolTipModal == undefined || localStorage.showToolTipModal == "undefined"){
	  localStorage.showToolTipModal = 'true';
	  }
	if(localStorage.showToolTipModal === 'true' && walkThroughAdded == false){
        showMessage('','<span class = "font-weight-bold text-uppercase" >'+ title +' </span><span>' +message + '</span>','tip-modal',false)

	$('#tip-modal-body').append(`<form class="form-inline pt-3 pb-0">
								  <div class="form-check  mr-0">
                                	<input role="option" type="checkbox" class="form-check-input" id="dontShowTipAgainCheckbox"   name = 'dontShowAgain' value = 'true'>
                                	<label class=" text-uppercase form-check-label " for="dontShowTipAgainCheckbox" >Turn off tips</label>
                            		</div>
								</form>`);
	  $('#tip-modal').modal().show();
	}
	$('#dontShowTipAgainCheckbox').change(function(){
    localStorage.showToolTipModal  = !this.checked;
    if(localStorage.showToolTipModal === 'false'){$('#tooltip-radio-second_toggle_label').click();}
    else if(localStorage.showToolTipModal === 'true'){$('#tooltip-radio-first_toggle_label').click();};
    });

}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to add a given study area to the study area dropdown
function addStudyAreaToDropdown(name,toolTip){
	var id = name.replaceAll(' ','-');
	$('#study-area-list').append(`<a id = '${id}' name = '${name}' class="dropdown-item "   data-toggle="tooltip" title="${toolTip}">${name}</a>`)
  	$('#'+id).on('click',function(){
  		// $('#summary-spinner').show();
  		$('#study-area-list').hide();
        longStudyAreaName = this.name;
    	dropdownUpdateStudyArea(this.name);
    }); 
 }
 //////////////////////////////////////////////////////////////////////////////////////////////
 function addToggle(containerDivID,toggleID,title,onLabel,offLabel,on,variable,valueOn,valueOff,onChangeFunction,tooltip){
    var valueDict = {true:valueOn,false:valueOff};
    var checked;
    if(tooltip === undefined || tooltip === null){tooltip = ''}
    if(on === null || on === undefined || on === 'checked' || on === 'true'){on = true;checked = 'checked';}
    else {on = false;checked = ''};
    eval(`window.${variable} = valueDict[on];`);
    $('#'+containerDivID).append(`<div title="${tooltip}" >${title}<input  id = "${toggleID}" data-onstyle="dark" data-offstyle="light" data-style="border" role="option" type="checkbox" data-on="${onLabel}" data-off="${offLabel}"  ${checked} data-toggle="toggle" data-width="100" data-onstyle="dark" data-offstyle="light" data-style="border" data-size="small" ></div>`);
    $('#'+toggleID).change(function(){
        var value = valueDict[$('#'+toggleID).prop('checked')];
        eval(`window.${variable} = value;`);
        eval(`${onChangeFunction}`); 
    })
}
//////////////////////////////////////////////////////////////////////////////////////////////
function addRadio(containerDivID,radioID,title,onLabel,offLabel,variable,valueOn,valueOff,onFunction,offFunction,tooltip){
	eval(`window.${variable} = '${valueOn}';`);
	$('#'+containerDivID).append(`<row class = 'row' id = '${radioID}-container' title="${tooltip}">
		<p class="col-12  param-title">${title} </p>
		<div class = 'col-12 pt-0'>
    		<div  id = '#${radioID}'  class="toggle_radio p-0">
                <input type="radio" class = "first_toggle" checked class="toggle_option" id="${radioID}-first_toggle" name="${radioID}-toggle_option"  value="1" >
    	       <input type="radio" class="toggle_option second_toggle" id="${radioID}-second_toggle" name="${radioID}-toggle_option"  value="2" >
    	       <label for="${radioID}-first_toggle" id = '${radioID}-first_toggle_label'><p>${onLabel}</p></label>
    	       <label for="${radioID}-second_toggle"  id = '${radioID}-second_toggle_label'><p>${offLabel}</p></label>
    	       <div class="toggle_option_slider">
    	    </div>
	    </div>
	</div>
	</row>`);

	$('#'+radioID + '-first_toggle').change(function(){
		eval(`window.${variable} = '${valueOn}';`);
		eval(`${onFunction}`);
	})
	$('#'+radioID + '-second_toggle').change(function(){
		eval(`window.${variable} = '${valueOff}';`);
		eval(`${offFunction}`);
	})
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to set up a checkbox list
//Will set up an object under the variable name with the optionList that is updated
//Option list is formatted as {'Label 1': true, 'Label 2':false...etc}
function addCheckboxes(containerID,checkboxID,title,variable,optionList){
    $('#'+containerID).append(`<form  class = 'simple-radio' id = '${checkboxID}'><p class = 'param-title'>${title}</p></form>`);
    eval(`if(window.${variable} === undefined){window.${variable} = []}`);
    Object.keys(optionList).map(function(k){
      // console.log(k)
      const kID = k.replace(/[^A-Za-z0-9]/g, "-")
      const checkboxCheckboxID = variable+kID+ '-checkbox';
      const checkboxLabelID = variable+checkboxCheckboxID + '-label'
      if(optionList[k] === 'true'){optionList[k] = true}
      else  if(optionList[k] === 'false'){optionList[k] = false};
      let checked = optionList[k];
      optionList[k] = checked;
      if(checked){checked = 'checked';}
        else{checked = ''};
        eval(`window.${variable} = optionList`)
      $('#'+checkboxID).append(`<input  role="option" id="${checkboxCheckboxID}" type="checkbox" ${checked} value = '${k}' />
                                 <label  id="${checkboxLabelID}" style = 'margin-bottom:0px;'  for="${checkboxCheckboxID}" >${k}</label>`);

      $('#'+checkboxCheckboxID).change( function() {
                                      optionList[$(this).val()] = $(this)[0].checked;
                                      eval(`window.${variable} = optionList`)
                                      console.log('Checkbox change');console.log(optionList);
                                    });
    })
  }
//////////////////////////////////////////////////////////////////////////////////////////////
//Similar to the addCheckboxes only with radio buttons
//The variable assumes the value of the key of the object that is selected instead of the entire optionList object
//e.g. if optionList = {'hello':true,'there':false} then the variable = 'hello'
function addMultiRadio(containerID,radioID,label,variable,optionList,title){
    $('#'+containerID).append(`<form  title='${title}' class = 'simple-radio' id = '${radioID}'><p class = 'param-title'>${label}</p></form>`);

    eval(`if(window.${variable} === undefined){window.${variable} = ''};`);
    Object.keys(optionList).map(function(k){
      const kID = k.replace(/[^A-Za-z0-9]/g, "-");
      var radioCheckboxID = kID + '-checkbox';
      var radioLabelID = radioCheckboxID + '-label';
      if(optionList[k] === 'true'){optionList[k] = true}
      else  if(optionList[k] === 'false'){optionList[k] = false};
      var checked = optionList[k];
      
      if(checked){
        checked = 'checked';
        eval(`window.${variable} = "${k}"`)
      }else{checked = ''};
      
      $('#'+radioID).append(`<div class="form-check form-check-inline">
                              <input role="option" class="form-check-input" type="radio" name="inlineRadioOptions" id="${radioCheckboxID}" ${checked} value="${k}">
                              <label class="form-check-label" for="${radioCheckboxID}">${k}</label>
                            </div>`);
      $('#'+radioCheckboxID).change( function() {
                                    Object.keys(optionList).map(k=>optionList[k]=false)
                                    var v = $(this).val();
                                    optionList[v]=true;
                                    eval(`window.${variable} = "${v}"`)
                                    });
})
}
//////////////////////////////////////////////////////////////////////////////////////////////
// Function to add JSON text input widget
function addJSONInputTextBox(containerID,inputID,label,variable,defaultValue,title){
    eval(`if(window.${variable} === undefined){window.${variable} = ${JSON.stringify(defaultValue)}}`);
    $('#'+containerID).append(`
    <hr>
    <label>${label}</label>
    <textarea title='${title}' class="form-control" id="${inputID}"oninput="auto_grow(this)" style='width:90%;'>${JSON.stringify(defaultValue)}</textarea>`);

    $('#'+containerID).on('input',()=>{
      var tJSON = $(`#${inputID}`).val();
      eval(`window.${variable} = JSON.parse(tJSON)`);
     })
  }
//////////////////////////////////////////////////////////////////////////////////////////////
//Some basic formatting functions
function zeroPad(num, places) {
  var zero = places - num.toString().length + 1;
  return Array(+(zero > 0 && zero)).join("0") + num;
}
function formatDT(__dt) {
    var year = __dt.getFullYear();
    var month = zeroPad(__dt.getMonth()+1, 2);
    var date = zeroPad(__dt.getDate(), 2);
    // var hours = zeroPad(__dt.getHours(), 2);
    // var minutes = zeroPad(__dt.getMinutes(), 2);
    // var seconds = zeroPad(__dt.getSeconds(), 2);
    return   month + '/'+ date + '/'+ year.toString().slice(2,4) //+ ' ' + hours + ':' + minutes + ':' + seconds;
};
function formatDTJulian(__dt) {
    // var year = __dt.getFullYear();
    var month = zeroPad(__dt.getMonth()+1, 2);
    var date = zeroPad(__dt.getDate(), 2);
    // var hours = zeroPad(__dt.getHours(), 2);
    // var minutes = zeroPad(__dt.getMinutes(), 2);
    // var seconds = zeroPad(__dt.getSeconds(), 2);
    return  month + '/' + date ;//+ ' ' + hours + ':' + minutes + ':' + seconds;
};

Date.fromDayofYear= function(n, y){
    if(!y) y= new Date().getFullYear();
    var d= new Date(y, 0, 1);
    return new Date(d.setMonth(0, n));
}
Date.prototype.dayofYear= function(){
    var d= new Date(this.getFullYear(), 0, 0);
    return Math.floor((this-d)/8.64e+7);
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Create a dual range slider
//Possible modes are : 'date','julian',or null
//Default mode is 'date', must specify mode as null to use vanilla numbers
function setUpDualRangeSlider(var1,var2,min,max,defaultMin,defaultMax,step,sliderID,updateID,mode,slideFun,stopFun){
    // var dt_from = "2000/11/01";
  // var dt_to = "2015/11/24";
// $("#"+updateID +" .ui-slider .ui-slider-handle").css( {"width": '3px'} );
  if(mode === undefined  || mode === null){mode = 'date'};
  if(defaultMin === undefined  || defaultMin   === null){defaultMin  = min};
  if(defaultMax === undefined  || defaultMax   === null){defaultMax  = max};
  // if(step === undefined  || step === null){step = 1};

  if(mode === 'date'){
    min = new Date(min);
    max = new Date(max);
    step = step *24*60*60;
    defaultMin   = new Date(defaultMin);
    defaultMax   = new Date(defaultMax);
    // step = step*60*60*24
    $( "#"+updateID).html(formatDT(defaultMin)+ ' - ' + formatDT(defaultMax));
  }
  else if(mode === 'julian'){
    min = Date.fromDayofYear(min);
    max = Date.fromDayofYear(max);
    step = step *24*60*60;
    defaultMin = Date.fromDayofYear(defaultMin);
    defaultMax = Date.fromDayofYear(defaultMax);
    $( "#"+updateID).html(formatDTJulian(defaultMin)+ ' - ' + formatDTJulian(defaultMax));
  }
  else{$( "#"+updateID).html(defaultMin.toString()+ ' - ' + defaultMax.toString());}
  
  if(mode === 'date' || mode === 'julian'){
  var minVal = Date.parse(min)/1000;
  var maxVal = Date.parse(max)/1000;
  var minDefault = Date.parse(defaultMin)/1000;
  var maxDefault = Date.parse(defaultMax)/1000;
  }
  else{
    var minVal = min;
    var maxVal = max;
    var minDefault = defaultMin;
    var maxDefault = defaultMax;
  }

      $("#"+sliderID).slider({
        range:true,
         min: minVal,
    max: maxVal,
    step: step,
    values: [minDefault, maxDefault],

    slide: function(e,ui){

      if(mode === 'date'){
      var value1 = ui.values[0]*1000;
      var value2 = ui.values[1]*1000;

      var value1Show  = formatDT(new Date(value1));
      var value2Show  = formatDT(new Date(value2));

      // value1 = new Date(value1);
      // value2 = new Date(value2);
      $( "#"+updateID ).html(value1Show.toString() + ' - ' + value2Show.toString());
      
      eval(var1 + '= new Date('+ value1.toString()+')');
      eval(var2 + '= new Date('+ value2.toString()+')');
        }
      else if(mode === 'julian'){
      var value1 = new Date(ui.values[0]*1000);
      var value2 = new Date(ui.values[1]*1000);

      var value1Show  = formatDTJulian(value1);
      var value2Show  = formatDTJulian(value2);
      value1 =value1.dayofYear();
      value2 = value2.dayofYear();
      
    $( "#"+updateID ).html(value1Show.toString() + ' - ' + value2Show.toString());
          
          eval(var1 + '= '+ value1.toString());
          eval(var2 + '= '+ value2.toString());
            }
          else{
          var value1 = ui.values[0];
          var value2 = ui.values[1];

          var value1Show  = value1;
          var value2Show  = value2;

          $( "#"+updateID ).html(value1Show.toString() + ' - ' + value2Show.toString());
          
          eval(var1 + '= '+ value1.toString());
          eval(var2 + '= '+ value2.toString());
          }
        if(slideFun!==undefined && slideFun!== null){
            slideFun(e,ui);
        }
        },
        stop: function (e, ui) {
            if(stopFun!==undefined && stopFun!== null){
                stopFun(e,ui);
            }
    
        }
          }); 
  }
//Wrapper function to add a dual range slider
function addDualRangeSlider(containerDivID,title,var1,var2,min,max,defaultMin,defaultMax,step,sliderID,mode,tooltip,slideFun,stopFun){
	if(tooltip === null || tooltip === undefined){tooltip = ''};
	
	// setUpRangeSlider('startYear', 'endYear', 1985, 2018, startYear, endYear, 1, 'slider1', 'date-range-value1', 'null');
	$('#'+containerDivID).append(`<div  id="${sliderID}-container"class='dual-range-slider-container px-1' title="${tooltip}">
							        <div class='dual-range-slider-name pt-2 pb-3 param-title'>${title}</div>
							        <div id="${sliderID}" class='dual-range-slider-slider' href = '#'></div>
							        <div id='${sliderID}-update' class='dual-range-slider-value p-2'></div>
							    </div>`);
	setUpDualRangeSlider(var1,var2,min,max,defaultMin,defaultMax,step,sliderID,sliderID+ '-update',mode,slideFun,stopFun)

}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to add single range slider
function setUpRangeSlider(variable,min,max,defaultValue,step,sliderID,mode){
    eval(`window.${variable} = ${defaultValue};`);
    $('#'+sliderID + '-update').html(defaultValue);
    $("#"+sliderID).slider({
        min: min,
        max:max,
        step: step,
        value: defaultValue,
        slide: function(e,ui){
            eval(`window.${variable} = ${ui.value};`);
            $('#'+sliderID + '-update').empty();
            $('#'+sliderID + '-update').html(ui.value);
        }
    })
}
//Wrapper for single range slider
function addRangeSlider(containerDivID,title,variable,min,max,defaultValue,step,sliderID,mode,tooltip){
    $('#'+containerDivID).append(`<div  id="${sliderID}-container" class='dual-range-slider-container px-1' title="${tooltip}">
                                    <div class='dual-range-slider-name pt-2 pb-3 param-title'>${title}</div>
                                    <div id="${sliderID}" class='dual-range-slider-slider' href = '#'></div>
                                    <div id='${sliderID}-update' class='dual-range-slider-value p-2'></div>
                                </div>`);
    setUpRangeSlider(variable,min,max,defaultValue,step,sliderID,mode);
}
 //////////////////////////////////////////////////////////////////////////////////////////////
//More Bootstrap element creators
//Function to add tab to list
function addTab(tabTitle,tabListID, divListID,tabID, divID,tabOnClick,divHTML,tabToolTip,selected){  
  if(!tabToolTip){tabToolTip = ''};
  var show;
  if(selected || selected === 'true'){show = 'active show'}else{show = ''};

  $("#" + tabListID ).append(`<li class="nav-item"><a onclick = '${tabOnClick}' class="nav-link text-left text-dark tab-nav-link ${show}" id="'+tabID+'" data-toggle="tab" href="#${divID}" role="tab" aria-controls="${divID}" aria-selected="false" title="${tabToolTip}">${tabTitle}</a></li>`);

  $('#'+divListID).append($(`<div class="tab-pane fade ${show}" id="${divID}" role="tabpanel" aria-labelledby="${tabID}" title="${tabToolTip}"></div>`).append(divHTML))

    };
/////////////////////////////////////////////////////////////////////////////////////////////
function addTabContainer(containerID,tabListID,divListID){
	$('#'+ containerID).append(`<ul class="pb-1 nav nav-tabs flex-column nav-justified md-tabs" id="${tabListID}" role="tablist">  
    </ul>
    <div class = 'tab-content card' id = '${divListID}'>
    </div>`);
}
// function addAccordianContainer(containerID,tabListID,divListID){
// 	$('#'+ containerID).append(`<ul class="pb-1 nav nav-tabs flex-column nav-justified md-tabs" id="${tabListID}" role="tablist">  
//     </ul>
//     <div class = 'tab-content card' id = '${divListID}'>
//     </div>`);
// }
//////////////////////////////////////////////////////////////////////////////////////////////
function addCollapse(containerID,collapseLabelID,collapseID,collapseLabel, collapseLabelIcon,show,onclick,toolTip,mode='append'){
	var collapsed;
	if(toolTip === undefined || toolTip === null){toolTip = ''}
	if(show === true || show === 'true' || show === 'show'){show = 'show';collapsed = ''; }else{show = '';collapsed='collapsed'}
	var collapseTitleDiv = `<header title="${toolTip}" class="panel-heading px-3 py-2 " role="tab" id="${collapseLabelID}" onclick = '${onclick}'>
	<h2 class="p-0 m-0 panel-title  ${collapsed}" data-toggle="collapse"  href="#${collapseID}" id="${collapseLabelID}-label" aria-expanded="${show}" aria-controls="${collapseID}"> <a class = 'collapse-title' role='img'>
	${collapseLabelIcon} ${collapseLabel} </a></h2><span id="${collapseLabelID}-message"</span></header>`;

	var collapseDiv =`<section id="${collapseID}" class="panel-collapse collapse panel-body ${show} px-5 py-0" role="tabpanel" aria-labelledby="${collapseLabelID}"></section>`;
    if(mode==='append'){
        $('#'+containerID).append(`<div role="listitem" id="${collapseLabelID}-${collapseID}"></div>`);
    }else{
        $('#'+containerID).prepend(`<div role="listitem" id="${collapseLabelID}-${collapseID}"></div>`)
    }
	$(`#${collapseLabelID}-${collapseID}`).append(collapseTitleDiv);
	$(`#${collapseLabelID}-${collapseID}`).append(collapseDiv);
}
//////////////////////////////////////////////////////////////////////////////////////////////
function addSubCollapse(containerID,collapseLabelID,collapseID,collapseLabel, collapseLabelIcon,show,onclick){
	var collapsed;
	if(show === true || show === 'true' || show === 'show'){show = 'show';collapsed = ''; }else{show = '';collapsed='collapsed'}


	var collapseTitleDiv = `<div >
                                <div   class="panel-heading px-0 py-2 " role="tab" id="${collapseLabelID}" onclick = '${onclick}'>
	                           <h5 class="sub-panel-title ${collapsed}" data-toggle="collapse"  href="#${collapseID}" aria-expanded="false" aria-controls="${collapseID}" > <a class = 'collapse-title' >${collapseLabelIcon} ${collapseLabel} </a></h5>
                                </div>
                            </div`;

	var collapseDiv =`<div id="${collapseID}" class="panel-collapse collapse panel-body ${show} px-1 py-0" role="tabpanel" aria-labelledby="${collapseLabelID}"></div>`;
	$('#'+containerID).append(collapseTitleDiv);
	$('#'+containerID).append(collapseDiv);
}
//////////////////////////////////////////////////////////////////////////////////////////////
function addAccordianContainer(parentContainerID,accordianContainerID){
  $('#' + parentContainerID).append(`<div class="accordion" id="${accordianContainerID}"></div>`);
    
}
//////////////////////////////////////////////////////////////////////////////////////////////
var panelCollapseI = 1;
function addAccordianCard(accordianContainerID,accordianCardHeaderID, accordianCardBodyID,accordianCardHeaderContent,accordianCardBodyContent,show,onclick,toolTip){
  var collapsed;
  if(toolTip === undefined || toolTip === null){toolTip = '';}
  if(show === true || show === 'true' || show === 'show'){show = 'show';collapsed = ''; }else{show = '';collapsed='collapsed'}
  $('#' + accordianContainerID).append(`
    <div>
      <div class=" px-0 py-2 sub-panel-title ${collapsed}" id="${accordianCardHeaderID}" data-toggle="collapse" data-target="#${accordianCardBodyID}"
        aria-expanded="false" aria-controls="${accordianCardBodyID}" onclick = '${onclick}'>
      <a class = 'collapse-title' title="${toolTip}"  >
        ${accordianCardHeaderContent} </a>
      </div>
      <div id="${accordianCardBodyID}" class="panel-collapse-${panelCollapseI} super-panel-collapse panel-collapse collapse panel-body pl-3 py-0  ${show} bg-black" aria-labelledby="${accordianCardHeaderID}"
        data-parent="#${accordianContainerID}">
        <div title="${toolTip}">${accordianCardBodyContent}</div>
      </div>
    </div>`)
  // $('#'+accordianCardBodyID+'.super-panel-collapse').on('hidden.bs.collapse', function () {
  	// find the children and close them
  	// $(!this).find('.show').collapse('hide');
  	// console.log('hello')
  	// $('.panel-collapse.show.collapse.toggle-collapse').collapse('hide');
  	// stopAllTools();
	// });
  panelCollapseI++;
}
//////////////////////////////////////////////////////////////////////////////////////////////
function addSubAccordianCard(accordianContainerID,accordianCardHeaderID, accordianCardBodyID,accordianCardHeaderContent,accordianCardBodyContent,show,onclick,toolTip){
  var collapsed;
  if(toolTip === undefined || toolTip === null){toolTip = '';}
  if(show === true || show === 'true' || show === 'show'){show = 'show';collapsed = ''; }else{show = '';collapsed='collapsed'}
  $('#' + accordianContainerID).append(`
    <div>
      <div class=" px-0 py-2 sub-sub-panel-title ${collapsed}" id="${accordianCardHeaderID}" data-toggle="collapse" data-target="#${accordianCardBodyID}"
        aria-expanded="false" aria-controls="${accordianCardBodyID}" onclick = '${onclick}'>
      <a class = 'collapse-title' title="${toolTip}"  >
        ${accordianCardHeaderContent} </a>
      </div>
      <div id="${accordianCardBodyID}" class="panel-collapse-${panelCollapseI} toggle-collapse panel-collapse collapse panel-body pl-3 py-0  ${show} bg-black" aria-labelledby="${accordianCardHeaderID}"
        data-parent="#${accordianContainerID}">
        <div title="${toolTip}">${accordianCardBodyContent}</div>
      </div>
    </div>`)
 //  $('.panel-collapse.toggle-collapse').on('hidden.bs.collapse', function () {
 //  	console.log('hello')
 //  	// find the children and close them
 //  	$(this).find('.show').collapse('hide');
 //  	// $('.panel-collapse.show.collapse.toggle-collapse').collapse('hide');
	// });
  
  panelCollapseI++;
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Functions to run the walk through
function getWalkThroughCollapseContainerID(){
    var collapseContainer;
    if($(window).width() < 768){collapseContainer = 'sidebar-left' }
    else{collapseContainer = 'legendDiv';}
    return collapseContainer
}
function moveElement(selectorFrom,appendToID){
    $(selectorFrom).detach().appendTo(appendToID);
}
function moveCollapse(baseID,collapseContainer =getWalkThroughCollapseContainerID()){
    // $('#'+baseID+'-label').detach().appendTo('#'+collapseContainer);
    moveElement('#'+baseID+'-label','#'+collapseContainer)
    // $('#'+baseID+'-div').detach().appendTo('#'+collapseContainer);
    moveElement('#'+baseID+'-div','#'+collapseContainer)
}

//////////////////////////////////////////////////////////////////////////////////////////////
//Legend functions
function addLegendCollapse(){
    var collapseContainer =getWalkThroughCollapseContainerID(); 
    addCollapse(getWalkThroughCollapseContainerID(),'chart-collapse-label','chart-collapse-div','QUERY OUTPUTS','<i class="fa fa-list  mx-0" aria-hidden="true"></i>',true,``,'Query Visible Map Layers outputs will appear here');
    addCollapse(collapseContainer,'legend-collapse-label','legend-collapse-div','LEGEND','<i class="fa fa-location-arrow fa-rotate-45 mx-1" aria-hidden="true"></i>',true,``,'LEGEND of the layers displayed on the map')
    
    $('#chart-collapse-div').append(`<div role="list" id="chart-list"></div>`);
    $('#chart-collapse-label-chart-collapse-div').hide();
    $('#chart-collapse-div').removeClass('px-5');
    $('#chart-collapse-div').addClass('px-3');
    // $('#legend-collapse-div').append(`<legend-list   id="legend"></legend-list>`)
    $('#legend-collapse-div').append(`<div role="list" id="legend-layer-list"></div>`);
    $('#legend-collapse-div').append(`<div role="list" id="legend-reference-layer-list"></div>`);
    $('#legend-collapse-div').append(`<div role="list" id="legend-fhp-div"></div>`);
    $('#legend-collapse-div').append(`<div role="list" id="time-lapse-legend-list"></div>`);
    $('#legend-collapse-div').append(`<div role="list" id="legend-area-charting-select-layer-list"></div>`);
}
function addLegendContainer(legendContainerID,containerID,show,toolTip){
	if(containerID === undefined || containerID === null){containerID = 'legend-collapse-div'}
	if(show === undefined || show === null){show = true}
	if(show){show = 'block'}
	else{show = 'none'}
	$('#' + containerID).prepend(`<div class = 'py-1 row' title= '${toolTip}' style = 'display:${show};' id = '${legendContainerID}'>
								</div>`);
}

function addClassLegendContainer(classLegendContainerID,legendContainerID,classLegendTitle){
	$('#'+legendContainerID).append(`<div class='my-legend'>
										<div class = 'legend-title'>${classLegendTitle}</div>
										<div class='legend-scale'>
									  		<ul class='legend-labels' id = '${classLegendContainerID}'></ul>
										</div>
									</div>`)
}
function addClassLegendEntry(classLegendContainerID,obj){
	$('#'+classLegendContainerID).append(`<li><span style='border: ${obj.classStrokeWeight}px solid #${obj.classStrokeColor};background:${addColorHash(obj.classColor)};'></span>${obj.className}</li>`)
}

function addColorRampLegendEntry(legendContainerID,obj){
	$('#'+legendContainerID).append(`<li class = 'legend-colorRamp' title= '${obj.helpBoxMessage}'>
							            <div class = 'legend-title'>${obj.name}</div>
							            <div class = 'colorRamp'style='${obj.colorRamp};'></div>
							            <div>
							                <span class = 'leftLabel'>${obj.min}</span>
							                <span class = 'rightLabel'>${obj.max}</span>
							            </div>
							            
							        </li> `)
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function to disable rerun button when there are still outstanding GEE requests
function regulateReRunButton(){
	if(outstandingGEERequests > 0){
		$('#reRun-button').prop('disabled',true);
		$('#reRun-button').prop('title',staticTemplates.reRunButtonDisabledTooltip);
	}
	else{
		$('#reRun-button').prop('disabled',false);
		$('#reRun-button').prop('title',staticTemplates.reRunButtonEnabledTooltip);
	}
} 
//Function to help keep track of GEE requests
function updateOutstandingGEERequests(){
    // $('#loading-number-box').html(outstandingGEERequests)
	

    if(outstandingGEERequests===0){$('#gee-queue-len').hide()
    }else{
        $('#gee-queue-len').show();
        $('#outstanding-gee-requests').html(outstandingGEERequests);
    }

	regulateReRunButton();
}
function updateGEETileLayersLoading(){
    $('#number-gee-tiles-downloading').html(geeTileLayersDownloading);
}
function incrementOutstandingGEERequests(){
	outstandingGEERequests ++;updateOutstandingGEERequests();
}
function decrementOutstandingGEERequests(){
	outstandingGEERequests --;updateOutstandingGEERequests();
}

function incrementGEETileLayersLoading(){
	geeTileLayersDownloading++;updateGEETileLayersLoading();
}
function decrementGEETileLayersLoading(){
	geeTileLayersDownloading--;updateGEETileLayersLoading();
}
function updateGEETileLayersDownloading(){
    geeTileLayersDownloading = Object.values(layerObj).filter(function(v){return v.loading}).length;
    updateGEETileLayersLoading();
}
//////////////////////////////////////////////////////////////////////////////////////////////
//Function for adding map layers of various sorts to the map
//Map layers can be ee objects, geojson, dynamic map services, and tile map services

function addLayer(layer){

    //Initialize a bunch of variables
    layer.loadError = false;
	var id = layer.legendDivID;
    layer.id = id;
    var queryID = id + '-'+layer.ID;
	var containerID = id + '-container-'+layer.ID;
	var opacityID = id + '-opacity-'+layer.ID;
	var visibleID = id + '-visible-'+layer.ID;
	var spanID = id + '-span-'+layer.ID;
	var visibleLabelID = visibleID + '-label-'+layer.ID;
	var spinnerID = id + '-spinner-'+layer.ID;
    var eraserID = `${id}-eraser-${layer.ID}`;
    var selectionID = id + '-selection-list-'+layer.ID;
	var checked = '';
    layerObj[id] = layer;
    layer.wasJittered = false;
    layer.loading = false;
    layer.refreshNumber = refreshNumber;
	if(layer.visible){checked = 'checked'}
    
    if(layer.viz.isTimeLapse){
        // console.log(timeLapseObj[layer.viz.timeLapseID]);
        timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.push(id);
        timeLapseObj[layer.viz.timeLapseID].sliders.push(opacityID);
        timeLapseObj[layer.viz.timeLapseID].layerVisibleIDs.push(visibleID);

    }

    //Set up layer control container
	$('#'+ layer.whichLayerList).prepend(`<li id = '${containerID}' aria-label="Map layer controls container for ${layer.name}" class = 'layer-container'  title= '${layer.helpBoxMessage}'>
								           <div id="${opacityID}" aria-labelledby="${containerID}" aria-label="Opacity range slider for ${layer.name}" class = 'simple-layer-opacity-range'></div>
								           <input  role="option" id="${visibleID}" aria-label="Layer visibility toggle checkbox for ${layer.name}" type="checkbox" ${checked}  />
								            <label class = 'layer-checkbox' id="${visibleLabelID}" aria-label="Layer visibility toggle checkbox for ${layer.name}" style = 'margin-bottom:0px;display:none;'  for="${visibleID}"></label>
								            <i id = "${spinnerID}" class="fa fa-spinner fa-spin layer-spinner" title='Waiting for layer service from Google Earth Engine'></i>
								            <i id = "${spinnerID}2" style = 'display:none;' class="fa fa-cog fa-spin layer-spinner" title='Waiting for map tiles from Google Earth Engine'></i>
								            <i id = "${spinnerID}3" style = 'display:none;' class="fa fa-cog fa-spin layer-spinner" title='Waiting for map tiles from Google Earth Engine'></i>
                                            <i title = 'Click to clear all selected features from this layer' id='${eraserID}' class="fa fa-eraser eraser" style="display:none;"></i>
								            <span id = '${spanID}' aria-labelledby="${containerID}" class = 'layer-span'>${layer.name}</span>
								       </li>`);
    //Set up opacity slider
	$("#"+opacityID).slider({
        min: 0,
        max: 100,
        step: 1,
        value: layer.opacity*100,
    	slide: function(e,ui){
    		layer.opacity = ui.value/100;
    		// console.log(layer.opacity);
    		 if(layer.layerType !== 'geeVector' && layer.layerType !== 'geoJSONVector'){
                layer.layer.setOpacity(layer.opacity);
                
                
              }else{
    	            var style = layer.layer.getStyle();
    	            style.strokeOpacity = layer.opacity;
    	            style.fillOpacity = layer.opacity/layer.viz.opacityRatio;
    	            layer.layer.setStyle(style);
    	            if(layer.visible){layer.range}
                    }
            if(layer.visible){
            	layer.rangeOpacity = layer.opacity;
            }     
            layerObj[id].visible = layer.visible;
            layerObj[id].opacity = layer.opacity;
    		setRangeSliderThumbOpacity();
    		}
	})
	function setRangeSliderThumbOpacity(){
        // console.log([opacityID,layer.rangeOpacity].join('-'))
		$(`#${opacityID}`).css("background-color", `rgba(55, 46, 44,${layer.rangeOpacity})!important`)
        
	}
    //Progress bar controller
	function updateProgress(){
		var pct = layer.percent;
        if(pct === 100 && mode !== 'lcms-dashboard' && (layer.layerType === 'geeImage' || layer.layerType === 'geeVectorImage' || layer.layerType === 'geeImageCollection')){jitterZoom()}
		$('#'+containerID).css('background',`-webkit-linear-gradient(left, #FFF, #FFF ${pct}%, transparent ${pct}%, transparent 100%)`)
	}
	//Function for zooming to object
	function zoomFunction(){
        
		if(layer.layerType === 'geeVector' ){
			centerObject(layer.item)
		}else if(layer.layerType === 'geoJSONVector'){
			// centerObject(ee.FeatureCollection(layer.item.features.map(function(t){return ee.Feature(t).dissolve(100,ee.Projection('EPSG:4326'))})).geometry().bounds())
			// synchronousCenterObject(layer.item.features[0].geometry)
		}else{
            
			if(layer.item.args !== undefined && layer.item.args.value !== null && layer.item.args.value !== undefined){
                synchronousCenterObject(layer.item.args.value)
			}
            else if(layer.item.args !== undefined &&layer.item.args.featureCollection !== undefined &&layer.item.args.featureCollection.args !== undefined && layer.item.args.featureCollection.args.value !== undefined && layer.item.args.featureCollection.args.value !== undefined){
                synchronousCenterObject(layer.item.args.featureCollection.args.value);
            }else if(layer.viz.bounds !== undefined && layer.viz.bounds !== null){
                synchronousCenterObject(layer.viz.bounds);
            }else{
                centerObject(layer.item);
            }
            ;
		}
	}
    //Try to handle load failures
    function loadFailure(failure){
        layer.loadError = true;
        console.log('GEE Tile Service request failed for '+layer.name);
        console.log(containerID)
        $('#'+containerID).css('background','red');
        $('#'+containerID).attr('title','Layer failed to load. Error message: "'+failure + '"')
        // getGEEMapService();
    }
    //Function to handle turning off of different types of layers
    function turnOff(){
        ga('send', 'event', 'layer-off', layer.layerType,layer.name);
        if(layer.layerType === 'dynamicMapService'){
            layer.layer.setMap(null);
            layer.visible = false;
            layer.percent = 0;
            layer.rangeOpacity = 0;
            setRangeSliderThumbOpacity();
            updateProgress();
            $('#'+layer.legendDivID).hide();
        } else if(layer.layerType !== 'geeVector' && layer.layerType !== 'geoJSONVector'){
            layer.visible = false;
            layer.map.overlayMapTypes.setAt(layer.layerId,null);
            layer.percent = 0;
            updateProgress();
            $('#'+layer.legendDivID).hide();
            layer.rangeOpacity = 0;
            if(layer.layerType !== 'tileMapService' && layer.layerType !== 'dynamicMapService' && layer.canQuery){
             queryObj[queryID].visible = layer.visible;
            }
        }else{
            layer.visible = false;
            
            layer.percent = 0;
            updateProgress();
            $('#'+layer.legendDivID).hide();
            layer.layer.setMap(null);
            layer.rangeOpacity = 0;
            $('#' + spinnerID+'2').hide();
            // geeTileLayersDownloading = 0;
            // updateGEETileLayersLoading();
            if(layer.layerType === 'geeVector' && layer.canQuery){
                queryObj[queryID].visible = layer.visible;
            }
            
        }
        if(layer.viz.dashboardSummaryLayer){
            Object.keys(layer.dashboardSelectedFeatures).map(nm=>layer.dashboardSelectedFeatures[nm].polyList.map(p=>p.setMap(null)));
            updateDashboardCharts();
            updateDashboardHighlights();
            
        }
        layer.loading = false;
        updateGEETileLayersDownloading();
            
        $('#'+spinnerID + '2').hide();
        $('#'+spinnerID + '3').hide();
        vizToggleCleanup();
    }
    //Function to handle turning on different layer types
    function turnOn(){
        ga('send', 'event', 'layer-on', layer.layerType,layer.name);
        if(!layer.viz.isTimeLapse){
            turnOffTimeLapseCheckboxes();
        }
        if(layer.layerType === 'dynamicMapService'){
            layer.layer.setMap(map);
            layer.visible = true;
            layer.percent = 100;
            layer.rangeOpacity = layer.opacity;
            setRangeSliderThumbOpacity();
            updateProgress();
            $('#'+layer.legendDivID).show();
        } else if(layer.layerType !== 'geeVector' && layer.layerType !== 'geoJSONVector'){
            layer.visible = true;
            layer.map.overlayMapTypes.setAt(layer.layerId,layer.layer);
            $('#'+layer.legendDivID).show();
            layer.rangeOpacity = layer.opacity;
            if(layer.isTileMapService){layer.percent = 100;updateProgress();}
            layer.layer.setOpacity(layer.opacity); 
            if(layer.layerType !== 'tileMapService' && layer.layerType !== 'dynamicMapService' && layer.canQuery){
             queryObj[queryID].visible = layer.visible;
            }
        }else{

           layer.visible = true;
            layer.percent = 100;
            updateProgress();
            $('#'+layer.legendDivID).show();
            layer.layer.setMap(layer.map);
            layer.rangeOpacity = layer.opacity;
            if(layer.layerType === 'geeVector' && layer.canQuery){
                queryObj[queryID].visible = layer.visible;
            }
             
        }
        if(layer.viz.dashboardSummaryLayer){
                
            Object.keys(layer.dashboardSelectedFeatures).map(nm=>layer.dashboardSelectedFeatures[nm].polyList.map(p=>p.setMap(map)));
            if(mode === 'lcms-dashboard'){
                dashboardBoxSelect();
              }else{
                updateDashboardCharts();
                updateDashboardHighlights();
              }
            
        }  
        vizToggleCleanup();
    }
    //Some functions to keep layers tidy
    function vizToggleCleanup(){
        setRangeSliderThumbOpacity();
        layerObj[id].visible = layer.visible;
        layerObj[id].opacity = layer.opacity;
    }
	function checkFunction(){
        if(!layer.loadError){
            if(layer.visible){
                turnOff();
            }else{turnOn()}  
        }
            
	}
    function turnOffAll(){  
        if(layer.visible){
            $('#'+visibleID).click();
        }
    }
    function turnOnAll(){
        if(!layer.visible){
            $('#'+visibleID).click();
        }
    }
	$("#"+ opacityID).val(layer.opacity * 100);

    //Handle double clicking
	var prevent = false;
	var delay = 200;
	$('#'+ spanID).click(function(){
		setTimeout(function(){
			if(!prevent){
				$('#'+visibleID).click();
			}
		},delay)
		
	});
    $('#'+ spinnerID + '2').click(function(){$('#'+visibleID).click();});
    //Try to zoom to layer if double clicked
	$('#'+ spanID).dblclick(function(){
            zoomFunction();
			prevent = true;
			zoomFunction();
			if(!layer.visible){$('#'+visibleID).click();}
			setTimeout(function(){prevent = false},delay)
		})

	//If checkbox is toggled
	$('#'+visibleID).change( function() {checkFunction();});
   

	layerObj[id].visible = layer.visible;
    layerObj[id].opacity = layer.opacity;
	
    //Handle different scenarios where all layers need turned off or on
    if(!layer.viz.isTimeLapse){
        $('.layer-checkbox').on('turnOffAll',function(){turnOffAll()});
    }
    if(layer.layerType === 'geeVector' || layer.layerType === 'geeVectorImage' || layer.layerType === 'geoJSONVector'){
        $('#'+visibleLabelID).addClass('vector-layer-checkbox');
        $('.vector-layer-checkbox').on('turnOffAll',function(){turnOffAll()});
        $('.vector-layer-checkbox').on('turnOnAll',function(){turnOnAll()});
        $('.vector-layer-checkbox').on('turnOffAllVectors',function(){turnOffAll()});
        $('.vector-layer-checkbox').on('turnOnAllVectors',function(){turnOnAll()});

        if(layer.viz.isUploadedLayer){
            $('#'+visibleLabelID).addClass('uploaded-layer-checkbox');
            selectionTracker.uploadedLayerIndices.push(layer.layerId)
            $('.vector-layer-checkbox').on('turnOffAllUploadedLayers',function(){turnOffAll()});
            $('.vector-layer-checkbox').on('turnOnAllUploadedLayers',function(){turnOnAll()});
        }
    }

    //Handle different object types
	if(layer.layerType === 'geeImage' || layer.layerType === 'geeVectorImage' || layer.layerType === 'geeImageCollection'){
        //Handle image colletions
        if(layer.layerType === 'geeImageCollection'){
            // layer.item = ee.ImageCollection(layer.item);
            layer.imageCollection = layer.item;

            if(layer.viz.reducer === null || layer.viz.reducer === undefined){
                layer.viz.reducer = ee.Reducer.lastNonNull();
            }else if(typeof(layer.viz.reducer)==='string'){
                try{
                    layer.viz.reducer = ee.Deserializer.fromJSON(layer.viz.reducer)
                }catch(err){
                    layer.viz.reducer = eval(layer.viz.reducer);
                }
            }
            var bandNames = ee.Image(layer.item.first()).bandNames();
            layer.item = ee.ImageCollection(layer.item).reduce(layer.viz.reducer).rename(bandNames).copyProperties(layer.imageCollection.first()).set(layer.item.toDictionary());
            
        //Handle vectors
        } else if(layer.layerType === 'geeVectorImage' || layer.layerType === 'geeVector'){

            if(layer.viz.isSelectLayer){
                
                selectedFeaturesJSON[layer.name] = {'layerName':layer.name,'filterList':[],'geoJSON':new google.maps.Data(),'id':layer.id,'rawGeoJSON':{},'selection':ee.FeatureCollection([])}
                // selectedFeaturesJSON[layer.name].geoJSON.setMap(layer.map);

                // layer.infoWindow = getInfoWindow(infoWindowXOffset);
                // infoWindowXOffset += 30;
                // selectedFeaturesJSON[layer.name].geoJSON.setStyle({strokeColor:invertColor(layer.viz.strokeColor)});
                // layer.queryVector = layer.item;  
                $('#'+visibleLabelID).addClass('select-layer-checkbox');
                $('.vector-layer-checkbox').on('turnOffAllSelectLayers',function(){turnOffAll()});
                $('.vector-layer-checkbox').on('turnOnAllSelectLayers',function(){turnOnAll()});
                $('.vector-layer-checkbox').on('turnOffAll',function(){turnOffAll()});
                $('.vector-layer-checkbox').on('turnOnAll',function(){turnOnAll()});
            }
            layer.queryItem = layer.item;
            if(layer.layerType === 'geeVectorImage'){
                layer.item = ee.Image().paint(layer.item,null,layer.viz.strokeWeight);
                layer.viz.palette = layer.viz.strokeColor;
            }
            //Add functionality for select layers to be clicked and selected
            if(layer.viz.isSelectLayer){
                if( layer.viz.selectLayerNameProperty === undefined){
                    var name;
                    layer.queryItem.first().propertyNames().evaluate(function(propertyNames,failure){
                        if(failure !== undefined){name = 'system:index';//showMessage('Error',failure)
                        }
                        else{
                            propertyNames.map(function(p){
                                if(p.toLowerCase().indexOf('name') !== -1){name = p}
                            })
                            if(name === undefined){name = 'system:index'}
                            }
                        selectedFeaturesJSON[layer.name].fieldName = name
                        selectedFeaturesJSON[layer.name].eeObject = layer.queryItem.select([name],['name'])
                    })
                }else{
                    selectedFeaturesJSON[layer.name].fieldName = layer.viz.selectLayerNamePropertyname
                    selectedFeaturesJSON[layer.name].eeObject = layer.queryItem.select([layer.viz.selectLayerNameProperty],['name'])
                }
                
            }
            if(layer.viz.isSelectedLayer){
                $('#'+visibleLabelID).addClass('selected-layer-checkbox');
                $('.vector-layer-checkbox').on('turnOffAllSelectLayers',function(){turnOffAll()});
                $('.vector-layer-checkbox').on('turnOnAllSelectLayers',function(){turnOnAll()});
                $('.vector-layer-checkbox').on('turnOffAllSelectedLayers',function(){turnOffAll()});
                $('.vector-layer-checkbox').on('turnOnAllSelectedLayers',function(){turnOnAll()});
                selectionTracker.seletedFeatureLayerIndices.push(layer.layerId)
            }
            
          
        };
        //Add layer to query object if it can be queried
        if(layer.canQuery){
          queryObj[queryID] = {'visible':layer.visible,'queryItem':layer.queryItem,'queryDict':layer.viz.queryDict,'type':layer.layerType,'name':layer.name,'queryDateFormat':layer.viz.queryDateFormat};  
        }
		incrementOutstandingGEERequests();

		//Handle creating GEE map services
		function getGEEMapServiceCallback(eeLayer){
            decrementOutstandingGEERequests();
            $('#' + spinnerID).hide();
            if(layer.viz.isTimeLapse){
                timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs = timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.filter(timeLapseLayerID => timeLapseLayerID !== id)
                var prop = parseInt((1-timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.length /timeLapseObj[layer.viz.timeLapseID].nFrames)*100);
                // $('#'+layer.viz.timeLapseID+'-loading-progress').css('width', prop+'%').attr('aria-valuenow', prop).html(prop+'% frames loaded');   
                $('#'+layer.viz.timeLapseID+ '-collapse-label').css('background',`-webkit-linear-gradient(left, #FFF, #FFF ${prop}%, transparent ${prop}%, transparent 100%)`)
                            
                // $('#'+layer.viz.timeLapseID+'-loading-count').html(`${timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.length}/${timeLapseObj[layer.viz.timeLapseID].nFrames} layers to load`)
                if(timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.length === 0){
                    $('#'+layer.viz.timeLapseID+'-loading-spinner').hide();
                    $('#'+layer.viz.timeLapseID+'-year-label').hide();
                    // $('#'+layer.viz.timeLapseID+'-loading-progress-container').hide();
                    $('#'+layer.viz.timeLapseID+ '-collapse-label').css('background',`-webkit-linear-gradient(left, #FFF, #FFF ${0}%, transparent ${0}%, transparent 100%)`)
                            
                    // $('#'+layer.viz.timeLapseID+'-icon-bar').show();
                    // $('#'+layer.viz.timeLapseID+'-time-lapse-layer-range-container').show();
                    $('#'+layer.viz.timeLapseID+'-toggle-checkbox-label').show();
                    
                    
                    timeLapseObj[layer.viz.timeLapseID].isReady = true;
                };
            }
            $('#' + visibleLabelID).show();
            
            if(layer.currentGEERunID === geeRunID){
                if(eeLayer === undefined){
                    loadFailure();
                }
                else{
                    //Set up GEE map service
                    var MAPID = eeLayer.mapid;
                    var TOKEN = eeLayer.token;
                    layer.highWaterMark = 0;
                    var tileIncremented = false;
                    var eeTileSource = new ee.layers.EarthEngineTileSource(eeLayer);
                    // console.log(eeTileSource)
                    layer.layer = new ee.layers.ImageOverlay(eeTileSource)
                    var overlay = layer.layer;
                    //Set up callback to keep track of tile downloading
                    layer.layer.addTileCallback(function(event){

                        event.count = event.loadingTileCount;
                        if(event.count > layer.highWaterMark){
                            layer.highWaterMark = event.count;
                        }

                        layer.percent = 100-((event.count / layer.highWaterMark) * 100);
                        if(event.count ===0 && layer.highWaterMark !== 0){layer.highWaterMark = 0}

                        if(layer.percent !== 100){
                            layer.loading = true;
                            $('#' + spinnerID+'2').show();
                            if(!tileIncremented){
                                incrementGEETileLayersLoading();
                                tileIncremented = true;
                                if(layer.viz.isTimeLapse){
                                    timeLapseObj[layer.viz.timeLapseID].loadingTilesLayerIDs.push(id);

                                }
                            }
                        }else{
                            layer.loading = false;
                            $('#' + spinnerID+'2').hide();
                            decrementGEETileLayersLoading();
                            if(layer.viz.isTimeLapse){
                                    timeLapseObj[layer.viz.timeLapseID].loadingTilesLayerIDs = timeLapseObj[layer.viz.timeLapseID].loadingTilesLayerIDs.filter(timeLapseLayerID => timeLapseLayerID !== id)
                
                                }
                            tileIncremented = false;
                        }
                        //Handle the setup of layers within a time lapse
                        if(layer.viz.isTimeLapse){
                            var loadingTimelapseLayers = Object.values(layerObj).filter(function(v){return v.loading && v.viz.isTimeLapse && v.whichLayerList === layer.whichLayerList});
                            var loadingTimelapseLayersYears = loadingTimelapseLayers.map(function(f){return [f.viz.year,f.percent].join(':')}).join(', ');
                            var notLoadingTimelapseLayers = Object.values(layerObj).filter(function(v){return !v.loading && v.viz.isTimeLapse && v.whichLayerList === layer.whichLayerList});
                            var notLoadingTimelapseLayersYears = notLoadingTimelapseLayers.map(function(f){return [f.viz.year,f.percent].join(':')}).join(', ');
                            $('#'+layer.viz.timeLapseID + '-message-div').html('Loading:<br>'+loadingTimelapseLayersYears+'<hr>Not Loading:<br>'+notLoadingTimelapseLayersYears);
                            var propTiles = parseInt((1-(timeLapseObj[layer.viz.timeLapseID].loadingTilesLayerIDs.length/timeLapseObj[layer.viz.timeLapseID].nFrames))*100);
                            // $('#'+layer.viz.timeLapseID+'-loading-progress').css('width', propTiles+'%').attr('aria-valuenow', propTiles).html(propTiles+'% tiles loaded');
                            $('#'+layer.viz.timeLapseID+ '-loading-gear').show();
                            
                            $('#'+layer.viz.timeLapseID+ '-collapse-label').css('background',`-webkit-linear-gradient(90deg, #FFF, #FFF ${propTiles}%, transparent ${propTiles}%, transparent 100%)`)
                            if(propTiles < 100){
                                // console.log(propTiles)
                                // if(timeLapseObj[layer.viz.timeLapseID] === 'play'){
                                // pauseButtonFunction();  
                                // }
                            }else{
                                $('#'+layer.viz.timeLapseID+ '-loading-gear').hide();
                            }
                        }

                        // var loadingLayers = Object.values(layerObj).filter(function(v){return v.loading});
                        // console.log(loadingLayers);
                        updateProgress();
                        // console.log(event.count);
                        // console.log(inst.highWaterMark);
                        // console.log(event.count / inst.highWaterMark);
                        // console.log(layer.percent)
                    });
                    if(layer.visible){
                            layer.map.overlayMapTypes.setAt(layer.layerId, layer.layer);
                            $('#'+layer.legendDivID).show();
                            layer.rangeOpacity = layer.opacity; 
                            
                            layer.layer.setOpacity(layer.opacity); 
                        }else{
                          $('#'+layer.legendDivID).hide();
                          layer.rangeOpacity = 0;
                          
                        }
                        setRangeSliderThumbOpacity(); 
                }
                
            }
        }
        function updateTimeLapseLoadingProgress(){
            var loadingTimelapseLayers = Object.values(layerObj).filter(function(v){return v.loading && v.viz.isTimeLapse && v.whichLayerList === layer.whichLayerList}).length;
            var notLoadingTimelapseLayers = Object.values(layerObj).filter(function(v){return !v.loading && v.viz.isTimeLapse && v.whichLayerList === layer.whichLayerList}).length;
            var total = loadingTimelapseLayers+notLoadingTimelapseLayers
            var propTiles = (1-(loadingTimelapseLayers/timeLapseObj[layer.viz.timeLapseID].nFrames))*100
            
            $('#'+layer.viz.timeLapseID+ '-collapse-label').css('background',`-webkit-linear-gradient(0deg, #FFF, #FFF ${propTiles}%, transparent ${propTiles}%, transparent 100%)`)
            if(propTiles < 100){
                $('#'+layer.viz.timeLapseID+ '-loading-gear').show();
                // console.log(propTiles)
                // if(timeLapseObj[layer.viz.timeLapseID] === 'play'){
                // pauseButtonFunction();  
                // }
            }else{
                $('#'+layer.viz.timeLapseID+ '-loading-gear').hide();
            }
            }
        //Handle alternative GEE tile service format
        function geeAltService(eeLayer,failure){
            decrementOutstandingGEERequests();
            $('#' + spinnerID).hide();
            if(layer.viz.isTimeLapse){
                timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs = timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.filter(timeLapseLayerID => timeLapseLayerID !== id)
                var prop = parseInt((1-timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.length /timeLapseObj[layer.viz.timeLapseID].nFrames)*100);
                // $('#'+layer.viz.timeLapseID+'-loading-progress').css('width', prop+'%').attr('aria-valuenow', prop).html(prop+'% frames loaded');   
                $('#'+layer.viz.timeLapseID+ '-collapse-label').css('background',`-webkit-linear-gradient(left, #FFF, #FFF ${prop}%, transparent ${prop}%, transparent 100%)`)
                            
                // $('#'+layer.viz.timeLapseID+'-loading-count').html(`${timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.length}/${timeLapseObj[layer.viz.timeLapseID].nFrames} layers to load`)
                if(timeLapseObj[layer.viz.timeLapseID].loadingLayerIDs.length === 0){
                    $('#'+layer.viz.timeLapseID+'-loading-spinner').hide();
                    $('#'+layer.viz.timeLapseID+'-year-label').hide();
                    // $('#'+layer.viz.timeLapseID+'-loading-progress-container').hide();
                    $('#'+layer.viz.timeLapseID+ '-collapse-label').css('background',`-webkit-linear-gradient(left, #FFF, #FFF ${0}%, transparent ${0}%, transparent 100%)`)
                            
                    // $('#'+layer.viz.timeLapseID+'-icon-bar').show();
                    // $('#'+layer.viz.timeLapseID+'-time-lapse-layer-range-container').show();
                    $('#'+layer.viz.timeLapseID+'-toggle-checkbox-label').show();
                    
                    
                    timeLapseObj[layer.viz.timeLapseID].isReady = true;
                };
            }
            $('#' + visibleLabelID).show();
            
            if(layer.currentGEERunID === geeRunID){
                if(eeLayer === undefined || failure !== undefined){
                    loadFailure(failure);
                }
                else{
                    const tilesUrl = eeLayer.urlFormat;
                    
                    var getTileUrlFun = function(coord, zoom) {
                        var t = [coord,zoom];
                        
                        
                        let url = tilesUrl
                                .replace('{x}', coord.x)
                                .replace('{y}', coord.y)
                                .replace('{z}', zoom);
                    if(!layer.loading){
                        layer.loading = true;
                        layer.percent = 10;
                        $('#' + spinnerID+'2').show();
                        updateGEETileLayersDownloading();
                        updateProgress();
                        if(layer.viz.isTimeLapse){
                            updateTimeLapseLoadingProgress();  
                        }
                    }
                    
                    return url
                }
                    layer.layer = new google.maps.ImageMapType({
                            getTileUrl:getTileUrlFun
                        });
                    // console.log(layer.name)
                    // layer.layer = new ee.layers.ImageOverlay(new ee.layers.EarthEngineTileSource(eeLayer));
                    // google.maps.event.addListener(layer.layer, "LOAD", (e)=>{
                    //     console.log(e)
                    // });
                    layer.layer.addListener('tilesloaded',function(e){
                        console.log(e)
                        layer.percent = 100;
                        layer.loading = false;
                        
                        
                        $('#' + spinnerID+'2').hide();
                        updateGEETileLayersDownloading();
                        updateProgress();
                        if(layer.viz.isTimeLapse){
                            updateTimeLapseLoadingProgress();  
                        }
                    })
                    
                    
                    if(layer.visible){
                        layer.map.overlayMapTypes.setAt(layer.layerId, layer.layer);
                        layer.rangeOpacity = layer.opacity; 
                        layer.layer.setOpacity(layer.opacity);
                        $('#'+layer.legendDivID).show();
                         }else{layer.rangeOpacity = 0;}
                         $('#' + spinnerID).hide();
                        $('#' + visibleLabelID).show();

                        setRangeSliderThumbOpacity();
                }
            }
        }
        //Asynchronous wrapper function to get GEE map service
        layer.mapServiceTryNumber = 0;
        function getGEEMapService(){
            // layer.item.getMap(layer.viz,function(eeLayer){getGEEMapServiceCallback(eeLayer)});
            
            //Handle embeded visualization params if available
            var vizKeys = Object.keys(layer.viz);
            var possibleVizKeys = ['bands','min','max','gain','bias','gamma','palette','color'];
            var vizFound = false;
            possibleVizKeys.map(function(k){
                var i = vizKeys.indexOf(k) > -1;
                if(i){vizFound = true}
            });
           
            if(vizFound == false){layer.usedViz = {}}
                else{layer.usedViz = layer.viz}
            // console.log(layer.usedViz);
            ee.Image(layer.item).getMap(layer.usedViz,function(eeLayer,failure){
                if(eeLayer === undefined && layer.mapServiceTryNumber <=1){
                    queryObj[queryID].queryItem = layer.item;
                    layer.item = layer.item.visualize();
                    getGEEMapService();
                }else{
                    geeAltService(eeLayer,failure);
                }  
            });

            // layer.item.getMap(layer.viz,function(eeLayer){
                // console.log(eeLayer)
                // console.log(ee.data.getTileUrl(eeLayer))
            // })
            layer.mapServiceTryNumber++;
        };
        getGEEMapService();

    //Handle different vector formats
	}else if(layer.layerType === 'geeVector' || layer.layerType === 'geoJSONVector'){
        if(layer.canQuery){
          queryObj[queryID] = {'visible':layer.visible,'queryItem':layer.queryItem,'queryDict':layer.viz.queryDict,'type':layer.layerType,'name':layer.name};  
        }
		incrementOutstandingGEERequests();
        //Handle adding geoJSON to map
		function addGeoJsonToMap(v){
			$('#' + spinnerID).hide();
			$('#' + visibleLabelID).show();

			if(layer.currentGEERunID === geeRunID){
                if(v === undefined){loadFailure()}
				layer.layer = new google.maps.Data();
               //  layer.viz.icon = {
               //    path: google.maps.SymbolPath.BACKWARD_CLOSED_ARROW,
               //    scale: 5,
               //    strokeWeight:2,
               //    strokeColor:"#B40404"
               // }
		        layer.layer.setStyle(layer.viz);
		      
		      	layer.layer.addGeoJson(v);
                if(layer.viz.clickQuery){
                    map.addListener('click',function(){
                        infowindow.setMap(null);
                    })
                    layer.layer.addListener('click', function(event) {
                        console.log(event);
                        infowindow.setPosition(event.latLng);
                        var infoContent = `<table class="table table-hover bg-white">
                            <tbody>`
                        var info = event.feature.j;
                        Object.keys(info).map(function(name){
                            var value = info[name];
                            infoContent +=`<tr><th>${name}</th><td>${value}</td></tr>`;
                        });
                        infoContent +=`</tbody></table>`;
                        infowindow.setContent(infoContent);
                        infowindow.open(map);
                    })  
                }
                
		      	featureObj[layer.name] = layer.layer
		      	// console.log(this.viz);
		      
		      	if(layer.visible){
		        	layer.layer.setMap(layer.map);
		        	layer.rangeOpacity = layer.viz.strokeOpacity;
		        	layer.percent = 100;
		        	updateProgress();
		        	$('#'+layer.legendDivID).show();
		      	}else{
		        	layer.rangeOpacity = 0;
		        	layer.percent = 0;
		        	$('#'+layer.legendDivID).hide();
		      		}
		      	setRangeSliderThumbOpacity();
		      	}
  		}
  		if(layer.layerType === 'geeVector'){
            decrementOutstandingGEERequests();
  			layer.item.evaluate(function(v){addGeoJsonToMap(v)})
  		}else{decrementOutstandingGEERequests();addGeoJsonToMap(layer.item)}
	//Handle non GEE tile services	
	}else if(layer.layerType === 'tileMapService'){
		layer.layer = new google.maps.ImageMapType({
                getTileUrl: layer.item,
                tileSize: new google.maps.Size(256, 256),
                // tileSize: new google.maps.Size($('#map').width(),$('#map').height()),
                maxZoom: 15
            
            })
		if(layer.visible){
        	
        	layer.map.overlayMapTypes.setAt(layer.layerId, layer.layer);
        	layer.rangeOpacity = layer.opacity; 
        	layer.layer.setOpacity(layer.opacity); 
             }else{layer.rangeOpacity = 0;}
             $('#' + spinnerID).hide();
			$('#' + visibleLabelID).show();
			setRangeSliderThumbOpacity();
                
	//Handle dynamic map services
	}else if(layer.layerType === 'dynamicMapService'){
		function groundOverlayWrapper(){
	      if(map.getZoom() > layer.item[1].minZoom){
	        return getGroundOverlay(layer.item[1].baseURL,layer.item[1].minZoom,layer.item[1].ending)
	      }
	      else{
	        return getGroundOverlay(layer.item[0].baseURL,layer.item[0].minZoom,layer.item[0].ending)
	      }
	      };
	      function updateGroundOverlay(){
                if(layer.layer !== null && layer.layer !== undefined){
                    layer.layer.setMap(null);
                }
                
                layer.layer =groundOverlayWrapper();
                if(layer.visible){
                	layer.layer.setMap(map);
                	layer.percent = 100;
					updateProgress();
                	groundOverlayOn = true
              		$('#'+layer.legendDivID).show();
                	layer.layer.setOpacity(layer.opacity);
                	layer.rangeOpacity = layer.opacity;
                	
                }else{layer.rangeOpacity = 0};
                   setRangeSliderThumbOpacity();          

            };
            updateGroundOverlay();
            // if(layer.visible){layer.opacity = 1}
                // else{this.opacity = 0}
            google.maps.event.addListener(map,'zoom_changed',function(){updateGroundOverlay()});

            google.maps.event.addListener(map,'dragend',function(){updateGroundOverlay()});
             $('#' + spinnerID).hide();
			$('#' + visibleLabelID).show();
			setRangeSliderThumbOpacity();
	}

    if(layer.viz.dashboardSummaryLayer){
        function deleteAllSelected(){
            if(layer.visible){
                Object.keys(layer.dashboardSelectedFeatures).map(fn=>{
                    layer.dashboardSelectedFeatures[fn].polyList.map(p=>p.setMap(null));
                    delete layer.dashboardSelectedFeatures[fn];
                });
                updateDashboardCharts();
                updateDashboardHighlights();
            }
        }
        // $(`#${eraserID}`).show();
        $(`#${eraserID}`).click(deleteAllSelected)
        layer.dashboardSelectedFeatures = {};
        layer.dashboardSummaryMode = layer.viz.dashboardSummaryMode;
        function mouseEventTracker(event){
            console.log(event);
                console.log(`${layer.name} clicked`);
                
                if(dashboardAreaSelectionMode==='Click'){
                    event.feature.toGeoJson((r)=>{
                        // console.log(r);
                        let featureName = r.properties[layer.viz.dashboardFieldName].toString();
                        if(Object.keys(layer.dashboardSelectedFeatures).indexOf(featureName)===-1){
                            layer.dashboardSelectedFeatures[featureName]={'geojson':r,'polyList':[]};
                        
                        
                            function getCoords(c){
                                if(c.type === 'Polygon'){
                                    
                                    c.coordinates.map(c2=>{
                                        let polyCoordsT =c2.map(c3=>{return {lng:c3[0],lat:c3[1]}});
                                        layer.dashboardSelectedFeatures[featureName].polyList.push(new google.maps.Polygon({
                                            strokeColor:'#0FF',
                                            fillColor:'#0FF',
                                            fillOpacity:0.3,
                                            strokeOpacity: 0,
                                            strokeWeight: 0,
                                            path:polyCoordsT,
                                            zIndex:-999
                                        }));
                                    })
                                        
                                }else if(c.type === 'MultiPolygon'){
                                    // console.log(c);
                                    c.coordinates.map(c2=>getCoords({type:'Polygon',coordinates:c2}))//c2.map(c3=>c3.map(c4=>coords.push({lng:c4[0],lat:c4[1]}))));
                                }else if(c.type === 'GeometryCollection'){
                                    c.geometries.map(g=>getCoords(g))
                                }
                            }
                            getCoords(r.geometry);
                            
                            
                            // var infoContent = `<table class="table table-hover bg-white">
                            // <tbody>`
                        
                            // Object.keys(info).map(function(name){
                            //     var value = info[name];
                            //     infoContent +=`<tr><th>${name}</th><td>${value}</td></tr>`;
                            // });
                            // infoContent +=`</tbody></table>`;
                            
                            
                            
                            layer.dashboardSelectedFeatures[featureName].polyList.map(p=>p.setMap(map));
                            
                        }else{
                            console.log(`Removing ${featureName}`)
                            layer.dashboardSelectedFeatures[featureName].polyList.map(p=>p.setMap(null));
                            delete layer.dashboardSelectedFeatures[featureName];
                        }
                        
                        let selectedNames = Object.keys(layer.dashboardSelectedFeatures).join(',');
                        // $('#dashboard-results-collapse-div').append(selectedNames);
                        updateDashboardCharts();
                    })
                }
                

               
                
                
                
                
                // console.log(polyPath);
                // var prop = event.feature.getProperty(layer.viz.dashboardFieldName);
                // console.log(prop)
                
            }
        
        // layer.layer.addListener('click', mouseEventTracker)

        // layer.dragBox=addDragBox();
        // layer.dragBox.addListenTo(layer.layer,layer.id);
        // layer.dragBox.startListening();

//   Object.values(layerObj).filter(l=>l.viz.dashboardSummaryLayer).map(v=>dragBox.addListenTo(v.layer,v.id))
        // layer.layer.addListener('mouseover', mouseEventTracker)
    }
}
//////////////////////////////////////////////////
// Transition charting input UI setup
function getTransitionRowData(){
    var periods = [];
    var periodsValid = true;
    periods.push([parseInt($('#first-transition-row td input:first').val()),
                  parseInt($('#first-transition-row td input:last').val())]);
  
  
    let rowI = 1
    $('#added-transition-rows tr').each(function() {
      let row = [];
      let colI = 0;
      $(this).find("td").each(function(){
        $(this).find("input").each(function(){
          let v = parseInt($(this).val());
          row.push(v);
          });
          colI++;
         });
        periods.push(row);
        rowI++;
    });
    periods.push([parseInt($('#last-transition-row td input:first').val()),
                  parseInt($('#last-transition-row td input:last').val())]);
    var errorDict = {
        'blank':'One or more blank value found',
        'outsideYearRange':`Found years outside available year range. Please ensure all years are >= ${activeStartYear} and <= ${activeEndYear}.`,
        'backwards':'One or more row has a first year that is greater than the last year',
        'overlap':'Please ensure all transition periods have values and are in succession of one another and do not overlap'

    };
    var errorList = [];
    rowI = 0
    periods.map(row=>{
        row.map(n=>{
            if(isNaN(n)){errorList.push('blank');}
            if(n < activeStartYear || n > activeEndYear){errorList.push('outsideYearRange')}
        })
        if(row[1]<row[0]){errorList.push('backwards')}
        if(rowI>0){
            let previousRow = periods[rowI-1];
            if(previousRow[1]>=row[0]){errorList.push('overlap')}
        }
        rowI++
    });
    if(errorList.length>0){
        let errorMessage = 'The following errors were found:<br>'+unique(errorList).map(e=>errorDict[e]).join('<br>');
        showMessage('Invalid Transition Periods Provided',errorMessage);
        periodsValid=false;
    }   
    if(periodsValid){
      return periods;
    }else{
      return null;
    }
    
  }
function setupTransitionPeriodUI(){

  $('#transition-periods-container').empty();
  $('#transition-periods-container').append(`
  <hr>
  <div class="row pb-2" title='Select Periods for Transition Area Charting. Please ensure each period does not completely overlap with the one preceeding it.'>
      <div style='padding-left:0.5rem;padding-right:0.5rem;width:100%;'>
  <p style='font-size:1.25rem;' >Transition Charting Periods</p>
          <table class="table " id="transition-period-table">
              <thead>
                  <tr>
                      
                      <th class="text-center">
                          First Year
                      </th>
                      <th class="text-center">
                          Last Year
                      </th>
                      
                  </tr>
              </thead>
              <tbody id='default-transition-start'> </tbody>
      <tbody id='added-transition-rows'></tbody>
      <tbody id='default-transition-end'></tbody>
     
          </table>

  <div class="input-group-prepend pl-2">
                          <button title = 'Click to add a transition period' class=" btn input-group-text bg-white search-box pr-1 pl-2" id="add-transition-row" onclick="addTransitionRow()"><i class="fa fa-plus teal " ></i></button>

                          <button title = 'Click to remove a transition period' style = 'border-radius: 0px 3px 3px 0px' class=" btn input-group-text bg-white search-box pr-1 pl-2" id="remove-transition-row" onclick="removeLastTransitionRow()"><i class="fa fa-minus teal "></i></button>
                      </div>
      </div>
  
  </div>
  
`);
addRow('default-transition-start','first-transition-row',activeStartYear,activeStartYear+2,true);
addRow('default-transition-end','last-transition-row',activeEndYear-2,activeEndYear,true);
}
var transitionRowI=0;



function addRow(containerID,rowID,yr1,yr2,isBookend=false){
$(`#${containerID}`).append(`<tr id='${rowID}'>

<td>
<input type="number" min=${activeStartYear} max=${activeEndYear} title='Enter year between the year ranges above and below this row' value='${yr1}' placeholder='Enter Year' class="form-control"/>
</td>
<td>
<input type="number" min=${activeStartYear} max=${activeEndYear} title='Enter year between the year ranges above and below this row' value='${yr2}'  placeholder='Enter Year' class="form-control"/>
</td>
</tr>`);

if(!isBookend){
    $(`#${rowID}`).append(`<td>
    <button title = 'Click to remove this transition period' style = 'border-radius: 0px 3px 3px 0px' class=" btn input-group-text bg-white search-box pr-1 pl-2" onclick="removeRow('${rowID}')" id="${rowID}-remove-transition-row"><i class="fa fa-close teal "></i></button>
  </td>`);
}else{
    $(`#${rowID}`).append(`<td>
    <button disabled title = 'Cannot remove this transition period since it is at the start or end' style = 'border-radius: 0px 3px 3px 0px' class=" btn input-group-text bg-white search-box pr-1 pl-2" onclick="removeRow('${rowID}')" id="${rowID}-remove-transition-row"><i class="fa fa-close gray invisible"></i></button>
  </td>`);
}

}

function removeRow(rowID){
    console.log(rowID)
    $(`#${rowID}`).remove();
    }
function addTransitionRow(){
    addRow('added-transition-rows',`transition-row-${transitionRowI}`,'','');
    transitionRowI++; 
    }
function removeLastTransitionRow(){
    $('#added-transition-rows tr:last').remove();
    }

/*This script constructs the page depending on the chosen mode*/
/*Put main elements on body*/
$('body').append(staticTemplates.map);

$('body').append(staticTemplates.mainContainer);
$('body').append(staticTemplates.sidebarLeftContainer);

$('body').append(staticTemplates.geeSpinner);


$('body').append(staticTemplates.bottomBar);

// $('#summary-spinner').show();

$('#main-container').append(staticTemplates.sidebarLeftToggler);
if(mode==='lcms-dashboard'){
  $('body').append(staticTemplates.lcmsSpinner);
  // $('body').append(staticTemplates.dashboardResultsDiv);
  $('body').append(staticTemplates.dashboardResultsContainer);
}
$('#sidebar-left-header').append(staticTemplates.topBanner);



/////////////////////////////////////////////////////////////////////
/*Check to see if modals should be shown*/
if(localStorage['showIntroModal-'+mode] == undefined){
  localStorage['showIntroModal-'+mode] = 'true';
  }


/////////////////////////////////////////////////////////////////////
/*Add study area dropdown if LCMS*/
if(mode === 'LCMS-pilot' ){
  $('#title-banner').append(staticTemplates.studyAreaDropdown);
  if(studyAreaSpecificPage){
    $('#study-area-label').removeClass('dropdown-toggle');
  }else{
    Object.keys(studyAreaDict).map(function(k){addStudyAreaToDropdown(k,studyAreaDict[k].popOver);});
  }

}

$('#sidebar-left-header').append(staticTemplates.placesSearchDiv);

// function fitTestCustom(fitID,desiredWidth){
//   while($('#title-banner').width())
// }
// fitTestCustom('title-banner',$('#title-banner').width()-50)

// $('#study-area-label').fitText(1.8);
if(['LCMS','lcms-base-learner','Ancillary','LT','IDS','lcms-dashboard'].indexOf(mode)>-1){
  $('#title-banner-icon-right').attr('src','images/logo_icon_lcms-data-viewer.svg');
  $('#title-banner-icon-right').attr('alt','LCMS icon');
}else if(mode==='MTBS'){
  $('#title-banner-icon-right').attr('src','images/mtbs-logo.png');
  $('#title-banner-icon-right').attr('alt','MTBS icon')
}else{
  $('#title-banner-icon-right').hide();
}

//1.55 = 'LCMS data explorer.length'
//1.6 = 'lcms data dashboard.length'
// fittextCoeff = len*0.05+0.65
// $('#title-banner').fitText(`${topBannerParams.leftWords} ${topBannerParams.centerWords} ${topBannerParams.rightWords}`.length*0.05+0.65);
function adjustTitleBanner(){
  $('.title-banner-icon').height(convertRemToPixels(1.5));
  $('#title-banner').fitText(1.6);
  setTimeout(() => {
    $('#title-banner').addClass('noWrap');
    $('.title-banner-icon').height($('.title-banner-label').height()-convertRemToPixels(0.5));
    $('#title-banner').removeClass('noWrap');
  }, 500);
}
adjustTitleBanner();


function populateDownloads(){
  var toggler = document.getElementsByClassName("caret");
  var i;
  for (i = 0; i < toggler.length; i++) {
    toggler[i].addEventListener("click", function() {
      // console.log(this)
      this.parentElement.querySelector(".nested").classList.toggle("active");
      // this.parentElement.querySelector(".nested").classList.toggle("treeOff");
      this.classList.toggle("caret-down");
      // this.classList.toggle("treeOff");
    });
  }
  }

function toggleAdvancedOn(){
    $("#threshold-container").slideDown();
    $("#advanced-radio-container").slideDown();  
}
function toggleAdvancedOff(){
    $("#threshold-container").slideUp();
    $("#advanced-radio-container").slideUp();  
}
/////////////////////////////////////////////////////////////////////
/*Start adding elements to page based on chosen mode*/
if(mode === 'LCMS-pilot' || mode === 'LCMS'){
  var minYear = startYear;var maxYear = endYear;
  // console.log(urlParams)  
  if(urlParams.startYear == null || urlParams.startYear == undefined){
      urlParams.startYear = startYear;
  }
  if(urlParams.endYear == null || urlParams.endYear == undefined){
     urlParams.endYear = endYear;
  }
  if(urlParams.addLCMSTimeLapsesOn == null || urlParams.addLCMSTimeLapsesOn == undefined){
     urlParams.addLCMSTimeLapsesOn = 'no';
  }

  
  // console.log(urlParams)
 
  /*Construct panes in left sidebar*/
  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS',`<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>`,false,null,'Adjust parameters used to filter and sort LCMS products');
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div','LCMS DATA',`<img class='panel-title-svg-sm'alt="LCMS icon" src="./Icons_svg/logo_icon_lcms-data-viewer.svg">`,true,null,'LCMS DATA layers to view on map');
  // $('#layer-list-collapse-label').append(`<button class = 'btn' title = 'Refresh layers if tiles failed to load' id = 'refresh-tiles-button' onclick = 'jitterZoom()'><i class="fa fa-refresh"></i></button>`)
  addCollapse('sidebar-left','reference-layer-list-collapse-label','reference-layer-list-collapse-div','REFERENCE DATA',`<img class='panel-title-svg-lg'  alt="Layers icon" src="./Icons_svg/data-layers_ffffff.svg">`,false,null,'Additional relevant layers to view on map intended to provide context for LCMS DATA');
  
  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<img class='panel-title-svg-lg'  alt="Tools icon" src="./Icons_svg/tools_ffffff.svg">`,false,'','Tools to measure and chart data provided on the map');

  addCollapse('sidebar-left','download-collapse-label','download-collapse-div','DOWNLOAD DATA',`<img class='panel-title-svg-lg'  alt="Downloads icon" src="./Icons_svg/dowload_ffffff.svg">`,false,``,'Download LCMS products for further analysis');
  addCollapse('sidebar-left','support-collapse-label','support-collapse-div','SUPPORT',`<img class='panel-title-svg-lg'  alt="Support icon" src="./Icons_svg/support_ffffff.svg">`,false,``,'If you need any help');

  // $('#parameters-collapse-div').append(staticTemplates.paramsDiv);

  //Construct parameters form
 
  if(['standard','advanced'].indexOf(urlParams.analysisMode) === -1){
    urlParams.analysisMode = 'standard'
  }
  if(['year','prob'].indexOf(urlParams.summaryMethod) === -1){
    urlParams.summaryMethod = 'year'
  }

  var tAnalysisMode = urlParams.analysisMode;
  var tAddLCMSTimeLapsesOn = urlParams.addLCMSTimeLapsesOn;
  if(mode === 'LCMS'){
    // $('#parameters-collapse-div').append(`<hr>`);
    // $('#parameters-collapse-div').append(`<p>Additional Functionality:</p>`);
  // $('#parameters-collapse-div').append(staticTemplates.addTimelapsesButton);
  addRadio('parameters-collapse-div','addTimeLapses-radio','Add LCMS Time Lapses:','No','Yes','urlParams.addLCMSTimeLapsesOn','no','yes','','','Add interactive time lapse of LCMS Change, Land Cover, and Land Use products. This will slow down the map loading');
  $('#parameters-collapse-div').append(`<hr>`);
  if(tAddLCMSTimeLapsesOn === 'yes'){
    $('#addTimeLapses-radio-second_toggle_label').click();
  }
  }
  addRadio('parameters-collapse-div','analysis-mode-radio','Choose which mode:','Standard','Advanced','urlParams.analysisMode','standard','advanced','toggleAdvancedOff()','toggleAdvancedOn()','Standard mode provides the core LCMS products based on carefully selected parameters. Advanced mode provides additional LCMS products and parameter options')

  urlParams.analysisMode = tAnalysisMode ;
  $('#parameters-collapse-div').append(`<hr>`);

  addDualRangeSlider('parameters-collapse-div','Choose analysis year range:','urlParams.startYear','urlParams.endYear',minYear, maxYear, urlParams.startYear, urlParams.endYear, 1,'analysis-year-slider','null','Years of LCMS data to include for land cover, land use, loss, and gain')
  

  $('#parameters-collapse-div').append(`<hr>
                                          <div id='threshold-container' style="display:none;width:100%"></div>
                                          <div id='advanced-radio-container' style="display: none;"></div>`)

  if( mode === 'LCMS-pilot' ){
  addRangeSlider('threshold-container','Choose loss threshold:','lowerThresholdDecline',0, 1, lowerThresholdDecline, 0.05,'decline-threshold-slider','null',"Threshold window for detecting loss.  Any loss probability greater than or equal to this value will be flagged as loss ")
  $('#threshold-container').append(`<hr>`);
  addRangeSlider('threshold-container','Choose gain threshold:','lowerThresholdRecovery',0, 1, lowerThresholdRecovery, 0.05,'recovery-threshold-slider','null',"Threshold window for detecting gain.  Any gain probability greater than or equal to this value will be flagged as gain ")
  $('#advanced-radio-container').append(`<hr>`);
  $('#advanced-radio-container').append(`<div id = 'fast-slow-threshold-container' ></div>`);
  addRangeSlider('fast-slow-threshold-container','Choose slow loss threshold:','lowerThresholdSlowLoss',0, 1, lowerThresholdSlowLoss , 0.05,'slow-loss-threshold-slider','null',"Threshold window for detecting loss.  Any loss probability greater than or equal to this value will be flagged as loss ")
  $('#fast-slow-threshold-container').append(`<hr>`);
  addRangeSlider('fast-slow-threshold-container','Choose fast loss threshold:','lowerThresholdFastLoss',0, 1, lowerThresholdFastLoss, 0.05,'fast-loss-threshold-slider','null',"Threshold window for detecting loss.  Any loss probability greater than or equal to this value will be flagged as loss ")
  $('#advanced-radio-container').append(`<hr>`);

  addRadio('advanced-radio-container','treemask-radio','Constrain analysis to areas with trees:','Yes','No','applyTreeMask','yes','no','','','Whether to constrain LCMS products to only treed areas. Any area LCMS classified as tree cover 2 or more years will be considered tree. Will reduce commission errors typical in agricultural and water areas, but may also reduce changes of interest in these areas.')
  $('#advanced-radio-container').append(`<hr>`);
 }
  var tSummaryMethod = urlParams.summaryMethod;
  addRadio('advanced-radio-container','summaryMethod-radio','Summary method:','Most recent year','Highest prob','urlParams.summaryMethod','year','prob','','','How to choose which value for disturbance and growth to display.  Choose the value with the highest model confidence or from the most recent year above the threshold.');
  urlParams.summaryMethod = tSummaryMethod;

  $('#advanced-radio-container').append(`<hr>`);
  // addRadio('advanced-radio-container','whichIndex-radio','Index for charting:','NDVI','NBR','whichIndex','NDVI','NBR','','','The vegetation index that will be displayed in the "Query LCMS Time Series" tool')
  // $('#advanced-radio-container').append(`<hr>`);
  $('#parameters-collapse-div').append(staticTemplates.reRunButton);


  //Set up layer lists
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  $('#reference-layer-list-collapse-div').append(`<ul id="reference-layer-list" class = "layer-list"></ul>`);

  if(mode === 'LCMS'){
    function populateLCMSDownloads(){
      var toggler = document.getElementsByClassName("caret");
    var i;

    for (i = 0; i < toggler.length; i++) {
      toggler[i].addEventListener("click", function() {
        // console.log(this)
        this.parentElement.querySelector(".nested").classList.toggle("active");
        // this.parentElement.querySelector(".nested").classList.toggle("treeOff");
        this.classList.toggle("caret-down");
        // this.classList.toggle("treeOff");
      });
    }
    }
    $('#download-collapse-div').append(staticTemplates.lcmsProductionDownloadDiv);
    
  }else{
    $('#download-collapse-div').append(staticTemplates.downloadDiv);
  }
  $('#support-collapse-div').append(staticTemplates.supportDiv);

  if(tAnalysisMode === 'advanced'){
    $('#analysis-mode-radio-second_toggle_label').click();
  }
  if(tSummaryMethod === 'prob'){
    $('#summaryMethod-radio-second_toggle_label').click();
  }

}else if(mode === 'lcms-dashboard'){
  $('#title-banner').fitText(1.7);
  var minYear = startYear;var maxYear = endYear;
  // console.log(urlParams)  
  if(urlParams.startYear == null || urlParams.startYear == undefined){
      urlParams.startYear = startYear;
  }
  if(urlParams.endYear == null || urlParams.endYear == undefined){
     urlParams.endYear = endYear;
  }
  
  $('#sidebar-left-header').append(staticTemplates.dashboardProgressDiv);
  
  addCollapse('dashboard-results-list','charts-collapse-label','charts-collapse-div','CHARTS',`<i role="img" class="fa fa-bar-chart mr-1" aria-hidden="true"></i>`,true,null,'Line chart LCMS summary results');

  addCollapse('dashboard-results-list','tables-collapse-label','tables-collapse-div','TABLES',`<i role="img" class="fa fa-list mr-1" aria-hidden="true"></i>`,true,null,'Tabular LCMS summary results');

  $('#tables-collapse-div').append(staticTemplates.dashboardHighlightsContainer);
  
  $('#charts-collapse-div').removeClass('px-5');
  $('#tables-collapse-div').removeClass('px-5');
  $('.plotly-chart').css('margin-left','');
  $('#charts-collapse-label').on('click',()=>{console.log('clicked');updateDashboardCharts();})
  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS',`<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>`,false,null,'Adjust parameters used to filter and sort LCMS products as well as change how summary areas are selected');
  //addDualRangeSlider('parameters-collapse-div','Choose analysis year range:','urlParams.startYear','urlParams.endYear',minYear, maxYear, urlParams.startYear, urlParams.endYear, 1,'analysis-year-slider','null','Years of LCMS data to include for land cover, land use, loss, and gain',null,()=>{updateDashboardCharts();updateDashboardHighlights();})
  
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div','LCMS SUMMARY AREAS',`<img class='panel-title-svg-sm'alt="LCMS icon" src="./Icons_svg/logo_icon_lcms-data-viewer.svg">`,true,null,'LCMS summary areas to view on map');
 
  $('#sidebar-left').append('<div id="charts-highlights-placeholder"</div>')
  addCollapse('sidebar-left','reference-layer-list-collapse-label','reference-layer-list-collapse-div','LCMS DATA',`<img class='panel-title-svg-sm'alt="LCMS icon" src="./Icons_svg/logo_icon_lcms-data-viewer.svg">`,false,null,'LCMS DATA layers to view on map');
  
  
    addCollapse('sidebar-left','support-collapse-label','support-collapse-div','SUPPORT',`<img class='panel-title-svg-lg'  alt="Support icon" src="./Icons_svg/support_ffffff.svg">`,false,``,'If you need any help');

  addMultiRadio('parameters-collapse-div','summary-area-selection-radio','Choose how to select areas','dashboardAreaSelectionMode',{'View-Extent':true,'Click':false,'Drag-Box':false});
  // $('#parameters-collapse-div').append('<hr>');
   
  //addSubCollapse('parameters-collapse-div','questions-dashboard-params-label','questions-dashboard-params-div','Questions', '',false,'Pre-selected parameter combinations')
  //////////////////////////////////// Add summaryArea to question dict in future////////////////////////////////////////////
  var questionDict = {
    fire:{
      title: 'Post Fire Succession',
      hoverText:'Some more info about fire succession',
      productHighlightClasses:{"Land-Cover": true,"Land-Use": false,"Change":true},
      changeHighlightClasses : {"Stable": false,"Slow-Loss": true,"Fast-Loss": true,"Gain": true},
      lcHighlightClasses : {"Trees": true,"Tall-Shrubs":false,"Shrubs": true,"Grass-Forb-Herb": true,"Barren-or-Impervious": true,'Snow-or-Ice':false,"Water": false},
      luHighlightClasses : {"Agriculture": false,"Developed": false,"Forest": false,"Non-Forest-Wetland": false,"Rangeland-or-Pasture": false,'Other':false},
      //summaryArea : {"Forests": false, "Forest-Districts": false, "Planning-Units":false, "CFLRP":false, "Census-Urban-Areas":false, "Counties":false, "HUC-6":false}
    },
    glacialRecession:{
      title: 'Glacial Recession',
      hoverText:'Some more info about glacial succession',
      productHighlightClasses:{"Land-Cover": true,"Land-Use": false,"Change":false},
      changeHighlightClasses : {"Stable": false,"Slow-Loss": false,"Fast-Loss": false,"Gain": false},
      lcHighlightClasses : {"Trees": false,"Tall-Shrubs":true,"Shrubs": false,"Grass-Forb-Herb": false,"Barren-or-Impervious": true,'Snow-or-Ice': true,"Water": true},
      luHighlightClasses : {"Agriculture": false,"Developed": false,"Forest": false,"Non-Forest-Wetland": false,"Rangeland-or-Pasture": false,'Other':false}
    },
    forestToDeveloped:{
      title: 'Forest and Agriculture to Developed',
      hoverText:'Forest and Agriculture land changing to developed',
      productHighlightClasses:{"Land-Cover": false,"Land-Use": true,"Change":false},
      changeHighlightClasses : {"Stable": false,"Slow-Loss": false,"Fast-Loss": false,"Gain": false},
      lcHighlightClasses : {"Trees": false,"Tall-Shrubs": false,"Shrubs": false,"Grass-Forb-Herb": false,"Barren-or-Impervious": false,'Snow-or-Ice': false,"Water": false},
      luHighlightClasses : {"Agriculture": true,"Developed": true,"Forest": true,"Non-Forest-Wetland": false,"Rangeland-or-Pasture": false,'Other':false}
    },
    waterLoss:{
      title: 'Water Change',
      hoverText:'Loss of Water',
      productHighlightClasses:{"Land-Cover": true,"Land-Use": false,"Change":true},
      changeHighlightClasses : {"Stable": false,"Slow-Loss": false,"Fast-Loss": true,"Gain": false},
      lcHighlightClasses : {"Trees": false,"Tall-Shrubs": false,"Shrubs": false,"Grass-Forb-Herb": false,"Barren-or-Impervious": false,'Snow-or-Ice': false,"Water": true},
      luHighlightClasses : {"Agriculture": false,"Developed": false,"Forest": false,"Non-Forest-Wetland": false,"Rangeland-or-Pasture": false,'Other':false}
    },
    customQuestion:{
      title: 'Custom - Choose your own Advanced Parameters to summarize',
      hoverText:'All products turned on for charting but empty until populated by user',
      productHighlightClasses:{"Land-Cover": true,"Land-Use": true,"Change":true},
      changeHighlightClasses : {"Stable": false,"Slow-Loss": false,"Fast-Loss": false,"Gain": false},
      lcHighlightClasses : {"Trees": false,"Tall-Shrubs": false,"Shrubs": false,"Grass-Forb-Herb": false,"Barren-or-Impervious": false,'Snow-or-Ice': false,"Water": false},
      luHighlightClasses : {"Agriculture": false,"Developed": false,"Forest": false,"Non-Forest-Wetland": false,"Rangeland-or-Pasture": false,'Other':false}
    }
  }
  // a variable to establish whether a 'share'/'deep' link is in play
  var deepLink = false;

  // Use first listed question as default. If the questionVar is undefined/null, then the first question is default; otherwise a share link is in use
  if(urlParams.questionVar == undefined || urlParams.questionVar === null){
    urlParams.questionVar = Object.keys(questionDict)[0];
  }
  else{
    deepLink = true;
  }

  // creates a Bootstrap dropdown to contain the questions
  function makeQuestionDropdown(){
    //addDropdown('questions-dashboard-params-div','questions-dashboard-dropdown','Choose a Question','urlParams.questionVar','Choose a Question to automatically select certain LCMS products to summarize');
    addDropdown('parameters-collapse-div','questions-dashboard-dropdown','Learn More About','urlParams.questionVar','Choose a Topic to automatically select certain LCMS products to summarize');
  }

  // populates the dropdown with the questions (keys) from the questionDict 
  function populateQuestionDropdown(){
    Object.keys(questionDict).map(k=>{
      addDropdownItem('questions-dashboard-dropdown',questionDict[k].title,k,questionDict[k].hoverText); 
    })
  }

  // changes the LCMS product selections based on the question chosen
  //////////////////////////////// add summary area as part of Question functionality in future//////////////////////////////////////////
  function selectQuestion(selectedQuestion){
    var selectedProducts = selectedQuestion.productHighlightClasses;
    // console.log(selectedProducts);
    Object.keys(selectedProducts).map(k=>{
      var checkboxID = `#productHighlightClasses${k}-checkbox`;
      // console.log(checkboxID);
      $(checkboxID).prop('checked', selectedProducts[k]);
      urlParams.productHighlightClasses[k] = selectedProducts[k];
    })
    var selectedChangeClasses = selectedQuestion.changeHighlightClasses;
    // console.log(selectedChangeClasses);
    Object.keys(selectedChangeClasses).map(k=>{
      var checkboxID = `#changeHighlightClasses${k}-checkbox`;
      // console.log(checkboxID);
      $(checkboxID).prop('checked', selectedChangeClasses[k]);
      urlParams.changeHighlightClasses[k] = selectedChangeClasses[k];
    })
    var selectedLCclasses = selectedQuestion.lcHighlightClasses;
    // console.log(selectedLCclasses);
    Object.keys(selectedLCclasses).map(k=>{
      var checkboxID = `#lcHighlightClasses${k}-checkbox`;
      // console.log(checkboxID);
      $(checkboxID).prop('checked', selectedLCclasses[k]);
      urlParams.lcHighlightClasses[k] = selectedLCclasses[k];
    })
    var selectedluClasses = selectedQuestion.luHighlightClasses;
    // console.log(selectedluClasses);  
    Object.keys(selectedluClasses).map(k=>{
      var checkboxID = `#luHighlightClasses${k}-checkbox`;
      // console.log(checkboxID);
      $(checkboxID).prop('checked', selectedluClasses[k]);
      urlParams.luHighlightClasses[k] = selectedluClasses[k];
    })
    // var selectedSummaryAreas = selectedQuestion.saHighlightClasses;
    // console.log(selectedSummaryAreas);  
    // Object.keys(selectedSummaryAreas).map(k=>{
    //   var checkboxID = `#saHighlightClasses${k}-checkbox`;
    //   console.log(checkboxID);
    //   $(checkboxID).prop('checked', selectedSummaryAreas[k]);
    //   urlParams.saHighlightClasses[k] = selectedSummaryAreas[k];
    // })
    updateHighlightsProductSelectionDict();
    updateDashboardHighlights();
    updateDashboardCharts();
  }

  function listenForQuestionChangechangeQuestion(){
    $('select#questions-dashboard-dropdown').change( ()=>{
      console.log('A question was asked')
      selectQuestion(questionDict[urlParams.questionVar]);
    });
  }

  makeQuestionDropdown();
  populateQuestionDropdown();
  $('#questions-dashboard-dropdown').val(urlParams.questionVar);  
  listenForQuestionChangechangeQuestion();

  addDualRangeSlider('parameters-collapse-div','Choose analysis year range:','urlParams.startYear','urlParams.endYear',minYear, maxYear, urlParams.startYear, urlParams.endYear, 1,'analysis-year-slider','null','Years of LCMS data to include for land cover, land use, loss, and gain',null,()=>{updateDashboardCharts();updateDashboardHighlights();})
 
  addSubCollapse('parameters-collapse-div','advanced-dashboard-params-label','advanced-dashboard-params-div','Advanced Parameters', '',false,'');
  if(urlParams.chartUnits === null || urlParams.chartUnits === undefined){
    urlParams.chartUnits = {"Percentage": true,"Acres": false,"Hectares": false}
  }
  addMultiRadio('advanced-dashboard-params-div','which-units-radio','Chart Area Units','chartFormat',urlParams.chartUnits);
 
  if(urlParams.pairwiseDiff === null || urlParams.pairwiseDiff === undefined){
    urlParams.pairwiseDiff = {'Annual':true,'Annual-Change':false}
  }
  addMultiRadio('advanced-dashboard-params-div','summary-pairwise-diff-radio','Annual Amount or Change in Annual Amount','pairwiseDiff',urlParams.pairwiseDiff);
 
  var highlightsProductsLookup = {'Land_Cover':'Land-Cover', 'Land_Use':'Land-Use', 'Change':'Change'};
  var highlightsLCLookup = {'Trees':'Trees','Tall-Shrubs':'Tall Shrubs','Shrubs':'Shrubs','Grass-Forb-Herb':'Grass/Forb/Herb','Barren-or-Impervious':'Barren or Impervious','Water':'Water','Snow-or-Ice':'Snow or Ice'};
  var highlightsLULookup = {'Agriculture':'Agriculture','Developed':'Developed','Forest':'Forest','Non-Forest-Wetland':'Non-Forest Wetland','Rangeland-or-Pasture':'Rangeland or Pasture','Other':'Other'};
  var highlightsChangeLookup = {'Stable':'Stable','Slow-Loss':'Slow Loss','Fast-Loss':'Fast Loss','Gain':'Gain'};
  
  var highlightLCMSProducts = {'Product':[],'Land_Cover':[],'Land_Use':[],'Change':[]};
  var highlightsSortingDict = {'Trees':'asc','Tall-Shrubs': 'desc','Shrubs':'desc','Grass/Forb/Herb':'desc','Barren or Impervious':'desc','Water':'asc','Snow or Ice':'asc',
'Agriculture':'asc','Developed':'desc','Forest':'asc','Non-Forest Wetland':'asc','Rangeland or Pasture':'desc','Other':'desc',
'Stable':'asc','Slow Loss':'desc','Fast Loss':'desc','Gain':'desc'};
  function updateHighlightsProductSelectionDict(){
    highlightLCMSProducts['Product'] = Object.keys(productHighlightClasses).filter(k=>productHighlightClasses[k]).map(v=>highlightsProductsLookup[v]);
    highlightLCMSProducts['Land_Cover']=Object.keys(lcHighlightClasses).filter(k=>lcHighlightClasses[k]).map(v=>highlightsLCLookup[v]);
    highlightLCMSProducts['Land_Use']=Object.keys(luHighlightClasses).filter(k=>luHighlightClasses[k]).map(v=>highlightsLULookup[v]);
    highlightLCMSProducts['Change']=Object.keys(changeHighlightClasses).filter(k=>changeHighlightClasses[k]).map(v=>highlightsChangeLookup[v]);
  }
  // all three LCMS products turned on by default at initial load
  if(urlParams.productHighlightClasses === null || urlParams.productHighlightClasses === undefined){
    urlParams.productHighlightClasses = {"Change":true,"Land-Cover": true,"Land-Use": true}
  }
  // addCheckboxes('advanced-dashboard-params-div','which-products-radio','Choose which LCMS outputs to chart','productHighlightClasses',urlParams.productHighlightClasses);
  var productHighlightClasses = urlParams.productHighlightClasses;

  if(urlParams.annualTransition === null || urlParams.annualTransition === undefined){
    urlParams.annualTransition = {"Annual": true,"Transition": false}
  }
  addCheckboxes('advanced-dashboard-params-div','annual-transition-radio','Choose which summary methods to chart','annualTransition',urlParams.annualTransition);

   $('#advanced-dashboard-params-div').append('<hr>');
  
  // default change products at initial load
  if(urlParams.changeHighlightClasses === null || urlParams.changeHighlightClasses === undefined){
    urlParams.changeHighlightClasses = {"Stable": false,"Slow-Loss":true,"Fast-Loss": true,"Gain": true}
  }
  addCheckboxes('advanced-dashboard-params-div','change-highlights-radio','Change Classes','changeHighlightClasses',urlParams.changeHighlightClasses);
  $('#advanced-dashboard-params-div').append('<hr>');
  
  // default LC products at initial load
  if(urlParams.lcHighlightClasses === null || urlParams.lcHighlightClasses === undefined){
    urlParams.lcHighlightClasses = {"Trees": true,"Tall-Shrubs":false,"Shrubs": true,"Grass-Forb-Herb": true,"Barren-or-Impervious": false,'Snow-or-Ice':false,"Water": false}
  }
  addCheckboxes('advanced-dashboard-params-div','lc-highlights-radio','Land Cover Classes','lcHighlightClasses',urlParams.lcHighlightClasses);

  $('#advanced-dashboard-params-div').append('<hr>');
  // default LU products at initial load
  if(urlParams.luHighlightClasses === null || urlParams.luHighlightClasses === undefined){
    urlParams.luHighlightClasses = {"Agriculture": false,"Developed": false,"Forest": false,"Non-Forest-Wetland": false,'Other':false,"Rangeland-or-Pasture": false}
  }
  addCheckboxes('advanced-dashboard-params-div','lu-highlights-radio','Land Use Classes','luHighlightClasses',urlParams.luHighlightClasses);
  $('#lc-highlights-radio,#lu-highlights-radio,#change-highlights-radio').change( ()=>{
    if(Object.values(urlParams.changeHighlightClasses).indexOf(true)>-1){
      urlParams.productHighlightClasses['Change'] = true;
    }
    else{
      urlParams.productHighlightClasses['Change'] = false;
    };
    if(Object.values(urlParams.lcHighlightClasses).indexOf(true)>-1){
      urlParams.productHighlightClasses['Land-Cover'] = true;
    }
    else{
      urlParams.productHighlightClasses['Land-Cover'] = false;
    };
    if(Object.values(urlParams.luHighlightClasses).indexOf(true)>-1){
      urlParams.productHighlightClasses['Land-Use'] = true;
    }
    else{
      urlParams.productHighlightClasses['Land-Use'] = false;
    };
    updateHighlightsProductSelectionDict();
    updateDashboardHighlights();
    updateDashboardCharts();
  });
  updateHighlightsProductSelectionDict();
  $('#advanced-dashboard-params-div').append('<hr>');

  var ciDict = {'90':1.64,'95':1.96,'99':2.58};
  if(urlParams.ciLevel === null || urlParams.ciLevel === undefined){
    urlParams.ciLevel = {"90": false,"95": true,"99": false}
  }

  addMultiRadio('advanced-dashboard-params-div','ci-level-radio','Confidence Interval Significance Level','ciLevel',urlParams.ciLevel);
  
  $('#which-units-radio,#which-products-radio').change( ()=>{
    updateDashboardCharts();
    updateDashboardHighlights();
  });

  $('#annual-transition-radio').change( ()=>{
    updateDashboardCharts();
  });
  $('#ci-level-radio').change( ()=>{
    updateDashboardHighlights();
  });

  $('#analysis-year-slider-container').prop('title','Choose which years to include in the annual charts. The first and last year of this range of years will be uses for the highlights summaries.');
  $('#summary-area-selection-radio').prop('title','Choose how to select summary areas. "View-Extent" will automatically select all areas within the current map view extent. "Click" will all you to select areas by clicking on them. "Drag-Box" will allow you to select by creating a box');
  $('#summary-pairwise-diff-radio').prop('title','Choose whether to show the amount or the amount of change from the previous year of the selected area(s) of each cover/use/change type');
  $('#which-products-radio').prop('title','Choose which LCMS products to show in the charts, highlights, and report');
  $('#annual-transition-radio').prop('title','Choose which chart type to show. Annual will show the percent for each year while transition will show a Sankey chart');
  $('#change-highlights-radio').prop('title','Choose which change classes to include in the highlights tables');
  $('#lc-highlights-radio').prop('title','Choose which land cover classes to include in the highlights tables');
  $('#lu-highlights-radio').prop('title','Choose which land use classes to include in the highlights tables');
  $('#which-units-radio').prop('title','Choose which units to represent summary areas in charts and tables');
  $('#ci-level-radio').prop('title','Choose which significance level to use for computing the confidence interval and significant change');
  $('#annualTransitionannualTransitionTransition-checkbox-label').prop('title','Select this to show Sankey charts')
  // $('#layer-list-collapse-div').append(staticTemplates.dashboardProgressDiv);
  // $('#parameters-collapse-div').append()
  
  
  // $('#parameters-collapse-label').hide();
  // $('#parameters-collapse-div').hide();
  
//   let selectionMode;
//   $('#parameters-collapse-div').append(`<div id='drawing-mode-selection' class="btn-group btn-group-justified" title='Choose how to select areas'>
//                                           <button type="button" id = 'click-drawing-mode' value='click' class="btn btn-primary drawing-mode-selector">Click</button>
//                                           <button type="button" id = 'drag-drawing-mode' value = 'drag' class="btn btn-primary drawing-mode-selector">Drag</button>
//                                         </div>`)
// $('.drawing-mode-selector').on('click',function(e){
//   selectionMode=this.value;
// })
// $('#click-drawing-mode').click();
  // let selectionModeDiv = `<div><i class="fa fa-draw-polygon"></i>
  //                         </div>`
  // $('#parameters-collapse-div').append(selectionModeDiv);
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  $('#reference-layer-list-collapse-div').append(`<ul id="reference-layer-list" class = "layer-list"></ul>`);


}else if(mode === 'lcms-base-learner'){
  canExport = false;
  startYear = 1984;endYear = 2022;
  var minYear = startYear;var maxYear = endYear;
  if(urlParams.startYear == null || urlParams.startYear == undefined){
      urlParams.startYear = startYear;// = parseInt(urlParams.startYear);
  }
  if(urlParams.endYear == null || urlParams.endYear == undefined){
     urlParams.endYear = endYear;// = parseInt(urlParams.endYear);
  }
  if(urlParams.lossMagThresh == null || urlParams.lossMagThresh == undefined){
     urlParams.lossMagThresh = -0.15;// = parseInt(urlParams.endYear);
  }
  if(urlParams.gainMagThresh == null || urlParams.gainMagThresh == undefined){
     urlParams.gainMagThresh = 0.1;// = parseInt(urlParams.endYear);
  }

  if(urlParams.whichIndices2 == null || urlParams.whichIndices2 == undefined){
     urlParams.whichIndices2 = {'nir':false,'swir1':false,'swir2':false,'NBR':true,'NDVI':false};
  }
  
  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS','<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>',false,null,'Adjust parameters used to filter and sort LCMS products');

  addDualRangeSlider('parameters-collapse-div','Choose analysis year range:','urlParams.startYear','urlParams.endYear',minYear, maxYear, urlParams.startYear, urlParams.endYear, 1,'analysis-year-slider','null','Years of LCMS data to include for land cover, land use, loss, and gain')
addCheckboxes('parameters-collapse-div','index-choice-checkboxes','Choose which indices to analyze','whichIndices2',urlParams.whichIndices2)
  
  addSubCollapse('parameters-collapse-div','lt-params-label','lt-params-div','LANDTRENDR Params', '',false,'')
  // addSubCollapse('parameters-collapse-div','ccdc-params-label','ccdc-params-div','CCDC Params', '',false,'')
  
  addRangeSlider('lt-params-div','Loss Magnitude Threshold','urlParams.lossMagThresh',-0.8,-0.05,urlParams.lossMagThresh,0.05,'loss-mag-thresh-slider','','The threshold to detect loss for each LANDTRENDR segment.  Any difference for a given segement less than this threshold will be flagged as loss') 
  addRangeSlider('lt-params-div','Gain Magnitude Threshold','urlParams.gainMagThresh',0.05,0.8,urlParams.gainMagThresh,0.05,'gain-mag-thresh-slider','','The threshold to detect gain for each LANDTRENDR segment.  Any difference for a given segement greater than this threshold will be flagged as gain') 
  
  // addCheckboxes('ccdc-params-div','ccdc-index-choice-checkboxes','Choose which indices to include in CCDC fitted charts','whichIndices3',{'blue':false,'green':false,'red':false,'nir':false,'swir1':false,'swir2':false,'NBR':true,'NDVI':true,'NDMI':false,'wetness':false})
  // addRangeSlider('ccdc-params-div','Change Probability Threshold','ccdcChangeProbThresh',0,1,0.8,0.1,'ccdc-change-prob-thresh-slider','','The CCDC probabibility threshold to detect change.  Any probability for a given break greater than this threshold will be flagged as change') 
  
  // $('#lt-params-div').append(`<hr>`);
  $('#parameters-collapse-div').append(`<hr>`);
  $('#parameters-collapse-div').append(staticTemplates.reRunButton);

  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div','LCMS BASE LEARNER DATA',`<img style = 'width:1.2em;height:1.1em;margin-top:-0.2em;margin-left:-0.1em' class='image-icon mr-1' alt="LCMS icon" src="images/lcms-icon.png">`,true,null,'LCMS DATA layers to view on map');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');
  if(canExport){
    addCollapse('sidebar-left','download-collapse-label','download-collapse-div','DOWNLOAD DATA',`<i role="img" class="fa fa-cloud-download mr-1" aria-hidden="true"></i>`,false,``,'Download '+mode+' products for further analysis');
  }
  
}else if(mode === 'LT'){
  canExport = true;
  startYear = 1984;endYear = new Date().getYear()+1900;startJulian = 152;endJulian = 273;
  initialZoomLevel = 9;
  initialCenter = [37.64109979850402,-107.6917775643849];
  var minYear = startYear;var maxYear = endYear;
  if(urlParams.startYear == null || urlParams.startYear == undefined){
      urlParams.startYear = startYear;// = parseInt(urlParams.startYear);
  }
  if(urlParams.endYear == null || urlParams.endYear == undefined){
     urlParams.endYear = endYear;// = parseInt(urlParams.endYear);
  }
  if(urlParams.startJulian == null || urlParams.startJulian == undefined){
      urlParams.startJulian = startJulian;// = parseInt(urlParams.startYear);
  }
  if(urlParams.endJulian == null || urlParams.endJulian == undefined){
     urlParams.endJulian = endJulian;// = parseInt(urlParams.endYear);
  }

  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS','<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>',false,null,'Adjust parameters used to filter and sort '+mode+' products');
  
  addSubCollapse('parameters-collapse-div','comp-params-label','comp-params-div','Landsat Composite Params', '',false,'');
  $('#comp-params-div').append(`<hr>`);


  addDualRangeSlider('comp-params-div','Choose analysis year range:','urlParams.startYear','urlParams.endYear',minYear, maxYear, urlParams.startYear, urlParams.endYear, 1,'analysis-year-slider2','null','Years of '+mode+' data to include.')
  
  addDualRangeSlider('comp-params-div','Choose analysis date range:','urlParams.startJulian','urlParams.endJulian',1, 365, urlParams.startJulian, urlParams.endJulian, 1,'julian-day-slider','julian','Days of year of '+mode+' data to include for land cover, land use, loss, and gain')
    $('#comp-params-div').append(`<hr>`);

  if(urlParams.whichPlatforms === null || urlParams.whichPlatforms === undefined){
    urlParams.whichPlatforms = {"L5": true,"L7-SLC-On": true,"L7-SLC-Off": false,"L8": true,"L9": true}
  }
  addCheckboxes('comp-params-div','which-sensor-method-radio','Choose which Landsat platforms to include','whichPlatforms',urlParams.whichPlatforms);
  
    $('#comp-params-div').append(`<hr>`);

    if(urlParams.yearBuffer === null || urlParams.yearBuffer === undefined){
      urlParams.yearBuffer = 0
    }
    addRangeSlider('comp-params-div','Composite Year Buffer','urlParams.yearBuffer',0,2,urlParams.yearBuffer,1,'year-buffer-slider','','The number of adjacent years to include in a given year composite. (E.g. a value of 1 would mean the 2015 composite would have imagery from 2015 +- 1 year - 2014 to 2016)') 
   $('#comp-params-div').append(`<hr>`);

   if(urlParams.minObs === null || urlParams.minObs === undefined){
      urlParams.minObs = 3
    }
   addRangeSlider('comp-params-div','Minimum Number of Observations','urlParams.minObs',1,5,urlParams.minObs,1,'min-obs-slider','','Minimum number of observations needed for a pixel to be included. This helps reduce noise in composites. Any number less than 3 can result in poor composite quality') 
    $('#comp-params-div').append(`<hr>`);

  var compMethodDict = {"Median":false,"Medoid":true};
  if(urlParams.compMethod !== null && urlParams.compMethod !== undefined){
    Object.keys(compMethodDict).map(k => compMethodDict[k] = false);
    compMethodDict[urlParams.compMethod] = true;

  }
  addMultiRadio('comp-params-div','comp-method-radio','Compositing method','urlParams.compMethod',compMethodDict)
   $('#comp-params-div').append(`<hr>`);


  if(urlParams.whichCloudMasks === null || urlParams.whichCloudMasks === undefined){
    urlParams.whichCloudMasks = {'fMask-Snow':true,'cloudScore':false,'fMask-Cloud':true,'TDOM':false,'fMask-Cloud-Shadow':true};
  }
  addCheckboxes('comp-params-div','cloud-masking-checkboxes','Choose which cloud masking methods to use','whichCloudMasks',urlParams.whichCloudMasks)
   $('#comp-params-div').append(`<hr>`);

  var maskWaterDict = {"No":false,"Yes":true};
  if(urlParams.maskWater !== null && urlParams.maskWater !== undefined){
    Object.keys(maskWaterDict).map(k => maskWaterDict[k] = false);
    maskWaterDict[urlParams.maskWater] = true;

  }
  addMultiRadio('comp-params-div','water-mask-radio','Mask out water','urlParams.maskWater',maskWaterDict)
  
  // $('#parameters-collapse-div').append(`<hr>`);
  // addRadio('parameters-collapse-div','cloudScore-cloud-radio','Apply CloudScore','No','Yes','applyCloudScore','no','yes','','',"Whether to apply Google's Landsat CloudScore algorithm")
  // $('#parameters-collapse-div').append(`<hr>`);
  // addRadio('parameters-collapse-div','fmask-cloud-radio','Apply Fmask cloud mask','Yes','No','applyFmaskCloud','yes','no','','','Whether to apply Fmask cloud mask')
  // $('#parameters-collapse-div').append(`<hr>`);
  // addRadio('parameters-collapse-div','fmask-cloud-shadow-radio','Apply Fmask cloud shadow mask','Yes','No','applyFmaskCloudShadow','yes','no','','','Whether to apply Fmask cloud shadow mask')
  
 
  
  addSubCollapse('parameters-collapse-div','lt-params-label','lt-params-div','LANDTRENDR Params', '',false,'')
  
  if(urlParams.whichIndices === null || urlParams.whichIndices === undefined){
    urlParams.whichIndices = {'NBR':true,'NDVI':false,'NDMI':false,'NDSI':false,'brightness':false,'greenness':false,'wetness':false,'tcAngleBG':false};
  }
  addCheckboxes('lt-params-div','index-choice-checkboxes','Choose which indices to analyze','whichIndices',urlParams.whichIndices)
  $('#lt-params-div').append(`<hr>`);

  var LTSortByDict = {"largest":true,"steepest":false,"newest":false, "oldest":false,  "shortest":false, "longest":false};
  if(urlParams.LTSortBy !== null && urlParams.LTSortBy !== undefined){
    Object.keys(LTSortByDict).map(k => LTSortByDict[k] = false);
    LTSortByDict[urlParams.LTSortBy] = true;

  }
  addMultiRadio('lt-params-div','lt-sort-radio','Choose method to summarize LANDTRENDR change','urlParams.LTSortBy',LTSortByDict)
  

  if(urlParams.lossMagThresh === null || urlParams.lossMagThresh === undefined){
      urlParams.lossMagThresh = -0.15;
    }
  addRangeSlider('lt-params-div','Loss Magnitude Threshold','urlParams.lossMagThresh',-0.8,0,urlParams.lossMagThresh,0.01,'loss-mag-thresh-slider','','The threshold to detect loss for each LANDTRENDR segment.  Any difference between start and end values for a given segement less than this threshold will be flagged as loss') 

  if(urlParams.lossSlopeThresh === null || urlParams.lossSlopeThresh === undefined){
      urlParams.lossSlopeThresh = -0.10;
    }
  addRangeSlider('lt-params-div','Loss Slope Threshold','urlParams.lossSlopeThresh',-0.8,0,urlParams.lossSlopeThresh,0.01,'loss-slope-thresh-slider','','The threshold to detect loss for each LANDTRENDR segment.  Any slope of a given segement less than this threshold will be flagged as loss') 
  
  if(urlParams.gainMagThresh === null || urlParams.gainMagThresh === undefined){
      urlParams.gainMagThresh = 0.10;
    }
  addRangeSlider('lt-params-div','Gain Magnitude Threshold','urlParams.gainMagThresh',0.01,0.8,urlParams.gainMagThresh,0.01,'gain-mag-thresh-slider','','The threshold to detect gain for each LANDTRENDR segment.  Any difference between start and end values for a given segement greater than this threshold will be flagged as gain');

  if(urlParams.gainSlopeThresh === null || urlParams.gainSlopeThresh === undefined){
      urlParams.gainSlopeThresh = 0.10;
    }
  addRangeSlider('lt-params-div','Gain Slope Threshold','urlParams.gainSlopeThresh',0.01,0.8,urlParams.gainSlopeThresh,0.01,'gain-slope-thresh-slider','','The threshold to detect gain for each LANDTRENDR segment.  Any slope of a given segement greater than this threshold will be flagged as gain') 
  
  if(urlParams.howManyToPull === null || urlParams.howManyToPull === undefined){
      urlParams.howManyToPull = 1;
    }
  addRangeSlider('lt-params-div','How Many','urlParams.howManyToPull',1,3,urlParams.howManyToPull,1,'how-many-slider','','The number of gains and losses to show. Typically an area only experiences a single loss/gain event, but in the cases where there are multiple above the specified thresholds, they can be shown.');

  if(urlParams.maxSegments === null || urlParams.maxSegments === undefined){
      urlParams.maxSegments = 6;
    }
  addRangeSlider('lt-params-div','Max LANDTRENDR Segments','urlParams.maxSegments',1,8,urlParams.maxSegments,1,'max-segments-slider','','The max number of segments LANDTRENDR can break time series into.  Generally 3-6 works well. Use a smaller number of characterizing long-term trends is the primary focus and a larger number if characterizing every little change is the primary focus.') 
  
  $('#parameters-collapse-div').append(`<hr>`);
  $('#parameters-collapse-div').append(staticTemplates.reRunButton);
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div','MAP DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layer icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);

  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');
  addCollapse('sidebar-left','download-collapse-label','download-collapse-div','DOWNLOAD DATA',`<i role="img" class="fa fa-cloud-download mr-1" aria-hidden="true"></i>`,false,``,'Download '+mode+' products for further analysis');
  
}else if(mode === 'MTBS'){
  startYear = 1984;
  endYear = 2021;
  if(urlParams.startYear == null || urlParams.startYear == undefined){
      urlParams.startYear = startYear;
  }
  if(urlParams.endYear == null || urlParams.endYear == undefined){
     urlParams.endYear = endYear;
  }
  addCollapse('sidebar-left','support-collapse-label','support-collapse-div','SUPPORT & FEEDBACK',`<i role="img" class="fa fa-question-circle mr-1" aria-hidden="true"></i>`,true,``,'');
  $('#support-collapse-div').append(staticTemplates.walkThroughButton);
    $('#support-collapse-div').append(`<hr>`);
  $('#support-collapse-div').append(`<p>MTBS burned area boundaries and severity within the Data Explorer and MTBS web map services are updated regularly, but alignment of their update schedule may vary. Please visit the <a class = 'intro-modal-links' href="https://mtbs.gov/direct-download?tab=map-services&target=mtbs-data-explorer" target="_blank" > map services</a> section at MTBS.gov to verify the publication dates when making comparisons between the MTBS data available within these products/services.</p>`)
  $('#support-collapse-div').append(`<hr>`);
  $('#support-collapse-div').append(`<p style = "margin-bottom:0px;">If you have any issues with this tool or have suggestions on how it could be improved, please <a class = 'intro-modal-links' href="https://www.mtbs.gov/contact" target="_blank" > contact us</a>.</p>`)
  // $('#support-collapse-div').append(`<div class="dropdown-divider mb-2"</div>`);
  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS','<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>',false,null,'Adjust parameters used to filter and sort MTBS products');
 
  var mtbsZoomToDict ={"All":true,"CONUS":false,"Alaska":false,"Hawaii":false,"Puerto-Rico":false};

  addMultiRadio('parameters-collapse-div','mtbs-zoom-to-radio','Zoom to MTBS Mapping Area','mtbsMappingArea',mtbsZoomToDict)
  $('#mtbs-zoom-to-radio').prop('title','Zoom to MTBS region')
  $( "#mtbs-zoom-to-radio" ).change(function() {
    console.log(mtbsMappingArea);
    synchronousCenterObject(clientBoundsDict[mtbsMappingArea])
  });
  $('#parameters-collapse-div').append(`<hr>`);
  
  addDualRangeSlider('parameters-collapse-div','Choose analysis year range:','urlParams.startYear','urlParams.endYear',startYear, endYear, urlParams.startYear, urlParams.endYear, 1,'analysis-year-slider','null','Years of MTBS data to include')
  addMultiRadio('parameters-collapse-div','mtbs-summary-method-radio','How to summarize MTBS data','mtbsSummaryMethod',{"Highest-Severity":true,"Most-Recent":false,"Oldest":false})

  $('#mtbs-summary-method-radio').prop('title','Select how to summarize MTBS raster data in areas with multiple fires.  Each summary method is applied on a pixel basis. "Highest-Severity" will show the severity and fire year corresponding to the highest severity. "Most-Recent" will show the severity and fire year corresponding to the most recently mapped fire. "Oldest" will show the severity and fire year corresponding to the oldest mapped fire.')
  $('#parameters-collapse-div').append(`<hr>`);
  $('#parameters-collapse-div').append(staticTemplates.reRunButton);

  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div',mode+' DATA',`<img style = 'height: 1.5rem;margin-top: -0.3rem;margin-left: -0.3rem;' class='image-icon mr-1' alt="MTBS logo" src="images/mtbs-logo.png">`,true,null,mode+' DATA layers to view on map');
  addCollapse('sidebar-left','reference-layer-list-collapse-label','reference-layer-list-collapse-div','REFERENCE DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,false,null,'Additional relevant layers to view on map intended to provide context for '+mode+' DATA');
  
  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');
  
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  $('#reference-layer-list-collapse-div').append(`<ul id="reference-layer-list" class = "layer-list"></ul>`);
  
 
  $('#introModal-body').append(staticTemplates.walkThroughButton);
}else if(mode === 'TEST' || mode === 'IDS'){
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div',mode+' DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);

  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');

}else if(mode==='Bloom-Mapper'){
  var algalRunID = 1;
  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS','<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>',false,null,'Adjust parameters used to filter and sort LCMS products');
  startYear = 2022;
  endYear = 2023;
  if(urlParams.startYear == null || urlParams.startYear == undefined){
    urlParams.startYear = 2023;
  }
  if(urlParams.endYear == null || urlParams.endYear == undefined){
    urlParams.endYear = 2023;
  }

  addDualRangeSlider('parameters-collapse-div','Choose analysis year range:','urlParams.startYear','urlParams.endYear',startYear, endYear, urlParams.startYear, urlParams.endYear, 1,'analysis-year-slider','null','Years of algal data to include')
  $('#parameters-collapse-div').append(staticTemplates.reRunButton);

  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div',mode+' DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);

  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');

  addCollapse('sidebar-left','support-collapse-label','support-collapse-div','SUPPORT',`<img class='panel-title-svg-lg'  alt="Support icon" src="./Icons_svg/support_ffffff.svg">`,false,``,'If you need any help');

  $('#support-collapse-div').append(staticTemplates.supportDivAlgal);

}else if(mode === 'LAMDA'){

addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS','<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>',false,null,'Adjust parameters used to filter and sort LAMDA products');
  startYear = 2021;
  var endYearCutoff = new Date('2023-02-26').dayOfYear();
  var currentDate = new Date();
  endYear = currentDate.getYear()+1900;
  var currentDayOfYear = currentDate.dayOfYear();
  if(currentDayOfYear < endYearCutoff){
    endYear--;
  }
  
  
  if(urlParams.year == null || urlParams.year == undefined){
        urlParams.year = endYear;
    }

addRangeSlider('parameters-collapse-div','Year','urlParams.year',startYear,endYear,urlParams.year,1,'year-slider','','Year of LAMDA products to show');
$('#parameters-collapse-div').append(staticTemplates.reRunButton);

 addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div',mode+' DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);

  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');


}else if(mode === 'geeViz'){
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div',mode+' DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');
 

}
else if(mode === 'STORM'){
  canExport = true;
  function refineFeatures(features,interpProps){
          var left = features.slice(0,features.length-1);
          var right = features.slice(1,features.length);
          var f = [left[0]];
          left.forEach(function(fl,i){
            var fr = right[i];
            var coordsL = fl.geometry.coordinates;
            var coordsR = fr.geometry.coordinates;

            
            var fm =  JSON.parse(JSON.stringify(fl));
            fm.geometry.coordinates = [(coordsL[0]+coordsR[0])/2.0,(coordsL[1]+coordsR[1])/2.0];
            
            interpProps.map(function(prop){

              var lProp =fl.properties[prop];
              var rProp = fr.properties[prop];
              var m = (rProp+lProp)/2.0
              fm.properties[prop] = m
            })
            f.push([fm,fr]);
          })
          f = f.flat();
          // console.log(f);
          // console.log(left);
        return f
        }

  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS','<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>',true,null,'Adjust parameters used to prepare storm outputs');

   $('#parameters-collapse-div').append(`
    <label>Download storm track from <a href="https://www.wunderground.com/hurricane" target="_blank">here</a>. Copy and paste the storm track coordinates into a text editor. Save the table. Then upload that table below. <a href="./geojson/michael.txt" download="michael.txt" >Download test data here.</a></label>
    <input class = 'file-input my-1' type="file" id="stormTrackUpload" name="upload"  style="display: inline-block;" title = "Download storm track from https://www.wunderground.com/hurricane">
    <hr>
    <label>Provide name for storm (optional):</label>
    <input title = 'Provide a name for the storm. The name of the provided storm track file will be used if left blank.'  type="user-selected-area-name" class="form-control" id="storm-name"  placeholder="Name your storm!" style='width:80%;'><hr>`)
   addRangeSlider('parameters-collapse-div','Refinement iterations','refinementIterations',0, 10, 5, 1,'refinement-factor-slider','null',"Specify number of iterations to perform a linear interpolation of provided track. A higher number is needed for tracks with fewer real observations")
   addRangeSlider('parameters-collapse-div','Max distance (km)','maxDistance',50, 500, 200, 50,'max-distance-slider','null',"Specify max distance in km from storm track to include in output")
   addRangeSlider('parameters-collapse-div','Min wind (mph)','minWind',0, 75, 30, 5,'min-wind-slider','null',"Specify min wind speed in mph to include in output")
   // addRangeSlider('parameters-collapse-div','Mod of Rupture','modRupture',2000, 20000, 8500, 100,'mod-rupture-slider','null',"Specify the modulus of rupture for the GALES model")
     
      $('#parameters-collapse-div').append(`
        <hr>
        <label style = 'width:90%'>The MOD of Rupture is intended to indicate how much force it takes to snap a tree. A single value can be provided by providing a constant image (e.g. ee.Image(1)) and a simple lookup to convert that image to a desired MOD of Rupture (e.g. {1:8500}). If different MOD of Rupture values are needed for different tree types, you can provide an EE image that may have tree classes or land cover classes that can then be cross-walked to a MOD of Rupture image with different values for different tree/land cover classes (e.g. ee.Image( "USGS/NLCD_RELEASES/2016_REL/2016" ).select([ 0 ]) with a lookup of {41:8500,42:2000,43:5000,90:4000}</label>
        <hr>
        <label>MOD of Rupture Image</label>
        <textarea   title = 'Provide an image with relevant land cover/tree classes. Provide a constant raster (ee.Image(1)) if you would like to use a constant'   class="form-control" id="mod-image"   oninput="auto_grow(this)" style='width:90%;'>ee.Image("USGS/NLCD_RELEASES/2016_REL/2016").select([0])</textarea>
        <hr>
        <label>MOD of Rupture Lookup</label>
        <textarea   title = 'Provide a lookup table to remap each class of the image provided above with a MOD of Rupture value.'  type="user-selected-area-name" class="form-control" id="mod-lookup" oninput="auto_grow(this)" style='width:90%;'>{41:8500, 42:2000, 43:5000, 90:4000}</textarea>
       `);


       $('#parameters-collapse-div').append(`<hr>
      <button class = 'btn' style = 'margin-bottom: 0.5em!important;' onclick = 'ingestStormTrack()' title = 'Click to ingest storm track and map damage'>Ingest Storm Track</button>
      <button class = 'btn' style = 'margin-bottom: 0.5em!important;' onclick = 'reRun()' title = 'Click to remove existing layers and exports'>Clear All Layers/Exports</button><br>`);
    function ingestStormTrack() {

      
          if(jQuery('#stormTrackUpload')[0].files.length > 0){
                
            var fr=new FileReader(); 
            fr.onload=function(){ 
                var rows = fr.result.split('\n');
                rows =rows.filter(row => row.split('\t').length > 5);
                // console.log(fr.result) 
                // console.log(rows)
                rows = rows.map(function(row){
                  row = row.split('\t');
                  var out = {};
                  out.type = "Feature";
                  out.geometry = {};
                  out.geometry.type = 'Point';
                  out.geometry.coordinates = [parseFloat(row[3]), parseFloat(row[2])]
                  
                  out.properties = {};
                  out.properties.lat = parseFloat(row[2]);
                  out.properties.lon = parseFloat(row[3]);
                  out.properties.wspd = parseFloat(row[4]);
                  out.properties.pres = parseFloat(row[5]);
                  out.properties.category = row[6];
                  out.properties.date = new Date(row[0] + ' ' + row[1]).getTime();
                  out.properties.year = new Date(row[0] + ' ' + row[1]).getFullYear()
                  return out
                })
                // var sa = ee.Image('projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/LANDFIRE/LF_US_EVH_200').geometry();
                // rows = ee.FeatureCollection(rows).filterBounds(sa).getInfo().features;
                // console.log(rows)
                // Map2.addLayer(rows)
                var iterations = refinementIterations;
                var initialN = rows.length;
                while(iterations > 0 && rows.length*2 < 1500){
                  console.log('Refining');
                  console.log(refinementIterations);
                  rows = refineFeatures(rows,['lat','lon','wspd','pres','date','year']);
                  console.log(rows.length);
                  iterations--
                }
                setTimeout(function(){
                  showMessage('Track ingestion finished','Refined '+ (refinementIterations-iterations).toString() +'/'+ refinementIterations.toString()+' iterations.<br>Total number of raw track points is: '+initialN.toString()+'<br>Total number of refined track points is: '+rows.length.toString())
                },1000)
                
                // rows = refineFeatures(rows,['lat','lon','wspd','pres','date','year']);

                var rowsLeft = rows.slice(0,rows.length-1);
                var rowsRight = rows.slice(1);
                var zipped = ee.List.sequence(0,rowsLeft.length-1).getInfo().map(function(i){
                  
                  var out = {};
                  out.type = "Feature";
                  out.geometry = rowsLeft[i].geometry;

                  out.properties = {};

                  out.properties.current = rowsLeft[i].properties;
                  out.properties.future = rowsRight[i].properties;
                  
                  return out
                })
                // console.log(zipped)
                // Map2.addLayer(rows)
                 $('#summary-spinner').slideUp();
                 // console.log(zipped)
                createHurricaneDamageWrapper(ee.FeatureCollection(zipped));
            } 
              
            fr.readAsText(jQuery('#stormTrackUpload')[0].files[0]);
            }else{
              $('#summary-spinner').hide();
              showMessage('No storm track provided','Please download storm track from <a href="https://www.wunderground.com/hurricane" target="_blank">here</a> . Copy and paste the storm track coordinates into a text editor. Save the table. Then upload that table above.')}


        } 
  //   $('#parameters-collapse-div').append(`<label>Provide storm track geoJSON:</label>
  //                                       <input rel="txtTooltip" title = 'Provide storm track geoJSON'  type="user-selected-area-name" class="form-control"  id="storm-track" placeholder="Provide storm track geoJSON" style='width:80%;'>`)
  
  
  // function ingestStormTrak(){
  //     var months = {
  //     'JAN' : '01',
  //     'FEB' : '02',
  //     'MAR' : '03',
  //     'APR' : '04',
  //     'MAY' : '05',
  //     'JUN' : '06',
  //     'JUL' : '07',
  //     'AUG' : '08',
  //     'SEP' : '09',
  //     'OCT' : '10',
  //     'NOV' : '11',
  //     'DEC' : '12'
  //     }
  //   if(jQuery('#stormTrackUpload')[0].files.length > 0){
  //     $('#summary-spinner').slideDown();
  //     convertToGeoJSON('stormTrackUpload').done(function(converted){

  //       converted.features = converted.features.map(function(f){
  //         f.properties.HR = parseFloat(f.properties['HHMM'].slice(0,2));
  //         f.properties.MN = parseFloat(f.properties['HHMM'].slice(2));
  //         if(Object.keys(months).indexOf(f.properties.MONTH) > -1){
  //           f.properties.MONTH = months[f.properties.MONTH]
  //         }
  //         return f
  //       })
  //       console.log('successfully converted to JSON');
  //       console.log(converted);
        


  //       var iterations =0;
  //       // var sa = ee.FeatureCollection("TIGER/2018/States").geometry();
  //       var sa = ee.Image('projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/LANDFIRE/LF_US_EVH_200').geometry();
  //       // converted.features = ee.FeatureCollection(converted.features).filterBounds(sa).getInfo().features;
  //       for(iterations; iterations > 0; iterations--){
  //         converted.features = refineFeatures(converted.features,['LAT','LON','YEAR','MONTH','DAY','INTENSITY','MSLP','HR','MN']);
          
          
          
  //         //{"date": "Aug 16:18:00 GMT", "lat": 10.9, "lon": -25.4, "wspd": 20.0, "pres": 0.0, "FO": "O"}
        
  //       }
        
  //       var rows = converted.features.map(function(f){
         
  //         var props = f.properties;
  //         f.properties.date = new Date(props.YEAR,props.MONTH-1,props.DAY,props.HR,props.MN)
  //         f.properties.lat = props.LAT;
  //         f.properties.lon = props.LON;
  //         f.properties.wspd = props.INTENSITY
  //         f.properties.pres = props.MSLP
  //         f.properties.name = props.STORMNAME
  //         f.properties.year = props.YEAR;
  //         return f;//ee.Feature(f).buffer(10000)
  //       });
        
        
  //       createHurricaneDamageWrapper(rows,true);
  //       $('#summary-spinner').slideUp(); 
       
        
  //         })
  //   }else{showMessage('No storm track provided','Please select a .zip shapefile or a .geojson file to summarize across')}
  // }                     
  // $('#parameters-collapse-div').append(`<label>Provide storm track geoJSON:</label>
  //                                       <input rel="txtTooltip" title = 'Provide storm track geoJSON'  type="user-selected-area-name" class="form-control" value = '${JSON.stringify(rows)}' id="storm-track" placeholder="Provide storm track geoJSON" style='width:80%;'>`)
  
  // $('#parameters-collapse-div').append(`<label>Provide name for storm (optional):</label>
  //                                       <input rel="txtTooltip" title = 'Provide a name for the storm. A default one will be provided if left blank.'  type="user-selected-area-name" class="form-control" id="storm-name" value = 'Michael' placeholder="Name your storm!" style='width:80%;'>`)
  // addRangeSlider('parameters-collapse-div','Choose storm year','stormYear',1980, 2030, 2018, 1,'storm-year-slider','null',"Specify year of storm")
  // $('#parameters-collapse-div').append(`<hr>`);
  // $('#parameters-collapse-div').append(staticTemplates.reRunButton);
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div',mode+' DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');
  addCollapse('sidebar-left','download-collapse-label','download-collapse-div','DOWNLOAD DATA',`<i role="img" class="fa fa-cloud-download mr-1" aria-hidden="true"></i>`,false,``,'Download '+mode+' products for further analysis');
 
}else if(mode==='TreeMap'){
  $('head').append(`<script type="text/javascript" src="./js/forest-type-palette.js"></script>`);
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div','TreeMap DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');
  //addCollapse('sidebar-left','download-collapse-label','download-collapse-div','DOWNLOAD DATA',`<i role="img" class="fa fa-cloud-download mr-1" aria-hidden="true"></i>`,false,``,'Download '+mode+' products for further analysis');
  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  //$('#download-collapse-div').append(staticTemplates.TreeMapDownloadDiv);
  //setupDropdownTreeMapDownloads()
  //populateDownloads()
}else if(mode==='sequoia-view'){
  
  addCollapse('sidebar-left','parameters-collapse-label','parameters-collapse-div','PARAMETERS','<i role="img" class="fa fa-sliders mr-1" aria-hidden="true"></i>',true,null,'Adjust parameters used to prepare analysis window');
  var minYear = 2017;
  var maxYear = new Date().getFullYear();
  var dayOfYear = new Date().dayofYear();
  if(urlParams.preStartYear == null || urlParams.preStartYear == undefined){
    urlParams.preStartYear = minYear;
  }
  if(urlParams.preEndYear == null || urlParams.preEndYear == undefined){
    urlParams.preEndYear = maxYear-1;
  }
  if(urlParams.postYear == null || urlParams.postYear == undefined){
    urlParams.postYear = maxYear;
  }
  // if(urlParams.postEndYear == null || urlParams.postEndYear == undefined){
  //   urlParams.postEndYear = maxYear;
  // }

  if(urlParams.startJulian == null || urlParams.startJulian == undefined){
    urlParams.startJulian = dayOfYear-16;// = parseInt(urlParams.startYear);
}
if(urlParams.endJulian == null || urlParams.endJulian == undefined){
   urlParams.endJulian = dayOfYear-2;// = parseInt(urlParams.endYear);
}
if(urlParams.compVizParams == null || urlParams.compVizParams == undefined){
  urlParams.compVizParams = {"min":0.1,"max":[0.5,0.6,0.6],"bands":"swir2,nir,red","gamma":1.6}
}
if(urlParams.diffVizParams == null || urlParams.diffVizParams == undefined){
  urlParams.diffVizParams = {min:-0.05,max:0.05,bands:['brightness','greenness','wetness']}
}
if(urlParams.diffThreshs == null || urlParams.diffThreshs == undefined){
  urlParams.diffThreshs = {'greenness':-0.05,'wetness':-0.02,'NBR':-0.2}
}
if(urlParams.treeDiameter == null || urlParams.treeDiameter == undefined){
  urlParams.treeDiameter = 15
}
if(urlParams.lcmsTreeMaskClasses == null || urlParams.lcmsTreeMaskClasses == undefined){
  urlParams.lcmsTreeMaskClasses = {"Trees": true,"Shrubs & Trees Mix": false,"Grass/Forb/Herb & Trees Mix":false,"Barren & Trees Mix":false}
}

  
  // $('#parameters-collapse-div').append(`<hr>`);

  addDualRangeSlider('parameters-collapse-div','Analysis date range:','urlParams.startJulian','urlParams.endJulian',1, 365, urlParams.startJulian, urlParams.endJulian, 1,'julian-day-slider','julian','Select a window of dates to filter the analysis (baseline and post-disturbance).')
  addDualRangeSlider('parameters-collapse-div','Baseline year(s):','urlParams.preStartYear','urlParams.preEndYear',minYear, maxYear-1, urlParams.preStartYear, urlParams.preEndYear, 1,'pre-years-slider','null','Choose year(s) to calculate reference (pre-change) signal. If more than one year is chosen, the baseline will be the mean signal of the years during the selected date range.')
  // addDualRangeSlider('parameters-collapse-div','Target year:','urlParams.postStartYear','urlParams.postEndYear',minYear, maxYear, urlParams.postStartYear, urlParams.postEndYear, 1,'post-years-slider','null','Years to include for the target year evaluation period')
  addRangeSlider('parameters-collapse-div','Target year:','urlParams.postYear',minYear+1,maxYear,urlParams.postYear,1,'post-years-slider',null,'Choose year to compare against Baseline year(s).')
  
  addSubCollapse('parameters-collapse-div','advanced-params-label','advanced-params-div','Advanced Parameters', '',false,'')
  $('#parameters-collapse-div').append('<hr>')
  addRangeSlider('advanced-params-div','Giant Sequoia Canopy Diamater (m)','urlParams.treeDiameter',5, 30,urlParams.treeDiameter,5,'tree-diameter-slider','null',"Specify the average diameter of a Giant Sequoia crown in meters");
  
  addCheckboxes('advanced-params-div','lcms-tree-mask-class-checkboxes','LCMS land cover classes to include as tree to mask out non tree areas from change detection. ','lcmsTreeMaskClasses',urlParams.lcmsTreeMaskClasses);

  // addRadio('advanced-params-div','cloud-mask-method-radio','','S2Cloudless+TDOM','CloudScore+','cloudMaskMethod','s2c','csp',null,null,'Toggle between imperial or metric units')

  if(urlParams.cloudMaskMethod === null || urlParams.cloudMaskMethod === undefined){
    urlParams.cloudMaskMethod = {"S2Cloudless-TDOM": true,"CloudScore+": false}
  }
  addMultiRadio('advanced-params-div','cloud-mask-method-radio','Cloud Masking Method','cloudMaskMethod',urlParams.cloudMaskMethod,'Choose which cloud and cloud shadow masking method to use. S2 Cloudless and TDOM work well, but TDOM is a bit computationally intensive. cloudScore+ masks clouds and cloud shadows better, but will not be fully available for all Sentinel-2 data until around spring of 2024');
  
  addJSONInputTextBox('advanced-params-div','diff-bands-thresh-input','Difference Bands and Thresholds','diffThreshs',urlParams.diffThreshs,'Bands and thresholds to use for identifying change');

  addJSONInputTextBox('advanced-params-div','comp-viz-params-input','Composite Visualization Parameters','compVizParams',urlParams.compVizParams,'Viz params for composite images');

  addJSONInputTextBox('advanced-params-div','diff-viz-params-input','Difference Visualization Parameters','diffVizParams',urlParams.diffVizParams,'Viz params for difference image');

  
// Sync sliders
$('#post-years-slider').slider().bind('slide',function(event,ui){
  var yr = ui.value;
  var needsUpdated=false;
  if(yr <= urlParams.preEndYear){
    urlParams.preEndYear=yr-1;
    needsUpdated=true;  
  }
  if(yr <= urlParams.preStartYear){
    urlParams.preStartYear=yr-1;
    needsUpdated=true;  
  }
  if(needsUpdated){
    $("#pre-years-slider" ).slider("values", [urlParams.preStartYear,urlParams.preEndYear]);
    $('#pre-years-slider-update').html(`${urlParams.preStartYear} - ${urlParams.preEndYear}`);
  }
});
$('#pre-years-slider').slider().bind('slide',function(event,ui){
  var yrs = ui.values;
  var needsUpdated=false;
  if(yrs[0] >= urlParams.postYear){
    urlParams.postYear=yrs[0]+1;
    needsUpdated=true;  
  }
  if(yrs[1] >= urlParams.postYear){
    urlParams.postYear=yrs[1]+1;
    needsUpdated=true;   
  }
  if(needsUpdated){
    $("#post-years-slider" ).slider("value", urlParams.postYear);
    $('#post-years-slider-update').html(`${urlParams.postYear}`);
  }
});
  

  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div','MAP LAYERS',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  
  addCollapse('sidebar-left','reference-layer-list-collapse-label','reference-layer-list-collapse-div','REFERENCE DATA',`<img class='panel-title-svg-lg'  alt="Layers icon" src="./Icons_svg/data-layers_ffffff.svg">`,false,null,'Additional relevant layers to view on map intended to provide context for change data');
  $('#reference-layer-list-collapse-div').append(`<ul id="reference-layer-list" class = "layer-list"></ul>`);

  addCollapse('sidebar-left','table-collapse-label','table-collapse-div','MONITORING SITES',`<img class='panel-title-svg-lg'  alt="Graph icon" src="./Icons_svg/graph_ffffff.svg">`,true,``,'Giant Sequoia monitoring sites output table');

  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');
  
  // addCollapse('sidebar-left','download-collapse-label','download-collapse-div','DOWNLOAD DATA',`<img class='panel-title-svg-lg'  alt="Downloads icon" src="./Icons_svg/dowload_ffffff.svg">`,false,``,'Download LCMS products for further analysis');
  // addCollapse('sidebar-left','support-collapse-label','support-collapse-div','SUPPORT',`<img class='panel-title-svg-lg'  alt="Support icon" src="./Icons_svg/support_ffffff.svg">`,false,``,'If you need any help');

  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);

  $('#parameters-collapse-div').append(staticTemplates.reRunButton);

  if(urlParams.canExport===true){
    canExport=urlParams.canExport;
    addCollapse('sidebar-left','download-collapse-label','download-collapse-div','DOWNLOAD DATA',`<i role="img" class="fa fa-cloud-download mr-1" aria-hidden="true"></i>`,false,``,'Download '+mode+' products for further analysis');
  }

}else{
  addCollapse('sidebar-left','layer-list-collapse-label','layer-list-collapse-div','ANCILLARY DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,true,null,mode+' DATA layers to view on map');
  addCollapse('sidebar-left','reference-layer-list-collapse-label','reference-layer-list-collapse-div','PLOT DATA',`<img style = 'width:1.1em;' class='image-icon mr-1' alt="Layers icon" src="images/layer_icon.png">`,false,null,'Additional relevant layers to view on map intended to provide context for '+mode+' DATA');
  
  addCollapse('sidebar-left','tools-collapse-label','tools-collapse-div','TOOLS',`<i role="img" class="fa fa-gear mr-1" aria-hidden="true"></i>`,false,'','Tools to measure and chart data provided on the map');

  $('#layer-list-collapse-div').append(`<ul id="layer-list" class = "layer-list"></ul>`);
  $('#reference-layer-list-collapse-div').append(`<ul id="reference-layer-list" class = "layer-list"></ul>`);
  plotsOn = true;
}

$('body').append(`<div class = 'legendDiv flexcroll col-sm-5 col-md-3 col-lg-3 col-xl-2 p-0 m-0' id = 'legendDiv'></div>`);
$('.legendDiv').css('bottom','1rem');
$('.sidebar').css('max-height',$('body').height()-$('.bottombar').height());
addLegendCollapse();
/////////////////////////////////////////////////////////////////
//Construct tool options for different modes
 

addAccordianContainer('tools-collapse-div','tools-accordian')
$('#tools-accordian').append(`<h5 class = 'pt-2' style = 'border-top: 0.0em solid black;'>Measuring Tools</h5>`);
// $('#tools-accordian').append(staticTemplates.imperialMetricToggle);
addSubAccordianCard('tools-accordian','measure-distance-label','measure-distance-div','Distance Measuring',staticTemplates.distanceDiv,false,`toggleTool(toolFunctions.measuring.distance)`,staticTemplates.distanceTipHover);

// <variable-radio onclick1 = 'updateDistance()' onclick2 = 'updateDistance()'var='metricOrImperialDistance' title2='' name2='Metric' name1='Imperial' value2='metric' value1='imperial' type='string' href="#" rel="txtTooltip" data-toggle="tooltip" data-placement="top" title='Toggle between imperial or metric units'></variable-radio>
addSubAccordianCard('tools-accordian','measure-area-label','measure-area-div','Area Measuring',staticTemplates.areaDiv,false,`toggleTool(toolFunctions.measuring.area)`,staticTemplates.areaTipHover);
addRadio('measure-distance-div','metricOrImperialDistance-radio','','Imperial','Metric','metricOrImperialDistance','imperial','metric','updateDistance()','updateDistance()','Toggle between imperial or metric units')

addRadio('measure-area-div','metricOrImperialArea-radio','','Imperial','Metric','metricOrImperialArea','imperial','metric','updateArea()','updateArea()','Toggle between imperial or metric units')

addShapeEditToolbar('measure-distance-div', 'measure-distance-div-icon-bar','undoDistanceMeasuring()','resetPolyline()')
addColorPicker('measure-distance-div-icon-bar','distance-color-picker','updateDistanceColor',distancePolylineOptions.strokeColor);

addShapeEditToolbar('measure-area-div', 'measure-area-div-icon-bar','undoAreaMeasuring()','resetPolys()')
addColorPicker('measure-area-div-icon-bar','area-color-picker','updateAreaColor',areaPolygonOptions.strokeColor);

// addAccordianContainer('pixel-tools-collapse-div','pixel-tools-accordian');
$('#tools-accordian').append(`<h5 class = 'pt-2' style = 'border-top: 0.1em solid black;'>Pixel Tools</h5>`);
addSubAccordianCard('tools-accordian','query-label','query-div','Query Visible Map Layers',staticTemplates.queryDiv,false,`toggleTool(toolFunctions.pixel.query)`,staticTemplates.queryTipHover);
if(['Bloom-Mapper','TreeMap','sequoia-view'].indexOf(mode) === -1){
  addSubAccordianCard('tools-accordian','pixel-chart-label','pixel-chart-div','Query '+mode+' Time Series',staticTemplates.pixelChartDiv,false,`toggleTool(toolFunctions.pixel.chart)`,staticTemplates.pixelChartTipHover);
  addDropdown('pixel-chart-div','pixel-collection-dropdown','Choose which '+mode+' time series to chart','whichPixelChartCollection','Choose which '+mode+' time series to chart.');
 
}
// $('#pixel-chart-div').append(staticTemplates.showChartButton);
// addAccordianContainer('area-tools-collapse-div','area-tools-accordian');
if(mode === 'geeViz'){
  $('#pixel-chart-label').remove();
  $('#share-button').remove();
   $('#tools-accordian').append(`<hr>`);
   //Sync tooltip toggle
  var tShowToolTipModal = true;
  if(localStorage.showToolTipModal !== null && localStorage.showToolTipModal !== undefined){
    tShowToolTipModal = localStorage.showToolTipModal
  }
  addRadio('tools-accordian','tooltip-radio','Show tool tips','Yes','No','localStorage.showToolTipModal','true','false','','','Whether to show tool tips to help explain how to use the tools.');
  if(tShowToolTipModal === 'false'){$('#tooltip-radio-second_toggle_label').click();}
}
if(mode==='LAMDA'){$('#pixel-chart-label').remove();}
// if(mode === 'LCMS'){$('#search-share-div').addClass('pt-2')};
if(mode === 'LCMS-pilot' || mode === 'MTBS'|| mode === 'lcms-base-learner' || mode === 'IDS' || mode === 'LCMS'){
  $('#tools-accordian').append(`<h5 class = 'pt-2' style = 'border-top: 0.1em solid black;'>Area Tools</h5>`);
  addSubCollapse('tools-accordian','area-chart-params-label','area-chart-params-div','Area Tools Parameters', '',false,'')
  $('#area-chart-params-label').prop('title', 'Click here to select which LCMS products to chart, and change which area units are used. ')
  // $('#tools-accordian').append(`<hr>`);
  addDropdown('area-chart-params-div','area-collection-dropdown','Choose which '+mode+' product to summarize','whichAreaChartCollection','Choose which '+mode+' time series to summarize.');
  // $('#area-chart-params-div').append(`<hr>`);
  $('#parameters-collapse-div').append(`<hr>`);
  addMultiRadio('area-chart-params-div','area-summary-format','Area Units','areaChartFormat',{"Percentage":true,"Acres":false,"Hectares":false})
  if(mode==='LCMS' ){//&& (urlParams.sankey==='true' || urlParams.beta ==='true')){
    var activeStartYear=urlParams.startYear;
    var activeEndYear=urlParams.endYear;
    $('#area-chart-params-div').append(`<div id='transition-periods-container'></div>`);
    $('#transition-periods-container').hide();
    $('#area-collection-dropdown').change(e=>{
      if($('#area-collection-dropdown').val().indexOf('-transition')>-1){
        $('#transition-periods-container').show();
        }else{
          $('#transition-periods-container').hide();
        }
      })
  }
 
  $('#area-summary-format').prop('title','Choose how to summarize area- as a percentage of the area, acres, or hectares.')
  addSubAccordianCard('tools-accordian','user-defined-area-chart-label','user-defined-area-chart-div','User-Defined Area',staticTemplates.userDefinedAreaChartDiv,false,`toggleTool(toolFunctions.area.userDefined)`,staticTemplates.userDefinedAreaChartTipHover);
  addSubAccordianCard('tools-accordian','upload-area-chart-label','upload-area-chart-div','Upload an Area',staticTemplates.uploadAreaChartDiv,false,'toggleTool(toolFunctions.area.shpDefined)',staticTemplates.uploadAreaChartTipHover);
  // addSubAccordianCard('tools-accordian','select-area-dropdown-chart-label','select-area-dropdown-chart-div','Select an Area from Dropdown',staticTemplates.selectAreaDropdownChartDiv,false,'toggleTool(toolFunctions.area.selectDropdown)',staticTemplates.selectAreaDropdownChartTipHover);
  addSubAccordianCard('tools-accordian','select-area-interactive-chart-label','select-area-interactive-chart-div','Select an Area on Map',staticTemplates.selectAreaInteractiveChartDiv,false,'toggleTool(toolFunctions.area.selectInteractive)',staticTemplates.selectAreaInteractiveChartTipHover);
  addRangeSlider('upload-reduction-factor-container','Vertex Reduction Factor','uploadReductionFactor',1, 5, 1 , 1,'upload-reduction-factor-slider','null',"Every n vertex in uploaded file will be kept for polygons > 100 vertices (E.g. if 3 is chosen, every third vertex remains). This is intended to help enable use of uploaded areas that may have failed due to its size.")
  addRangeSlider('simplify-error-range-container','Simplify Area - Max Error','simplifyMaxError',0, 500, 0 , 50,'simplify-error-slider','null',"If the selected area is very large and/or has a lot of vertices, it may not compute. In this instance, clear out any existing selections (trash can button below), and increase this value. The selected polygon will be simplified using a max error in meters equal to this value upon selection. Generally between 50 and 150 will get most areas to work.")
  addShapeEditToolbar('user-defined-edit-toolbar', 'user-defined-area-icon-bar','undoUserDefinedAreaCharting()','restartUserDefinedAreaCarting()')
  addColorPicker('user-defined-area-icon-bar','user-defined-color-picker','updateUDPColor',udpOptions.strokeColor);

  addShapeEditToolbar('select-features-edit-toolbar', 'select-area-interactive-chart-icon-bar','removeLastSelectArea()','clearSelectedAreas()','Click to unselect most recently selected polyogn','Click to clear all selected polygons');
  $('#tools-accordian').append(`<hr>`);
   //Sync tooltip toggle
  var tShowToolTipModal = true
  if(localStorage.showToolTipModal !== null && localStorage.showToolTipModal !== undefined){
    tShowToolTipModal = localStorage.showToolTipModal
  }
  addRadio('tools-accordian','tooltip-radio','Show tool tips','Yes','No','localStorage.showToolTipModal','true','false','','','Whether to show tool tips to help explain how to use the tools.');
  if(tShowToolTipModal === 'false'){$('#tooltip-radio-second_toggle_label').click();}

}
// Add functionality to Sequoia mode for user to upload a shapefile, geoJSON, etc
if(mode === 'sequoia-view'){
  $('#tools-accordian').append(`<h5 class = 'pt-2' style = 'border-top: 0.1em solid black;'>Area Tools</h5>`);
  //addSubCollapse('tools-accordian','area-chart-params-label','area-chart-params-div','Area Tools Parameters', '',false,'')
  addSubAccordianCard('tools-accordian','upload-area-chart-label','upload-area-chart-div','Upload an Area',staticTemplates.uploadShpToMapLayerDiv,false,'toggleTool(toolFunctions.area.shpDefined)',staticTemplates.uploadAreaChartTipHover);
}
//Add some logos for different modes
if(mode === 'MTBS' || mode === 'Ancillary'){
  $('#contributor-logos').prepend(`<a href="https://www.usgs.gov/" target="_blank" >
                                    <img src="images/usgslogo.png" class = 'image-icon-bar' alt="USGS logo" title="Click to learn more about the US Geological Survey">
                                  </a>`)
  $('#contributor-logos').prepend(`<a href="https://www.mtbs.gov/" target="_blank" >
                                    <img src="images/mtbs-logo-large.png" class = 'image-icon-bar' alt="MTBS logo" title="Click to learn more about MTBS">
                                  </a>`)
}
//Handle exporting if chosen
if(canExport){
  // console.log('here')
   $('#download-collapse-div').append(staticTemplates.exportContainer);
   if(localStorage.export_crs !== undefined && localStorage.export_crs !== null && localStorage.export_crs.indexOf('EPSG') > -1){
    $('#export-crs').val(localStorage.export_crs)
  }else{localStorage.export_crs = $('#export-crs').val()};
   function cacheCRS(){
    localStorage.export_crs = $('#export-crs').val();
   }
   if(mode === 'STORM'){
     $('#export-area-drawing-div').append(`<hr>
                                            <button class = 'btn' onclick = 'addTrackBounds()' title = 'Add bounds of storm track for export area.'><i class="pr-1 fa fa-square-o" aria-hidden="true"></i> Use storm track bound as area to download</button>
                                            `)
     $('#export-button-div').append(`<hr>`);
     addRangeSlider('export-button-div','Quick look spatial resolution','quickLookRes',1200, 6000, 3000, 300,'quick-look-res-slider','null',"Specify spatial resolution for quick look downloads.")
     $('#export-button-div').append(`<button class = 'btn' onclick = 'downloadQuickLooks()'  title = 'Quickly download outputs at coarse resolution'><i class="pr-1 fa fa-cloud-download" aria-hidden="true"></i>Download Quick Look Outputs</button>
                                            `)
     
   }
}
function resizeViewerPanes(){
  console.log('resized');
  if(mode !== 'lcms-dashboard'){
    moveCollapse('chart-collapse');
    moveCollapse('legend-collapse');
    
   
  }
 
  $('.legendDiv').css('bottom','1rem');
  $('.legendDiv').css('max-height',window.innerHeight-convertRemToPixels(1)+1);
  $('.sidebar').css('max-height',$('body').height()-$('.bottombar').height());
  // moveCollapse('plot-collapse');
  if(walkThroughAdded){
      moveCollapse('walk-through-collapse');
  }
  
  adjustTitleBanner();
  // addLegendCollapse();


}

function resizeDashboardPanes(){
  console.log('resized');
  let layerWidth = $('#layer-list-collapse-label-layer-list-collapse-div').width();//+5;
  let bottomHeight=$('.bottombar').height();
  let resultsHeight = $('#dashboard-results-container').height();
  let sidebarHeight=$('#sidebar-left-container').height();
  let expanderHeight = $('#dashboard-results-expander').height();
  let highlightsWidth=$('.dashboard-highlights').width();
  let highlightsHeight=$('.dashboard-highlights').height();
  $('#sidebar-left-container').css('max-height',window.innerHeight-bottomHeight);
  if(sidebarHeight+bottomHeight+resultsHeight+expanderHeight<window.innerHeight){
    $('#dashboard-results-container').css('left',0);
    if(highlightsHeight<window.innerHeight-resultsHeight-expanderHeight){
      $('#dashboard-results-container').css('max-width',window.innerWidth);
    }else{
      $('#dashboard-results-container').css('max-width',window.innerWidth-highlightsWidth);
    }
    
  }else{
    $('#dashboard-results-container').css('left',layerWidth);
    if(highlightsHeight<window.innerHeight-resultsHeight-expanderHeight){
      $('#dashboard-results-container').css('max-width',window.innerWidth-layerWidth);
      $('.dashboard-highlights').css('height',)
    }else{
      $('#dashboard-results-container').css('max-width',window.innerWidth-layerWidth-highlightsWidth);
    }
  }
  
  $('#dashboard-results-container').css('bottom',bottomHeight+expanderHeight-1);
  if(resultsHeight>0){
    $('.dashboard-highlights').css('max-height',window.innerHeight-bottomHeight);
  }else{
    $('.dashboard-highlights').css('max-height',window.innerHeight-bottomHeight);
  };
 
  // $('.chart').css('height',$('#dashboard-results-container').height())
  try{
    if($(window).width() < 768){moveDashboardResults('left')}
    else if($(window).width() >= 768){moveDashboardResults('right')}
  }catch(err){
    console.log(err);
  }
  $('.dashboard-results-toggler').css('right',`${($('#dashboard-results-container-right').width()-convertRemToPixels(3))/$('body').width()*100}%`)
  // $(document).ready(function(){resizeDashboardPanes()})
}
if(mode === 'lcms-dashboard'){
  
  $('body').append(staticTemplates.dashboardResultsToggler);
  $('.dashboard-results-toggler').css('right',`${($('#dashboard-results-container-right').width()-convertRemToPixels(3))/$('body').width()*100}%`)
  var dashboardScrollLeft = 0;
  var dashboardScrollTop = {'left':0,'right':0};
  if(urlParams.showHighlightsBar === undefined || urlParams.showHighlightsBar === null){
    urlParams.showHighlightsBar = true
  }
  if(!urlParams.showHighlightsBar){ $('#highlights-tables-container').hide()}
  moveCollapse('legend-collapse','sidebar-left')

  // resizeDashboardPanes();
  // $( "#dashboard-results-container-right" ).scrollTop()
  // $("#dashboard-results-div").mouseup(()=>dashboardScrollLeft=$( "#dashboard-results-div" ).scrollLeft())
  var dashboardResultsLocation ='right';
  var dashboardMoveLocationDict = {'right':'dashboard-results-list','left':'charts-highlights-placeholder'};
  var dashboardScrollDict = {'right':'#dashboard-results-container-right','left':'#sidebar-left-container'};

  var resultsScrollHandler = function() {
    clearTimeout($.data(this, 'scrollTimer'));
    $.data(this, 'scrollTimer', setTimeout(function() {
      
      dashboardScrollTop[dashboardResultsLocation] = $( dashboardScrollDict[dashboardResultsLocation] ).scrollTop();
      // console.log(`Scrolling stopped ${dashboardScrollTop[dashboardResultsLocation]}`)
    }, 250));
  }
  var turnOnScrollMonitoring = function(){
    $(dashboardScrollDict[dashboardResultsLocation]).scroll(resultsScrollHandler);
  }
  var turnOffScrollMonitoring = function(){
    $(dashboardScrollDict[dashboardResultsLocation]).off('scroll',resultsScrollHandler);
  }

  $('.panel-title').click((e)=>{setTimeout(()=>{resizeDashboardPanes()},500);});
  function addExpander(){
    var expander = {};
    expander.setDragID = (id)=>expander.id = id;
    expander.mouseDown=false;
    expander.mouseUpFun;expander.originalBackgroundColor;
    expander.startListening=()=>{
      $('body').mousedown(e=>{
        // console.log(e.target.id)
        if(e.target.id===expander.id){
          expander.mouseDown=true;
          expander.originalBackgroundColor=$(`#${expander.id}`).css('background-color');
          $(`#${expander.id}`).css('background-color','#00BFA5');
          
          $('body').css('user-select','none');
          
        }
      }).mouseup(e=>{
        if(expander.mouseDown){
          console.log('mouseUp');
          expander.mouseDown=false;
          expander.mouseUpFun(e);
          $(`#${expander.id}`).css('background-color',expander.originalBackgroundColor);
          $('body').css('user-select','auto');
        }
        
      })
    
    }

    return expander
  }
  var dashboardResultsHeight = convertRemToPixels(23);
  var expander = addExpander();
  expander.setDragID('dashboard-results-expander');

  expander.mouseUpFun=(e)=>{
    dashboardResultsHeight = window.innerHeight-e.pageY-$(`#${expander.id}`).height();
        $('.dashboard-results-container').css('height',dashboardResultsHeight);
       
    updateDashboardCharts();
  }
  expander.startListening();
  // console.log(expander);
  var isDragging = false;
  var wasDragging = false;
  var mouseDown = false;
  
  var dragBox;
  
  $('#summary-area-selection-radio').change(()=>{
    console.log(dashboardAreaSelectionMode)
    if(dashboardAreaSelectionMode==='View-Extent'){
      clearAllSelectedDashboardFeatures();
		  startDashboardViewExtentSelect();
      try{dragBox.stopListening();}catch(err){}
      dashboardBoxSelect();
    }else if(dashboardAreaSelectionMode==='Drag-Box'){
      
      if(dragBox === undefined){
        dragBox=addDragBox();
        dragBox.addListenTo(map,'map')
      dragBox.addOnStopFunction(dashboardDragboxLayerSelect)
          dragBox.addOnStartFunction(clearAllSelectedDashboardFeatures)
        // Object.values(layerObj).filter(l=>l.viz.dashboardSummaryLayer).map(v=>dragBox.addListenTo(v.layer,v.id))
        }
      stopDashboardViewExtentSelect();
      stopDashboardClickLayerSelect();
      clearAllSelectedDashboardFeatures();
      dragBox.startListening();
    }else{
      stopDashboardViewExtentSelect();
      clearAllSelectedDashboardFeatures();
      startDashboardClickLayerSelect();
      try{dragBox.stopListening();}catch(err){}
    }

});
var showPairwiseDiff;
pairwiseDiffFun=()=>{
  if(pairwiseDiff==='Annual-Change'){showPairwiseDiff=true}
  else{showPairwiseDiff=false};
};
pairwiseDiffFun();
$('#summary-pairwise-diff-radio').change(()=>{
  pairwiseDiffFun();
  updateDashboardCharts();
})
  $('#support-collapse-div').append(staticTemplates.supportDivDashboard);

  
}
if(urlParams.showSidebar === undefined || urlParams.showSidebar === null){
  urlParams.showSidebar = true
}
// Handle legacy 'true' and 'false'
if(urlParams.showSidebar === 'true'){urlParams.showSidebar = true}
else if(urlParams.showSidebar === 'false'){urlParams.showSidebar = false}

function toggleSidebar(){
  
  $('#sidebar-left').toggle('collapse');
  // $('#title-banner').toggle('collapse');
  
  if(mode === 'lcms-dashboard'){
    setTimeout(()=>{resizeDashboardPanes()},500);
  }
  if(urlParams.showSidebar === false){
    urlParams.showSidebar = true
  }else{
    urlParams.showSidebar = false
  }
  
};
function toggleHighlights(){
  turnOffScrollMonitoring();
  $('#dashboard-results-list').toggle('collapse');
  setTimeout(()=>{resizeDashboardPanes();
    urlParams.showHighlightsBar = $('#dashboard-results-list').css("display")!=='none';
    turnOnScrollMonitoring();
  },500);
}
if(urlParams.showSidebar === false){
  $('#sidebar-left').hide();
}

//Wrapper for mapping functions
///////////////////////////////////////////////////////////////////
//Set up some globals
var mapDiv = document.getElementById('map');

// tableConverter = function(dataTableT){

//   // var x = [dataTableT[0]]
//   // x[0][0] = 'Year'
//   // dataTableT.slice(1).map(function(i){
    
//   //   i[0] = (i[0].getYear()+1900).toString()
//   //   x.push(i)
//   // })
//   // dataTableT   = x
// var lcDict = {
//   '0': 'No data',
// '1': 'Barren',
// '2': 'Grass/forb/herb',
// '3': 'Impervious',
// '4': 'Shrubs',
// '5': 'Snow/ice',
// '6': 'Trees',
// '7': 'Water'
// };

// var luDict = {
//   '0': 'No data',
// '1': 'Agriculture',
// '2': 'Developed',
// '3': 'Forest',
// '4': 'Non-forest wetland',
// '5': 'Other',
// '6': 'Rangeland'
// };

// var cpDict = {
//   '0': 'No Data',
//   '1': 'Stable',
//   '2':'Growth/recovery',
//   '3': 'Fire',
//   '4': 'Harvest',
//   '5': 'Other'
// }

//   // if(dataTableT[0].length > 5){
//   if(analysisMode === 'advanced'){
//     // console.log('convertinggggggg tabbbbbbbble' );
//     var isFirst = true;
//     dataTableT = dataTableT.map(function(i){if(isFirst === false){i[3] = lcDict[Math.round(i[3]*10)]};isFirst = false;return i});
//     var isFirst = true;
//     dataTableT = dataTableT.map(function(i){if(isFirst === false){i[4] = luDict[Math.round(i[4]*10)]};isFirst = false;return i});
//     var isFirst = true;
//     // dataTableT = dataTableT.map(function(i){if(isFirst === false){i[5] = cpDict[parseInt(i[5]*10)]};isFirst = false;return i});
// //       dataTableT = dataTableT.map(function(i){i[2] = cdlDict[i[2]];return i})
//   }
  

//       return dataTableT
//     };



function copyObj(mainObj) {
  let objCopy = {}; // objCopy will store a copy of the mainObj
  let key;

  for (key in mainObj) {
    objCopy[key] = mainObj[key]; // copies each property to the objCopy object
  }
  return objCopy;
};
function copyArray(array) {
  var arrayCopy = []; 
 

  array.map(function(i){
    arrayCopy.push(i)
  })
    
  
  return arrayCopy;
};
///////////////////////////////////////////////////////////////////
//Function to compute range list on client side
function range(start, stop, step){
  start = parseInt(start);
  stop = parseInt(stop);
    if (typeof stop=='undefined'){
        // one param defined
        stop = start;
        start = 0;
    }
    if (typeof step=='undefined'){
        step = 1;
    }
    if ((step>0 && start>=stop) || (step<0 && start<=stop)){
        return [];
    }
    var result = [];
    for (var i=start; step>0 ? i<stop : i>stop; i+=step){
        result.push(i);
    }
    return result;
}
///////////////////////////////////////////////////////////////////
//Convert lng, lat to nad 83 code
function llToNAD83(x,y){
      var vertex = [x,y];
      var smRadius = 6378136.98;
      var smRange = smRadius * Math.PI * 2.0;
      var smLonToX = smRange / 360.0;
      var smRadiansOverDegrees = Math.PI / 180.0;


      // compute x-map-unit
      vertex[0] *= smLonToX;

      var y = vertex[1];

      // compute y-map-unit
      if (y > 86.0)
      {
      vertex[1] = smRange;
      }
      else if (y < -86.0)
      {
      vertex[1] = -smRange;
      }
      else
      {
      y *= smRadiansOverDegrees;
      y = Math.log(Math.tan(y) + (1.0 / Math.cos(y)), Math.E);
      vertex[1] = y * smRadius; 
      }
      return {'x':vertex[0],'y':vertex[1]}
    }
///////////////////////////////////////////////////////////////////
//Make an object out of to lists of keys and values
//From:https://stackoverflow.com/questions/12199051/merge-two-arrays-of-keys-and-values-to-an-object-using-underscore answer 6
var toObj = (ks, vs) => ks.reduce((o,k,i)=> {o[k] = vs[i]; return o;}, {});
var toDict = toObj;
////////////////////////////////////////
//Copy an array
function CopyAnArray (ari1) {
   var mxx4 = [];
   for (var i=0;i<ari1.length;i++) {
      var nads2 = [];
      for (var j=0;j<ari1[0].length;j++) {
         nads2.push(ari1[i][j]);
      }
      mxx4.push(nads2);
   }
   return mxx4;
}
///////////////////////////////////////////////////////////////////
//Get a column of a 2-d array
function arrayColumn(arr,i){return arr.map(function(r){return r[i]})};
///////////////////////////////////////////////////////////////////
//Convert xyz coords to quad key for map services such as Bing
//Source: http://bcdcspatial.blogspot.com/2012/01/onlineoffline-mapping-map-tiles-and.html
function tileXYZToQuadKey(x, y, z){
        var quadKey = '';
         for(var i = z;i > 0;i--){
             var digit = 0;
              var mask = 1 << (i - 1);
              // print(mask);
              // print(i);
              if((x & mask)  != 0){
                        digit = digit + 1
                      }
              // print((x & mask))
              // print(digit)
              if((y & mask) != 0){
                        digit =digit + 2
                    
                  }
              // print(digit)
              quadKey = quadKey  + digit.toString();
            }
                return quadKey
       }
///////////////////////////////////////////////////////////////////
//Functions for centering map
function centerMap(lng,lat,zoom){
    map.setCenter({lat:lat,lng:lng});
    map.setZoom(zoom);
}
function synchronousCenterObject(feature){
    var bounds = new google.maps.LatLngBounds(); 
    feature.coordinates[0].map(function(latlng){
     bounds.extend({lng:latlng[0], lat:latlng[1]});
    });
    map.fitBounds(bounds);
}
function centerObject(fc){
  try{
    fc.geometry().bounds(100).evaluate(function(feature){synchronousCenterObject(feature);
    });
  }
  catch(err){
    try{
      fc.bounds(100).evaluate(function(feature){synchronousCenterObject(feature);
    })}catch(err){
      console.log(err);
    }
    console.log(err);
  }
}
///////////////////////////////////////////////////////////////////
//Function for creating color ramp generally for a map legend
function createColorRamp(styleName, colorList, width,height){
  colorList = colorList.map(addColorHash);
  var myCss ="background-image:linear-gradient(to right, ";
  for(var i = 0; i< colorList.length;i++){myCss = myCss + colorList[i].toLowerCase() + ',';}
  myCss = myCss.slice(0,-1) + ");";
  return myCss
}
///////////////////////////////////////////////////////////////////
//Function to convert csv, kml, shp to geoJSON using ogre.adc4gis.com
function convertToGeoJSON(formID){
  var url = 'https://ogre.adc4gis.com/convert'

  var data = new FormData();
  // data.append("sourceSrs","EPSG:5070");
   
  data.append("targetSrs","EPSG:4326");
  jQuery.each(jQuery('#'+formID)[0].files, function (i, file) {
    data.append("upload", file);
  });
  var out= $.ajax({
    type: 'POST',
    url: url,
    data: data,
    processData: false,
    contentType: false,
    error: function (err) {
        // console.log("AJAX error in request: " + JSON.stringify(err, null, 2));
        showMessage('Error!', 'Error converting file: <hr>'+err.responseJSON.msg.replace('\n','<br>'));
        $('#summary-spinner').hide();
    }
  });
  return out;
}
function compressGeoJSON(geoJSON,reductionFactor){
  if(reductionFactor === undefined || reductionFactor === null){reductionFactor = 2}
  geoJSON.features = geoJSON.features.map(function(f){
    
    if(f.geometry.type.indexOf('Multi')> -1){
      f.geometry.coordinates = f.geometry.coordinates.map(function(poly){
        return poly.map(function(pts){
          if(pts.length>100){
            pts = pts.filter((element, index) => {return index % reductionFactor === 0;})
          }
          return pts//.map(function(pt){
          //   return [parseFloat(pt[0].toFixed(decimalPlaces)),parseFloat(pt[1].toFixed(decimalPlaces))]
          // })
        })
      })
    }else{
      f.geometry.coordinates = f.geometry.coordinates.map(function(poly){
        if(poly.length>100){
          poly = poly.filter((element, index) => {return index % reductionFactor === 0;});
        }
        return poly//.map(function(pt){
          // return [parseFloat(pt[0].toFixed(decimalPlaces)),parseFloat(pt[1].toFixed(decimalPlaces))]
        // })
      })
    }
   return f
  })
  return geoJSON
}
//////////////////////////////////////////////////////
//Wrappers for printing and printing to console
function printImage(message){print(message)};
function print(message){
    console.log(message)
}
function printEE(obj){
  print('Getting info about ee object')
  console.log(obj.getInfo(function(success,failure){
    if(success !== undefined){
      console.log(success);
    }
    else{
      console.log(failure)
    }

  }))
}
/////////////////////////////////////////////////////
//Get random number within specified range
function getRandomArbitrary(min, max) {
    return Math.random() * (max - min) + min;
}
/////////////////////////////////////////////////////
//Plot manager functions
//Clear plots from plot list
function clearPlots(){
var plotElements = document.getElementById("pt-list");;
                print(plotElements);
                while(plotElements.firstChild){
                    // print('removing')
                    plotElements.removeChild(plotElements.firstChild);
                    }
    plotDictID = 1;
    plotIDList = [];
    plotID =1;
}
function addPlotProject(plotProjectName,plotProjectPts){
  
  var projectElement = document.createElement("ee-pt-project");
  projectElement.name = plotProjectName;
  projectElement.plotList = plotProjectPts;
  projectElement.ID = plotProjectID;
  var ptList = document.querySelector("pt-project-list");
  ptList.insertBefore(projectElement,ptList.firstChild);
  plotProjectID++;

}

function setPlotColor(ID){
    var plotElements = document.getElementsByTagName("ee-pt");
      
  for(var i = 0;i<plotElements.length;i++){
    plotElements[i].style.outline = 'none';
    
  }
  // console.log(plotElements[0])
  plotElements[plotElements.length-ID].style.outline = '#FFF solid';
   
}
function setPlotProjectColor(ID){
    var plotElements = document.getElementsByTagName("ee-pt-project");
      
  for(var i = 0;i<plotElements.length;i++){
    plotElements[i].style.outline = 'none';
    
  }
  // console.log(plotElements[0])
  plotElements[plotElements.length-ID].style.outline = '#FFF dotted';
   
}
/////////////////////////////////////////////////////
//Wrapper function to add a select layer
function addSelectLayerToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
  viz.canQuery = false;
  viz.isSelectLayer = true;
  addToMap(item,viz,name,visible,label,fontColor,helpBox,'area-charting-select-layer-list',queryItem);
}
/////////////////////////////////////////////////////
//Functions to manage time lapses
var intervalPeriod = 666.6666666666666;
var timeLapseID;
var timeLapseFrame = 0;
var cumulativeMode = false;
function pauseTimeLapse(id){
  if(id === null || id === undefined){id = timeLapseID}
    timeLapseID = id;
  if(timeLapseObj[timeLapseID].isReady){
      pauseAll();
      clearActiveButtons();
      $('#'+timeLapseID+'-pause-button').addClass('time-lapse-active');
    }
  } 

function setFrameOpacity(frame,opacity){
  var s = $('#'+frame).slider();
  s.slider('option', 'value',opacity);
  s.slider('option','slide').call(s,null,{ handle: $('.ui-slider-handle', s), value: opacity });
}
//Function to shoe a specific frame
function selectFrame(id,fromYearSlider,advanceOne){

  if(id === null || id === undefined){id = timeLapseID}
  if(fromYearSlider === null || fromYearSlider === undefined){fromYearSlider = false}
  if(advanceOne === null || advanceOne === undefined){advanceOne = true}
  timeLapseID = id
  
  if(timeLapseID !== undefined && timeLapseObj[timeLapseID].isReady){
    turnOffLayers();
    turnOnTimeLapseLayers();
    var slidersT = timeLapseObj[timeLapseID].sliders;
    if(timeLapseFrame > slidersT.length-1){timeLapseFrame = 0}
    else if(timeLapseFrame < 0){timeLapseFrame = slidersT.length-1}

    if(!eval(cumulativeMode) || timeLapseFrame === 0){
      slidersT.map(function(s){
        try{
          setFrameOpacity(s,0)
        }catch(err){}
        
      });
    }else{
      slidersT.slice(0,timeLapseFrame).map(function(s){
        try{
          setFrameOpacity(s,timeLapseObj[timeLapseID].opacity)
        }catch(err){}
        
      })
    }
    
    var frame = slidersT[timeLapseFrame];
    try{
        setFrameOpacity(frame,timeLapseObj[timeLapseID].opacity);
        if(!fromYearSlider){
          Object.keys(timeLapseObj).map(function(k){
            var s = $('#'+k+'-year-slider').slider();
            s.slider('option', 'value',timeLapseObj[k].years[timeLapseFrame]);
            $('#'+k+'-year-slider-handle-label').text( timeLapseObj[k].years[timeLapseFrame])

          })
        }
      }catch(err){}
    $('#'+timeLapseID+'-year-label').show();
    // $('#'+timeLapseID+'-year-label').html(timeLapseObj[timeLapseID].years[timeLapseFrame])
    $('#time-lapse-year-label').show();
    $('#time-lapse-year-label').html(`Time lapse date: ${timeLapseObj[timeLapseID].years[timeLapseFrame]}`)
    // if(advanceOne){timeLapseFrame++};
  }
  
}
function advanceOneFrame(){
  timeLapseFrame++;
  selectFrame()
}
function pauseButtonFunction(id){
  if(id === null || id === undefined){id = timeLapseID}
  
  timeLapseID = id;
  if(timeLapseID !== undefined && timeLapseObj[timeLapseID].isReady){
    clearAllFrames();
    pauseTimeLapse();
    selectFrame();
    alignTimeLapseCheckboxes();
    timeLapseObj[timeLapseID].state = 'paused';
  }

}
function pauseAll(){
  Object.keys(timeLapseObj).map(function(k){
    if(timeLapseObj[k].intervalValue !== null && timeLapseObj[k].intervalValue !== undefined){
      window.clearInterval(timeLapseObj[k].intervalValue);
    }
    timeLapseObj[k].intervalValue = null;
  })
}
function forwardOneFrame(id){
    timeLapseID = id;
    if(timeLapseObj[timeLapseID].isReady){
      clearAllFrames();
      pauseTimeLapse();
      // year++;
      advanceOneFrame();
      alignTimeLapseCheckboxes();
    }
  };
function backOneFrame(id){
    timeLapseID = id;
    if(timeLapseObj[timeLapseID].isReady){
      clearAllFrames();
      pauseTimeLapse();

      timeLapseFrame--;
      selectFrame();
      alignTimeLapseCheckboxes();
    }
  };
function clearActiveButtons(){
   Object.keys(timeLapseObj).map(function(k){
    $('#'+k+'-pause-button').removeClass('time-lapse-active');
    $('#'+k+'-play-button').removeClass('time-lapse-active');
    if(k === timeLapseID){
      $('#'+k+'-stop-button').removeClass('time-lapse-active');
    }
    
   })
};
function clearAllFrames(){
  turnOffAllNonActiveTimeLapseLayers(); 
  
  Object.keys(timeLapseObj).map(function(k){
    var slidersT = timeLapseObj[k].sliders;
    $('#'+k+'-year-label').hide();
    $('#'+k+'-stop-button').addClass('time-lapse-active');
    $('#'+k+'-pause-button').removeClass('time-lapse-active');
    $('#'+k+'-play-button').removeClass('time-lapse-active');
    timeLapseObj[k].state = 'inactive';
    slidersT.map(function(s){
      try{setFrameOpacity(s,0)}
      catch(err){}
      
    })
  })
}
function setSpeed(id,speed){
  timeLapseID = id;
  intervalPeriod = speed;
  if(timeLapseObj[timeLapseID].isReady){
    pauseAll();
    playTimeLapse(id);
  }
}
function playTimeLapse(id){
   if(id === null || id === undefined){id = timeLapseID}
  
  timeLapseID = id;
  if(timeLapseID !== undefined && timeLapseObj[timeLapseID].isReady){
    clearAllFrames();
    pauseAll();
    timeLapseObj[timeLapseID].state = 'play';
    selectFrame(null,null,false);
    if(timeLapseObj[id].intervalValue === null || timeLapseObj[id].intervalValue === undefined){
        timeLapseObj[id].intervalValue =window.setInterval(advanceOneFrame, intervalPeriod);
      }
      $('#'+id+'-stop-button').removeClass('time-lapse-active');
      $('#'+id+'-pause-button').removeClass('time-lapse-active');
      $('#'+id+'-play-button').addClass('time-lapse-active');
      alignTimeLapseCheckboxes();
  }
}
function stopTimeLapse(id){
  $('#time-lapse-year-label').empty();
  $('#time-lapse-year-label').hide();
  timeLapseID = null;
  // turnOffAllTimeLapseLayers();
  pauseAll();
  clearAllFrames();
}
//Toggle all layers within a specific time lapse layer
function toggleTimeLapseLayers(id){
  if(id === null || id === undefined){id = timeLapseID}
  var visibleToggles = timeLapseObj[k].layerVisibleIDs;
  visibleToggles.map(function(i){$('#'+i).click()});
}
//Toggle all layers within all time lapse layers
function toggleAllTimeLapseLayers(){
  Object.keys(timeLapseObj).map(function(k){
    toggleTimeLapseLayers(k)
  })
}
//Turn off all layers within all time lapse layers
function turnOffAllTimeLapseLayers(){
  Object.keys(timeLapseObj).map(function(k){
    turnOffTimeLapseLayers(k)
  })
}
//Turn off all layers within non active time lapses
function turnOffAllNonActiveTimeLapseLayers(){
  Object.keys(timeLapseObj).map(function(k){
    if(k !== timeLapseID){
      turnOffTimeLapseLayers(k);
    }
  })
}
function toggleTimeLapseLayers(id){
  if(id === null || id === undefined){id = timeLapseID}
  if(timeLapseObj[id].isReady){
    timeLapseObj[id].layerVisibleIDs.map(function(i){$('#'+i).click()});
    if(timeLapseObj[id].visible){
      timeLapseObj[id].visible = false
    }else{timeLapseObj[id].visible = true}
  }
}
function turnOnTimeLapseLayers(id){
  if(id === null || id === undefined){id = timeLapseID}
  if(timeLapseObj[id].isReady){
    
    if(timeLapseObj[id].visible === false){
      timeLapseObj[id].visible = true;
      timeLapseObj[id].layerVisibleIDs.map(function(i){$('#'+i).click()});
    }
    queryObj[id].visible = timeLapseObj[id].visible;
  }
}
function turnOffTimeLapseLayers(id){
  if(id === null || id === undefined){id = timeLapseID}
  if(timeLapseObj[id].isReady){
    
    if(timeLapseObj[id].visible === true){
      timeLapseObj[id].visible = false;
      timeLapseObj[id].layerVisibleIDs.map(function(i){$('#'+i).click()});
    }
    queryObj[id].visible = timeLapseObj[id].visible;
  }
}
//Function to handle tiles getting stuck when requested from GEE
//Currently the best method seems to be to jitter the zoom to re-request the tiles from GEE
var lastJitter;
function jitterZoom(fromButton){
  if(fromButton === null || fromButton === undefined){fromButton = false}
  if(lastJitter === null || lastJitter === undefined){
    lastJitter = new Date();
  }
  var tDiff = new Date() - lastJitter;
  var jittered = false;
  if((tDiff > 5000 && geeTileLayersDownloading === 0) || tDiff > 20000 || fromButton){
    // console.log(tDiff)
    console.log('jittering zoom')
    var z = map.getZoom();
    updateViewList = false;
    map.setZoom(z-1);
    updateViewList = false;
    map.setZoom(z);
    jittered = true;
    lastJitter = new Date();
  }
  
  return jittered
  
}
//Tidy up time lapse checkboxes
function alignTimeLapseCheckboxes(){
  Object.keys(timeLapseObj).map(function(k){
    if(timeLapseObj[k].isReady){
      var checked = false;
      if(timeLapseObj[k].visible){
        checked = true;
        $('#'+k+'-time-lapse-layer-range-container').slideDown();
        $('#'+k+'-icon-bar').slideDown();
        $('#'+k+'-collapse-label').addClass('time-lapse-label-container');
      }
      else{
        $('#'+k+'-collapse-label').css('background',`-webkit-linear-gradient(left, #FFF, #FFF ${0}%, transparent ${0}%, transparent 100%)`);
        $('#'+k+'-time-lapse-layer-range-container').slideUp();
        $('#'+k+'-icon-bar').slideUp();
        $('#'+k+'-collapse-label').removeClass('time-lapse-label-container');
        $('#'+k+'-loading-spinner').hide();
        $('#'+k+'-loading-gear').hide();
      }
        
      $('#'+k+'-toggle-checkbox').prop('checked', checked);
    }
  })
}
function timeLapseCheckbox(id){
  var v = timeLapseObj[id].visible;
  ga('send', 'event', 'time-lapse-toggle', id,v);
  if(!v){
    pauseButtonFunction(id);

  }else{
    stopTimeLapse(id);
  }
  alignTimeLapseCheckboxes();
}
function toggleFrames(id){
  $('#'+id+'-collapse-div').toggle();
}
//Turn off all time lapses
function turnOffTimeLapseCheckboxes(){
  Object.keys(timeLapseObj).map(function(k){
    if(timeLapseObj[k].isReady){
      if(timeLapseObj[k].visible){
        stopTimeLapse(k);
      }
    }
    
  });
  alignTimeLapseCheckboxes();
}
//Toggle whether to show all layers prior to the current layer or just a single layer
function toggleCumulativeMode(){
  if(cumulativeMode){
    $('.cumulativeToggler').removeClass('time-lapse-active');
    cumulativeMode = false;
  }else{
    $('.cumulativeToggler').addClass('time-lapse-active');
    cumulativeMode = true;
  }
  // timeLapseFrame--;
  selectFrame();
  
}

//Fill empty collections
function fillEmptyCollections(inCollection,dummyImage){                       
  var dummyCollection = ee.ImageCollection([dummyImage.mask(ee.Image(0))]);
  var imageCount = inCollection.toList(1).length();
  return ee.ImageCollection(ee.Algorithms.If(imageCount.gt(0),inCollection,dummyCollection));

}
//////////////////////////////////////////////////////////////////////////
//Wrapper function to add a time lapse to the map
function addTimeLapseToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
  if(viz !== null && viz !== undefined && viz.serialized !== null && viz.serialized !== undefined && viz.serialized === true){
        item = ee.Deserializer.decode(item);
        viz.serialized = false;
    }
  if(viz.cumulativeMode === null || viz.cumulativeMode === undefined){viz.cumulativeMode = false}
    //Force time lapses to be turned off on load to speed up loading
    var visible = false;
  if(viz.opacity === undefined || viz.opacity === null){viz.opacity = 1}
  item = ee.ImageCollection(item);

  if(name== undefined || name == null){
    name = "Layer "+NEXT_LAYER_ID;  
  }
  var checked = '';
  if(visible){checked = 'checked'}
  var legendDivID = name.replaceAll(' ','-')+ '-' +NEXT_LAYER_ID.toString() ;
  legendDivID = legendDivID.replace(/[^A-Za-z0-9]/g, "-");
  // legendDivID = legendDivID.replaceAll('/','-');
  // legendDivID = legendDivID.replaceAll('(','-');
  // legendDivID = legendDivID.replaceAll(')','-');
  // legendDivID = legendDivID.replaceAll('&','-');
  // legendDivID = legendDivID.replaceAll(',','-');
  // legendDivID = legendDivID.replaceAll('.','-');
  // legendDivID = legendDivID.replaceAll('%','-');
  // legendDivID = legendDivID.replaceAll('^','-');
  
  //AutoViz if specified
  if(viz.autoViz){
    dicts =getLookupDicts(ee.Image(item.first()),null,'eeImage')
    viz.classLegendDict = dicts.classLegendDict;
    viz.queryDict = dicts.queryDict;
    viz.autoViz = false;
  }
  if(viz.mosaic  === null || viz.mosaic  === undefined){
    viz.mosaic = false;
  }
  viz.canQuery = false;
  viz.isSelectLayer = false;
  viz.isTimeLapse = true;
  viz.timeLapseID = legendDivID;
  viz.layerType = 'geeImage';
  
  if(viz.dateFormat  === null || viz.dateFormat  === undefined){
    viz.dateFormat = 'YYYY';
    viz.advanceInterval = 'year';
  }
  if(viz.dateField  === null || viz.dateField  === undefined){
    viz.dateField = 'system:time_start';
  }

  timeLapseObj[legendDivID] = {}
  if(whichLayerList === null || whichLayerList === undefined){whichLayerList = "layer-list"}  

 
  
  //Pull out years if not provided
  //Years need to be client-side
  //Assumes the provided image collection has time property under system:time_start property
  if(viz.years === null || viz.years === undefined){
    console.log('start computing years');
    viz.years = unique(item.sort(viz.dateField,true).toList(10000,0).map(function(img){
      var d = ee.Date(ee.Image(img).get(viz.dateField))
      return ee.Number.parse(d.format(viz.dateFormat)).int32()
    }).getInfo());

    console.log('done computing years');
    console.log(viz.years);
    // console.log(viz)
  }
  
  //Set up time laps object entry
  var startYearT = viz.years[0];
  var endYearT = viz.years[viz.years.length-1]
  timeLapseObj[legendDivID].years = viz.years;
  timeLapseObj[legendDivID].frames = ee.List.sequence(0,viz.years.length-1).getInfo();
  timeLapseObj[legendDivID].nFrames = viz.years.length;
  timeLapseObj[legendDivID].loadingLayerIDs = [];
  timeLapseObj[legendDivID].loadingTilesLayerIDs = [];
  timeLapseObj[legendDivID].layerVisibleIDs = [];
  timeLapseObj[legendDivID].sliders = [];
  timeLapseObj[legendDivID].intervalValue = null;
  timeLapseObj[legendDivID].isReady = false;
  timeLapseObj[legendDivID].visible = visible;
  timeLapseObj[legendDivID].state = 'inactive';
  timeLapseObj[legendDivID].opacity = viz.opacity*100;
 
   
  
  var layerContainerTitle = 'Time lapse layers load multiple map layers throughout time. Once loaded, you can play the time lapse as an animation, or advance through single years using the buttons and sliders provided.  The layers can be displayed as a single year or as a cumulative mosaic of all preceding years using the right-most button.'
  
  //Set up container for time lapse
  $('#'+whichLayerList).append(`
                                <li   title = '${layerContainerTitle}' id = '${legendDivID}-collapse-label' class = 'layer-container'>
                                  <div class = 'time-lapse-layer-range-container' >
                                    <div title = 'Opacity' id='${legendDivID}-opacity-slider' class = 'simple-time-lapse-layer-range-first'>
                                      <div id='${legendDivID}-opacity-slider-handle' class=" time-lapse-slider-handle ui-slider-handle">
                                        <div style = 'display:none;' id='${legendDivID}-opacity-slider-handle-label' class = 'time-lapse-slider-handle-label'>${timeLapseObj[legendDivID].opacity/100}</div>
                                      </div>
                                    </div>
                                    <div id='${legendDivID}-time-lapse-layer-range-container' style = 'display:none;'>
                                      <div title = 'Frame Date' id='${legendDivID}-year-slider' class = 'simple-time-lapse-layer-range-first'>
                                        <div id='${legendDivID}-year-slider-handle' class=" time-lapse-slider-handle ui-slider-handle">
                                          <div id='${legendDivID}-year-slider-handle-label' class = 'time-lapse-slider-handle-label'>${viz.years[0]}</div>
                                        </div>
                                      </div>
                                    
                                      <div title = 'Frame Rate' id='${legendDivID}-speed-slider' class = 'simple-time-lapse-layer-range'>
                                        <div id='${legendDivID}-speed-slider-handle' class=" time-lapse-slider-handle ui-slider-handle">
                                          <div id='${legendDivID}-speed-slider-handle-label' class = 'time-lapse-slider-handle-label'>${(1/(intervalPeriod/1000)).toFixed(1)}fps</div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <input  id="${legendDivID}-toggle-checkbox" onchange = 'timeLapseCheckbox("${legendDivID}")' type="checkbox" ${checked}/>
                                  <label  title = 'Activate/deactivate time lapse' id="${legendDivID}-toggle-checkbox-label" style = 'margin-bottom:0px;display:none;'  for="${legendDivID}-toggle-checkbox"></label>
                                  <i style = 'display:none;' id = '${legendDivID}-loading-gear' title = '${name} time lapse tiles loading' class="text-dark fa fa-gear fa-spin layer-spinner"></i>
                                  <i id = '${legendDivID}-loading-spinner' title = '${name} time lapse layers loading' class="text-dark fa fa-spinner fa-spin layer-spinner"></i>

                                  <span  id = '${legendDivID}-name-span'  class = 'layer-span'>${name}</span>

                                  <div id = "${legendDivID}-icon-bar" class = 'icon-bar pl-3 pt-3' style = 'display:none;'>
                                    <button class = 'btn' title = 'Back one frame' id = '${legendDivID}-backward-button' onclick = 'backOneFrame("${legendDivID}")'><i class="fa fa-backward fa-xs"></i></button>
                                    <button class = 'btn' title = 'Pause animation' id = '${legendDivID}-pause-button' onclick = 'pauseButtonFunction("${legendDivID}")'><i class="fa fa-pause"></i></button>
                                    <button style = 'display:none;' class = 'btn time-lapse-active' title = 'Clear animation' id = '${legendDivID}-stop-button' onclick = 'stopTimeLapse("${legendDivID}")'><i class="fa fa-stop"></i></button>
                                    <button class = 'btn' title = 'Play animation' id = '${legendDivID}-play-button'  onclick = 'playTimeLapse("${legendDivID}")'><i class="fa fa-play"></i></button>
                                    <button class = 'btn' title = 'Forward one frame' id = '${legendDivID}-forward-button' onclick = 'forwardOneFrame("${legendDivID}")'><i class="fa fa-forward"></i></button>
                                    <button style = '' class = 'btn' title = 'Refresh layers if tiles failed to load' id = '${legendDivID}-refresh-tiles-button' onclick = 'jitterZoom(true)'><i class="fa fa-refresh"></i></button>
                                    <button style = 'display:none;' class = 'btn' title = 'Toggle frame visiblity' id = '${legendDivID}-toggle-frames-button' onclick = 'toggleFrames("${legendDivID}")'><i class="fa fa-eye"></i></button>
                                    <button class = 'btn cumulativeToggler' onclick = 'toggleCumulativeMode()' title = 'Click to toggle whether to show a single year or all years in the past along with current year'><img style = 'width:1.4em;filter: invert(100%) brightness(500%)'  src="images/cumulative_icon.png"></button>
                                    <div id = "${legendDivID}-message-div" class = 'pt-2'></div>
                                  </div>

                                </li>
                                
                                <div id = '${legendDivID}-collapse-div' style = 'display:none;'></div>`)
  
  
  //Add legend
  $('#time-lapse-legend-list').append(`<div id="legend-${legendDivID}-collapse-div"></div>`);
  onclick = 'timeLapseCheckbox("${legendDivID}")'
  var prevent = false;
  var delay = 200;
  $('#'+ legendDivID + '-name-span').click(function(){
    // showMessage('test')
    setTimeout(function(){
      if(!prevent){
        timeLapseCheckbox(legendDivID);
      }
    },delay)
    
  });
  // $('#'+ legendDivID + '-name-span').dblclick(function(){
  //   // showMessage('test',item.get('bounds').getInfo())
  //   // printEE(item.get('bounds'))
  //   // synchronousCenterObject(item.get('bounds'))
  //   })

  //Add in layers
  viz.layerType = 'geeImage';
  viz.legendTitle = name;
  viz.opacity = 0;

  if(viz.timeLapseType === 'tileMapService'){
    viz.layerType = 'tileMapService';
    viz.years.map(function(yr){
      if(yr !== viz.years[0]){
        viz.addToLegend = false;
        viz.addToClassLegend = false;
      }
      var vizT = Object.assign({},viz);
      vizT.year = yr
        addToMap(standardTileURLFunction(item + yr.toString()+'/',true,''),vizT,name +' '+   yr.toString(),visible,label ,fontColor,helpBox,legendDivID+'-collapse-div',queryItem);
     }) 
  }else{
    var dummyImage = ee.Image(item.first());
    var cT = []
    viz.years.map(function(yr){

      // Get the date
      var d = ee.Date.parse(viz.dateFormat,yr.toString());

       // Filter and find the image
      if(viz.dateField !== 'system:time_start'){
        
        var img = item.filter(ee.Filter.gte(viz.dateField,d.millis()));
        img = img.filter(ee.Filter.lt(viz.dateField,d.advance(1,viz.advanceInterval).millis()));
        // var img = item.filter.and(ee.Filter.gte(viz.dateField,d.millis()),ee.Filter.lt(viz.dateField,d.advance(1,viz.advanceInterval).millis()));
        img = fillEmptyCollections(img,dummyImage);
      }else{
        // This method fails with different dateFields than system:time_start
        var img = fillEmptyCollections(item.filterDate(d,d.advance(1,viz.advanceInterval)),dummyImage);
      }
      
      if(viz.mosaic){
        var img = ee.Image(img.mosaic()).set('system:time_start',d.millis());
      }else{
        var img = ee.Image(img.first()).set('system:time_start',d.millis());
      }
      
      cT.push(img)
      if(yr !== viz.years[0]){
        viz.addToLegend = false;
        viz.addToClassLegend = false;
        viz.classLegendDict = null;
      }
      var vizT = Object.assign({},viz);
      vizT.year = yr
      addToMap(img,vizT,name +' '+   yr.toString(),visible,label ,fontColor,helpBox,legendDivID+'-collapse-div',queryItem);
    })
    
     // Set the time_start (which is used for pixel query charting) to the date used 
      // regardless of the dateField so the same dates will appear in the charts and timeLapse
    if(viz.dateField !== 'system:time_start'){
      item = ee.ImageCollection(cT);
    }
  }
  //If its a tile map service, don't wait
  if(viz.timeLapseType === 'tileMapService'){
    timeLapseObj[legendDivID].isReady = true;
    $('#'+legendDivID+'-toggle-checkbox-label').show();
    $('#'+legendDivID+'-loading-spinner').hide();
  }

  // Set up query collection
  queryObj[legendDivID] = {'visible':timeLapseObj[legendDivID].visible,'queryItem':item,'queryDict':viz.queryDict,'type':'geeImageCollection','name':name,'queryDateFormat':viz.queryDateFormat}; 

  //Get all the individual layers' sliders
  timeLapseObj[legendDivID].sliders = timeLapseObj[legendDivID].sliders;

  //Handle the sliders for that time lapse
  //Start with the opacity slider
  //Controls the opacity of all layers within that time lapse
  $('#'+legendDivID+'-opacity-slider').slider({
        min: 0,
        max: 1,
        step: 0.05,
        value: timeLapseObj[legendDivID].opacity/100,
        slide: function(e,ui){
          var opacity = ui.value;
          var k = legendDivID;
          var s = $('#'+k+'-opacity-slider').slider();
          s.slider('option', 'value',ui.value);
          $('#'+k+'-opacity-slider-handle-label').text(opacity);
          timeLapseObj[k].opacity = opacity*100
          selectFrame(null,null,false);
          setTimeLapseRangeSliderThumbOpacity(opacity);
        }
      });
      function setTimeLapseRangeSliderThumbOpacity(opacity){
        $(`#${legendDivID}-opacity-slider`).css("background-color", `rgba(55, 46, 44,${opacity})!important`)  
	}
  //The year slider
  $('#'+legendDivID+'-year-slider').slider({
        min: startYearT,
        max: endYearT,
        step: 1,
        value: startYearT,
        slide: function(e,ui){
          var yr = ui.value;
          var i = viz.years.indexOf(yr);
          timeLapseFrame = i;
          Object.keys(timeLapseObj).map(function(k){
            var s = $('#'+k+'-year-slider').slider();
            s.slider('option', 'value',ui.value);
            $('#'+k+'-year-slider-handle-label').text( ui.value )
          })
          if(timeLapseObj[legendDivID].isReady){
            clearAllFrames();
            pauseTimeLapse(legendDivID);
            selectFrame(legendDivID,true,false);
            alignTimeLapseCheckboxes();
          }
        }
      });
  //The speed slider
  $('#'+legendDivID+'-speed-slider').slider({
        min: 0.5,
        max: 3.0  ,
        step: 0.5,
        value: 1.5,
        slide: function(e,ui){
          var speed = 1/ui.value*1000;
          Object.keys(timeLapseObj).map(function(k){
            var s = $('#'+k+'-speed-slider').slider();
            s.slider('option', 'value',ui.value);
            $('#'+k+'-speed-slider-handle-label').text(`${ui.value.toFixed(1)}fps`)
          })
          if(timeLapseObj[legendDivID].isReady){
            setSpeed(legendDivID,speed)
          }
        }
      });
}
/////////////////////////////////////////////////////
//Wrapper to add an export

function addExport(eeImage,name,res,Export,metadataParams,noDataValue){

  var exportElement = {};
  if(res === null || res === undefined){
    res = 30;
  }
  if(metadataParams === null || metadataParams === undefined){
    metadataParams = {};//'studyAreaName':studyAreaName,'version':'v2019.1','summaryMethod':summaryMethod,'whichOne':'Gain Year','startYear':startYear,'endYear':endYear,'description':'this is a description'}
  }
  if(Export === null || Export === undefined){
    Export = true;
  }
  if(noDataValue === null || noDataValue === undefined){
 
    noDataValue = -32768;
  }
  var checked = '';
  if(Export){checked = 'checked'}
  
  var now = Date().split(' ');
  var nowSuffix = '_'+now[2]+'_'+now[1]+'_'+now[3]+'_'+now[4]

  name = name;//+ nowSuffix
  name = name.replace(/[^A-Za-z0-9]/g, "_");
  // name = name.replace(/\s+/g,'_')
  // name = name.replaceAll('(','_')
  // name = name.replaceAll(')','_')
  exportElement.res = res;
  exportElement.name = name;
 
  exportElement.eeImage = eeImage;

  exportElement.Export = Export;
  exportElement.ID = exportID;
  
  exportImageDict[exportID] = {'eeImage':eeImage,'name':name,'res':res,'shouldExport':Export,'metadataParams':metadataParams,'noDataValue':noDataValue}
  // var exportList = document.querySelector("export-list");
  $('#export-list').append(`<div class = 'input-group'>
                              <span  class="input-group-addon">
                                <input  id = '${name}-checkbox-${exportID}' type="checkbox" ${checked} >
                                <label  style = 'margin-bottom:0px;'  for='${name}-checkbox-${exportID}'></label>
                              </span>
                              
                              <input  id = '${name}-name-${exportID}' class="form-control export-name-input" type="text" value="${exportElement.name}" title = 'Change export name if needed'>
                              <input  id = '${name}-res-${exportID}' class="form-control export-res-input" type="text" value="${exportElement.res}" title = 'Change export spatial resolution (meters) if needed'>
                            </div>`)
  $('#' + name + '-name-'+exportID.toString()).on('input', function() {
    exportImageDict[exportElement.ID].name = $(this).val();
  });
  $('#' + name + '-res-'+exportID.toString()).on('input', function() {
    exportImageDict[exportElement.ID].res = parseInt($(this).val());
  });
  $('#' + name + '-checkbox-'+exportID.toString()).on('change', function() {
   
    exportImageDict[exportElement.ID].shouldExport = this.checked;
  });
  
  exportID ++;
}

/////////////////////////////////////////////////////
//Function to add ee object as well as client-side objects to map
function getLookupDicts(image,bandName,layerType){
  if(layerType == 'geeImageCollection'){image = ee.Image(image.first())}
  if(bandName === null || bandName === undefined){
    bandName = ee.Image(image).bandNames().getInfo()[0]
  }
  values = ee.List([image.get(bandName+'_class_values'),image.get(bandName+'_class_names'),image.get(bandName+'_class_palette')]).getInfo()
  value_name = zip(values[0],values[1]).map(function(i){return i.join('- ')})
  // console.log(value_name)
  legendDict = toObj(value_name,values[2])
  queryDict = toObj(values[0],value_name)
  return {'classLegendDict':legendDict,'queryDict':queryDict}
}
var typeLookup = {'Image':'geeImage','ImageCollection':'geeImageCollection','Feature':'geeVectorImage','FeatureCollection':'geeVectorImage','Geometry':'geeVectorImage'}
function addToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
    
    // $('#layer-list-collapse-label-message').html(`Loading: ${name}`)
    if(viz !== null && viz !== undefined && viz.serialized !== null && viz.serialized !== undefined && viz.serialized === true){
        item = ee.Deserializer.decode(item);
    }
    var currentGEERunID = geeRunID;
    if(whichLayerList === null || whichLayerList === undefined){whichLayerList = "layer-list"}
    if(viz === null || viz === undefined){viz = {}}
    if(name===undefined || name === null){
        name = "Layer "+NEXT_LAYER_ID;  
    }
    //Possible layerType: geeVector,geoJSONVector,geeImage,geeImageArray,geeImageCollection,tileMapService,dynamicMapService
    if(viz.layerType === null || viz.layerType === undefined){
      var eeType = ee.Algorithms.ObjectType(item).getInfo();
      if(eeType === 'Feature'){
        item = ee.FeatureCollection([item])
        eeType = ee.Algorithms.ObjectType(item).getInfo();
      }
   
      viz.layerType =typeLookup[eeType]; 
     
    }
    
    // console.log(name + ': '+viz.layerType)
    // console.log(item.bandNames())
    if(viz.layerType === 'geoJSONVector'){viz.canQuery = false;}
    
    if(viz.layerType === 'geeVector' || viz.layerType === 'geoJSONVector'){
      if(viz.strokeOpacity === undefined || viz.strokeOpacity === null){viz.strokeOpacity = 1};
      if(viz.fillOpacity === undefined || viz.fillOpacity === null){viz.fillOpacity = 0.2};
      if(viz.fillColor === undefined || viz.fillColor === null){viz.fillColor = '222222'};
      if(viz.strokeColor === undefined || viz.strokeColor === null){viz.strokeColor = getColor()};
      if(viz.strokeWeight === undefined || viz.strokeWeight === null){viz.strokeWeight = 3};
      viz.opacityRatio = viz.strokeOpacity/viz.fillOpacity;
      if(viz.fillColor.indexOf('#') == -1){viz.fillColor = '#' + viz.fillColor};
      if(viz.strokeColor.indexOf('#') == -1){viz.strokeColor = '#' + viz.strokeColor};
      if(viz.addToClassLegend === undefined || viz.addToClassLegend === null){
        viz.addToClassLegend = true;
        
      }
    }else if(viz.layerType === 'geeVectorImage' ){
      if(viz.strokeOpacity === undefined || viz.strokeOpacity === null){viz.strokeOpacity = 1};
      viz.fillOpacity = 0;
      if(viz.fillColor === undefined || viz.fillColor === null){viz.fillColor = '222222'};
      if(viz.strokeColor === undefined || viz.strokeColor === null){viz.strokeColor = getColor()};
      if(viz.strokeWeight === undefined || viz.strokeWeight === null){viz.strokeWeight = 2};
      if(viz.fillColor.indexOf('#') == -1){viz.fillColor = '#' + viz.fillColor};
      if(viz.strokeColor.indexOf('#') == -1){viz.strokeColor = '#' + viz.strokeColor};
      if(viz.addToClassLegend === undefined || viz.addToClassLegend === null){
        viz.addToClassLegend = true;viz.addToLegend = false;
        
      }
    }

    //Handle legend
    var legendDivID = name.replaceAll(' ','-')+ '-' +NEXT_LAYER_ID.toString() ;
    legendDivID = legendDivID.replace(/[^A-Za-z0-9]/g, "-");
    // legendDivID = legendDivID.replaceAll('/','-');
    // legendDivID = legendDivID.replaceAll('(','-');
    // legendDivID = legendDivID.replaceAll(')','-');
    // legendDivID = legendDivID.replaceAll('&','-');
    // legendDivID = legendDivID.replaceAll(',','-');
    // legendDivID = legendDivID.replaceAll('.','-');
    // legendDivID = legendDivID.replaceAll('%','-');
    // legendDivID = legendDivID.replaceAll('^','-');
    if(visible == null){
        visible = true;
    }
    if(viz.opacity == null){
      viz.opacity = 1;
    }
    if(viz.bands !== undefined && typeof(viz.bands) === 'string'){
      viz.bands = viz.bands.split(',');
    }
    
    var layerObjKeys = Object.keys(layerObj);
    var nameIndex = layerObjKeys.indexOf(legendDivID);
    if(nameIndex   != -1){
      visible = layerObj[legendDivID].visible;
      viz.opacity = layerObj[legendDivID].opacity;
      if(viz.layerType === 'geeVector' || viz.layerType === 'geoJSONVector'){
        viz.strokeOpacity =  layerObj[legendDivID].opacity;
        viz.fillOpacity = viz.strokeOpacity / viz.opacityRatio;

      }
    }


    if(helpBox == null || helpBox === undefined){helpBox = ''};
    if(viz.title !== null && viz.title !== undefined){helpBox = viz.title};
    var layer = {};//document.createElement("ee-layer");
    
    layer.ID = NEXT_LAYER_ID;
    NEXT_LAYER_ID += 1;
    layer.layerChildID = layerChildID;
    layerChildID++
    layer.name = name ;
    layer.opacity = viz.opacity;
    viz.opacity = 1;
    layer.map = map;
    layer.helpBoxMessage = helpBox;
    layer.visible = visible;
    layer.label = label;
    layer.fontColor = fontColor;
    layer.helpBox = helpBox;
    layer.legendDivID = legendDivID ;
    if(queryItem === null || queryItem === undefined){queryItem = item};
    if(viz.canQuery === null || viz.canQuery === undefined){viz.canQuery = true};
    layer.canQuery = viz.canQuery;
    layer.queryItem = queryItem;
    layer.layerType = viz.layerType;

    //AutoViz if specified
    if(viz.autoViz){
      dicts =getLookupDicts(item,null,viz.layerType)
      viz.classLegendDict = dicts.classLegendDict;
      viz.queryDict = dicts.queryDict
    }
    //Construct legend
    if(viz != null && (viz.bands == null || viz.bands.length==1 )&& viz.addToLegend != false && (viz.addToClassLegend === undefined || viz.addToClassLegend === null || viz.addToClassLegend === false) &&(viz.classLegendDict == undefined || viz.classLegendDict == null )){
      addLegendContainer(legendDivID,'legend-'+whichLayerList,false,helpBox)
      
      var legend ={};
    
        if(viz.legendTitle !== null && viz.legendTitle !== undefined){
         
          legend.name = viz.legendTitle
        }else{
          legend.name = name;
        }
        
        legend.helpBoxMessage = helpBox
        if(viz.palette != null){
            var palette = viz.palette;
        } else{var palette = '000,FFF';}
        var paletteList = palette;
        if(typeof(palette) === 'string'){paletteList = paletteList.split(',');}
        if(paletteList.length == 1){paletteList = [paletteList[0],paletteList[0]];}
        paletteList = paletteList.map(function(color){if(color.indexOf('#')>-1){color = color.slice(1)};return color});
        var colorRamp = createColorRamp('colorRamp'+colorRampIndex.toString(),paletteList,180,20);
      
        legend.colorRamp = colorRamp;

        let legendMinValue = viz.min;
        let legendMaxValue = viz.max;
        if(viz.legendNumbersWithCommas){
          legendMinValue = legendMinValue.numberWithCommas();
          legendMaxValue = legendMaxValue.numberWithCommas();
        }
        if(label != null && viz.min != null){
            legend.min = legendMinValue + ' ' +label;
        } else if(label != null && viz.min == null){
            legend.min = minLabel;
        } else if(label == null && viz.min != null){
            legend.min = legendMinValue;
        } 
        
        if(label != null && viz.max != null){
            legend.max = legendMaxValue + ' ' +label;
        } else if(label != null && viz.max == null){
            legend.max = maxLabel;
        } else if(label == null && viz.max != null){
            legend.max = legendMaxValue;
        } 
        
     
        if(viz.legendLabelLeft !== null && viz.legendLabelLeft !== undefined){legend.min = viz.legendLabelLeft + ' ' +legendMinValue}
        if(viz.legendLabelRight !== null && viz.legendLabelRight !== undefined){legend.max = viz.legendLabelRight + ' ' + legendMaxValue}
        if(viz.legendLabelLeftAfter !== null && viz.legendLabelLeftAfter !== undefined){legend.min =  legendMinValue + ' '+viz.legendLabelLeftAfter }
        if(viz.legendLabelRightAfter !== null && viz.legendLabelRightAfter !== undefined){legend.max = legendMaxValue + ' '+ viz.legendLabelRightAfter }
        if(legend.min ==null){legend.min = 'min'};
        if(legend.max ==null){legend.max = 'max'};
   
      if(fontColor != null){legend.fontColor = "color:#" +fontColor + ";" }
          else{legend.fontColor    = "color:#DDD;"}
       addColorRampLegendEntry(legendDivID,legend)
    }

    else if(viz != null   &&  ((viz.classLegendDict !== undefined  &&  viz.classLegendDict !== null) || viz.addToClassLegend === true)){
      addLegendContainer(legendDivID,'legend-'+whichLayerList,false,helpBox)
      var classLegendContainerID = legendDivID + '-class-container';
      var legendClassContainerName;
      if(viz.legendTitle !== null && viz.legendTitle !== undefined){
         
          legendClassContainerName = viz.legendTitle
        }else{
          legendClassContainerName = name;
        }
      addClassLegendContainer(classLegendContainerID,legendDivID,legendClassContainerName)
      if(viz.layerType !== 'geeVector' && viz.layerType !== 'geoJSONVector' && viz.layerType !== 'geeVectorImage'){
        var legendKeys = Object.keys(viz.classLegendDict);//.reverse();
        legendKeys.map(function(lk){

          var legend = {};//document.createElement("ee-class-legend");
          legend.name = name;
          
          legend.helpBoxMessage = helpBox;


          legend.classColor = viz.classLegendDict[lk];
          legend.classStrokeColor = '999';
          legend.classStrokeWeight = 1;
          legend.className = lk;
          addClassLegendEntry(classLegendContainerID,legend)
        })
      }else{
        var legend = {};
        legend.name = name;
        legend.helpBoxMessage = helpBox;
        var strokeColor = viz.strokeColor.slice(1);
        var fillColor = viz.fillColor.slice(1);

        if(strokeColor.length === 3){strokeColor =  strokeColor.split('').map(function(i){return i+i}).join().replaceAll(',','')}
        if(fillColor.length === 3){fillColor =  fillColor.split('').map(function(i){return i+i}).join().replaceAll(',','')}
        
        legend.classColor =  fillColor + Math.floor(viz.fillOpacity/2 * 255).toString(16);
        legend.classStrokeColor = strokeColor+ Math.floor(viz.strokeOpacity * 255).toString(16);
        legend.classStrokeWeight = viz.strokeWeight+1;
        legend.className = '';
   
        addClassLegendEntry(classLegendContainerID,legend)
      }

      

      var title = {};
      title.name = name;
      title.helpBoxMessage = helpBox;
    }

   
    layer.visible = visible;
    layer.item = item;
    layer.name = name;
    layer.viz = viz;
    layer.whichLayerList = whichLayerList;
    layer.layerId = layerCount;
    layer.currentGEERunID = currentGEERunID;
    //Add the layer
    
    addLayer(layer);
    layerCount ++;
    
       
}

//////////////////////////////////////////////////////
//Wrapper for bringing in a tile map service
function standardTileURLFunction(url,xThenY,fileExtension,token){
              if(xThenY === null || xThenY === undefined  ){xThenY  = false;};
              if(token === null || token === undefined  ){token  = '';}
              else{token = '?token='+token};
              if(fileExtension === null || fileExtension === undefined  ){fileExtension  = '.png';}
              
              return function(coord, zoom) {
                    
                    // "Wrap" x (logitude) at 180th meridian properly
                    // NB: Don't touch coord.x because coord param is by reference, and changing its x property breakes something in Google's lib 
                    var tilesPerGlobe = 1 << zoom;
                    var x = coord.x % tilesPerGlobe;
                    console.log(coord,zoom,x)
                    if (x < 0) {
                        x = tilesPerGlobe+x;
                    }
                    // Wrap y (latitude) in a like manner if you want to enable vertical infinite scroll
                    // return "https://api.mapbox.com/styles/v1/mapbox/satellite-v9/tiles/256/" + zoom + "/" + x + "/" + coord.y + "?access_token=pk.eyJ1IjoiaWhvdXNtYW4iLCJhIjoiY2ltcXQ0cnljMDBwNHZsbTQwYXRtb3FhYiJ9.Sql6G9QR_TQ-OaT5wT6f5Q"
                    if(xThenY ){
                        return url+ zoom + "/" + x + "/" + coord.y +fileExtension+token;
                    }
                    else{return url+ zoom + "/" + coord.y + "/" +x  +fileExtension+token;}//+ (new Date()).getTime();
                    
                }
            }
function superSimpleTileURLFunction(url){return function(coord, zoom) {return url + zoom+'/' + coord.y+'/'+coord.x}}
/////////////////////////////////////////////////////
//Function to add ee object ot map
function addRESTToMap(tileURLFunction,name,visible,maxZoom,helpBox,whichLayerList){
  var viz = {};var item = ee.Image();
  if(whichLayerList === null || whichLayerList === undefined){whichLayerList = "layer-list"}
    // print(item.getInfo().type)
    // if(item.getInfo().type === 'ImageCollection'){print('It is a collection')}
    if(name === null || name === undefined){
        name = "Layer "+NEXT_LAYER_ID;
        
    }

    if(visible === null || visible === undefined){
        visible = true;
    }
    if(maxZoom === null || maxZoom === undefined){
        maxZoom = 18;
    }
    if(helpBox == null){helpBox = ''};
    var layer = document.createElement("REST-layer");
    layer.tileURLFunction = tileURLFunction;
    layer.ID = NEXT_LAYER_ID;
    NEXT_LAYER_ID += 1;
    layer.layerChildID = layerChildID;
    layerChildID++
    layer.name = name ;
    layer.map = map;
    layer.helpBoxMessage = helpBox;
    layer.visible = visible;
    // layer.label = label;
    // layer.fontColor = fontColor;
    layer.helpBox = helpBox;
      layer.maxZoom = maxZoom;
   
    layer.visible = visible;
    layer.item = item;
    layer.name = name;
    
    var layerList = document.querySelector(whichLayerList);
    
    
    layerList.insertBefore(layer,layerList.firstChild);
    layerCount ++;
    item.getMap(viz,function(eeLayer){
        layer.setLayer(eeLayer);
    });
}
//////////////////////////////////////////////////////
//Function to convert xy space in the dom to the map
function point2LatLng(x,y) {
  var out;
  try{
    var m = document.getElementById('map');
    x = x- m.offsetLeft;
    y = y-m.offsetTop;
    // console.log('converting div to lat lng');console.log(x.toString() + ' ' + y.toString());
    var topRight = map.getProjection().fromLatLngToPoint(map.getBounds().getNorthEast());
    var bottomLeft = map.getProjection().fromLatLngToPoint(map.getBounds().getSouthWest());
    var scale = Math.pow(2, map.getZoom());
    var worldPoint = new google.maps.Point(x / scale + bottomLeft.x, y / scale + topRight.y);
    out = map.getProjection().fromPointToLatLng(worldPoint);
    
  }catch(err){
    out = null;
  }
  
  return out;
}
//////////////////////////////////////////////////////
//Wrapper function to get a dynamic map service
function getGroundOverlay(baseUrl,minZoom,ending){
  if(map.getZoom()>=minZoom){
  if(ending === undefined || ending === null){ending = ''};
  var mapHeight = $('#map').height();
  var mapWidth = $('#map').width();

   var bounds = map.getBounds();
  var keys = Object.keys(bounds);
  var keysX = Object.keys(bounds[keys[0]]);
  var keysY = Object.keys(bounds[keys[1]]);
  
  eeBoundsPoly = ee.Geometry.Rectangle([bounds[keys[1]][keysX[0]],bounds[keys[0]][keysY[0]],bounds[keys[1]][keysX[1]],bounds[keys[0]][keysY[1]]]);

  var ulx = bounds[keys[1]][keysX[0]];
  var lrx = bounds[keys[1]][keysX[1]];
  // if(ulx > lrx){ulx = -180;}
  var ulxy = [ulx,bounds[keys[0]][keysY[0]]];
  var lrxy = [lrx,bounds[keys[0]][keysY[1]]];
  // console.log('b');console.log(ulxy);console.log(lrxy);
  var ulxyMercator = llToNAD83(ulxy[0],ulxy[1]);
  var lrxyMercator = llToNAD83(lrxy[0],lrxy[1]);
  
  var url = baseUrl+ulxyMercator.x.toString()+'%2C'+lrxyMercator.y.toString()+'%2C'+lrxyMercator.x.toString()+'%2C'+ulxyMercator.y.toString()+
  '&bboxSR=102100&imageSR=102100&size='+mapWidth.toString()+'%2C'+mapHeight.toString()+'&f=image'+ending

  overlay = new google.maps.GroundOverlay(url,bounds);
  return overlay
}
else{
  url = '../images/blank.png';
  overlay = new google.maps.GroundOverlay(url,map.getBounds())
  return overlay
}
}
//////////////////////////////////////////////////////
/////////////////////////////////////////////////////
//Function to add dynamic object mapping service to map
function addDynamicToMap(baseUrl1,baseUrl2, ending1,ending2,minZoom1,minZoom2,name,visible,helpBox,whichLayerList){
  if(whichLayerList === null || whichLayerList === undefined){whichLayerList = "layer-list"}
    var viz = {};var item = ee.Image();
    if(name === null || name === undefined){
        name = "Layer "+NEXT_LAYER_ID;   
    }
    if(visible === null || visible === undefined){
        visible = true;
    }
    if(helpBox == null){helpBox = ''};
    function groundOverlayWrapper(){
      if(map.getZoom() > minZoom2){
        return getGroundOverlay(baseUrl2,minZoom2,ending1)
      }
      else{
        return getGroundOverlay(baseUrl1,minZoom1,ending2)
      }
      }
    var layer = document.createElement("dynamic-layer");
    
    layer.ID = NEXT_LAYER_ID;
    NEXT_LAYER_ID += 1;
    layer.layerChildID = layerChildID;
    layerChildID++
    layer.name = name ;
    layer.map = map;
    layer.helpBoxMessage = helpBox;
    layer.visible = visible;
    layer.groundOverlayFunction = groundOverlayWrapper;
    layer.helpBox = helpBox;
     
   // layer.baseUrl = baseUrl;
    layer.visible = visible;
    layer.item = item;
    layer.name = name;
    
    var layerList = document.querySelector(whichLayerList);
    
    
    layerList.insertBefore(layer,layerList.firstChild);
    layerCount ++;
    layer.startUp();
   
}
//Function to add a gee feature to the map
function addFeatureToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
  console.log('adding feature: '+name);
  item.evaluate(function(v){
    var layer = new google.maps.Data({fillOpacity: 0,strokeColor:'#F00'});
    layer.addGeoJson(v);
    layer.setMap(map);
    // map.overlayMapTypes.setAt(this.layerId, v);
  })
}
var featureViewObj = {};
function addFeatureView(assetId,visParams,name,visible,maxZoom,helpBox,whichLayerList){
  ee.data.getFeatureViewTilesKey({
          'assetId': assetId,
          'visParams':visParams
        },
  function(tokens){
    console.log(tokens)
    var url = 'https://earthengine.googleapis.com/v1alpha/projects/earthengine-legacy/featureViews/'+tokens.token+'/tiles/'
    
    tileURLFunction =  function(coord, zoom) {return url + zoom+'/' + coord.x+'/'+coord.y}
    addToMap(tileURLFunction,{layerType:'tileMapService'},name,visible)
    
  })

  var legendDivID = name.replaceAll(' ','-')+ '-' +NEXT_LAYER_ID.toString() ;
  legendDivID = legendDivID.replace(/[^A-Za-z0-9]/g, "-");
  // legendDivID = legendDivID.replaceAll('/','-');
  // legendDivID = legendDivID.replaceAll('(','-');
  // legendDivID = legendDivID.replaceAll(')','-');
  // legendDivID = legendDivID.replaceAll('&','-');
  // legendDivID = legendDivID.replaceAll(',','-');
  // legendDivID = legendDivID.replaceAll('.','-');

  NEXT_LAYER_ID++;
  featureViewObj[legendDivID] = {
    name:name,
    assetId:assetId
  }
}
/////////////////////////////////////////////////////////////////////////////////////
//Set up Map2 object
function mp(){
  this.addLayer = function(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
    addToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem);
  };
  this.addSerializedLayer = function(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
    viz.serialized = true;
    addToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem);
  };
  this.addSelectLayer = function(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
    addSelectLayerToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem);
    
  };
  this.addTimeLapse = function(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
    addTimeLapseToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem);
  };
  this.addSerializedTimeLapse = function(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem){
    viz.serialized = true;
    addTimeLapseToMap(item,viz,name,visible,label,fontColor,helpBox,whichLayerList,queryItem);
  };
  this.addREST = function(tileURLFunction,name,visible,maxZoom,helpBox,whichLayerList){
    addRESTToMap(tileURLFunction,name,visible,maxZoom,helpBox,whichLayerList);
  };
  this.addExport = function(eeImage,name,res,resMin,resMax,resStep,Export,vizParams){
    addExport(eeImage,name,res,resMin,resMax,resStep,Export,vizParams);
  };
  this.addPlot = function(nameLngLat){
    addPlot(nameLngLat);
  };
  this.addFeatureView = function(assetId,visParams,name,visible,maxZoom,helpBox,whichLayerList){
    addFeatureView(assetId,visParams,name,visible,maxZoom,helpBox,whichLayerList);
  };
  this.centerObject = function(fc){
    centerObject(fc);
  }
  this.setTitle = function(title){
    $('#title-banner').html(title);
    document.title = title;
  }
  this.turnOnInspector = function(){
    $('#query-label').click();
  }
  this.setQueryCRS = function(newCrs){
    crs = newCrs;
  }
  this.setQueryScale = function(newScale){
    transform=null;
    scale=newScale;
    plotRadius=newScale/2.;
  }
  this.setQueryTransform = function(newTransform){
    scale=null;
    transform=newTransform;
    plotRadius=transform[0]/2.;
  }
  this.setQueryPrecision = function(newChartPrecision = 3,newChartDecimalProportion=0.25){
    chartPrecision = newChartPrecision;
    chartDecimalProportion=newChartDecimalProportion;
  }
  this.setQueryDateFormat = function(newDefaultQueryDateFormat){
    defaultQueryDateFormat = newDefaultQueryDateFormat;
  }
  this.setQueryBoxColor = function(color){
    if(isHexColor(color) && color[0] !== '#'){
      color = '#'+color;
    }

    clickBoundsColor= color;
  } 
  
 
}

var Map2 = new mp();

if(urlParams.addLayer==='false' || urlParams.addLayer ===false){
  Object.keys(Map2).filter(k=>k.indexOf('add')>-1).map(k=>{
    Map2[k]=function(){}
  })
}

////////////////////////////////////////////////////////////////////////
//Some helper functions
function sleep(delay) {
        var start = new Date().getTime();
        while (new Date().getTime() < start + delay);
      }
function stringToBoolean(string){
    switch(string.toLowerCase().trim()){
        case "true": case "yes": case "1": return true;
        case "false": case "no": case "0": case null: return false;
        default: return Boolean(string);
    }
}
////////////////////////////////////////////////////////////////////////
function setGEERunID(){
  geeRunID = new Date().getTime();
}
////////////////////////////////////////////////////////////////////////
//Function to rerun all GEE code
//Clears out current map, exports, and legends and then reruns
function reRun(){
  // $('#summary-spinner').show(); 
  if(staticTemplates.loadingModal[mode]===undefined){
            if(mode==='MTBS'){
              showMessage('',staticTemplates.loadingModal['all']('mtbs-logo.png','Updating'));
            }else if(mode==='STORM' || mode === 'Bloom-Mapper' || mode === 'sequoia-view'){
              showMessage('',staticTemplates.loadingModal['all']('','Updating'));
            }else{
              showMessage('',staticTemplates.loadingModal['all']('lcms-icon.png','Updating'));
            }
              
          }else{
            showMessage('Loading Updated Layers',staticTemplates.loadingModal[mode]);
          }
          
  // showMessage('Loading Updated Layers',staticTemplates.loadingModal);
  // showMessage('Loading',staticTemplates.loadingModal)
  setGEERunID();

  //Clean out current map, legend, etc
  clearSelectedAreas();
  clearUploadedAreas();
  layerChildID = 0;
  geeTileLayersDownloading = 0;
  updateGEETileLayersLoading();

  stopTimeLapse();
  queryObj = {};areaChartCollections = {};pixelChartCollections = {};timeLapseObj = {};dashboardObj={};
  intervalPeriod = 666.6666666;
  timeLapseID = null;
  timeLapseFrame = 0;
  cumulativeMode = false;
  NEXT_LAYER_ID = 1;
  clearSelectedAreas();
  selectedFeaturesGeoJSON = {};
  ['layer-list','reference-layer-list','area-charting-select-layer-list','fhp-div','time-lapse-legend-list'].map(function(l){
    $('#'+l).empty();
    $('#legend-'+l).empty();
  })
  
  $('#export-list').empty();
  
	
  Object.values(featureObj).map(function(f){f.setMap(null)});
  featureObj = {};
  map.overlayMapTypes.getArray().forEach(function(element,index){
                     map.overlayMapTypes.setAt(index,null);   
                });

  refreshNumber   ++;

  exportImageDict = {};
  try{
    clearDownloadDropdown();
  }catch(err){}
  google.maps.event.clearListeners(mapDiv, 'click');
  

  //Rerun the GEE code
  setTimeout(function() { 
    // try{
      run(); 
    // }catch(err){
      // console.log(err);
      // console.log('Failed to load GEE run function. Waiting 5 seconds to retry')
      // setTimeout(()=>run(), 5000);
     
    // }
     
    if(mode !== 'lcms-dashboard'){
      $('.modal').modal('hide');
      $('.modal-backdrop').remove();
    }
    
    setupAreaLayerSelection();
    addLabelOverlay();
    if((urlParams.endYear-urlParams.startYear < 5) && mode === 'LCMS' ){//&&(urlParams.sankey==='true' || urlParams.beta ==='true') ){
      showMessage('No Transition Charting','The year range must be 5 years or more to perform transition charting')
    }
  }, 1500);
	
  
  
  // $('#error-modal').toggleClass('show');
  // $('#summary-spinner').hide(); 

  
}
////////////////////////////////////////////////////////////////////////
// Taken from: https://stackoverflow.com/questions/521295/seeding-the-random-number-generator-in-javascript
function mulberry32(a) {
  return function() {
    var t = a += 0x6D2B79F5;
    t = Math.imul(t ^ t >>> 15, t | 1);
    t ^= t + Math.imul(t ^ t >>> 7, t | 61);
    var out = ((t ^ t >>> 14) >>> 0) / 4294967296;
    return out;
  }
}
var randomN = mulberry32(1);
////////////////////////////
// Function to handle adding a hash before a hex color or add nothing if it's a color name
function isHexColor(color,regexp = /^[0-9a-fA-F]+$/){
  return regexp.test(color);
}
function addColorHash(color){
  if(isHexColor(color)){
    return `#${color}`;
  }else{
    return color;
  }
}
////////////////////////////
function getRandomInt(min, max) {
    return Math.floor(randomN() * (max - min + 1)) + min;
}
function padLeft(nr, n, str){
    return Array(n-String(nr).length+1).join(str||'0')+nr;
}
function rgbToHex(r,g,b) {
  if(typeof(r)=='object'){
    var colors = r;
    r = colors[0];
    g = colors[1];
    b = colors[2];
  }
    return "#"+("00000"+(r<<16|g<<8|b).toString(16)).slice(-6);
}
//Taken from: https://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb
function hexToRgb(hex) {
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result ? {
    r: parseInt(result[1], 16),
    g: parseInt(result[2], 16),
    b: parseInt(result[3], 16)
  } : null;
}
function offsetColor(hex,offset){
  obj = hexToRgb(hex)
  obj.r = (obj.r+offset)%255
  obj.g = (obj.g+offset)%255
  obj.b = (obj.b+offset)%255
  return rgbToHex(obj.r,obj.g,obj.b) 
}
function invertColor(hex) {
    if (hex.indexOf('#') === 0) {
        hex = hex.slice(1);
    }
    // convert 3-digit hex to 6-digits.
    if (hex.length === 3) {
        hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
    }
    if (hex.length !== 6) {
        throw new Error('Invalid HEX color.');
    }
    // invert color components
    var r = (255 - parseInt(hex.slice(0, 2), 16)).toString(16),
        g = (255 - parseInt(hex.slice(2, 4), 16)).toString(16),
        b = (255 - parseInt(hex.slice(4, 6), 16)).toString(16);
    // pad each with zeros and return
    return '#' + padZero(r) + padZero(g) + padZero(b);
}

function padZero(str, len) {
    len = len || 2;
    var zeros = new Array(len).join('0');
    return (zeros + str).slice(-len);
}
function randomColor(mins = [100,100,100],maxes=[200,200,255]){
  var r = getRandomInt(mins[0], maxes[0]);
  var g = getRandomInt(mins[1], maxes[1]);
  var b = getRandomInt(mins[2], maxes[2]);
  var c = rgbToHex(r,g,b)
  return c
}
function getChartColor(){
  var color = chartColors[chartColorI%chartColors.length]
  chartColorI++;
  return color

}
function randomRGBColor(){
  var r = getRandomInt(100, 225);
  var g = getRandomInt(100, 225);
  var b = getRandomInt(100, 225);
  
  return [r,g,b];
}
function randomColors(n){
  var out = [];
  while(n>0){
    out.push(randomColor());
    n = n-1;
  }
  return out
}
//////////////////////////////////
//Taken from: https://sashat.me/2017/01/11/list-of-20-simple-distinct-colors/
var colorList = ['#e6194b', '#3cb44b', '#ffe119', '#4363d8', '#f58231', '#911eb4', '#46f0f0', '#f032e6', '#bcf60c', '#fabebe', '#008080', '#e6beff', '#9a6324', '#fffac8', '#800000', '#aaffc3', '#808000', '#ffd8b1', '#000075', '#808080', '#ffffff', '#000000'];
var colorMod = colorList.length;
function getColor(){
  var currentColor =  colorList[colorMod%colorList.length];
  colorMod++;
  return currentColor
}
//Taken from: https://stackoverflow.com/questions/5560248/programmatically-lighten-or-darken-a-hex-color-or-rgb-and-blend-colors
function LightenDarkenColor(col,amt) {
    var usePound = false;
    if ( col[0] == "#" ) {
        col = col.slice(1);
        usePound = true;
    }
    var num = parseInt(col,16);

    var r = (num >> 16) + amt;

    if ( r > 255 ) r = 255;
    else if  (r < 0) r = 0;

    var b = ((num >> 8) & 0x00FF) + amt;

    if ( b > 255 ) b = 255;
    else if  (b < 0) b = 0;

    var g = (num & 0x0000FF) + amt;

    if ( g > 255 ) g = 255;
    else if  ( g < 0 ) g = 0;

    return (usePound?"#":"") + (g | (b << 8) | (r << 16)).toString(16);
}
/////////////////////////////////////////////////////
//Area measurement
function startArea(){
  if(polyOn === false){
    polyOn = true;
  }
    areaPolygonOptions.polyNumber = polyNumber;
    map.setOptions({draggableCursor:'crosshair'});
    map.setOptions({disableDoubleClickZoom: true });
    // Construct the polygon.
    areaPolygonObj[polyNumber] = new google.maps.Polyline(areaPolygonOptions);
    areaPolygonObj[polyNumber].setMap(map);

    updateArea = function(){
      var unitName;var unitMultiplier;
        var keys = Object.keys(areaPolygonObj);
        // console.log('keys');console.log(keys);
        var totalArea = 0;
        var totalWithArea = 0;
        var outString = '';
        function areaWrapper(key){
          // console.log('key');console.log(key);
        // print('Adding in: '+key.toString());
        var pathT = areaPolygonObj[key].getPath().getArray();

        if(pathT.length > 0){

          clickCoords =clickLngLat;//pathT[pathT.length-1];
           console.log(clickCoords)
           console.log(pathT)
          // console.log(clickCoords);console.log(pathT.length);
          area = google.maps.geometry.spherical.computeArea(areaPolygonObj[key].getPath());
          
          var unitNames = unitNameDict[metricOrImperialArea].area;
          var unitMultipliers = unitMultiplierDict[metricOrImperialArea].area;
          if(area>0){
            totalWithArea++;
          }
          totalArea = totalArea + area

          if(totalArea >= 1000){
            unitName = unitNames[1];
            unitMultiplier = unitMultipliers[1];
          }
          else{
            unitName = unitNames[0];
            unitMultiplier = unitMultipliers[0];
            }
          console.log(unitNames);
          console.log(unitMultipliers);
          console.log(area);
          console.log(totalArea);
          console.log(unitName);
          console.log(unitMultiplier)
        }
      }
      keys.map(areaWrapper)
      var pixelProp = totalArea/9;

      totalArea = totalArea*unitMultiplier;
        totalArea = totalArea.formatNumber();
        var polyString = 'polygon';
        if(keys.length>1){
          polyString = 'polygons';
        }
        var areaContent = totalWithArea.toString()+' '+polyString+' <br>'+totalArea +' '+unitName ;
        if(mode === 'Ancillary'){areaContent += '<br>'+pixelProp.formatNumber() + ' % pixel'}
        infowindow.setContent(areaContent);
        infowindow.setPosition(clickCoords);
        
        infowindow.open(map);
        $('.gm-ui-hover-effect').hide();         
    }

  startListening();
}
function setToPolygon(id){
        if(id == undefined || id == null){id = polyNumber};
        console.log('Setting '+id.toString()+' to polygon');
        areaPolygonOptions.strokeColor = areaPolygonObj[id].strokeColor;
        var path = areaPolygonObj[id].getPath();
        areaPolygonObj[id].setMap(null);
        areaPolygonObj[id] = new google.maps.Polygon(areaPolygonOptions);
        areaPolygonObj[id].setPath(path);
        areaPolygonObj[id].setMap(map);
}
function setToPolyline(id){
        if(id == undefined || id == null){id = polyNumber};
        areaPolygonOptions.strokeColor = areaPolygonObj[id].strokeColor;
        var path = areaPolygonObj[polyNumber].getPath();
        areaPolygonObj[id].setMap(null);
        areaPolygonObj[id] = new google.maps.Polyline(areaPolygonOptions);
        areaPolygonObj[id].setPath(path);
        areaPolygonObj[id].setMap(map);
}

//Start listening for area measuring
function startListening(){
    mapHammer = new Hammer(document.getElementById('map'));

    mapHammer.on("tap", function(event) {
        

        var path = areaPolygonObj[polyNumber].getPath();
        var x =event.center.x;
        var y = event.center.y;
        clickLngLat =point2LatLng(x,y);
        path.push(clickLngLat);
        updateArea();
    
    });
    mapHammer.on("doubletap",function(){
        setToPolygon()
        resetPolygon();
    });

    google.maps.event.addListener(areaPolygonObj[polyNumber], "click", updateArea);
    google.maps.event.addListener(areaPolygonObj[polyNumber], "mouseup", updateArea);
    google.maps.event.addListener(areaPolygonObj[polyNumber], "dragend", updateArea);
    google.maps.event.addListener(areaPolygonObj[polyNumber].getPath(), 'set_at',  updateArea);

    window.addEventListener("keydown", resetPolys);
    window.addEventListener("keydown", deleteLastAreaVertex);

}
//Clear and restart area measuring
function resetPolys(e){
    if( e === undefined || e.key === 'Delete'|| e.key === 'd'|| e.key === 'Backspace' ){
        stopArea();
        startArea();
      }
    }
//Undo last vertex
function undoAreaMeasuring(){
  if(areaPolygonObj[polyNumber].getPath().length >0){
          areaPolygonObj[polyNumber].getPath().pop(1);
          updateArea();
        }
  else if(polyNumber > 1){
          stopListening();
          polyNumber = polyNumber -1;
          setToPolyline()
          startListening();
        }
}
function undoDistanceMeasuring(){
  distancePolyline.getPath().pop(1);
  updateDistance();
}
function deleteLastAreaVertex(e){
      // console.log(e);
      if(e.key == 'z' && e.ctrlKey){
        undoAreaMeasuring();
      }
    }
function deleteLastDistanceVertex(e){
      // console.log(e);
      if(e.key == 'z' && e.ctrlKey){
        undoDistanceMeasuring();
      }
    }
function activatePoly(poly){
  console.log(poly.polyNumber)
}
function stopListening(){
    try{
    mapHammer.destroy();
    google.maps.event.clearListeners(areaPolygonObj[polyNumber], 'dblclick');
    google.maps.event.clearListeners(areaPolygonObj[polyNumber], 'click');
    google.maps.event.clearListeners(mapDiv, 'click');
    google.maps.event.clearListeners(areaPolygonObj[polyNumber], 'mouseup');
    google.maps.event.clearListeners(areaPolygonObj[polyNumber], 'dragend');
    window.removeEventListener('keydown',resetPolys);
    window.removeEventListener('keydown',deleteLastAreaVertex);
    }catch(err){}
}
function clearPoly(id){

  areaPolygonObj[id].setMap(null);
  areaPolygonObj[id].setPath([]);
  updateArea();
  google.maps.event.clearListeners(areaPolygonObj[id], 'click');
}
function clearPolys(){
  stopListening();
  var keys = Object.keys(areaPolygonObj);
  keys.map(function(k){areaPolygonObj[k].setMap(null);})
  areaPolygonObj = {};
  polyNumber = 1;
  polyOn = false;

}
function stopArea(){
  try{
    mapHammer.destroy();
  }catch(err){}
  map.setOptions({disableDoubleClickZoom: true });
  
  clearPolys();
  infowindow.setMap(null);
  map.setOptions({draggableCursor:'hand'});
}

function resetPolygon(){
    stopListening();
    var keys = Object.keys(areaPolygonObj);
    var lastKey = keys[keys.length-1];
    console.log('last key '+lastKey.toString());
    polyNumber = parseInt(lastKey);
    polyNumber++;
    startArea();
    // console.log(areaPolygonObj)
}
function newPolygon(){
  stopArea();

}
///////////////////////////////////////////////////////////////////////////////////
//Distance measuring functions
function startDistance(){
  map.setOptions({draggableCursor:'crosshair'});
    try{
      distancePolyline.destroy();
    }catch(err){};
    
    distancePolyline = new google.maps.Polyline(distancePolylineOptions);
    distancePolyline.setMap(map);
    map.setOptions({disableDoubleClickZoom: true });

    google.maps.event.addListener(distancePolyline, "click", updateDistance);
    mapHammer = new Hammer(document.getElementById('map'));
    mapHammer.on("doubletap", resetPolyline);
    mapHammer.on("tap", function(event) {
        var x =event.center.x;
        var y = event.center.y;
        var path = distancePolyline.getPath();
        clickLngLat =point2LatLng(x,y)
        path.push(clickLngLat);
        updateDistance();
    });
    google.maps.event.addListener(distancePolyline, "mouseup", updateDistance);
    google.maps.event.addListener(distancePolyline, "dragend", updateDistance);
    google.maps.event.addListener(distancePolyline.getPath(), 'set_at',  updateDistance);
    window.addEventListener('keydown',deleteLastDistanceVertex);
    window.addEventListener('keydown',resetPolyline);
    }

function stopDistance(){
  try{
    window.removeEventListener('keydown',deleteLastDistanceVertex);
    window.removeEventListener('keydown',resetPolyline);
    mapHammer.destroy();
    map.setOptions({disableDoubleClickZoom: true });
    google.maps.event.clearListeners(distancePolyline, 'click');
    google.maps.event.clearListeners(mapDiv, 'click');
    google.maps.event.clearListeners(distancePolyline, 'mouseup');
    google.maps.event.clearListeners(distancePolyline, 'dragend');
    if(infowindow != undefined){infowindow.setMap(null);}
    distancePolyline.setMap(null);
    map.setOptions({draggableCursor:'hand'});
    infowindow.setMap(null);
  }catch(err){}  
}
function resetPolyline(e){
  if(e === undefined || e.key === undefined ||  e.key == 'Delete'|| e.key == 'd'|| e.key == 'Backspace'){
    stopDistance();startDistance();
  }    
}
updateDistance = function(){
  distance = google.maps.geometry.spherical.computeLength(distancePolyline.getPath());
  var pathT = distancePolyline.getPath().j;
  clickCoords = clickLngLat;//pathT[pathT.length-1];
  var unitNames = unitNameDict[metricOrImperialDistance].distance;
  var unitMultipliers = unitMultiplierDict[metricOrImperialDistance].distance;
  if(distance >= 1000){
    var unitName = unitNames[1];
    var unitMultiplier = unitMultipliers[1];
  }
  else{
    var unitName = unitNames[0];
    var unitMultiplier = unitMultipliers[0];
    }
  distance = distance*unitMultiplier
  if(distance >= 0){
   
        var distanceContent = distance.formatNumber() + ' ' + unitName 
        infowindow.setContent(distanceContent);
        infowindow.setPosition(clickCoords);

        infowindow.open(map);
        $('.gm-ui-hover-effect').hide();
  }
}
// function getDistance(lat1,lon1,lat2,lon2){
//     var R = 6371e3; // metres
//     var phi1 = lat1* Math.PI / 180;
//     var phi2 = lat2* Math.PI / 180;
//     var deltaPhi = (lat2-lat1)* Math.PI / 180;
//     var deltaLambda = (lon2-lon1)* Math.PI / 180;

//     var a = Math.sin(deltaPhi/2) * Math.sin(deltaPhi/2) +
//             Math.cos(phi1) * Math.cos(phi2) *
//             Math.sin(deltaLambda/2) * Math.sin(deltaLambda/2);
//     var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
//     var d = R * c;
//     return d
// }


// function addFusionTable1(id){
// var layer1 = new google.maps.FusionTablesLayer({
//           query: {
//             select: 'geometry',
//             from: id
//           },
//           styles: [{
//       polygonOptions: {
//         // fillColor: '#00FF00',
//         fillOpacity: 0.0000000000001,
//         strokeColor:'#FF0000',
//         strokeWeight : 2
//       }
//     }]
//     // map:map
//         });
//     layer1.setMap(map);
//     }
// function addFusionTable2(id){
// var layer2 = new google.maps.FusionTablesLayer({
//           query: {
//             select: 'geometry',
//             from: id
//           },
//           styles: [{
//       polygonOptions: {
//         // fillColor: '#00FF00',
//         fillOpacity: 0.0000000000001,
//         strokeColor:'#FF0000',
//         strokeWeight : 2
//       }
//     }]
//         });
// layer2.setMap(map);
    
//     }
////////////////////////////////////////////////////////////////
//Setup drag box selection object
function addDragBox(){
  const dragBox = {}
  dragBox.polygon = new google.maps.Polygon({
    strokeColor:'#FF0',
    fillColor:'#0FF',
    fillOpacity:0.0,
    strokeOpacity: 1,
    strokeWeight: 1.5,
    zIndex:999
    
  });
  dragBox.setColor = function(color){
    dragBox.polygon.setOptions({
      strokeColor:color
    });
  }
  dragBox.onStartFunctions = [];
  dragBox.onStopFunctions = [];
  dragBox.addOnStartFunction = function(fun){dragBox.onStartFunctions.push(fun)}
  dragBox.addOnStopFunction = function(fun){dragBox.onStopFunctions.push(fun)}
  dragBox.listeners={'click':[],'mousemove':[]};
  dragBox.dragBoxPath = [];
  dragBox.clickI=0;
  dragBox.startDragBoxLocation,dragBox.currentDragLocation;
  dragBox.stop = function(e){
    dragBox.listeners.mousemove.map(e=>google.maps.event.removeListener(e));
    dragBox.listeners.mousemove = [];
    if(dragBox.polygon.getPath().getArray().length===0){
      dragBox.start();
    }else{
      dragBox.onStopFunctions.map(fun=>fun())
    }
    
    
    // dragBox.polygon.setMap(null);
  }
  dragBox.expand = function(e){
      dragBox.currentDragLocation = {lng:e.latLng.lng(),lat:e.latLng.lat()};
      let second = {lng:dragBox.startDragBoxLocation.lng,lat:dragBox.currentDragLocation.lat};
      let fourth = {lat:dragBox.startDragBoxLocation.lat,lng:dragBox.currentDragLocation.lng};
      dragBox.dragBoxPath = [dragBox.startDragBoxLocation,second,dragBox.currentDragLocation,fourth];
      dragBox.polygon.setPath(dragBox.dragBoxPath);
  }
  dragBox.start = function(e){
    dragBox.onStartFunctions.map(fun=>fun());
    dragBox.polygon.setMap(null);
    dragBox.startDragBoxLocation = {lng:e.latLng.lng(),lat:e.latLng.lat()};
    dragBox.polygon.setPath([dragBox.startDragBoxLocation,dragBox.startDragBoxLocation,dragBox.startDragBoxLocation]);
    dragBox.polygon.setMap(map);

    Object.keys(dragBox.listenTo).map(k=>{
      dragBox.listeners.mousemove.push(google.maps.event.addListener(dragBox.listenTo[k], "mousemove", dragBox.expand));
    });
    
  }
  dragBox.click = function(e){
    if(mode !== 'lcms-dashboard' || dashboardAreaSelectionMode==='Drag-Box'){
      if(dragBox.clickI%2===0){
        dragBox.start(e);
      }else{
        dragBox.stop(e);
      }
      dragBox.clickI++
    }
    
  }
  dragBox.listenTo={'box':dragBox.polygon}
  dragBox.addListenTo = function(obj,nm){
    dragBox.listenTo[nm]=obj;
  }
  dragBox.startListening=function(){
    
    Object.keys(dragBox.listenTo).map(k=>{
      dragBox.listeners.click.push(google.maps.event.addListener(dragBox.listenTo[k], "click", dragBox.click));
    });
  }
  dragBox.stopListening=function(hide=true){
    if(hide){
      dragBox.polygon.setMap(null);
    }
    
    dragBox.listeners.click.map(e=>google.maps.event.removeListener(e));
    dragBox.listeners.mousemove.map(e=>google.maps.event.removeListener(e));
    dragBox.listeners={'click':[],'mousemove':[]};
  }
  return dragBox;
}

////////////////////////////////////////////////////////////////
//Setup study areas and run functions
function dropdownUpdateStudyArea(whichOne){
  $('#summary-spinner').show();
  resetStudyArea(whichOne);
  var coords = studyAreaDict[whichOne].center;
  centerMap(coords[1],coords[0],coords[2]);
    if(mode === 'Ancillary'){
      run = runAncillary;
    } else if( mode === 'LT'){
      run  = runLT;
    }else if( mode === 'LCMS'|| (mode === 'LCMS-pilot' && studyAreaDict[longStudyAreaName].isPilot == false)){
      run  = runGTAC;
      run = function(){}
    }else if( mode === 'LCMS-pilot'){
      run  = runUSFS;
    }else if( mode === 'STORM'){
      run  = runStorm;
    }else if( mode === 'LAMDA'){
      run  = runLAMDA;
    }else if( mode === 'TreeMap'){
      run  = runTreeMap;
    }else if(mode === 'lcms-base-learner'){
      run = runBaseLearner
    }else if(mode === 'sequoia-view'){
      run = runSequoia;
    }else if(studyAreaName === 'CONUS'){
      run = runCONUS
    }else{run = runUSFS};

    reRun();
};
//Function to set study area
var resetStudyArea = function(whichOne){
    localStorage.setItem("cachedStudyAreaName",whichOne);
    urlParams.studyAreaName = whichOne;
    $('#studyAreaDropdown').val(whichOne);
    $('#study-area-label').text(whichOne);
    console.log('changing study area');
    console.log(whichOne);
    lowerThresholdDecline =  studyAreaDict[whichOne].lossThresh;
    if(studyAreaDict[whichOne].lossSlowThresh !== undefined  && studyAreaDict[whichOne].lossSlowThresh !== null){
      lowerThresholdSlowLoss = studyAreaDict[whichOne].lossSlowThresh;
    }else{
      lowerThresholdSlowLoss = lowerThresholdDecline;
    }
    if(studyAreaDict[whichOne].lossFastThresh !== undefined  && studyAreaDict[whichOne].lossFastThresh !== null){
      lowerThresholdFastLoss = studyAreaDict[whichOne].lossFastThresh;
    }else{
      lowerThresholdFastLoss = lowerThresholdDecline;
    }
   
    upperThresholdDecline = 1;
    upperThresholdSlowLoss = 1;
    upperThresholdFastLoss = 1;
    lowerThresholdRecovery = studyAreaDict[whichOne].gainThresh;
    upperThresholdRecovery = 1;
    
    startYear = studyAreaDict[whichOne].startYear;
    endYear = studyAreaDict[whichOne].endYear;
   
    setUpRangeSlider('lowerThresholdDecline',0,1,lowerThresholdDecline,0.05,'decline-threshold-slider','null');
    setUpRangeSlider('lowerThresholdRecovery',0,1,lowerThresholdRecovery,0.05,'recovery-threshold-slider','null');
    
    setUpRangeSlider('lowerThresholdSlowLoss',0,1,lowerThresholdSlowLoss,0.05,'slow-loss-threshold-slider','null');
    setUpRangeSlider('lowerThresholdFastLoss',0,1,lowerThresholdFastLoss,0.05,'fast-loss-threshold-slider','null');
    
    setUpDualRangeSlider('urlParams.startYear','urlParams.endYear',minYear,maxYear,urlParams.startYear,urlParams.endYear,1,'analysis-year-slider','analysis-year-slider-update','null')

    var coords = studyAreaDict[whichOne].center;
    studyAreaName = studyAreaDict[whichOne].name;
    if(studyAreaName === 'CONUS'){run = runCONUS;}
    else if( mode === 'LCMS'|| (mode === 'LCMS-pilot' && studyAreaDict[longStudyAreaName].isPilot == false)){
      run = runGTAC;
    }
    else{run = runUSFS;};
    if(studyAreaDict[whichOne].addFastSlow){
      $('#fast-slow-threshold-container').show();
    }else{$('#fast-slow-threshold-container').hide();}
    if(studyAreaDict[whichOne].addGainThresh){
      $('#recovery-threshold-slider-container').show();
    }else{$('#recovery-threshold-slider-container').hide();}
    $('#export-crs').val(studyAreaDict[whichOne].crs)
}
///////////////////////////////////////////////////////////
//Taken from https://developers.google.com/maps/documentation/javascript/examples/places-searchbox
function initSearchBox() {
  // Create the search box and link it to the UI element.
  var input = document.getElementById('pac-input');
  var searchBox = new google.maps.places.SearchBox(input);
  // map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

  // Bias the SearchBox results towards current map's viewport.
  map.addListener('bounds_changed', function() {
    searchBox.setBounds(map.getBounds());
  });

  var markers = [];
  // Listen for the event fired when the user selects a prediction and retrieve
  // more details for that place.
  searchBox.addListener('places_changed', function() {
    var places = searchBox.getPlaces();

    if (places.length == 0) {
      return;
    }

    // Clear out the old markers.
    markers.forEach(function(marker) {
      marker.setMap(null);
    });
    markers = [];

    // For each place, get the icon, name and location.
    var bounds = new google.maps.LatLngBounds();
    var formattedAddresses = [];
    places.forEach(function(place) {
      if (!place.geometry) {
        console.log("Returned place contains no geometry");
        return;
      }
      formattedAddresses.push(place.formatted_address);
      var icon = {
        url: place.icon,
        size: new google.maps.Size(71, 71),
        origin: new google.maps.Point(0, 0),
        anchor: new google.maps.Point(17, 34),
        scaledSize: new google.maps.Size(25, 25)
      };

      // Create a marker for each place.
      markers.push(new google.maps.Marker({
        map: map,
        icon: icon,
        title: place.name,
        position: place.geometry.location
      }));

      if (place.geometry.viewport) {
        // Only geocodes have viewport.
        bounds.union(place.geometry.viewport);
      } else {
        bounds.extend(place.geometry.location);
      }
    });
    var boundsBounds = {
      south : [-85,85],
      west : [-179,179],
      north : [-85,85],
      east : [-179,179]
    }
    
    bounds = bounds.toJSON();
 
    Object.keys(bounds).map(function(key){
      var coord = bounds[key];
      var min =  boundsBounds[key][0];
      var max = boundsBounds[key][1];
      if(coord < min){bounds[key] = min;showMessage('Search coords tip!','Search coords format is lat lng (e.g. 45 -111)')}
      if(coord > max){bounds[key] = max;showMessage('Search coords tip!','Search coords format is lat lng (e.g. 45 -111)')}

    });
    console.log(bounds)
    console.log(formattedAddresses.join(','))
    ga('send', 'event', 'places-search', JSON.stringify(bounds), formattedAddresses.join(','));
    map.fitBounds(bounds);
  });
  }
/////////////////////////////////////////////////////////////////
//Set up info window
var infoWindowXOffset = 30;
function getInfoWindow(xOffset,yOffset){
  if(xOffset == null || xOffset === undefined){xOffset = 30};
  if(yOffset == null || yOffset === undefined){yOffset = -30};
  return new google.maps.InfoWindow({
    content : '',
    maxWidth: 300,
    pixelOffset: new google.maps.Size(xOffset,yOffset,'rem','rem'),
    close:false
  });
} 
//Functions for tracking views and going forward and backward map views
function trackView(){
  if(updateViewList){
    viewList = viewList.slice(0,viewIndex)
    viewList.push({lng:urlParams.lng, lat:urlParams.lat,zoom:urlParams.zoom});
    viewIndex = viewList.length;
    checkViewIndex();
  }
}
//See if there are any remaining views
function checkViewIndex(){
  if(viewIndex <= 1){
    viewIndex = 1
    $('#back-view-button').prop('disabled',true);
  }else{$('#back-view-button').prop('disabled',false)};

  if(viewIndex >= viewList.length){
    viewIndex = viewList.length;
    $('#forward-view-button').prop('disabled',true);
  }else{$('#forward-view-button').prop('disabled',false)};
}
function setView(view){
    updateViewList = false;
    map.setCenter(view);
    map.setZoom(view.zoom);
  }
  function backView(){
    viewIndex--;
    checkViewIndex();
    setView(viewList[viewIndex-1]);
    
  }
  function forwardView(){
    viewIndex++;
    checkViewIndex();
    setView(viewList[viewIndex-1]);
    
  } 
////////////////////////////////////////////////////////////////
// Create an overlay to display map labels only
var labelOverlayAdded = false;
function addLabelOverlay(){
  map.overlayMapTypes.setAt(Object.keys(layerObj).length, labelsMapType);
  labelOverlayAdded = true;
}
function removeLabelOverlay(){
  map.overlayMapTypes.setAt(Object.keys(layerObj).length,null);
  labelOverlayAdded = false;
}
function toggleLabelOverlay(){
  if(labelOverlayAdded){
    removeLabelOverlay()
  }else{addLabelOverlay()}
}
var labelsMapType;
var geeAuthenticated = false;
//Initialize map
function initialize() {
  labelsMapType = new google.maps.StyledMapType([
  {
    "elementType": "geometry.fill",
    "stylers": [
      {
        "visibility": "off"
      }
    ]
  },
  {
    "elementType": "geometry.stroke",
    "stylers": [
      {
        "weight": 0.01
      }
    ]
  }
]);

 
  var mapTypeIds = ['roadmap', 'satellite', 'hybrid', 'terrain'];
  if(urlParams.mapTypeId  === undefined || urlParams.mapTypeId  === null &&urlParams.mapTypeId.indexOf(urlParams.mapTypeIds)  === -1 ){
    urlParams.mapTypeId = 'hybrid'
  }
  //Set up map options
  var mapOptions = {
    center: null,
    zoom: null,
    minZoom: 2,
     disableDefaultUI: false,
    disableDoubleClickZoom: true,
    // maxZoom: 15,
    mapTypeId:urlParams.mapTypeId,
    streetViewControl: true,
    fullscreenControl: false,
    mapTypeControlOptions :{position: google.maps.ControlPosition.TOP_RIGHT,
      mapTypeIds: mapTypeIds},
    // fullscreenControlOptions:{position: google.maps.ControlPosition.RIGHT_TOP},
    streetViewControlOptions:{position: google.maps.ControlPosition.RIGHT_TOP},
    scaleControlOptions:{position: google.maps.ControlPosition.RIGHT_TOP},
    zoomControlOptions:{position: google.maps.ControlPosition.RIGHT_TOP},
    tilt:0,
    controlSize: 20,
    scaleControl: true,
    clickableIcons:false,
    cursor:'pointer'
  };

  var center = new google.maps.LatLng(initialCenter[0],initialCenter[1]);
  var zoom = initialZoomLevel;//8;

  var settings = null;


  //Set up caching of study area
  if(typeof(Storage) !== "undefined"){
    cachedStudyAreaName = localStorage.getItem("cachedStudyAreaName");
    // console.log(urlParams.studyAreaName)

    if(urlParams.studyAreaName !== null && urlParams.studyAreaName !== undefined){
      cachedStudyAreaName = decodeURIComponent(urlParams.studyAreaName);
    }else if(cachedStudyAreaName === null || cachedStudyAreaName === undefined){
      cachedStudyAreaName = defaultStudyArea;
    }
    studyAreaName = studyAreaDict[cachedStudyAreaName].name;
    longStudyAreaName = cachedStudyAreaName;
   
    $('#study-area-label').text(longStudyAreaName);
    $('#study-area-label').fitText(1.8);
    
    if(studyAreaSpecificPage == true){
      cachedSettingskey =  studyAreaName +"-settings"; 
    }
    settings = JSON.parse(localStorage.getItem(cachedSettingskey));
    layerObj =  null;
  }

  if(settings != null && settings.center != null && settings.zoom != null){
    center = settings.center;
    zoom  = settings.zoom;
  }
  if(layerObj === null){
    layerObj = {};
  }

  if(urlParams.lng !== undefined && urlParams.lng !== null && urlParams.lat !== undefined && urlParams.lat !== null ){
    print('Setting center from URL')
    mapOptions.center = {lng:parseFloat(urlParams.lng),lat:parseFloat(urlParams.lat)};
  }else{
    mapOptions.center = center;


  }
  if(urlParams.zoom !== undefined && urlParams.zoom !== null ){
    print('Setting zoom from URL')
    mapOptions.zoom = parseInt(urlParams.zoom);
  }else{
    mapOptions.zoom = zoom;
  }
  urlParams.lng =  mapOptions.center.lng;urlParams.lat = mapOptions.center.lat;urlParams.zoom= mapOptions.zoom;
  // trackView()  
  map = new google.maps.Map(document.getElementById("map"),mapOptions);

  
  
  //Associate the styled map with the MapTypeId and set it to display.
  // map.mapTypes.set('dark_mode', styledMapType);
  // const drawingManager = new google.maps.drawing.DrawingManager({
  //   drawingMode: google.maps.drawing.OverlayType.MARKER,
  //   drawingControl: true,
  //   drawingControlOptions: {
  //     position: google.maps.ControlPosition.TOP_CENTER,
  //     drawingModes: [
   
  //       google.maps.drawing.OverlayType.RECTANGLE,
  //       google.maps.drawing.OverlayType.POLYGON,
        
  //     ],
  //   },
    
    
  // });
  // drawingManager.setMap(map);
 //  $("#rectangle-drawing-btn").click( function(){
 //      drawingManager.setDrawingMode(google.maps.drawing.OverlayType.RECTANGLE);
 // });

 //  $("#polygon-drawing-btn")square-drawing-btn.click( function(){
 //        drawingManager.setDrawingMode(google.maps.drawing.OverlayType.POLYGON);
 //   });
  //Listen for street view use
  //Adapted from: https://stackoverflow.com/questions/7251738/detecting-google-maps-streetview-mode
  var thePanorama = map.getStreetView();
  google.maps.event.addListener(thePanorama, 'visible_changed', function() {

      if (thePanorama.getVisible()) {
        console.log('street view in use')
        $('#sidebar-left-container').hide();
        $('.sidebar-toggler').hide();
        $('#legendDiv').hide();
        $('#bottombar').hide();
        $('#dashboard-results-container').hide();
        $('#dashboard-highlights-container').hide();
          // Display your street view visible UI

      } else {
        console.log('street view not in use')
        $('#sidebar-left-container').show();
        $('.sidebar-toggler').show();
        $('#legendDiv').show();
        $('#bottombar').show();
        $('#dashboard-results-container').show();
        $('#dashboard-highlights-container').show();
          // Display your original UI

      }

  });
  marker=new google.maps.Circle({
    center:{lat:45,lng:-111},
    radius:5
  });
  
  infowindow = getInfoWindow();

  queryGeoJSON = new google.maps.Data();
  queryGeoJSON.setMap(map);
  queryGeoJSON.setStyle({strokeColor:'#FF0'});
  

  //Add search box
  initSearchBox();
  
  placeholderID = 1;


  // function addWMS(url,name,maxZoom,xThenY){
  //   if(maxZoom === null || maxZoom === undefined  ){
  //     maxZoom = 19;
  //   }
  //   if(xThenY === null || xThenY === undefined  ){
  //     xThenY = false;
  //   }
  //     var imageMapType =  new google.maps.ImageMapType({
  //     getTileUrl: function(coord, zoom) {
  //         // "Wrap" x (logitude) at 180th meridian properly
  //         // NB: Don't touch coord.x because coord param is by reference, and changing its x property breakes something in Google's lib 
  //         var tilesPerGlobe = 1 << zoom;
  //         var x = coord.x % tilesPerGlobe;
  //         if (x < 0) {
  //             x = tilesPerGlobe+x;
  //         }
  //         // Wrap y (latitude) in a like manner if you want to enable vertical infinite scroll
  //         // return "https://api.mapbox.com/styles/v1/mapbox/satellite-v9/tiles/256/" + zoom + "/" + x + "/" + coord.y + "?access_token=pk.eyJ1IjoiaWhvdXNtYW4iLCJhIjoiY2ltcXQ0cnljMDBwNHZsbTQwYXRtb3FhYiJ9.Sql6G9QR_TQ-OaT5wT6f5Q"
  //         if(xThenY ){
  //             return url+ zoom + "/" + x + "/" + coord.y +".png?";
  //         }
  //         else{return url+ zoom + "/" + coord.y + "/" +x  +".png?";}//+ (new Date()).getTime();
          
  //     },
  //     tileSize: new google.maps.Size(256, 256),
  //     name: name,
  //     maxZoom: maxZoom
  
  // })

         
  //     map.mapTypes.set('Placeholder' + placeholderID.toString(),imageMapType )
  //     placeholderID  ++;
  // }
              

        

    //Set up cursor info in bottom bar
    function updateMousePositionAndZoom(cLng,cLat,zoom,elevation){
            // $('.legendDiv').css('bottom',$('.bottombar').height());
            
            $( "#current-mouse-position" ).html( 'Lng: ' +cLng + ', Lat: ' + cLat +', '+elevation+ ' Zoom: ' +zoom +', 1:'+zoomDict[zoom]);
    }
     
    //Set up elevation api
   
    // var elevator = new google.maps.ElevationService;
    var lastElevation = 0;
    var elevationCheckTime = 0;

    function getElevation(center){
      mouseLat = center.lat().toFixed(4).toString();
      mouseLng = center.lng().toFixed(4).toString();
      try{
        var elevation = ee.Image("USGS/SRTMGL1_003").reduceRegion(ee.Reducer.first(),ee.Geometry.Point([center.lng(), center.lat()])).get('elevation');
        elevation.evaluate(function(thisElevation){
          
          if(thisElevation !== null){
            var thisElevationFt = parseInt(thisElevation*3.28084);
            lastElevation = 'Elevation: '+thisElevation.toString()+'(m), '+thisElevationFt.toString()+'(ft),';
          }else{
            var thisElevationFt = 'NA';
            lastElevation = 'Elevation: NA,';
          };
          
          updateMousePositionAndZoom(mouseLng,mouseLat,zoom,lastElevation)
        })
      }catch(err){
        var thisElevationFt = 'NA';
        lastElevation = 'Elevation: NA,';
        updateMousePositionAndZoom(mouseLng,mouseLat,zoom,lastElevation)
      }
      
    
   
    }
    
    //Listen for mouse movement and update bottom bar
    map.addListener('mousemove',function(event){
      // console.log(event)
        // var x =event.clientX;
        // var y = event.clientY;
        var center =event.latLng;//point2LatLng(x,y);
        if(center !== null){
          var zoom = map.getZoom();
          // var center = event.latLng;
          mouseLat = center.lat().toFixed(4).toString();
          mouseLng = center.lng().toFixed(4).toString();
          var now = new Date().getTime()
          var dt = now - elevationCheckTime  ;
          
          if(dt > 1000){
            getElevation(center);
            elevationCheckTime = now;
          }
          else{updateMousePositionAndZoom(mouseLng,mouseLat,zoom,lastElevation)}
        }
        
        
    })
    function trackViewChange(){
      // console.log('idle')
      zoom = map.getZoom();
      var mapCenter = map.getCenter();
      var mapCenterLng = mapCenter.lng();
      var mapCenterLat = mapCenter.lat();
      urlParams.lng = mapCenterLng;urlParams.lat = mapCenterLat;urlParams.zoom= zoom;

      trackView();
      
      // console.log('bounds changed');
      var coords = Object.values(map.getBounds().toJSON());
      updateMousePositionAndZoom(mouseLng,mouseLat,zoom,lastElevation);
      try{
        eeBoundsPoly = ee.Geometry.Rectangle([coords[1],coords[0],coords[3],coords[2]],null,false);
      }
      catch(err){
        const x = 1;
      }
      if(typeof(Storage) == "undefined") return;
      localStorage.setItem(cachedSettingskey,JSON.stringify({center:{lat:mapCenterLat,lng:mapCenterLng},zoom:zoom}));
      updateViewList = true;
      
      // setTimeout(function(){updateViewList = true;},10)
    }
    //Listen for zoom change and update bottom bar
    
    google.maps.event.addListener(map,'maptypeid_changed',function(){
        console.log('map type id changed')
        urlParams.mapTypeId = map.mapTypeId;
        if(map.mapTypeId === 'satellite'){removeLabelOverlay()}
        else{addLabelOverlay()};
    })

    //Keep track of map bounds and zoom changes
    // google.maps.event.addListener(map,'zoom_changed',trackViewChange)
    google.maps.event.addListener(map,'idle',trackViewChange);

    //Specify proxy server location
    //Proxy server used for EE and GCS auth
    //RCR appspot proxy costs $$
	 // ee.initialize("https://rcr-ee-proxy-server2.appspot.com/api","https://earthengine.googleapis.com/map",function(){
    //Initialize GEE
    
    function loadGEELibraries(){
      function loadCDL(){
        loadJS("./js/changeDetectionLib.js", true,eeInitSuccessCallback)
      }
      loadJS("./js/getImagesLib.js", true,loadCDL)
    }
    function eeInitSuccessCallback(){
      //Set up the correct GEE run function
      geeAuthenticated = true;
        setTimeout(function() { 
        if(localStorage['showIntroModal-'+mode] === 'true'){
          $('#introModal').modal().show();
        }else{
          if(staticTemplates.loadingModal[mode]===undefined){
            if(mode==='MTBS'){
              showMessage('',staticTemplates.loadingModal['all']('mtbs-logo.png','Creating'));
            }else if(mode==='STORM' || mode === 'Bloom-Mapper' || mode === 'sequoia-view' || mode === 'TreeMap'){
              showMessage('',staticTemplates.loadingModal['all']('logos_usda-fs_bn-dk-01.svg','Creating'));
            }else if(mode==='lcms-dashboard'){
            showMessage('',staticTemplates.loadingModal['all']('lcms-icon.png','Loading','LCMS summary areas'));
          }else{
              showMessage('',staticTemplates.loadingModal['all']('lcms-icon.png','Creating'));
            }
            

          }else{
            showMessage('Loading',staticTemplates.loadingModal[mode]);
          }
          
        }

        $('#dontShowAgainCheckbox').change(function(){
          // console.log(this.checked);
          localStorage['showIntroModal-'+mode]  = !this.checked;
        });
        
      },1000);
      if(geeAuthenticated){
        $('#main-container').append(staticTemplates.introModal[mode]);
      }
      if(cachedStudyAreaName === null){
        $('#study-area-label').text(defaultStudyArea);
      }
      if(mode === 'Ancillary'){
        run = runAncillary;
      } else if( mode === 'LCMS'|| (mode === 'LCMS-pilot' && studyAreaDict[longStudyAreaName].isPilot == false)){
        run  = runGTAC;
      }else if( mode === 'LT'){
        run  = runLT;
      } else if(mode === 'MTBS'){
        run = runMTBS;
      }else if(mode === 'TEST'){
        run = runTest;
      }else if(mode === 'IDS'){
        run = runIDS;
      }else if(mode === 'geeViz'){
        run = runGeeViz;
      }else if( mode === 'LAMDA'){
      run  = runLAMDA;
      }else if( mode === 'STORM'){
      run  = runStorm;
      }else if(mode === 'lcms-base-learner'){
        run = runBaseLearner
      }else if( mode === 'TreeMap'){
        run  = runTreeMap;
      }else if(mode === 'lcms-dashboard'){
        run = runDashboard;
        map.setOptions({mapTypeControlOptions :{style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,position: google.maps.ControlPosition.TOP_CENTER,style: google.maps.MapTypeControlStyle.SMALL},
          streetViewControlOptions:{position: google.maps.ControlPosition.TOP_CENTER},
          scaleControlOptions:{position: google.maps.ControlPosition.TOP_CENTER},
          zoomControlOptions:{position: google.maps.ControlPosition.TOP_CENTER,style: google.maps.ZoomControlStyle.SMALL},
          draggableCursor:'pointer'});
        
      }else if(mode === 'Bloom-Mapper'){
        run = runAlgal;
      }else if(mode === 'sequoia-view'){
        run = runSequoia;
      }else if(studyAreaName === 'CONUS'){
        longStudyAreaName = cachedStudyAreaName;
        run = runCONUS;
      }else if(cachedStudyAreaName != null){
        longStudyAreaName = cachedStudyAreaName;
        resetStudyArea(cachedStudyAreaName)
      } 
      else{run = runUSFS}
      // run = function(){};
    //Bring in downloads if needed
    if(mode === 'LCMS'){ 
      setupDropdownTreeDownloads(studyAreaName);
      populateLCMSDownloads();
    }

    setGEERunID();
    
    setTimeout(function() { 
      var loaded = false;
      var loadTryCount = 0;
      var maxLoadTryCount = 2;
      var geeRunError;
      function loadRun(){
        try{
            run();
            loaded = true; 
          }catch(err){
            geeRunError = err;
            console.log(err);
            console.log('Failed to load GEE run function. Waiting 1 second   to retry');
            loadTryCount++;
            
          }

      }
      while(loaded===false && loadTryCount < maxLoadTryCount){
        loadRun();
        if(loaded===false){
          sleepFor(1000);
        }
      }
      
      setupAreaLayerSelection();
      // setupFSB();
      //Bring in plots of they're turned on
      if(plotsOn){
        addPlotCollapse();
        loadAllPlots();
      }
      // if(mode !== 'lcms-dashboard'){
        if(localStorage['showIntroModal-'+mode] !== 'true'){
          $('.modal').modal('hide');
          $('.modal-backdrop').remove();
        }else{
          $('#intro-modal-loading-div').hide();
          $('#summary-spinner').hide();
          
        };

        if(!loaded){
          showMessage('GEE Script Error',geeRunError);
        };
      // }
      if(mode === 'lcms-dashboard'){
        dashboardBoxSelect();
        startDashboardViewExtentSelect(); 
      }
      
      
      
      addLabelOverlay();
      
      if((urlParams.endYear-urlParams.startYear < 5) && mode === 'LCMS' ){//&&(urlParams.sankey==='true' || urlParams.beta ==='true') ){
      showMessage('No Transition Charting','The year range must be 5 years or more to perform transition charting')
    }
    }, 1500);
   
  	}
    function eeInitFailureCallback(failure){
      console.log(`Failed to authenticate to GEE: ${failure}`)
      if(mode === 'LCMS'){ 
        setupDropdownTreeDownloads(studyAreaName);
        populateLCMSDownloads();
      }
      
     
      ga('send', 'event', mode + '-gee-auth-error', 'failure', 'failure');
      showMessage('Map Loading Error',staticTemplates['authErrorMessage']);

      if(mode==='geeViz' && urlParams.accessToken !== null && urlParams.accessToken !== undefined && urlParams.accessToken !== 'null' && urlParams.accessToken !== 'None'){
        urlParams.geeAuthProxyURL = "https://rcr-ee-proxy-2.herokuapp.com";
        authProxyAPIURL = urlParams.geeAuthProxyURL;
        urlParams.projectID = undefined;
        projectID = urlParams.projectID;
        console.log(projectID)
        geeAPIURL = "https://earthengine.googleapis.com";
        if(initCount<5){
          showMessage('Map Loading Error',`<p style = 'margin-bottom:1rem;'>Switching to use standard credentials to access GEE. This may produce errors in accessing assets that are not shared publically.</p>${staticTemplates.loadingModal[mode]}<hr>Error Message: ${failure}`);
          
          setTimeout(()=>{eeInit()}, 1000);
        }
        
      }
  }
  var initCount = 1;
  function eeInit(){
    console.log(`Initializing GEE try number: ${initCount}`)
    
    ee.initialize(authProxyAPIURL,geeAPIURL,()=>{
      loadGEELibraries()},
    (failure)=>{eeInitFailureCallback(failure)},null,projectID);
   
    initCount++;
  }
  eeInit();

}
///////////////////////////////////////////////////////////////
//Wait to initialize
//Taken from: https://stackoverflow.com/questions/32808613/how-to-wait-till-the-google-maps-api-has-loaded-before-loading-a-google-maps-ove
var mapWaitCount = 0;
var mapWaitMax = 3;
//Handle failed attempts to load gmaps api
function map_load() { // if you need any param
    mapWaitCount++;
    // if api is loaded
    if(typeof google !== 'undefined') {
        initialize();
    }
    // try again if until maximum allowed attempt
    else if(mapWaitCount < mapWaitMax) {
        console.log('Waiting attempt #' + mapWaitCount); // just log
        setTimeout(function() { map_load(); }, 1000);
    }
    // if failed after maximum attempt, not mandatory
    else if(mapWaitCount >= mapWaitMax) {
        console.log('Failed to load google api');
    }
}
$(document).ready(map_load);

/////////////////////////////////////////////////////


function sortFunction(a, b) {
    if (a[0] === b[0]) {
        return 0;
    }
    else {
        return (a[0] < b[0]) ? -1 : 1;
    }
}
function downloadURI() {
	if(uri != null && uri != undefined){
	  var link = document.createElement("a");
	  link.download = uriName + '.png';
	  link.href = uri;
	  link.click();
	  // document.body.removeChild(link);
	    delete link;
}}

function clearUploadedAreas(){
	if(selectionTracker.uploadedLayerIndices === undefined || selectionTracker.uploadedLayerIndices === null){
		selectionTracker.uploadedLayerIndices = [];
	}
	// selectionTracker.uploadedLayerIndices.reverse().map(function(index){
 //    	map.overlayMapTypes.setAt(index,null)
 //    });
    turnOffUploadedLayers();
	$('#area-charting-shp-layer-list').empty();
}
function clearSelectedAreas(){
  

    
    selectionTracker.seletedFeatureLayerIndices.reverse().map(function(index){
    	map.overlayMapTypes.setAt(index,null)
    });
    setupAreaLayerSelection();
    updateSelectedAreasNameList();updateSelectedAreaArea();

    
}



function removeLastSelectArea(){
	selectionTracker.selectedFeatures = selectionTracker.selectedFeatures.slice(0,selectionTracker.selectedFeatures.length-1);
	updateSelectedAreasNameList();updateSelectedAreaArea();
	var lastIndex = selectionTracker.seletedFeatureLayerIndices[selectionTracker.seletedFeatureLayerIndices.length-1]
	map.overlayMapTypes.setAt(lastIndex,null);
	selectionTracker.seletedFeatureLayerIndices = selectionTracker.seletedFeatureLayerIndices.slice(0,selectionTracker.seletedFeatureLayerIndices.length-1)
	$('#area-charting-selected-layer-list li:first-child').remove();
}
function updateSelectedAreasNameList(){

	var selectedFeatures = ee.FeatureCollection(selectionTracker.selectedFeatures).flatten()
    
 //    $('#select-features-list-spinner').show();
   
  	// $('#selected-features-list').empty();
            
    var namesList = ee.List(ee.Dictionary(selectedFeatures.aggregate_histogram('name')).keys());
    
    namesList.evaluate(function(names,failure){
    	
        if(failure !== undefined){showMessage('Error',failure)}
        else{
        	selectionTracker.selectedNames = names;
            // names.map(function(nm){
                // $('#selected-features-list').append(`<ul>${nm}</ul>`);
            // })
           }
 //        $('#select-features-list-spinner').hide();
       })
}
function updateSelectedAreaArea(){
	var selectedFeatures = ee.FeatureCollection(selectionTracker.selectedFeatures).flatten()
    
    $('#select-features-area-spinner').show();
    
    var area =selectedFeatures.geometry().area(1000);
    area.evaluate(function(values,failure){
        if(failure !== undefined){showMessage('Error',failure)}
        else{
            $('#selected-features-area').html((values*0.0001).formatNumber() + ' hectares / '+(values*0.000247105).formatNumber() + ' acres');
                
                $('#select-features-area-spinner').hide();
            }
        })
            
    }


function setupAreaLayerSelection(){
	google.maps.event.clearListeners(map, 'click');
	selectionTracker.selectedFeatures = [];
	selectionTracker.selectedNames = [];
	selectionTracker.seletedFeatureLayerIndices = [];
	// turnOffSelectLayers();
	$('#selected-features-list').empty();
	$('#area-charting-selected-layer-list').empty();
	
	// Map2.addLayer(allSelectLayers,{layerType:'geeVectorImage'},'all select layers')
	    map.addListener('click',function(event){
	        if(getActiveTools().indexOf("Area Tools-Select an Area on map")>-1){
	            var coords = [event.latLng.lng(),event.latLng.lat()];
	            
	            Object.keys(selectedFeaturesJSON).map(function(k){
	            	if(layerObj[selectedFeaturesJSON[k].id].visible){
	            		var selectedFeaturesT = selectedFeaturesJSON[k].eeObject
	            			.filterBounds(ee.Geometry.Point(coords));
	            		
	            		var namesList = ee.List(selectedFeaturesT.aggregate_array('name'));

	            		namesList.evaluate(function(nms,failure){
	            			if(failure !== undefined){showMessage('Error',failure)}
        					else{
        						if(nms.length > 0){
        							console.log('names '+nms)
        							if(simplifyMaxError !== 0){
				            			selectedFeaturesT = ee.FeatureCollection(selectedFeaturesT.map(function(f){return ee.Feature(f).simplify(simplifyMaxError, crs)}));
				            		}
        							selectionTracker.selectedFeatures.push(selectedFeaturesT);

        						
        							var layerName = 'Selected '+selectedFeaturesJSON[k].layerName+' '+ nms.join('-').replaceAll('&','-');
        							if(simplifyMaxError !== 0){
        								layerName = 'Simplified ('+simplifyMaxError.toString()+'m)- '+layerName 
        							}
        							Map2.addLayer(selectedFeaturesT,{layerType:'geeVectorImage',isSelectedLayer :true},layerName,true,null,null,null,'area-charting-selected-layer-list');
        						}	updateSelectedAreasNameList();updateSelectedAreaArea();
        					}
	            		})	
	            	}
				})
	             
	        }   
	})
}

// function updateSelectedAreaArea(){
// 	var selectedFeatures = getSelectedGEEFeatureCollection();
// 	if(selectedFeatures === undefined){
// 		$('#selected-features-area').html('0 hectares / 0 acres');
// 	}else{
// 		$('#selected-features-area').html('Updating');
// 		$('#select-features-area-spinner').show();
// 		// selectedFeatures.evaluate(function(values){console.log(values)})
// 		// ee.Array(selectedFeatures.toList(10000,0).map(function(f){return ee.Feature(f).area()})).reduce(ee.Reducer.sum(),[0])
// 		ee.Feature(selectedFeatures.union().first()).area(1000)
// 		.evaluate(function(values,error){
// 			if(values === undefined){values = 0;console.log(error)};
//         	$('#selected-features-area').html((values*0.0001).formatNumber() + ' hectares / '+(values*0.000247105).formatNumber() + ' acres');
//         	$('#select-features-area-spinner').hide();
//     	})
// 	}
	
// }
function updateUserDefinedAreaArea(){
	var area = 0;
	Object.values(udpPolygonObj).map(function(poly){
		area += google.maps.geometry.spherical.computeArea(poly.getPath());
	});
	$('#user-defined-features-area').html((area*0.0001).formatNumber()+ ' hectares / '+(area*0.000247105).formatNumber()+ ' acres');
        	
	
}
function turnOffVectorLayers(){
	$(".vector-layer-checkbox").trigger("turnOffAllVectors");
}
function turnOffLayers(){
	$(".layer-checkbox").trigger("turnOffAll");
}

function turnOffSelectLayers(){
	$(".vector-layer-checkbox").trigger("turnOffAllSelectLayers");
}
function turnOnSelectedLayers(){
	$(".vector-layer-checkbox").trigger("turnOnAllSelectedLayers");
}
function turnOffUploadedLayers(){
	$(".vector-layer-checkbox").trigger("turnOffAllUploadedLayers");
}
function turnOnUploadedLayers(){
	$(".vector-layer-checkbox").trigger("turnOnAllUploadedLayers");
}
function turnOffSelectGeoJSON(){
	// Object.keys(selectedFeaturesJSON).map(function(k){
 //        selectedFeaturesJSON[k].geoJSON.forEach(function(f){selectedFeaturesJSON[k].geoJSON.setMap(null)});
 //    })
}
function turnOnSelectGeoJSON(){
	Object.keys(selectedFeaturesJSON).map(function(k){
        selectedFeaturesJSON[k].geoJSON.forEach(function(f){selectedFeaturesJSON[k].geoJSON.setMap(map)});
    })
}
function chartSelectedAreas(){
    
    // Map2.addLayer(selectedFeatures,{layerType :'geeVector'},'Selected Areas');
    // console.log(selectedFeatures);
    // console.log(ee.FeatureCollection(selectedFeatures).getInfo());
    var selectedFeatures  = ee.FeatureCollection(selectionTracker.selectedFeatures).flatten();

    $('#summary-spinner').slideDown();
    selectedFeatures.size().evaluate(function(size,failure){
    	if(failure !== undefined){showMessage('Error',failure)}
    	else if(size !== 0){
    		var title = $('#user-selected-area-name').val();
	    	if(title === ''){title = selectionTracker.selectedNames.join(' - ');}
	    	
	        makeAreaChart(selectedFeatures,title + ' ' + areaChartCollections[whichAreaChartCollection].label + ' Summary',true)
    	}else{
    		showMessage('Error!','Please select area to chart. Turn on any of the layers and click on polygons to select them.  Then hit the <kbd>Chart Selected Areas</kbd> button.');
    		$('#summary-spinner').slideUp();
    	}

    })
    	
    
    
    
}

function clearQueryGeoJSON(){
	queryGeoJSON.forEach(function(f){queryGeoJSON.remove(f)});
}
// Set to infoWindow or sidebarCollapse
var queryWindowMode = 'infoWindow';
queryWindowMode = 'sidepane';
var  getQueryImages = function(lng,lat){
	var lngLat = [lng, lat];
	$('.gm-ui-hover-effect').show();
	var outDict = {};
	$('#summary-spinner').slideDown();
	// $('#query-container').empty();
	
	
	var nameEnd = ' Queried Values for Lng '+lng.toFixed(3) + ' Lat ' + lat.toFixed(3);
	var queryContent =`<div>
							<h6 style = 'font-weight:bold;'>Queried values for<br>lng: ${lng.toFixed(3).toString()} lat: ${lat.toFixed(3).toString()}</h6>
							<li id = 'query-list-container'></li>
							
						</div>`;
	if(queryWindowMode === 'infoWindow'){
		$('#chart-collapse-label-chart-collapse-div').hide();
		$('#chart-collapse-div').empty();
		$('#legendDiv').css('max-width','');
		$('#legendDiv').css('max-height','60%');
		infowindow.setMap(null);
		infowindow.setPosition({lng:lng,lat:lat});
		infowindow.setOptions({maxWidth:350});
		infowindow.setContent(queryContent);
		infowindow.open(map);
	}else{
		infowindow.setContent('');
		infowindow.setMap(null);
		$('#legendDiv').css('max-width','');
		$('#legendDiv').css('max-height','80%');
		$('#chart-collapse-label-chart-collapse-div').show();
		$('#chart-collapse-div').empty();
	 	$('#chart-collapse-div').append(queryContent);
		
	}
	
	
	var idI = 1;
	function makeQueryTable(value,q,k){
		// console.log(value);
		var containerID = k + '-container-'+idI.toString();
		idI++;
		$('#query-list-container').append(`<table class="table table-hover bg-white">
												<tbody>
													<tr class = 'bg-black'><th></th></tr>
												</tbody>
											  </table>`);
		if(value === null || value === undefined){
			$('#query-list-container').append(`<table class="table table-hover bg-white">
												<tbody id = '${containerID}'></tbody>
											  </table>`);
			$('#'+containerID).append(`<tr><th>${q.name}</th><th>NULL</th></tr>`);
		}else if(q.type === 'geeImage'){
			
			$('#query-list-container').append(`<table class="table table-hover bg-white">
												<tbody id = '${containerID}'></tbody>
											  </table>`);
			let valueKeys = Object.keys(value);
			 if(valueKeys.length === 4 && 
				valueKeys.indexOf('viz-blue')>-1 && 
				valueKeys.indexOf('viz-green')>-1 && 
				valueKeys.indexOf('viz-red')>-1){
				let mainKey = valueKeys.filter(f=>f.indexOf('viz-')===-1)[0];
				var tValue = JSON.stringify(value[mainKey]);
				if(q.queryDict !== null && q.queryDict !== undefined){
					tValue = q.queryDict[parseInt(tValue)]
				}else{
					tValue = smartToFixed(tValue);
				  }
				
				$('#'+containerID).append(`<tr><th>${q.name}</th><td>${tValue}</td></tr>`);
			}else{	
				if(Object.keys(value).length > 1){
					$('#'+containerID).append(`<tr><th colspan=2 style="text-align:left;">${q.name}</th</tr>`);
				// $('#'+containerID).append(`<tr><th>Band Name</th><th>Value</th></tr>`);
				}
				
				Object.keys(value).map(function(kt){
					try{
					var v = value[kt];
					
					if(Array.isArray(v)){
						// Limit precision
						v = arraySmartToFixed(v);
						v = JSON.stringify(v);
						
					}else if(!Number.isInteger(v) && v !== null){
						v = smartToFixed(v);
					}else if(q.queryDict !== null && q.queryDict !== undefined){
								var t = q.queryDict[parseInt(v)];
								if(t !== undefined){v = t}
							}
					
					// var queryLine =  kt+ ': '+v + "<br>";
					if(Object.keys(value).length > 1){
						$('#'+containerID).append(`<tr><td>${kt}</td><td>${v}</td></tr>`);
					}else{
						$('#'+containerID).append(`<tr><th>${q.name}</th><td>${v}</td></tr>`);
					}
					}catch(err){
						console.log(`Click query error: ${err}`);
						$('#'+containerID).append(`<tr><td>${kt}</td><td>${JSON.stringify(v)}</td></tr>`);
					}
				});
				
			}	
		}else if(q.type === 'geeImageCollection'){
			// console.log(q)
			
			var yAxisLabels = {tickfont:{size:yLabelFontSize}};
		
			if(q.queryDict !== undefined && q.queryDict !== null){
				// Configure best way of showing given labels for queried pixel
				// This tries to avoid over-crowding of labels that happens when there are many long labels
				// within the queried range of values
				var yValues = value.table[0].y.filter(n=>n!==null);
				var yMin = yValues.min();
				var yMax = yValues.max();
				
				var allYValues = range(yMin,yMax+1);
				var allYLabels = allYValues.map(v=>q.queryDict[v]);
				var yLabelMaxLinesT = yLabelMaxLines;
				var brokenLabels;
				function breakLabels(){
					var totalLines = 0;
					brokenLabels = allYLabels.map(l=>{
						var chunks = l.slice(0,yLabelMaxLength).chunk(yLabelBreakLength).slice(0,yLabelMaxLinesT)
						totalLines = totalLines+ chunks.length;
						return chunks.join('<br>');
					})
					if(totalLines>yLabelMaxTotalLines && yLabelMaxLinesT > 1){
						yLabelMaxLinesT = yLabelMaxLinesT-1;
						breakLabels()
					}
				}
				breakLabels();
				yAxisLabels = {
					ticktext:brokenLabels,
					tickvals:allYValues,
					tickmode:"array",
					tickfont:{size:yLabelFontSize},
				  }
			}
			$('#query-list-container').append(`<ul class = 'bg-black dropdown-divider'></ul>`);
			$('#query-list-container').append(`<ul class = 'm-0 p-0 bg-white' id = '${containerID}'></ul>`);
			let chartWidthC= 600;
			if(queryWindowMode === 'infoWindow'){
				infowindow.setOptions({maxWidth:1200});
				infowindow.open(map);

			}else{
				$('#legendDiv').css('max-width','575px');
				chartWidthC = 550;
			}
	 		var plotLayout = {
	 			plot_bgcolor:'#D6D1CA',
	 			paper_bgcolor:"#D6D1CA",
	 			font: {
			    family: 'Roboto Condensed, sans-serif'
			  },
				 			legend: {
									"font":{"size":yLabelFontSize}},

	 			margin: {
				    l: 50,
				    r: 10,
				    b: 50,
				    t: 50,
				    pad: 0
				  },
	 			width:chartWidthC,
	 			height:400,
	 			title: {
    				text:q.name
    			},
    			xaxis: {
    				tickangle:45,
					tickformat: q.xTickDateFormat,
    				tickfont:{size:yLabelFontSize},
				    title: {
				      text: value.xLabel,
					  font:{
						size:12
					  }
				  }},
				  yaxis:yAxisLabels
	 		};
	 		var buttonOptions = {
				    toImageButtonOptions: {
				        filename: q.name + nameEnd ,
				        width: 900,
				        height: 600,
				        format: 'png'
				    }
				}
			// console.log(value.table);console.log(containerID)
			Plotly.newPlot(containerID, value.table,plotLayout,buttonOptions);

		}else if(q.type === 'geeVectorImage' || q.type === 'geeVector'){
			$('#query-list-container').append(`<table class="table table-hover bg-white">
												<tbody id = '${containerID}'></tbody>
											  </table>`);
			
				var infoKeys = Object.keys(value);
	            $('#'+containerID).append(`<tr><th>${q.name}</th><th>Attribute Table</th></tr>`);
	            // queryContent += `<tr><th>Attribute Name</th><th>Attribute Value</th></tr>`;
	            
	            infoKeys.map(function(name){
	                var valueT = value[name];
	                $('#'+containerID).append(`<tr><th>${name}</th><td>${valueT}</td></tr>`);
	            });	
			
            
		}
		
		





		if(keyI >= keyCount){
			map.setOptions({draggableCursor:'help'});
			map.setOptions({cursor:'help'});
			$('#summary-spinner').slideUp();
			// queryContent += `<tr class = 'bg-black'><th></th><td></td></tr>`;
			// queryContent +=`</tbody></table>`;
		  // infowindow.setContent(queryContent);
		  // infowindow.open(map);
		}
	
	}
	// queryContent += queryLine;
	// $('#query-container').append(queryLine);
	var keys = Object.keys(queryObj);
	var keysToShow = [];
	keys.map(function(k){
		var q = queryObj[k];
		if(q.visible){keysToShow.push(k);}
	})
	// console.log(keysToShow);
	var keyCount = keysToShow.length;
	var keyI = 0;
	
	if(keyCount === 0){
		$('#summary-spinner').slideUp();
		showMessage('No Layers to Query!','No visible layers to query. Please turn on any layers you would like to query');

	}
	clearQueryGeoJSON();
	keysToShow.map(function(k){
		var q = queryObj[k];
	

		if(q.visible){
			var clickPt = ee.Geometry.Point(lngLat);
			ga('send', 'event', mode, 'pixelQuery-'+q.type, q.name);
			if(q.type === 'geeImage'){
				var img = ee.Image(q.queryItem);
				img.reduceRegion(ee.Reducer.first(),clickPt,scale,crs,transform,true,1e13,4).evaluate(function(values){
					keyI++;
					
					makeQueryTable(values,q,k);
				})
			}else if(q.type === 'geeImageCollection'){
				var dateFormat = q.queryDateFormat;
				// console.log(`Query date format: ${dateFormat}`);
				if(dateFormat===null||dateFormat===undefined){dateFormat = defaultQueryDateFormat}
				q.xTickDateFormat = null;
				if(dateFormat.indexOf('HH:mm')>-1){
					q.xTickDateFormat = '%Y-%m-%d\n%H:%M';
				}
				var c = ee.ImageCollection(q.queryItem);
				var plotBounds = clickPt.buffer(plotRadius).bounds();
				function getCollectionValues(values){
					// console.log(values);
					keyI++;
					if(values.length >1){
						var header = values[0];
						values = values.slice(1);
						
						var hasTime = false;
						var timeColumnN = header.indexOf('time');
						var idColumnN = header.indexOf('id');
						

						var ids = arrayColumn(values,idColumnN).filter((v, i, a) => a.indexOf(v) === i);
						var expectedLength = ids.length;
						if(values.length > expectedLength){
							console.log('reducing number of inputs');
							values = values.slice(0,expectedLength);
						}
						
						hasTime =values[0][timeColumnN] !== null;

						var xColumn;
						var xLabel;
						if(hasTime){
							// xColumn = arrayColumn(values,timeColumnN).map(function(d){
							// 	// var date = new Date(d);
							// 	// var day = date.getDate().toString().padStart(2,'0');
							// 	// var month = (date.getMonth()+1).toString().padStart(2,'0');
							// 	// var year = date.getFullYear().toString();
							// 	return d;//year + '-' + month + '-' + day;
							// });
							xColumn = arrayColumn(values,timeColumnN);
							xLabel = 'Time';}
						else{xColumn = arrayColumn(values,idColumnN);xLabel = 'ID'}
						// var yColumns = ee.Image(c.first()).bandNames().getInfo();
						var yColumnNames = 	header.slice(4);
						yColumns = values.map(function(v){return v.slice(4)});
						var tableList = yColumnNames.map(function(c,i){
							return {
							  x: xColumn,
							  y: arrayColumn(yColumns,i).map(smartToFixed),
							  type: 'scatter',
							  name:c
							}
						})
						
						
						
						
						
						makeQueryTable({table:tableList,xLabel:xLabel},q,k);
					}else{console.log('no data');makeQueryTable(null,q,k);}
					
				}
				if(c.first().propertyNames().getInfo().indexOf('system:time_start')>-1){
					c = c.sort('system:time_start').map(function(img){return img.set('system:time_start',img.date().format(dateFormat))});
				};
				
				var getRegionCall = c.getRegion(plotBounds,scale,crs,transform);
				getRegionCall.evaluate(function(values,failure){
					// console.log('values');
					console.log(values);
					if(values !== undefined && values !== null){
						getCollectionValues(values);
					}else{
						keyI++;
						makeQueryTable(null,q,k);
					}
					if(failure !== undefined && failure !== null){showMessage('Error',failure)}
				});

				// var cT = c.filterBounds(clickPt);
				// var anyImages = cT.limit(1).size().getInfo()>0;
				// if(anyImages){
				// 	var dateIDs = ee.List(cT.toList(10000,0).map(img=>ee.List([ee.Image(img).id(),ee.Image(img).get('system:time_start')])));
				
				// 	var cTBns = cT.first().bandNames();
				// 	var totalBands = dateIDs.length().multiply(cTBns.length());
				// 	// console.log(totalBands.getInfo())
				// 	var table2 = cT.getRegion(plotBounds, scale, crs, transform);//.slice(0,totalBands);
				// 	console.log(table2.getInfo())
				// 	var table = cT.toBands().reduceRegion(ee.Reducer.firstNonNull(),clickPt,scale,crs,transform,true,1e13,4)
				// 	var allTables = ee.Dictionary({'table':table,'bandNames':cTBns,'dateIDs':dateIDs})
				// 	allTables.evaluate(function(values,failure){
						
				// 		keyI++;
				// 		if(values !== undefined && values !== null){
				// 			// console.log(values);
				// 			values['id_date_lookup'] = toDict(arrayColumn(values.dateIDs,0),arrayColumn(values.dateIDs,1));
				// 			values['ids'] = arrayColumn(values.dateIDs,0);
				// 			// console.log(values);

				// 			var header = ['id','date'];
				// 			values.bandNames.map(bandName=>{header.push(bandName)})
				// 			var out_table = [];
				// 			values.ids.map(id=>{
								
				// 				var date = values['id_date_lookup'][id];
				// 				var row = [id,date];
				// 				// console.log(date)
				// 				values.bandNames.map(bandName=>{
				// 					var v = values.table[id+'_'+bandName];
				// 					row.push(smartToFixed(v));
				// 				});
				// 				var allNull = row.slice(2).filter(n=>n!==null).length==0;
				// 				if(!allNull){
				// 					out_table.push(row);
				// 				}
				// 			});
				// 			// var yColumns = ee.Image(c.first()).bandNames().getInfo();
				// 			var yColumnNames = 	header.slice(2);
				// 			var xLabel = 'Time';
				// 			var xColumn = arrayColumn(out_table,1);
				// 			if(xColumn.indexOf(null)>-1){
				// 				xColumn = arrayColumn(out_table,0);
				// 				xLabel = 'ID';
				// 			}
				// 			// console.log(xColumn);
							
				// 			// console.log(yColumnNames);
				// 			// yColumns = out_table.map(function(v){return v.slice(4)});
				// 			var tableList = yColumnNames.map(function(c,i){
				// 				return {
				// 				x: xColumn,
				// 				y: arrayColumn(out_table,i+2),
				// 				type: 'scatter',
				// 				name:c
				// 				}
				// 			})
							
				// 			makeQueryTable({table:tableList,xLabel:xLabel},q,k);
				// 			// console.log(arrayColumn(out_table,2));
				// 			// console.log(out_table);
				// 			// console.log(lngLat);
				// 			// console.log(failure);
				// 		}else{
				// 			makeQueryTable(null,q,k);
				// 		}
					
				// 	if(failure !== undefined && failure !== null){showMessage('Error',failure);}
					
				// })
			// }else{keyI++;makeQueryTable(null,q,k);}
				// c.reduceRegion(ee.Reducer.first(),clickPt,null,'EPSG:5070',[30,0,-2361915.0,0,-30,3177735.0]).evaluate(function(value){keyI++;makeQueryTable(value,q,k);})
			}else if(q.type === 'geeVectorImage' || q.type === 'geeVector'){
				try{
					var features = q.queryItem.filterBounds(clickPt);
				}
				catch(err){
					// console.log(err);
					var features = ee.FeatureCollection([q.queryItem]).filterBounds(clickPt);
				}
				features.evaluate(function(values){
					// console.log(values);
					keyI++;
					
		            queryGeoJSON.addGeoJson(values);
           
					var features = values.features; 
					
					if(features.length === 0){
						makeQueryTable(null,q,k)
					}else{
						features.map(function(f){
      						makeQueryTable(f.properties,q,k)
      					})	
					}
      				
            		
        		})
			}
			
			// outDict[k] = value;

		}
	})
	
	
	
	
};
var fsb;
// var fieldName = 'NAME';
// var fsbPath = 'TIGER/2018/Counties';

// var fieldName = 'name';
// var fsbPath = 'USGS/WBD/2017/HUC10';

// var fieldName = 'FORESTNAME';
// var fsbPath = 'projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/FS_Boundaries';
function populateChartDropdown(id,collectionDict,whichChartCollectionVar){
	$('#'+id).empty();
	var keys = Object.keys(collectionDict);
	// console.log(keys)
	eval(whichChartCollectionVar+' = keys[0]');
	if(keys.length > 1){
	    Object.keys(collectionDict).map(function(k){
	    	addDropdownItem(id,collectionDict[k].label,k,collectionDict[k].tooltip);

	    });
	    $('#'+id+'-container').show();
	}else{$('#'+id+'-container').hide();}
	  
}
function populateAreaChartDropdown(){
  populateChartDropdown('area-collection-dropdown',areaChartCollections,'whichAreaChartCollection')
}
function populatePixelChartDropdown(){
  populateChartDropdown('pixel-collection-dropdown',pixelChartCollections,'whichPixelChartCollection')
}
// $('#area-collection-dropdown').change(function(){
//   console.log(whichAreaChartCollection);
//   // setupFSB();
// })
// var fieldName = 'PARKNAME';
// var fsbPath = 'projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/NPS_Boundaries';
function setupFSB(){
  $('#forestBoundaries').empty();
  $('#forestBoundaries').hide();
  // $('#summary-spinner').slideDown();
  $('#select-area-spinner').show();
  // $('#select-area-spinner').addClass(`fa-spin fa fa-spinner`);

  // var fsb = ee.FeatureCollection('projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/FS_Boundaries');
  // var fieldName = 'FORESTNAME';

  	var nfsFieldName = 'FORESTNAME';
	var nfs = ee.FeatureCollection('projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/FS_Boundaries');


	var npsFieldName = 'PARKNAME';
	var nps = ee.FeatureCollection('projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/NPS_Boundaries');

	nfs = nfs.map(function(f){return f.set('label',f.get(nfsFieldName))});


	nps = nps.map(function(f){return f.set('label',ee.String(f.get(npsFieldName)).cat(' National Park'))});

	fsb = nfs.merge(nps);
	fieldName = 'label';
 
	if(areaChartCollections[whichAreaChartCollection] !== undefined){
		fsb = fsb.filterBounds(areaChartCollections[whichAreaChartCollection].collection.geometry());

		  var names = ee.List(ee.Dictionary(fsb.aggregate_histogram(fieldName)).keys());
		  ee.Dictionary.fromLists(names, names).evaluate(function(d){
		  	// print('d');print(d);
		  	 var mySelect = $('#forestBoundaries');
			  var choose;
			  mySelect.append($('<option></option>').val(choose).html('Choose an area'))
			  $.each(d, function(val,text) {
			     
			      mySelect.append($('<option></option>').val(val).html(text)
			      );
			  });
			  // $('#select-area-spinner').removeClass('fa-spin fa fa-spinner');
			  $('#select-area-spinner').hide();
			  $('#forestBoundaries').show();
		  })
	}
  
 	
 
};

var udp;
var udpList = [];
var whichAreaDrawingMethod;

// function startAreaCharting(){
// 	console.log('starting area charting');
// 	// $('#areaChartingTabs').slideDown();
// 	$("#charting-parameters").slideDown();
// 	if(whichAreaDrawingMethod === '#user-defined'){console.log('starting user defined area charting');startUserDefinedAreaCharting();}
//   	else if(whichAreaDrawingMethod === '#shp-defined'){$('#areaUpload').slideDown();startShpDefinedCharting();}
//   	else if(whichAreaDrawingMethod === '#pre-defined'){$('#pre-defined').slideDown();}

// }
function areaChartingTabSelect(target){

	stopAreaCharting();
	stopCharting();
	// $('#charting-container').slideDown();
	// $("#charting-parameters").slideDown();
	
   
	whichAreaDrawingMethod = target;
  	if(target === '#user-defined'){startUserDefinedAreaCharting();}
  	else if(target === '#shp-defined'){startShpDefinedCharting();}
  	else if(target === '#pre-defined'){$('#pre-defined').slideDown();}
  	else if(target === '#user-selected'){
  		map.setOptions({draggableCursor:'pointer'});
 		map.setOptions({cursor:'pointer'});
  	}
  	// startAreaCharting();
}
// function listenForUserDefinedAreaCharting(){
//   $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
  	
//   var target = $(e.target).attr("href") // activated tab

//   console.log(target);
//   areaChartingTabSelect(target);
//   });
        
// }
// listenForUserDefinedAreaCharting();
function restartUserDefinedAreaCarting(e){
	// console.log(e);
	if(e === undefined || e.key == 'Delete'|| e.key == 'd'|| e.key == 'Backspace'){
		areaChartingTabSelect(whichAreaDrawingMethod);
		updateUserDefinedAreaArea();
		//startUserDefinedAreaCharting();
	}
	
}
function undoUserDefinedAreaCharting(e){
	// console.log(e);
	if(e === undefined || (e.key == 'z' && e.ctrlKey) ){
		try{
			udpPolygonObj[udpPolygonNumber].getPath().pop(1);
		}catch(err){
			udpPolygonNumber--;
			if(udpPolygonNumber < 1){udpPolygonNumber = 1;showMessage('Error!','No more vertices to undo')}
			udpPolygonObj[udpPolygonNumber].getPath().pop(1);
		}
		updateUserDefinedAreaArea();
        
        // udpList.pop(1);
      }
	
}
function startUserDefinedAreaCharting(){
	
	// udpList = [];



	map.setOptions({draggableCursor:'crosshair'});
    map.setOptions({disableDoubleClickZoom: true });
    google.maps.event.clearListeners(mapDiv, 'dblclick');
    google.maps.event.clearListeners(mapDiv, 'click');
    window.addEventListener("keydown", restartUserDefinedAreaCarting);
    window.addEventListener("keydown", undoUserDefinedAreaCharting);
   try{
   	udp.setMap(null);
   }catch(err){};
   udpPolygonObj[udpPolygonNumber]  = new google.maps.Polyline(udpOptions);
   // udp = new google.maps.Polyline(udpOptions);

   udpPolygonObj[udpPolygonNumber].setMap(map);
   google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "click", updateUserDefinedAreaArea);
   google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "mouseup", updateUserDefinedAreaArea);
   google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "dragend", updateUserDefinedAreaArea);
   
   mapHammer = new Hammer(document.getElementById('map'));
   // google.maps.event.addDomListener(mapDiv, 'click', function(event) {
        mapHammer.on("tap", function(event) {
        

        var path = udpPolygonObj[udpPolygonNumber].getPath();
        var x =event.center.x;
        var y = event.center.y;
        clickLngLat =point2LatLng(x,y);
        // udpList.push([clickLngLat.lng(),clickLngLat.lat()])
        path.push(clickLngLat);
        updateUserDefinedAreaArea();
    
    });
   
	mapHammer.on("doubletap", function() {
	// 	$('#summary-spinner').slideDown();
        var path = udpPolygonObj[udpPolygonNumber].getPath();
        udpPolygonObj[udpPolygonNumber].setMap(null);
        udpPolygonObj[udpPolygonNumber] = new google.maps.Polygon(udpOptions);
        udpPolygonObj[udpPolygonNumber].setPath(path);
        udpPolygonObj[udpPolygonNumber].setMap(map);
        google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "click", updateUserDefinedAreaArea);
   		google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "mouseup", updateUserDefinedAreaArea);
   		google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "dragend", updateUserDefinedAreaArea);
        udpPolygonNumber++
        udpPolygonObj[udpPolygonNumber]  = new google.maps.Polyline(udpOptions);
        udpPolygonObj[udpPolygonNumber].setMap(map);
        google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "click", updateUserDefinedAreaArea);
   		google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "mouseup", updateUserDefinedAreaArea);
   		google.maps.event.addListener(udpPolygonObj[udpPolygonNumber], "dragend", updateUserDefinedAreaArea);
   
        updateUserDefinedAreaArea();
 //        google.maps.event.clearListeners(mapDiv, 'dblclick');
 //    	google.maps.event.clearListeners(mapDiv, 'click');
 //    	map.setOptions({draggableCursor:'hand'});
 // 		map.setOptions({cursor:'hand'});
 // 		mapHammer.destroy()
 // 		// var geoJson = {'type':'Polygon',
	// 		// 	'geometry':[udpList]};
	// 	try{
	// 		var userArea = ee.FeatureCollection([ee.Feature(ee.Geometry.Polygon(udpList))]);


		
	// 	// $('#areaUpload').slideDown();
	  	
	//   	// $("#charting-parameters").slideDown();
	//   	var udpName = $('#user-defined-area-name').val();
	//   	if(udpName === ''){udpName = 'User Defined Area '+userDefinedI.toString() ;userDefinedI++;};
	//   	var addon = ' '+ areaChartCollections[whichAreaChartCollection].label+ ' Summary';
	//   	udpName +=  addon
	// 	// Map2.addLayer(userArea,{},udpName,false)
	// 	// console.log(userArea.getInfo());
	// 	makeAreaChart(userArea,udpName,true);
	// 	}
	// 	catch(err){areaChartingTabSelect(whichAreaDrawingMethod);showMessage('Error',err);}
		

	});
    // google.maps.event.addDomListener(mapDiv, 'dblclick', function() {
      
    // });

}
function chartUserDefinedArea(){
	try{
		var userArea = [];
		var anythingToChart = false;
		Object.values(udpPolygonObj).map(function(v){
			var coords = v.getPath().getArray();
			var f = [];
			coords.map(function(coord){f.push([coord.lng(),coord.lat()])});
		
			if(f.length > 2){userArea.push(ee.Feature(ee.Geometry.Polygon(f)));anythingToChart = true}
		});
		if(!anythingToChart){
			showMessage('Error!','Please draw polygons on map. Double-click to finish drawing polygon. Once all polygons have been drawn, click the <kbd>Chart Selected Areas</kbd> button to create chart.')
		}
		else{
			userArea = ee.FeatureCollection(userArea);
			var udpName = $('#user-defined-area-name').val();
		  	if(udpName === ''){udpName = 'User Defined Area '+userDefinedI.toString() ;userDefinedI++;};
		  	var addon = ' '+ areaChartCollections[whichAreaChartCollection].label+ ' Summary';
		  	udpName +=  addon
		  	$('#summary-spinner').slideDown();
			makeAreaChart(userArea,udpName,true);	
		}
		
		}
		catch(err){showMessage('Error',err);}
	

}
function chartChosenArea(){
  // $('#charting-container').slideDown();
    // $("#charting-parameters").slideDown();
    $('#summary-spinner').slideDown();
    try{
   	udp.setMap(null);
   }catch(err){};
    map.setOptions({draggableCursor:'progress'});
			map.setOptions({cursor:'progress'});
  // var fsb = ee.FeatureCollection('projects/USFS/LCMS-NFS/CONUS-Ancillary-Data/FS_Boundaries');
  // var fieldName = 'FORESTNAME';

 
  var chosenArea = $('#forestBoundaries').val();
  var chosenAreaName = chosenArea + ' '+ areaChartCollections[whichAreaChartCollection].label + ' Summary';
  var chosenAreaGeo = fsb.filter(ee.Filter.eq(fieldName,chosenArea));

  makeAreaChart(chosenAreaGeo,chosenAreaName);
  // console.log('Charting ' + chosenArea);
}
function convertToStack(areaChartCollection,xAxisProperty='year',dateFormat='YYYY'){
	if(xAxisProperty === 'year'){
		areaChartCollection = areaChartCollection.map(function(img){return img.set('year',img.date().format(dateFormat))});
		
	}
	var oBns = areaChartCollection.first().bandNames();
	var xProps = ee.List(areaChartCollection.toList(10000,0).map(img=>ee.Image(img).get(xAxisProperty)));
	var stack = areaChartCollection.toBands();
	var bns = stack.bandNames();
	var bnsOut = bns.map(bn=>{
		var i = ee.Number.parse(ee.String(bn).split('_').get(0));
		return ee.String(xProps.get(i)).cat('---').cat(ee.String(bn).split('_').slice(1,null).join('_'))
	})
	return stack.rename(bnsOut).set({'xProps':xProps,'bns':oBns});
}
function getAreaSummaryTable(areaChartCollection,area,xAxisProperty,multiplier,dateFormat,crs,transform,scale){
	if(xAxisProperty === null || xAxisProperty === undefined){xAxisProperty = 'year'};
	if(multiplier === null || multiplier === undefined){multiplier = 100};
	if(dateFormat === null || dateFormat === undefined){dateFormat = 'YYYY'};
	if(crs === null || crs === undefined){crs = 'EPSG:5070'};
	if(transform === null || transform === undefined){transform = null};
	if((scale === null || scale === undefined) && transform === null){scale = 30}
	// else{scale = null};
	
	// Newer stack-based method
	// var stack = convertToStack(areaChartCollection,xAxisProperty,dateFormat);
	
	
	// var t2 = stack.reduceRegion(ee.Reducer.fixedHistogram(0, 2, 2),area,scale,crs,transform,true,1e13,4);
	// // console.log(t2)
	// // console.log(ee.List(ee.Dictionary(t2).values()).get(0).getInfo())
	// var xProps = ee.List(stack.get('xProps'));
	// var bns = ee.List(stack.get('bns'));
	// var sum = ee.Array(t2.values().get(0)).slice(1,1,2).project([0]).reduce(ee.Reducer.sum(),[0]).get([0]);
	// // console.log(sum.getInfo());
	// var t2Formatted = xProps.map(xProp=>{
	// 	var row = bns.map(bn=>{
	// 		var a = t2.get(ee.String(xProp).cat('---').cat(bn));
	// 		a = ee.Array(a).slice(1,1,2).project([0]);
	// 		// var sum = ee.Number(a.reduce(ee.Reducer.sum(),[0]).get([0]));
	// 		a = ee.Number(a.toList().get(1));
	// 		var pct = a.divide(sum).multiply(multiplier);
	// 		return pct;
	// 	})
	// 	return ee.List([xProp]).cat(row);
	// });

	// return t2Formatted;

	// Older area charting method
	if(xAxisProperty === 'year'){
		areaChartCollection = areaChartCollection.map(function(img){return img.set('year',img.date().format(dateFormat))});
		
	}
	var bandNames = ee.Image(areaChartCollection.first()).bandNames();
	
	return areaChartCollection.toList(10000,0).map(function(img){
						img = ee.Image(img);
				    // img = ee.Image(img).clip(area);
				    var t = img.reduceRegion(ee.Reducer.fixedHistogram(0, 2, 2),area,scale,crs,transform,true,1e13,4);
				    var xAxisLabel = img.get(xAxisProperty);
				    // t = ee.Dictionary(t).toArray().slice(1,1,2).project([0]);
				    // var lossT = t.slice(0,2,null);
				    // var gainT = t.slice(0,0,2);
				    // var lossSum = lossT.reduce(ee.Reducer.sum(),[0]).get([0]);
				    // var gainSum = gainT.reduce(ee.Reducer.sum(),[0]).get([0]);
				    // var lossPct = ee.Number.parse(lossT.get([1]).divide(lossSum).multiply(100).format('%.2f'));
				    // var gainPct = ee.Number.parse(gainT.get([1]).divide(gainSum).multiply(100).format('%.2f'));
				    // return [year,lossPct,gainPct];//ee.List([lossSum]);
				    t = ee.Dictionary(t);
				    // var values = t.values();
				    // var keys = t.keys();
				    var sum;
				    values = bandNames.map(function(bn){
				      var a = t.get(bn);
				      a = ee.Array(a).slice(1,1,2).project([0]);
				      sum = ee.Number(a.reduce(ee.Reducer.sum(),[0]).get([0]));
				      a = ee.Number(a.toList().get(1));
				      var pct = a.divide(sum).multiply(multiplier);
				      return pct;
				    });
				    values = ee.List([xAxisLabel]).cat(values);
				    return values;
				})
}
var chartFormatDict = {'Percentage': {'mult':'NA','label':'% Area','places':2}, 'Acres': {'mult':0.222395,'label':'Acres','places':0}, 'Hectares': {'mult':0.09,'label':'ha','places':0}};

function expandChart(){
	console.log('expanding');
	$('#curve_chart_big').slideDown();
	$('#curve_chart_big_modal').modal();
	closeChart();
}
var currentChartID = 0;
function cancelMakeAreaChart(){
	currentChartID++;
	$('#summary-spinner').slideUp();
}
function makeAreaChart(area,name,userDefined){
	let maxError = 500;
	currentChartID++;
	var thisChartID = currentChartID;
	areaGeoJson = null;
	if(userDefined === undefined || userDefined === null){userDefined = false};
	
	areaChartingCount++;
	// closeChart();
	// document.getElementById('curve_chart_big').style.display = 'none';
	var fColor = randomColor().slice(1,7);
	
	
	// updateProgress(50);
	area = area.set('source','LCMS_data_explorer');0
	centerObject(area);
	area = area.geometry();

	if(areaChartCollections[whichAreaChartCollection].type === 'transition'){
		// console.log('here');console.log(area);
		$('#summary-spinner').slideDown();
		let startYear = areaChartCollections[whichAreaChartCollection].collection.sort('system:time_start').first().date().get('year').getInfo();
		let endYear = areaChartCollections[whichAreaChartCollection].collection.sort('system:time_start',false).first().date().get('year').getInfo();
		
		// let transitionPeriods = getSankeyPeriods(startYear,endYear,transitionChartYearInterval,yearBuffer=2);
		let transitionPeriods = getTransitionRowData();
		if(transitionPeriods!==null){

			
			let transitionClasses = getTransitionClasses(areaChartCollections[whichAreaChartCollection].collection,transitionPeriods,areaChartCollections[whichAreaChartCollection].values,areaChartCollections[whichAreaChartCollection].bandName);
			
			
			

			// var chartFormatDict = {'Percentage': {'mult':'NA','label':'% Area'}, 'Acres': {'mult':0.000247105,'label':' Acres'}, 'Hectares': {'mult':0.0001,'label':' Hectares'}};
			let bounds = area.bounds(maxError,crs).transform(crs,maxError);

			let img = ee.Image(transitionClasses).clip(area);
			
			let table = img.reduceRegion(ee.Reducer.fixedHistogram(0, 3, 3),bounds,scale,crs,transform,true,1e13,4);

			table.evaluate((t,failure)=>{
				if(failure !== undefined && currentChartID === thisChartID ){
					showMessage('Charting Error',failure);
				}else if(currentChartID === thisChartID){
					
				const total_area = Object.values(t)[0].slice(0,2).map(i=>i[1]).reduce((a, b) => a + b, 0);
					
				const sankey_dict = {source:[],target:[],value:[]};
				let sankeyPalette = [];
				let labels = [];
				let raw_labels = [];
				let label_code_dict = {};
				let label_code_i = 0;
				let years = [];
				let geojsonT = {};
				Object.keys(t).map(k=>years.push(k.split('---')[0].split('--')[0],k.split('---')[1].split('--')[0]));
				Object.keys(t).map(k=>raw_labels.push(k.split('---')[0].split('--')[1],k.split('---')[1].split('--')[1]));
				years = unique(years);
				raw_labels = unique(raw_labels).map(n=>parseInt(n)).sort((a, b)=>{return a - b;});

				years.map((yr)=>{
					
					areaChartCollections[whichAreaChartCollection].names.map((nm)=>{
					const outNm = yr+' '+nm;
					labels.push(outNm);
					label_code_dict[outNm] = label_code_i;
					label_code_i++;
					});
					areaChartCollections[whichAreaChartCollection].colors.map((nm)=>{sankeyPalette.push(nm)});
					
				});

				let mult;
				if(areaChartFormat === 'Percentage'){
					mult = 1/total_area*100;
					}else{
					mult = chartFormatDict[areaChartFormat].mult;
					}
				let dataMatrix = [];
				let yri = 1;
				years.slice(0,years.length-1).map(yr=>{
					let startYearPair = yr;
					let endYearPair = years[yri];
					yri++;
					let dataMatrixHeader = [''];
					raw_labels.map(l=>dataMatrixHeader.push(endYearPair+' '+areaChartCollections[whichAreaChartCollection].names[l-1]));
					dataMatrix.push(dataMatrixHeader);

					raw_labels.map(from=>{
						let row = [startYearPair+' '+areaChartCollections[whichAreaChartCollection].names[from-1]];
						raw_labels.map(to=>{
							let k = `${startYearPair}--${from}---${endYearPair}--${to}`;
							let v = t[k][1][1]*mult;
							row.push(v);
						});
						dataMatrix.push(row)

					});
					dataMatrix.push([''])
				});
				dataMatrix = dataMatrix.slice(0,dataMatrix.length-1);
				// console.log(dataMatrix);
				
				dataTable = dataMatrix;//[['From Class','To Class',chartFormatDict[areaChartFormat].label]];
					
					Object.keys(t).map((k)=>{
					const startRange = k.split('---')[0].split('--')[0];
					const endRange = k.split('---')[1].split('--')[0];

					const transitionFromClassI = parseInt(k.split('---')[0].split('--')[1])-1;
					const transitionToClassI = parseInt(k.split('---')[1].split('--')[1])-1;
					const transitionFromClassName = areaChartCollections[whichAreaChartCollection].names[transitionFromClassI];
					const transitionToClassName = areaChartCollections[whichAreaChartCollection].names[transitionToClassI];
					const v = t[k][1][1]*mult;
					
					const fromLabel = startRange+' '+transitionFromClassName;
					const toLabel = endRange+' '+transitionToClassName
					
					geojsonT[k]=v
					sankey_dict.source.push(label_code_dict[fromLabel]);
					sankey_dict.target.push(label_code_dict[toLabel]);
					sankey_dict.value.push(v);
					})
			
				function getSankeyPlot(canvasID,thickness=20,nodePad = 25,fontSize=10){
					sankey_dict.hovertemplate='%{value}'+chartFormatDict[areaChartFormat].label+' %{source.label}-%{target.label}<extra></extra>'

						var data = {
							type: "sankey",
							orientation: "h",
							node: {
							pad: nodePad,
							thickness: thickness,
							line: {
								color: "black",
								width: 0.5
							},
							label: labels,
							color: sankeyPalette,
							hovertemplate:'%{value}'+chartFormatDict[areaChartFormat].label+' %{label}<extra></extra>'
								},

							link: sankey_dict,

						}

						var data = [data]
						
						// let h = parseInt($('#chart-modal-body').width()*0.5);
						// let w = $('#chart-modal-body').width();
						// console.log(h);console.log(w);
						var layout = {
							title: name,
							font: {
							size: fontSize
							},
							autosize: true,
							margin: {
							l: 25,
							r: 25,
							b: 25,
							t: 50,
							pad: 4
							},
							paper_bgcolor: '#DDD',
							plot_bgcolor: '#DDD'
						}
						var config = {
							toImageButtonOptions: {
								format: 'png', // one of png, svg, jpeg, webp
								filename: name,
								width:1000,height:600
							},
							scrollZoom: true,
							displayModeBar: false
							};
						return Plotly.newPlot(canvasID, data, layout,config);
					}	

					
					configChartModal('Plotly');
					getSankeyPlot('chart-canvas',thickness=20,nodePad=25,fontSize=10);
					
					plotlyDownloadChartObject = getSankeyPlot('chart-download-canvas',thickness=40,nodePad=20,fontSize=20);
				
					$('#chart-download-dropdown').empty();
					$('#chart-modal-footer').append(`<div class="dropdown">
												<div class=" dropdown-toggle"  id="chartDownloadDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
													Download
												</div>
												<div id = 'chart-download-dropdown' class="dropdown-menu px-2" aria-labelledby="chartDownloadDropdown">
													<a class="dropdown-item" href="#" onclick = "downloadPlotly(plotlyDownloadChartObject,'${name}.png')">PNG</a>
													<a class="dropdown-item" href="#" onclick = "exportToCsv('${name}.csv', dataTable)">CSV</a>
												</div>
												</div>
												
												</div>
												<div class="dropdown">
												<div class=" dropdown-toggle"  id="chartTypeDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
													Chart Type
												</div>
												<div id = 'chart-type-dropdown' class="dropdown-menu px-2" aria-labelledby="chartTypeDropdown">
													<a class="dropdown-item" href="#" onclick = "toggleChartTable('chart');">Sankey Chart</a>
													<a class="dropdown-item" href="#" onclick = "toggleChartTable('table')">Table</a>
												</div>
												</div>
												
												`);
						
					
				var chartTableHTML = htmlTable(dataTable);
				$('#chart-table').append(chartTableHTML);
				toggleChartTable(localStorage.tableOrChart)
					area.evaluate(function(i,failure){
									areaGeoJson = i;
									areaGeoJson['properties'] = geojsonT;
									if(failure === undefined && areaGeoJson !== undefined && areaGeoJson !== null){
										$('#chart-download-dropdown').append(`<a class="dropdown-item" href="#" onclick = "exportJSON('${name}.geojson', areaGeoJson)">geoJSON</a>`);
								}else{
									showMessage('Error','Could not convert summary area to geoJSON '+failure)
								}
								});
					ga('send', 'event', mode, 'sankeyAreaChart', whichAreaChartCollection);
					$('#chart-modal').modal();
					
				}
				$('#summary-spinner').slideUp();
			});
		}else{$('#summary-spinner').slideUp();}
	}else{
		

		var areaChartCollection = areaChartCollections[whichAreaChartCollection].collection;
		var xAxisProperty = areaChartCollections[whichAreaChartCollection].xAxisProperty;
		var xAxisLabel = areaChartCollections[whichAreaChartCollection].xAxisLabel;
		var yAxisLabel = areaChartCollections[whichAreaChartCollection].yAxisLabel;
		var dateFormat = areaChartCollections[whichAreaChartCollection].dateFormat;
		if(xAxisProperty === null || xAxisProperty == undefined){xAxisProperty = 'year'};
		if(xAxisLabel === null || xAxisLabel == undefined){xAxisLabel = null};
		if(yAxisLabel === null || yAxisLabel == undefined){yAxisLabel = '% Area'};
		yAxisLabel = areaChartFormatDict[areaChartFormat].label;
		var totalArea = area.area(1000);
		if(['Acres','Hectares'].indexOf(areaChartFormat)>-1){
			multiplier =totalArea.multiply(areaChartFormatDict[areaChartFormat].mult);
		}
		else{
			multiplier = areaChartFormatDict[areaChartFormat].mult;
		}
		
		var bandNames = ee.Image(areaChartCollection.first()).bandNames().getInfo();
		bandNames = bandNames.map(function(bn){return bn.replaceAll('_',' ') + ' '+areaChartFormatDict[areaChartFormat].label});
		bandNames.unshift(xAxisProperty);
		


		var table = getAreaSummaryTable(areaChartCollection,area,xAxisProperty,multiplier,dateFormat,crs,transform,scale);
		// var bandNames = ee.Image(1).rename(['Year']).addBands(ee.Image(areaChartCollection.first())).bandNames().getInfo().map(function(i){return i.replaceAll('_',' ')});
		var iteration = 0;
		var maxIterations = 60;
		var success = false;
		var maxTime = 10000;
		var startTime = new Date();
		var tableT;
		function evalTable(){
			// console.log('Evaluating area chart tables');
			table.evaluate(function(tableT, failure){
				// print(iteration);
				// print(tableT);
				// print(failure);
				// print(areaChartingCount);
				var endTime = new Date();
				var dt = endTime-startTime;
				// console.log('dt: '+dt.toString())
				if(failure !== undefined && iteration < maxIterations && currentChartID === thisChartID && dt < maxTime){
					// $('#area-charting-message-box').empty();
					// $('#area-charting-message-box').html(failure	);
					evalTable()
				}
				else if(failure === undefined && currentChartID === thisChartID) {
					// tableT.unshift(['year','Loss %','Gain %']);
					tableT.unshift(bandNames)
					$('#summary-spinner').slideUp();
					var stackedAreaChart = areaChartCollections[whichAreaChartCollection].stacked;
					var steppedLine = areaChartCollections[whichAreaChartCollection].steppedLine;
					var colors = areaChartCollections[whichAreaChartCollection].colors;
					var chartType = areaChartCollections[whichAreaChartCollection].chartType
					var fieldsHidden = areaChartCollections[whichAreaChartCollection].fieldsHidden
					if(chartType === null || chartType === undefined){chartType = 'line'}
					ga('send', 'event', mode, 'areaChart', whichAreaChartCollection);
					addChartJS(tableT,name,chartType,stackedAreaChart,steppedLine,colors,xAxisLabel,yAxisLabel,fieldsHidden);
			
					// areaChartingTabSelect(whichAreaDrawingMethod);
					// map.setOptions({draggableCursor:'hand'});
					// map.setOptions({cursor:'hand'});
					// if(whichAreaDrawingMethod === '#user-defined'){
						area.evaluate(function(i,failure){
							areaGeoJson = i;
							areaGeoJson[name] = tableT;
							if(failure === undefined && areaGeoJson !== undefined && areaGeoJson !== null){
						    	$('#chart-download-dropdown').append(`<a class="dropdown-item" href="#" onclick = "exportJSON('${name}.geojson', areaGeoJson)">geoJSON</a>`);
						   }else{
						   	showMessage('Error','Could not convert summary area to geoJSON '+failure)
						   }
						});
					// }
					areaChartingCount--;
				}
				else if(failure !== undefined){
					$('#summary-spinner').slideUp();
					// map.setOptions({draggableCursor:'hand'});
					// map.setOptions({cursor:'hand'});
					
					// areaChartingTabSelect(whichAreaDrawingMethod);
					if(failure.indexOf('Dictionary.toArray: Unable to convert dictionary to array')>-1 || failure.indexOf("Array: Parameter 'values' is required.")> -1){
						failure = 'Most likely selected area does not overlap with selected LCMS study area<br>Please select area that overlaps with products<br>Raw Error Message:<br>'+failure;
					}
					showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error! Try again',failure)};
				iteration ++;
			

			
				
		});
			
		}
		evalTable();
	};
	


	
}
function fixGeoJSONZ(f){
	console.log('getting rid of z');
	f.features = f.features.map(function(f){
		if(f.geometry.type.indexOf('Multi') === -1){
			f.geometry.coordinates = f.geometry.coordinates.map(function(c){
	    															return c.map(function(i){
	    																return i.slice(0,2)})
																			});
		}else{
			f.geometry.coordinates = f.geometry.coordinates.map(function(c1){
	    															return c1.map(function(c2){
	    																return c2.map(function(i){
	    																	return i.slice(0,2)})
																				});
	    															});
		}
    
    return f;
  });
	console.log(f);

	return f
}
function runShpDefinedCharting(){
		clearUploadedAreas();
		if(jQuery('#areaUpload')[0].files.length > 0){
			try{udp.setMap(null);}
			catch(err){console.log(err)};
		
			$('#summary-spinner').slideDown();

			var name = jQuery('#areaUpload')[0].files[0].name.split('.')[0] 
			var addon = ' '+ areaChartCollections[whichAreaChartCollection].label + ' Summary';
			if(name.indexOf(addon) === -1){
				name += addon;
			}
			map.setOptions({draggableCursor:'progress'});
			map.setOptions({cursor:'progress'});
			
			convertToGeoJSON('areaUpload').done(function(convertedRaw){
				console.log('successfully converted to JSON');
				console.log(convertedRaw);
				console.log('compressing geoJSON')
				var converted = compressGeoJSON(convertedRaw,uploadReductionFactor);
				console.log(converted);
			//First try assuming the geoJSON has spatial info
			try{
				var area =ee.FeatureCollection(converted.features.map(function(t){return ee.Feature(t).dissolve(100,ee.Projection('EPSG:4326'))}));
				console.log('N features to summarize ');
				var nFeatures = area.size().getInfo()
				console.log(nFeatures);
				if(nFeatures == 0){
					showMessage('No Features Found','Found '+nFeatures.toString() + ' in provided file. Please select a file with features.');
					$('#summary-spinner').hide();
					return
				}
				} 
			//Fix it if not
			catch(err){
				err = err.toString();
				console.log('Error');console.log(err);
				if(err.indexOf('Error: Invalid GeoJSON geometry:') > -1){
					try{
						var area =ee.FeatureCollection(fixGeoJSONZ(converted).features.map(function(t){return ee.Feature(t).dissolve(100,ee.Projection('EPSG:4326'))}))	
						console.log('N features to summarize ');
						console.log(area.size().getInfo());
						}
					catch(err){
						err = err.toString();
						console.log(err)
						if(err.indexOf('413')>-1){
							showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!','Provided vector has too many vertices.<br>Try increasing the "Vertex Reduction Factor" slider by one and then rerunning.')
						}else{
							showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!',err)
						}
						$('#summary-spinner').hide();
						return;
						
					};
					}
				else{
					
					if(err.indexOf('413')>-1){
							showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!','Provided vector has too many vertices.<br>Try increasing the "Vertex Reduction Factor" slider by one and then rerunning.')
						}else{
							showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!',err)
						}
					$('#summary-spinner').hide();
					return;
					}
				};
				// var area  =ee.FeatureCollection(converted.features.map(function(t){return ee.Feature(t).dissolve(100,ee.Projection('EPSG:4326'))}));//.geometry()//.dissolve(1000,ee.Projection('EPSG:4326'));
				
				Map2.addLayer(area,{isUploadedLayer:true},name,true,null,null,name + ' for area summarizing','area-charting-shp-layer-list');
				
				makeAreaChart(area,name);
			})
		
	}else{showMessage('No Summary Area Selected','Please select a .zip shapefile or a .geojson file to summarize across')}
}
// new function based on runShpDefinedCharting that is for adding a user defined shp, geojson, etc without doing any charting -EH
function runShpDefinedAddLayer(){
	//clearUploadedAreas();
	if(jQuery('#areaUpload')[0].files.length > 0){
		//try{udp.setMap(null);}
		//catch(err){console.log(err)};
	
		//$('#summary-spinner').slideDown();

		var name = jQuery('#areaUpload')[0].files[0].name.split('.')[0] 
		//var addon = ' '+ areaChartCollections[whichAreaChartCollection].label + ' Summary';
		//if(name.indexOf(addon) === -1){
		//	name += addon;
		//}
		map.setOptions({draggableCursor:'progress'});
		map.setOptions({cursor:'progress'});
		
		convertToGeoJSON('areaUpload').done(function(convertedRaw){
			console.log('successfully converted to JSON');
			console.log(convertedRaw);
		
			//console.log('compressing geoJSON')
			//var converted = compressGeoJSON(convertedRaw,uploadReductionFactor);
			//console.log(converted);
		////////////First try assuming the geoJSON has spatial info/////////////
		// var area =ee.FeatureCollection(convertedRaw.features.map(function(t){return ee.Feature(t).dissolve(100,ee.Projection('EPSG:4326'))}));
		// 	console.log('N features to add to map ');
		// 	var nFeatures = area.size().getInfo()
		// 	console.log(nFeatures);
		// 	if(nFeatures == 0){
		// 		showMessage('No Features Found','Found '+nFeatures.toString() + ' in provided file. Please select a file with features.');
		// 		$('#summary-spinner').hide();
		// 		return
		// 	}
			/*	
		try{
			var area =ee.FeatureCollection(converted.features.map(function(t){return ee.Feature(t).dissolve(100,ee.Projection('EPSG:4326'))}));
			console.log('N features to add to map ');
			var nFeatures = area.size().getInfo()
			console.log(nFeatures);
			if(nFeatures == 0){
				showMessage('No Features Found','Found '+nFeatures.toString() + ' in provided file. Please select a file with features.');
				$('#summary-spinner').hide();
				return
			}
			} 
		//Fix it if not
		catch(err){
			err = err.toString();
			console.log('Error');console.log(err);
			if(err.indexOf('Error: Invalid GeoJSON geometry:') > -1){
				try{
					var area =ee.FeatureCollection(fixGeoJSONZ(converted).features.map(function(t){return ee.Feature(t).dissolve(100,ee.Projection('EPSG:4326'))}))	
					console.log('N features to summarize ');
					console.log(area.size().getInfo());
					}
				catch(err){
					err = err.toString();
					console.log(err)
					if(err.indexOf('413')>-1){
						showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!','Provided vector has too many vertices.<br>Try increasing the "Vertex Reduction Factor" slider by one and then rerunning.')
					}else{
						showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!',err)
					}
					$('#summary-spinner').hide();
					return;
					
				};
				}
			else{
				
				if(err.indexOf('413')>-1){
						showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!','Provided vector has too many vertices.<br>Try increasing the "Vertex Reduction Factor" slider by one and then rerunning.')
					}else{
						showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error Ingesting Study Area!',err)
					}
				$('#summary-spinner').hide();
				return;
				}*
			};*/
			if(convertedRaw.features.map(function(f){f.geometry.type == 'Point' || "MultiPoint"})){
				Map2.addLayer(convertedRaw.features.map(pts=>{return ee.Feature(pts).buffer(8)}),{layerType:'geeVectorImage'},name,true,null,null,name,'reference-layer-list')
				}
			else{
				Map2.addLayer(convertedRaw,{layerType:'geoJSONVector'},name,true,null,null,name,'reference-layer-list');
				}
		})		
}else{showMessage('No Summary Area Selected','Please select a .zip shapefile or a .geojson file to add to viewer')}
}
function startShpDefinedCharting(){
	// clearUploadedAreas();
	turnOnUploadedLayers();
	if(selectionTracker.uploadedLayerIndices === undefined || selectionTracker.uploadedLayerIndices === null){
		selectionTracker.uploadedLayerIndices = [];
	}
	
	// $('#areaUpload').change(function(){runShpDefinedCharting()})
};
function stopAreaCharting(){
	window.removeEventListener("keydown", restartUserDefinedAreaCarting);
    window.removeEventListener("keydown", undoUserDefinedAreaCharting);
	// console.log('stopping area charting');
	try{
   	Object.keys(udpPolygonObj).map(function(k){
        udpPolygonObj[k].setMap(null) ;       
    });
    udpPolygonObj = {};
    udpPolygonNumber = 1;
    updateUserDefinedAreaArea();
   }catch(err){};
 //   $('#areaChartingTabs').slideUp();
	$('#areaUpload').unbind('change')
	// $("#charting-parameters").slideUp();
	// $('#user-defined').slideUp();
	// $('#shp-defined').slideUp();
	// $('#pre-defined').slideUp();
	$('#summary-spinner').slideUp();
	// // $('#areaUpload').slideUp();
	// google.maps.event.clearListeners(mapDiv, 'dblclick');
 //    google.maps.event.clearListeners(mapDiv, 'click');
	// updateProgress(1);
	// closeChart();

};

function startQuery(){
	areaGeoJson = null;
	try{udp.setMap(null);}catch(err){console.log(err)};
	if(queryWindowMode !== 'infoWindow'){$('#chart-collapse-label-chart-collapse-div').show();}
	google.maps.event.clearListeners(mapDiv, 'dblclick');
    google.maps.event.clearListeners(mapDiv, 'click');
	map.setOptions({draggableCursor:'help'});
 	map.setOptions({cursor:'help'});
 	mapHammer = new Hammer(document.getElementById('map'));
   	mapHammer.on("doubletap", function(e) {
	// google.maps.event.addDomListener(mapDiv,"dblclick", function (e) {
			$('#summary-spinner').slideDown()
			map.setOptions({draggableCursor:'progress'});
			map.setOptions({cursor:'progress'});
			
			print('Map was double clicked');
			var x =e.center.x;//clientX;
        	var y = e.center.y;//console.log(x);
        	center =point2LatLng(x,y);

			

			var pt = ee.Geometry.Point([center.lng(),center.lat()]);
			var plotBounds = pt.buffer(plotRadius).bounds();
	   		addClickMarker(plotBounds)
	   		
			marker.setMap(map);

			getQueryImages(center.lng(),center.lat());

		})
   		// mapHammer.on("tap",function(e){
   		// // 	infowindow.setMap(null);
   		// 	clearQueryGeoJSON();
   		// })
   		// map.addListener("click", function(){infowindow.setMap(null);clearQueryGeoJSON();});
	// document.getElementById('query-container').style.display = 'block';
}
function stopQuery(){
	// print('stopping');
	try{
		mapHammer.destroy();
		map.setOptions({draggableCursor:'hand'});
		map.setOptions({cursor:'hand'});
		// $('#query-container').text('Double click on map to query values of displayed layers at a location');
		google.maps.event.clearListeners(mapDiv, 'dblclick');
		// google.maps.event.clearInstanceListeners(map);
		map.setOptions({cursor:'hand'});
		infowindow.setMap(null);
		marker.setMap(null);
		$('#legendDiv').css('max-width','');
		$('#chart-collapse-div').empty();
		$('#chart-collapse-label-chart-collapse-div').hide();
	}catch(err){};
	
	// document.getElementById('query-container').style.display = 'none';
}
function getImageCollectionValuesForCharting(pt){
	
	// var timeSeries = years.map(function(yr){
	// 	var imageT = l5s.filterDate(ee.Date.fromYMD(yr,1,1),ee.Date.fromYMD(yr,12,31)).median().set('system:time_start',ee.Date.fromYMD(yr,6,1).millis());
	// 	return imageT
	// })
	// timeSeries = ee.ImageCollection.fromImages(timeSeries);
	var icT = ee.ImageCollection(chartCollection.filterBounds(pt));
	var tryCount = 2;
	// print(icT.getRegion(pt.buffer(plotRadius),plotScale))
	try{var allValues = icT.getRegion(pt,scale,crs,transform).evaluate();
		print(allValues)
		return allValues}
	catch(err){showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Charting error',err.message)};//reRun();setTimeout(function(){icT.getRegion(pt.buffer(plotRadius),plotScale).getInfo();},5000)}
	

}
Date.prototype.yyyymmdd = function() {
  var mm = this.getMonth() + 1; // getMonth() is zero-based
  var dd = this.getDate();

  return [this.getFullYear(), !mm[1] && '0', mm, !dd[1] && '0', dd].join(''); // padding
};
function getDataTable(pt){
	// var chartScale = plotScale;
	// var chartPtSize = plotRadius;
	// addToMap(pt.buffer(chartPtSize));

	
	var values = getImageCollectionValuesForCharting(pt);
	globalChartValues	 = values;
	// var values = imageCollectionForCharting.getRegion(pt.buffer(chartPtSize),chartScale).getInfo();
	
	if(chartIncludeDate){var startColumn = 3}else{var startColumn = 4};
	var header = values[0].slice(startColumn);

	values = values.slice(1).map(function(v){return v.slice(startColumn)}).sort(sortFunction);




	print(values)
	if(chartIncludeDate){
	values = values.map(function(v){
			  var d = [new Date(v[0])];
			  v.slice(1).map(function(vt){d.push(vt)})
			  return d})
	}

	var forChart = [header];
	values.map(function(v){forChart.push(v)});
	
	return forChart
}

// function changeChartType(newType,showExpanded){
// 	if(!showExpanded){showExpanded = false};
// 	newType.checked = true;
// 	$(newType).checked = true;
// 	chartType = newType.value;
// 	uriName = mode+'_Product_Time_Series_for_lng_' +center.lng().toFixed(4).toString() + '_' + center.lat().toFixed(4).toString(); //+ ' Res: ' +plotScale.toString() + '(m) Radius: ' + plotRadius	.toString() + '(m)';
// 	csvName = uriName + '.csv'
// 	document.getElementById('curve_chart').style.display = 'none';
// 	// setTimeout(function(){updateProgress(80);},0);
// 	Chart(showExpanded);
// }

//////////////////////////////////////////////////////////////////
//ChartJS code
function downloadChartJS(chart,name){
	var link = document.createElement("a");
	link.download = name;
	link.href = chart.toBase64Image();
	link.click();
	delete link;
	ga('send', 'event', mode, getActiveTools()[0] +'-chartDownload', 'png');
}
function downloadPlotly(plotlyDownloadChartObject,name){

	Plotly.update('chart-download-canvas', null, {font: {size: 20},margin: {
		              l: 50,
		              r: 50,
		              b: 50,
		              t: 75,
		              pad: 4
		            }})
				plotlyDownloadChartObject.then((chart)=>{
					Plotly.toImage(chart,{width:2000,height:1000})
				         .then(
				             function(url){
				         	var link = document.createElement("a");
							link.download = name;
							link.href = url;
							link.click();
							delete link;
						}
				         )
				         ga('send', 'event', mode, getActiveTools()[0] +'-sankey-chartDownload', 'png');	
				})
	    		
	    	}
Chart.pluginService.register({
    beforeDraw: function (chart, easing) {
        if (chart.config.options.chartArea && chart.config.options.chartArea.backgroundColor) {
            var helpers = Chart.helpers;
            var ctx = chart.chart.ctx;
            var chartArea = chart.chartArea;

            ctx.save();
            ctx.fillStyle = chart.config.options.chartArea.backgroundColor;
            ctx.fillRect(chartArea.left-90, chartArea.top-40, chartArea.right - chartArea.left+190, chartArea.bottom - chartArea.top+350);
            ctx.restore();
        }
    }
});
var dataToTable = function (dataset) {
    var html = '<table>';
    html += '<thead><tr><th style="width:120px;">#</th>';
    
    var columnCount = 0;
    jQuery.each(dataset.datasets, function (idx, item) {
        html += '<th style="background-color:' + item.fillColor + ';">' + item.label + '</th>';
        columnCount += 1;
    });

    html += '</tr></thead>';

    jQuery.each(dataset.labels, function (idx, item) {
        html += '<tr><td>' + item + '</td>';
        for (i = 0; i < columnCount; i++) {
            html += '<td style="background-color:' + dataset.datasets[i].fillColor + ';">' + (dataset.datasets[i].data[idx] === '0' ? '-' : dataset.datasets[i].data[idx]) + '</td>';
        }
        html += '</tr>';
    });

    html += '</tr><tbody></table>';

    return html;
};
var chartJSChart,plotlyDownloadChartObject;
var chartType;
if(localStorage.tableOrChart === undefined || localStorage.tableOrChart === null){
	// if(mode === 'MTBS'){localStorage.tableOrChart = 'table'}
	// else{
		localStorage.tableOrChart = 'chart'
	// };
	
}

addModal('main-container','chart-modal');
//addModalTitle('chart-modal','test');$('#chart-modal-body').append('hello');$('#chart-modal').modal();
function configChartModal(chartPlatform='chartJS'){
	var h = $(document).height();
	var w = $(document).width();
	if(h/w > 1){
		canvasHeight = '90%';
		canvasWidth = '100%';
	}
	else{
		canvasHeight = '50%';
		canvasWidth = '100%';
	}
	
	// console.log(dt);
	// $('#'+modalID).html('');
	clearModal('chart-modal');
	// if(title !== null && title !== undefined){addModalTitle('chart-modal',title)}

	$('#chart-modal-body').append(`<div id = 'chart-modal-graph-table-container' class = 'flexcroll chart-table-graph-container'></div>`);
   
    if(chartPlatform === 'chartJS'){
		$('#chart-modal-graph-table-container').append(`<div id = 'chart-modal-graph-container' class = 'pb-2'>
	    													<canvas id="chart-canvas" width="${canvasWidth}" height = "${canvasHeight}" ></canvas>
	    												</div>`);
	}else{
		$('#chart-modal-graph-table-container').append(`<div id = 'chart-modal-graph-container' class = 'pb-2'>
	    													<div id="chart-canvas"></div>
	    													<div id="chart-download-canvas" style="display:none;"></div>
	    												</div>`);
	}
    
    $('#chart-modal-graph-table-container').append(`<div id="chart-table" style = 'display:none;' width="${canvasWidth}" height = "${canvasHeight}" ></div>`);
}
function addChartJS(dt,title,chartType,stacked,steppedLine,colors,xAxisLabel,yAxisLabel,fieldsHidden){
	var displayXAxis = true;var displayYAxis = true;
	if(fieldsHidden === null || fieldsHidden === undefined){fieldsHidden = null};
	if(xAxisLabel === null || xAxisLabel === undefined){xAxisLabel = '';displayXAxis = false};
	if(yAxisLabel === null || yAxisLabel === undefined){yAxisLabel = '';displayYAxis = false};
	if(colors === null || colors === undefined){colors = chartColors};
	if(chartType === null || chartType === undefined){chartType = 'line'};
	if(stacked === null || stacked === undefined){stacked = false};
	if(steppedLine === undefined || steppedLine == null){steppedLine = false};

	// console.log('starting convert to table')
	dataTable = dataTableNumbersToNames(dt);
	// console.log('finished convert to table')
	configChartModal();

    var data = dt.slice(1);
    // console.log(data);
    var firstColumn = arrayColumn(data,0);
    // console.log(firstColumn)
    var columnN = dt[1].length;
    var columns = range(1,columnN);
    // console.log('starting to convert to chart')
    var datasets = columns.map(function(i){
    	var fieldHidden = false;
    	if(fieldsHidden !== null){
    		fieldHidden = fieldsHidden[i-1]
    	}
        var col = arrayColumn(dt,i);
        var label = col[0];
        var data = col.slice(1);
        // console.log(data)
        data = data.map(function(i){
        			var out;
        			try{out = i.toFixed(6)}
        			catch(err){out = i;}
        			
        			return out
        			})
        // console.log(data)
        
        
        // var color = randomRGBColor();
        var color = colors[(i-1)%colors.length];
        if(color.indexOf('#') === -1){color = '#'+color};
        var out = {'label':label,
			        pointStyle: 'circle',
			        pointRadius:1,
			        'data':data,
			        'fill':false,
			        'borderColor':color,
			        'lineTension':0,
			        'borderWidth':2,
			        'steppedLine':steppedLine,
			        'showLine':true,
			        'spanGaps':true,
			        'hidden': fieldHidden
			    	};
		if(stacked){
			out['fill'] = true;
			out['backgroundColor'] = color
		}
        return out
        // console.log(label);console.log(data)
    });
    // console.log('finished to convert to chart')
    chartColorI = 0;
    // console.log(datasets)
    try{
    	chartJSChart.destroy();	
    }
    catch(err){};
    chartJSChart = new Chart($('#chart-canvas'),{
    	"type":chartType,
	    "data":{"labels":firstColumn,
	    "datasets":datasets},
	    "options":{
	    	 title: {
	            display: true,
	            position:'top',
	            text: title.replaceAll('_',' '),
	            // fontColor: '#000',
	            fontSize: 16
	        },
	        legend:{
	        	display:true,
	        	position:'bottom',
	        	
	        	labels : {
	        		boxWidth:5,
	        		usePointStyle: true,
            
        		}
	        },
	        chartArea: {
		        backgroundColor: '#DDD'
		    },
		    scales: {
				yAxes: [{ stacked: stacked ,scaleLabel:{display:displayYAxis,labelString:yAxisLabel}}],
				xAxes: [{ stacked: stacked ,scaleLabel:{display:displayXAxis,labelString:xAxisLabel},maxBarThickness: 100}]
			}
    	}	
	});

	
	    $('#chart-download-dropdown').empty();
	    $('#chart-modal-footer').append(`<div class="dropdown">
										  <div class=" dropdown-toggle"  id="chartDownloadDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										    Download
										  </div>
										  <div id = 'chart-download-dropdown' class="dropdown-menu px-2" aria-labelledby="chartDownloadDropdown">
										    <a class="dropdown-item" href="#" onclick = "downloadChartJS(chartJSChart,'${title}.png')">PNG</a>
										    <a class="dropdown-item" href="#" onclick = "exportToCsv('${title}.csv', dataTable)">CSV</a>
										  </div>
										</div>
										
										</div>
										<div class="dropdown">
										  <div class=" dropdown-toggle"  id="chartTypeDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										    Chart Type
										  </div>
										  <div id = 'chart-type-dropdown' class="dropdown-menu px-2" aria-labelledby="chartTypeDropdown">
										    <a class="dropdown-item" href="#" onclick = "toggleChartTable('chart');change('line',false,${steppedLine});">Line</a>
										    <a class="dropdown-item" href="#" onclick = "toggleChartTable('chart');change('line',true,${steppedLine});">Stacked Line</a>
										    <a class="dropdown-item" href="#" onclick = "toggleChartTable('chart');change('bar',false,${steppedLine});">Bar</a>
										    <a class="dropdown-item" href="#" onclick = "toggleChartTable('chart');change('bar',true,${steppedLine});">Stacked Bar</a>
										    <a class="dropdown-item" href="#" onclick = "toggleChartTable('table')">Table</a>
										  </div>
										</div>
										`);
	   	
	    var chartTableHTML = htmlTable(dataTable);
	    $('#chart-table').append(chartTableHTML);
	    toggleChartTable(localStorage.tableOrChart)
	    $('#chart-modal').modal();
}


function toggleChartTable(showWhich){
	if(showWhich === 'table'){
		$('#chart-modal-graph-container').hide();
		$('#chart-table').show();
		localStorage.tableOrChart = 'table';
	}else if(showWhich === 'chart'){
		$('#chart-modal-graph-container').show();
		$('#chart-table').hide();
		localStorage.tableOrChart = 'chart';
	}
	else{
		$('#chart-modal-graph-container').show();
		$('#chart-table').show();
		localStorage.tableOrChart = 'both';
	}
}
function change(newType,stacked,steppedLine) {
	if(stacked === undefined || stacked == null){stacked = false};
	if(steppedLine === undefined || steppedLine == null){steppedLine = false};
	

		var config = chartJSChart.config;
		chartJSChart.destroy();
		config.type = newType;

		var currentScales = config.options.scales;
		currentScales.xAxes[0].stacked = stacked;
		currentScales.yAxes[0].stacked = stacked;
		config.options.scales = currentScales;
		if(stacked){
			// config.options.scales = {
			// 	yAxes: [{ stacked: stacked }],//,ticks:{min:0,max:100}}],
			// 	xAxes: [{ stacked: stacked }]
			// }

			var datasets = config.data.datasets;
			// console.log(datasets);
			datasets = datasets.map(function(dataset){
				dataset['fill'] = true;
				dataset['backgroundColor'] = dataset['borderColor'];
				dataset['steppedLine'] = steppedLine;
				return dataset;
			})
			config.data.datasets = datasets;
		}else{
			// config.options.scales = {
			// 	yAxes: [{ stacked: stacked }],
			// 	xAxes: [{ stacked: stacked }]
			// }
			var datasets = config.data.datasets;
			// console.log(datasets);
			datasets = datasets.map(function(dataset){
				dataset['fill'] = false;
				dataset['steppedLine'] = false;
				// dataset['backgroundColor'] = null;
				return dataset;
			})
			config.data.datasets = datasets;
		};
		
		
		chartJSChart = new Chart($('#chart-canvas'), config);
	
};
var chartTableDict;
var testTable = JSON.parse('[["id","longitude","latitude","time","Raw NDVI","LANDTRENDR Fitted NDVI","Land Cover Class","Land Use Class","Loss Probability","Gain Probability"],["Landsat_Fmask_allL7_SR_medoid_1984_1986_190_250_1_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1985",-109.74183328494144,42.94571387213776,486432000000,0.6041558441558442,0.61475,0.699999988079071,0.30000001192092896,0,0],["Landsat_Fmask_allL7_SR_medoid_1985_1987_190_250_2_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1986",-109.74183328494144,42.94571387213776,517968000000,0.6490280777537797,0.6148,0.699999988079071,0.30000001192092896,0,0],["Landsat_Fmask_allL7_SR_medoid_1986_1988_190_250_3_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1987",-109.74183328494144,42.94571387213776,549504000000,0.6315240083507307,0.61485,0.699999988079071,0.30000001192092896,0,0],["Landsat_Fmask_allL7_SR_medoid_1987_1989_190_250_4_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1988",-109.74183328494144,42.94571387213776,581126400000,0.6315240083507307,0.6149,0.699999988079071,0.30000001192092896,0,0],["Landsat_Fmask_allL7_SR_medoid_1988_1990_190_250_5_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1989",-109.74183328494144,42.94571387213776,612662400000,0.6353887399463807,0.61495,0.699999988079071,0.30000001192092896,0,0],["Landsat_Fmask_allL7_SR_medoid_1989_1991_190_250_6_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1990",-109.74183328494144,42.94571387213776,644198400000,0.6176795580110498,0.615,0.699999988079071,0.30000001192092896,0,0],["Landsat_Fmask_allL7_SR_medoid_1990_1992_190_250_7_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1991",-109.74183328494144,42.94571387213776,675734400000,0.5684689236988377,0.61505,0.699999988079071,0.30000001192092896,0,0],["Landsat_Fmask_allL7_SR_medoid_1991_1993_190_250_8_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1992",-109.74183328494144,42.94571387213776,707356800000,0.5684689236988377,0.6151,0.699999988079071,0.30000001192092896,0.019999999552965164,0],["Landsat_Fmask_allL7_SR_medoid_1992_1994_190_250_9_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1993",-109.74183328494144,42.94571387213776,738892800000,0.6082029141932002,0.61515,0.699999988079071,0.30000001192092896,0.019999999552965164,0],["Landsat_Fmask_allL7_SR_medoid_1993_1995_190_250_10_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1994",-109.74183328494144,42.94571387213776,770428800000,0.5819209039548022,0.6152000000000001,0.699999988079071,0.30000001192092896,0.05000000074505806,0],["Landsat_Fmask_allL7_SR_medoid_1994_1996_190_250_11_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1995",-109.74183328494144,42.94571387213776,801964800000,0.6067796610169491,0.6152500000000001,0.699999988079071,0.30000001192092896,0.05000000074505806,0],["Landsat_Fmask_allL7_SR_medoid_1995_1997_190_250_12_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1996",-109.74183328494144,42.94571387213776,833587200000,0.6067796610169491,0.6153000000000001,0.699999988079071,0.30000001192092896,0.019999999552965164,0],["Landsat_Fmask_allL7_SR_medoid_1996_1998_190_250_13_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1997",-109.74183328494144,42.94571387213776,865123200000,0.6450617283950617,0.6153500000000001,0.699999988079071,0.30000001192092896,0.03999999910593033,0.009999999776482582],["Landsat_Fmask_allL7_SR_medoid_1997_1999_190_250_14_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1998",-109.74183328494144,42.94571387213776,896659200000,0.6450617283950617,0.6154000000000001,0.699999988079071,0.30000001192092896,0.019999999552965164,0],["Landsat_Fmask_allL7_SR_medoid_1998_2000_190_250_15_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-1999",-109.74183328494144,42.94571387213776,928195200000,0.6054347826086957,0.61545,0.699999988079071,0.30000001192092896,0.07999999821186066,0],["Landsat_Fmask_allL7_SR_medoid_1999_2001_190_250_16_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2000",-109.74183328494144,42.94571387213776,959817600000,0.6196961760083813,0.6155,0.699999988079071,0.30000001192092896,0.10999999940395355,0],["Landsat_Fmask_allL7_SR_medoid_2000_2002_190_250_17_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2001",-109.74183328494144,42.94571387213776,991353600000,0.625,0.61555,0.699999988079071,0.30000001192092896,0.20999999344348907,0],["Landsat_Fmask_allL7_SR_medoid_2001_2003_190_250_18_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2002",-109.74183328494144,42.94571387213776,1022889600000,0.625,0.6156,0.699999988079071,0.30000001192092896,0.3700000047683716,0],["Landsat_Fmask_allL7_SR_medoid_2002_2004_190_250_19_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2003",-109.74183328494144,42.94571387213776,1054425600000,0.5976331360946746,0.61565,0.699999988079071,0.30000001192092896,0.30000001192092896,0],["Landsat_Fmask_allL7_SR_medoid_2003_2005_190_250_20_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2004",-109.74183328494144,42.94571387213776,1086048000000,0.6184004181913225,0.6157,0.699999988079071,0.30000001192092896,0.23999999463558197,0],["Landsat_Fmask_allL7_SR_medoid_2004_2006_190_250_21_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2005",-109.74183328494144,42.94571387213776,1117584000000,0.6023643202579259,0.6050375,0.699999988079071,0.30000001192092896,0.3799999952316284,0],["Landsat_Fmask_allL7_SR_medoid_2005_2007_190_250_22_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2006",-109.74183328494144,42.94571387213776,1149120000000,0.5668202764976958,0.594375,0.699999988079071,0.30000001192092896,0.3100000023841858,0],["Landsat_Fmask_allL7_SR_medoid_2006_2008_190_250_23_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2007",-109.74183328494144,42.94571387213776,1180656000000,0.5428024868483978,0.5837125000000001,0.699999988079071,0.30000001192092896,0.7099999785423279,0],["Landsat_Fmask_allL7_SR_medoid_2007_2009_190_250_24_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2008",-109.74183328494144,42.94571387213776,1212278400000,0.6413103831204887,0.5730500000000001,0.699999988079071,0.30000001192092896,0.5099999904632568,0],["Landsat_Fmask_allL7_SR_medoid_2008_2010_190_250_25_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2009",-109.74183328494144,42.94571387213776,1243814400000,0.5547407019381875,0.5623875,0.699999988079071,0.30000001192092896,0.8799999952316284,0],["Landsat_Fmask_allL7_SR_medoid_2009_2011_190_250_26_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2010",-109.74183328494144,42.94571387213776,1275350400000,0.5532495903877663,0.551725,0.699999988079071,0.30000001192092896,0.550000011920929,0],["Landsat_Fmask_allL7_SR_medoid_2010_2012_190_250_27_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2011",-109.74183328494144,42.94571387213776,1306886400000,0.5532495903877663,0.5410625,0.699999988079071,0.30000001192092896,0.5199999809265137,0],["Landsat_Fmask_allL7_SR_medoid_2011_2013_190_250_28_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2012",-109.74183328494144,42.94571387213776,1338508800000,0.5121196493037647,0.5304,0.699999988079071,0.30000001192092896,0.7799999713897705,0.019999999552965164],["Landsat_Fmask_allL7_SR_medoid_2012_2014_190_250_29_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2013",-109.74183328494144,42.94571387213776,1370044800000,0.5759870200108166,0.5492714285714286,0.699999988079071,0.30000001192092896,0.10999999940395355,0.15000000596046448],["Landsat_Fmask_allL7_SR_medoid_2013_2015_190_250_30_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2014",-109.74183328494144,42.94571387213776,1401580800000,0.5555555555555556,0.5681428571428572,0.699999988079071,0.30000001192092896,0.17000000178813934,0.09000000357627869],["Landsat_Fmask_allL7_SR_medoid_2014_2016_190_250_31_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2015",-109.74183328494144,42.94571387213776,1433116800000,0.6195835678109173,0.5870142857142857,0.699999988079071,0.30000001192092896,0.07999999821186066,0.029999999329447746],["Landsat_Fmask_allL7_SR_medoid_2015_2017_190_250_32_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2016",-109.74183328494144,42.94571387213776,1464739200000,0.6360619469026548,0.6058857142857144,0.699999988079071,0.30000001192092896,0.14000000059604645,0.14000000059604645],["Landsat_Fmask_allL7_SR_medoid_2016_2018_190_250_33_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2017",-109.74183328494144,42.94571387213776,1496275200000,0.6152263374485596,0.6247571428571429,0.699999988079071,0.30000001192092896,0.05000000074505806,0.11999999731779099],["Landsat_Fmask_allL7_SR_medoid_2017_2019_190_250_34_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2018",-109.74183328494144,42.94571387213776,1527811200000,0.656484727090636,0.6436285714285715,0.699999988079071,0.30000001192092896,0.17000000178813934,0.1899999976158142],["Landsat_Fmask_allL7_SR_medoid_2018_2020_190_250_35_BT-LC-LU-DND-RNR-DNDSlow-DNDFast-2019",-109.74183328494144,42.94571387213776,1559347200000,0.6271186440677967,0.6625,0.699999988079071,0.30000001192092896,0.1599999964237213,0.3199999928474426]]')
function dataTableNumbersToNames(dataTable){
	// try{chartTableDict = chartCollection.get('chartTableDict').getInfo();}
	// catch(err){chartTableDict = null};
	if(pixelChartCollections[whichPixelChartCollection].chartTableDict !== null && pixelChartCollections[whichPixelChartCollection].chartTableDict !== undefined){
		chartTableDict = pixelChartCollections[whichPixelChartCollection].chartTableDict;
	}else{chartTableDict = null;}
	
	
	// console.log(chartTableDict)
	var header = dataTable[0];//.map(function(i){return i.toProperCase()});
	header[0] = header[0].toProperCase();
	var outTable = [header];
	dataTable.slice(1).map(function(r){
		var row = [];
		jQuery.each(r,function(i,value){
			
			var label = header[i];
			
			var tableValue;
			// console.log(chartTableDict[label]);console.log(value);
        	if(chartTableDict !== null && chartTableDict[label] !== null && chartTableDict[label] !== undefined && value !== undefined){
        		var keys = Object.keys(chartTableDict[label]);
        		var whichKey  = keys.filter(function(k){return Math.abs(k-value)< 0.0001});
        		// console.log(whichKey)
        		tableValue = chartTableDict[label][whichKey];
        		if(tableValue === null || tableValue === undefined){
        			try{value = value.formatNumber()}
					catch(err){};
					tableValue =value ;
        		}
        		// console.log(tableValue)
        		// console.log(keys);console.log(parseFloat(value).toString());
        		// console.log(keys.indexOf(parseFloat(value)));
        		// console.log(keys.indexOf(parseInt(value)))
        	// } && (chartTableDict[label][parseInt(value)] !== undefined || chartTableDict[label][parseFloat(value)] !== undefined)){
        		// console.log('yay');
        		// console.log(chartTableDict[label]);
        		// tableValue = chartTableDict[label][parseInt(value)];
        		// if(tableValue === undefined){
        		// 	tableValue = chartTableDict[label][parseFloat(value)];
        		// }
			}else{
				try{value = value.toFixed(6)}
				catch(err){};
				tableValue =value ;
			};
			if(tableValue === null){tableValue = ''}
			row.push(tableValue);
		});
		outTable.push(row);

	})
	return outTable;

}
function htmlTable(table){
	var html = '<div class = "flexcroll chart-table text-black"><table class="table  table-hover">';
    html += '<thead><tr>';
    var header = dataTable[0];
 

   header.map(function(label){
   		html += '<th  class = "chart-table-first-row bg-black">' + label + '</th>';
      
   });
   html += '</tr></thead>';

    table.slice(1).map(function(r){
		html += '<tr>';
		html += '<td class = "chart-table-first-column bg-black">' +  r[0] + '</td>';
		var columnI = 1;
		r.slice(1).map(function(value){
			html += '<td>' +  value + '</td>';
			columnI++;
		})	
		html += '</tr>';	
	});
	html += '</tr><tbody></table></div>';
   return html
}


var d =
[["time", "NDVI", "NDVI_LT_fitted", "Land Cover Class", "Land Use Class", "Loss Probability", "Gain Probability"]
,["1985", 0.6456953642384106, null, 0.6000000238418579, 0.30000001192092896, 0.019999999552965164, 0]
,["1986", 0.6456953642384106, 0.6573789473684211, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1987", 0.6456953642384106, 0.6598578947368421, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1988", 0.6934156378600823, 0.6623368421052632, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1989", 0.6934156378600823, 0.6648157894736842, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1990", 0.6934156378600823, 0.6672947368421053, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1991", null, 0.6697736842105264, null, null, null, null]
,["1992", null, 0.6722526315789473, null, null, null, null]
,["1993", null, 0.6747315789473685, null, null, null, null]
,["1994", 0.6439862542955326, 0.6772105263157895, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1995", 0.6439862542955326, 0.6796894736842105, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1996", 0.6439862542955326, 0.6821684210526316, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["1997", null, 0.6846473684210527, null, null, null, null]
,["1998", 0.7261107729762629, 0.6871263157894737, 0.6000000238418579, 0.30000001192092896, 0.1599999964237213, 0]
,["1999", 0.7261107729762629, 0.6896052631578948, 0.6000000238418579, 0.30000001192092896, 0.07999999821186066, 0]
,["2000", 0.6856763925729443, 0.6920842105263157, 0.6000000238418579, 0.30000001192092896, 0.09000000357627869, 0]
,["2001", 0.6856763925729443, 0.6945631578947369, 0.6000000238418579, 0.30000001192092896, 0.07000000029802322, 0]
,["2002", 0.7016229712858926, 0.6970421052631579, 0.6000000238418579, 0.30000001192092896, 0.05000000074505806, 0]
,["2003", 0.6268958543983821, 0.6995210526315789, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["2004", 0.766839378238342, 0.7020000000000001, 0.6000000238418579, 0.30000001192092896, 0, 0]
,["2005", 0.1652502360717658, 0.1652, 0.10000000149011612, 0.5, 0.75, 0]
,["2006", 0.37468030690537085, 0.21481538461538469, 0.10000000149011612, 0.6000000238418579, 0.07999999821186066, 0.07999999821186066]
,["2007", 0.37468030690537085, 0.26443076923076925, 0.4000000059604645, 0.6000000238418579, 0.09000000357627869, 0.05999999865889549]
,["2008", 0.44536882972823066, 0.3140461538461539, 0.10000000149011612, 0.5, 0.12999999523162842, 0.12999999523162842]
,["2009", 0.3751962323390895, 0.3636615384615385, 0.4000000059604645, 0.6000000238418579, 0.019999999552965164, 0.07999999821186066]
,["2010", 0.3751962323390895, 0.41327692307692304, 0.4000000059604645, 0.6000000238418579, 0, 0.10999999940395355]
,["2011", 0.4737417943107221, 0.4628923076923077, 0.4000000059604645, 0.6000000238418579, 0.05999999865889549, 0.07999999821186066]
,["2012", 0.5301810865191147, 0.5125076923076924, 0.4000000059604645, 0.6000000238418579, 0.12999999523162842, 0.10000000149011612]
,["2013", 0.5709251101321586, 0.562123076923077, 0.4000000059604645, 0.6000000238418579, 0.05000000074505806, 0.8399999737739563]
,["2014", 0.569609507640068, 0.6117384615384616, 0.4000000059604645, 0.30000001192092896, 0, 0.6499999761581421]
,["2015", 0.6380090497737556, 0.6613538461538462, 0.4000000059604645, 0.6000000238418579, 0.019999999552965164, 0.8700000047683716]
,["2016", 0.7084615384615386, 0.7109692307692308, 0.4000000059604645, 0.30000001192092896, 0, 0.75]
,["2017", 0.7672530446549392, 0.7605846153846154, 0.4000000059604645, 0.30000001192092896, 0, 0.6499999761581421]];
var d = [['time','landcover','burnSeverity','cdl','percent_tree_cover','impervious','IDS Mort Type','IDS Mort DCA','IDS Defol Type','IDS Defol DCA','IDS Mort Type Year','IDS Mort DCA Year','IDS Defol Type Year','IDS Defol DCA Year'],
[1984,,,,,,,,,,,,,],
[1985,,,,,,,,,,,,,],
[1986,,,,,,,,,,,,,],
[1987,,,,,,,,,,,,,],
[1988,,,,,,,,,,,,,],
[1989,,,,,,,,,,,,,],
[1990,,,,,,,,,,,,,],
[1991,,,,,,,,,,,,,],
[1992,43,,,,,,,,,,,,],
[1993,,,,,,,,,,,,,],
[1994,,,,,,,,,,,,,],
[1995,,,,,,,,,,,,,],
[1996,,,,,,,,,,,,,],
[1997,,,,,,,,,,,,,],
[1998,,,,,,,,,,,,,],
[1999,,,,,,,,,,,,,],
[2000,,,,,,,,,,,,,],
[2001,43,,,,0,,,,,,,,],
[2002,,,,,,,,,,,,,],
[2003,,,,,,,,,,,,,],
[2004,43,,,,,,,,,,,,],
[2005,,,,,,2,11,,,2005,2005,,],
[2005,,,,,,2,11,,,2005,2005,,],
[2006,43,,,,0,,,,,,,,],
[2007,,,,,,2,80,,,2007,2007,,],
[2007,,,,,,2,80,,,2007,2007,,],
[2008,43,,143,,,,,,,,,,],
[2009,,,143,,,,,,,,,,],
[2010,,,143,,,,,,,,,,],
[2011,43,,142,65,0,,,,,,,,],
[2012,,,143,,,,,,,,,,],
[2013,43,,143,,,,,,,,,,],
[2014,,,143,,,,,,,,,,],
[2015,,,141,,,,,,,,,,],
[2016,43,,143,,0,,,,,,,,],
[2017,,,143,,,,,,,,,,],
[2018,,,143,,,,,,,,,,]]
// addChartJS(d,'test1');

// var legends = chartCollection.get('legends').getInfo();
// if(legends !== null){makeLegend(legends)}


function addClickMarker(plotBounds){
	plotBounds.evaluate(function(plotBounds){
		var coords = plotBounds.coordinates[0];
	
	marker.setMap(null);
	marker=new google.maps.Rectangle({
			// center:{lat:center.lat(),lng:center.lng()},
			// radius:plotRadius,
			 bounds: {
            north: coords[0][1],
            south: coords[2][1],
            east: coords[1][0],
            west: coords[0][0],
          	},
			strokeColor: clickBoundsColor,
			fillOpacity:0
			});
	marker.setMap(map);
	})
	
}
function getEveryOther(values){
			return values.filter(i => values.indexOf(i)%2 ==0)
		}

function makeLegend(legendDicts){
	$( '#chart-modal-graph-container' ).append(`<div id = 'chart-legend' style = 'font-size:0.7em;' class = 'text-dark'></div>`);
	Object.keys(legendDicts).map(function(k){
		var title = k;
		try{
			var legendDict = JSON.parse(legendDicts[k]);
		}catch(err){
			var legendDict = legendDicts[k];
		}
		
		var legendID = title.replaceAll(' ','-')
		legendID = legendID.replaceAll(':','') + '-legend'
		$( '#chart-legend' ).append(`<div  class = 'px-2' id='${legendID}'>
										<div class = 'p-0'>${title}</div>
										<table  style = 'display:inline-block;vertical-align:top' class = 'table-bordered' id = '${legendID}-table'></table>
									</div>`)

		$('#'+legendID+ '-table').append(`<tr id = '${legendID}-table-names'></tr>`);
		$('#'+legendID+ '-table').append(`<tr id = '${legendID}-table-values'></tr>`);
		Object.keys(legendDict).map(function(k){
			$('#'+legendID+ '-table-names').append(`<td>${k}</td>`)
		})
		Object.keys(legendDict).map(function(k){
			$('#'+legendID+ '-table-values').append(`<td>${legendDict[k]}</td>`)
		})
	})
	

}


function startPixelChartCollection() {
	
	
	

	map.setOptions({draggableCursor:'help'});
	mapHammer = new Hammer(document.getElementById('map'));
   
    mapHammer.on("doubletap", function(event) {
    	chartCollection = pixelChartCollections[whichPixelChartCollection].collection;
    	
    	
    	// if(pixelChartCollections[whichPixelChartCollection].chartColors !== undefined && pixelChartCollections[whichPixelChartCollection].chartColors !== null){
    	// 	chartColors = pixelChartCollections[whichPixelChartCollection].chartColors;
    	// }
    	
    	areaGeoJson = null;
    	$('#summary-spinner').slideDown();
    	map.setOptions({draggableCursor:'progress'});
        var x =event.center.x;
        var y = event.center.y;
        center =point2LatLng(x,y);

		var pt = ee.Geometry.Point([center.lng(),center.lat()]);
		var plotBounds = pt.buffer(plotRadius).bounds();
   		addClickMarker(plotBounds)
		var icT = ee.ImageCollection(chartCollection.filterBounds(pt));
		
		uriName =  pixelChartCollections[whichPixelChartCollection].label.replaceAll(' ','_')+'_lng_' +center.lng().toFixed(4).toString() + '_lat_' + center.lat().toFixed(4).toString();
		chartTitle =  pixelChartCollections[whichPixelChartCollection].label+' (lng: ' +center.lng().toFixed(4).toString() + ' lat: ' + center.lat().toFixed(4).toString() + ')';
		
		csvName = uriName + '.csv'
		

		function chartValues(values){
			
			if(chartIncludeDate){var startColumn = 3}else{var startColumn = 4};
			// print('Extracted values:');
			// print(values);
			var header = values[0].slice(startColumn);
			values = values.slice(1).map(function(v){return v.slice(startColumn)}).sort(sortFunction);
			if(chartIncludeDate){
				values = values.map(function(v){
				  // var d = [new Date(v[0])];
				  // v.slice(1).map(function(vt){d.push(vt)})
				  var d = v[0];
				  
				  if(pixelChartCollections[whichPixelChartCollection].simplifyDate === false){
				  	var y = new Date(d).toGMTString();
				  }
				  else if(pixelChartCollections[whichPixelChartCollection].semiSimpleDate === true){
				  	var y = `${new Date(d).getFullYear()}-${new Date(d).getMonth()+1}-${new Date(d).getDate()}`
				  }else{
				  	var y = (new Date(d).getYear()+1900).toString();
				  }
				  // v = v.map(function(i){if(i === null){return i}else{return i.toFixed(3)}})
				  v[0] = y;
				  return v;
				})
			}
			// values = values.map(function(v)
			// 	{return v.map(function(i){
			// 	if(i === null || i === undefined){return i}
			// 	else if(i%1!==0){return parseFloat(i.toFixed(4))}
			// 	else if(i%1==0){return parseInt(i)}
			// 	else{return i}
			// 	})
			// });
			values.unshift(header);
			$('#summary-spinner').slideUp();
			map.setOptions({draggableCursor:'help'});
			ga('send', 'event', mode, 'pixelChart', whichPixelChartCollection);
			addChartJS(values,chartTitle,'line',false,false,pixelChartCollections[whichPixelChartCollection].chartColors,pixelChartCollections[whichPixelChartCollection].xAxisLabel,pixelChartCollections[whichPixelChartCollection].yAxisLabel,pixelChartCollections[whichPixelChartCollection].fieldsHidden);
		
			if(pixelChartCollections[whichPixelChartCollection].legends !== null && pixelChartCollections[whichPixelChartCollection].legends !== undefined){
				makeLegend(pixelChartCollections[whichPixelChartCollection].legends);
				toggleChartTable(localStorage.tableOrChart);
			}
			
   			}

		icT.getRegion(plotBounds,scale,crs,transform).evaluate(function(values,failure){
			$('#summary-spinner').slideUp();
			// if(values === undefined ||  values === null){
			// 	showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error! Try again','Error encountered while charting.<br>Most likely clicked outside study area data extent<br>Try charting an area within the selected study area');
			// }
			if(failure !== undefined && failure !== null){showMessage('<i class="text-dark text-uppercase fa fa-exclamation-triangle"></i> Error! Try again',failure)}
			if(values !== undefined && values !== null && values.length > 1){
				var expectedLength = icT.size().getInfo()+1
				if(values.length > expectedLength){
					console.log('reducing number of inputs');
					// console.log(expectedLength);
					// console.log(values);
					values = values.slice(0,expectedLength)
					// values = getEveryOther(values);
				}
				chartValues(values);
			}
			else{

				showMessage('Charting Error','Unknown Error<br>Try again');
			}
		})
	})

		
		
      }

// function closeChart(){
// 	updateProgress(1);
// 	$('#curve_chart').slideUp();

	
// }
// function closeBigChart(){
// 	$('#curve_chart_big').slideUp();
	
// }
function stopCharting(){
	// document.getElementById('charting-parameters').style.display = 'none';
	// $("#charting-parameters").slideUp();
	// $("#whichIndexForChartingRadio").slideUp();
	// marker.setMap(null);
	// google.maps.event.clearListeners(mapDiv, 'dblclick');

	// updateProgress(1);
	// closeChart();
	// closeBigChart();
	try{
		mapHammer.destroy();
	}catch(err){};
	try{
		map.setOptions({draggableCursor:'hand'});
		$('#summary-spinner').slideUp();
		infowindow.setMap(null);
		marker.setMap(null);
		
	}catch(err){}
	

}

function exportJSON(filename,json){
	json = JSON.stringify(json);

	var blob = new Blob([json], { type: "application/json" });
	var url  = URL.createObjectURL(blob);

	var link = document.createElement("a");
    if (link.download !== undefined) { // feature detection
        // Browsers that support HTML5 download attribute
        var url = URL.createObjectURL(blob);
        link.setAttribute("href", url);
        link.setAttribute("download", filename);
        link.style.visibility = 'hidden';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        ga('send', 'event', mode, getActiveTools()[0] +'-chartDownload', 'geoJSON');
    }
}
function exportToCsv(filename, rows) {
        var processRow = function (row) {
            var finalVal = '';
            for (var j = 0; j < row.length; j++) {
                var innerValue = row[j] === null || row[j] === undefined ? '' : row[j].toString();
                if (row[j] instanceof Date) {
                    innerValue = row[j].toLocaleString();
                };

                var result = innerValue.replace(/"/g, '""');
                if (result.search(/("|,|\n)/g) >= 0)
                    result = '"' + result + '"';
                if (j > 0)
                    finalVal += ',';
                finalVal += result;
            }
            return finalVal + '\n';
        };

        var csvFile = '';
        for (var i = 0; i < rows.length; i++) {
            csvFile += processRow(rows[i]);
        }

        var blob = new Blob([csvFile], { type: 'text/csv;charset=utf-8;' });
        if (navigator.msSaveBlob) { // IE 10+
            navigator.msSaveBlob(blob, filename);
        } else {
            var link = document.createElement("a");
            if (link.download !== undefined) { // feature detection
                // Browsers that support HTML5 download attribute
                var url = URL.createObjectURL(blob);
                link.setAttribute("href", url);
                link.setAttribute("download", filename);
                link.style.visibility = 'hidden';
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
                ga('send', 'event', mode, getActiveTools()[0] +'-chartDownload', 'csv');
            }
        }
    }
function stopAllTools(){
  stopArea();
  stopDistance();
  stopQuery();
  stopCharting();
  stopAreaCharting();
  stopCharting();
  clearQueryGeoJSON();
  // clearQueryGeoJSON();
  // clearSelectedAreas();
  turnOffUploadedLayers();

  turnOffSelectLayers();
  turnOffSelectGeoJSON();

  Object.keys(toolFunctions).map(function(t){Object.keys(toolFunctions[t]).map(function(tt){toolFunctions[t][tt]['state'] = false})});
  updateToolStatusBar();
  
}
var toolFunctions = {'measuring':
                    {'area':
                      {'on':'stopAllTools();startArea();showTip("AREA MEASURING",staticTemplates.areaTip);',
                      'off':'stopAllTools();',
                      'state':false,
                      'title': 'Measuring Tools-Area Measuring'
                      },
                    'distance':
                      {'on':'stopAllTools();startDistance();showTip("DISTANCE MEASURING",staticTemplates.distanceTip);',
                      'off':'stopAllTools()',
                      'state':false,
                      'title': 'Measuring Tools-Distance Measuring'
                      }
                    },
                  'pixel':
                    {
                      'query':{
                        'on':'stopAllTools();startQuery();showTip("QUERY VISIBLE MAP LAYERS",staticTemplates.queryTip);',
                        'off':'stopAllTools()',
                        'state':false,
                        'title': 'Pixel Tools-Query Visible Map Layers'
                      },
                      'chart':{
                        'on':'stopAllTools();startPixelChartCollection();showTip("QUERY "+mode+" TIME SERIES",staticTemplates.pixelChartTip);',
                        'off':'stopAllTools()',
                        'state':false,
                        'title': 'Pixel Tools-Query '+mode+' Time Series'
                      }
                    },
                    'area':
                    {
                      'userDefined':{
                        'on':'stopAllTools();areaChartingTabSelect("#user-defined");showTip("SUMMARIZE BY USER-DEFINED AREA",staticTemplates.userDefinedAreaChartTip);',
                        'off':'stopAllTools()',
                        'state':false,
                        'title': 'Area Tools-User Defined Area Tool'
                      },
                      'shpDefined':{
                        'on':'stopAllTools();areaChartingTabSelect("#shp-defined");showTip("SUMMARIZE BY UPLOADED AREA",staticTemplates.uploadAreaChartTip);',
                        'off':'stopAllTools()',
                        'state':false,
                        'title': 'Area Tools-Upload an Area'
                      },
                      'selectDropdown':{
                        'on':'stopAllTools();areaChartingTabSelect("#pre-defined");showTip("SUMMARIZE BY PRE-DEFINED AREA",staticTemplates.selectAreaDropdownChartTip);',
                        'off':'stopAllTools()',
                        'state':false,
                        'title': 'Area Tools-Select an Area from Dropdown'
                      },
                      'selectInteractive':{
                        'on':'stopAllTools();turnOffVectorLayers();turnOnSelectedLayers();turnOnSelectGeoJSON();areaChartingTabSelect("#user-selected");showTip("SUMMARIZE BY PRE-DEFINED AREA",staticTemplates.selectAreaInteractiveChartTip);',
                        'off':'stopAllTools();turnOffSelectLayers();',
                        'state':false,
                        'title': 'Area Tools-Select an Area on map'
                      },
                    }
                  }
function getActiveTools(){
  var out = [];

  Object.keys(toolFunctions).map(function(t){Object.keys(toolFunctions[t]).map(function(tt){
                                                                        var state = toolFunctions[t][tt]['state'];
                                                                        var title = toolFunctions[t][tt]['title'];
                                                                        if(state){
                                                                          out.push(title)
                                                                          
                                                                        } 
                                                                        
                                                                      })});
  return out;
}
function updateToolStatusBar(){
  var somethingShown = false;
  $('#current-tool-selection').empty();
  $('#current-tool-selection').append(`Active tools: `)
  Object.keys(toolFunctions).map(function(t){Object.keys(toolFunctions[t]).map(function(tt){
                                                                        var state = toolFunctions[t][tt]['state'];
                                                                        var title = toolFunctions[t][tt]['title'];
                                                                        if(state){
                                                                          $('#current-tool-selection').append(`${title}`)
                                                                          somethingShown = true
                                                                        } 
                                                                        
                                                                      })});
  if(!somethingShown){$('#current-tool-selection').append(`No active tools`)}
    else{
    
      ga('send', 'event','tool-active', mode, $('#current-tool-selection').html().split(': ')[1]);
    }
}
function toggleTool(tool){

  if(tool.state){
    eval(tool.off);

    // tool.state = false
  }else{
    eval(tool.on);
    tool.state = true
  };
  updateToolStatusBar();
}


updateToolStatusBar();
// var paragraphs = document.getElementsByClassName("collapse-title");
// for (var i = 0; i < paragraphs.length; i++) {
//   var paragraph = paragraphs.item(i);
//   paragraph.style.setProperty("font-size", "0.5em", null);
//   paragraph.style.setProperty("padding", "0.0em", null);
//   paragraph.style.setProperty("margin", "0.0em", null);
// }