# writerai-api

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install writerai-api
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import writer
from writer.models import operations, shared

s = writer.Writer()
   
req = operations.ContentDetectorAPIRequest(
    path_params=operations.ContentDetectorAPIPathParams(
        organization_id=548814,
    ),
    headers=operations.ContentDetectorAPIHeaders(
        authorization="deserunt",
    ),
    request=shared.ContentDetectorRequest(
        input="porro",
    ),
)
    
res = s.ai_content_detector.content_detector_api(req)

if res.content_detector_responses is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## SDK Available Operations


### ai_content_detector

* `content_detector_api` - Content detector api

### billing

* `get_subscription_details` - Get your organization subscription details

### co_write

* `generate_content` - Generate content using predefined templates
* `get_template_inputs` - Get a list of your existing CoWrite templates

### completions

* `completions` - Create completion for LLM model
* `customization_completions` - Create completion for LLM customization model

### content

* `content_check` - Check your content against your preset styleguide.
* `contetn_correct` - Apply the style guide suggestions directly to your content.

### download_the_customized_model

* `fetch_customized_model_file` - Download your fine-tuned model (available only for Palmyra Base and Palmyra Large)

### files

* `delete_file` - Delete file
* `files` - List files
* `get_file` - Get file
* `upload_file` - Upload file

### fine_tunes

* `create_model_customization` - Create model customization
* `customizations` - List model customizations
* `delete_model_customization` - Delete Model customization
* `get_model_customization` - Get model customization

### models

* `models` - List available LLM models

### snippet

* `delete_snippets` - Delete snippets
* `find_snippets` - Find snippets
* `update_snippets` - Update snippets

### styleguide

* `list_pages` - List your styleguide pages
* `page_details` - Page details

### terminology

* `add_terms` - Add terms
* `delete_terms` - Delete terms
* `find_terms` - Find terms
* `update_terms` - Update terms

### user

* `list_users` - List users
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
